/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: dosblc.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 14:14:08 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#include <stdio.h>
#include <ctype.h>
#include <sys/alloc.h>

#include "comdep.hxx"

struct dirent *readdir( DIR *pDir )
{
    int nOk;
    if ( pDir->p )
    {
        char *pBuf = new char[ strlen( pDir->p ) + 5 ];
        if ( pBuf )
        {
            // *.* dahinter, ggf mit "\\" abtrennen (falls nicht schon da)
            strcpy( pBuf, pDir->p );
            strcat( pBuf, "\\*.*" + ( *(pBuf + strlen( pBuf ) - 1 ) == '\\' ) );
            nOk = !findfirst( pBuf, &pDir->aDirEnt, 0xFF );
            pDir->p = NULL;
            delete pBuf;
        }
        else
            nOk = 0;
    }
    else
    {
        nOk = !findnext( &pDir->aDirEnt );
    }

    if ( nOk )
        for ( char *p = pDir->aDirEnt.d_name; *p; p++ )
            *p = tolower( *p );

    return nOk ? &pDir->aDirEnt : NULL;
}

int closedir( DIR *pDir )
{
    if ( pDir )
        delete pDir;
    return (pDir != NULL);
}

DIR *opendir( const char* pPfad )
{
    DIR *pDir = new DIR;
    if ( pDir )
        pDir->p = (char*) pPfad;
    return pDir;
}

char *volumeid( const char* pPfad )
{
    static char _far sVolume[260];
    struct dirent    aDirEnt;

#ifdef WIN
    // unter Windows koennen wir die Netzwerknamen auch leicht rausbekommen
    unsigned nLen = sizeof(sVolume);
    unsigned nErr = WNetGetConnection( (char*) pPfad, sVolume, &nLen );
    if ( nErr == WN_SUCCESS )
        return sVolume;
#endif

    char *pMask = new char[ strlen( pPfad ) + 5 ];

    // *.* dahinter, ggf mit "\\" abtrennen (falls nicht schon da)
    strcpy( pMask, pPfad );
    strcat( pMask, "\\*.*" + ( *(pPfad + strlen( pPfad ) - 1 ) == '\\' ) );
    if ( !findfirst( pMask, &aDirEnt, FA_LABEL ) )
    {
        delete pMask;
        strcpy( sVolume, aDirEnt.d_name );
        return sVolume;
    }
    else
    {
        delete pMask;
        return NULL;
    }
}

#include "dos.cxx"
