/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: txtq.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 10:56:01 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/


#pragma hdrstop

#include "cmdid.h"
#include "hintids.hxx"


#ifndef _LIST_HXX //autogen steht hier wg. "internal Microsoft error"
#include <tools/list.hxx>
#endif
#ifndef _SFXENUMITEM_HXX //autogen
#include <svtools/eitem.hxx>
#endif
#ifndef _SFXSTRITEM_HXX //autogen
#include <svtools/stritem.hxx>
#endif
#ifndef _SFXINTITEM_HXX //autogen
#include <svtools/intitem.hxx>
#endif
#ifndef _SFX_WHITER_HXX //autogen
#include <svtools/whiter.hxx>
#endif
#ifndef _SFXREQUEST_HXX //autogen
#include <sfx2/request.hxx>
#endif
#ifndef _SVX_LRSPITEM_HXX //autogen
#include <svx/lrspitem.hxx>
#endif
#ifndef _SVX_ULSPITEM_HXX //autogen
#include <svx/ulspitem.hxx>
#endif

#include "wrtsh.hxx"
#include "frmatr.hxx"
#include "pagedesc.hxx"
#include "fmtcol.hxx"
#include "charfmt.hxx"
#include "textsh.hxx"
#include "num.hxx"
#include "fldbas.hxx"

/*--------------------------------------------------

--------------------------------------------------*/

void SwTextShell::StateQuery( SfxItemSet& rSet )
{
	register SwWrtShell& rSh = GetShell();
	SfxWhichIter aIter( rSet );
	USHORT nWhich = aIter.FirstWhich();
	register BOOL bFlag;

	switch( nWhich )
	{
		case FN_GET_SELECTION:
		case FN_GET_SELECTED_TEXT:
			{
				String sSelection;
				rSh.GetSelectedText( sSelection,
					FN_GET_SELECTION == nWhich
							? GETSELTXT_PARABRK_KEEP
							: GETSELTXT_PARABRK_TO_BLANK );
				rSet.Put( SfxStringItem( nWhich, sSelection ) );
				nWhich = 0;
			}
			break;
		case FN_GETSET_LINE_TEXT:
		{
			rSh.StartAction();
			rSh.Push();
			rSh.LeftMargin(FALSE);
			rSh.RightMargin(TRUE);
			rSet.Put( SfxStringItem( nWhich, rSh.GetSelTxt() ) );
			rSh.Pop(FALSE);
			rSh.EndAction();
			nWhich = 0;
		}
		break;
		case FN_GET_CURSOR_XPOS:
			{
				const SvxLRSpaceItem& rLR = rSh.GetPageDesc( rSh.GetCurPageDesc()
													).GetMaster().GetLRSpace();
				long nRet = rSh.GetCharRect().Left() -
								(rLR.GetLeft() + DOCUMENTBORDER);
				rSet.Put( SfxInt32Item( nWhich, nRet ) );
				nWhich = 0;
			}
			break;
		case FN_GET_CURSOR_YPOS:
			{
				const SvxULSpaceItem& rUL = rSh.GetPageDesc( rSh.GetCurPageDesc()
													).GetMaster().GetULSpace();
				long nRet = rSh.GetCharRect().Top() -
								(rUL.GetUpper() + DOCUMENTBORDER);
				rSet.Put( SfxInt32Item( nWhich, nRet ) );
				nWhich = 0;
			}
			break;
		case FN_GET_PAGECOUNT:
			{
				rSet.Put( SfxUInt16Item( nWhich, rSh.GetPageCnt()));
				nWhich = 0;
			}
			break;
		case FN_GET_PAGENUMBER:
		case FN_GET_LOG_PAGENUMBER:
			{
				USHORT nPage, nLogPage;
				rSh.GetPageNum( nPage, nLogPage,
				   rSh.IsCrsrVisible(), FALSE);
				rSet.Put( SfxUInt16Item( nWhich,
					nWhich == FN_GET_PAGENUMBER ? nPage : nLogPage));
				nWhich = 0;
			}
			break;
		case FN_IS_START_OF_PARA:
			bFlag = rSh.IsSttOfPara();
			break;
		case FN_IS_START_OF_WORD:
			bFlag = rSh.IsSttWrd();
			break;
		case FN_IS_START_OF_DOC:
			bFlag = rSh.IsStartOfDoc();
			break;
		case FN_IS_END_OF_PARA:
			bFlag = rSh.IsEndOfPara();
			break;
		case FN_IS_END_OF_WORD:
			bFlag = rSh.IsEndWrd();
			break;
		case FN_IS_END_OF_DOC:
			bFlag = rSh.IsEndOfDoc();
			break;
		case FN_GET_NO_OF_SEL:
				rSet.Put( SfxUInt16Item( nWhich, rSh.GetCrsrCnt(FALSE) ) );
				nWhich = 0;
			break;
		case FN_GET_CUR_VALUE:
		{
				String aRet;
				if(rSh.HasSelection())
					aRet = rSh.GetSelTxt();
				else if( rSh.GetCurFld())
				{
					SwField* pFld = rSh.GetCurFld();
					aRet = pFld->GetCntnt();
				}
				else
				{
					rSh.Push();
					rSh.SelNearestWrd();
					aRet = rSh.GetSelTxt();
					rSh.Pop(FALSE);
				}
				rSet.Put(SfxStringItem(nWhich, aRet));
				nWhich = 0;
		}
		break;
		case FN_IS_START_OF_PAGE:
			break;
		case FN_IS_END_OF_PAGE:
			break;
		case FN_IS_START_OF_SENT:
			break;
		case FN_IS_END_OF_SENT:
		{
			bFlag = FALSE;

			if (!rSh.IsSttOfPara())
			{
				switch (rSh.GetChar(FALSE, -1))
				{
					case ';':
					case '.':
					case ':':
					case '!':
					case '?':
						bFlag = TRUE;
						break;
				}
			}
		}
		break;
		case FN_IS_END_OF_LINE:
		{
			BOOL bLocked = rSh.IsViewLocked();
			if (!bLocked)
				rSh.LockView(TRUE);
			Point aStartPos = rSh.GetCrsrDocPos();
			rSh.Push();
			rSh.RightMargin(FALSE);
			bFlag = aStartPos == rSh.GetCrsrDocPos();
			rSh.Pop(FALSE);
			if (!bLocked)
				rSh.LockView(FALSE);
		}
		break;
		case FN_GET_CHAR_STYLE_COUNT:
		{
			rSet.Put( SfxUInt16Item( nWhich,
									rSh.GetCharFmtCount() - 1 ));
			nWhich = 0;
		}
		break;
		case FN_GET_PARA_STYLE_COUNT:
		{
			rSet.Put( SfxUInt16Item( nWhich,
									rSh.GetTxtFmtCollCount() - 1 ));
			nWhich = 0;
		}
		break;
		default:
			ASSERT(FALSE, falscher Dispatcher);
			return;
	}
	if( nWhich )
		rSet.Put( SfxBoolItem( nWhich, bFlag ) );
}

/*--------------------------------------------------

--------------------------------------------------*/

void SwTextShell::ExecQuery(SfxRequest &rReq)
{
	register SwWrtShell& rSh = GetShell();
	const SfxItemSet* pArgs = rReq.GetArgs();
	USHORT nSlot = rReq.GetSlot();

	switch( nSlot )
	{
		case FN_GET_CHAR_STYLE_AT:
		{
			if(pArgs)
			{
				String aStyle = aEmptyStr;

				const USHORT nIndex = ((SfxUInt16Item &)pArgs->
												Get(nSlot)).GetValue();
				if( nIndex <  rSh.GetCharFmtCount() - 1 )
					aStyle = rSh.GetCharFmt(nIndex+1).GetName();
				rReq.SetReturnValue(SfxStringItem(nSlot, aStyle));
			}
		}
		break;
		case FN_GET_PARA_STYLE_AT:
		{
			if(pArgs)
			{
				String aStyle = aEmptyStr;
				const USHORT nIndex = ((SfxUInt16Item &)pArgs->
												Get(nSlot)).GetValue();
				USHORT nCount = rSh.GetTxtFmtCollCount() - 1;
				if(nIndex < nCount)
					aStyle = rSh.GetTxtFmtColl(nIndex + 1).GetName();
				rReq.SetReturnValue(SfxStringItem(nSlot, aStyle));
			}
		}
		break;
		case FN_GETSET_LINE_TEXT:
		if(pArgs)
		{
			const String sArg = ((SfxStringItem &)pArgs->
												Get(nSlot)).GetValue();
			rSh.StartAction();
			rSh.Push();
			rSh.LeftMargin(FALSE);
			rSh.RightMargin(TRUE);
			rSh.Insert(sArg);
			rSh.Pop(FALSE);
			rSh.EndAction();
		}
		break;
		case FN_GET_LINE_COUNT:
		{
			BOOL bActPos = FALSE;
			if(pArgs && SFX_ITEM_SET == pArgs->GetItemState(FN_GET_LINE_COUNT))
				bActPos = ((const SfxBoolItem&)pArgs->Get(FN_GET_LINE_COUNT)).GetValue();
			rReq.SetReturnValue(SfxUInt16Item(FN_GET_LINE_COUNT, rSh.GetLineCount(bActPos)));
		}
		break;
		default:
			ASSERT(FALSE, falscher Dispatcher);
			return;
	}
}


