/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: tempauto.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 02:19:52 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#ifndef _TEMPAUTO_HXX
#define _TEMPAUTO_HXX

#ifndef _SVARRAY_HXX //autogen
#include <svtools/svarray.hxx>
#endif

#ifndef _STRING_HXX //autogen
#include <tools/string.hxx>
#endif

/*************************************************************************
 * In der folgenden Struktur werden Paare von Strings fuer die temporaere
 * Autokorrektur gehalten:
 * in aWrong das als falsch erkannte Wort,
 * in aCorrect die richtige Schreibweise.
 *************************************************************************/

class SwCorrection
{
	String aWrong;
	String aCorrect;

	StringCompare _Compare( const SwCorrection& rSwCorrection ) const;
public:
	SwCorrection( const String& rStr ) : aWrong( rStr )	{}

		  String &Correct()				{ return aCorrect; }
	const String &Correct() const 		{ return aCorrect; }

	BOOL Identical() const 				{ return aWrong == aCorrect; }

	BOOL operator<( const SwCorrection& rSwCorrection ) const
		{ return COMPARE_GREATER == _Compare( rSwCorrection ); }
	BOOL operator==( const SwCorrection& rSwCorrection ) const
		{ return COMPARE_EQUAL == _Compare( rSwCorrection ); }
};

typedef SwCorrection* SwCorrectionPtr;
SV_DECL_PTRARR_SORT_DEL(SwTempList, SwCorrectionPtr, 0, 10)

/*************************************************************************
 * SwTempAuto
 * enthaelt als member eine Liste von Ersetzungspaaren (SwCorrection).
 * Gefuellt wird diese Liste mit den Worten, die ueber die Rechtschreib-
 * korrektur ersetzt werden, via Dialog (splwrp.cxx) oder rechte Maustaste
 * beim OnlineSpelling (olmenu.cxx).
 * Ausgewertet wird die Liste bei eingeschalteter Autokorrektur nach Eingabe
 * eines Blanks (edws.cxx) und ein wiederholter Schreibfehler wird sofort
 * korrigiert.
 * Die Liste wird bei Bedarf (beim ersten Ersetzen) angelegt und erst beim
 * Programmende geloescht (txtinit.cxx).
 *************************************************************************/

class SwTempAuto
{
	SwTempList aList;
public:
	const SwCorrection* Replaceable( const String& rCheck ) const;
	void Insert( SwCorrection* pCorr );
	void Delete( const String& rCheck );
};

// In TempAuto.Cxx implementiert, in olmenu.cxx und splwrp.cxx ggf. mit
// new angelegt.
extern SwTempAuto *pTempAuto;


#endif
