/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: svxurlbk.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 23:41:28 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#include <string.h>
#pragma hdrstop

#include <sot/exchange.hxx>
#include <sot/formats.hxx>

#include "svxurlbk.hxx"

//-----------------------------------------------------------------------

sal_uInt32 SvxINetBookmark::HasFormat( SotDataObject& rObj )

/*	[Beschreibung]

	Liefert sal_True, falls in dem SvDataObject ein entsp. ::com::sun::star::text::Bookmark-Format
	gefunden wurde.
*/

{
	return INetBookmark::_HasFormat( rObj );
}

//-----------------------------------------------------------------------

sal_Bool SvxINetBookmark::SetData( SvData& rData )

/*	[Beschreibung]

	Liefert sal_True, falls in dem SvDataObject ein entsp. ::com::sun::star::text::Bookmark-Format
	gefunden steht, das wir unterstuetzen. Wenn ja, werden die Daten
	ins Data-Object kopiert.
*/

{
	return INetBookmark::_SetData( rData );
}

//-----------------------------------------------------------------------

sal_Bool SvxINetBookmark::Copy( SotDataObject& rObj ) const

/*	[Beschreibung]

	Diese Methode kopiert diese Instanz in das Clipboard.
*/

{
	return INetBookmark::_Copy( rObj );
}

//-----------------------------------------------------------------------

sal_Bool SvxINetBookmark::Paste( SotDataObject& rObj, sal_uInt32 nFormat )

/*	[Beschreibung]

	Diese Methode "uberschreibt den Wert dieser Instanz mit dem
	Inhalt des DragServers an Position 'nItem'. Es wird vorausgesetzt,
	da\s sich das eigene Format im DragServer befindet.
*/

{
	return INetBookmark::_Paste( rObj, nFormat );
}

//=======================================================================

#if SUP <= 397

sal_uInt32 SvxINetBookmark::HasFormat( SvDataObject& rObj )
{
	SotDataObject& rSotObj = rObj;
	return SvxINetBookmark::HasFormat( rSotObj );
}

sal_Bool SvxINetBookmark::Copy( SvDataObject& rObj ) const
{
	SotDataObject& rSotObj = rObj;
	return Copy( rSotObj );
}

sal_Bool SvxINetBookmark::Paste( SvDataObject& rObj, sal_uInt32 nFormat )
{
	SotDataObject& rSotObj = rObj;
	return Paste( rSotObj, nFormat );
}

#endif



