
package org.netbeans.modules.openoffice;

import java.io.*;
import java.util.HashMap;
import java.util.Date;
import java.text.DateFormat;

import org.openide.loaders.*;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.actions.*;
import org.openide.util.actions.SystemAction;
import org.openide.util.*;


public class OOIDLDataLoader extends UniFileLoader {

    
   
    /** Creates new OOIDLDataLoader */
    public OOIDLDataLoader() {
        super (OOIDLDataObject.class);
    }

    /** Does initialization. Initializes display name,
    * extension list and the actions. */
    protected void initialize () {
        super.initialize ();
        setDisplayName (NbBundle.getBundle (OOIDLDataLoader.class).
                        getString("PROP_OOIDLLoader_Name"));
        ExtensionList exts = new ExtensionList ();
        exts.addExtension ("idl");
        setExtensions (exts);
        setSpecialNames (new String[] { "Openoffice IDL", "StarOffice IDL", "IDL File" });
        setActions(new SystemAction[] {
                       SystemAction.get(OpenAction.class),
                       SystemAction.get(FileSystemAction.class),
                       null,
                       SystemAction.get(CompileAction.class),
                       null,
                       SystemAction.get(CutAction.class),
                       SystemAction.get(CopyAction.class),
                       SystemAction.get(PasteAction.class),
                       null,
                       SystemAction.get(DeleteAction.class),
                       SystemAction.get(RenameAction.class),
                       null,
                       SystemAction.get(ToolsAction.class),
                       SystemAction.get(PropertiesAction.class),
                   });
    }


    /** Create a special file entry for the makefile.
     * For token substitution.
     * @param obj the data object
     * @param primaryFile the only file
     * @return a special file entry
     */
    protected MultiDataObject.Entry createPrimaryEntry (MultiDataObject obj, FileObject primaryFile) {
        return new OOIDLFileEntry (obj, primaryFile);
    }


    /** Get the primary file.
     * @param fo the file to find the primary file for
     *
     * @return the primary file, or <code>null</code> if its extension is not {@link #getExtensions recognized}
     */
    protected FileObject findPrimaryFile (FileObject fo) {
        FileObject supe = super.findPrimaryFile (fo);
        if (supe != null) return supe;
        String name = fo.getName ();
        String ext = fo.getExt ();
        if (ext != null && ! ext.equals ("")) name += '.' + ext;
        String[] names = getSpecialNames ();
        for (int i = 0; i < names.length; i++)
            if (name.equals (names[i]))
                return fo;
        return null;
    }


    /** Creates the correct kind of object.
     * @return the data object
     * @param fo the file
     * @throws IOException if something fails
     */
    protected MultiDataObject createMultiObject (final FileObject fo)
    throws IOException {
        return new OOIDLDataObject (fo, this);
    }

    /** Bean getter.
     * @return the special makefile names
     */
    public String[] getSpecialNames () {
        return (String[]) getProperty ("specialNames");
    }

    /** Bean setter.
     * @param nue the special makefile names
     */
    public void setSpecialNames (String[] nue) {
        putProperty ("specialNames", nue, true);
    }

    /** Store loader state.
     * @param oo the output stream
     * @throws IOException stream errors
     */
    public void writeExternal (ObjectOutput oo) throws IOException {
        super.writeExternal (oo);
        oo.writeObject (getSpecialNames ());
          try{
//        PrintStream prS = new PrintStream(new FileOutputStream("c:\\log.txt",true));
//        prS.println("write external von IDL Loader11");
//        prS.close();
        }catch (Exception e)
        {}
    }

    /** Read loader state.
     * @param oi the input stream
     * @throws IOException stream errors
     * @throws ClassNotFoundException definition errors
     */
    public void readExternal (ObjectInput oi) throws IOException, ClassNotFoundException {
        super.readExternal (oi);
        setSpecialNames ((String[]) oi.readObject ());
         try{
//        PrintStream prS = new PrintStream(new FileOutputStream("c:\\log.txt",true));
//        prS.println("read external von IDL Loader11");
//        prS.close();
        }catch (Exception e)
        {}
    }

    /** This entry defines the format for replacing the text during
     * instantiation the data object.
     */
    static class OOIDLFileEntry extends FileEntry.Format {

        /** generated
         */
        

        /** Creates new file entry.
         * This will handle substitution of tokens.
         * @param obj the data object
         * @param file the makefile
         */
        OOIDLFileEntry (MultiDataObject obj, FileObject file) {
            super (obj, file);
        }

        /** Method to provide suitable format for substitution of lines.
         *
         * @param target the target folder of the installation
         * @param n the name the file will have
         * @param e the extension the file will have
         * @return format to use for formating lines
         */
        protected java.text.Format createFormat (FileObject target, String n, String e) {
            HashMap map = new HashMap();
            // [PENDING] this is not really terribly useful unless it matches Java conventions
            map.put ("NAME", n);
            map.put ("DATE", DateFormat.getDateInstance (DateFormat.LONG).format (new Date()));
            map.put ("TIME", DateFormat.getTimeInstance (DateFormat.SHORT).format (new Date()));
            map.put ("USER", System.getProperty ("user.name"));

            MapFormat format = new MapFormat (map);
            format.setLeftBrace ("__");
            format.setRightBrace ("__");
            format.setExactMatch (false);
            return format;
        }
    }
}
