<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" 
xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
xmlns:fo="http://www.w3.org/1999/XSL/Format" 
xmlns:office="http://openoffice.org/2000/office" 
xmlns:style="http://openoffice.org/2000/style" 
xmlns:text="http://openoffice.org/2000/text" 
xmlns:table="http://openoffice.org/2000/table" 
xmlns:draw="http://openoffice.org/2000/drawing"  
xmlns:xlink="http://www.w3.org/1999/xlink" 
xmlns:dc="http://purl.org/dc/elements/1.1/" 
xmlns:meta="http://openoffice.org/2000/meta" 
xmlns:number="http://openoffice.org/2000/datastyle" 
xmlns:svg="http://www.w3.org/2000/svg" 
xmlns:chart="http://openoffice.org/2000/chart" 
xmlns:dr3d="http://openoffice.org/2000/dr3d" 
xmlns:math="http://www.w3.org/1998/Math/MathML" 
xmlns:form="http://openoffice.org/2000/form" 
xmlns:script="http://openoffice.org/2000/script" 
xmlns:config="http://openoffice.org/2001/config" 
office:class="text" 
office:version="1.0">

<!-- 
   +++++++++++++++++++++++++++++++++++++++++++++++
   DISPLAY OF THE IMAGES ONLY WORKS WHEN YOU'RE
	 INSIDE THE CVS MODULE STRUCTURE:
   
	 <some root folder>
	   |__helpcontent2
	   |   |__source
     |       |__text
     |           |__shared
     |           |__swriter
     |           |__...
     |
	   |__default_images	 

-->

<xsl:param name="imgmodule" select="'default_images'"/>

<xsl:variable name="imgroot">
	<xsl:call-template name="getdepth">
		<xsl:with-param name="file">
			<xsl:choose>
				<xsl:when test="starts-with(/helpdocument/meta/topic/filename,'/')">
					<xsl:value-of select="substring-after(/helpdocument/meta/topic/filename,'/')"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="/helpdocument/meta/topic/filename"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:with-param>
	</xsl:call-template>
</xsl:variable>


<!--
#############################################################################
 
	StarOffice Help Format Input Filter Stylesheet - Jan 26, 2006
	==================================================================
	(c) 2004-2006, Sun Microsystems, Inc. - FPE

	attribute values:
	o means no need for support
	+ means is supported
	# means is not supported
#############################################################################
-->


<xsl:param name="am" select="'&amp;'"/>
<xsl:param name="sl" select="'/'"/>
<xsl:param name="qt" select="'&quot;'"/>


<xsl:variable name="defaultpararoles">
	<xsl:value-of select="'note tip warning paragraph listitem code example tablecontent tablehead heading'"/>
</xsl:variable>

<xsl:variable name="defaultcharstyles">
	<xsl:value-of select="'acronym emph keycode literal menuitem path'"/>
</xsl:variable>

<xsl:template match="/">

	<xsl:element name="office:document">
			<office:meta>
		<meta:generator>OpenOffice.org Import Filter</meta:generator>
		
		<dc:title>
			<xsl:value-of select="/helpdocument/meta/topic/title"/>
		</dc:title>
		
		<dc:description></dc:description>
		<dc:subject><xsl:value-of select="/helpdocument/meta/topic/filename"/></dc:subject>
		<meta:creation-date>
			<xsl:value-of select="/helpdocument/meta/history/created/@date"/>
		</meta:creation-date>
		
		<dc:date>
			<xsl:value-of select="/helpdocument/meta/history/lastedited/@date"/>
		</dc:date>
		
		<dc:language>
			<xsl:value-of select="article/@lang"/>
		</dc:language>
		
		<meta:keywords>
			<meta:keyword><xsl:value-of select="/helpdocument/meta/topic/@status"/></meta:keyword>
		</meta:keywords>
		
		<meta:editing-cycles>1</meta:editing-cycles>
		<meta:editing-duration>P0DT0H0M1S</meta:editing-duration>
		
		<meta:user-defined meta:name="Indexer">
			<xsl:value-of select="/helpdocument/meta/topic/@indexer"/>
		</meta:user-defined>
		
		<meta:user-defined meta:name="ID">
			<xsl:value-of select="/helpdocument/meta/topic/@id"/>
		</meta:user-defined>
		
		<meta:user-defined meta:name="Created">
			<xsl:value-of select="/helpdocument/meta/history/created"/>
		</meta:user-defined>
		
		<meta:user-defined meta:name="Lastedited">
			<xsl:value-of select="/helpdocument/meta/history/lastedited"/>
		</meta:user-defined>
		
		<meta:document-statistic meta:table-count="0" meta:image-count="0" meta:object-count="0" meta:page-count="1" meta:paragraph-count="0" meta:word-count="0" meta:character-count="0"/>
	</office:meta>
	
	<office:script>
  	<office:events>
   		<script:event script:language="StarBasic" script:event-name="on-save-as-done" script:location="document" script:macro-name="HelpAuthoring._Main.SetMetaDataOnSave"/>
		<script:event script:language="StarBasic" script:event-name="on-save-as" script:location="application" script:macro-name="HelpAuthoring.Validate.Validate"/>
		<script:event script:language="StarBasic" script:event-name="on-save" script:location="application" script:macro-name="HelpAuthoring.Validate.Validate"/>
   		<script:event script:language="StarBasic" script:event-name="on-save-done" script:location="document" script:macro-name="HelpAuthoring._Main.SetMetaDataOnSave"/>
  	</office:events>
 	</office:script>
	
	<office:styles>
		<xsl:call-template name="createstyles"/>
	</office:styles>
	<office:automatic-styles>
		<xsl:call-template name="createautostyles"/>
	</office:automatic-styles>	
	<office:master-styles></office:master-styles>
	
	<office:body>				 
		<xsl:call-template name="createvariablesets"/>
		
		
		<xsl:apply-templates select="helpdocument/body" />
	
	</office:body>
	
	</xsl:element>
</xsl:template>

<!-- 
###################################################### 
AHELP 
	+ hid CDATA #REQUIRED
  + visibility (hidden | visible) #IMPLIED
###################################################### 
-->

<xsl:template match="ahelp">
	<xsl:choose>
		<xsl:when test="@visibility='hidden'">
				<text:span text:style-name="hlp_aux_tag">
				<text:variable-set text:name="AHID_" text:value-type="string">
					<xsl:value-of select="concat('&lt;AHID hid=&quot;',@hid,'&quot;&gt;')"/>
				</text:variable-set>
				</text:span>
				<xsl:apply-templates />
				<text:span text:style-name="hlp_aux_tag">
				<text:variable-set text:name="_AHID" text:value-type="string">
					<xsl:value-of select="'&lt;/AHID&gt;'"/>
				</text:variable-set>
				</text:span>
		</xsl:when>
		<xsl:otherwise>
			<text:span text:style-name="hlp_aux_tag">
			<text:variable-set text:name="AVIS_" text:value-type="string">
				<xsl:value-of select="concat('&lt;AVIS hid=&quot;',@hid,'&quot;&gt;')"/>
			</text:variable-set>
			</text:span>
			<xsl:apply-templates />
			<text:span text:style-name="hlp_aux_tag">
			<text:variable-set text:name="_AVIS" text:value-type="string">
				<xsl:value-of select="'&lt;/AVIS&gt;'"/>
			</text:variable-set>
			</text:span>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<!-- 
###################################################### 
ALT
  o xml-lang CDATA #REQUIRED (is always en-US for the source)
  + id CDATA #REQUIRED (is the same as for theimage except for "alt_"
  + localize CDATA #IMPLIED 
###################################################### 
-->

<xsl:template match="alt">
	<svg:desc>
		<xsl:choose>
			<xsl:when test="@localize">
				<xsl:value-of select="concat('LOCALIZE=',@localize,'#',.)"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="."/>
			</xsl:otherwise>
		</xsl:choose>
	</svg:desc>
</xsl:template>

<!-- 
###################################################### 
BODY, SEE HEADER
  # localize CDATA #IMPLIED
###################################################### 
-->
<!-- <xsl:template match="body" /> //-->

<!-- 
###################################################### 
BOOKMARK
  + branch CDATA #REQUIRED
  o xml-lang CDATA #REQUIRED (is always en-US for the source)
  + id CDATA #REQUIRED
  + localize CDATA #IMPLIED 
###################################################### 
-->
<xsl:template match="bookmark[starts-with(@branch,'hid')]">
	<xsl:choose>
		<xsl:when test="ancestor::paragraph">
			<text:span text:style-name="hlp_aux_tag">
			<text:variable-set text:name="BOOKMARK" text:value-type="string">
				<xsl:value-of select="concat('&lt;BOOKMARK branch=&quot;',@branch,'&quot; id=&quot;',@id,'&quot; localize=&quot;false&quot;/&gt;')"/>
			</text:variable-set>
			</text:span>
		</xsl:when>
		<xsl:otherwise>
			<text:p text:style-name="hlp_aux_bookmark">
				<text:span text:style-name="hlp_aux_tag">
			<text:variable-set text:name="BOOKMARK" text:value-type="string">
				<xsl:value-of select="concat('&lt;BOOKMARK branch=&quot;',@branch,'&quot; id=&quot;',@id,'&quot; localize=&quot;false&quot;/&gt;')"/>
			</text:variable-set>
			</text:span>
			</text:p>
		</xsl:otherwise>
	</xsl:choose>

</xsl:template>

<xsl:template match="bookmark">
	<xsl:choose>
		<xsl:when test="ancestor::paragraph">
			<text:span text:style-name="hlp_aux_tag">
			<text:variable-set text:name="BOOKMARK_" text:value-type="string">
				<xsl:value-of select="concat('&lt;BOOKMARK branch=&quot;',@branch,'&quot; id=&quot;',@id,'&quot; localize=&quot;',@localize,'&quot;&gt;')"/>
			</text:variable-set>
			</text:span>
			<xsl:apply-templates />
			<text:line-break/>
			<text:span text:style-name="hlp_aux_tag">
			<text:variable-set text:name="_BOOKMARK" text:value-type="string">
				<xsl:value-of select="'&lt;/BOOKMARK&gt;'"/>
			</text:variable-set>
			</text:span>
		</xsl:when>
		<xsl:otherwise>
			<text:p text:style-name="hlp_aux_bookmark">
				<text:span text:style-name="hlp_aux_tag">
				<text:variable-set text:name="BOOKMARK_" text:value-type="string">
					<xsl:value-of select="concat('&lt;BOOKMARK branch=&quot;',@branch,'&quot; id=&quot;',@id,'&quot; localize=&quot;',@localize,'&quot;&gt;')"/>
				</text:variable-set>
				</text:span>
				<xsl:apply-templates />
				<text:line-break/>
				<text:span text:style-name="hlp_aux_tag">
				<text:variable-set text:name="_BOOKMARK" text:value-type="string">
					<xsl:value-of select="'&lt;/BOOKMARK&gt;'"/>
				</text:variable-set>
				</text:span>
			</text:p>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<!-- 
###################################################### 
BOOKMARK_VALUE 
###################################################### 
-->
<xsl:template match="bookmark_value">
	<text:line-break />
	<text:span text:style-name="hlp_aux_tag">
	<text:variable-set text:name="BOOKMARKVALUE_" text:value-type="string">
		<xsl:value-of select="'&lt;BOOKMARKVALUE&gt;'"/>
	</text:variable-set>
	</text:span>
	<text:variable-set text:name="BOOKMARKVALUE" text:value-type="string">
		<xsl:apply-templates />
	</text:variable-set>
	<text:span text:style-name="hlp_aux_tag">
	<text:variable-set text:name="_BOOKMARKVALUE" text:value-type="string">
		<xsl:value-of select="'&lt;/BOOKMARKVALUE&gt;'"/>
	</text:variable-set>
	</text:span>
</xsl:template>

<!-- 
###################################################### 
BR 
###################################################### 
-->
<xsl:template match="br">
	<text:line-break/>
</xsl:template>

<!-- 
###################################################### 
CAPTION 
  o xml-lang CDATA #REQUIRED (is always en-US for the source)
  + id CDATA #REQUIRED   (in parent elements)
  + localize CDATA #IMPLIED (in parent elements)
###################################################### 
-->
<xsl:template match="caption">
	<xsl:apply-templates />
</xsl:template>

<!-- 
###################################################### 
CASE
  + select CDATA #REQUIRED
###################################################### 
-->
<xsl:template match="case">
	<text:p text:style-name="hlp_aux_switch">
		<text:span text:style-name="hlp_aux_tag">
			<text:variable-set text:name="CASE_" text:value-type="string">
				<xsl:value-of select="concat('&lt;CASE select=&quot;',@select,'&quot;&gt;')"/>
			</text:variable-set>
		</text:span>
		<xsl:text> </xsl:text>
		</text:p>
		<xsl:apply-templates />
		<text:p text:style-name="hlp_aux_switch">
		<text:span text:style-name="hlp_aux_tag">
			<text:variable-set text:name="_CASE" text:value-type="string">
			<xsl:value-of select="'&lt;/CASE&gt;'"/>
			</text:variable-set>
		</text:span>
		<xsl:text> </xsl:text>
	</text:p>
</xsl:template>

<!-- 
###################################################### 
CASEINLINE
  + select CDATA #REQUIRED 
###################################################### 
-->
<xsl:template match="caseinline">
	<text:span text:style-name="hlp_aux_tag">
			<text:variable-set text:name="CASEINLINE_" text:value-type="string">
				<xsl:value-of select="concat('&lt;CASEINLINE select=&quot;',@select,'&quot;&gt;')"/>
			</text:variable-set>
		</text:span>
		<xsl:apply-templates />
		<text:span text:style-name="hlp_aux_tag">
			<text:variable-set text:name="_CASEINLINE" text:value-type="string">
			<xsl:value-of select="'&lt;/CASEINLINE&gt;'"/>
			</text:variable-set>
		</text:span>
</xsl:template>

<!-- 
###################################################### 
COMMENT 
###################################################### 
-->
<xsl:template match="comment">
	<xsl:choose>
		<xsl:when test="ancestor::paragraph">
			<text:span text:style-name="hlp_aux_tag">
				<text:variable-set text:name="COMMENT_" text:value-type="string">
					<xsl:value-of select="'&lt;COMMENT&gt;'"/>
				</text:variable-set>
			</text:span>
			<text:span text:style-name="hlp_aux_comment">
				<text:variable-set text:name="COMMENT" text:value-type="string">
					<xsl:value-of select="."/>
				</text:variable-set>
			</text:span>
			<text:span text:style-name="hlp_aux_tag">
				<text:variable-set text:name="_COMMENT" text:value-type="string">
					<xsl:value-of select="'&lt;/COMMENT&gt;'"/>
				</text:variable-set>
			</text:span>
		</xsl:when>
		<xsl:otherwise>
			<text:p text:style-name="hlp_aux_comment">
				<text:span text:style-name="hlp_aux_tag">
					<text:variable-set text:name="COMMENT_" text:value-type="string">
						<xsl:value-of select="'&lt;COMMENT&gt;'"/>
					</text:variable-set>
				</text:span>
				<text:span text:style-name="hlp_aux_comment">
					<text:variable-set text:name="COMMENT" text:value-type="string">
					<xsl:value-of select="."/>
				</text:variable-set>
				</text:span>
				<text:span text:style-name="hlp_aux_tag">
					<text:variable-set text:name="_COMMENT" text:value-type="string">
						<xsl:value-of select="'&lt;/COMMENT&gt;'"/>
					</text:variable-set>
				</text:span>
				<xsl:text> </xsl:text>
			</text:p>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<!-- 
###################################################### 
CREATED,  SEE HEADER
  + date CDATA #REQUIRED
###################################################### 
-->
<xsl:template match="created" />

<!-- 
###################################################### 
DEFAULT 
###################################################### 
-->
<xsl:template match="default">
	<text:p text:style-name="hlp_aux_switch">
		<text:span text:style-name="hlp_aux_tag">
			<text:variable-set text:name="DEFAULT_" text:value-type="string">
				<xsl:value-of select="'&lt;DEFAULT&gt;'"/>
			</text:variable-set>
		</text:span>
		<xsl:text> </xsl:text>
		</text:p>
		<xsl:apply-templates />
		<text:p text:style-name="hlp_aux_switch">
		<text:span text:style-name="hlp_aux_tag">
			<text:variable-set text:name="_DEFAULT" text:value-type="string">
			<xsl:value-of select="'&lt;/DEFAULT&gt;'"/>
			</text:variable-set>
		</text:span>
		<xsl:text> </xsl:text>
	</text:p>
</xsl:template>

<!-- 
###################################################### 
DEFAULTINLINE 
###################################################### 
-->
<xsl:template match="defaultinline">
	<text:span text:style-name="hlp_aux_tag">
			<text:variable-set text:name="DEFAULTINLINE_" text:value-type="string">
				<xsl:value-of select="'&lt;DEFAULTINLINE&gt;'"/>
			</text:variable-set>
		</text:span>
		<xsl:apply-templates />
		<text:span text:style-name="hlp_aux_tag">
			<text:variable-set text:name="_DEFAULTINLINE" text:value-type="string">
			<xsl:value-of select="'&lt;/DEFAULTINLINE&gt;'"/>
			</text:variable-set>
		</text:span>
</xsl:template>

<!-- 
###################################################### 
EMBED
	+ href CDATA #REQUIRED
  + role CDATA #IMPLIED
  + level CDATA #IMPLIED
###################################################### 
-->
<xsl:template match="embed">
	<xsl:variable name="embed" select="concat('embed file=&quot;',@href,'&quot; role=&quot;',@role,'&quot; level=&quot;',@level,'&quot;')" />
	<text:p text:style-name="hlp_aux_embed">
	<xsl:variable name="href" select="substring-before(@href,'#')"/>
	<text:span text:style-name="hlp_aux_tag">
	
	<text:variable-set text:name="EMBED" text:value-type="string">
		<xsl:value-of select="concat('&lt;EMBED href=&quot;',@href,'&quot;')"/>
		<xsl:if test="@role">
			<xsl:value-of select="concat(' role=&quot;',@role,'&quot;')"/>
		</xsl:if>
			<xsl:if test="@level">
		<xsl:value-of select="concat(' level=&quot;',@level,'&quot;')"/>
		</xsl:if>
		<xsl:value-of select="'&gt;'"/>
	</text:variable-set>
	
	
	</text:span>
	</text:p>
</xsl:template>

<!-- 
###################################################### 
EMBEDVAR
 + href CDATA #REQUIRED
 + markup (keep | ignore) #IMPLIED
###################################################### 
-->
<xsl:template match="embedvar">
	<xsl:variable name="embed" select="concat('embedvar var=&quot;',@href,'&quot; markup=&quot;',@markup,'&quot;')" />
	<xsl:variable name="href" select="@href"/>
	<text:span text:style-name="hlp_aux_tag">
	
	<text:variable-set text:name="EMBEDVAR" text:value-type="string">
		<xsl:value-of select="concat('&lt;EMBEDVAR var=&quot;',@href,'&quot;')"/>
		<xsl:if test="@markup">
		<xsl:value-of select="concat(' markup=&quot;',@markup,'&quot;')"/>
		</xsl:if>
		<xsl:value-of select="'&gt;'"/>
	</text:variable-set>
	</text:span>
</xsl:template>

<!-- 
###################################################### 
EMPH 
###################################################### 
-->
<xsl:template match="emph">
	<text:span text:style-name="hlp_emph">
		<xsl:apply-templates />
	</text:span>
</xsl:template>

<!-- 
###################################################### 
FILENAME,  SEE HEADER
###################################################### 
-->
<xsl:template match="filename" />


<!-- 
###################################################### 
HELPDOCUMENT,  SEE HEADER
  + version CDATA #REQUIRED
###################################################### 
-->
<!-- <xsl:template match="helpdocument" /> -->

<!-- 
###################################################### 
HISTORY,  SEE HEADER
###################################################### 
-->
<xsl:template match="history" />


<!-- 
###################################################### 
IMAGE 
  + s rc CDATA #REQUIRED
  + width CDATA #IMPLIED
  + height CDATA #IMPLIED
  + id CDATA #REQUIRED
###################################################### 
-->
<xsl:template match="image">
	<xsl:variable name="src" select="concat($imgroot,@src)" />
			<xsl:choose>
				<xsl:when test="not(parent::paragraph)"> 
							<text:p text:style-name="hlp_default">
								<text:span text:style-name="hlp_aux_tag">
									<text:variable-set text:name="ID" text:value-type="string">
										<xsl:value-of select="concat('id=&quot;par_id',generate-id(),'&quot; l10n=&quot;F&quot;')"/>
									</text:variable-set>
								</text:span><text:span text:style-name="hlp_aux_tag">
								<text:variable-set text:name="IMG_" text:value-type="string">
									<xsl:value-of select="concat('&lt;IMG ID=&quot;',@id,'&quot;&gt;')"/>
								</text:variable-set>
							</text:span>
								<draw:image draw:name="{@id}" text:anchor-type="as-char" xlink:href="{$src}" xlink:type="simple" xlink:show="embed" xlink:actuate="onLoad" draw:filter-name="&lt;All formats&gt;">
									<xsl:if test="@height"><xsl:attribute name="svg:height"><xsl:value-of select="@height"/></xsl:attribute></xsl:if>
									<xsl:if test="@width"><xsl:attribute name="svg:width"><xsl:value-of select="@width"/></xsl:attribute></xsl:if>
									<xsl:apply-templates select="alt"/>
								</draw:image>
	
								<xsl:if test="caption">
									<text:span text:style-name="hlp_aux_tag">
										<text:variable-set text:name="IMGCAPTION_" text:value-type="string">
											<xsl:value-of select="concat('&lt;IMGCAPTION ID=&quot;',caption/@id,'&quot; LOCALIZE=&quot;',caption/@localize,'&quot;&gt;')"/>
										</text:variable-set>
									</text:span>
									
									<text:span text:style-name="hlp_aux_imgcaption">
										<xsl:apply-templates select="caption"/>
									</text:span>
									
									<text:span text:style-name="hlp_aux_tag">
										<text:variable-set text:name="_IMGCAPTION" text:value-type="string">
											<xsl:value-of select="'&lt;/IMGCAPTION&gt;'"/>
										</text:variable-set>
									</text:span>
								</xsl:if>	
	
								<text:span text:style-name="hlp_aux_tag">
									<text:variable-set text:name="_IMG" text:value-type="string">
										<xsl:value-of select="'&lt;/IMG&gt;'"/>
									</text:variable-set>
								</text:span>
							</text:p>
				</xsl:when>
				<xsl:otherwise>
							<text:span text:style-name="hlp_aux_tag">
								<text:variable-set text:name="IMG_" text:value-type="string">
									<xsl:value-of select="concat('&lt;IMG ID=&quot;',@id,'&quot;&gt;')"/>
								</text:variable-set>
							</text:span>
							
							<xsl:variable name="localize_img">
							<xsl:choose>
								<xsl:when test="@localize">
									<xsl:value-of select="concat(' localize=&quot;',@localize,'&quot;')"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="''"/>
								</xsl:otherwise>
							</xsl:choose>
							</xsl:variable>
			
							<draw:image draw:name="{@id}{$localize_img}" text:anchor-type="as-char" xlink:href="{$src}" xlink:type="simple" xlink:show="embed" xlink:actuate="onLoad" draw:filter-name="&lt;All formats&gt;">
									<xsl:if test="@height"><xsl:attribute name="svg:height"><xsl:value-of select="@height"/></xsl:attribute></xsl:if>
									<xsl:if test="@width"><xsl:attribute name="svg:width"><xsl:value-of select="@width"/></xsl:attribute></xsl:if>
									<xsl:if test="$localize_img != ''"><xsl:attribute name="draw:style-name"><xsl:value-of select="'hlp_img_loc'"/></xsl:attribute></xsl:if>
									<xsl:apply-templates select="alt"/>
								</draw:image>
	
								<xsl:if test="caption">
									<text:span text:style-name="hlp_aux_tag">
										<text:variable-set text:name="IMGCAPTION_" text:value-type="string">
											<xsl:value-of select="concat('&lt;IMGCAPTION ID=&quot;',caption/@id,'&quot; LOCALIZE=&quot;',caption/@localize,'&quot;&gt;')"/>
										</text:variable-set>
									</text:span>
									
									<text:span text:style-name="hlp_aux_imgcaption">
										<xsl:apply-templates select="caption"/>
									</text:span>
									
									<text:span text:style-name="hlp_aux_tag">
										<text:variable-set text:name="_IMGCAPTION" text:value-type="string">
											<xsl:value-of select="'&lt;/IMGCAPTION&gt;'"/>
										</text:variable-set>
									</text:span>
								</xsl:if>	
	
								<text:span text:style-name="hlp_aux_tag">
									<text:variable-set text:name="_IMG" text:value-type="string">
										<xsl:value-of select="'&lt;/IMG&gt;'"/>
									</text:variable-set>
								</text:span>
				</xsl:otherwise>
			</xsl:choose>
	
</xsl:template>

<!-- 
###################################################### 
ITEM 
  + type CDATA #REQUIRED
###################################################### 
-->
<xsl:template match="item">
	<xsl:variable name="style"><xsl:value-of select="concat('hlp_',@type)"/></xsl:variable>
	<text:span text:style-name="{$style}">    <!-- style needs to be created, see createstyles template -->
		<xsl:apply-templates />
	</text:span>
</xsl:template>

<!-- 
###################################################### 
LASTEDITED,  SEE HEADER
  + date CDATA #REQUIRED
###################################################### 
-->
<xsl:template match="lastedited" />

<!-- 
###################################################### 
LINK
  + href CDATA #REQUIRED
  + name CDATA #REQUIRED
  + type CDATA #IMPLIED
  + target CDATA #IMPLIED
###################################################### 
-->
<xsl:template match="link">
	<xsl:variable name="href">
	<xsl:choose>
		<xsl:when test="starts-with(@href,'text/')">
			<xsl:value-of select="@href"/>
		</xsl:when>
		<xsl:otherwise>
			<xsl:value-of select="@href"/>
		</xsl:otherwise>
	</xsl:choose>
	</xsl:variable>
	<text:span text:style-name="hlp_aux_tag">
	<text:variable-set text:name="LINK_" text:value-type="string">
		<xsl:value-of select="concat('&lt;LINK href=&quot;',@href,'&quot;')"/>
		<xsl:if test="@name"><xsl:value-of select="concat(' name=&quot;',@name,'&quot;')"/></xsl:if>
		<xsl:if test="@type"><xsl:value-of select="concat(' type=&quot;',@type,'&quot;')"/></xsl:if>
		<xsl:if test="@target"><xsl:value-of select="concat(' target=&quot;',@target,'&quot;')"/></xsl:if>
		<xsl:value-of select="'&gt;'"/>
	</text:variable-set>
	</text:span>
	<xsl:apply-templates />
	<text:span text:style-name="hlp_aux_tag">
	<text:variable-set text:name="_LINK" text:value-type="string">
		<xsl:value-of select="'&lt;/LINK&gt;'"/>
	</text:variable-set>
  </text:span>
	
</xsl:template>

<!-- 
###################################################### 
LIST
  + type CDATA #REQUIRED
  + startwith CDATA #IMPLIED
  # format (1 | i | I | a | A) #IMPLIED
  # bullet (disc | circle | square) #IMPLIED
  # localize CDATA #IMPLIED
  # sorted (asc | desc) #IMPLIED
###################################################### 
-->
<xsl:template match="list">
	
	<xsl:variable name="style">
		<xsl:choose>
			<xsl:when test="@startwith">
				<xsl:value-of select="concat('hlp_List',@startwith)"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="'hlp_orderedlist'"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	<xsl:choose>
		<xsl:when test="@type='ordered'">
			<text:ordered-list text:style-name="{$style}">
				<xsl:apply-templates />
			</text:ordered-list>
		</xsl:when>
		<xsl:otherwise>
			<text:unordered-list text:style-name="{$style}">
				<xsl:apply-templates />
			</text:unordered-list>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<!-- 
###################################################### 
LISTITEM 
  # format (1 | i | I | a | A) #IMPLIED
  # bullet (disc | circle | square) #IMPLIED
  # localize CDATA #IMPLIED
  # class CDATA #IMPLIED
###################################################### 
-->
<xsl:template match="listitem">
	<text:list-item>
		<xsl:apply-templates />
	</text:list-item>
</xsl:template>

<!-- 
###################################################### 
META, SEE HEADER
###################################################### 
-->
<xsl:template match="meta" />

<!-- 
###################################################### 
OBJECT
  + type CDATA #REQUIRED
  + id CDATA #REQUIRED
  + data CDATA #REQUIRED
  + height CDATA #IMPLIED
  + width CDATA #IMPLIED
###################################################### 
-->
<xsl:template match="object">
	<xsl:choose>
		<xsl:when test="@height">
			<draw:text-box draw:style-name="fr1" draw:name="frame1" text:anchor-type="as-char" svg:width="{@width}" fo:min-height="{@height}" draw:z-index="1">
				<text:p text:style-name="hlp_default">
					<text:span text:style-name="hlp_aux_tag">
						<text:variable-set text:name="OBJECT" text:value-type="string">
							<xsl:value-of select="concat('&lt;OBJECT ID=&quot;',@id,'&quot; TYPE=&quot;',@type,'&quot; DATA=&quot;',@data,'&quot; HEIGHT=&quot;',@height,'&quot; WIDTH=&quot;',@width,'&quot; /&gt;')"/>
						</text:variable-set>
					</text:span>
					<xsl:text> </xsl:text>
				</text:p>
			</draw:text-box>
		</xsl:when>
		<xsl:otherwise>
			<text:span text:style-name="hlp_aux_tag">
				<text:variable-set text:name="OBJECT" text:value-type="string">
					<xsl:value-of select="concat('&lt;OBJECT ID=&quot;',@id,'&quot; TYPE=&quot;',@type,'&quot; DATA=&quot;',@data,'&quot; HEIGHT=&quot;',@height,'&quot; WIDTH=&quot;',@width,'&quot; /&gt;')"/>
				</text:variable-set>
			</text:span>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<!-- 
###################################################### 
PARAGRAPH 
  + role CDATA #REQUIRED
  + level CDATA #IMPLIED
  + id CDATA #REQUIRED
  + l10n CDATA #REQUIRED
  o xml-lang CDATA #REQUIRED (is always en-US for the source)
  + oldref CDATA #IMPLIED
  + localize CDATA #IMPLIED
###################################################### 
-->
<xsl:template match="paragraph">
	<xsl:choose>
		<xsl:when test="@role='heading'">
			<xsl:variable name="style" select="concat('hlp_head',@level)" />
			<text:h text:style-name="{$style}" text:level="{@level}">
			
			<xsl:variable name="tagstyle">
				<xsl:choose>
					<xsl:when test="@l10n='NEW' or @l10n='CHG'">
						<xsl:value-of select="'hlp_aux_parachanged'"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="'hlp_aux_tag'"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:variable>

			<text:span text:style-name="{$tagstyle}">
			<text:variable-set text:name="ID" text:value-type="string">
				<xsl:value-of select="concat('id=&quot;',@id,'&quot;')"/>
				<xsl:if test="@l10n and not(@l10n='')"> 
					<xsl:value-of select="concat(' l10n=&quot;',@l10n,'&quot;')"/>
				</xsl:if>
				<xsl:if test="@oldref and not(@oldref='')"> 
					<xsl:value-of select="concat(' oldref=&quot;',@oldref,'&quot;')"/>
				</xsl:if>
				<xsl:if test="@localize and not(@localize='')"> 
					<xsl:value-of select="concat(' localize=&quot;',@localize,'&quot;')"/>
				</xsl:if>
			</text:variable-set>
			</text:span>
				<xsl:apply-templates />
			</text:h>
		</xsl:when>
		
		<xsl:otherwise>
			<xsl:variable name="style" select="concat('hlp_',@role)" />
			<text:p text:style-name="{$style}">
			<xsl:variable name="tagstyle">
				<xsl:choose>
					<xsl:when test="@l10n='NEW' or @l10n='CHG'">
						<xsl:value-of select="'hlp_aux_parachanged'"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="'hlp_aux_tag'"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:variable>
		<text:span text:style-name="{$tagstyle}">
			<text:variable-set text:name="ID" text:value-type="string">
				<xsl:value-of select="concat('id=&quot;',@id,'&quot;')"/>
				<xsl:if test="@l10n and not(@l10n='')"> 
					<xsl:value-of select="concat(' l10n=&quot;',@l10n,'&quot;')"/>
				</xsl:if>
				<xsl:if test="@oldref and not(@oldref='')"> 
					<xsl:value-of select="concat(' oldref=&quot;',@oldref,'&quot;')"/>
				</xsl:if>
				<xsl:if test="@localize and not(@localize='')"> 
					<xsl:value-of select="concat(' localize=&quot;',@localize,'&quot;')"/>
				</xsl:if>
			</text:variable-set>
			</text:span>
				<xsl:apply-templates />
			</text:p>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<!-- 
###################################################### 
SECTION
  + id CDATA #REQUIRED
  + localize CDATA #IMPLIED 
###################################################### 
-->
<xsl:template match="section"> <!-- some files contain 2 equal sections cascaded (bug) -->
	<xsl:variable name="id1" select="@id" />
	<xsl:choose>
		<xsl:when test="child::section[@id=$id1]">
			<xsl:apply-templates />
		</xsl:when>
		<xsl:otherwise>
			<xsl:variable name="id">
				<xsl:choose>
					<xsl:when test="@localize='false'">
						<xsl:value-of select="concat(@id,'__NOLOCALIZE')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="@id"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:variable>
			<text:section text:style-name="hlp_aux_section" text:name="{$id}">
				<text:p text:style-name="hlp_aux_section">
					<text:span text:style-name="hlp_aux_tag">
						<text:variable-set text:name="SECTION_" text:value-type="string">
							<xsl:value-of select="concat('&lt;SECTION id=&quot;',@id,'&quot;&gt;')"/>
						</text:variable-set>
					</text:span>
				</text:p>
				<xsl:apply-templates />
				<text:p text:style-name="hlp_aux_section">
					<text:span text:style-name="hlp_aux_tag">
						<text:variable-set text:name="_SECTION" text:value-type="string">
							<xsl:value-of select="'&lt;/SECTION&gt;'"/>
						</text:variable-set>
					</text:span>
				</text:p>
			</text:section>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<!-- 
###################################################### 
SORT 
  + order (asc | desc) #IMPLIED
###################################################### 
-->
<xsl:template match="sort">
	<text:p text:style-name="hlp_aux_sort">
		<text:span text:style-name="hlp_aux_tag">
			<text:variable-set text:name="SORT_" text:value-type="string">
				<xsl:value-of select="concat('&lt;SORT order=&quot;',@order,'&quot;&gt;')"/>
			</text:variable-set>
		</text:span>
		<xsl:text> </xsl:text>
		</text:p>
		<xsl:apply-templates />
		<text:p text:style-name="hlp_aux_sort">
		<text:span text:style-name="hlp_aux_tag">
			<text:variable-set text:name="_SORT" text:value-type="string">
			<xsl:value-of select="'&lt;/SORT&gt;'"/>
			</text:variable-set>
		</text:span>
		<xsl:text> </xsl:text>
	</text:p>
</xsl:template>

<!-- 
###################################################### 
SWITCH
  + select (sys | appl | distrib ) #REQUIRED
  + localize CDATA #IMPLIED
###################################################### 
-->
<xsl:template match="switch">
	<text:p text:style-name="hlp_aux_switch">
		<text:span text:style-name="hlp_aux_tag">
			<text:variable-set text:name="SWITCH_" text:value-type="string">
				<xsl:value-of select="concat('&lt;SWITCH select=&quot;',@select,'&quot; localize=&quot;',@localize,'&quot;&gt;')"/>
			</text:variable-set>
		</text:span>
		<xsl:text> </xsl:text>
		</text:p>
		<xsl:apply-templates />
		<text:p text:style-name="hlp_aux_switch">
		<text:span text:style-name="hlp_aux_tag">
			<text:variable-set text:name="_SWITCH" text:value-type="string">
			<xsl:value-of select="'&lt;/SWITCH&gt;'"/>
			</text:variable-set>
		</text:span>
		<xsl:text> </xsl:text>
	</text:p>
</xsl:template>

<!-- 
###################################################### 
SWITCHINLINE
  + select (sys | appl | distrib | target | ver | lang) #REQUIRED
###################################################### 
-->
<xsl:template match="switchinline">
	<text:span text:style-name="hlp_aux_tag">
			<text:variable-set text:name="SWITCHINLINE_" text:value-type="string">
				<xsl:value-of select="concat('&lt;SWITCHINLINE select=&quot;',@select,'&quot;&gt;')"/>
			</text:variable-set>
		</text:span>
		<xsl:apply-templates />
		<text:span text:style-name="hlp_aux_tag">
			<text:variable-set text:name="_SWITCHINLINE" text:value-type="string">
			<xsl:value-of select="'&lt;/SWITCHINLINE&gt;'"/>
			</text:variable-set>
		</text:span>
</xsl:template>

<!-- 
###################################################### 
TABLE
  + name CDATA #IMPLIED
  + width CDATA #IMPLIED
  + height CDATA #IMPLIED
  + unit CDATA #IMPLIED
  + class CDATA #IMPLIED
  + id CDATA #REQUIRED
  + localize CDATA #IMPLIED
###################################################### 
-->
<xsl:template match="table">
	<xsl:variable name="maxcols">
	<xsl:value-of select="count(tablerow[1]/tablecell)" />	<!-- colspan for first row unsupported! -->
	</xsl:variable>
	
	<xsl:variable name="id">
			<xsl:value-of select="concat('ID=(',@id,')WIDTH=(',@width,')HEIGHT=(',@height,')UNIT=(',@unit,')CLASS=(',@class,')LOCALIZE=(',@localize,')')"/>		
	</xsl:variable>
	
	<table:table table:name="{$id}" table:style-name="hlp_table">
	   <table:table-column table:number-columns-repeated="{$maxcols}"/>
		 <xsl:apply-templates />
	</table:table>
	<xsl:if test="caption">
		<text:p text:style-name="hlp_aux_tablecaption">
	
			<text:span text:style-name="hlp_aux_tag">
				<text:variable-set text:name="CAPTION_" text:value-type="string">
					<xsl:value-of select="concat('&lt;CAPTION ID=&quot;',caption/@id,'&quot; LOCALIZE=&quot;',caption/@localize,'&quot;&gt;')"/>
				</text:variable-set>
			</text:span>
			
			<xsl:apply-templates select="caption"/>
			<text:span text:style-name="hlp_aux_tag">
				<text:variable-set text:name="_CAPTION" text:value-type="string">
					<xsl:value-of select="'&lt;/CAPTION&gt;'"/>
				</text:variable-set>
			</text:span>
			<xsl:text> </xsl:text>
		</text:p>
	</xsl:if>
</xsl:template>

<!-- 
###################################################### 
TABLECELL
  + colspan CDATA #IMPLIED
  + rowspan CDATA #IMPLIED
  # width CDATA #IMPLIED
  # class CDATA #IMPLIED
  # unit CDATA #IMPLIED
  # localize CDATA #IMPLIED
###################################################### 
-->
<xsl:template match="tablecell">
	<table:table-cell>
		<xsl:if test="@colspan">
			<xsl:attribute name="table:number-columns-spanned"><xsl:value-of select="@colspan"/></xsl:attribute>
		</xsl:if>
		<xsl:if test="@rowspan">
			<xsl:attribute name="table:number-rows-spanned"><xsl:value-of select="@rowspan"/></xsl:attribute>
		</xsl:if>
		<xsl:apply-templates />
	</table:table-cell>
</xsl:template>

<!-- 
###################################################### 
TABLEROW
  # height CDATA #IMPLIED
  # class CDATA #IMPLIED
  # unit CDATA #IMPLIED
  # localize CDATA #IMPLIED
###################################################### 
-->
<xsl:template match="tablerow">
	<table:table-row>
		<xsl:apply-templates />
	</table:table-row>
</xsl:template>

<!-- 
###################################################### 
TITLE,  SEE HEADER
  o xml-lang CDATA #REQUIRED (is always en-US for the source)
  o id CDATA #REQUIRED (is always tit for the title)
  # localize CDATA #IMPLIED
###################################################### 
-->
<xsl:template match="title"/>

<!-- 
###################################################### 
TOPIC,  SEE HEADER
  + id CDATA #REQUIRED
  + indexer (exclude | include) #IMPLIED 
###################################################### 
-->
<xsl:template match="topic"/>

<!-- 
###################################################### 
VARIABLE 
  + id CDATA #REQUIRED
  + visibility (hidden | visible) #IMPLIED
###################################################### 
-->
<xsl:template match="variable">
	<text:span text:style-name="hlp_aux_tag"><text:variable-set text:name="VAR_" text:value-type="string">
		<xsl:value-of select="concat('&lt;VAR ID=&quot;',@id,'&quot; VISIBILITY=&quot;',@visibility,'&quot;&gt;')"/>
	</text:variable-set>
	</text:span>
	<xsl:apply-templates />
	<text:span text:style-name="hlp_aux_tag"><text:variable-set text:name="_VAR" text:value-type="string">
		<xsl:value-of select="'&lt;/VAR&gt;'"/>
	</text:variable-set>
	</text:span>
</xsl:template>


<xsl:template name="createvariablesets">
	<text:variable-decls>
		<text:variable-decl text:value-type="string" text:name="AHID_"/>
		<text:variable-decl text:value-type="string" text:name="_AHID"/>
		<text:variable-decl text:value-type="string" text:name="AVIS_"/>
		<text:variable-decl text:value-type="string" text:name="_AVIS"/>
		<text:variable-decl text:value-type="string" text:name="AHID_"/>
		<text:variable-decl text:value-type="string" text:name="BOOKMARK"/>
		<text:variable-decl text:value-type="string" text:name="BOOKMARK_"/>
		<text:variable-decl text:value-type="string" text:name="_BOOKMARK"/>
		<text:variable-decl text:value-type="string" text:name="BOOKMARKVALUE_"/>
		<text:variable-decl text:value-type="string" text:name="_BOOKMARKVALUE"/>
		<text:variable-decl text:value-type="string" text:name="BOOKMARKVALUE"/>
		<text:variable-decl text:value-type="string" text:name="CASE_"/>
		<text:variable-decl text:value-type="string" text:name="_CASE"/>
		<text:variable-decl text:value-type="string" text:name="CASEINLINE_"/>
		<text:variable-decl text:value-type="string" text:name="_CASEINLINE"/>
		<text:variable-decl text:value-type="string" text:name="COMMENT_"/>
		<text:variable-decl text:value-type="string" text:name="_COMMENT"/>
		<text:variable-decl text:value-type="string" text:name="COMMENT"/>
		<text:variable-decl text:value-type="string" text:name="DEFAULT_"/>
		<text:variable-decl text:value-type="string" text:name="_DEFAULT"/>
		<text:variable-decl text:value-type="string" text:name="DEFAULTINLINE_"/>
		<text:variable-decl text:value-type="string" text:name="_DEFAULTINLINE"/>
		<text:variable-decl text:value-type="string" text:name="EMBEDVAR"/>
		<text:variable-decl text:value-type="string" text:name="EMBED"/>
		<text:variable-decl text:value-type="string" text:name="IMG_"/>
		<text:variable-decl text:value-type="string" text:name="_IMG"/>
		<text:variable-decl text:value-type="string" text:name="IMGCAPTION_"/>
		<text:variable-decl text:value-type="string" text:name="_IMGCAPTION"/>
		<text:variable-decl text:value-type="string" text:name="LINK_"/>
		<text:variable-decl text:value-type="string" text:name="_LINK"/>
		<text:variable-decl text:value-type="string" text:name="OBJECT"/>
		<text:variable-decl text:value-type="string" text:name="ID"/>
		<text:variable-decl text:value-type="string" text:name="SECTION_"/>
		<text:variable-decl text:value-type="string" text:name="_SECTION"/>
		<text:variable-decl text:value-type="string" text:name="SORT_"/>
		<text:variable-decl text:value-type="string" text:name="_SORT"/>
		<text:variable-decl text:value-type="string" text:name="SWITCH_"/>
		<text:variable-decl text:value-type="string" text:name="_SWITCH"/>
		<text:variable-decl text:value-type="string" text:name="SWITCHINLINE_"/>
		<text:variable-decl text:value-type="string" text:name="_SWITCHINLINE"/>
		<text:variable-decl text:value-type="string" text:name="TABLEATTR"/>
		<text:variable-decl text:value-type="string" text:name="CAPTION_"/>
		<text:variable-decl text:value-type="string" text:name="_CAPTION"/>
		<text:variable-decl text:value-type="string" text:name="_VAR"/>
		<text:variable-decl text:value-type="string" text:name="VAR_"/>
	</text:variable-decls>
</xsl:template>

<!-- 
###################################################### 
-->

<!-- 
CREATESTYLES
	This template creates automatic styles that need to be added, e.g.
	due to lists that start at values != 0 or paragraph@roles that are
	not within the roles predefined in the stw file
 -->
<xsl:template name="createstyles">

 <style:default-style style:family="paragraph">
   <style:properties fo:language="en" fo:country="US"/>
 </style:default-style>

	<xsl:for-each select="//list[@startwith &gt; '1']">
		<xsl:variable name="style"><xsl:value-of select="concat('hlp_List',@startwith)"/></xsl:variable>
		<text:list-style style:name="{$style}">
			<text:list-level-style-number text:level="1" text:style-name="Numbering Symbols" style:num-suffix="." style:num-format="1" text:start-value="{@startwith}" />
  </text:list-style>
	</xsl:for-each>

	<xsl:for-each select="//item">
		<xsl:if test="not(contains($defaultcharstyles,@type))">
			<xsl:variable name="style"><xsl:value-of select="concat('hlp_',@type)"/></xsl:variable>
			<xsl:element name="style:style">
				<xsl:attribute name="style:name"><xsl:value-of select="$style"/></xsl:attribute>
				<xsl:attribute name="style:family"><xsl:value-of select="'text'"/></xsl:attribute>
			</xsl:element>
		</xsl:if>
	</xsl:for-each>

	<xsl:for-each select="//paragraph">
		<xsl:if test="not(contains($defaultpararoles,@role))">
			<xsl:variable name="style"><xsl:value-of select="concat('hlp_',@role)"/></xsl:variable>
			<xsl:element name="style:style">
				<xsl:attribute name="style:name"><xsl:value-of select="$style"/></xsl:attribute>
				<xsl:attribute name="style:family"><xsl:value-of select="'paragraph'"/></xsl:attribute>
				<xsl:attribute name="style:parent-style-name"><xsl:value-of select="'hlp_default'"/></xsl:attribute>
			</xsl:element>
		</xsl:if>
	</xsl:for-each>

	

	
<!-- now ensure that all aux styles are available -->
<!--	
	<style:style style:name="hlp_aux_bookmark" style:family="paragraph" style:parent-style-name="hlp_default" style:next-style-name="hlp_default"/>
	<style:style style:name="hlp_aux_switch" style:family="paragraph" style:parent-style-name="hlp_default" style:next-style-name="hlp_default"/>
	<style:style style:name="hlp_aux_comment" style:family="paragraph" style:parent-style-name="hlp_default" style:next-style-name="hlp_default"/>
	<style:style style:name="hlp_aux_embed" style:family="paragraph" style:parent-style-name="hlp_default" style:next-style-name="hlp_default"/>
	<style:style style:name="hlp_aux_imgcaption" style:family="paragraph" style:parent-style-name="hlp_default" style:next-style-name="hlp_default"/>
	<style:style style:name="hlp_aux_imgcaptionattributes" style:family="paragraph" style:parent-style-name="hlp_default" style:next-style-name="hlp_default"/>
	<style:style style:name="hlp_aux_sort" style:family="paragraph" style:parent-style-name="hlp_default" style:next-style-name="hlp_default"/>
	<style:style style:name="hlp_aux_tablecaption" style:family="paragraph" style:parent-style-name="hlp_default" style:next-style-name="hlp_default"/>
	<style:style style:name="hlp_aux_tableattributes" style:family="paragraph" style:parent-style-name="hlp_default" style:next-style-name="hlp_default"/>
	<style:style style:name="hlp_img_loc" style:family="graphics" style:parent-style-name="Graphics" />
	//-->
</xsl:template> 

<xsl:template name="createautostyles">
	<style:style style:name="hlp_table" style:family="table">
		<style:properties fo:margin-top="0.4cm" fo:margin-bottom="0cm" table:align="margins"/>
	</style:style>

	<!--
	<style:style style:name="hlp_aux_section" style:family="section">
		<style:properties fo:background-color="#EEEEEE">
		<style:columns fo:column-count="0" fo:column-gap="0cm"/>
		<style:background-image/>
		</style:properties>
	</style:style>
//-->
</xsl:template>


<xsl:template name="getdepth">
	<xsl:param name="file"/>
	<xsl:param name="relpath"/>
	<xsl:choose>
		<xsl:when test="contains($file,'/')">
			<xsl:call-template name="getdepth">
				<xsl:with-param name="file" select="substring-after($file,'/')"/>
				<xsl:with-param name="relpath" select="concat($relpath,'../')"/>
			</xsl:call-template>
		</xsl:when>
		<xsl:otherwise>
			<xsl:value-of select="concat($relpath,'../../',$imgmodule,'/')"/>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>


</xsl:stylesheet>
