/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: dp_sfwk.cxx,v $
 *
 *  $Revision: 1.10 $
 *
 *  last change: $Author: obo $ $Date: 2006/03/22 11:09:45 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#include "dp_sfwk.hrc"
#include "dp_backend.h"
#include "dp_ucb.h"
#include "dp_parceldesc.hxx"
#include "rtl/uri.hxx"
#include "ucbhelper/content.hxx"
#include "cppuhelper/exc_hlp.hxx"
#include "comphelper/servicedecl.hxx"
#include "svtools/inettype.hxx"
#include <com/sun/star/container/XNameContainer.hpp>
#include <com/sun/star/script/provider/XScriptProviderFactory.hpp>
#include <memory>


using namespace ::dp_misc;
using namespace ::com::sun::star;
using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::ucb;
using namespace ::com::sun::star::script;

using ::rtl::OUString;
namespace css = ::com::sun::star;

namespace dp_registry
{
namespace backend
{
namespace sfwk
{

//==============================================================================
class BackendImpl : public ::dp_registry::backend::PackageRegistryBackend
{
    class PackageImpl : public ::dp_registry::backend::Package
    {
        BackendImpl * getMyBackend() const {
            return static_cast<BackendImpl *>(m_myBackend.get());
        }
        
        Reference< container::XNameContainer > m_xNameCntrPkgHandler;
        OUString m_descr;        
        
        void initPackageHandler();
        
        // Package
        virtual beans::Optional< beans::Ambiguous<sal_Bool> > isRegistered_(
            ::osl::ResettableMutexGuard & guard,
            ::rtl::Reference<AbortChannel> const & abortChannel,
            Reference<XCommandEnvironment> const & xCmdEnv );
        virtual void processPackage_(
            ::osl::ResettableMutexGuard & guard,
            bool registerPackage,
            ::rtl::Reference<AbortChannel> const & abortChannel,
            Reference<XCommandEnvironment> const & xCmdEnv );
        
    public:
        PackageImpl( ::rtl::Reference<BackendImpl> const & myBackend,
                     OUString const & url, OUString const & libType,
                     Reference<XCommandEnvironment> const &xCmdEnv );
        // XPackage
        virtual OUString SAL_CALL getDescription() throw (RuntimeException);
    };
    friend class PackageImpl;
    
    // PackageRegistryBackend
    virtual Reference<deployment::XPackage> bindPackage_(
        OUString const & url, OUString const & mediaType,
        Reference<XCommandEnvironment> const & xCmdEnv );

    const Reference<deployment::XPackageTypeInfo> m_xTypeInfo;
    
public:
    BackendImpl(
        Sequence<Any> const & args,
        Reference<XComponentContext> const & xComponentContext );
    
    // XPackageRegistry
    virtual Sequence< Reference<deployment::XPackageTypeInfo> > SAL_CALL
    getSupportedPackageTypes() throw (RuntimeException);
};

//______________________________________________________________________________
OUString BackendImpl::PackageImpl::getDescription() throw (RuntimeException)
{
    if (m_descr.getLength() == 0)
        return Package::getDescription();
    else
        return m_descr;
}

//______________________________________________________________________________
BackendImpl::PackageImpl::PackageImpl(
    ::rtl::Reference<BackendImpl> const & myBackend,
    OUString const & url, OUString const & libType,
    Reference<XCommandEnvironment> const &xCmdEnv )
    : Package( myBackend.get(), url, OUString(), OUString(),
               myBackend->m_xTypeInfo ),
      m_descr(libType)
{
    initPackageHandler();
    
    sal_Int32 segmEnd = url.getLength();
    if (url.getLength() > 0 && url[ url.getLength() - 1 ] == '/')
        --segmEnd;
    sal_Int32 segmStart = (url.lastIndexOf( '/', segmEnd ) + 1);
    if (segmStart < 0)
        segmStart = 0;
    // name and display name default the same:
    m_displayName = ::rtl::Uri::decode(
        url.copy( segmStart, segmEnd - segmStart ),
        rtl_UriDecodeWithCharset, RTL_TEXTENCODING_UTF8 );
    m_name = m_displayName;

    OSL_TRACE("PakageImpl displayName is %s",
        ::rtl::OUStringToOString( m_displayName , RTL_TEXTENCODING_ASCII_US ).pData->buffer );
}

//______________________________________________________________________________
BackendImpl::BackendImpl(
    Sequence<Any> const & args,
    Reference<XComponentContext> const & xComponentContext )
    : PackageRegistryBackend( args, xComponentContext ),
      m_xTypeInfo( new Package::TypeInfo(
                       OUSTR("application/vnd.sun.star.framework-script"),
                       OUString() /* no file filter */,
                       OUSTR("Scripting Framework Script Library"),
                       RID_IMG_SCRIPTLIB, RID_IMG_SCRIPTLIB_HC ) )
{
    if (! transientMode())
    {
/*
        if (office_is_running())
        {
            Reference<XComponentContext> xContext( getComponentContext() );
            m_xScriptLibs.set(
                xContext->getServiceManager()->createInstanceWithContext(
                    OUSTR("com.sun.star."
                          "script.ApplicationScriptLibraryContainer"),
                    xContext ), UNO_QUERY_THROW );
            m_xDialogLibs.set(
                xContext->getServiceManager()->createInstanceWithContext(
                    OUSTR("com.sun.star."
                          "script.ApplicationDialogLibraryContainer"),
                    xContext ), UNO_QUERY_THROW );
        }
        else
        {
            OUString basic_path(
                m_eContext == CONTEXT_USER
                ? OUSTR("vnd.sun.star.expand:${$SYSBINDIR/"
                        SAL_CONFIGFILE("bootstrap")
                        ":UserInstallation}/user/basic")
                : OUSTR("vnd.sun.star.expand:${$SYSBINDIR/"
                        SAL_CONFIGFILE("bootstrap")
                        ":BaseInstallation}/share/basic") );
            m_basic_script_libs.reset(
                new LibraryContainer(
                    makeURL( basic_path, OUSTR("script.xlc") ),
                    getMutex(),
                    getComponentContext() ) );
            m_dialog_libs.reset(
                new LibraryContainer(
                    makeURL( basic_path, OUSTR("dialog.xlc") ),
                    getMutex(),
                    getComponentContext() ) );
        }
*/
    }
}

// XPackageRegistry
//______________________________________________________________________________
Sequence< Reference<deployment::XPackageTypeInfo> >
BackendImpl::getSupportedPackageTypes() throw (RuntimeException)
{
    return Sequence< Reference<deployment::XPackageTypeInfo> >(&m_xTypeInfo, 1);
}

// PackageRegistryBackend
//______________________________________________________________________________
Reference<deployment::XPackage> BackendImpl::bindPackage_(
    OUString const & url, OUString const & mediaType_,
    Reference<XCommandEnvironment> const & xCmdEnv )
{
    OUString mediaType( mediaType_ );
    if (mediaType.getLength() == 0)
    {
        // detect media-type:
        ::ucb::Content ucbContent;
        if (create_ucb_content( &ucbContent, url, xCmdEnv ) &&
            ucbContent.isFolder())
        {
            // probe for parcel-descriptor.xml:
            if (create_ucb_content(
                    0, makeURL( url, OUSTR("parcel-descriptor.xml") ),
                    xCmdEnv, false /* no throw */ ))
            {
                mediaType = OUSTR("application/vnd.sun.star.framework-script");
            }
        }
        if (mediaType.getLength() == 0)
            throw lang::IllegalArgumentException(
                StrCannotDetectMediaType::get() + url,
                static_cast<OWeakObject *>(this), static_cast<sal_Int16>(-1) );
    }
    
    String type, subType;
    INetContentTypeParameterList params;
    if (INetContentTypes::parse( mediaType, type, subType, &params ))
    {
        if (type.EqualsIgnoreCaseAscii("application"))
        {
            if (subType.EqualsIgnoreCaseAscii("vnd.sun.star.framework-script"))
            {
                OUString lang = OUString::createFromAscii("Script");
                OUString sParcelDescURL = makeURL(
                    url, OUSTR("parcel-descriptor.xml") ); 

                ::ucb::Content ucb_content;

                if (create_ucb_content( &ucb_content, sParcelDescURL,
                        xCmdEnv, false /* no throw */ ))
                {
                    ParcelDescDocHandler* pHandler = 
                        new ParcelDescDocHandler(); 
                    Reference< xml::sax::XDocumentHandler >
                        xDocHandler = pHandler;

                    Reference<XComponentContext>
                        xContext( getComponentContext() );

                    Reference< xml::sax::XParser > xParser(
                      xContext->getServiceManager()->createInstanceWithContext(
                            OUSTR("com.sun.star.xml.sax.Parser"), xContext ), 
                                UNO_QUERY_THROW );

                    xParser->setDocumentHandler( xDocHandler );
                    xml::sax::InputSource source;
                    source.aInputStream = ucb_content.openStream();
                    source.sSystemId = ucb_content.getURL();
                    xParser->parseStream( source );

                    if ( pHandler->isParsed() ) 
                    {
                        lang = pHandler->getParcelLanguage();
                    }
                }

                OUString sfwkLibType = getResourceString( RID_STR_SFWK_LIB );
                // replace %MACRONAME placeholder with language name
                OUString MACRONAME( OUSTR("%MACROLANG" ) );
                sal_Int32 startOfReplace = sfwkLibType.indexOf( MACRONAME );
                sal_Int32 charsToReplace = MACRONAME.getLength();
                sfwkLibType = sfwkLibType.replaceAt( startOfReplace, charsToReplace, lang );
                OSL_TRACE("******************************");
                OSL_TRACE(" BackEnd detected lang = %s  ",
                     rtl::OUStringToOString( lang, RTL_TEXTENCODING_ASCII_US ).getStr() );
                OSL_TRACE(" for url %s",
                     rtl::OUStringToOString( sParcelDescURL, RTL_TEXTENCODING_ASCII_US ).getStr() );
                OSL_TRACE("******************************");
                return new PackageImpl( this, url, sfwkLibType, xCmdEnv );
            }
        }
    }
    throw lang::IllegalArgumentException(
        StrUnsupportedMediaType::get() + mediaType,
        static_cast<OWeakObject *>(this),
        static_cast<sal_Int16>(-1) );
}

//##############################################################################

void BackendImpl::PackageImpl:: initPackageHandler()
{
    if (m_xNameCntrPkgHandler.is())
        return;
    
    BackendImpl * that = getMyBackend();
    Any aContext;

    if ( that->m_eContext == CONTEXT_USER )
    {
        aContext  <<= OUSTR("user");
    } 
    else if ( that->m_eContext == CONTEXT_SHARED )
    {
        aContext  <<= OUSTR("share");
    }
    else
    {
        OSL_ASSERT( 0 );
        // NOT supported at the momemtn // TODO
    }

    Reference< provider::XScriptProviderFactory > xFac( 
        that->getComponentContext()->getValueByName(
            OUSTR( "/singletons/com.sun.star.script.provider.theMasterScriptProviderFactory") ), UNO_QUERY );

    if ( xFac.is() )
    {
        Reference< container::XNameContainer > xName( xFac->createScriptProvider( aContext ), UNO_QUERY );
        if ( xName.is() )
        {
            m_xNameCntrPkgHandler.set( xName );
        }
    }
    // TODO what happens if above fails??
}

// Package
//______________________________________________________________________________
beans::Optional< beans::Ambiguous<sal_Bool> >
BackendImpl::PackageImpl::isRegistered_(
    ::osl::ResettableMutexGuard & guard,
    ::rtl::Reference<AbortChannel> const & abortChannel,
    Reference<XCommandEnvironment> const & xCmdEnv )
{
    return beans::Optional< beans::Ambiguous<sal_Bool> >(
        true /* IsPresent */,
        beans::Ambiguous<sal_Bool>(
            m_xNameCntrPkgHandler.is() && m_xNameCntrPkgHandler->hasByName(
                m_url ),
            false /* IsAmbiguous */ ) );
}

//______________________________________________________________________________
void BackendImpl::PackageImpl::processPackage_(
    ::osl::ResettableMutexGuard & guard,
    bool registerPackage,
    ::rtl::Reference<AbortChannel> const & abortChannel,
    Reference<XCommandEnvironment> const & xCmdEnv )
{
    BackendImpl * that = getMyBackend();

    if ( !m_xNameCntrPkgHandler.is() )
    {
        OSL_TRACE("no package handler!!!!");   
        throw RuntimeException( OUSTR("No package Handler " ), 
            Reference< XInterface >() );
    }     
    
    if (registerPackage)
    {
        // will throw if it fails
        m_xNameCntrPkgHandler->insertByName( m_url, makeAny( Reference< XPackage >(this) ) );

    }
    else // revokePackage()
    {
        m_xNameCntrPkgHandler->removeByName( m_url );
    }
}

namespace sdecl = comphelper::service_decl;
sdecl::class_<BackendImpl, sdecl::with_args<true> > serviceBI;
extern sdecl::ServiceDecl const serviceDecl(
    serviceBI,
    "com.sun.star.comp.deployment.sfwk.PackageRegistryBackend",
    BACKEND_SERVICE_NAME );

} // namespace sfwk
} // namespace backend
} // namespace dp_registry

