/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: re.hxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 15:55:19 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef ARY_RE_HXX
#define ARY_RE_HXX



// USED SERVICES
    // BASE CLASSES
    // COMPONENTS
    // PARAMETERS
#include <cosv/template/dyn.hxx>
#include <ary/ids.hxx>






namespace ary
{
class Host;


namespace n22
{


/** Interface for every class, that is stored within the
    Autodoc Sourcecode Repositoy with an own id.
*/
class RepositoryEntity
{
  public:
    // LIFECYCLE
    virtual             ~RepositoryEntity() {}

    // OPERATIONS
    void                Visit(
                            Host &              io_rHost ) const;
    // INQUIRY
    Rid                 Id() const;
    RCid                ClassId() const;

    // ACCESS
    void                Set_Id(
                            Rid                 i_nId );

  protected:
                        RepositoryEntity()      : nId(0) {}


  private:
    // LOCALS
    virtual void        do_Visit( Host & io_rHost ) const = 0;
    virtual RCid        inq_ClassId() const = 0;

    // DATA
    Rid                 nId;
};



// IMPLEMENTATION

inline void
RepositoryEntity::Visit( Host & io_rHost ) const
    { do_Visit(io_rHost); }

inline Rid
RepositoryEntity::Id() const
    { return nId; }

inline RCid
RepositoryEntity::ClassId() const
    { return inq_ClassId(); }

inline void
RepositoryEntity::Set_Id( Rid i_nId )
    { nId = i_nId; }


}   // namespace n22

template <class SECONDARIES>
inline SECONDARIES &
access_to_2s( Dyn<SECONDARIES> & io_rDyn )
{
    if ( bool(io_rDyn) )
        return io_rDyn.operator*();
    return (io_rDyn = new SECONDARIES).operator*();
}



#if ENABLE_UDM

// Used not here, but in all derived classes:
namespace udm
{
    template <class> class struct_traits;
}


// Macro for implementing udm-specific things

#define IMPL_UDM_GET_TRAITS( traits_type )  \
namespace udm { namespace {     \
typedef traits_type UdmSource;  \
typedef udm::struct_traits<UdmSource> Traits;   \
Traits *   pTraits = 0; }   \
const udm::type_traits<UdmSource> & get_traits( csv::Type2Type<UdmSource> )  \
{   if (pTraits != 0 )  return *pTraits;    \
    return *( pTraits = new Traits( &UdmSource::SetupUdmTraits_ ) );    \
} } const void * pDummy_makeSemicolonPossibleAfterThis = 0

#endif // ENABLE_UDM




    class Display;
    class Documentation;

/**
*/
class RepositoryEntity
{
  public:
    // LIFECYCLE
    virtual             ~RepositoryEntity() {}

    // OPERATIONS
    void                StoreAt(
                            Display &           o_rOut ) const;
    // INQUIRY
    Rid                 Id() const;
    RCid                RC() const;
    const Documentation &
                        Info() const;

    // ACCESS
    void                Add_Documentation(
                            DYN ary::Documentation &
                                                let_drInfo );
    Documentation &     Info()                  { return const_cast< Documentation& >(inq_Info()); }
    
  private:
    virtual void        do_StoreAt(
                            ary::Display &      o_rOut ) const = 0;
    virtual Rid         inq_Id() const = 0;
    virtual RCid        inq_RC() const = 0;
    virtual const Documentation &
                        inq_Info() const = 0;
    virtual void        do_Add_Documentation(
                            DYN ary::Documentation &
                                                let_drInfo ) = 0;
};



// IMPLEMENTATION

inline void
RepositoryEntity::StoreAt( Display & o_rOut ) const
    { do_StoreAt(o_rOut); }
inline Rid
RepositoryEntity::Id() const
    { return inq_Id(); }
inline RCid
RepositoryEntity::RC() const
    { return inq_RC(); }
inline const Documentation &
RepositoryEntity::Info() const
    { return inq_Info(); }    
inline void
RepositoryEntity::Add_Documentation( DYN Documentation & let_drInfo )
    { do_Add_Documentation(let_drInfo); }


}   // namespace ary



#endif

