/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: ConceptGroupGenerator.java,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 16:29:51 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
package com.sun.xmlsearch.qe;

import com.sun.xmlsearch.util.*;

import java.io.InputStream;

class ConceptGroupGenerator implements CompressorIterator {
  private static final int NConceptsInGroup =
  DocumentCompressor.NConceptsInGroup;
  private static final int BitsInLabel =
  DocumentCompressor.BitsInLabel;
  
  private int           _last;
  private ConceptData[] _table;
  private Decompressor    _bits;
  private int          _k1;
  private final int     _k2 = BitsInLabel;
  private ConceptData  _cData;

  public ConceptGroupGenerator() {
    _k1 = 0;
    _table = new ConceptData[NConceptsInGroup];
    _last = 0;
    _bits = null;
  }
    
  public ConceptGroupGenerator(byte[] bytes, int index, int k) {
    _k1 = k;
    _table = new ConceptData[NConceptsInGroup];
    _last = 0;
    _bits = new ByteArrayDecompressor(bytes, index);
  }

  public void init(byte[] bytes, int index, int k) {
    _k1 = k;
    _bits = new ByteArrayDecompressor(bytes, index);
    _last = 0;
    for (int i = 0; i < NConceptsInGroup; i++)
      _table[i] = null;
  }

  public void addTerms(int index, ConceptData terms) {
    _table[index] = terms;
  }

  public int decodeConcepts(int k, int shift, int[] concepts) throws Exception {
    return _bits.ascendingDecode(k, shift, concepts);
  }

  public int position() {
    return _last;
  }
  
  public void value(int value) {
    _last += value;
  }
  
  public boolean next() throws Exception {
    while (_bits.readNext(_k1, this))
      if ((_cData = _table[_bits.read(_k2)]) != null)
	return true;
    return false;
  }
  
  public void generateFillers(RoleFiller[] array) {
    _cData.generateFillers(array, _last);
  }
}
