/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: fmtftn.hxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 16:04:24 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#ifndef _FMTFTN_HXX
#define _FMTFTN_HXX


// auto strip #ifndef _STRING_HXX //autogen
// auto strip #include <tools/string.hxx>
// auto strip #endif
#ifndef _SFXPOOLITEM_HXX //autogen
#include <svtools/poolitem.hxx>
#endif
namespace binfilter {

class SwDoc;
class SwTxtFtn;

// ATT_FTN **********************************************************

class SwFmtFtn: public SfxPoolItem
{
	friend class SwTxtFtn;
	SwTxtFtn* pTxtAttr;		//mein TextAttribut
	String  aNumber;		//Benutzerdefinierte 'Nummer'
	USHORT  nNumber;		//Automatische Nummerierung
	BOOL	bEndNote;		//Ist es eine Endnote?

	// geschuetzter CopyCtor
	SwFmtFtn& operator=(const SwFmtFtn& rFtn);
	SwFmtFtn( const SwFmtFtn& );

public:
	SwFmtFtn( BOOL bEndNote = FALSE );
	~SwFmtFtn();

	// "pure virtual Methoden" vom SfxPoolItem
	virtual int             operator==( const SfxPoolItem& ) const;
	virtual SfxPoolItem*	Clone( SfxItemPool* pPool = 0 ) const;
	virtual SfxPoolItem*	Create(SvStream &, USHORT nVer) const;
	virtual SvStream&		Store(SvStream &, USHORT nIVer) const;
	virtual USHORT			GetVersion( USHORT nFFVer ) const;

	const String &GetNumStr() const { return aNumber; }
	const USHORT &GetNumber() const { return nNumber; }
		  BOOL	  IsEndNote() const	{ return bEndNote;}

	void SetNumStr( const String& rStr )	{ aNumber = rStr; }
	void SetNumber( USHORT nNo ) 			{ nNumber = nNo; }
//STRIP001 	void SetEndNote( BOOL b );

	void SetNumber( const SwFmtFtn& rFtn )
		{ nNumber = rFtn.nNumber; aNumber = rFtn.aNumber; }

	const SwTxtFtn *GetTxtFtn() const   { return pTxtAttr; }
		  SwTxtFtn *GetTxtFtn()	  		{ return pTxtAttr; }

//STRIP001 	void GetFtnText( String& rStr ) const;

	// returnt den anzuzeigenden String der Fuss-/Endnote
	String GetViewNumStr( const SwDoc& rDoc, BOOL bInclStrs = FALSE ) const;
};


} //namespace binfilter
#endif

