/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: stbmgr.hxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 12:40:20 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#ifndef _SFXSTBMGR_HXX
#define _SFXSTBMGR_HXX

#ifndef _STATUS_HXX //autogen
#include <vcl/status.hxx>
#endif
#ifndef _SFXLSTNER_HXX //autogen
#include <svtools/lstner.hxx>
#endif

#include <framework/statusbarconfiguration.hxx>

#include <bf_sfx2/app.hxx>
#include <bf_sfx2/cfgitem.hxx>
namespace binfilter {

//--------------------------------------------------------------------

class SfxStatusItemArr_Impl;
class SfxStatusItemInfArr_Impl;
class SfxStatusBarControl;
class SfxBindings;

//--------------------------------------------------------------------

class SfxStatusBarManager: public SfxConfigItem, public SfxListener
{
friend class SfxStatusBar_Impl;

	StatusBar*					pBar;
	SfxStatusItemArr_Impl*		pBoundItems;
	SfxBindings*				pBindings;
	ULONG						nMaxProgress;
	SfxStatusItemInfArr_Impl*	pItems;
	SfxShell*					pShell;

private:
#if _SOLAR__PRIVATE
    BOOL                        Store( SvStream& rStream );
    int                         Load( SvStream& rStream );
	void						Construct();
	SfxStatusBarControl*		FindControl_Impl( USHORT nId ) const;
//STRIP001 	void						Clear_Impl();
#endif

public:
					SfxStatusBarManager( Window* pParent, SfxBindings&,
						SfxShell*, SfxConfigManager*, USHORT nId=SFX_ITEMTYPE_STATBAR,
						StatusBar*p=NULL );
//STRIP001                     SfxStatusBarManager( Window* pParent, const SfxStatusBarManager& rOther, SfxConfigManager* );
					~SfxStatusBarManager();

	static BOOL     Import( SvStream& rInStream, SvStream& rOutStream );
    static BOOL     Export( SvStream& rInStream, SvStream& rOutStream );

    virtual BOOL    Store( SotStorage& rStream );
    virtual int     Load( SotStorage& rStream );
	virtual	void	UseDefault();
    virtual String  GetStreamName() const{DBG_BF_ASSERT(0, "STRIP"); return String();} //STRIP001 virtual String  GetStreamName() const;
	StatusBar*		GetStatusBar() const
					{ return pBar; }

//STRIP001 	BOOL			AddItem( USHORT nItemId, long nWidth,
//STRIP001 							USHORT nOffset = STATUSBAR_OFFSET,
//STRIP001 							USHORT nPos = STATUSBAR_APPEND );

//STRIP001 	void			RemoveItem( USHORT nItemId);
//STRIP001 	void			SetItemWidth (USHORT nId, long nWidth);
	USHORT			GetItemPos(USHORT nId)
						{ return pBar->GetItemPos(nId); }

//STRIP001 	void			Clear();
//STRIP001 	void			Show();
//STRIP001 	void			Hide();
//STRIP001 	void			DestroyingBindings(SfxBindings*);

	BOOL			IsVisible() const
						{ return pBar->IsVisible(); }
	long			GetWidth( const String& rStr ) const
						{ return pBar->GetTextWidth(rStr); }

	// Beginn Fortschrittsanzeige
	void			StartProgressMode(const String &rText, ULONG nMax);
	// Status Fortschrittsanzeige
	void			SetProgressState(ULONG nVal);
	void			EndProgressMode();
	void            SetProgressMaxValue(ULONG nVal){nMaxProgress=nVal;}
	BOOL			IsProgressMode() const { return pBar->IsProgressMode(); }
	// Hilfetext anzeigen
//STRIP001 	void			ShowHelpText(const String &rText );
	// Items anzeigen
	void			ShowItems()
						{ pBar->ShowItems(); }

	virtual void 	SFX_NOTIFY( SfxBroadcaster& rBC, const TypeId& rBCType,
						 const SfxHint& rHint, const TypeId& rHintType );
#if _SOLAR__PRIVATE
	SfxBindings*	GetBindings_Impl()
					{ return pBindings; }
#endif
};

}//end of namespace binfilter
#endif
