/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: wizag.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 07:23:50 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _WIZAG_HXX
#define _WIZAG_HXX

#ifndef _DYNARY_HXX //autogen
#include <tools/dynary.hxx>
#endif

#include "wizagdlg.hxx"
#include "wizgo.hxx"

#ifndef _WIZCFG_HXX
#include <wizcfg.hxx>
#endif
namespace binfilter {

class AgenDialog;

struct AgendaRec {
	String 		aThem;   // Das Thema
	String 		aName;   // Name des Verantwortlichen
	sal_Int32 	nZeit;   // Zeitdauer in Minuten
};

typedef AgendaRec* AgendaRecPtr;

DECLARE_DYNARRAY(AgendaArray_Impl,AgendaRecPtr)//STRIP008 ;

class AgendaArray : private AgendaArray_Impl {
	USHORT nUsedSiz;
private:
	void ForceSize(USHORT nSiz);
public:
	AgendaArray();
	~AgendaArray();
	USHORT GetAnz() { return nUsedSiz; }
	void Trim();
	void GetRec(USHORT nNum, AgendaRec& rRec);
	void SetThm(USHORT nNum, const String& pThm);
	void SetNam(USHORT nNum, const String& pNam);
	void SetTim(USHORT nNum, sal_Int32 nTim);
	void XChange(USHORT a, USHORT b);
};

/*
class MyEdit: public Edit {
	AgenDialog* pDlg;
public:
	MyEdit(AgenDialog* pParent, ResId& rResId);
	virtual void GetFocus();
	virtual void LoseFocus();
	virtual void KeyInput(const KeyEvent rKey);
};
*/

struct AgendaDlgRec {
	FixedText*    pPkt;
	SpinField*    pThm;
	SpinField*    pNam;
	NumericField* pTim;
};

#define DIALOGLINES 6
class AgenList
{
friend AgenDialog;
	AgendaDlgRec aRec[DIALOGLINES];
	AgenDialog*  pDlg;
	ScrollBar*   pScrl;
	USHORT       nArrOfs;
private:
	void InitUI();
	void InitUIArr();
	void SetScrollBarSizes();
	void ScrollUpdate();
	USHORT GetUILine(Edit* pEdt);
	void   UIToArr(USHORT nUILin);
	void MoveCursor(USHORT nArrLin);
	void SetEventHandler();
	DECL_LINK( ModifyHdl, Edit * );
	DECL_LINK( ScrollHdl, ScrollBar * );
	void UpDownHdl(PushButton* pBtn);
	void SelectHdl(ListBox* pLst);
	DECL_LINK( SpinUpHdl, SpinField * );
	DECL_LINK( SpinDnHdl, SpinField * );
	DECL_LINK( GetFocus3Hdl, Control * );
	DECL_LINK( LosFocus3Hdl, Control * );
	DECL_LINK( GetFocus4Hdl, Control * );
	DECL_LINK( LosFocus4Hdl, Control * );
public:
	AgenList(AgenDialog& rDlg);
	void ToUI();
	void MoveUp(USHORT nNum);
	void MoveDn(USHORT nNum);
	USHORT GetAnz();
	void GetRec(USHORT nNum, AgendaRec& rRec);
	AgendaArray& GetArray();
};

class AgenDialog: public WizardAgenDialog, private WizardGo
{
friend AgenList;
	WizardAgenPage 		aPage1;
	SwAgendaWizardCfg   aConfig;
	AgenList       		aList;

public:
	AgenDialog(Window* pParent);
	virtual void Fill(USHORT StepNum, MultiOne& WinArr);
	virtual BOOL Possible(USHORT StepNum);
	virtual void Enter(USHORT StepNum);
	virtual void Leave(USHORT StepNum);

	void GetFromIni();  // Defaults vom Inifile holen

	virtual void WriteToIni();
	virtual BOOL MakeDoc();

	void ToUI();        // Logo, Titel
	void LogoToUI();    // Logodateiname, Buttontext

	void ArrangeObjects();
	void CheckTitel();
	void CheckElements();
	void FillDocInfoList();
	BOOL   GetDocInfOn(USHORT nNum);
	String GetDocInfStr(USHORT nNum);
	BOOL   GetDocInfStrOk(USHORT nNum);

	void SetEventHandler();
	DECL_LINK( StyleClickHdl, RadioButton * );
	DECL_LINK( CheckHdl, CheckBox * );
	DECL_LINK( GrfBtnHdl, PushButton * );
	DECL_LINK( TitlModHdl, Edit * );
	DECL_LINK( LogoClickHdl, CheckBox * );

private:
	void GetTimeRange(String& rStr, USHORT nNum=0xFFFF);
	void CreateMacro();
	void SaveMacro();
	void InsLogoAgen();
	void InsLogoProt();
	void InsTitl(char cAdd);
	void InsDatm(char cAdd);
	void InsElem(char cAdd);
	void InsBmrk(char cAdd);
	void InsAgen();
	void InsProt();
	void DeleteProtocoll();
	void InsDocInfBookmark(USHORT nElemNum);
};


} //namespace binfilter
#endif  //_WIZAG_HXX
