/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sw_frmmgr.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 05:14:37 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
namespace binfilter {


//STRIP001 #pragma hdrstop
//STRIP001 
//STRIP001 #include "cmdid.h"
//STRIP001 #ifndef _UIPARAM_HXX
//STRIP001 #include <uiparam.hxx>
//STRIP001 #endif
//STRIP001 #include "hintids.hxx"
//STRIP001 
//STRIP001 
//STRIP001 #ifndef _SFXSTRITEM_HXX //autogen
//STRIP001 #include <svtools/stritem.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _SVX_PROTITEM_HXX //autogen
//STRIP001 #include <bf_svx/protitem.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _SVX_BOXITEM_HXX //autogen
//STRIP001 #include <bf_svx/boxitem.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _SVX_OPAQITEM_HXX //autogen
//STRIP001 #include <bf_svx/opaqitem.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _SVX_LRSPITEM_HXX //autogen
//STRIP001 #include <bf_svx/lrspitem.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _SVX_ULSPITEM_HXX //autogen
//STRIP001 #include <bf_svx/ulspitem.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _SVX_SHADITEM_HXX //autogen
//STRIP001 #include <bf_svx/shaditem.hxx>
//STRIP001 #endif
//STRIP001 
//STRIP001 
//STRIP001 #ifndef _FMTCLDS_HXX //autogen
//STRIP001 #include <fmtclds.hxx>
//STRIP001 #endif
//STRIP001 #include "wrtsh.hxx"
//STRIP001 #include "view.hxx"
//STRIP001 #include "viewopt.hxx"
//STRIP001 #include "uitool.hxx"
//STRIP001 #include "frmmgr.hxx"
//STRIP001 #include "format.hxx"
//STRIP001 #include "mdiexp.hxx"
//STRIP001 #include "poolfmt.hxx"
//STRIP001 
//STRIP001 static USHORT __FAR_DATA aFrmMgrRange[] = {
//STRIP001 							RES_FRMATR_BEGIN, RES_FRMATR_END-1,
//STRIP001 							SID_ATTR_BORDER_INNER, SID_ATTR_BORDER_INNER,
//STRIP001 							FN_SET_FRM_NAME, FN_SET_FRM_NAME,
//STRIP001 							0};
//STRIP001 
//STRIP001 /*--------------------------------------------------------------------
//STRIP001 	 Beschreibung: Rahmen-Attribute ueber Shell ermitteln
//STRIP001  --------------------------------------------------------------------*/
//STRIP001 
//STRIP001 SwFlyFrmAttrMgr::SwFlyFrmAttrMgr( BOOL bNew, SwWrtShell* pSh, BYTE nType ) :
//STRIP001 	bAbsPos( FALSE ),
//STRIP001 	bNewFrm( bNew ),
//STRIP001     bIsInVertical( FALSE ),
//STRIP001 	aSet( (SwAttrPool&)pSh->GetAttrPool(), aFrmMgrRange ),
//STRIP001 	pOwnSh( pSh )
//STRIP001 
//STRIP001 {
//STRIP001 	if ( bNewFrm )
//STRIP001 	{
//STRIP001 		// Defaults einstellen:
//STRIP001 		USHORT nId;
//STRIP001 		switch ( nType )
//STRIP001 		{
//STRIP001 			case FRMMGR_TYPE_TEXT:	nId = RES_POOLFRM_FRAME;	break;
//STRIP001 			case FRMMGR_TYPE_OLE:	nId = RES_POOLFRM_OLE;		break;
//STRIP001 			case FRMMGR_TYPE_GRF:	nId = RES_POOLFRM_GRAPHIC;	break;
//STRIP001 		}
//STRIP001 		aSet.SetParent( &pOwnSh->GetFmtFromPool( nId )->GetAttrSet());
//STRIP001 		aSet.Put( SwFmtFrmSize( ATT_MIN_SIZE, DFLT_WIDTH, DFLT_HEIGHT ));
//STRIP001 		if ( 0 != ::binfilter::GetHtmlMode(pSh->GetView().GetDocShell()) )
//STRIP001 			aSet.Put( SwFmtHoriOrient( 0, HORI_LEFT, PRTAREA ) );
//STRIP001 	}
//STRIP001 	else if ( nType == FRMMGR_TYPE_NONE )
//STRIP001     {
//STRIP001 		pOwnSh->GetFlyFrmAttr( aSet );
//STRIP001         BOOL bRightToLeft;
//STRIP001         bIsInVertical = pOwnSh->IsFrmVertical(TRUE, bRightToLeft);
//STRIP001     }
//STRIP001 	::PrepareBoxInfo( aSet, *pOwnSh );
//STRIP001 }
//STRIP001 
//STRIP001 SwFlyFrmAttrMgr::SwFlyFrmAttrMgr( BOOL bNew, SwWrtShell* pSh, const SfxItemSet &rSet ) :
//STRIP001 	bAbsPos( FALSE ),
//STRIP001 	bNewFrm( bNew ),
//STRIP001 	aSet( rSet ),
//STRIP001 	pOwnSh( pSh ),
//STRIP001 	bIsInVertical(FALSE)
//STRIP001 {
//STRIP001 	if(!bNew)
//STRIP001 	{
//STRIP001 		BOOL bRightToLeft;
//STRIP001         bIsInVertical = pSh->IsFrmVertical(TRUE, bRightToLeft);
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 /*--------------------------------------------------------------------
//STRIP001 	 Beschreibung:	Initialisieren
//STRIP001  --------------------------------------------------------------------*/
//STRIP001 
//STRIP001 void SwFlyFrmAttrMgr::UpdateAttrMgr()
//STRIP001 {
//STRIP001 	if ( !bNewFrm && pOwnSh->IsFrmSelected() )
//STRIP001 		pOwnSh->GetFlyFrmAttr( aSet );
//STRIP001 	::PrepareBoxInfo( aSet, *pOwnSh );
//STRIP001 }
//STRIP001 
//STRIP001 void SwFlyFrmAttrMgr::_UpdateFlyFrm()
//STRIP001 {
//STRIP001 	const SfxPoolItem* pItem = 0;
//STRIP001 
//STRIP001 	if (aSet.GetItemState(FN_SET_FRM_NAME, FALSE, &pItem) == SFX_ITEM_SET)
//STRIP001 		pOwnSh->SetFlyName(((SfxStringItem *)pItem)->GetValue());
//STRIP001 
//STRIP001 	pOwnSh->SetModified();
//STRIP001 
//STRIP001 	if ( bAbsPos )
//STRIP001 	{
//STRIP001 		pOwnSh->SetFlyPos( aAbsPos );
//STRIP001 		bAbsPos = FALSE;
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 /*--------------------------------------------------------------------
//STRIP001 	Beschreibung: Bestehenden Fly-Frame aendern
//STRIP001  --------------------------------------------------------------------*/
//STRIP001 
//STRIP001 void SwFlyFrmAttrMgr::UpdateFlyFrm()
//STRIP001 {
//STRIP001 	ASSERT( pOwnSh->IsFrmSelected(),
//STRIP001 		"Kein Rahmen selektiert oder keine Shell, Update nicht moeglich");
//STRIP001 
//STRIP001 	if( pOwnSh->IsFrmSelected() )
//STRIP001 	{
//STRIP001 		//JP 6.8.2001: set never an invalid anchor into the core.
//STRIP001 		const SfxPoolItem *pGItem, *pItem;
//STRIP001 		if( SFX_ITEM_SET == aSet.GetItemState( RES_ANCHOR, FALSE, &pItem ))
//STRIP001 		{
//STRIP001 			SfxItemSet aGetSet( *aSet.GetPool(), RES_ANCHOR, RES_ANCHOR );
//STRIP001 			if( pOwnSh->GetFlyFrmAttr( aGetSet ) && 1 == aGetSet.Count() &&
//STRIP001 				SFX_ITEM_SET == aGetSet.GetItemState( RES_ANCHOR, FALSE, &pGItem )
//STRIP001 				&& ((SwFmtAnchor*)pGItem)->GetAnchorId() ==
//STRIP001 				   ((SwFmtAnchor*)pItem)->GetAnchorId() )
//STRIP001 				aSet.ClearItem( RES_ANCHOR );
//STRIP001 		}
//STRIP001 
//STRIP001 		// return wg. BASIC
//STRIP001 		if( aSet.Count() )
//STRIP001 		{
//STRIP001 			pOwnSh->StartAllAction();
//STRIP001 			pOwnSh->SetFlyFrmAttr( aSet );
//STRIP001 			_UpdateFlyFrm();
//STRIP001 			pOwnSh->EndAllAction();
//STRIP001 		}
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 /*--------------------------------------------------------------------
//STRIP001 	 Beschreibung:	Rahmen einfuegen
//STRIP001  --------------------------------------------------------------------*/
//STRIP001 
//STRIP001 BOOL SwFlyFrmAttrMgr::InsertFlyFrm()
//STRIP001 {
//STRIP001 	pOwnSh->StartAllAction();
//STRIP001 
//STRIP001 	BOOL bRet = 0 != pOwnSh->NewFlyFrm( aSet );
//STRIP001 
//STRIP001 	// richtigen Mode an der Shell einschalten, Rahmen wurde aut. selektiert.
//STRIP001 	if ( bRet )
//STRIP001 	{
//STRIP001 		_UpdateFlyFrm();
//STRIP001 		pOwnSh->EnterSelFrmMode();
//STRIP001 		FrameNotify(pOwnSh, FLY_DRAG_START);
//STRIP001 	}
//STRIP001 	pOwnSh->EndAllAction();
//STRIP001 	return bRet;
//STRIP001 }
//STRIP001 
//STRIP001 /*------------------------------------------------------------------------
//STRIP001  Beschreibung:	Rahmen des Typs eAnchorType einfuegen. Position und
//STRIP001 				Groesse werden explizit angegeben.
//STRIP001 				Nicht erlaubte Werte des Aufzaehlungstypes werden
//STRIP001 				korrigiert.
//STRIP001 ------------------------------------------------------------------------*/
//STRIP001 
//STRIP001 void SwFlyFrmAttrMgr::InsertFlyFrm(RndStdIds	eAnchorType,
//STRIP001 								   const Point	&rPos,
//STRIP001 								   const Size	&rSize,
//STRIP001 								   BOOL bAbs )
//STRIP001 {
//STRIP001 	ASSERT( eAnchorType == FLY_PAGE		||
//STRIP001 			eAnchorType == FLY_AT_CNTNT ||
//STRIP001 			eAnchorType == FLY_AUTO_CNTNT ||
//STRIP001 			eAnchorType == FLY_AT_FLY ||
//STRIP001 			eAnchorType == FLY_IN_CNTNT, "Rahmentyp nicht erlaubt" );
//STRIP001 
//STRIP001 	if ( bAbs )
//STRIP001 		SetAbsPos( rPos );
//STRIP001 	else
//STRIP001 		SetPos( rPos );
//STRIP001 
//STRIP001 	SetSize( rSize );
//STRIP001 	SetAnchor( eAnchorType );
//STRIP001 	InsertFlyFrm();
//STRIP001 }
//STRIP001 
//STRIP001 /*--------------------------------------------------------------------
//STRIP001 	 Beschreibung:	Anker setzen
//STRIP001  --------------------------------------------------------------------*/
//STRIP001 
//STRIP001 void SwFlyFrmAttrMgr::SetAnchor( RndStdIds eId )
//STRIP001 {
//STRIP001 	USHORT nPhyPageNum, nVirtPageNum;
//STRIP001 	pOwnSh->GetPageNum( nPhyPageNum, nVirtPageNum );
//STRIP001 
//STRIP001 	aSet.Put( SwFmtAnchor( eId, nPhyPageNum ) );
//STRIP001 	if( FLY_PAGE == eId || FLY_AT_CNTNT == eId || FLY_AUTO_CNTNT == eId
//STRIP001 		|| FLY_AT_FLY == eId )
//STRIP001 	{
//STRIP001 		SwFmtVertOrient aVertOrient( GetVertOrient() );
//STRIP001 		SwFmtHoriOrient aHoriOrient( GetHoriOrient() );
//STRIP001 		aHoriOrient.SetRelationOrient( FRAME );
//STRIP001 		aVertOrient.SetRelationOrient( FRAME );
//STRIP001 		aSet.Put( aVertOrient );
//STRIP001 		aSet.Put( aHoriOrient );
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 /*------------------------------------------------------------------------
//STRIP001  Beschreibung:	Setzen des Attributs fuer Spalten
//STRIP001 ------------------------------------------------------------------------*/
//STRIP001 
//STRIP001 void SwFlyFrmAttrMgr::SetCol( const SwFmtCol &rCol )
//STRIP001 {
//STRIP001 	aSet.Put( rCol );
//STRIP001 }
//STRIP001 /*--------------------------------------------------------------------
//STRIP001 	 Beschreibung:	Absolute Position setzen
//STRIP001  --------------------------------------------------------------------*/
//STRIP001 
//STRIP001 void SwFlyFrmAttrMgr::SetAbsPos( const Point& rPoint )
//STRIP001 {
//STRIP001 	bAbsPos = TRUE;
//STRIP001 	aAbsPos = rPoint;
//STRIP001 
//STRIP001 	SwFmtVertOrient aVertOrient( GetVertOrient() );
//STRIP001 	SwFmtHoriOrient aHoriOrient( GetHoriOrient() );
//STRIP001 	aHoriOrient.SetHoriOrient( HORI_NONE );
//STRIP001 	aVertOrient.SetVertOrient( VERT_NONE );
//STRIP001 	aSet.Put( aVertOrient );
//STRIP001 	aSet.Put( aHoriOrient );
//STRIP001 }
//STRIP001 
//STRIP001 /*--------------------------------------------------------------------
//STRIP001 	Beschreibung: Metriken auf Korrektheit pruefen
//STRIP001  --------------------------------------------------------------------*/
//STRIP001 
//STRIP001 void SwFlyFrmAttrMgr::ValidateMetrics( SwFrmValid& rVal, BOOL bOnlyPercentRefValue )
//STRIP001 {
//STRIP001 	if (!bOnlyPercentRefValue)
//STRIP001 	{
//STRIP001 		rVal.nMinHeight = MINFLY + CalcTopSpace() + CalcBottomSpace();
//STRIP001 		rVal.nMinWidth =  MINFLY + CalcLeftSpace()+ CalcRightSpace();
//STRIP001 	}
//STRIP001 
//STRIP001 	SwRect aBoundRect;
//STRIP001 
//STRIP001 	pOwnSh->CalcBoundRect(aBoundRect, rVal.eArea, rVal.eHRel, rVal.bMirror, NULL, &rVal.aPercentSize);
//STRIP001 
//STRIP001 	if (bOnlyPercentRefValue)
//STRIP001 		return;
//STRIP001 
//STRIP001     if(bIsInVertical)
//STRIP001     {
//STRIP001         Point aPos(aBoundRect.Pos());
//STRIP001         long nTmp = aPos.X();
//STRIP001         aPos.X() = aPos.Y();
//STRIP001         aPos.Y() = nTmp;
//STRIP001         Size aSize(aBoundRect.SSize());
//STRIP001         nTmp = aSize.Width();
//STRIP001         aSize.Width() = aSize.Height();
//STRIP001         aSize.Height() = nTmp;
//STRIP001         aBoundRect.Chg( aPos, aSize );
//STRIP001         //exchange width/height to enable correct values
//STRIP001         nTmp = rVal.nWidth;
//STRIP001         rVal.nWidth = rVal.nHeight;
//STRIP001         rVal.nHeight = nTmp;
//STRIP001     }
//STRIP001     if ( rVal.eArea == FLY_PAGE || rVal.eArea == FLY_AT_FLY )
//STRIP001 	{
//STRIP001 		// MinimalPosition
//STRIP001 		rVal.nMinHPos = aBoundRect.Left();
//STRIP001 		rVal.nMinVPos = aBoundRect.Top();
//STRIP001 		SwTwips nH = rVal.nHPos;
//STRIP001 		SwTwips nV = rVal.nVPos;
//STRIP001 
//STRIP001 		if (rVal.nHPos + rVal.nWidth > aBoundRect.Right())
//STRIP001 		{
//STRIP001 			if (rVal.eHori == HORI_NONE)
//STRIP001 			{
//STRIP001 				rVal.nHPos -= ((rVal.nHPos + rVal.nWidth) - aBoundRect.Right());
//STRIP001 				nH = rVal.nHPos;
//STRIP001 			}
//STRIP001 			else
//STRIP001 				rVal.nWidth = aBoundRect.Right() - rVal.nHPos;
//STRIP001 		}
//STRIP001 
//STRIP001 		if (rVal.nHPos + rVal.nWidth > aBoundRect.Right())
//STRIP001 			rVal.nWidth = aBoundRect.Right() - rVal.nHPos;
//STRIP001 
//STRIP001 		if (rVal.nVPos + rVal.nHeight > aBoundRect.Bottom())
//STRIP001 		{
//STRIP001 			if (rVal.eVert == SVX_VERT_NONE)
//STRIP001 			{
//STRIP001 				rVal.nVPos -= ((rVal.nVPos + rVal.nHeight) - aBoundRect.Bottom());
//STRIP001 				nV = rVal.nVPos;
//STRIP001 			}
//STRIP001 			else
//STRIP001 				rVal.nHeight = aBoundRect.Bottom() - rVal.nVPos;
//STRIP001 		}
//STRIP001 
//STRIP001 		if (rVal.nVPos + rVal.nHeight > aBoundRect.Bottom())
//STRIP001 			rVal.nHeight = aBoundRect.Bottom() - rVal.nVPos;
//STRIP001 
//STRIP001 		if ( rVal.eVert != SVX_VERT_NONE )
//STRIP001 			nV = aBoundRect.Top();
//STRIP001 
//STRIP001 		if ( rVal.eHori != HORI_NONE )
//STRIP001 			nH = aBoundRect.Left();
//STRIP001 
//STRIP001 		rVal.nMaxHPos	= aBoundRect.Right()  - rVal.nWidth;
//STRIP001 		rVal.nMaxHeight = aBoundRect.Bottom() - nV;
//STRIP001 
//STRIP001 		rVal.nMaxVPos	= aBoundRect.Bottom() - rVal.nHeight;
//STRIP001 		rVal.nMaxWidth	= aBoundRect.Right()  - nH;
//STRIP001 	}
//STRIP001 	else if ( rVal.eArea == FLY_AT_CNTNT || rVal.eArea == FLY_AUTO_CNTNT )
//STRIP001 	{
//STRIP001 		SwTwips nH = rVal.nHPos;
//STRIP001 		SwTwips nV = rVal.nVPos;
//STRIP001 
//STRIP001 		if (rVal.nHPos + rVal.nWidth > aBoundRect.Right())
//STRIP001 		{
//STRIP001 			if (rVal.eHori == HORI_NONE)
//STRIP001 			{
//STRIP001 				rVal.nHPos -= ((rVal.nHPos + rVal.nWidth) - aBoundRect.Right());
//STRIP001 				nH = rVal.nHPos;
//STRIP001 			}
//STRIP001 			else
//STRIP001 				rVal.nWidth = aBoundRect.Right() - rVal.nHPos;
//STRIP001 		}
//STRIP001 
//STRIP001 		if (rVal.nVPos + rVal.nHeight > aBoundRect.Bottom())
//STRIP001 		{
//STRIP001 			if (rVal.eVert == SVX_VERT_NONE)
//STRIP001 			{
//STRIP001 				rVal.nVPos -= ((rVal.nVPos + rVal.nHeight) - aBoundRect.Bottom());
//STRIP001 				nV = rVal.nVPos;
//STRIP001 			}
//STRIP001 			else
//STRIP001 				rVal.nHeight = aBoundRect.Bottom() - rVal.nVPos;
//STRIP001 		}
//STRIP001 
//STRIP001 		if ( rVal.eVert != SVX_VERT_NONE )
//STRIP001 			nV = aBoundRect.Top();
//STRIP001 
//STRIP001 		if ( rVal.eHori != HORI_NONE )
//STRIP001 			nH = aBoundRect.Left();
//STRIP001 
//STRIP001 		rVal.nMinVPos  = aBoundRect.Top();
//STRIP001 		rVal.nMaxVPos  = aBoundRect.Height() - rVal.nHeight;
//STRIP001 
//STRIP001 		rVal.nMinHPos  = aBoundRect.Left();
//STRIP001 		rVal.nMaxHPos  = aBoundRect.Right() - rVal.nWidth;
//STRIP001 
//STRIP001 		// Maximale Breite Hoehe
//STRIP001 		rVal.nMaxHeight  = rVal.nMaxVPos + rVal.nHeight - nV;
//STRIP001 		rVal.nMaxWidth	 = rVal.nMaxHPos + rVal.nWidth - nH;
//STRIP001 	}
//STRIP001 	else if ( rVal.eArea == FLY_IN_CNTNT )
//STRIP001 	{
//STRIP001 		rVal.nMinHPos = 0;
//STRIP001 		rVal.nMaxHPos = 0;
//STRIP001 
//STRIP001 		rVal.nMaxHeight = aBoundRect.Height();
//STRIP001 		rVal.nMaxWidth	= aBoundRect.Width();
//STRIP001 
//STRIP001 		rVal.nMaxVPos	= aBoundRect.Height();
//STRIP001 		rVal.nMinVPos	= -aBoundRect.Height() + rVal.nHeight;
//STRIP001 		if (rVal.nMaxVPos < rVal.nMinVPos)
//STRIP001 		{
//STRIP001 			rVal.nMinVPos = rVal.nMaxVPos;
//STRIP001 			rVal.nMaxVPos = -aBoundRect.Height();
//STRIP001 		}
//STRIP001 	}
//STRIP001     if(bIsInVertical)
//STRIP001     {
//STRIP001         //restore width/height exchange
//STRIP001         long nTmp = rVal.nWidth;
//STRIP001         rVal.nWidth = rVal.nHeight;
//STRIP001         rVal.nHeight = nTmp;
//STRIP001     }
//STRIP001 
//STRIP001     if (rVal.nMaxWidth < rVal.nWidth)
//STRIP001 		rVal.nWidth = rVal.nMaxWidth;
//STRIP001 	if (rVal.nMaxHeight < rVal.nHeight)
//STRIP001 		rVal.nHeight = rVal.nMaxHeight;
//STRIP001 }
//STRIP001 
//STRIP001 /*--------------------------------------------------------------------
//STRIP001 	Beschreibung: Korrektur fuer Umrandung
//STRIP001  --------------------------------------------------------------------*/
//STRIP001 
//STRIP001 long SwFlyFrmAttrMgr::CalcWidthSpace()
//STRIP001 {
//STRIP001 	SvxLRSpaceItem &rLR = (SvxLRSpaceItem&)aSet.Get(RES_LR_SPACE);
//STRIP001 	return rLR.GetLeft() + rLR.GetRight() + CalcLeftSpace() + CalcRightSpace();
//STRIP001 }
//STRIP001 
//STRIP001 long SwFlyFrmAttrMgr::CalcHeightSpace()
//STRIP001 {
//STRIP001 	SvxULSpaceItem &rUL = (SvxULSpaceItem&)aSet.Get(RES_UL_SPACE);
//STRIP001 	return rUL.GetUpper() + rUL.GetLower() + CalcTopSpace() + CalcBottomSpace();
//STRIP001 }
//STRIP001 
//STRIP001 SwTwips SwFlyFrmAttrMgr::CalcTopSpace()
//STRIP001 {
//STRIP001 	const SvxShadowItem& rShadow = GetShadow();
//STRIP001 	const SvxBoxItem& 	 rBox 	 = GetBox();
//STRIP001 	return rShadow.CalcShadowSpace(SHADOW_TOP ) + rBox.CalcLineSpace(BOX_LINE_TOP);
//STRIP001 }
//STRIP001 
//STRIP001 SwTwips SwFlyFrmAttrMgr::CalcBottomSpace()
//STRIP001 {
//STRIP001 	const SvxShadowItem& rShadow = GetShadow();
//STRIP001 	const SvxBoxItem& rBox 		 = GetBox();
//STRIP001 	return rShadow.CalcShadowSpace(SHADOW_BOTTOM) + rBox.CalcLineSpace(BOX_LINE_BOTTOM);
//STRIP001 }
//STRIP001 
//STRIP001 SwTwips SwFlyFrmAttrMgr::CalcLeftSpace()
//STRIP001 {
//STRIP001 	const SvxShadowItem& rShadow = GetShadow();
//STRIP001 	const SvxBoxItem&	 rBox 	 = GetBox();
//STRIP001 	return rShadow.CalcShadowSpace(SHADOW_LEFT) + rBox.CalcLineSpace(BOX_LINE_LEFT);
//STRIP001 }
//STRIP001 
//STRIP001 SwTwips SwFlyFrmAttrMgr::CalcRightSpace()
//STRIP001 {
//STRIP001 	const SvxShadowItem& rShadow = GetShadow();
//STRIP001 	const SvxBoxItem&	 rBox 	 = GetBox();
//STRIP001 	return rShadow.CalcShadowSpace(SHADOW_RIGHT) + rBox.CalcLineSpace(BOX_LINE_RIGHT);
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 /*--------------------------------------------------------------------
//STRIP001 	Beschreibung: Attribut aus dem Set loeschen
//STRIP001  --------------------------------------------------------------------*/
//STRIP001 void SwFlyFrmAttrMgr::DelAttr( USHORT nId )
//STRIP001 {
//STRIP001 	aSet.ClearItem( nId );
//STRIP001 }
//STRIP001 
//STRIP001 void SwFlyFrmAttrMgr::SetLRSpace( long nLeft, long nRight )
//STRIP001 {
//STRIP001 	ASSERT( LONG_MAX != nLeft && LONG_MAX != nRight, "Welchen Raend setzen?" );
//STRIP001 
//STRIP001 	SvxLRSpaceItem aTmp( (SvxLRSpaceItem&)aSet.Get( RES_LR_SPACE ) );
//STRIP001 	if( LONG_MAX != nLeft )
//STRIP001 		aTmp.SetLeft( USHORT(nLeft) );
//STRIP001 	if( LONG_MAX != nRight )
//STRIP001 		aTmp.SetRight( USHORT(nRight) );
//STRIP001 	aSet.Put( aTmp );
//STRIP001 }
//STRIP001 
//STRIP001 void SwFlyFrmAttrMgr::SetULSpace( long nTop, long nBottom )
//STRIP001 {
//STRIP001 	ASSERT( LONG_MAX != nTop && LONG_MAX != nBottom, Welchen Raend setzen? );
//STRIP001 
//STRIP001 	SvxULSpaceItem aTmp( (SvxULSpaceItem&)aSet.Get( RES_UL_SPACE ) );
//STRIP001 	if( LONG_MAX != nTop )
//STRIP001 		aTmp.SetUpper( USHORT(nTop) );
//STRIP001 	if( LONG_MAX != nBottom )
//STRIP001 		aTmp.SetLower( USHORT(nBottom) );
//STRIP001 	aSet.Put( aTmp );
//STRIP001 }
//STRIP001 
//STRIP001 void SwFlyFrmAttrMgr::SetWrapType( SwSurround eFly )
//STRIP001 {
//STRIP001 	SwFmtSurround aWrap( GetSurround() );
//STRIP001 	aWrap.SetSurround( eFly );
//STRIP001 	aSet.Put( aWrap );
//STRIP001 }
//STRIP001 
//STRIP001 void SwFlyFrmAttrMgr::SetAnchorOnly(BOOL bSet)
//STRIP001 {
//STRIP001 	SwFmtSurround aWrap( GetSurround() );
//STRIP001 	aWrap.SetAnchorOnly(bSet);
//STRIP001 	aSet.Put( aWrap );
//STRIP001 }
//STRIP001 
//STRIP001 void SwFlyFrmAttrMgr::SetContour(	BOOL bSet)
//STRIP001 {
//STRIP001 	SwFmtSurround aWrap( GetSurround() );
//STRIP001 	aWrap.SetContour(bSet);
//STRIP001 	aSet.Put( aWrap );
//STRIP001 }
//STRIP001 
//STRIP001 void SwFlyFrmAttrMgr::SetPos( const Point& rPoint )
//STRIP001 {
//STRIP001 	SwFmtVertOrient aVertOrient( GetVertOrient() );
//STRIP001 	SwFmtHoriOrient aHoriOrient( GetHoriOrient() );
//STRIP001 
//STRIP001 	aHoriOrient.SetPos		 ( rPoint.X() );
//STRIP001 	aHoriOrient.SetHoriOrient( HORI_NONE  );
//STRIP001 
//STRIP001 	aVertOrient.SetPos		 ( rPoint.Y() );
//STRIP001 	aVertOrient.SetVertOrient( VERT_NONE  );
//STRIP001 
//STRIP001 	aSet.Put( aVertOrient );
//STRIP001 	aSet.Put( aHoriOrient );
//STRIP001 }
//STRIP001 
//STRIP001 void SwFlyFrmAttrMgr::SetHorzOrientation(SwHoriOrient eOrient)
//STRIP001 {
//STRIP001 	SwFmtHoriOrient aHoriOrient( GetHoriOrient() );
//STRIP001 	aHoriOrient.SetHoriOrient( eOrient );
//STRIP001 	aSet.Put( aHoriOrient );
//STRIP001 }
//STRIP001 
//STRIP001 void SwFlyFrmAttrMgr::SetVertOrientation(SvxFrameVertOrient eOrient)
//STRIP001 {
//STRIP001 	SwFmtVertOrient aVertOrient( GetVertOrient() );
//STRIP001 	aVertOrient.SetVertOrient( (SwVertOrient)eOrient );
//STRIP001 	aSet.Put( aVertOrient );
//STRIP001 }
//STRIP001 
//STRIP001 void SwFlyFrmAttrMgr::SetSizeType( SwFrmSize eType )
//STRIP001 {
//STRIP001 	SwFmtFrmSize aSize( GetFrmSize() );
//STRIP001 	aSize.SetSizeType( eType );
//STRIP001 	aSet.Put( aSize );
//STRIP001 }
//STRIP001 
//STRIP001 void SwFlyFrmAttrMgr::SetSize( const Size& rSize )
//STRIP001 {
//STRIP001 	SwFmtFrmSize aSize( GetFrmSize() );
//STRIP001 	aSize.SetSize(Size(Max(rSize.Width(), long(MINFLY)), Max(rSize.Height(), long(MINFLY))));
//STRIP001 	aSet.Put( aSize );
//STRIP001 }
//STRIP001 
//STRIP001 void SwFlyFrmAttrMgr::SetFrmSize(const SwFmtFrmSize& rFrmSize)
//STRIP001 {
//STRIP001 	aSet.Put(rFrmSize);
//STRIP001 }
//STRIP001 
//STRIP001 void SwFlyFrmAttrMgr::ProtectPosSize( BOOL bProt )
//STRIP001 {
//STRIP001 	SvxProtectItem aProtection( ((SvxProtectItem&)aSet.Get(RES_PROTECT)));
//STRIP001 	aProtection.SetSizeProtect( bProt );
//STRIP001 	aProtection.SetPosProtect ( bProt );
//STRIP001 	aSet.Put( aProtection );
//STRIP001 }
//STRIP001 
//STRIP001 void SwFlyFrmAttrMgr::SetTransparent(BOOL bTrans)
//STRIP001 {
//STRIP001 	aSet.Put( SvxOpaqueItem( RES_OPAQUE, !bTrans ));
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 void SwFlyFrmAttrMgr::SetAttrSet(const SfxItemSet& rSet)
//STRIP001 {
//STRIP001 	aSet.ClearItem();
//STRIP001 	aSet.Put( rSet );
//STRIP001 }
//STRIP001 
//STRIP001 /*--------------------------------------------------------------------
//STRIP001 	Beschreibung: Validierung der Inputs
//STRIP001  --------------------------------------------------------------------*/
//STRIP001 
//STRIP001 SwFrmValid::SwFrmValid() :
//STRIP001 	bAuto(0),
//STRIP001 	bMirror(0),
//STRIP001 	nHPos(0),
//STRIP001 	nMaxHPos(LONG_MAX),
//STRIP001 	nMinHPos(0),
//STRIP001 
//STRIP001 	nVPos(0),
//STRIP001 	nMaxVPos(LONG_MAX),
//STRIP001 	nMinVPos(0),
//STRIP001 
//STRIP001 	nWidth( DFLT_WIDTH ),
//STRIP001 	nMinWidth(0),
//STRIP001 	nMaxWidth(LONG_MAX),
//STRIP001 
//STRIP001 	nHeight( DFLT_HEIGHT ),
//STRIP001 	nMaxHeight(LONG_MAX)
//STRIP001 {
//STRIP001 }


}
