/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sw_dbtree.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 04:28:00 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// INCLUDE ---------------------------------------------------------------


#pragma hdrstop

#ifndef _SOT_FORMATS_HXX
#include <sot/formats.hxx>
#endif

#ifndef _COM_SUN_STAR_LANG_XMULTISERVICEFACTORY_HPP_
#include <com/sun/star/lang/XMultiServiceFactory.hpp>
#endif
#ifndef _COM_SUN_STAR_CONTAINER_XNAMEACCESS_HPP_
#include <com/sun/star/container/XNameAccess.hpp>
#endif
#ifndef _COM_SUN_STAR_SDBC_XDATASOURCE_HPP_
#include <com/sun/star/sdbc/XDataSource.hpp>
#endif
#ifndef _COM_SUN_STAR_SDBCX_XTABLESSUPPLIER_HPP_
#include <com/sun/star/sdbcx/XTablesSupplier.hpp>
#endif
#ifndef _COM_SUN_STAR_SDBCX_XCOLUMNSSUPPLIER_HPP_
#include <com/sun/star/sdbcx/XColumnsSupplier.hpp>
#endif
#ifndef _COM_SUN_STAR_SDB_XQUERIESSUPPLIER_HPP_
#include <com/sun/star/sdb/XQueriesSupplier.hpp>
#endif
#ifndef _COM_SUN_STAR_SDB_XDATABASEACCESS_HPP_
#include <com/sun/star/sdb/XDatabaseAccess.hpp>
#endif
#ifndef _COM_SUN_STAR_SDB_COMMANDTYPE_HPP_
#include <com/sun/star/sdb/CommandType.hpp>
#endif
#ifndef _COM_SUN_STAR_BEANS_XPROPERTYSET_HPP_
#include <com/sun/star/beans/XPropertySet.hpp>
#endif
#ifndef _COMPHELPER_PROCESSFACTORY_HXX_
#include <comphelper/processfactory.hxx>
#endif
#ifndef _COM_SUN_STAR_SDB_XCOMPLETEDCONNECTION_HPP_
#include <com/sun/star/sdb/XCompletedConnection.hpp>
#endif
#ifndef _COM_SUN_STAR_CONTAINER_XCONTAINERLISTENER_HPP_
#include <com/sun/star/container/XContainerListener.hpp>
#endif
#ifndef _COM_SUN_STAR_CONTAINER_XCONTAINER_HPP_
#include <com/sun/star/container/XContainer.hpp>
#endif
#ifndef _CPPUHELPER_IMPLBASE1_HXX_
#include <cppuhelper/implbase1.hxx>
#endif
#ifndef _SVX_DBAEXCHANGE_HXX_
#include <bf_svx/dbaexchange.hxx>
#endif

#ifndef _DBMGR_HXX
#include <dbmgr.hxx>
#endif
#ifndef _SWMODULE_HXX
#include <swmodule.hxx>
#endif
#ifndef _VIEW_HXX
#include <view.hxx>
#endif

#ifndef _HORIORNT_HXX
#include <horiornt.hxx>
#endif

#ifndef _WRTSH_HXX
#include <wrtsh.hxx>
#endif
#ifndef _DBTREE_HXX
#include <dbtree.hxx>
#endif
#ifndef _VOS_MUTEX_HXX_
#include <vos/mutex.hxx>
#endif
#ifndef _SV_SVAPP_HXX
#include <vcl/svapp.hxx>
#endif

#ifndef _HELPID_H
#include <helpid.h>
#endif
#ifndef _UTLUI_HRC
#include <utlui.hrc>
#endif
#ifndef _LEGACYBINFILTERMGR_HXX
#include <legacysmgr/legacy_binfilters_smgr.hxx>	//STRIP002 
#endif
namespace binfilter {
using namespace rtl;
using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::container;
using namespace ::com::sun::star::lang;
using namespace ::com::sun::star::sdb;
using namespace ::com::sun::star::sdbc;
using namespace ::com::sun::star::sdbcx;
using namespace ::com::sun::star::task;
using namespace ::com::sun::star::beans;

//STRIP001 #define C2U(cChar) ::rtl::OUString::createFromAscii(cChar)
/* -----------------------------17.07.01 13:10--------------------------------

 ---------------------------------------------------------------------------*/
//STRIP001 struct SwConnectionData
//STRIP001 {
//STRIP001     OUString                sSourceName;
//STRIP001     Reference<XConnection>  xConnection;
//STRIP001 };

//STRIP001 typedef SwConnectionData* SwConnectionDataPtr;
//STRIP001 SV_DECL_PTRARR_DEL( SwConnectionArr, SwConnectionDataPtr, 32, 32 )
//STRIP001 SV_IMPL_PTRARR( SwConnectionArr, SwConnectionDataPtr )
/* -----------------------------17.07.01 13:24--------------------------------

 ---------------------------------------------------------------------------*/
//STRIP001 class SwDBTreeList_Impl : public cppu::WeakImplHelper1 < XContainerListener >
//STRIP001 {
//STRIP001     Reference< XNameAccess > xDBContext;
//STRIP001     SwConnectionArr aConnections;
//STRIP001     SwWrtShell& rWrtSh;
//STRIP001 
//STRIP001     public:
//STRIP001         SwDBTreeList_Impl(SwWrtShell& rShell) :
//STRIP001             rWrtSh(rShell) {}
//STRIP001         ~SwDBTreeList_Impl();
//STRIP001 
//STRIP001     virtual void SAL_CALL elementInserted( const ContainerEvent& Event ) throw (RuntimeException);
//STRIP001     virtual void SAL_CALL elementRemoved( const ContainerEvent& Event ) throw (RuntimeException);
//STRIP001     virtual void SAL_CALL elementReplaced( const ContainerEvent& Event ) throw (RuntimeException);
//STRIP001     virtual void SAL_CALL disposing( const EventObject& Source ) throw (RuntimeException);
//STRIP001 
//STRIP001     BOOL                        HasContext();
//STRIP001     Reference< XNameAccess >    GetContext() {return xDBContext;}
//STRIP001     Reference<XConnection>      GetConnection(const ::rtl::OUString& rSourceName);
//STRIP001 };
/* -----------------------------17.07.01 13:24--------------------------------

 ---------------------------------------------------------------------------*/
//STRIP001 SwDBTreeList_Impl::~SwDBTreeList_Impl()
//STRIP001 {
//STRIP001     Reference<XContainer> xContainer(xDBContext, UNO_QUERY);
//STRIP001     if(xContainer.is())
//STRIP001     {
//STRIP001         m_refCount++;
//STRIP001         //block necessary due to solaris' compiler behaviour to
//STRIP001         //remove temporaries at the block's end
//STRIP001         {
//STRIP001             xContainer->removeContainerListener( this );
//STRIP001         }
//STRIP001         m_refCount--;
//STRIP001     }
//STRIP001 }
/* -----------------------------17.07.01 13:24--------------------------------

 ---------------------------------------------------------------------------*/
//STRIP001 void SwDBTreeList_Impl::elementInserted( const ContainerEvent&  ) throw (RuntimeException)
//STRIP001 {
//STRIP001     // information not needed
//STRIP001 }
/* -----------------------------17.07.01 13:24--------------------------------

 ---------------------------------------------------------------------------*/
//STRIP001 void SwDBTreeList_Impl::elementRemoved( const ContainerEvent& rEvent ) throw (RuntimeException)
//STRIP001 {
//STRIP001     vos::OGuard aGuard(Application::GetSolarMutex());
//STRIP001     OUString sSource;
//STRIP001     rEvent.Accessor >>= sSource;
//STRIP001     for(USHORT i = 0; i < aConnections.Count(); i++)
//STRIP001     {
//STRIP001         SwConnectionDataPtr pPtr = aConnections[i];
//STRIP001         if(pPtr->sSourceName == sSource)
//STRIP001         {
//STRIP001             SwConnectionDataPtr pPtr = aConnections[i];
//STRIP001 //            Reference<XComponent> xComp(pPtr->xConnection, UNO_QUERY);
//STRIP001 //            if(xComp.is())
//STRIP001 //                xComp->dispose();
//STRIP001             aConnections.DeleteAndDestroy(i);
//STRIP001             break;
//STRIP001         }
//STRIP001     }
//STRIP001 }
/* -----------------------------17.07.01 13:24--------------------------------

 ---------------------------------------------------------------------------*/
//STRIP001 void SwDBTreeList_Impl::disposing( const EventObject&  ) throw (RuntimeException)
//STRIP001 {
//STRIP001     xDBContext = 0;
//STRIP001 }
/* -----------------------------17.07.01 13:24--------------------------------

 ---------------------------------------------------------------------------*/
//STRIP001 void SwDBTreeList_Impl::elementReplaced( const ContainerEvent& rEvent ) throw (RuntimeException)
//STRIP001 {
//STRIP001     elementRemoved(rEvent);
//STRIP001 }
/* -----------------------------17.07.01 13:24--------------------------------

 ---------------------------------------------------------------------------*/
//STRIP001 BOOL SwDBTreeList_Impl::HasContext()
//STRIP001 {
//STRIP001     if(!xDBContext.is())
//STRIP001     {
//STRIP001         Reference< XMultiServiceFactory > xMgr( ::legacy_binfilters::getLegacyProcessServiceFactory() );
//STRIP001         if( xMgr.is() )
//STRIP001         {
//STRIP001             Reference<XInterface> xInstance = xMgr->createInstance(
//STRIP001                         C2U( "com.sun.star.sdb.DatabaseContext" ));
//STRIP001             xDBContext = Reference<XNameAccess>(xInstance, UNO_QUERY) ;
//STRIP001             Reference<XContainer> xContainer(xDBContext, UNO_QUERY);
//STRIP001             if(xContainer.is())
//STRIP001                 xContainer->addContainerListener( this );
//STRIP001         }
//STRIP001         DBG_ASSERT(xDBContext.is(), "com.sun.star.sdb.DataBaseContext: service not available")
//STRIP001     }
//STRIP001     return xDBContext.is();
//STRIP001 }
/* -----------------------------17.07.01 13:24--------------------------------

 ---------------------------------------------------------------------------*/
//STRIP001 Reference<XConnection>  SwDBTreeList_Impl::GetConnection(const ::rtl::OUString& rSourceName)
//STRIP001 {
//STRIP001     Reference<XConnection>  xRet;
//STRIP001     for(USHORT i = 0; i < aConnections.Count(); i++)
//STRIP001     {
//STRIP001         SwConnectionDataPtr pPtr = aConnections[i];
//STRIP001         if(pPtr->sSourceName == rSourceName)
//STRIP001         {
//STRIP001             xRet = pPtr->xConnection;
//STRIP001             break;
//STRIP001         }
//STRIP001     }
//STRIP001     if(!xRet.is() && xDBContext.is())
//STRIP001     {
//STRIP001         SwConnectionDataPtr pPtr = new SwConnectionData();
//STRIP001         pPtr->sSourceName = rSourceName;
//STRIP001         xRet = rWrtSh.GetNewDBMgr()->RegisterConnection(pPtr->sSourceName);
//STRIP001         aConnections.Insert(pPtr, aConnections.Count());
//STRIP001     }
//STRIP001     return xRet;
//STRIP001 }
/*------------------------------------------------------------------------
 Beschreibung:
------------------------------------------------------------------------*/
//STRIP001 SwDBTreeList::SwDBTreeList(Window *pParent, const ResId& rResId,
//STRIP001                         SwWrtShell& rSh,
//STRIP001                         const String& rDefDBName, const BOOL bShowCol):
//STRIP001 
//STRIP001 	SvTreeListBox	(pParent, rResId),
//STRIP001     aImageList      (SW_RES(ILIST_DB_DLG    )),
//STRIP001     aImageListHC    (SW_RES(ILIST_DB_DLG_HC )),
//STRIP001 	sDefDBName		(rDefDBName),
//STRIP001 	bShowColumns	(bShowCol),
//STRIP001     pImpl(new SwDBTreeList_Impl(rSh)),
//STRIP001 	bInitialized	(FALSE)
//STRIP001 {
//STRIP001 	SetHelpId(HID_DB_SELECTION_TLB);
//STRIP001 
//STRIP001 	if (IsVisible())
//STRIP001 		InitTreeList();
//STRIP001 }

/*------------------------------------------------------------------------
 Beschreibung:
------------------------------------------------------------------------*/
//STRIP001 SwDBTreeList::~SwDBTreeList()
//STRIP001 {
//STRIP001     delete pImpl;
//STRIP001 }

/*------------------------------------------------------------------------
 Beschreibung:
------------------------------------------------------------------------*/


//STRIP001 void SwDBTreeList::InitTreeList()
//STRIP001 {
//STRIP001     if(!pImpl->HasContext())
//STRIP001 		return;
//STRIP001 	SetSelectionMode(SINGLE_SELECTION);
//STRIP001 	SetWindowBits(WB_HASLINES|WB_CLIPCHILDREN|WB_SORT|WB_HASBUTTONS|WB_HASBUTTONSATROOT|WB_HSCROLL);
//STRIP001 	// Font nicht setzen, damit der Font des Controls uebernommen wird!
//STRIP001 	SetSpaceBetweenEntries(0);
//STRIP001     SetNodeBitmaps( aImageList.GetImage(IMG_COLLAPSE),
//STRIP001                     aImageList.GetImage(IMG_EXPAND  ), BMP_COLOR_NORMAL );
//STRIP001     SetNodeBitmaps( aImageListHC.GetImage(IMG_COLLAPSE),
//STRIP001                     aImageListHC.GetImage(IMG_EXPAND  ), BMP_COLOR_HIGHCONTRAST );
//STRIP001 
//STRIP001 	SetDragDropMode(SV_DRAGDROP_APP_COPY);
//STRIP001 
//STRIP001 	GetModel()->SetCompareHdl(LINK(this, SwDBTreeList, DBCompare));
//STRIP001 
//STRIP001     Sequence<OUString> aDBNames = pImpl->GetContext()->getElementNames();
//STRIP001 	const OUString* pDBNames = aDBNames.getConstArray();
//STRIP001 	long nCount = aDBNames.getLength();
//STRIP001 
//STRIP001     Image aImg = aImageList.GetImage(IMG_DB);
//STRIP001     Image aHCImg = aImageListHC.GetImage(IMG_DB);
//STRIP001     for(long i = 0; i < nCount; i++)
//STRIP001 	{
//STRIP001 		String sDBName(pDBNames[i]);
//STRIP001         SvLBoxEntry* pEntry = InsertEntry(sDBName, aImg, aImg, NULL, TRUE);
//STRIP001         SetExpandedEntryBmp(pEntry, aHCImg, BMP_COLOR_HIGHCONTRAST);
//STRIP001         SetCollapsedEntryBmp(pEntry, aHCImg, BMP_COLOR_HIGHCONTRAST);
//STRIP001 	}
//STRIP001 	String sDBName(sDefDBName.GetToken(0, DB_DELIM));
//STRIP001 	String sTableName(sDefDBName.GetToken(1, DB_DELIM));
//STRIP001 	String sColumnName(sDefDBName.GetToken(2, DB_DELIM));
//STRIP001 	Select(sDBName, sTableName, sColumnName);
//STRIP001 
//STRIP001 
//STRIP001 	bInitialized = TRUE;
//STRIP001 }

/*------------------------------------------------------------------------
 Beschreibung:
------------------------------------------------------------------------*/

//STRIP001 void SwDBTreeList::ShowColumns(BOOL bShowCol)
//STRIP001 {
//STRIP001 	if (bShowCol != bShowColumns)
//STRIP001 	{
//STRIP001 		bShowColumns = bShowCol;
//STRIP001 		String sTableName, sColumnName;
//STRIP001 		String  sDBName(GetDBName(sTableName, sColumnName));
//STRIP001 
//STRIP001 		SetUpdateMode(FALSE);
//STRIP001 
//STRIP001 		SvLBoxEntry* pEntry = First();
//STRIP001 
//STRIP001 		while (pEntry)
//STRIP001 		{
//STRIP001 			pEntry = (SvLBoxEntry*)GetRootLevelParent( pEntry );
//STRIP001 			Collapse(pEntry);		// zuklappen
//STRIP001 
//STRIP001 			SvLBoxEntry* pChild;
//STRIP001 			while ((pChild = FirstChild(pEntry)) != 0L)
//STRIP001 				GetModel()->Remove(pChild);
//STRIP001 
//STRIP001 			pEntry = Next(pEntry);
//STRIP001 		}
//STRIP001 
//STRIP001 		if (sDBName.Len())
//STRIP001 		{
//STRIP001 			Select(sDBName, sTableName, sColumnName);	// force RequestingChilds
//STRIP001 		}
//STRIP001 		SetUpdateMode(TRUE);
//STRIP001 	}
//STRIP001 }

/*------------------------------------------------------------------------
 Beschreibung:
------------------------------------------------------------------------*/

//STRIP001 void  SwDBTreeList::RequestingChilds(SvLBoxEntry* pParent)
//STRIP001 {
//STRIP001 	if (!pParent->HasChilds())
//STRIP001 	{
//STRIP001 		if (GetParent(pParent))	// column names
//STRIP001 		{
//STRIP001             try
//STRIP001             {        
//STRIP001 
//STRIP001                 String sSourceName = GetEntryText(GetParent(pParent));
//STRIP001                 String sTableName = GetEntryText(pParent);
//STRIP001 
//STRIP001                 if(!pImpl->GetContext()->hasByName(sSourceName))
//STRIP001                     return;
//STRIP001                 Reference<XConnection> xConnection = pImpl->GetConnection(sSourceName);
//STRIP001                 BOOL bTable = pParent->GetUserData() == 0;
//STRIP001                 Reference<XColumnsSupplier> xColsSupplier;
//STRIP001                 if(bTable)
//STRIP001                 {
//STRIP001                     Reference<XTablesSupplier> xTSupplier = Reference<XTablesSupplier>(xConnection, UNO_QUERY);
//STRIP001                     if(xTSupplier.is())
//STRIP001                     {
//STRIP001                         Reference<XNameAccess> xTbls = xTSupplier->getTables();
//STRIP001                         DBG_ASSERT(xTbls->hasByName(sTableName), "table not available anymore?")
//STRIP001                         try
//STRIP001                         {
//STRIP001                             Any aTable = xTbls->getByName(sTableName);
//STRIP001                             Reference<XPropertySet> xPropSet;
//STRIP001                             aTable >>= xPropSet;
//STRIP001                             xColsSupplier = Reference<XColumnsSupplier>(xPropSet, UNO_QUERY);
//STRIP001                         }
//STRIP001                         catch(Exception&)
//STRIP001                         {}
//STRIP001                     }
//STRIP001                 }
//STRIP001                 else
//STRIP001                 {
//STRIP001                     Reference<XQueriesSupplier> xQSupplier = Reference<XQueriesSupplier>(xConnection, UNO_QUERY);
//STRIP001                     if(xQSupplier.is())
//STRIP001                     {
//STRIP001                         Reference<XNameAccess> xQueries = xQSupplier->getQueries();
//STRIP001                         DBG_ASSERT(xQueries->hasByName(sTableName), "table not available anymore?")
//STRIP001                         try
//STRIP001                         {
//STRIP001                             Any aQuery = xQueries->getByName(sTableName);
//STRIP001                             Reference<XPropertySet> xPropSet;
//STRIP001                             aQuery >>= xPropSet;
//STRIP001                             xColsSupplier = Reference<XColumnsSupplier>(xPropSet, UNO_QUERY);
//STRIP001                         }
//STRIP001                         catch(Exception&)
//STRIP001                         {}
//STRIP001                     }
//STRIP001                 }
//STRIP001 
//STRIP001                 if(xColsSupplier.is())
//STRIP001                 {
//STRIP001                     Reference <XNameAccess> xCols = xColsSupplier->getColumns();
//STRIP001                     Sequence<OUString> aColNames = xCols->getElementNames();
//STRIP001                     const OUString* pColNames = aColNames.getConstArray();
//STRIP001                     long nCount = aColNames.getLength();
//STRIP001                     for (long i = 0; i < nCount; i++)
//STRIP001                     {
//STRIP001                         String sName = pColNames[i];
//STRIP001                         if(bTable)
//STRIP001                             InsertEntry(sName, pParent);
//STRIP001                         else
//STRIP001                             InsertEntry(sName, pParent);
//STRIP001                     }
//STRIP001                 }
//STRIP001             }
//STRIP001             catch(const Exception& rEx)
//STRIP001             {
//STRIP001             }        
//STRIP001 		}
//STRIP001 		else	// Tabellennamen
//STRIP001 		{
//STRIP001             try
//STRIP001             {        
//STRIP001                 String sSourceName = GetEntryText(pParent);
//STRIP001                 if(!pImpl->GetContext()->hasByName(sSourceName))
//STRIP001                     return;
//STRIP001                 Reference<XConnection> xConnection = pImpl->GetConnection(sSourceName);
//STRIP001                 if (xConnection.is())
//STRIP001                 {
//STRIP001                     Reference<XTablesSupplier> xTSupplier = Reference<XTablesSupplier>(xConnection, UNO_QUERY);
//STRIP001                     if(xTSupplier.is())
//STRIP001                     {
//STRIP001                         Reference<XNameAccess> xTbls = xTSupplier->getTables();
//STRIP001                         Sequence<OUString> aTblNames = xTbls->getElementNames();
//STRIP001                         String sTableName;
//STRIP001                         long nCount = aTblNames.getLength();
//STRIP001                         const OUString* pTblNames = aTblNames.getConstArray();
//STRIP001                         Image aImg = aImageList.GetImage(IMG_DBTABLE);
//STRIP001                         Image aHCImg = aImageListHC.GetImage(IMG_DBTABLE);
//STRIP001                         for (long i = 0; i < nCount; i++)
//STRIP001                         {
//STRIP001                             sTableName = pTblNames[i];
//STRIP001                             SvLBoxEntry* pTableEntry = InsertEntry(sTableName, aImg, aImg, pParent, bShowColumns);
//STRIP001                             //to discriminate between queries and tables the user data of table entries is set
//STRIP001                             pTableEntry->SetUserData((void*)0);
//STRIP001                             SetExpandedEntryBmp(pTableEntry, aHCImg, BMP_COLOR_HIGHCONTRAST);
//STRIP001                             SetCollapsedEntryBmp(pTableEntry, aHCImg, BMP_COLOR_HIGHCONTRAST);
//STRIP001                         }
//STRIP001                     }
//STRIP001 
//STRIP001                     Reference<XQueriesSupplier> xQSupplier = Reference<XQueriesSupplier>(xConnection, UNO_QUERY);
//STRIP001                     if(xQSupplier.is())
//STRIP001                     {
//STRIP001                         Reference<XNameAccess> xQueries = xQSupplier->getQueries();
//STRIP001                         Sequence<OUString> aQueryNames = xQueries->getElementNames();
//STRIP001                         String sQueryName;
//STRIP001                         long nCount = aQueryNames.getLength();
//STRIP001                         const OUString* pQueryNames = aQueryNames.getConstArray();
//STRIP001                         Image aImg = aImageList.GetImage(IMG_DBQUERY);
//STRIP001                         Image aHCImg = aImageListHC.GetImage(IMG_DBQUERY);
//STRIP001                         for (long i = 0; i < nCount; i++)
//STRIP001                         {
//STRIP001                             sQueryName = pQueryNames[i];
//STRIP001                             SvLBoxEntry* pQueryEntry = InsertEntry(sQueryName, aImg, aImg, pParent, bShowColumns);
//STRIP001                             pQueryEntry->SetUserData((void*)1);
//STRIP001                             SetExpandedEntryBmp(pQueryEntry, aHCImg, BMP_COLOR_HIGHCONTRAST);
//STRIP001                             SetCollapsedEntryBmp( pQueryEntry, aHCImg, BMP_COLOR_HIGHCONTRAST);
//STRIP001                         }
//STRIP001                     }
//STRIP001                 }
//STRIP001             }
//STRIP001             catch(const Exception& rEx)
//STRIP001             {
//STRIP001             }        
//STRIP001         }
//STRIP001 	}
//STRIP001 }

/*------------------------------------------------------------------------
 Beschreibung:
------------------------------------------------------------------------*/

//STRIP001 IMPL_LINK( SwDBTreeList, DBCompare, SvSortData*, pData )
//STRIP001 {
//STRIP001 	SvLBoxEntry* pRight = (SvLBoxEntry*)(pData->pRight );
//STRIP001 
//STRIP001 	if (GetParent(pRight) && GetParent(GetParent(pRight)))
//STRIP001 		return COMPARE_GREATER;	// Spaltennamen nicht sortieren
//STRIP001 
//STRIP001 	return DefaultCompare(pData);	// Sonst Basisklasse rufen
//STRIP001 }

/*------------------------------------------------------------------------
 Beschreibung:
------------------------------------------------------------------------*/

//STRIP001 String  SwDBTreeList::GetDBName(String& rTableName, String& rColumnName, BOOL* pbIsTable)
//STRIP001 {
//STRIP001 	String sDBName;
//STRIP001 	SvLBoxEntry* pEntry = FirstSelected();
//STRIP001 
//STRIP001 	if (pEntry && GetParent(pEntry))
//STRIP001 	{
//STRIP001 		if (GetParent(GetParent(pEntry)))
//STRIP001 		{
//STRIP001 			rColumnName = GetEntryText(pEntry);
//STRIP001 			pEntry = GetParent(pEntry);	// Spaltenname war selektiert
//STRIP001 		}
//STRIP001 		sDBName = GetEntryText(GetParent(pEntry));
//STRIP001 		if(pbIsTable)
//STRIP001 		{
//STRIP001             *pbIsTable = pEntry->GetUserData() == 0;
//STRIP001 		}
//STRIP001 		rTableName = GetEntryText(pEntry);
//STRIP001 	}
//STRIP001 	return sDBName;
//STRIP001 }

/*------------------------------------------------------------------------
 Beschreibung:	Format: Datenbank.Tabelle
------------------------------------------------------------------------*/


//STRIP001 void SwDBTreeList::Select(const String& rDBName, const String& rTableName, const String& rColumnName)
//STRIP001 {
//STRIP001 	SvLBoxEntry* pParent;
//STRIP001 	SvLBoxEntry* pChild;
//STRIP001 	USHORT nParent = 0;
//STRIP001 	USHORT nChild = 0;
//STRIP001 
//STRIP001 	while ((pParent = GetEntry(nParent++)) != NULL)
//STRIP001 	{
//STRIP001 		if (rDBName == GetEntryText(pParent))
//STRIP001 		{
//STRIP001 			if (!pParent->HasChilds())
//STRIP001 				RequestingChilds(pParent);
//STRIP001 			while ((pChild = GetEntry(pParent, nChild++)) != NULL)
//STRIP001 			{
//STRIP001 				if (rTableName == GetEntryText(pChild))
//STRIP001 				{
//STRIP001 					pParent = pChild;
//STRIP001 
//STRIP001 					if (bShowColumns && rColumnName.Len())
//STRIP001 					{
//STRIP001 						nChild = 0;
//STRIP001 
//STRIP001 						if (!pParent->HasChilds())
//STRIP001 							RequestingChilds(pParent);
//STRIP001 
//STRIP001 						while ((pChild = GetEntry(pParent, nChild++)) != NULL)
//STRIP001 							if (rColumnName == GetEntryText(pChild))
//STRIP001 								break;
//STRIP001 					}
//STRIP001 					if (!pChild)
//STRIP001 						pChild = pParent;
//STRIP001 
//STRIP001 					MakeVisible(pChild);
//STRIP001 					SvTreeListBox::Select(pChild);
//STRIP001 					return;
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 }

/*------------------------------------------------------------------------
 Beschreibung: Initialisierung verzgern
------------------------------------------------------------------------*/

//STRIP001 void  SwDBTreeList::Show()
//STRIP001 {
//STRIP001 	if (!bInitialized)
//STRIP001 		InitTreeList();
//STRIP001 
//STRIP001 	SvTreeListBox::Show();
//STRIP001 }

/*------------------------------------------------------------------------
 Beschreibung:
------------------------------------------------------------------------*/

//STRIP001 void SwDBTreeList::StartDrag( sal_Int8 nAction, const Point& rPosPixel )
//STRIP001 {
//STRIP001 	String sTableName, sColumnName;
//STRIP001 	String  sDBName( GetDBName( sTableName, sColumnName ));
//STRIP001 	if( sDBName.Len() )
//STRIP001 	{
//STRIP001 		TransferDataContainer* pContainer = new TransferDataContainer;
//STRIP001 		STAR_REFERENCE( datatransfer::XTransferable ) xRef( pContainer );
//STRIP001 		if( sColumnName.Len() )
//STRIP001 		{
//STRIP001 			// Datenbankfeld draggen
//STRIP001 			svx::OColumnTransferable aColTransfer(
//STRIP001 							sDBName, ::com::sun::star::sdb::CommandType::TABLE,
//STRIP001 							sTableName, sColumnName,
//STRIP001 							(CTF_FIELD_DESCRIPTOR |CTF_COLUMN_DESCRIPTOR ));
//STRIP001 			aColTransfer.addDataToContainer( pContainer );
//STRIP001 		}
//STRIP001 
//STRIP001 		sDBName += '.';
//STRIP001 		sDBName += sTableName;
//STRIP001 		if( sColumnName.Len() )
//STRIP001 		{
//STRIP001 			sDBName += '.';
//STRIP001 			sDBName += sColumnName;
//STRIP001 		}
//STRIP001 
//STRIP001 		pContainer->CopyString( FORMAT_STRING, sDBName );
//STRIP001 		pContainer->StartDrag( this, DND_ACTION_COPY | DND_ACTION_LINK,
//STRIP001 								Link() );
//STRIP001 	}
//STRIP001 }

/*------------------------------------------------------------------------
 Beschreibung:
------------------------------------------------------------------------*/
//STRIP001 sal_Int8 SwDBTreeList::AcceptDrop( const AcceptDropEvent& rEvt )
//STRIP001 {
//STRIP001 	return DND_ACTION_NONE;
//STRIP001 }

}
