/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: svx_optpath.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 06:39:36 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// include ---------------------------------------------------------------

#if defined (WIN) || defined (WNT)
#ifndef _SVWIN_H
#include <tools/svwin.h>
#endif
#endif

#ifndef _SHL_HXX
#include <tools/shl.hxx>
#endif
#ifndef _SV_MSGBOX_HXX //autogen
#include <vcl/msgbox.hxx>
#endif

#ifndef _FILEDLGHELPER_HXX
#include <bf_sfx2/filedlghelper.hxx>
#endif
#ifndef _PICKERHELPER_HXX
#include <svtools/pickerhelper.hxx>
#endif

#ifndef _SVTABBX_HXX //autogen
#include <svtools/svtabbx.hxx>
#endif
#ifndef _AEITEM_HXX //autogen
#include <svtools/aeitem.hxx>
#endif
#ifndef _SVT_FILEDLG_HXX //autogen
#include <svtools/filedlg.hxx>
#endif
#ifndef _CONFIG_HXX
#include <tools/config.hxx>
#endif
#include <tools/urlobj.hxx>
#include <vcl/svapp.hxx>
#include <svtools/defaultoptions.hxx>
#include <unotools/localfilehelper.hxx>
#pragma hdrstop

#ifndef INCLUDED_SVTOOLS_PATHOPTIONS_HXX
#include <svtools/pathoptions.hxx>
#endif

#define _SVX_OPTPATH_CXX

#include "optpath.hxx"
#include "dialmgr.hxx"
#include "multipat.hxx"

#include "optpath.hrc"
#include "dialogs.hrc"
#include "helpid.hrc"

#ifndef _COMPHELPER_PROCESSFACTORY_HXX_
#include <comphelper/processfactory.hxx>
#endif

#ifndef _COM_SUN_STAR_UNO_EXCEPTION_HPP_
#include <com/sun/star/uno/Exception.hpp>
#endif

#ifndef  _COM_SUN_STAR_LANG_XMULTISERVICEFACTORY_HPP_
#include <com/sun/star/lang/XMultiServiceFactory.hpp>
#endif

#ifndef  _COM_SUN_STAR_UI_DIALOGS_XFOLDERPICKER_HPP_
#include <com/sun/star/ui/dialogs/XFolderPicker.hpp>
#endif
#ifndef  _COM_SUN_STAR_UI_DIALOGS_EXECUTABLEDIALOGRESULTS_HPP_
#include <com/sun/star/ui/dialogs/ExecutableDialogResults.hpp>
#endif
#ifndef _LEGACYBINFILTERMGR_HXX
#include <legacysmgr/legacy_binfilters_smgr.hxx>	//STRIP002 
#endif
namespace binfilter {

using namespace ::com::sun::star::lang;
using namespace ::com::sun::star::ui::dialogs;
using namespace ::com::sun::star::uno;

// define ----------------------------------------------------------------

//STRIP001 #define TAB_WIDTH1		80
//STRIP001 #define TAB_WIDTH_MIN   10
//STRIP001 #define TAB_WIDTH2		1000
//STRIP001 #define ITEMID_TYPE		1
//STRIP001 #define ITEMID_PATH		2
//STRIP001 
//STRIP001 // struct OptPath_Impl ---------------------------------------------------
//STRIP001 
//STRIP001 struct OptPath_Impl
//STRIP001 {
//STRIP001 	SvtDefaultOptions _aDefOpt;
//STRIP001     Image aLockImage;
//STRIP001     Image aLockImageHC;
//STRIP001 
//STRIP001     OptPath_Impl(const ResId& rLockRes, const ResId& rLockResHC) :
//STRIP001         aLockImage(rLockRes),
//STRIP001         aLockImageHC(rLockResHC){}
//STRIP001 };
//STRIP001 
//STRIP001 // struct PathUserData_Impl ----------------------------------------------
//STRIP001 
//STRIP001 struct PathUserData_Impl
//STRIP001 {
//STRIP001 	USHORT			nRealId;
//STRIP001 	SfxItemState	eState;
//STRIP001 	String			aPathStr;
//STRIP001 
//STRIP001 	PathUserData_Impl( USHORT nId ) :
//STRIP001 		nRealId( nId ), eState( SFX_ITEM_UNKNOWN ) {}
//STRIP001 };
//STRIP001 
//STRIP001 #define MULTIPATH_DELIMITER		';'
//STRIP001 
//STRIP001 String Convert_Impl( const String& rValue )
//STRIP001 {
//STRIP001 	char cDelim = MULTIPATH_DELIMITER;
//STRIP001     USHORT nCount = rValue.GetTokenCount( cDelim );
//STRIP001     String aReturn;
//STRIP001     for ( USHORT i=0; i<nCount ; ++i )
//STRIP001 	{
//STRIP001         String aValue = rValue.GetToken( i, cDelim );
//STRIP001         INetURLObject aObj( aValue );
//STRIP001         if ( aObj.GetProtocol() == INET_PROT_FILE )
//STRIP001             aReturn += aObj.PathToFileName();
//STRIP001         else if ( ::utl::LocalFileHelper::IsFileContent( aValue ) )
//STRIP001             aReturn += aObj.GetURLPath( INetURLObject::DECODE_WITH_CHARSET );
//STRIP001         if ( i+1 < nCount)
//STRIP001             aReturn += MULTIPATH_DELIMITER;
//STRIP001     }
//STRIP001 
//STRIP001     return aReturn;
//STRIP001 }
//STRIP001 
//STRIP001 // class SvxPathControl_Impl ---------------------------------------------
//STRIP001 
//STRIP001 long SvxPathControl_Impl::Notify( NotifyEvent& rNEvt )
//STRIP001 {
//STRIP001 	long nRet = Control::Notify( rNEvt );
//STRIP001 
//STRIP001 	if ( m_pFocusCtrl && rNEvt.GetWindow() != m_pFocusCtrl && rNEvt.GetType() == EVENT_GETFOCUS )
//STRIP001 		m_pFocusCtrl->GrabFocus();
//STRIP001 	return nRet;
//STRIP001 }
//STRIP001 
//STRIP001 // class OptHeaderTabListBox ---------------------------------------------
//STRIP001 
//STRIP001 class OptHeaderTabListBox : public SvTabListBox
//STRIP001 {
//STRIP001 private:
//STRIP001 	BOOL		m_bFirstPaint;
//STRIP001 	HeaderBar* 	m_pHeaderBar;
//STRIP001 
//STRIP001 	DECL_LINK( TabBoxScrollHdl_Impl, SvTabListBox* );
//STRIP001 
//STRIP001 public:
//STRIP001 	OptHeaderTabListBox( Window* pParent, WinBits nBits );
//STRIP001 
//STRIP001 	virtual void	Paint( const Rectangle& rRect );
//STRIP001 	void			InitHeaderBar( HeaderBar* _pHeaderBar );
//STRIP001     virtual void    InitEntry( SvLBoxEntry*, const XubString&, const Image&, const Image& );
//STRIP001 };
//STRIP001 
//STRIP001 // class OptLBoxString_Impl ----------------------------------------------
//STRIP001 
//STRIP001 class OptLBoxString_Impl : public SvLBoxString
//STRIP001 {
//STRIP001 public:
//STRIP001     OptLBoxString_Impl( SvLBoxEntry* pEntry, USHORT nFlags, const String& rTxt ) :
//STRIP001         SvLBoxString( pEntry, nFlags, rTxt ) {}
//STRIP001 
//STRIP001     virtual void Paint( const Point& rPos, SvLBox& rDev, USHORT nFlags, SvLBoxEntry* pEntry );
//STRIP001 };
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void OptLBoxString_Impl::Paint( const Point& rPos, SvLBox& rDev, USHORT, SvLBoxEntry* pEntry )
//STRIP001 {
//STRIP001     Font aOldFont( rDev.GetFont() );
//STRIP001     Font aFont( aOldFont );
//STRIP001     //detect readonly state by asking for a valid Image
//STRIP001     if(pEntry && !(!((OptHeaderTabListBox&)rDev).GetCollapsedEntryBmp(pEntry)))
//STRIP001         aFont.SetColor( Application::GetSettings().GetStyleSettings().GetDeactiveTextColor() );
//STRIP001     rDev.SetFont( aFont );
//STRIP001     rDev.DrawText( rPos, GetText() );
//STRIP001     rDev.SetFont( aOldFont );
//STRIP001 }
//STRIP001 
//STRIP001 OptHeaderTabListBox::OptHeaderTabListBox( Window* pParent, WinBits nWinStyle ) :
//STRIP001 
//STRIP001 	SvTabListBox( pParent, nWinStyle ),
//STRIP001 
//STRIP001 	m_bFirstPaint( TRUE ),
//STRIP001 	m_pHeaderBar( NULL )
//STRIP001 
//STRIP001 {
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void OptHeaderTabListBox::Paint( const Rectangle& rRect )
//STRIP001 {
//STRIP001 	if ( m_bFirstPaint )
//STRIP001 	{
//STRIP001 		m_bFirstPaint = FALSE;
//STRIP001 		RepaintScrollBars();
//STRIP001 	}
//STRIP001 
//STRIP001 	SvTabListBox::Paint( rRect );
//STRIP001 }
//STRIP001 
//STRIP001 void OptHeaderTabListBox::InitHeaderBar( HeaderBar* _pHeaderBar )
//STRIP001 {
//STRIP001 	m_pHeaderBar = _pHeaderBar;
//STRIP001 	SetScrolledHdl( LINK( this, OptHeaderTabListBox, TabBoxScrollHdl_Impl ) );
//STRIP001 }
//STRIP001 
//STRIP001 void OptHeaderTabListBox::InitEntry( SvLBoxEntry* pEntry, const XubString& rTxt,
//STRIP001                                      const Image& rImg1, const Image& rImg2 )
//STRIP001 {
//STRIP001     SvTabListBox::InitEntry( pEntry, rTxt, rImg1, rImg2 );
//STRIP001     USHORT nTabCount = TabCount();
//STRIP001 
//STRIP001     for ( USHORT nCol = 1; nCol < nTabCount; ++nCol )
//STRIP001     {
//STRIP001         // alle Spalten mit eigener Klasse initialisieren (Spalte 0 == Bitmap)
//STRIP001         SvLBoxString* pCol = (SvLBoxString*)pEntry->GetItem( nCol );
//STRIP001         OptLBoxString_Impl* pStr = new OptLBoxString_Impl( pEntry, 0, pCol->GetText() );
//STRIP001         pEntry->ReplaceItem( pStr, nCol );
//STRIP001     }
//STRIP001 }
//STRIP001 
//STRIP001 IMPL_LINK( OptHeaderTabListBox, TabBoxScrollHdl_Impl, SvTabListBox*, pList )
//STRIP001 {
//STRIP001 	m_pHeaderBar->SetOffset( -GetXOffset() );
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 // functions -------------------------------------------------------------
//STRIP001 
//STRIP001 BOOL IsMultiPath_Impl( const USHORT nIndex )
//STRIP001 {
//STRIP001 	return ( SvtPathOptions::PATH_AUTOCORRECT == nIndex ||
//STRIP001 			 SvtPathOptions::PATH_AUTOTEXT == nIndex ||
//STRIP001 			 SvtPathOptions::PATH_BASIC == nIndex ||
//STRIP001 			 SvtPathOptions::PATH_GALLERY == nIndex ||
//STRIP001 			 SvtPathOptions::PATH_TEMPLATE == nIndex );
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 String GetEntryURL_Impl( const USHORT nIndex, const OptHeaderTabListBox* pBox )
//STRIP001 {
//STRIP001 	String aURL;
//STRIP001 	for ( USHORT i = 0; pBox && i < pBox->GetEntryCount(); ++i )
//STRIP001 	{
//STRIP001 		PathUserData_Impl* pUserData = (PathUserData_Impl*)pBox->GetEntry(i)->GetUserData();
//STRIP001 		if ( nIndex == pUserData->nRealId )
//STRIP001 		{
//STRIP001 			INetURLObject aEntry( pUserData->aPathStr, INET_PROT_FILE );
//STRIP001 			aEntry.setFinalSlash();
//STRIP001 			aURL = aEntry.GetMainURL( INetURLObject::DECODE_TO_IURI );
//STRIP001 			break;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	return aURL;
//STRIP001 }
//STRIP001 
//STRIP001 // class SvxPathTabPage --------------------------------------------------
//STRIP001 
//STRIP001 SvxPathTabPage::SvxPathTabPage( Window* pParent, const SfxItemSet& rSet ) :
//STRIP001 
//STRIP001 	SfxTabPage( pParent, SVX_RES( RID_SFXPAGE_PATH ), rSet ),
//STRIP001 
//STRIP001 	aTypeText		( this, ResId( FT_TYPE ) ),
//STRIP001 	aPathText		( this, ResId( FT_PATH ) ),
//STRIP001 	aPathCtrl		( this, ResId( LB_PATH ) ),
//STRIP001 	aStandardBtn	( this, ResId( BTN_STANDARD ) ),
//STRIP001 	aPathBtn		( this, ResId( BTN_PATH ) ),
//STRIP001 	aStdBox			( this, ResId( GB_STD ) ),
//STRIP001 
//STRIP001 	pHeaderBar		( NULL ),
//STRIP001 	pPathBox		( NULL ),
//STRIP001     pImpl           ( new OptPath_Impl(ResId(IMG_LOCK), ResId(IMG_LOCK_HC) ))
//STRIP001 
//STRIP001 {
//STRIP001 	aStandardBtn.SetClickHdl( LINK( this, SvxPathTabPage, StandardHdl_Impl ) );
//STRIP001 	Link aLink = LINK( this, SvxPathTabPage, PathHdl_Impl );
//STRIP001 	aPathBtn.SetClickHdl( aLink );
//STRIP001 	Size aBoxSize = aPathCtrl.GetOutputSizePixel();
//STRIP001 	pHeaderBar = new HeaderBar( &aPathCtrl, WB_BUTTONSTYLE | WB_BOTTOMBORDER );
//STRIP001 	pHeaderBar->SetPosSizePixel( Point( 0, 0 ), Size( aBoxSize.Width(), 16 ) );
//STRIP001 	pHeaderBar->SetSelectHdl( LINK( this, SvxPathTabPage, HeaderSelect_Impl ) );
//STRIP001 	pHeaderBar->SetEndDragHdl( LINK( this, SvxPathTabPage, HeaderEndDrag_Impl ) );
//STRIP001 	Size aSz;
//STRIP001 	aSz.Width() = TAB_WIDTH1;
//STRIP001 	pHeaderBar->InsertItem( ITEMID_TYPE, aTypeText.GetText(),
//STRIP001 							LogicToPixel( aSz, MapMode( MAP_APPFONT ) ).Width(),
//STRIP001 							HIB_LEFT | HIB_VCENTER | HIB_CLICKABLE | HIB_UPARROW );
//STRIP001 	aSz.Width() = TAB_WIDTH2;
//STRIP001 	pHeaderBar->InsertItem( ITEMID_PATH, aPathText.GetText(),
//STRIP001 							LogicToPixel( aSz, MapMode( MAP_APPFONT ) ).Width(),
//STRIP001 							HIB_LEFT | HIB_VCENTER );
//STRIP001 
//STRIP001 	static long nTabs[] = {3, 0, TAB_WIDTH1, TAB_WIDTH1 + TAB_WIDTH2 };
//STRIP001 	Size aHeadSize = pHeaderBar->GetSizePixel();
//STRIP001 
//STRIP001 	WinBits nBits = WB_SORT | WB_HSCROLL | WB_CLIPCHILDREN | WB_TABSTOP;
//STRIP001 	pPathBox = new OptHeaderTabListBox( &aPathCtrl, nBits );
//STRIP001 	aPathCtrl.SetFocusControl( pPathBox );
//STRIP001 	pPathBox->SetWindowBits( nBits );
//STRIP001 	pPathBox->SetDoubleClickHdl( aLink );
//STRIP001 	pPathBox->SetSelectHdl( LINK( this, SvxPathTabPage, PathSelect_Impl ) );
//STRIP001 	pPathBox->SetSelectionMode( MULTIPLE_SELECTION );
//STRIP001 	pPathBox->SetPosSizePixel( Point( 0, aHeadSize.Height() ),
//STRIP001 							   Size( aBoxSize.Width(), aBoxSize.Height() - aHeadSize.Height() ) );
//STRIP001 	pPathBox->SetTabs( &nTabs[0], MAP_APPFONT );
//STRIP001 	pPathBox->InitHeaderBar( pHeaderBar );
//STRIP001 	pPathBox->SetHighlightRange();
//STRIP001 	pPathBox->SetHelpId( HID_OPTPATH_CTL_PATH );
//STRIP001 	pHeaderBar->SetHelpId( HID_OPTPATH_HEADERBAR );
//STRIP001 	pPathBox->Show();
//STRIP001 	pHeaderBar->Show();
//STRIP001 
//STRIP001 	FreeResource();
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 SvxPathTabPage::~SvxPathTabPage()
//STRIP001 {
//STRIP001     // #110603# do not grab focus to a destroyed window !!!
//STRIP001     aPathCtrl.SetFocusControl( NULL );
//STRIP001 
//STRIP001 	pHeaderBar->Hide();
//STRIP001 	for ( USHORT i = 0; i < pPathBox->GetEntryCount(); ++i )
//STRIP001 		delete (PathUserData_Impl*)pPathBox->GetEntry(i)->GetUserData();
//STRIP001 	delete pPathBox;
//STRIP001 	delete pHeaderBar;
//STRIP001 	delete pImpl;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 SfxTabPage*	SvxPathTabPage::Create( Window* pParent,
//STRIP001 									const SfxItemSet& rAttrSet )
//STRIP001 {
//STRIP001 	return ( new SvxPathTabPage( pParent, rAttrSet ) );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 BOOL SvxPathTabPage::FillItemSet( SfxItemSet& rCoreSet )
//STRIP001 {
//STRIP001 	SfxAllEnumItem aPathItem( GetWhich( SID_ATTR_PATHNAME ) );
//STRIP001 	String aBlank( ' ' );
//STRIP001 
//STRIP001 	for ( USHORT i = 0; i < pPathBox->GetEntryCount(); ++i )
//STRIP001 	{
//STRIP001 		PathUserData_Impl* pPathImpl = (PathUserData_Impl*)pPathBox->GetEntry(i)->GetUserData();
//STRIP001 		SfxItemState eState = pPathImpl ? pPathImpl->eState : SFX_ITEM_UNKNOWN;
//STRIP001 		USHORT nRealId = pPathImpl->nRealId;
//STRIP001 
//STRIP001 		switch ( eState )
//STRIP001 		{
//STRIP001 			case SFX_ITEM_SET:
//STRIP001 				// Eintrag in App-Ini machen
//STRIP001 				aPathItem.InsertValue( nRealId, pPathImpl->aPathStr );
//STRIP001 				break;
//STRIP001 
//STRIP001 			case SFX_ITEM_DONTCARE:
//STRIP001 				// Eintrag in App-Ini l"oschen
//STRIP001 				aPathItem.InsertValue( nRealId, String() );
//STRIP001 				break;
//STRIP001 
//STRIP001 			case SFX_ITEM_UNKNOWN:
//STRIP001 				// Eintrag in App-Ini unver"andert lassen
//STRIP001 				aPathItem.InsertValue( nRealId, aBlank );
//STRIP001 				break;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	aPathItem.InsertValue( SvtPathOptions::PATH_CONFIG, aBlank );
//STRIP001 	aPathItem.InsertValue( SvtPathOptions::PATH_FAVORITES, aBlank );
//STRIP001 	aPathItem.InsertValue( SvtPathOptions::PATH_HELP, aBlank );
//STRIP001 	aPathItem.InsertValue( SvtPathOptions::PATH_MODULE, aBlank );
//STRIP001 	aPathItem.InsertValue( SvtPathOptions::PATH_STORAGE, aBlank );
//STRIP001 	if ( Application::IsRemoteServer() )
//STRIP001 		aPathItem.InsertValue( SvtPathOptions::PATH_TEMP, aBlank );
//STRIP001 
//STRIP001 	rCoreSet.Put( aPathItem );
//STRIP001 	return TRUE;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxPathTabPage::Reset( const SfxItemSet& rSet )
//STRIP001 {
//STRIP001 	SfxItemState eItemState = SFX_ITEM_UNKNOWN;
//STRIP001 	const SfxAllEnumItem* pGrpItem = NULL;
//STRIP001 	const SfxAllEnumItem* pNameItem = NULL;
//STRIP001 	USHORT nWhich = GetWhich( SID_ATTR_PATHGROUP );
//STRIP001 
//STRIP001 	// Item mit den Pfad-Gruppen holen
//STRIP001 	eItemState = rSet.GetItemState( nWhich, FALSE, (const SfxPoolItem**)&pGrpItem );
//STRIP001 
//STRIP001 	if ( eItemState == SFX_ITEM_DEFAULT )
//STRIP001 		pGrpItem = (const SfxAllEnumItem*)&( rSet.Get( nWhich ) );
//STRIP001 	else if ( eItemState == SFX_ITEM_DONTCARE )
//STRIP001 		pGrpItem = NULL;
//STRIP001 
//STRIP001 	// Item mit den Pfad-Namen holen
//STRIP001 	nWhich = GetWhich( SID_ATTR_PATHNAME );
//STRIP001 	eItemState = rSet.GetItemState( nWhich, FALSE, (const SfxPoolItem**)&pNameItem );
//STRIP001 
//STRIP001 	if ( eItemState == SFX_ITEM_DEFAULT )
//STRIP001 		pNameItem = (const SfxAllEnumItem*)&( rSet.Get( nWhich ) );
//STRIP001 	else if ( eItemState == SFX_ITEM_DONTCARE )
//STRIP001 		pNameItem = NULL;
//STRIP001 
//STRIP001 	if ( !pGrpItem || !pNameItem )
//STRIP001 	{
//STRIP001 		DBG_ERRORFILE( "keine Pfade" );
//STRIP001 		return;
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( pGrpItem->GetValueCount() != pNameItem->GetValueCount() )
//STRIP001 	{
//STRIP001 		DBG_ERRORFILE( "die Counts der Items sind unterschiedlich" );
//STRIP001 		return;
//STRIP001 	}
//STRIP001 
//STRIP001 	// TabListBox f"ullen
//STRIP001 	pPathBox->Clear();
//STRIP001     SvtPathOptions aPathOpt;
//STRIP001 
//STRIP001 	for ( USHORT i = 0; i < pNameItem->GetValueCount(); ++i )
//STRIP001 	{
//STRIP001 		// Users shouldn't configure these pathes
//STRIP001 		if ( SvtPathOptions::PATH_CONFIG == i || SvtPathOptions::PATH_FAVORITES == i ||
//STRIP001 			 SvtPathOptions::PATH_HELP == i || SvtPathOptions::PATH_MODULE == i ||
//STRIP001 			 SvtPathOptions::PATH_STORAGE == i || ( SvtPathOptions::PATH_TEMP == i && Application::IsRemoteServer() ) )
//STRIP001 			// so don't show them
//STRIP001 			continue;
//STRIP001 
//STRIP001         String aStr( pGrpItem->GetValueTextByPos(i) );
//STRIP001 		String aValue( pNameItem->GetValueTextByPos(i) );
//STRIP001 		aStr += '\t';
//STRIP001         aStr += Convert_Impl( aValue );
//STRIP001 		SvLBoxEntry* pEntry = pPathBox->InsertEntry( aStr );
//STRIP001         BOOL   bReadonly = aPathOpt.IsPathReadonly((SvtPathOptions::Pathes) i);
//STRIP001         if(bReadonly)
//STRIP001         {
//STRIP001             pPathBox->SetCollapsedEntryBmp( pEntry, pImpl->aLockImage,   BMP_COLOR_NORMAL );
//STRIP001             pPathBox->SetCollapsedEntryBmp( pEntry, pImpl->aLockImageHC,   BMP_COLOR_HIGHCONTRAST  );
//STRIP001         }
//STRIP001 		PathUserData_Impl* pPathImpl = new PathUserData_Impl( i );
//STRIP001 		pPathImpl->aPathStr = aValue;
//STRIP001 		pEntry->SetUserData( pPathImpl );
//STRIP001 	}
//STRIP001 
//STRIP001 	String aUserData = GetUserData();
//STRIP001 
//STRIP001 	if ( aUserData.Len() )
//STRIP001 	{
//STRIP001 		// Spaltenbreite restaurieren
//STRIP001 		pHeaderBar->SetItemSize( ITEMID_TYPE, aUserData.GetToken(0).ToInt32() );
//STRIP001 		HeaderEndDrag_Impl( NULL );
//STRIP001 		// Sortierrichtung restaurieren
//STRIP001 		BOOL bUp = (BOOL)(USHORT)aUserData.GetToken(1).ToInt32();
//STRIP001 		HeaderBarItemBits nBits	= pHeaderBar->GetItemBits(ITEMID_TYPE);
//STRIP001 
//STRIP001 		if ( bUp )
//STRIP001 		{
//STRIP001 			nBits &= ~HIB_UPARROW;
//STRIP001 			nBits |= HIB_DOWNARROW;
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			nBits &= ~HIB_DOWNARROW;
//STRIP001 			nBits |= HIB_UPARROW;
//STRIP001 		}
//STRIP001 		pHeaderBar->SetItemBits( ITEMID_TYPE, nBits );
//STRIP001 		HeaderSelect_Impl( NULL );
//STRIP001 	}
//STRIP001 	PathSelect_Impl( NULL );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxPathTabPage::FillUserData()
//STRIP001 {
//STRIP001 	String aUserData = String::CreateFromInt32( pHeaderBar->GetItemSize( ITEMID_TYPE ) );
//STRIP001 	aUserData += ';';
//STRIP001 	HeaderBarItemBits nBits	= pHeaderBar->GetItemBits( ITEMID_TYPE );
//STRIP001 	BOOL bUp = ( ( nBits & HIB_UPARROW ) == HIB_UPARROW );
//STRIP001 	aUserData += bUp ? '1' : '0';
//STRIP001 	SetUserData( aUserData );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SvxPathTabPage, PathSelect_Impl, OptHeaderTabListBox *, EMPTYARG )
//STRIP001 
//STRIP001 /*	[Beschreibung]
//STRIP001 
//STRIP001 */
//STRIP001 
//STRIP001 {
//STRIP001 	USHORT nSelCount = 0;
//STRIP001 	SvLBoxEntry* pEntry = pPathBox->FirstSelected();
//STRIP001 
//STRIP001     //the entry image indicates whether the path is write protected
//STRIP001     Image aEntryImage;
//STRIP001     if(pEntry)
//STRIP001         aEntryImage = pPathBox->GetCollapsedEntryBmp( pEntry );
//STRIP001     BOOL bEnable = !aEntryImage;
//STRIP001 	while ( pEntry && ( nSelCount < 2 ) )
//STRIP001 	{
//STRIP001 		nSelCount++;
//STRIP001 		pEntry = pPathBox->NextSelected( pEntry );
//STRIP001 	}
//STRIP001 
//STRIP001     aPathBtn.Enable( 1 == nSelCount && bEnable);
//STRIP001     aStandardBtn.Enable( nSelCount > 0 && bEnable);
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SvxPathTabPage, StandardHdl_Impl, PushButton *, EMPTYARG )
//STRIP001 {
//STRIP001 	SvLBoxEntry* pEntry = pPathBox->FirstSelected();
//STRIP001 	while ( pEntry )
//STRIP001 	{
//STRIP001 		PathUserData_Impl* pPathImpl = (PathUserData_Impl*)pEntry->GetUserData();
//STRIP001 		String aOldPath = pImpl->_aDefOpt.GetDefaultPath( pPathImpl->nRealId );
//STRIP001 
//STRIP001 		if ( aOldPath.Len() )
//STRIP001 		{
//STRIP001             pPathBox->SetEntryText( Convert_Impl( aOldPath ), pEntry, 1 );
//STRIP001 			pPathImpl->eState = SFX_ITEM_SET;
//STRIP001 			pPathImpl->aPathStr = aOldPath;
//STRIP001 		}
//STRIP001 		pEntry = pPathBox->NextSelected( pEntry );
//STRIP001 	}
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SvxPathTabPage, PathHdl_Impl, PushButton *, EMPTYARG )
//STRIP001 {
//STRIP001 	SvLBoxEntry* pEntry = pPathBox->GetCurEntry();
//STRIP001 	USHORT nPos = ( pEntry != NULL ) ? ( (PathUserData_Impl*)pEntry->GetUserData() )->nRealId : 0;
//STRIP001 	String aPathName;
//STRIP001 	if ( pEntry )
//STRIP001 	{
//STRIP001 		PathUserData_Impl* pPathImpl = (PathUserData_Impl*)pEntry->GetUserData();
//STRIP001 		aPathName = pPathImpl->aPathStr;
//STRIP001 	}
//STRIP001 
//STRIP001     if(pEntry && !(!((OptHeaderTabListBox*)pPathBox)->GetCollapsedEntryBmp(pEntry)))
//STRIP001         return 0;
//STRIP001 
//STRIP001 	if ( IsMultiPath_Impl( nPos ) )
//STRIP001 	{
//STRIP001 		SvxMultiPathDialog aDlg( this );
//STRIP001 		aDlg.SetPath( aPathName );
//STRIP001 
//STRIP001 		if ( aDlg.Execute() == RET_OK && pEntry )
//STRIP001 		{
//STRIP001 			String aNewPath = aDlg.GetPath();
//STRIP001             pPathBox->SetEntryText( Convert_Impl( aNewPath ), pEntry, 1 );
//STRIP001 
//STRIP001 			// merken, da\s er ver"andert wurde
//STRIP001 			nPos = (USHORT)pPathBox->GetModel()->GetAbsPos( pEntry );
//STRIP001 			PathUserData_Impl* pPathImpl = (PathUserData_Impl*)pPathBox->GetEntry(nPos)->GetUserData();
//STRIP001 			pPathImpl->eState = SFX_ITEM_SET;
//STRIP001 			pPathImpl->aPathStr = aNewPath;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else if ( pEntry )
//STRIP001 	{
//STRIP001         try
//STRIP001         {
//STRIP001     		::rtl::OUString aService( RTL_CONSTASCII_USTRINGPARAM( FOLDER_PICKER_SERVICE_NAME ) );
//STRIP001     		Reference < XMultiServiceFactory > xFactory( ::legacy_binfilters::getLegacyProcessServiceFactory() );
//STRIP001 			Reference < XFolderPicker > xFolderPicker( xFactory->createInstance( aService ), UNO_QUERY );
//STRIP001 
//STRIP001 //			svt::SetDialogHelpId( xFolderPicker, HID_OPTIONS_PATHS_SELECTFOLDER );
//STRIP001 
//STRIP001         	INetURLObject aURL( aPathName, INET_PROT_FILE );
//STRIP001         	xFolderPicker->setDisplayDirectory( aURL.GetMainURL( INetURLObject::NO_DECODE ) );
//STRIP001 			short nRet = xFolderPicker->execute();
//STRIP001 
//STRIP001         	if ( ExecutableDialogResults::OK != nRet )
//STRIP001 				return 0;
//STRIP001 
//STRIP001 			// old path is an URL?
//STRIP001 			INetURLObject aObj( aPathName );
//STRIP001 			FASTBOOL bURL = ( aObj.GetProtocol() != INET_PROT_NOT_VALID );
//STRIP001 			String aPathStr = xFolderPicker->getDirectory();
//STRIP001 			INetURLObject aNewObj( aPathStr );
//STRIP001 			aNewObj.removeFinalSlash();
//STRIP001 
//STRIP001 			// then the new path also an URL else system path
//STRIP001 			String aNewPathStr = bURL ? aPathStr : aNewObj.getFSysPath( INetURLObject::FSYS_DETECT );
//STRIP001 
//STRIP001 			FASTBOOL bChanged =
//STRIP001 #ifdef UNX
//STRIP001 // Unix is case sensitive
//STRIP001 								( aNewPathStr != aPathName );
//STRIP001 #else
//STRIP001 								( aNewPathStr.CompareIgnoreCaseToAscii( aPathName ) != COMPARE_EQUAL );
//STRIP001 #endif
//STRIP001 			if ( bChanged )
//STRIP001 			{
//STRIP001                 pPathBox->SetEntryText( Convert_Impl( aNewPathStr ), pEntry, 1 );
//STRIP001 				nPos = (USHORT)pPathBox->GetModel()->GetAbsPos( pEntry );
//STRIP001 				PathUserData_Impl* pPathImpl = (PathUserData_Impl*)pPathBox->GetEntry(nPos)->GetUserData();
//STRIP001 				pPathImpl->eState = SFX_ITEM_SET;
//STRIP001 				pPathImpl->aPathStr = aNewPathStr;
//STRIP001 			}
//STRIP001 		}
//STRIP001         catch( Exception& )
//STRIP001         {
//STRIP001             DBG_ERRORFILE( "SvxPathTabPage::PathHdl_Impl: exception from folder picker" )
//STRIP001         }
//STRIP001 	}
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SvxPathTabPage, HeaderSelect_Impl, HeaderBar*, pBar )
//STRIP001 {
//STRIP001 	if ( pBar && pBar->GetCurItemId() != ITEMID_TYPE )
//STRIP001 		return 0;
//STRIP001 
//STRIP001 	HeaderBarItemBits nBits	= pHeaderBar->GetItemBits(ITEMID_TYPE);
//STRIP001 	BOOL bUp = ( ( nBits & HIB_UPARROW ) == HIB_UPARROW );
//STRIP001 	SvSortMode eMode = SortAscending;
//STRIP001 
//STRIP001 	if ( bUp )
//STRIP001 	{
//STRIP001 		nBits &= ~HIB_UPARROW;
//STRIP001 		nBits |= HIB_DOWNARROW;
//STRIP001 		eMode = SortDescending;
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		nBits &= ~HIB_DOWNARROW;
//STRIP001 		nBits |= HIB_UPARROW;
//STRIP001 	}
//STRIP001 	pHeaderBar->SetItemBits( ITEMID_TYPE, nBits );
//STRIP001 	SvTreeList* pModel = pPathBox->GetModel();
//STRIP001 	pModel->SetSortMode( eMode );
//STRIP001 	pModel->Resort();
//STRIP001 	return 1;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SvxPathTabPage, HeaderEndDrag_Impl, HeaderBar*, pBar )
//STRIP001 {
//STRIP001 	if ( pBar && !pBar->GetCurItemId() )
//STRIP001 		return 0;
//STRIP001 
//STRIP001 	if ( !pHeaderBar->IsItemMode() )
//STRIP001 	{
//STRIP001 		Size aSz;
//STRIP001 		USHORT nTabs = pHeaderBar->GetItemCount();
//STRIP001 		long nTmpSz = 0;
//STRIP001 		long nWidth = pHeaderBar->GetItemSize(ITEMID_TYPE);
//STRIP001 		long nBarWidth = pHeaderBar->GetSizePixel().Width();
//STRIP001 
//STRIP001         if(nWidth < TAB_WIDTH_MIN)
//STRIP001             pHeaderBar->SetItemSize( ITEMID_TYPE, TAB_WIDTH_MIN);
//STRIP001         else if ( ( nBarWidth - nWidth ) < TAB_WIDTH_MIN )
//STRIP001             pHeaderBar->SetItemSize( ITEMID_TYPE, nBarWidth - TAB_WIDTH_MIN );
//STRIP001 
//STRIP001 		for ( USHORT i = 1; i <= nTabs; ++i )
//STRIP001 		{
//STRIP001 			long nWidth = pHeaderBar->GetItemSize(i);
//STRIP001 			aSz.Width() =  nWidth + nTmpSz;
//STRIP001 			nTmpSz += nWidth;
//STRIP001 			pPathBox->SetTab( i, PixelToLogic( aSz, MapMode(MAP_APPFONT) ).Width(), MAP_APPFONT );
//STRIP001 		}
//STRIP001 	}
//STRIP001 	return 1;
//STRIP001 }

}
