/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: svx_optlingu.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 06:39:01 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#pragma hdrstop
// include ---------------------------------------------------------------

#define _SVSTDARR_STRINGSDTOR
#define _SVSTDARR_USHORTS
#ifndef _SVSTDARR_HXX
#include <svtools/svstdarr.hxx>
#endif

#ifndef _SV_MSGBOX_HXX //autogen
#include <vcl/msgbox.hxx>
#endif
#ifndef _SV_FIELD_HXX
#include <vcl/field.hxx>
#endif
#ifndef _SV_FIXED_HXX
#include <vcl/fixed.hxx>
#endif

#ifndef _SHL_HXX
#include <tools/shl.hxx>
#endif
#ifndef _DYNARY_HXX
#include <tools/dynary.hxx>
#endif
#ifndef _SVARRAY_HXX //autogen
#include <svtools/svarray.hxx>
#endif
#ifndef _SVTOOLS_LINGUCFG_HXX_
#include <svtools/lingucfg.hxx>
#endif

#ifndef _UNO_LINGU_HXX
#include <unolingu.hxx>
#endif
#ifndef _SVX_DLGUTIL_HXX
#include <dlgutil.hxx>
#endif
#ifndef _LINGUISTIC_LNGPROPS_HHX_
#include <bf_linguistic/lngprops.hxx>
#endif
#ifndef _UNO_LINGU_HXX
#include <unolingu.hxx>
#endif
#ifndef _SFX_SFXUNO_HXX
#include <bf_sfx2/sfxuno.hxx>
#endif
#ifndef _SFXDISPATCH_HXX
#include <bf_sfx2/dispatch.hxx>
#endif
#ifndef _URLOBJ_HXX
#include <tools/urlobj.hxx>
#endif
#ifndef _COM_SUN_STAR_LANG_XMULTISERVICEFACTORY_HPP_
#include <com/sun/star/lang/XMultiServiceFactory.hpp>
#endif
#ifndef _COMPHELPER_PROCESSFACTORY_HXX_
#include <comphelper/processfactory.hxx>
#endif
#ifndef _COM_SUN_STAR_LINGUISTIC2_XSPELLCHECKER_HPP_
#include <com/sun/star/linguistic2/XSpellChecker.hpp>
#endif
#ifndef _COM_SUN_STAR_LINGUISTIC2_XHYPHENATOR_HPP_
#include <com/sun/star/linguistic2/XHyphenator.hpp>
#endif
#ifndef _COM_SUN_STAR_LINGUISTIC2_XTHESAURUS_HPP_
#include <com/sun/star/linguistic2/XThesaurus.hpp>
#endif
#ifndef _COM_SUN_STAR_LINGUISTIC2_XAVAILABLELOCALES_HPP_
#include <com/sun/star/linguistic2/XAvailableLocales.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_XSERVICEDISPLAYNAME_HPP_
#include <com/sun/star/lang/XServiceDisplayName.hpp>
#endif
#ifndef _COM_SUN_STAR_LINGUISTIC2_DICTIONARYLISTEVENTFLAGS_HPP_
#include <com/sun/star/linguistic2/DictionaryListEventFlags.hpp>
#endif
#ifndef _COM_SUN_STAR_LINGUISTIC2_DICTIONARYLISTEVENT_HPP_
#include <com/sun/star/linguistic2/DictionaryListEvent.hpp>
#endif
#ifndef _COM_SUN_STAR_LINGUISTIC2_XDICTIONARYLISTEVENTLISTENER_HPP_
#include <com/sun/star/linguistic2/XDictionaryListEventListener.hpp>
#endif
#ifndef _COM_SUN_STAR_LINGUISTIC2_XDICTIONARYLIST_HPP_
#include <com/sun/star/linguistic2/XDictionaryList.hpp>
#endif
#ifndef _COM_SUN_STAR_FRAME_XSTORABLE_HPP_
#include <com/sun/star/frame/XStorable.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_COMMANDABORTEDEXCEPTION_HPP_
#include <com/sun/star/ucb/CommandAbortedException.hpp>
#endif
#ifndef _SVLBOX_HXX
#include <svtools/svlbox.hxx>
#endif
#ifndef _SFXENUMITEM_HXX //autogen
#include <svtools/eitem.hxx>
#endif
#ifndef _SFXINTITEM_HXX //autogen
#include <svtools/intitem.hxx>
#endif
#include <bf_sfx2/viewfrm.hxx>

#define _SVX_OPTLINGU_CXX

#include "optlingu.hrc"

#define ITEMID_SPELLCHECK	0
#define ITEMID_HYPHENREGION	0

#include "optdict.hxx"
#include "optitems.hxx"
#include "optlingu.hxx"
#include "dialmgr.hxx"
#include "dialogs.hrc"
#include "helpid.hrc"

#include <ucbhelper/content.hxx>
#ifndef _LEGACYBINFILTERMGR_HXX
#include <legacysmgr/legacy_binfilters_smgr.hxx>	//STRIP002 
#endif
namespace binfilter {

using namespace ::ucb;
using namespace ::rtl;
using namespace ::com::sun::star;
using namespace ::com::sun::star::lang;
using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::linguistic2;
using namespace ::com::sun::star::beans;

//STRIP001 #define C2U(cChar) OUString::createFromAscii(cChar)
//STRIP001 #define SVX_MAX_USERDICTS 20
//STRIP001 #define CBCOL_FIRST		0
//STRIP001 #define CBCOL_SECOND	1
//STRIP001 #define CBCOL_BOTH		2
//STRIP001 
//STRIP001 static const sal_Char cSpell[] = "com.sun.star.linguistic2.SpellChecker";
//STRIP001 static const sal_Char cHyph[] = "com.sun.star.linguistic2.Hyphenator";
//STRIP001 static const sal_Char cThes[] = "com.sun.star.linguistic2.Thesaurus";
//STRIP001 
//STRIP001 // static ----------------------------------------------------------------
//STRIP001 
//STRIP001 static Sequence< INT16 > lcl_LocaleSeqToLangSeq( const Sequence< Locale > &rSeq )
//STRIP001 {
//STRIP001     INT32 nLen = rSeq.getLength();
//STRIP001     Sequence< INT16 > aRes( nLen );
//STRIP001     INT16 *pRes = aRes.getArray();
//STRIP001     const Locale *pSeq = rSeq.getConstArray();
//STRIP001     for (INT32 i = 0;  i < nLen;  ++i)
//STRIP001     {
//STRIP001         pRes[i] = SvxLocaleToLanguage( pSeq[i] );
//STRIP001     }
//STRIP001     return aRes;
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 static BOOL lcl_SeqHasLang( const Sequence< INT16 > &rSeq, INT16 nLang )
//STRIP001 {
//STRIP001     INT32 nLen = rSeq.getLength();
//STRIP001     const INT16 *pLang = rSeq.getConstArray();
//STRIP001     INT32 nPos = -1;
//STRIP001     for (INT32 i = 0;  i < nLen  &&  nPos < 0;  ++i)
//STRIP001     {
//STRIP001         if (nLang == pLang[i])
//STRIP001             nPos = i;
//STRIP001     }
//STRIP001     return nPos < 0 ? FALSE : TRUE;
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 static INT32 lcl_SeqGetEntryPos(
//STRIP001 	const Sequence< OUString > &rSeq, const OUString &rEntry )
//STRIP001 {
//STRIP001 	INT32 i;
//STRIP001 	INT32 nLen = rSeq.getLength();
//STRIP001 	const OUString *pItem = rSeq.getConstArray();
//STRIP001 	for (i = 0;  i < nLen;  ++i)
//STRIP001 	{
//STRIP001 		if (rEntry == pItem[i])
//STRIP001 			break;
//STRIP001 	}
//STRIP001     return i < nLen ? i : -1;
//STRIP001 }
//STRIP001 
//STRIP001 /*--------------------------------------------------
//STRIP001 --------------------------------------------------*/
//STRIP001 
//STRIP001 static const sal_uInt16 nNameLen = 8;
//STRIP001 
//STRIP001 static sal_uInt16 pRanges[] =
//STRIP001 {
//STRIP001 	SID_ATTR_SPELL,
//STRIP001 	SID_ATTR_SPELL,
//STRIP001 	0
//STRIP001 };
//STRIP001 
//STRIP001 sal_Bool KillFile_Impl( const String& rURL )
//STRIP001 {
//STRIP001 	sal_Bool bRet = sal_True;
//STRIP001 	try
//STRIP001 	{
//STRIP001 		Content aCnt( rURL, Reference< ::com::sun::star::ucb::XCommandEnvironment > () );
//STRIP001 		aCnt.executeCommand( OUString::createFromAscii( "delete" ), makeAny( sal_Bool( sal_True ) ) );
//STRIP001 	}
//STRIP001 	catch( ::com::sun::star::ucb::CommandAbortedException& )
//STRIP001 	{
//STRIP001 		DBG_ERRORFILE( "KillFile: CommandAbortedException" );
//STRIP001 		bRet = sal_False;
//STRIP001 	}
//STRIP001 	catch( ... )
//STRIP001 	{
//STRIP001 		DBG_ERRORFILE( "KillFile: Any other exception" );
//STRIP001 		bRet = sal_False;
//STRIP001 	}
//STRIP001 
//STRIP001 	return bRet;
//STRIP001 }
//STRIP001 /* -----------------------------27.11.00 14:07--------------------------------
//STRIP001 
//STRIP001  ---------------------------------------------------------------------------*/
//STRIP001 // 0x 0p 0t 0c nn
//STRIP001 // p: 1 -> parent
//STRIP001 // t: 1 -> spell, 2 -> hyph, 3 -> thes
//STRIP001 // c: 1 -> checked 0 -> unchecked
//STRIP001 // n: index
//STRIP001 
//STRIP001 #define TYPE_SPELL  (BYTE)1
//STRIP001 #define TYPE_HYPH   (BYTE)2
//STRIP001 #define TYPE_THES   (BYTE)3
//STRIP001 
//STRIP001 class ModuleUserData_Impl
//STRIP001 {
//STRIP001 	BOOL bParent;
//STRIP001 	BOOL bIsChecked;
//STRIP001 	BYTE nType;
//STRIP001 	BYTE nIndex;
//STRIP001 	String	sImplName;
//STRIP001 
//STRIP001 public:
//STRIP001 	ModuleUserData_Impl( String sImpName, BOOL bIsParent, BOOL bChecked, BYTE nSetType, BYTE nSetIndex ) :
//STRIP001 		bParent(bIsParent),
//STRIP001 		bIsChecked(bChecked),
//STRIP001 		nType(nSetType),
//STRIP001 		nIndex(nSetIndex),
//STRIP001 		sImplName(sImpName)
//STRIP001 		{
//STRIP001 		}
//STRIP001 	BOOL IsParent() const {return bParent;}
//STRIP001 	BYTE GetType() const {return nType;}
//STRIP001 	BOOL IsChecked() const {return bIsChecked;}
//STRIP001 	BYTE GetIndex() const {return nIndex;}
//STRIP001 	void SetIndex(BYTE nSet)  {nIndex = nSet;}
//STRIP001 	const String& GetImplName() const {return sImplName;}
//STRIP001 
//STRIP001 };
//STRIP001 
//STRIP001 /*--------------------------------------------------
//STRIP001 --------------------------------------------------*/
//STRIP001 class DicUserData
//STRIP001 {
//STRIP001 	ULONG	nVal;
//STRIP001 
//STRIP001 public:
//STRIP001 	DicUserData( ULONG nUserData ) : nVal( nUserData ) {}
//STRIP001 	DicUserData( USHORT nEID,
//STRIP001 				 BOOL bChecked, BOOL bEditable, BOOL bDeletable );
//STRIP001 
//STRIP001 	ULONG	GetUserData() const			{ return nVal; }
//STRIP001 	USHORT	GetEntryId() const			{ return (USHORT)(nVal >> 16); }
//STRIP001 	BOOL	IsChecked() const			{ return (BOOL)(nVal >>  8) & 0x01; }
//STRIP001 	BOOL	IsEditable() const			{ return (BOOL)(nVal >>  9) & 0x01; }
//STRIP001 	BOOL	IsDeletable() const			{ return (BOOL)(nVal >> 10) & 0x01; }
//STRIP001 
//STRIP001 	void	SetChecked( BOOL bVal );
//STRIP001 };
//STRIP001 
//STRIP001 
//STRIP001 DicUserData::DicUserData(
//STRIP001 		USHORT nEID,
//STRIP001 		BOOL bChecked, BOOL bEditable, BOOL bDeletable )
//STRIP001 {
//STRIP001 	DBG_ASSERT( nEID < 65000, "Entry Id out of range" );
//STRIP001 	nVal =  ((ULONG)(0xFFFF & nEID)			<< 16) |
//STRIP001 			((ULONG)(bChecked ? 1 : 0)		<<  8) |
//STRIP001 			((ULONG)(bEditable ? 1 : 0)		<<  9) |
//STRIP001 			((ULONG)(bDeletable ? 1 : 0)	<< 10);
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 void DicUserData::SetChecked( BOOL bVal )
//STRIP001 {
//STRIP001 	nVal &= ~(1UL << 8);
//STRIP001 	nVal |=  (ULONG)(bVal ? 1 : 0) << 8;
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 // class BrwString_Impl -------------------------------------------------
//STRIP001 
//STRIP001 void lcl_SetCheckButton( SvLBoxEntry* pEntry, BOOL bCheck )
//STRIP001 {
//STRIP001 	SvLBoxButton* pItem = (SvLBoxButton*)(pEntry->GetFirstItem(SV_ITEM_ID_LBOXBUTTON));
//STRIP001 
//STRIP001 	DBG_ASSERT(pItem,"SetCheckButton:Item not found")
//STRIP001 	if (((SvLBoxItem*)pItem)->IsA() == SV_ITEM_ID_LBOXBUTTON)
//STRIP001 	{
//STRIP001 		if (bCheck)
//STRIP001 			pItem->SetStateChecked();
//STRIP001 		else
//STRIP001 			pItem->SetStateUnchecked();
//STRIP001 		//InvalidateEntry( pEntry );
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 class BrwStringDic_Impl : public SvLBoxString
//STRIP001 {
//STRIP001 public:
//STRIP001 
//STRIP001 	BrwStringDic_Impl( SvLBoxEntry* pEntry, USHORT nFlags,
//STRIP001 		const String& rStr ) : SvLBoxString( pEntry, nFlags, rStr ) {}
//STRIP001 
//STRIP001 	virtual void Paint( const Point& rPos, SvLBox& rDev, USHORT nFlags,
//STRIP001 											SvLBoxEntry* pEntry);
//STRIP001 };
//STRIP001 
//STRIP001 void BrwStringDic_Impl::Paint( const Point& rPos, SvLBox& rDev, USHORT nFlags,
//STRIP001 	SvLBoxEntry* pEntry )
//STRIP001 {
//STRIP001 	ModuleUserData_Impl* pData = (ModuleUserData_Impl*)pEntry->GetUserData();
//STRIP001 	Point aPos(rPos);
//STRIP001 	Font aOldFont( rDev.GetFont());
//STRIP001 	if(pData->IsParent())
//STRIP001 	{
//STRIP001 		Font aFont( aOldFont );
//STRIP001 		aFont.SetWeight( WEIGHT_BOLD );
//STRIP001 		rDev.SetFont( aFont );
//STRIP001 		aPos.X() = 0;
//STRIP001 	}
//STRIP001 	else
//STRIP001 		aPos.X() += 5;
//STRIP001 	rDev.DrawText( aPos, GetText() );
//STRIP001 	rDev.SetFont( aOldFont );
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 /*--------------------------------------------------
//STRIP001 --------------------------------------------------*/
//STRIP001 
//STRIP001 class OptionsBreakSet : public ModalDialog
//STRIP001 {
//STRIP001 	OKButton 		aOKPB;
//STRIP001 	CancelButton	aCancelPB;
//STRIP001     FixedLine       aValFL;
//STRIP001 	NumericField	aValNF;
//STRIP001 
//STRIP001 public:
//STRIP001 	OptionsBreakSet(Window* pParent, int nRID) :
//STRIP001 			ModalDialog(pParent, ResId(RID_SVXDLG_LNG_ED_NUM_PREBREAK, DIALOG_MGR() )),
//STRIP001 			aOKPB		(this, ResId(BT_OK_PREBREAK)),
//STRIP001 			aCancelPB	(this, ResId(BT_CANCEL_PREBREAK)),
//STRIP001             aValFL      (this, ResId(FL_NUMVAL_PREBREAK)),
//STRIP001 			aValNF		(this, ResId(ED_PREBREAK))
//STRIP001 	{
//STRIP001 		DBG_ASSERT( STR_NUM_PRE_BREAK_DLG   == nRID	||
//STRIP001 					STR_NUM_POST_BREAK_DLG  == nRID	||
//STRIP001 					STR_NUM_MIN_WORDLEN_DLG == nRID, "unexpected RID" );
//STRIP001 
//STRIP001 		if (nRID != -1)
//STRIP001             aValFL.SetText( String( ResId(nRID) ) );
//STRIP001 		FreeResource();
//STRIP001 	}
//STRIP001 
//STRIP001 	NumericField& 	GetNumericFld()	{ return aValNF; }
//STRIP001 };
//STRIP001 
//STRIP001 
//STRIP001 /*--------------------------------------------------
//STRIP001 	Entry IDs for options listbox of dialog
//STRIP001 --------------------------------------------------*/
//STRIP001 
//STRIP001 enum EID_OPTIONS
//STRIP001 {
//STRIP001 	EID_CAPITAL_WORDS,
//STRIP001 	EID_WORDS_WITH_DIGITS,
//STRIP001 	EID_CAPITALIZATION,
//STRIP001 	EID_SPELL_SPECIAL,
//STRIP001 	EID_ALL_LANGUAGES,
//STRIP001 	EID_SPELL_AUTO,
//STRIP001 	EID_HIDE_MARKINGS,
//STRIP001 	EID_OLD_GERMAN,
//STRIP001 	EID_NUM_MIN_WORDLEN,
//STRIP001 	EID_NUM_PRE_BREAK,
//STRIP001 	EID_NUM_POST_BREAK,
//STRIP001 	EID_HYPH_AUTO,
//STRIP001 	EID_HYPH_SPECIAL
//STRIP001 };
//STRIP001 
//STRIP001 //! this array must have an entry for every value of EID_OPTIONS.
//STRIP001 //  It is used to get the respective property name.
//STRIP001 static const char * aEidToPropName[] =
//STRIP001 {
//STRIP001 	"IsSpellUpperCase",			// EID_CAPITAL_WORDS
//STRIP001 	"IsSpellWithDigits",		// EID_WORDS_WITH_DIGITS
//STRIP001 	"IsSpellCapitalization",    // EID_CAPITALIZATION
//STRIP001 	"IsSpellSpecial",			// EID_SPELL_SPECIAL
//STRIP001 	"IsSpellInAllLanguages",	// EID_ALL_LANGUAGES
//STRIP001 	"IsSpellAuto",				// EID_SPELL_AUTO
//STRIP001 	"IsSpellHide",				// EID_HIDE_MARKINGS
//STRIP001 	"IsGermanPreReform",		// EID_OLD_GERMAN
//STRIP001 	"HyphMinWordLength",		// EID_NUM_MIN_WORDLEN,
//STRIP001 	"HyphMinLeading",			// EID_NUM_PRE_BREAK
//STRIP001 	"HyphMinTrailing",			// EID_NUM_POST_BREAK
//STRIP001 	"IsHyphAuto",				// EID_HYPH_AUTO
//STRIP001 	"IsHyphSpecial"				// EID_HYPH_SPECIAL
//STRIP001 };
//STRIP001 
//STRIP001 
//STRIP001 static inline String lcl_GetPropertyName( EID_OPTIONS eEntryId )
//STRIP001 {
//STRIP001 	DBG_ASSERT( (int) eEntryId < sizeof(aEidToPropName) / sizeof(aEidToPropName[0]),
//STRIP001 			"index out of range" );
//STRIP001 	return String::CreateFromAscii( aEidToPropName[ (int) eEntryId ] );
//STRIP001 }
//STRIP001 
//STRIP001 // class OptionsUserData -------------------------------------------------
//STRIP001 
//STRIP001 class OptionsUserData
//STRIP001 {
//STRIP001 	ULONG	nVal;
//STRIP001 
//STRIP001 	void	SetModified();
//STRIP001 
//STRIP001 public:
//STRIP001 	OptionsUserData( ULONG nUserData ) : nVal( nUserData ) {}
//STRIP001 	OptionsUserData( USHORT nEID,
//STRIP001 					 BOOL bHasNV, USHORT nNumVal,
//STRIP001 					 BOOL bCheckable, BOOL bChecked );
//STRIP001 
//STRIP001 	ULONG	GetUserData() const			{ return nVal; }
//STRIP001 	USHORT	GetEntryId() const			{ return (USHORT)(nVal >> 16); }
//STRIP001 	BOOL	HasNumericValue() const		{ return (BOOL)(nVal >> 10) & 0x01; }
//STRIP001 	USHORT	GetNumericValue() const		{ return (USHORT)(nVal & 0xFF); }
//STRIP001 	BOOL	IsChecked() const			{ return (BOOL)(nVal >> 8) & 0x01; }
//STRIP001 	BOOL	IsCheckable() const			{ return (BOOL)(nVal >> 9) & 0x01; }
//STRIP001 	BOOL	IsModified() const			{ return (BOOL)(nVal >> 11) & 0x01; }
//STRIP001 
//STRIP001 	void	SetChecked( BOOL bVal );
//STRIP001 	void	SetNumericValue( BYTE nNumVal );
//STRIP001 };
//STRIP001 
//STRIP001 OptionsUserData::OptionsUserData( USHORT nEID,
//STRIP001 		BOOL bHasNV, USHORT nNumVal,
//STRIP001 		BOOL bCheckable, BOOL bChecked )
//STRIP001 {
//STRIP001 	DBG_ASSERT( nEID < 65000, "Entry Id out of range" );
//STRIP001 	DBG_ASSERT( nNumVal < 256, "value out of range" );
//STRIP001 	nVal =  ((ULONG)(0xFFFF & nEID)			<< 16) |
//STRIP001 			((ULONG)(bHasNV ? 1 : 0)		<< 10) |
//STRIP001 			((ULONG)(bCheckable ? 1 : 0)	<<  9) |
//STRIP001 			((ULONG)(bChecked ? 1 : 0)		<<  8) |
//STRIP001 			((ULONG)(0xFF & nNumVal));
//STRIP001 }
//STRIP001 
//STRIP001 void OptionsUserData::SetChecked( BOOL bVal )
//STRIP001 {
//STRIP001 	if (IsCheckable()  &&  (IsChecked() != bVal))
//STRIP001 	{
//STRIP001 		nVal &= ~(1UL << 8);
//STRIP001 		nVal |=  (ULONG)(bVal ? 1 : 0) << 8;
//STRIP001 		SetModified();
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 void OptionsUserData::SetNumericValue( BYTE nNumVal )
//STRIP001 {
//STRIP001 	DBG_ASSERT( nNumVal < 256, "value out of range" );
//STRIP001 	if (HasNumericValue()  &&  (GetNumericValue() != nNumVal))
//STRIP001 	{
//STRIP001 		nVal &= 0xffffff00;
//STRIP001 		nVal |= (nNumVal);
//STRIP001 		SetModified();
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 void OptionsUserData::SetModified()
//STRIP001 {
//STRIP001 	nVal |=  (ULONG)1 << 11;
//STRIP001 }
//STRIP001 
//STRIP001 // class BrwString_Impl -------------------------------------------------
//STRIP001 
//STRIP001 class BrwString_Impl : public SvLBoxString
//STRIP001 {
//STRIP001 public:
//STRIP001 
//STRIP001 	BrwString_Impl( SvLBoxEntry* pEntry, USHORT nFlags,
//STRIP001 		const String& rStr ) : SvLBoxString( pEntry, nFlags, rStr ) {}
//STRIP001 
//STRIP001 	virtual void Paint( const Point& rPos, SvLBox& rDev, USHORT nFlags,
//STRIP001 											SvLBoxEntry* pEntry);
//STRIP001 };
//STRIP001 
//STRIP001 void BrwString_Impl::Paint( const Point& rPos, SvLBox& rDev, USHORT nFlags,
//STRIP001 	SvLBoxEntry* pEntry )
//STRIP001 {
//STRIP001 	Point aPos(rPos);
//STRIP001 	aPos.X() += 20;
//STRIP001 	rDev.DrawText( aPos, GetText() );
//STRIP001 	if(pEntry->GetUserData())
//STRIP001 	{
//STRIP001 		Point aNewPos(aPos);
//STRIP001 		aNewPos.X() += rDev.GetTextWidth(GetText());
//STRIP001 		Font aOldFont( rDev.GetFont());
//STRIP001 		Font aFont( aOldFont );
//STRIP001 		aFont.SetWeight( WEIGHT_BOLD );
//STRIP001 
//STRIP001 		BOOL bFett = TRUE;
//STRIP001 		USHORT nPos = 0;
//STRIP001 		//??? das untere byte aus dem user data in string wandeln
//STRIP001 		OptionsUserData aData( (ULONG) pEntry->GetUserData() );
//STRIP001 		if(aData.HasNumericValue())
//STRIP001 		{
//STRIP001 			String sTxt( ' ' );
//STRIP001 			sTxt +=  String::CreateFromInt32( aData.GetNumericValue() );
//STRIP001 			rDev.SetFont( aFont );
//STRIP001 			rDev.DrawText( aNewPos, sTxt );
//STRIP001 		}
//STRIP001 
//STRIP001 //			if( STRING_NOTFOUND != nPos )
//STRIP001 //				aNewPos.X() += rDev.GetTextWidth( sTxt );
//STRIP001 
//STRIP001 		rDev.SetFont( aOldFont );
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // ServiceInfo_Impl ----------------------------------------------------
//STRIP001 
//STRIP001 struct ServiceInfo_Impl
//STRIP001 {
//STRIP001 	OUString					sDisplayName;
//STRIP001 	OUString					sSpellImplName;
//STRIP001 	OUString					sHyphImplName;
//STRIP001 	OUString					sThesImplName;
//STRIP001 	Reference <XSpellChecker>	xSpell;
//STRIP001 	Reference <XHyphenator>	    xHyph;
//STRIP001 	Reference <XThesaurus>      xThes;
//STRIP001 	BOOL						bConfigured;
//STRIP001 
//STRIP001     ServiceInfo_Impl() : bConfigured(sal_False) {}
//STRIP001 };
//STRIP001 
//STRIP001 DECLARE_DYNARRAY(ServiceInfoArr, ServiceInfo_Impl *)//STRIP008 ;
//STRIP001 
//STRIP001 DECLARE_TABLE( LangImplNameTable, Sequence< OUString > * )//STRIP008 ;
//STRIP001 
//STRIP001 // SvxLinguData_Impl ----------------------------------------------------
//STRIP001 
//STRIP001 class SvxLinguData_Impl
//STRIP001 {
//STRIP001 	//contains services an implementation names sorted by implementation names
//STRIP001 	ServiceInfoArr			   			aDisplayServiceArr;
//STRIP001     ULONG                               nDisplayServices;
//STRIP001 
//STRIP001     Sequence< Locale >                  aAllServiceLocales;
//STRIP001     LangImplNameTable                   aCfgSpellTable;
//STRIP001     LangImplNameTable                   aCfgHyphTable;
//STRIP001     LangImplNameTable                   aCfgThesTable;
//STRIP001     Reference< XMultiServiceFactory >   xMSF;
//STRIP001     Reference< XLinguServiceManager >   xLinguSrvcMgr;
//STRIP001 
//STRIP001 
//STRIP001     sal_Bool    AddRemove( Sequence< OUString > &rConfigured,
//STRIP001                            const OUString &rImplName, BOOL bAdd );
//STRIP001 
//STRIP001 public:
//STRIP001 	SvxLinguData_Impl();
//STRIP001     SvxLinguData_Impl( const SvxLinguData_Impl &rData );
//STRIP001 	~SvxLinguData_Impl();
//STRIP001 
//STRIP001     SvxLinguData_Impl & operator = (const SvxLinguData_Impl &rData);
//STRIP001 
//STRIP001     Reference<XLinguServiceManager> &   GetManager() { return xLinguSrvcMgr; }
//STRIP001 
//STRIP001     void SetChecked( const Sequence< OUString > &rConfiguredServices );
//STRIP001     void Reconfigure( const OUString &rDisplayName, BOOL bEnable );
//STRIP001 
//STRIP001     const Sequence<Locale> &    GetAllSupportedLocales() { return aAllServiceLocales; }
//STRIP001 
//STRIP001     const LangImplNameTable &   GetSpellTable() const   { return aCfgSpellTable; }
//STRIP001     LangImplNameTable &         GetSpellTable()         { return aCfgSpellTable; }
//STRIP001     const LangImplNameTable &   GetHyphTable() const    { return aCfgHyphTable; }
//STRIP001     LangImplNameTable &         GetHyphTable()          { return aCfgHyphTable; }
//STRIP001     const LangImplNameTable &   GetThesTable() const    { return aCfgThesTable; }
//STRIP001     LangImplNameTable &         GetThesTable()          { return aCfgThesTable; }
//STRIP001 
//STRIP001     const ServiceInfoArr &      GetDisplayServiceArray() const  { return aDisplayServiceArr; }
//STRIP001     ServiceInfoArr &            GetDisplayServiceArray()        { return aDisplayServiceArr; }
//STRIP001 
//STRIP001     const ULONG &   GetDisplayServiceCount() const          { return nDisplayServices; }
//STRIP001     void            SetDisplayServiceCount( ULONG nVal )    { nDisplayServices = nVal; }
//STRIP001 };
//STRIP001 
//STRIP001 //-----------------------------------------------------------------------------
//STRIP001 
//STRIP001 void lcl_MergeLocales(Sequence<Locale>& aAllLocales, const Sequence<Locale>& rAdd)
//STRIP001 {
//STRIP001 	const Locale* pAdd = rAdd.getConstArray();
//STRIP001 	Sequence<Locale> aLocToAdd(rAdd.getLength());
//STRIP001 	const Locale* pAllLocales = aAllLocales.getConstArray();
//STRIP001 	Locale* pLocToAdd = aLocToAdd.getArray();
//STRIP001 	sal_Int32 nFound = 0;
//STRIP001 	sal_Int32 i;
//STRIP001 	for(i = 0; i < rAdd.getLength(); i++)
//STRIP001 	{
//STRIP001 		sal_Bool bFound = sal_False;
//STRIP001 		for(sal_Int32 j = 0; j < aAllLocales.getLength() && !bFound; j++)
//STRIP001 		{
//STRIP001 			bFound = pAdd[i].Language == pAllLocales[j].Language &&
//STRIP001 				pAdd[i].Country == pAllLocales[j].Country;
//STRIP001 		}
//STRIP001 		if(!bFound)
//STRIP001 		{
//STRIP001 			pLocToAdd[nFound++] = pAdd[i];
//STRIP001 		}
//STRIP001 	}
//STRIP001 	sal_Int32 nLength = aAllLocales.getLength();
//STRIP001 	aAllLocales.realloc( nLength + nFound);
//STRIP001 	Locale* pAllLocales2 = aAllLocales.getArray();
//STRIP001 	for(i = 0; i < nFound; i++)
//STRIP001 		pAllLocales2[nLength++] = pLocToAdd[i];
//STRIP001 }
//STRIP001 /* -----------------------------27.11.00 16:48--------------------------------
//STRIP001 
//STRIP001  ---------------------------------------------------------------------------*/
//STRIP001 void lcl_MergeDisplayArray(
//STRIP001         SvxLinguData_Impl &rData,
//STRIP001         const ServiceInfo_Impl* pToAdd )
//STRIP001 {
//STRIP001     ULONG nCnt = 0;
//STRIP001 
//STRIP001     ServiceInfoArr &rSvcInfoArr = rData.GetDisplayServiceArray();
//STRIP001     ULONG nEntries = rData.GetDisplayServiceCount();
//STRIP001 
//STRIP001     ServiceInfo_Impl* pEntry;
//STRIP001     for (ULONG i = 0;  i < nEntries;  ++i)
//STRIP001 	{
//STRIP001         pEntry = rSvcInfoArr.Get(i);
//STRIP001         if (pEntry  &&  pEntry->sDisplayName == pToAdd->sDisplayName)
//STRIP001 		{
//STRIP001 			if(pToAdd->xSpell.is())
//STRIP001 			{
//STRIP001                 DBG_ASSERT( !pEntry->xSpell.is() &&
//STRIP001                             pEntry->sSpellImplName.getLength() == 0,
//STRIP001                             "merge conflict" )
//STRIP001 				pEntry->sSpellImplName = pToAdd->sSpellImplName;
//STRIP001 				pEntry->xSpell = pToAdd->xSpell;
//STRIP001 			}
//STRIP001 			if(pToAdd->xHyph.is())
//STRIP001 			{
//STRIP001                 DBG_ASSERT( !pEntry->xHyph.is() &&
//STRIP001                             pEntry->sHyphImplName.getLength() == 0,
//STRIP001                             "merge conflict" )
//STRIP001 				pEntry->sHyphImplName = pToAdd->sHyphImplName;
//STRIP001 				pEntry->xHyph = pToAdd->xHyph;
//STRIP001 			}
//STRIP001 			if(pToAdd->xThes.is())
//STRIP001 			{
//STRIP001                 DBG_ASSERT( !pEntry->xThes.is() &&
//STRIP001                             pEntry->sThesImplName.getLength() == 0,
//STRIP001                             "merge conflict" )
//STRIP001 				pEntry->sThesImplName = pToAdd->sThesImplName;
//STRIP001 				pEntry->xThes = pToAdd->xThes;
//STRIP001 			}
//STRIP001 			return ;
//STRIP001 		}
//STRIP001         ++nCnt;
//STRIP001 	}
//STRIP001 	ServiceInfo_Impl* pInsert = new ServiceInfo_Impl(*pToAdd);
//STRIP001     rData.GetDisplayServiceArray().Put( nCnt, pInsert );
//STRIP001     rData.SetDisplayServiceCount( nCnt + 1 );
//STRIP001 }
//STRIP001 /* -----------------------------26.11.00 18:07--------------------------------
//STRIP001 
//STRIP001  ---------------------------------------------------------------------------*/
//STRIP001 SvxLinguData_Impl::SvxLinguData_Impl() :
//STRIP001     nDisplayServices    (0)
//STRIP001 {
//STRIP001 	xMSF = ::legacy_binfilters::getLegacyProcessServiceFactory();
//STRIP001 	Reference < XInterface > xI = xMSF->createInstance(
//STRIP001 		C2U( "com.sun.star.linguistic2.LinguServiceManager" ) );
//STRIP001 	xLinguSrvcMgr = Reference<XLinguServiceManager>(xI, UNO_QUERY);
//STRIP001 	DBG_ASSERT(xLinguSrvcMgr.is(), "No linguistic service available!")
//STRIP001 	if(xLinguSrvcMgr.is())
//STRIP001 	{
//STRIP001 		Locale aCurrentLocale;
//STRIP001 	    LanguageType eLang = Application::GetSettings().GetLanguage();
//STRIP001 		SvxLanguageToLocale(aCurrentLocale, eLang);
//STRIP001 		Sequence<Any> aArgs(2);//second arguments has to be empty!
//STRIP001 		aArgs.getArray()[0] <<= SvxGetLinguPropertySet();
//STRIP001 
//STRIP001 		//read spell checker
//STRIP001 		Sequence< OUString > aSpellNames = xLinguSrvcMgr->getAvailableServices(
//STRIP001 						C2U(cSpell),	Locale() );
//STRIP001 		const OUString* pSpellNames = aSpellNames.getConstArray();
//STRIP001 
//STRIP001 		sal_Int32 nIdx;
//STRIP001 		for(nIdx = 0; nIdx < aSpellNames.getLength(); nIdx++)
//STRIP001 		{
//STRIP001 			ServiceInfo_Impl* pInfo = new ServiceInfo_Impl;
//STRIP001 			pInfo->sSpellImplName = pSpellNames[nIdx];
//STRIP001 			pInfo->xSpell = Reference<XSpellChecker>(
//STRIP001 							xMSF->createInstanceWithArguments(pInfo->sSpellImplName, aArgs), UNO_QUERY);
//STRIP001             lcl_MergeLocales( aAllServiceLocales, pInfo->xSpell->getLocales() );
//STRIP001 
//STRIP001             Reference<XServiceDisplayName> xDispName(pInfo->xSpell, UNO_QUERY);
//STRIP001 			if(xDispName.is())
//STRIP001                 pInfo->sDisplayName = xDispName->getServiceDisplayName( aCurrentLocale );
//STRIP001 
//STRIP001             lcl_MergeDisplayArray( *this, pInfo );
//STRIP001         }
//STRIP001 
//STRIP001 		//read hyphenator
//STRIP001 		Sequence< OUString > aHyphNames = xLinguSrvcMgr->getAvailableServices(
//STRIP001 						C2U(cHyph),	Locale() );
//STRIP001 		const OUString* pHyphNames = aHyphNames.getConstArray();
//STRIP001 		for(nIdx = 0; nIdx < aHyphNames.getLength(); nIdx++)
//STRIP001 		{
//STRIP001 			ServiceInfo_Impl* pInfo = new ServiceInfo_Impl;
//STRIP001 			pInfo->sHyphImplName = pHyphNames[nIdx];
//STRIP001 			pInfo->xHyph = Reference<XHyphenator>(
//STRIP001 							xMSF->createInstanceWithArguments(pInfo->sHyphImplName, aArgs), UNO_QUERY);
//STRIP001             lcl_MergeLocales( aAllServiceLocales, pInfo->xHyph->getLocales() );
//STRIP001 
//STRIP001             Reference<XServiceDisplayName> xDispName(pInfo->xHyph, UNO_QUERY);
//STRIP001 			if(xDispName.is())
//STRIP001                 pInfo->sDisplayName = xDispName->getServiceDisplayName( aCurrentLocale );
//STRIP001 
//STRIP001             lcl_MergeDisplayArray( *this, pInfo );
//STRIP001 		}
//STRIP001 
//STRIP001 		//read thesauri
//STRIP001 		Sequence< OUString > aThesNames = xLinguSrvcMgr->getAvailableServices(
//STRIP001 						C2U(cThes),		Locale() );
//STRIP001 		const OUString* pThesNames = aThesNames.getConstArray();
//STRIP001 		for(nIdx = 0; nIdx < aThesNames.getLength(); nIdx++)
//STRIP001 		{
//STRIP001 			ServiceInfo_Impl* pInfo = new ServiceInfo_Impl;
//STRIP001 			pInfo->sThesImplName = pThesNames[nIdx];
//STRIP001 			pInfo->xThes = Reference<XThesaurus>(
//STRIP001 							xMSF->createInstanceWithArguments(pInfo->sThesImplName, aArgs), UNO_QUERY);
//STRIP001             lcl_MergeLocales( aAllServiceLocales, pInfo->xThes->getLocales() );
//STRIP001 
//STRIP001             Reference<XServiceDisplayName> xDispName(pInfo->xThes, UNO_QUERY);
//STRIP001 			if(xDispName.is())
//STRIP001                 pInfo->sDisplayName = xDispName->getServiceDisplayName( aCurrentLocale );
//STRIP001 
//STRIP001             lcl_MergeDisplayArray( *this, pInfo );
//STRIP001 		}
//STRIP001 
//STRIP001         Sequence< OUString > aCfgSvcs;
//STRIP001 		const Locale* pAllLocales = aAllServiceLocales.getConstArray();
//STRIP001 		for(sal_Int32 nLocale = 0; nLocale < aAllServiceLocales.getLength(); nLocale++)
//STRIP001 		{
//STRIP001             INT16 nLang = SvxLocaleToLanguage( pAllLocales[nLocale] );
//STRIP001 
//STRIP001             aCfgSvcs = xLinguSrvcMgr->getConfiguredServices(C2U(cSpell), pAllLocales[nLocale]);
//STRIP001             SetChecked( aCfgSvcs );
//STRIP001             if (aCfgSvcs.getLength())
//STRIP001                 aCfgSpellTable.Insert( nLang, new Sequence< OUString >(aCfgSvcs) );
//STRIP001 
//STRIP001             aCfgSvcs = xLinguSrvcMgr->getConfiguredServices(C2U(cHyph), pAllLocales[nLocale]);
//STRIP001             SetChecked( aCfgSvcs );
//STRIP001             if (aCfgSvcs.getLength())
//STRIP001                 aCfgHyphTable.Insert( nLang, new Sequence< OUString >(aCfgSvcs) );
//STRIP001 
//STRIP001             aCfgSvcs = xLinguSrvcMgr->getConfiguredServices(C2U(cThes), pAllLocales[nLocale]);
//STRIP001             SetChecked( aCfgSvcs );
//STRIP001             if (aCfgSvcs.getLength())
//STRIP001                 aCfgThesTable.Insert( nLang, new Sequence< OUString >(aCfgSvcs) );
//STRIP001 		}
//STRIP001 	}
//STRIP001 }
//STRIP001 /* -----------------------------22.05.01 10:43--------------------------------
//STRIP001 
//STRIP001  ---------------------------------------------------------------------------*/
//STRIP001 SvxLinguData_Impl::SvxLinguData_Impl( const SvxLinguData_Impl &rData ) :
//STRIP001     xMSF                (rData.xMSF),
//STRIP001     xLinguSrvcMgr       (rData.xLinguSrvcMgr),
//STRIP001     aAllServiceLocales  (rData.aAllServiceLocales),
//STRIP001     aDisplayServiceArr  (rData.aDisplayServiceArr),
//STRIP001     nDisplayServices    (rData.nDisplayServices)
//STRIP001 {
//STRIP001 }
//STRIP001 /* -----------------------------22.05.01 10:43--------------------------------
//STRIP001 
//STRIP001  ---------------------------------------------------------------------------*/
//STRIP001 SvxLinguData_Impl & SvxLinguData_Impl::operator = (const SvxLinguData_Impl &rData)
//STRIP001 {
//STRIP001     xMSF                = rData.xMSF;
//STRIP001     xLinguSrvcMgr       = rData.xLinguSrvcMgr;
//STRIP001     aAllServiceLocales  = rData.aAllServiceLocales;
//STRIP001     aDisplayServiceArr  = rData.aDisplayServiceArr;
//STRIP001     nDisplayServices    = rData.nDisplayServices;
//STRIP001     return *this;
//STRIP001 }
//STRIP001 /* -----------------------------26.11.00 18:08--------------------------------
//STRIP001 
//STRIP001  ---------------------------------------------------------------------------*/
//STRIP001 SvxLinguData_Impl::~SvxLinguData_Impl()
//STRIP001 {
//STRIP001     USHORT k;
//STRIP001     aDisplayServiceArr.Clear();
//STRIP001 
//STRIP001     LangImplNameTable *pTable[3] =
//STRIP001     {
//STRIP001         &aCfgSpellTable, &aCfgHyphTable, &aCfgThesTable
//STRIP001     };
//STRIP001     for (USHORT i = 0;  i < 3;  ++i)
//STRIP001     {
//STRIP001         LangImplNameTable &rTable = *pTable[i];
//STRIP001         for (k = 0;  k < rTable.Count();  ++k)
//STRIP001             delete rTable.GetObject(k);
//STRIP001         rTable.Clear();
//STRIP001     }
//STRIP001 }
//STRIP001 /* -----------------------------26.11.00 19:42--------------------------------
//STRIP001 
//STRIP001  ---------------------------------------------------------------------------*/
//STRIP001 void SvxLinguData_Impl::SetChecked(const Sequence<OUString>& rConfiguredServices)
//STRIP001 {
//STRIP001 	const OUString* pConfiguredServices = rConfiguredServices.getConstArray();
//STRIP001 	for(sal_Int32 n = 0; n < rConfiguredServices.getLength(); n++)
//STRIP001 	{
//STRIP001         ServiceInfo_Impl* pEntry;
//STRIP001         for (ULONG i = 0;  i < nDisplayServices;  ++i)
//STRIP001 		{
//STRIP001             pEntry = aDisplayServiceArr.Get(i);
//STRIP001             if (pEntry  &&  !pEntry->bConfigured)
//STRIP001             {
//STRIP001                 const OUString &rSrvcImplName = pConfiguredServices[n];
//STRIP001                 if (rSrvcImplName.getLength()  &&
//STRIP001                     (pEntry->sSpellImplName == rSrvcImplName  ||
//STRIP001                         pEntry->sHyphImplName  == rSrvcImplName  ||
//STRIP001                         pEntry->sThesImplName  == rSrvcImplName))
//STRIP001                 {
//STRIP001                     pEntry->bConfigured = sal_True;
//STRIP001                     break;
//STRIP001                 }
//STRIP001             }
//STRIP001 		}
//STRIP001 	}
//STRIP001 }
//STRIP001 /* -----------------------------26.11.00 20:43--------------------------------
//STRIP001 
//STRIP001  ---------------------------------------------------------------------------*/
//STRIP001 
//STRIP001 sal_Bool SvxLinguData_Impl::AddRemove(
//STRIP001             Sequence< OUString > &rConfigured,
//STRIP001             const OUString &rImplName, BOOL bAdd )
//STRIP001 {
//STRIP001     sal_Bool bRet = sal_False;  // modified?
//STRIP001 
//STRIP001     INT32 nEntries = rConfigured.getLength();
//STRIP001     INT32 nPos = lcl_SeqGetEntryPos(rConfigured, rImplName);
//STRIP001     if (bAdd  &&  nPos < 0)         // add new entry
//STRIP001     {
//STRIP001         rConfigured.realloc( ++nEntries );
//STRIP001         OUString *pConfigured = rConfigured.getArray();
//STRIP001         pConfigured = rConfigured.getArray();
//STRIP001         pConfigured[nEntries - 1] = rImplName;
//STRIP001         bRet = sal_True;
//STRIP001     }
//STRIP001     else if (!bAdd  &&  nPos >= 0)  // remove existing entry
//STRIP001     {
//STRIP001         OUString *pConfigured = rConfigured.getArray();
//STRIP001         for (INT32 i = nPos;  i < nEntries - 1;  ++i)
//STRIP001             pConfigured[i] = pConfigured[i + 1];
//STRIP001         rConfigured.realloc(--nEntries);
//STRIP001         bRet = sal_True;
//STRIP001     }
//STRIP001 
//STRIP001 	return bRet;
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 void SvxLinguData_Impl::Reconfigure( const OUString &rDisplayName, BOOL bEnable )
//STRIP001 {
//STRIP001     DBG_ASSERT( rDisplayName.getLength(), "empty DisplayName" );
//STRIP001 
//STRIP001     ServiceInfo_Impl *pInfo = 0;
//STRIP001     ServiceInfo_Impl *pTmp;
//STRIP001     for (ULONG i = 0;  i < nDisplayServices;  ++i)
//STRIP001     {
//STRIP001         pTmp = aDisplayServiceArr.Get(i);
//STRIP001         if (pTmp  &&  pTmp->sDisplayName == rDisplayName)
//STRIP001         {
//STRIP001             pInfo = pTmp;
//STRIP001             break;
//STRIP001         }
//STRIP001     }
//STRIP001     DBG_ASSERT( pInfo, "DisplayName entry not found" );
//STRIP001     if (pInfo)
//STRIP001     {
//STRIP001         pInfo->bConfigured = bEnable;
//STRIP001 
//STRIP001         Sequence< Locale > aLocales;
//STRIP001         const Locale *pLocale = 0;
//STRIP001         INT32 nLocales = 0;
//STRIP001         INT32 i;
//STRIP001 
//STRIP001         // update configured spellchecker entries
//STRIP001         if (pInfo->xSpell.is())
//STRIP001         {
//STRIP001             aLocales = pInfo->xSpell->getLocales();
//STRIP001             pLocale = aLocales.getConstArray();
//STRIP001             nLocales = aLocales.getLength();
//STRIP001             for (i = 0;  i < nLocales;  ++i)
//STRIP001             {
//STRIP001                 INT16 nLang = SvxLocaleToLanguage( pLocale[i] );
//STRIP001                 Sequence< OUString > *pCfgImplNames = aCfgSpellTable.Get( nLang );
//STRIP001                 if (!pCfgImplNames && bEnable)
//STRIP001                 {
//STRIP001                     pCfgImplNames = new Sequence< OUString >();
//STRIP001                     aCfgSpellTable.Insert( nLang, pCfgImplNames );
//STRIP001                 }
//STRIP001                 if (pCfgImplNames)
//STRIP001                     AddRemove( *pCfgImplNames, pInfo->sSpellImplName, bEnable );
//STRIP001             }
//STRIP001         }
//STRIP001 
//STRIP001         // update configured hyphenator entries
//STRIP001         if (pInfo->xHyph.is())
//STRIP001         {
//STRIP001             aLocales = pInfo->xHyph->getLocales();
//STRIP001             pLocale = aLocales.getConstArray();
//STRIP001             nLocales = aLocales.getLength();
//STRIP001             for (i = 0;  i < nLocales;  ++i)
//STRIP001             {
//STRIP001                 INT16 nLang = SvxLocaleToLanguage( pLocale[i] );
//STRIP001                 Sequence< OUString > *pCfgImplNames = aCfgHyphTable.Get( nLang );
//STRIP001                 if (!pCfgImplNames && bEnable)
//STRIP001                 {
//STRIP001                     pCfgImplNames = new Sequence< OUString >();
//STRIP001                     aCfgHyphTable.Insert( nLang, pCfgImplNames );
//STRIP001                 }
//STRIP001                 if (pCfgImplNames)
//STRIP001                     AddRemove( *pCfgImplNames, pInfo->sHyphImplName, bEnable );
//STRIP001             }
//STRIP001         }
//STRIP001 
//STRIP001         // update configured spellchecker entries
//STRIP001         if (pInfo->xThes.is())
//STRIP001         {
//STRIP001             aLocales = pInfo->xThes->getLocales();
//STRIP001             pLocale = aLocales.getConstArray();
//STRIP001             nLocales = aLocales.getLength();
//STRIP001             for (i = 0;  i < nLocales;  ++i)
//STRIP001             {
//STRIP001                 INT16 nLang = SvxLocaleToLanguage( pLocale[i] );
//STRIP001                 Sequence< OUString > *pCfgImplNames = aCfgThesTable.Get( nLang );
//STRIP001                 if (!pCfgImplNames && bEnable)
//STRIP001                 {
//STRIP001                     pCfgImplNames = new Sequence< OUString >();
//STRIP001                     aCfgThesTable.Insert( nLang, pCfgImplNames );
//STRIP001                 }
//STRIP001                 if (pCfgImplNames)
//STRIP001                     AddRemove( *pCfgImplNames, pInfo->sThesImplName, bEnable );
//STRIP001             }
//STRIP001         }
//STRIP001     }
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 // SvxModulesData_Impl ---------------------------------------------------
//STRIP001 
//STRIP001 // list of service-implemantation names associated to a specific modules
//STRIP001 // UI name.
//STRIP001 struct SvxModulesData_Impl
//STRIP001 {
//STRIP001     // list of service implementation names
//STRIP001     OUString    aSpellImplName;
//STRIP001     OUString    aHyphImplName;
//STRIP001     OUString    aThesImplName;
//STRIP001 
//STRIP001     // is at least one of them configured to be used in any language?
//STRIP001     BOOL        bIsConfigured;
//STRIP001 
//STRIP001     SvxModulesData_Impl(const OUString &rSpellImpl,
//STRIP001                         const OUString &rHyphImpl,
//STRIP001                         const OUString &rThesImpl, BOOL bVal) :
//STRIP001         aSpellImplName  (rSpellImpl),
//STRIP001         aHyphImplName   (rHyphImpl),
//STRIP001         aThesImplName   (rThesImpl),
//STRIP001         bIsConfigured   (bVal)
//STRIP001     {
//STRIP001     }
//STRIP001 };
//STRIP001 
//STRIP001 // class SvxLinguTabPage -------------------------------------------------
//STRIP001 
//STRIP001 #define CBCOL_FIRST		0
//STRIP001 #define CBCOL_SECOND	1
//STRIP001 #define CBCOL_BOTH		2
//STRIP001 
//STRIP001 SvxLinguTabPage::SvxLinguTabPage( Window* pParent,
//STRIP001 								  const SfxItemSet& rSet ):
//STRIP001 
//STRIP001 	SfxTabPage( pParent, ResId( RID_SFXPAGE_LINGU, DIALOG_MGR() ), rSet ),
//STRIP001 
//STRIP001     aLinguisticFL       ( this, ResId( FL_LINGUISTIC ) ),
//STRIP001 	aLinguModulesFT		( this, ResId( FT_LINGU_MODULES ) ),
//STRIP001 	aLinguModulesCLB	( this, ResId( CLB_LINGU_MODULES ) ),
//STRIP001 	aLinguModulesEditPB	( this, ResId( PB_LINGU_MODULES_EDIT ) ),
//STRIP001     aLinguDicsFT        ( this, ResId( FT_LINGU_DICS ) ),
//STRIP001     aLinguDicsCLB       ( this, ResId( CLB_LINGU_DICS ) ),
//STRIP001     aLinguDicsNewPB     ( this, ResId( PB_LINGU_DICS_NEW_DIC ) ),
//STRIP001     aLinguDicsEditPB    ( this, ResId( PB_LINGU_DICS_EDIT_DIC ) ),
//STRIP001     aLinguDicsDelPB     ( this, ResId( PB_LINGU_DICS_DEL_DIC ) ),
//STRIP001 	aLinguOptionsFT		( this, ResId( FT_LINGU_OPTIONS ) ),
//STRIP001 	aLinguOptionsCLB	( this, ResId( CLB_LINGU_OPTIONS ) ),
//STRIP001 	aLinguOptionsEditPB	( this, ResId( PB_LINGU_OPTIONS_EDIT ) ),
//STRIP001 	sCapitalWords		( ResId( STR_CAPITAL_WORDS ) ),
//STRIP001 	sWordsWithDigits	( ResId( STR_WORDS_WITH_DIGITS ) ),
//STRIP001 	sCapitalization		( ResId( STR_CAPITALIZATION ) ),
//STRIP001 	sSpellSpecial		( ResId( STR_SPELL_SPECIAL ) ),
//STRIP001 	sAllLanguages		( ResId( STR_ALL_LANGUAGES ) ),
//STRIP001 	sSpellAuto			( ResId( STR_SPELL_AUTO ) ),
//STRIP001 	sHideMarkings		( ResId( STR_HIDE_MARKINGS ) ),
//STRIP001 	sOldGerman			( ResId( STR_OLD_GERMAN ) ),
//STRIP001 	sNumMinWordlen  	( ResId( STR_NUM_MIN_WORDLEN ) ),
//STRIP001 	sNumPreBreak		( ResId( STR_NUM_PRE_BREAK ) ),
//STRIP001 	sNumPostBreak		( ResId( STR_NUM_POST_BREAK ) ),
//STRIP001 	sHyphAuto			( ResId( STR_HYPH_AUTO ) ),
//STRIP001 	sHyphSpecial		( ResId( STR_HYPH_SPECIAL ) ),
//STRIP001 
//STRIP001 	pLinguData			( NULL )
//STRIP001 {
//STRIP001 	pCheckButtonData = NULL;
//STRIP001 
//STRIP001     aLinguModulesCLB.SetWindowBits( WB_CLIPCHILDREN|WB_HSCROLL|WB_FORCE_MAKEVISIBLE );
//STRIP001 	aLinguModulesCLB.SetHelpId(HID_CLB_LINGU_MODULES );
//STRIP001 	aLinguModulesCLB.SetHighlightRange();
//STRIP001 	aLinguModulesCLB.SetSelectHdl( LINK( this, SvxLinguTabPage, SelectHdl_Impl ));
//STRIP001     aLinguModulesCLB.SetDoubleClickHdl(LINK(this, SvxLinguTabPage, BoxDoubleClickHdl_Impl));
//STRIP001     aLinguModulesCLB.SetCheckButtonHdl(LINK(this, SvxLinguTabPage, BoxCheckButtonHdl_Impl));
//STRIP001 
//STRIP001 	aLinguModulesEditPB.SetClickHdl( LINK( this, SvxLinguTabPage, ClickHdl_Impl ));
//STRIP001 	aLinguOptionsEditPB.SetClickHdl( LINK( this, SvxLinguTabPage, ClickHdl_Impl ));
//STRIP001 
//STRIP001     aLinguDicsCLB.SetWindowBits( WB_CLIPCHILDREN|WB_HSCROLL|WB_FORCE_MAKEVISIBLE );
//STRIP001     aLinguDicsCLB.SetHelpId(HID_CLB_EDIT_MODULES_DICS );
//STRIP001     aLinguDicsCLB.SetHighlightRange();
//STRIP001     aLinguDicsCLB.SetSelectHdl( LINK( this, SvxLinguTabPage, SelectHdl_Impl ));
//STRIP001     aLinguDicsCLB.SetCheckButtonHdl(LINK(this, SvxLinguTabPage, BoxCheckButtonHdl_Impl));
//STRIP001 
//STRIP001     aLinguDicsNewPB.SetClickHdl( LINK( this, SvxLinguTabPage, ClickHdl_Impl ));
//STRIP001     aLinguDicsEditPB.SetClickHdl( LINK( this, SvxLinguTabPage, ClickHdl_Impl ));
//STRIP001     aLinguDicsDelPB.SetClickHdl( LINK( this, SvxLinguTabPage, ClickHdl_Impl ));
//STRIP001 
//STRIP001     aLinguOptionsCLB.SetWindowBits( WB_CLIPCHILDREN|WB_HSCROLL|WB_FORCE_MAKEVISIBLE );
//STRIP001 	aLinguOptionsCLB.SetHelpId(HID_CLB_LINGU_OPTIONS );
//STRIP001 	aLinguOptionsCLB.SetHighlightRange();
//STRIP001 	aLinguOptionsCLB.SetSelectHdl( LINK( this, SvxLinguTabPage, SelectHdl_Impl ));
//STRIP001     aLinguOptionsCLB.SetDoubleClickHdl(LINK(this, SvxLinguTabPage, BoxDoubleClickHdl_Impl));
//STRIP001 
//STRIP001 	xProp = Reference< XPropertySet >( SvxGetLinguPropertySet(), UNO_QUERY );
//STRIP001 
//STRIP001 	xDicList = Reference< XDictionaryList >( SvxGetDictionaryList(), UNO_QUERY );
//STRIP001 	if (xDicList.is())
//STRIP001 	{
//STRIP001         // keep references to all **currently** available dictionaries,
//STRIP001         // since the diclist may get changed meanwhile (e.g. through the API).
//STRIP001         // We want the dialog to operate on the same set of dictionaries it
//STRIP001         // was started with.
//STRIP001         // Also we have to take care to not loose the last reference when 
//STRIP001         // someone else removes a dictionary from the list.
//STRIP001         // removed dics will be replaced by NULL new entries be added to the end
//STRIP001         // Thus we may use indizes as consistent references.
//STRIP001         aDics = xDicList->getDictionaries();
//STRIP001         
//STRIP001         UpdateDicBox_Impl();
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001         aLinguDicsFT.Disable();
//STRIP001         aLinguDicsCLB.Disable();
//STRIP001         aLinguDicsNewPB.Disable();
//STRIP001         aLinguDicsEditPB.Disable();
//STRIP001         aLinguDicsDelPB.Disable();
//STRIP001 	}
//STRIP001 
//STRIP001 	const SfxSpellCheckItem* pItem = 0;
//STRIP001 	SfxItemState eItemState = SFX_ITEM_UNKNOWN;
//STRIP001 
//STRIP001 	eItemState = rSet.GetItemState( GetWhich( SID_ATTR_SPELL ),
//STRIP001 									sal_False, (const SfxPoolItem**)&pItem );
//STRIP001 
//STRIP001 	// handelt es sich um ein Default-Item?
//STRIP001 	if ( eItemState == SFX_ITEM_DEFAULT )
//STRIP001 		pItem = (const SfxSpellCheckItem*)&(rSet.Get( GetWhich( SID_ATTR_SPELL ) ) );
//STRIP001 	else if ( eItemState == SFX_ITEM_DONTCARE )
//STRIP001 		pItem = NULL;
//STRIP001 
//STRIP001 	FreeResource();
//STRIP001 
//STRIP001     SvxLinguConfigUpdate::UpdateAll();
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 SvxLinguTabPage::~SvxLinguTabPage()
//STRIP001 {
//STRIP001 	if (pLinguData)
//STRIP001 		delete pLinguData;
//STRIP001 	for(sal_uInt16 nEntry = 0; nEntry < aLinguModulesCLB.GetEntryCount(); nEntry++)
//STRIP001 	{
//STRIP001 		SvxModulesData_Impl* pData = (SvxModulesData_Impl*)aLinguModulesCLB.GetEntry(nEntry)->GetUserData();
//STRIP001 		delete pData;
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 //nicht berladen wegschmeissen
//STRIP001 sal_uInt16* SvxLinguTabPage::GetRanges()
//STRIP001 {
//STRIP001 	//TL???
//STRIP001 	return pRanges;
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 SfxTabPage* SvxLinguTabPage::Create( Window* pParent,
//STRIP001 									 const SfxItemSet& rAttrSet )
//STRIP001 {
//STRIP001 	return ( new SvxLinguTabPage( pParent, rAttrSet ) );
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 Any lcl_Bool2Any(BOOL bVal)
//STRIP001 {
//STRIP001 	Any aRet(&bVal, ::getBooleanCppuType());
//STRIP001 	return aRet;
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 sal_Bool lcl_Bool2Any(Any& rVal)
//STRIP001 {
//STRIP001 	return *(sal_Bool*)rVal.getValue();
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 sal_Bool SvxLinguTabPage::FillItemSet( SfxItemSet& rCoreSet )
//STRIP001 {
//STRIP001 	sal_Bool bModified = sal_True; // !!!!
//STRIP001 
//STRIP001 	// if not HideGroups was called with GROUP_MODULES...
//STRIP001 	if (aLinguModulesCLB.IsVisible())
//STRIP001 	{
//STRIP001         DBG_ASSERT( pLinguData, "pLinguData not yet initialized" );
//STRIP001         if (!pLinguData)
//STRIP001             pLinguData =    new SvxLinguData_Impl;
//STRIP001 
//STRIP001         ULONG i;
//STRIP001 
//STRIP001         // update spellchecker configuration entries
//STRIP001         const LangImplNameTable *pTable = &pLinguData->GetSpellTable();
//STRIP001         for (i = 0;  i < pTable->Count();  ++i)
//STRIP001         {
//STRIP001             INT16 nLang = (INT16) pTable->GetObjectKey(i);
//STRIP001             const Sequence< OUString > *pImplNames = pTable->GetObject(i);
//STRIP001             DBG_ASSERT( pImplNames, "service implementation names missing" )
//STRIP001             if (pImplNames)
//STRIP001             {
//STRIP001 #if OSL_DEBUG_LEVEL > 1
//STRIP001                 const OUString *pTmpStr = pImplNames->getConstArray();
//STRIP001 #endif
//STRIP001                 Reference< XLinguServiceManager > xMgr( pLinguData->GetManager() );
//STRIP001                 Locale aLocale( SvxCreateLocale(nLang) );
//STRIP001                 if (xMgr.is())
//STRIP001                     xMgr->setConfiguredServices( C2U(cSpell), aLocale, *pImplNames );
//STRIP001             }
//STRIP001         }
//STRIP001 
//STRIP001         // update hyphenator configuration entries
//STRIP001         pTable = &pLinguData->GetHyphTable();
//STRIP001         for (i = 0;  i < pTable->Count();  ++i)
//STRIP001         {
//STRIP001             INT16 nLang = (INT16) pTable->GetObjectKey(i);
//STRIP001             const Sequence< OUString > *pImplNames = pTable->GetObject(i);
//STRIP001             DBG_ASSERT( pImplNames, "service implementation names missing" )
//STRIP001             if (pImplNames)
//STRIP001             {
//STRIP001                 Reference< XLinguServiceManager > xMgr( pLinguData->GetManager() );
//STRIP001                 Locale aLocale( SvxCreateLocale(nLang) );
//STRIP001                 if (xMgr.is())
//STRIP001                     xMgr->setConfiguredServices( C2U(cHyph), aLocale, *pImplNames );
//STRIP001             }
//STRIP001         }
//STRIP001 
//STRIP001         // update thesaurus configuration entries
//STRIP001         pTable = &pLinguData->GetThesTable();
//STRIP001         for (i = 0;  i < pTable->Count();  ++i)
//STRIP001         {
//STRIP001             INT16 nLang = (INT16) pTable->GetObjectKey(i);
//STRIP001             const Sequence< OUString > *pImplNames = pTable->GetObject(i);
//STRIP001             DBG_ASSERT( pImplNames, "service implementation names missing" )
//STRIP001             if (pImplNames)
//STRIP001             {
//STRIP001                 Reference< XLinguServiceManager > xMgr( pLinguData->GetManager() );
//STRIP001                 Locale aLocale( SvxCreateLocale(nLang) );
//STRIP001                 if (xMgr.is())
//STRIP001                     xMgr->setConfiguredServices( C2U(cThes), aLocale, *pImplNames );
//STRIP001             }
//STRIP001         }
//STRIP001 	}
//STRIP001 
//STRIP001 
//STRIP001     //
//STRIP001     // activate dictionaries according to checkbox state
//STRIP001     //
//STRIP001     Sequence< OUString > aActiveDics;
//STRIP001     INT32 nActiveDics = 0;
//STRIP001     ULONG nEntries = aLinguDicsCLB.GetEntryCount();
//STRIP001     for (ULONG i = 0;  i < nEntries;  ++i)
//STRIP001     {
//STRIP001         INT32 nDics = aDics.getLength();
//STRIP001         const Reference< XDictionary > *pDic = aDics.getConstArray();
//STRIP001 
//STRIP001         aActiveDics.realloc( nDics );
//STRIP001         OUString *pActiveDic = aActiveDics.getArray();
//STRIP001 
//STRIP001         SvLBoxEntry *pEntry = aLinguDicsCLB.GetEntry( i );
//STRIP001         if (pEntry)
//STRIP001         {
//STRIP001             DicUserData aData( (ULONG)pEntry->GetUserData() );
//STRIP001             if (aData.GetEntryId() < nDics)
//STRIP001             {
//STRIP001                 BOOL bChecked = aLinguDicsCLB.IsChecked( (USHORT) i );
//STRIP001                 Reference< XDictionary > xDic( aDics.getConstArray()[ i ] );
//STRIP001                 if (xDic.is())
//STRIP001                 {
//STRIP001                     if (SvxGetIgnoreAllList() == xDic)
//STRIP001                         bChecked = TRUE;
//STRIP001                     xDic->setActive( bChecked );
//STRIP001 
//STRIP001                     if (bChecked)
//STRIP001                     {
//STRIP001                         String aDicName( xDic->getName() );
//STRIP001                         pActiveDic[ nActiveDics++ ] = aDicName;
//STRIP001                     }
//STRIP001                 }
//STRIP001             }
//STRIP001         }
//STRIP001     }
//STRIP001     //
//STRIP001     aActiveDics.realloc( nActiveDics );
//STRIP001     Any aTmp;
//STRIP001     aTmp <<= aActiveDics;
//STRIP001     SvtLinguConfig aLngCfg;
//STRIP001     aLngCfg.SetProperty( UPH_ACTIVE_DICTIONARIES, aTmp );
//STRIP001 
//STRIP001 
//STRIP001 	BOOL bCheckAllLangChanged = FALSE;
//STRIP001 
//STRIP001     nEntries = aLinguOptionsCLB.GetEntryCount();
//STRIP001     for (USHORT j = 0;  j < nEntries;  ++j)
//STRIP001 	{
//STRIP001 		SvLBoxEntry *pEntry = aLinguOptionsCLB.GetEntry( j );
//STRIP001 
//STRIP001 		OptionsUserData aData( (ULONG)pEntry->GetUserData() );
//STRIP001 		String aPropName( lcl_GetPropertyName( (EID_OPTIONS) aData.GetEntryId() ) );
//STRIP001 
//STRIP001 		if (EID_ALL_LANGUAGES == (EID_OPTIONS) aData.GetEntryId())
//STRIP001 		{
//STRIP001 			bCheckAllLangChanged = aData.IsChecked() != aLinguOptionsCLB.IsChecked( j );
//STRIP001 		}
//STRIP001 
//STRIP001 		Any aAny;
//STRIP001 		if (aData.IsCheckable())
//STRIP001 		{
//STRIP001 			BOOL bChecked = aLinguOptionsCLB.IsChecked( j );
//STRIP001 			aAny <<= bChecked;
//STRIP001 		}
//STRIP001 		else if (aData.HasNumericValue())
//STRIP001 		{
//STRIP001 			INT16 nVal = aData.GetNumericValue();
//STRIP001 			aAny <<= nVal;
//STRIP001 		}
//STRIP001 
//STRIP001 		if (xProp.is())
//STRIP001 			xProp->setPropertyValue( aPropName, aAny );
//STRIP001 		aLngCfg.SetProperty( aPropName, aAny );
//STRIP001 	}
//STRIP001 
//STRIP001 	rCoreSet.Put( SfxBoolItem( SID_SPELL_MODIFIED, bCheckAllLangChanged ) );
//STRIP001 
//STRIP001 	SvLBoxEntry *pPreBreakEntry  = aLinguOptionsCLB.GetEntry( (USHORT) EID_NUM_PRE_BREAK );
//STRIP001 	SvLBoxEntry *pPostBreakEntry = aLinguOptionsCLB.GetEntry( (USHORT) EID_NUM_POST_BREAK );
//STRIP001 	DBG_ASSERT( pPreBreakEntry, "NULL Pointer" );
//STRIP001 	DBG_ASSERT( pPostBreakEntry, "NULL Pointer" );
//STRIP001 	if (pPreBreakEntry && pPostBreakEntry)
//STRIP001 	{
//STRIP001 		OptionsUserData aPreBreakData( (ULONG)pPreBreakEntry->GetUserData() );
//STRIP001 		OptionsUserData aPostBreakData( (ULONG)pPostBreakEntry->GetUserData() );
//STRIP001 		if ( aPreBreakData.IsModified() || aPostBreakData.IsModified() )
//STRIP001 		{
//STRIP001 			SfxHyphenRegionItem aHyp( GetWhich( SID_ATTR_HYPHENREGION ) );
//STRIP001 			aHyp.GetMinLead()  = (UINT8) aPreBreakData.GetNumericValue();
//STRIP001 			aHyp.GetMinTrail() = (UINT8) aPostBreakData.GetNumericValue();
//STRIP001 			rCoreSet.Put( aHyp );
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 
//STRIP001 	// Autom. Rechtschreibung
//STRIP001 	BOOL bNewAutoCheck = aLinguOptionsCLB.IsChecked( (USHORT) EID_SPELL_AUTO );
//STRIP001 	const SfxPoolItem* pOld = GetOldItem( rCoreSet, SID_AUTOSPELL_CHECK );
//STRIP001 	if ( !pOld || ( (SfxBoolItem*)pOld )->GetValue() != bNewAutoCheck )
//STRIP001 	{
//STRIP001 		rCoreSet.Put( SfxBoolItem( GetWhich( SID_AUTOSPELL_CHECK ),
//STRIP001 								bNewAutoCheck ) );
//STRIP001 		bModified |= sal_True;
//STRIP001 	}
//STRIP001 
//STRIP001 	// pOld ist alte Wert wenn wert gendert mit neuen Wert ins Item Set
//STRIP001 	BOOL bNewMarkOff = aLinguOptionsCLB.IsChecked( (USHORT) EID_HIDE_MARKINGS );
//STRIP001 	pOld = GetItem( rCoreSet, SID_AUTOSPELL_MARKOFF );
//STRIP001 	if ( !pOld || ( (SfxBoolItem*)pOld )->GetValue() != bNewMarkOff )
//STRIP001 	{
//STRIP001 		rCoreSet.Put( SfxBoolItem( GetWhich( SID_AUTOSPELL_MARKOFF ),
//STRIP001 								   bNewMarkOff ) );
//STRIP001 		bModified |= sal_True;
//STRIP001 	}
//STRIP001 
//STRIP001 	return bModified;
//STRIP001 }
//STRIP001 
//STRIP001 // ----------------------------------------------------------------------
//STRIP001 
//STRIP001 ULONG SvxLinguTabPage::GetDicUserData( const Reference< XDictionary > &rxDic, USHORT nIdx )
//STRIP001 {
//STRIP001     ULONG nRes = 0;
//STRIP001     DBG_ASSERT( rxDic.is(), "dictionary not supplied" );
//STRIP001     if (rxDic.is())
//STRIP001     {
//STRIP001         Reference< frame::XStorable > xStor( rxDic, UNO_QUERY );
//STRIP001 
//STRIP001         ULONG nUserData = 0;
//STRIP001         BOOL bChecked = rxDic->isActive();
//STRIP001         BOOL bEditable = !xStor.is() || !xStor->isReadonly();
//STRIP001         BOOL bDeletable = bEditable;
//STRIP001         BOOL bNegativ = rxDic->getDictionaryType() == DictionaryType_NEGATIVE;
//STRIP001 
//STRIP001         nRes = DicUserData( nIdx,
//STRIP001                 bChecked, bEditable, bDeletable ).GetUserData();
//STRIP001     }
//STRIP001     return nRes;
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 void SvxLinguTabPage::AddDicBoxEntry( 
//STRIP001         const Reference< XDictionary > &rxDic, 
//STRIP001         USHORT nIdx )
//STRIP001 {
//STRIP001     aLinguDicsCLB.SetUpdateMode(FALSE);
//STRIP001 
//STRIP001     String aTxt( ::GetDicInfoStr( rxDic->getName(),
//STRIP001                         SvxLocaleToLanguage( rxDic->getLocale() ),
//STRIP001                         DictionaryType_NEGATIVE == rxDic->getDictionaryType() ) );
//STRIP001     aLinguDicsCLB.InsertEntry( aTxt );  // append at end
//STRIP001     SvLBoxEntry* pEntry = aLinguDicsCLB.GetEntry( aLinguDicsCLB.GetEntryCount() - 1 );
//STRIP001     DBG_ASSERT( pEntry, "failed to add entry" );
//STRIP001     if (pEntry)
//STRIP001     {
//STRIP001         DicUserData aData( GetDicUserData( rxDic, nIdx ) );
//STRIP001         pEntry->SetUserData( (void *) aData.GetUserData() );
//STRIP001         lcl_SetCheckButton( pEntry, aData.IsChecked() );
//STRIP001     }
//STRIP001     
//STRIP001     aLinguDicsCLB.SetUpdateMode(TRUE);
//STRIP001 }
//STRIP001 
//STRIP001 // ----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxLinguTabPage::UpdateDicBox_Impl()
//STRIP001 {
//STRIP001     aLinguDicsCLB.SetUpdateMode(FALSE);
//STRIP001     aLinguDicsCLB.Clear();
//STRIP001 
//STRIP001 	INT32 nDics	 = aDics.getLength();
//STRIP001 	const Reference< XDictionary > *pDic = aDics.getConstArray();
//STRIP001 	for (INT32 i = 0;  i < nDics;  ++i)
//STRIP001 	{
//STRIP001 		const Reference< XDictionary > &rDic = pDic[i];
//STRIP001 		if (rDic.is())
//STRIP001             AddDicBoxEntry( rDic, (USHORT)i );
//STRIP001 	}
//STRIP001 
//STRIP001     aLinguDicsCLB.SetUpdateMode(TRUE);
//STRIP001 }
//STRIP001 
//STRIP001 // ----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxLinguTabPage::UpdateModulesBox_Impl()
//STRIP001 {
//STRIP001     if (pLinguData)
//STRIP001     {
//STRIP001         const ServiceInfoArr &rAllDispSrvcArr = pLinguData->GetDisplayServiceArray();
//STRIP001         const ULONG nDispSrvcCount = pLinguData->GetDisplayServiceCount();
//STRIP001 
//STRIP001         for (USHORT n = 0;  n < aLinguModulesCLB.GetEntryCount();  ++n)
//STRIP001         {
//STRIP001             SvxModulesData_Impl* pData = (SvxModulesData_Impl*)
//STRIP001                                             aLinguModulesCLB.GetEntry(n)->GetUserData();
//STRIP001             delete pData;
//STRIP001         }
//STRIP001         aLinguModulesCLB.Clear();
//STRIP001 
//STRIP001         ServiceInfo_Impl* pInfo;
//STRIP001         for (USHORT i = 0;  i < nDispSrvcCount;  ++i)
//STRIP001         {
//STRIP001             pInfo = rAllDispSrvcArr.Get(i);
//STRIP001             aLinguModulesCLB.InsertEntry(pInfo->sDisplayName);
//STRIP001             SvLBoxEntry* pEntry = aLinguModulesCLB.GetEntry(i);
//STRIP001             pEntry->SetUserData( new SvxModulesData_Impl(
//STRIP001                                         pInfo->sSpellImplName,
//STRIP001                                         pInfo->sHyphImplName,
//STRIP001                                         pInfo->sThesImplName,
//STRIP001                                         pInfo->bConfigured ) );
//STRIP001             aLinguModulesCLB.CheckEntryPos( i, pInfo->bConfigured );
//STRIP001         }
//STRIP001         aLinguModulesEditPB.Enable( nDispSrvcCount > 0 );
//STRIP001     }
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxLinguTabPage::Reset( const SfxItemSet& rSet )
//STRIP001 {
//STRIP001 	// if not HideGroups was called with GROUP_MODULES...
//STRIP001 	if (aLinguModulesCLB.IsVisible())
//STRIP001 	{
//STRIP001 		if (!pLinguData)
//STRIP001 			pLinguData = new SvxLinguData_Impl;
//STRIP001         UpdateModulesBox_Impl();
//STRIP001 	}
//STRIP001 
//STRIP001 
//STRIP001 	//
//STRIP001 	//	get data from configuration
//STRIP001 	//
//STRIP001 
//STRIP001 	SvtLinguConfig aLngCfg;
//STRIP001 
//STRIP001 	aLinguOptionsCLB.SetUpdateMode(FALSE);
//STRIP001 	aLinguOptionsCLB.Clear();
//STRIP001 
//STRIP001 	SvLBoxTreeList *pModel = aLinguOptionsCLB.GetModel();
//STRIP001 	SvLBoxEntry* pEntry = NULL;
//STRIP001 
//STRIP001 	INT16 nVal = 0;
//STRIP001 	BOOL  bVal  = FALSE;
//STRIP001 	ULONG nUserData = 0;
//STRIP001 
//STRIP001 	pEntry = CreateEntry( sCapitalWords,	CBCOL_FIRST );
//STRIP001 	aLngCfg.GetProperty( C2U(UPN_IS_SPELL_UPPER_CASE) ) >>= bVal;
//STRIP001 	nUserData = OptionsUserData( EID_CAPITAL_WORDS, FALSE, 0, TRUE, bVal).GetUserData();
//STRIP001 	pEntry->SetUserData( (void *)nUserData );
//STRIP001 	pModel->Insert( pEntry );
//STRIP001 	lcl_SetCheckButton( pEntry, bVal );
//STRIP001 
//STRIP001 	pEntry = CreateEntry( sWordsWithDigits,	CBCOL_FIRST );
//STRIP001 	aLngCfg.GetProperty( C2U(UPN_IS_SPELL_WITH_DIGITS) ) >>= bVal;
//STRIP001 	nUserData = OptionsUserData( EID_WORDS_WITH_DIGITS, FALSE, 0, TRUE, bVal).GetUserData();
//STRIP001 	pEntry->SetUserData( (void *)nUserData );
//STRIP001 	pModel->Insert( pEntry );
//STRIP001 	lcl_SetCheckButton( pEntry, bVal );
//STRIP001 
//STRIP001 	pEntry = CreateEntry( sCapitalization,	CBCOL_FIRST );
//STRIP001 	aLngCfg.GetProperty( C2U(UPN_IS_SPELL_CAPITALIZATION) ) >>= bVal;
//STRIP001 	nUserData = OptionsUserData( EID_CAPITALIZATION, FALSE, 0, TRUE, bVal).GetUserData();
//STRIP001 	pEntry->SetUserData( (void *)nUserData );
//STRIP001 	pModel->Insert( pEntry );
//STRIP001 	lcl_SetCheckButton( pEntry, bVal );
//STRIP001 
//STRIP001 	pEntry = CreateEntry( sSpellSpecial,	CBCOL_FIRST );
//STRIP001 	aLngCfg.GetProperty( C2U(UPN_IS_SPELL_SPECIAL) ) >>= bVal;
//STRIP001 	nUserData = OptionsUserData( EID_SPELL_SPECIAL, FALSE, 0, TRUE, bVal).GetUserData();
//STRIP001 	pEntry->SetUserData( (void *)nUserData );
//STRIP001 	pModel->Insert( pEntry );
//STRIP001 	lcl_SetCheckButton( pEntry, bVal );
//STRIP001 
//STRIP001 	pEntry = CreateEntry( sAllLanguages,	CBCOL_FIRST );
//STRIP001 	aLngCfg.GetProperty( C2U(UPN_IS_SPELL_IN_ALL_LANGUAGES) ) >>= bVal;
//STRIP001 	nUserData = OptionsUserData( EID_ALL_LANGUAGES, FALSE, 0, TRUE, bVal).GetUserData();
//STRIP001 	pEntry->SetUserData( (void *)nUserData );
//STRIP001 	pModel->Insert( pEntry );
//STRIP001 	lcl_SetCheckButton( pEntry, bVal );
//STRIP001 
//STRIP001 	pEntry = CreateEntry( sSpellAuto,		CBCOL_FIRST );
//STRIP001 	aLngCfg.GetProperty( C2U(UPN_IS_SPELL_AUTO) ) >>= bVal;
//STRIP001 	const SfxPoolItem* pItem = GetItem( rSet, SID_AUTOSPELL_CHECK );
//STRIP001 	if (pItem)
//STRIP001 		bVal = ((SfxBoolItem *) pItem)->GetValue();
//STRIP001 	nUserData = OptionsUserData( EID_SPELL_AUTO, FALSE, 0, TRUE, bVal).GetUserData();
//STRIP001 	pEntry->SetUserData( (void *)nUserData );
//STRIP001 	pModel->Insert( pEntry );
//STRIP001 	lcl_SetCheckButton( pEntry, bVal );
//STRIP001 
//STRIP001 	pEntry = CreateEntry( sHideMarkings,	CBCOL_FIRST );
//STRIP001 	aLngCfg.GetProperty( C2U(UPN_IS_SPELL_HIDE) ) >>= bVal;
//STRIP001 	pItem = GetItem( rSet, SID_AUTOSPELL_MARKOFF );
//STRIP001 	if (pItem)
//STRIP001 		bVal = ((SfxBoolItem *) pItem)->GetValue();
//STRIP001 	nUserData = OptionsUserData( EID_HIDE_MARKINGS, FALSE, 0, TRUE, bVal).GetUserData();
//STRIP001 	pEntry->SetUserData( (void *)nUserData );
//STRIP001 	pModel->Insert( pEntry );
//STRIP001 	lcl_SetCheckButton( pEntry, bVal );
//STRIP001 
//STRIP001 	pEntry = CreateEntry( sOldGerman,		CBCOL_FIRST );
//STRIP001 	aLngCfg.GetProperty( C2U(UPN_IS_GERMAN_PRE_REFORM) ) >>= bVal;
//STRIP001 	nUserData = OptionsUserData( EID_OLD_GERMAN, FALSE, 0, TRUE, bVal).GetUserData();
//STRIP001 	pEntry->SetUserData( (void *)nUserData );
//STRIP001 	pModel->Insert( pEntry );
//STRIP001 	lcl_SetCheckButton( pEntry, bVal );
//STRIP001 
//STRIP001 	pEntry = CreateEntry( sNumMinWordlen,	CBCOL_SECOND );
//STRIP001 	aLngCfg.GetProperty( C2U(UPN_HYPH_MIN_WORD_LENGTH) ) >>= nVal;
//STRIP001 	nUserData = OptionsUserData( EID_NUM_MIN_WORDLEN, TRUE, (USHORT)nVal, FALSE, FALSE).GetUserData();
//STRIP001 	pEntry->SetUserData( (void *)nUserData );
//STRIP001 	pModel->Insert( pEntry );
//STRIP001 
//STRIP001 	const SfxHyphenRegionItem *pHyp = NULL;
//STRIP001 	USHORT nWhich = GetWhich( SID_ATTR_HYPHENREGION );
//STRIP001     if ( rSet.GetItemState( nWhich, FALSE ) == SFX_ITEM_SET )
//STRIP001 		pHyp = &( (const SfxHyphenRegionItem &) rSet.Get( nWhich ) );
//STRIP001 
//STRIP001 	pEntry = CreateEntry( sNumPreBreak,		CBCOL_SECOND );
//STRIP001 	aLngCfg.GetProperty( C2U(UPN_HYPH_MIN_LEADING) ) >>= nVal;
//STRIP001 	if (pHyp)
//STRIP001 		nVal = (INT16) pHyp->GetMinLead();
//STRIP001 	nUserData = OptionsUserData( EID_NUM_PRE_BREAK, TRUE, (USHORT)nVal, FALSE, FALSE).GetUserData();
//STRIP001 	pEntry->SetUserData( (void *)nUserData );
//STRIP001 	pModel->Insert( pEntry );
//STRIP001 
//STRIP001 	pEntry = CreateEntry( sNumPostBreak,	CBCOL_SECOND );
//STRIP001 	aLngCfg.GetProperty( C2U(UPN_HYPH_MIN_TRAILING) ) >>= nVal;
//STRIP001 	if (pHyp)
//STRIP001 		nVal = (INT16) pHyp->GetMinTrail();
//STRIP001 	nUserData = OptionsUserData( EID_NUM_POST_BREAK, TRUE, (USHORT)nVal, FALSE, FALSE).GetUserData();
//STRIP001 	pEntry->SetUserData( (void *)nUserData );
//STRIP001 	pModel->Insert( pEntry );
//STRIP001 
//STRIP001 	pEntry = CreateEntry( sHyphAuto,		CBCOL_FIRST );
//STRIP001 	aLngCfg.GetProperty( C2U(UPN_IS_HYPH_AUTO) ) >>= bVal;
//STRIP001 	nUserData = OptionsUserData( EID_HYPH_AUTO, FALSE, 0, TRUE, bVal).GetUserData();
//STRIP001 	pEntry->SetUserData( (void *)nUserData );
//STRIP001 	pModel->Insert( pEntry );
//STRIP001 	lcl_SetCheckButton( pEntry, bVal );
//STRIP001 
//STRIP001 	pEntry = CreateEntry( sHyphSpecial,		CBCOL_FIRST );
//STRIP001 	aLngCfg.GetProperty( C2U(UPN_IS_HYPH_SPECIAL) ) >>= bVal;
//STRIP001 	nUserData = OptionsUserData( EID_HYPH_SPECIAL, FALSE, 0, TRUE, bVal).GetUserData();
//STRIP001 	pEntry->SetUserData( (void *)nUserData );
//STRIP001 	pModel->Insert( pEntry );
//STRIP001 	lcl_SetCheckButton( pEntry, bVal );
//STRIP001 
//STRIP001 	aLinguOptionsCLB.SetUpdateMode(TRUE);
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SvxLinguTabPage, BoxDoubleClickHdl_Impl, SvTreeListBox *, pBox )
//STRIP001 {
//STRIP001     if (pBox == &aLinguModulesCLB)
//STRIP001     {
//STRIP001         //! in order to avoid a bug causing a GPF when double clicking
//STRIP001         //! on a module entry and exiting the "Edit Modules" dialog
//STRIP001         //! after that.
//STRIP001         Application::PostUserEvent( LINK(
//STRIP001                     this, SvxLinguTabPage, PostDblClickHdl_Impl ) );
//STRIP001     }
//STRIP001     else if (pBox == &aLinguOptionsCLB)
//STRIP001     {
//STRIP001         ClickHdl_Impl(&aLinguOptionsEditPB);
//STRIP001     }
//STRIP001     return 0;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SvxLinguTabPage, PostDblClickHdl_Impl, SvTreeListBox *, pBox )
//STRIP001 {
//STRIP001     ClickHdl_Impl(&aLinguModulesEditPB);
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SvxLinguTabPage, BoxCheckButtonHdl_Impl, SvTreeListBox *, pBox )
//STRIP001 {
//STRIP001     if (pBox == &aLinguModulesCLB)
//STRIP001     {
//STRIP001         DBG_ASSERT( pLinguData, "NULL pointer, LinguData missing" );
//STRIP001         USHORT nPos = aLinguModulesCLB.GetSelectEntryPos();
//STRIP001         if (nPos != LISTBOX_ENTRY_NOTFOUND  &&  pLinguData)
//STRIP001         {
//STRIP001             pLinguData->Reconfigure( aLinguModulesCLB.GetText( nPos ),
//STRIP001                                      aLinguModulesCLB.IsChecked( nPos ) );
//STRIP001         }
//STRIP001     }
//STRIP001     else if (pBox == &aLinguDicsCLB)
//STRIP001     {
//STRIP001         USHORT nPos = aLinguDicsCLB.GetSelectEntryPos();
//STRIP001         if (nPos != LISTBOX_ENTRY_NOTFOUND)
//STRIP001         {
//STRIP001             const Reference< XDictionary > &rDic = aDics.getConstArray()[ nPos ];
//STRIP001             if (SvxGetIgnoreAllList() == rDic)
//STRIP001             {
//STRIP001                 SvLBoxEntry* pEntry = aLinguDicsCLB.GetEntry( nPos );
//STRIP001                 if (pEntry)
//STRIP001                     lcl_SetCheckButton( pEntry, TRUE );
//STRIP001             }
//STRIP001         }
//STRIP001     }
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SvxLinguTabPage, ClickHdl_Impl, PushButton *, pBtn )
//STRIP001 {
//STRIP001 	if (&aLinguModulesEditPB == pBtn)
//STRIP001 	{
//STRIP001 		if (!pLinguData)
//STRIP001 			pLinguData = new SvxLinguData_Impl;
//STRIP001 
//STRIP001         SvxLinguData_Impl   aOldLinguData( *pLinguData );
//STRIP001         SvxEditModulesDlg   aDlg( this, *pLinguData );
//STRIP001         if (aDlg.Execute() != RET_OK)
//STRIP001             *pLinguData = aOldLinguData;
//STRIP001 
//STRIP001         // evaluate new status of 'bConfigured' flag
//STRIP001         ULONG nLen = pLinguData->GetDisplayServiceCount();
//STRIP001         for (ULONG i = 0;  i < nLen;  ++i)
//STRIP001             pLinguData->GetDisplayServiceArray().Get(i)->bConfigured = FALSE;
//STRIP001         const Locale* pAllLocales = pLinguData->GetAllSupportedLocales().getConstArray();
//STRIP001         INT32 nLocales = pLinguData->GetAllSupportedLocales().getLength();
//STRIP001         for (INT32 k = 0;  k < nLocales;  ++k)
//STRIP001 		{
//STRIP001             INT16 nLang = SvxLocaleToLanguage( pAllLocales[k] );
//STRIP001             Sequence< OUString > *pNames;
//STRIP001             pNames = pLinguData->GetSpellTable().Get( nLang );
//STRIP001             if (pNames)
//STRIP001                 pLinguData->SetChecked( *pNames );
//STRIP001             pNames = pLinguData->GetHyphTable().Get( nLang );
//STRIP001             if (pNames)
//STRIP001                 pLinguData->SetChecked( *pNames );
//STRIP001             pNames = pLinguData->GetThesTable().Get( nLang );
//STRIP001             if (pNames)
//STRIP001                 pLinguData->SetChecked( *pNames );
//STRIP001 		}
//STRIP001 
//STRIP001         // show new status of modules
//STRIP001         UpdateModulesBox_Impl();
//STRIP001 	}
//STRIP001     else if (&aLinguDicsNewPB == pBtn)
//STRIP001 	{
//STRIP001         Reference< XSpellChecker1 > xSpellChecker1;
//STRIP001 		SvxNewDictionaryDialog aDlg( this,  xSpellChecker1);
//STRIP001         Reference< XDictionary >  xNewDic;
//STRIP001 		if ( aDlg.Execute() == RET_OK )
//STRIP001             xNewDic = Reference< XDictionary >( aDlg.GetNewDictionary(), UNO_QUERY );
//STRIP001 		if ( xNewDic.is() )
//STRIP001         {
//STRIP001             // add new dics to the end
//STRIP001             INT32 nLen = aDics.getLength();
//STRIP001             aDics.realloc( nLen + 1 );
//STRIP001 
//STRIP001             aDics.getArray()[ nLen ] = xNewDic;
//STRIP001 
//STRIP001             AddDicBoxEntry( xNewDic, (USHORT) nLen );
//STRIP001         }
//STRIP001 	}
//STRIP001     else if (&aLinguDicsEditPB == pBtn)
//STRIP001 	{
//STRIP001         SvLBoxEntry *pEntry = aLinguDicsCLB.GetCurEntry();
//STRIP001 		if (pEntry)
//STRIP001 		{
//STRIP001 			DicUserData aData( (ULONG) pEntry->GetUserData() );
//STRIP001 			USHORT nDicPos = aData.GetEntryId();
//STRIP001 			INT32 nDics = aDics.getLength();
//STRIP001 			if (nDicPos < nDics)
//STRIP001 			{
//STRIP001 				Reference< XDictionary > xDic;
//STRIP001 				xDic = aDics.getConstArray()[ nDicPos ];
//STRIP001 				if (xDic.is())
//STRIP001 				{
//STRIP001                     Reference< XSpellChecker1 > xSpellChecker1;
//STRIP001 					SvxEditDictionaryDialog aDlg( this,
//STRIP001 							xDic->getName(), xSpellChecker1 );
//STRIP001 					aDlg.Execute();
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001     else if (&aLinguDicsDelPB == pBtn)
//STRIP001 	{
//STRIP001 		if ( RET_NO ==
//STRIP001 		 	QueryBox( this, ResId( RID_SFXQB_DELDICT, DIALOG_MGR() ) ).Execute() )
//STRIP001 			return 0;
//STRIP001 
//STRIP001         SvLBoxEntry *pEntry = aLinguDicsCLB.GetCurEntry();
//STRIP001 		if (pEntry)
//STRIP001 		{
//STRIP001 			DicUserData aData( (ULONG) pEntry->GetUserData() );
//STRIP001 			USHORT nDicPos = aData.GetEntryId();
//STRIP001 			INT32 nDics = aDics.getLength();
//STRIP001 			if (nDicPos < nDics)
//STRIP001 			{
//STRIP001 				Reference< XDictionary > xDic;
//STRIP001 				xDic = aDics.getConstArray()[ nDicPos ];
//STRIP001 				if (xDic.is())
//STRIP001 				{
//STRIP001 					if (SvxGetIgnoreAllList() == xDic)
//STRIP001 						xDic->clear();
//STRIP001 					else
//STRIP001 					{
//STRIP001 						if (xDicList.is())
//STRIP001 							xDicList->removeDictionary( xDic );
//STRIP001 
//STRIP001 						Reference< frame::XStorable > xStor( xDic, UNO_QUERY );
//STRIP001 						if ( xStor->hasLocation() && !xStor->isReadonly() )
//STRIP001 						{
//STRIP001 							String sURL = xStor->getLocation();
//STRIP001 							INetURLObject aObj(sURL);
//STRIP001 							DBG_ASSERT( aObj.GetProtocol() == INET_PROT_FILE,
//STRIP001 									"non-file URLs cannot be deleted" );
//STRIP001 							if ( aObj.GetProtocol() == INET_PROT_FILE )
//STRIP001 							{
//STRIP001 								KillFile_Impl( aObj.GetMainURL( INetURLObject::NO_DECODE ) );
//STRIP001 							}
//STRIP001 						}
//STRIP001 
//STRIP001                         aDics.getArray()[ nDicPos ] = 0;
//STRIP001 
//STRIP001                         // remove entry from checklistbox
//STRIP001                         ULONG nCnt = aLinguDicsCLB.GetEntryCount();
//STRIP001                         for (ULONG i = 0;  i < nCnt;  ++i)
//STRIP001                         {
//STRIP001                             SvLBoxEntry *pEntry = aLinguDicsCLB.GetEntry( i );
//STRIP001                             DBG_ASSERT( pEntry, "missing entry" );
//STRIP001                             if (pEntry)
//STRIP001                             {
//STRIP001                                 DicUserData aData( (ULONG) pEntry->GetUserData() );
//STRIP001                                 if (aData.GetEntryId() == nDicPos )
//STRIP001                                 {
//STRIP001                                     aLinguDicsCLB.RemoveEntry( (USHORT) i );
//STRIP001                                     break;
//STRIP001                                 }
//STRIP001                             }
//STRIP001                         }
//STRIP001                         DBG_ASSERT( nCnt > aLinguDicsCLB.GetEntryCount(), 
//STRIP001                                 "remove failed ?");
//STRIP001 					}
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else if (&aLinguOptionsEditPB == pBtn)
//STRIP001 	{
//STRIP001 		SvLBoxEntry *pEntry = aLinguOptionsCLB.GetCurEntry();
//STRIP001 		DBG_ASSERT( pEntry, "no entry selected" );
//STRIP001 		if (pEntry)
//STRIP001 		{
//STRIP001 			long nVal = -1;
//STRIP001 			OptionsUserData aData( (ULONG)pEntry->GetUserData() );
//STRIP001 			if(aData.HasNumericValue())
//STRIP001 			{
//STRIP001 				int nRID = -1;
//STRIP001 				switch (aData.GetEntryId())
//STRIP001 				{
//STRIP001 					case EID_NUM_PRE_BREAK	: nRID = STR_NUM_PRE_BREAK_DLG; break;
//STRIP001 					case EID_NUM_POST_BREAK	: nRID = STR_NUM_POST_BREAK_DLG; break;
//STRIP001 					case EID_NUM_MIN_WORDLEN: nRID = STR_NUM_MIN_WORDLEN_DLG; break;
//STRIP001 					default:
//STRIP001 						DBG_ERROR( "unexpected case" );
//STRIP001 				}
//STRIP001 
//STRIP001 				OptionsBreakSet aDlg( this, nRID );
//STRIP001                 aDlg.GetNumericFld().SetValue( aData.GetNumericValue() );
//STRIP001 				if (RET_OK == aDlg.Execute() )
//STRIP001 				{
//STRIP001 					nVal = aDlg.GetNumericFld().GetValue();
//STRIP001 					if (-1 != nVal && aData.GetNumericValue() != nVal)
//STRIP001 					{
//STRIP001 						aData.SetNumericValue( (BYTE)nVal ); //! sets IsModified !
//STRIP001 						pEntry->SetUserData( (void *) aData.GetUserData() );
//STRIP001 						aLinguOptionsCLB.Invalidate();
//STRIP001 					}
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		DBG_ERROR( "pBtn unexpected value" );
//STRIP001 	}
//STRIP001 
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SvxLinguTabPage, SelectHdl_Impl, SvxCheckListBox *, pBox )
//STRIP001 {
//STRIP001 	if (&aLinguModulesCLB == pBox)
//STRIP001 	{
//STRIP001 	}
//STRIP001     else if (&aLinguDicsCLB == pBox)
//STRIP001 	{
//STRIP001 		SvLBoxEntry *pEntry = pBox->GetCurEntry();
//STRIP001 		if (pEntry)
//STRIP001 		{
//STRIP001 			DicUserData aData( (ULONG) pEntry->GetUserData() );
//STRIP001             aLinguDicsEditPB.Enable( aData.IsEditable() );
//STRIP001             aLinguDicsDelPB .Enable( aData.IsDeletable() );
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else if (&aLinguOptionsCLB == pBox)
//STRIP001 	{
//STRIP001 		SvLBoxEntry *pEntry = pBox->GetCurEntry();
//STRIP001 		if (pEntry)
//STRIP001 		{
//STRIP001 			OptionsUserData aData( (ULONG) pEntry->GetUserData() );
//STRIP001 			aLinguOptionsEditPB.Enable( aData.HasNumericValue() );
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		DBG_ERROR( "pBox unexpected value" );
//STRIP001 	}
//STRIP001 
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 SvLBoxEntry* SvxLinguTabPage::CreateEntry( String& rTxt, USHORT nCol )
//STRIP001 {
//STRIP001 	SvLBoxEntry* pEntry = new SvLBoxEntry;
//STRIP001 
//STRIP001 	if( !pCheckButtonData )
//STRIP001 		pCheckButtonData = new SvLBoxButtonData( &aLinguOptionsCLB );
//STRIP001 
//STRIP001 	String sEmpty;
//STRIP001 	if (CBCOL_FIRST == nCol)
//STRIP001 		pEntry->AddItem( new SvLBoxButton( pEntry, 0, pCheckButtonData ) );
//STRIP001 	if (CBCOL_SECOND == nCol)
//STRIP001 		pEntry->AddItem( new SvLBoxString( pEntry, 0, sEmpty) );	// Leerspalte
//STRIP001 	pEntry->AddItem( new SvLBoxContextBmp( pEntry, 0, Image(), Image(), 0));	// Sonst Puff!
//STRIP001 	pEntry->AddItem( new BrwString_Impl( pEntry, 0, rTxt ) );
//STRIP001 
//STRIP001 	return pEntry;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxLinguTabPage::HideGroups( sal_uInt16 nGrp )
//STRIP001 {
//STRIP001 	if ( 0 != ( GROUP_MODULES & nGrp ) )
//STRIP001 	{
//STRIP001 		aLinguModulesFT.Hide();
//STRIP001 		aLinguModulesCLB.Hide();
//STRIP001 		aLinguModulesEditPB.Hide();
//STRIP001 
//STRIP001         // reposition / resize remaining controls
//STRIP001         long nDeltaY = aLinguDicsFT.GetPosPixel().Y() -
//STRIP001                        aLinguModulesFT.GetPosPixel().Y();
//STRIP001         DBG_ASSERT( nDeltaY >= 0, "move/resize value is negative" );
//STRIP001         Point   aPos;
//STRIP001         //
//STRIP001         aPos = aLinguDicsFT.GetPosPixel();
//STRIP001         aPos.Y() -= nDeltaY;
//STRIP001         aLinguDicsFT.SetPosPixel( aPos );
//STRIP001         aPos = aLinguDicsCLB.GetPosPixel();
//STRIP001         aPos.Y() -= nDeltaY;
//STRIP001         aLinguDicsCLB.SetPosPixel( aPos );
//STRIP001         aPos = aLinguDicsNewPB.GetPosPixel();
//STRIP001         aPos.Y() -= nDeltaY;
//STRIP001         aLinguDicsNewPB.SetPosPixel( aPos );
//STRIP001         aPos = aLinguDicsEditPB.GetPosPixel();
//STRIP001         aPos.Y() -= nDeltaY;
//STRIP001         aLinguDicsEditPB.SetPosPixel( aPos );
//STRIP001         aPos = aLinguDicsDelPB.GetPosPixel();
//STRIP001         aPos.Y() -= nDeltaY;
//STRIP001         aLinguDicsDelPB.SetPosPixel( aPos );
//STRIP001         //
//STRIP001         aPos = aLinguOptionsFT.GetPosPixel();
//STRIP001         aPos.Y() -= nDeltaY;
//STRIP001         aLinguOptionsFT.SetPosPixel( aPos );
//STRIP001         aPos = aLinguOptionsCLB.GetPosPixel();
//STRIP001         aPos.Y() -= nDeltaY;
//STRIP001         aLinguOptionsCLB.SetPosPixel( aPos );
//STRIP001         aPos = aLinguOptionsEditPB.GetPosPixel();
//STRIP001         aPos.Y() -= nDeltaY;
//STRIP001         aLinguOptionsEditPB.SetPosPixel( aPos );
//STRIP001         //
//STRIP001         Size aSize( aLinguOptionsCLB.GetSizePixel() );
//STRIP001         aSize.Height() += nDeltaY;
//STRIP001         aLinguOptionsCLB.SetSizePixel( aSize );
//STRIP001 	}
//STRIP001 }
//STRIP001 /*--------------------------------------------------
//STRIP001 --------------------------------------------------*/
//STRIP001 
//STRIP001 SvxEditModulesDlg::SvxEditModulesDlg(Window* pParent, SvxLinguData_Impl& rData) :
//STRIP001 		ModalDialog(pParent, ResId(RID_SVXDLG_EDIT_MODULES, DIALOG_MGR() )),
//STRIP001 		aClosePB	( this, ResId( PB_OK ) ),
//STRIP001 		aHelpPB		( this, ResId( PB_HELP ) ),
//STRIP001         aModulesFL  ( this, ResId( FL_EDIT_MODULES_OPTIONS ) ),
//STRIP001 		aLanguageFT	( this, ResId( FT_EDIT_MODULES_LANGUAGE ) ),
//STRIP001 		aLanguageLB	( this, ResId( LB_EDIT_MODULES_LANGUAGE ), FALSE ),
//STRIP001 		aModulesCLB	( this, ResId( CLB_EDIT_MODULES_MODULES ) ),
//STRIP001 		aPrioUpPB	( this, ResId( PB_EDIT_MODULES_PRIO_UP ) ),
//STRIP001 		aPrioDownPB	( this, ResId( PB_EDIT_MODULES_PRIO_DOWN ) ),
//STRIP001 		aBackPB		( this, ResId( PB_EDIT_MODULES_PRIO_BACK ) ),
//STRIP001 		sSpell( ResId( ST_SPELL)),
//STRIP001 		sHyph( ResId( ST_HYPH)),
//STRIP001 		sThes( ResId( ST_THES)),
//STRIP001 		rLinguData(rData)
//STRIP001 {
//STRIP001 	pCheckButtonData = NULL;
//STRIP001 	FreeResource();
//STRIP001 
//STRIP001     pDefaultLinguData = new SvxLinguData_Impl( rLinguData );
//STRIP001 
//STRIP001 	aModulesCLB.SetWindowBits( WB_CLIPCHILDREN|WB_HSCROLL|WB_FORCE_MAKEVISIBLE );
//STRIP001 	aModulesCLB.SetHighlightRange();
//STRIP001 	aModulesCLB.SetHelpId(HID_CLB_EDIT_MODULES_MODULES );
//STRIP001 	aModulesCLB.SetSelectHdl( LINK( this, SvxEditModulesDlg, SelectHdl_Impl ));
//STRIP001     aModulesCLB.SetCheckButtonHdl( LINK( this, SvxEditModulesDlg, BoxCheckButtonHdl_Impl) );
//STRIP001 
//STRIP001     aClosePB   .SetClickHdl( LINK( this, SvxEditModulesDlg, ClickHdl_Impl ));
//STRIP001     aPrioUpPB  .SetClickHdl( LINK( this, SvxEditModulesDlg, UpDownHdl_Impl ));
//STRIP001 	aPrioDownPB.SetClickHdl( LINK( this, SvxEditModulesDlg, UpDownHdl_Impl ));
//STRIP001     aBackPB    .SetClickHdl( LINK( this, SvxEditModulesDlg, BackHdl_Impl ));
//STRIP001     // in case of not installed language modules
//STRIP001     aPrioUpPB  .Enable( FALSE );
//STRIP001     aPrioDownPB.Enable( FALSE );
//STRIP001 
//STRIP001     //
//STRIP001     //fill language box
//STRIP001     //
//STRIP001     Sequence< INT16 > aAvailLang;
//STRIP001     Reference< XAvailableLocales > xAvail( rLinguData.GetManager(), UNO_QUERY );
//STRIP001     if (xAvail.is())
//STRIP001     {
//STRIP001         aAvailLang = lcl_LocaleSeqToLangSeq(
//STRIP001                         xAvail->getAvailableLocales( C2U(cSpell) ) );
//STRIP001     }
//STRIP001     const Sequence< Locale >& rLoc = rLinguData.GetAllSupportedLocales();
//STRIP001 	const Locale* pLocales = rLoc.getConstArray();
//STRIP001 	aLanguageLB.Clear();
//STRIP001 	for(long i = 0; i < rLoc.getLength(); i++)
//STRIP001 	{
//STRIP001         INT16 nLang = SvxLocaleToLanguage( pLocales[i] );
//STRIP001         aLanguageLB.InsertLanguage( nLang, lcl_SeqHasLang( aAvailLang, nLang ) );
//STRIP001 	}
//STRIP001 	LanguageType eSysLang = GetSystemLanguage();
//STRIP001 	aLanguageLB.SelectLanguage( eSysLang );
//STRIP001 	if(!aLanguageLB.IsLanguageSelected( eSysLang ) )
//STRIP001 		aLanguageLB.SelectEntryPos(0);
//STRIP001 
//STRIP001 	aLanguageLB.SetSelectHdl( LINK( this, SvxEditModulesDlg, LangSelectHdl_Impl ));
//STRIP001 	LangSelectHdl_Impl(&aLanguageLB);
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 SvxEditModulesDlg::~SvxEditModulesDlg()
//STRIP001 {
//STRIP001     delete pDefaultLinguData;
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 SvLBoxEntry* SvxEditModulesDlg::CreateEntry( String& rTxt, USHORT nCol )
//STRIP001 {
//STRIP001 	SvLBoxEntry* pEntry = new SvLBoxEntry;
//STRIP001 	if( !pCheckButtonData )
//STRIP001 	{
//STRIP001 		pCheckButtonData = new SvLBoxButtonData( &aModulesCLB );
//STRIP001         pCheckButtonData->SetLink( aModulesCLB.GetCheckButtonHdl() );
//STRIP001 	}
//STRIP001 
//STRIP001 	String sEmpty;
//STRIP001 	if (CBCOL_FIRST == nCol)
//STRIP001 		pEntry->AddItem( new SvLBoxButton( pEntry, 0, pCheckButtonData ) );
//STRIP001 	if (CBCOL_SECOND == nCol)
//STRIP001 		pEntry->AddItem( new SvLBoxString( pEntry, 0, sEmpty) );	// Leerspalte
//STRIP001 	pEntry->AddItem( new SvLBoxContextBmp( pEntry, 0, Image(), Image(), 0));	// Sonst Puff!
//STRIP001 	pEntry->AddItem( new BrwStringDic_Impl( pEntry, 0, rTxt ) );
//STRIP001 
//STRIP001 	return pEntry;
//STRIP001 }
//STRIP001 
//STRIP001 /* ---------------------------------------------------------------------------
//STRIP001 
//STRIP001  ---------------------------------------------------------------------------*/
//STRIP001 
//STRIP001 static void lcl_UpdateLinguData()
//STRIP001 {
//STRIP001 }
//STRIP001 
//STRIP001 /* ---------------------------------------------------------------------------
//STRIP001 
//STRIP001  ---------------------------------------------------------------------------*/
//STRIP001 IMPL_LINK( SvxEditModulesDlg, SelectHdl_Impl, SvxCheckListBox *, pBox )
//STRIP001 {
//STRIP001 	if (&aModulesCLB == pBox)
//STRIP001 	{
//STRIP001 		sal_Bool bDisableUp = sal_True;
//STRIP001 		sal_Bool bDisableDown = sal_True;
//STRIP001 		SvLBoxEntry *pEntry = pBox->GetCurEntry();
//STRIP001 		if (pEntry)
//STRIP001 		{
//STRIP001 			ModuleUserData_Impl* pData = (ModuleUserData_Impl*)pEntry->GetUserData();
//STRIP001 			if(!pData->IsParent() && pData->GetType() != TYPE_HYPH)
//STRIP001 			{
//STRIP001 				USHORT	nCurPos = pBox->GetSelectEntryPos();
//STRIP001 				if(nCurPos < pBox->GetEntryCount() - 1)
//STRIP001 				{
//STRIP001 					bDisableDown = ((ModuleUserData_Impl*)pBox->
//STRIP001 							GetEntry(nCurPos + 1)->GetUserData())->IsParent();
//STRIP001 				}
//STRIP001 				if(nCurPos > 1)
//STRIP001 				{
//STRIP001             					bDisableUp = ((ModuleUserData_Impl*)pBox->
//STRIP001 							GetEntry(nCurPos - 1)->GetUserData())->IsParent();
//STRIP001 				}
//STRIP001 			}
//STRIP001 			aPrioUpPB.Enable(!bDisableUp);
//STRIP001 			aPrioDownPB.Enable(!bDisableDown);
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		DBG_ERROR( "pBox unexpected value" );
//STRIP001 	}
//STRIP001 
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 /* -----------------------------28.05.01 11:00--------------------------------
//STRIP001 
//STRIP001  ---------------------------------------------------------------------------*/
//STRIP001 IMPL_LINK( SvxEditModulesDlg, BoxCheckButtonHdl_Impl, SvTreeListBox *, pBox )
//STRIP001 {
//STRIP001 //    if (pBox == (SvTreeListBox *) &aModulesCLB)
//STRIP001 //    {
//STRIP001         pBox = &aModulesCLB;
//STRIP001 		SvLBoxEntry *pCurEntry = pBox->GetCurEntry();
//STRIP001 		if (pCurEntry)
//STRIP001 		{
//STRIP001 			ModuleUserData_Impl* pData = (ModuleUserData_Impl *)
//STRIP001 												pCurEntry->GetUserData();
//STRIP001 			if (!pData->IsParent()  &&  pData->GetType() == TYPE_HYPH)
//STRIP001 			{
//STRIP001 				// make hyphenator checkboxes function as radio-buttons
//STRIP001 				// (at most one box may be checked)
//STRIP001 				SvLBoxEntry *pEntry = pBox->First();
//STRIP001 				while (pEntry)
//STRIP001 				{
//STRIP001 					pData = (ModuleUserData_Impl *) pEntry->GetUserData();
//STRIP001 					if (!pData->IsParent()  &&
//STRIP001 						 pData->GetType() == TYPE_HYPH  &&
//STRIP001 						 pEntry != pCurEntry)
//STRIP001 					{
//STRIP001 						lcl_SetCheckButton( pEntry, FALSE );
//STRIP001 						pBox->InvalidateEntry( pEntry );
//STRIP001 					}
//STRIP001 					pEntry = pBox->Next( pEntry );
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 //    }
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 /* -----------------------------27.11.00 14:00--------------------------------
//STRIP001 
//STRIP001  ---------------------------------------------------------------------------*/
//STRIP001 OUString lcl_GetServiceName(BYTE nType)
//STRIP001 {
//STRIP001 	switch(nType)
//STRIP001 	{
//STRIP001 		case  TYPE_SPELL:	return C2U(cSpell);
//STRIP001 		case  TYPE_HYPH:    return C2U(cHyph);
//STRIP001 		case  TYPE_THES:    return C2U(cThes);
//STRIP001 	}
//STRIP001 	return OUString();
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 IMPL_LINK( SvxEditModulesDlg, LangSelectHdl_Impl, ListBox *, pBox )
//STRIP001 {
//STRIP001 	LanguageType  eCurLanguage = aLanguageLB.GetSelectLanguage();
//STRIP001 	static Locale aLastLocale;
//STRIP001 	Locale aCurLocale;
//STRIP001 	SvxLanguageToLocale(aCurLocale, eCurLanguage);
//STRIP001 	SvLBoxTreeList *pModel = aModulesCLB.GetModel();
//STRIP001 	Reference<XLinguServiceManager>&   xMgr = rLinguData.GetManager();
//STRIP001 
//STRIP001     if (pBox)
//STRIP001 	{
//STRIP001         // save old probably changed settings
//STRIP001         // before switching to new language entries
//STRIP001 
//STRIP001         ULONG nLang = SvxLocaleToLanguage( aLastLocale );
//STRIP001 
//STRIP001 		sal_Int32 nStart = 0, nLocalIndex = 0;
//STRIP001 		Sequence<OUString> aChange;
//STRIP001 		sal_Bool bChanged = FALSE;
//STRIP001 		for(USHORT i = 0; i < aModulesCLB.GetEntryCount(); i++)
//STRIP001 		{
//STRIP001 			SvLBoxEntry *pEntry = aModulesCLB.GetEntry(i);
//STRIP001 			ModuleUserData_Impl* pData = (ModuleUserData_Impl*)pEntry->GetUserData();
//STRIP001 			if(pData->IsParent())
//STRIP001 			{
//STRIP001 				if(bChanged)
//STRIP001 				{
//STRIP001                     LangImplNameTable *pTable = 0;
//STRIP001                     BYTE nType = pData->GetType();
//STRIP001                     switch (nType - 1)
//STRIP001                     {
//STRIP001                         case  TYPE_SPELL : pTable = &rLinguData.GetSpellTable(); break;
//STRIP001                         case  TYPE_HYPH  : pTable = &rLinguData.GetHyphTable();  break;
//STRIP001                         case  TYPE_THES  : pTable = &rLinguData.GetThesTable();  break;
//STRIP001                     }
//STRIP001                     if (pTable)
//STRIP001                     {
//STRIP001                         aChange.realloc(nStart);
//STRIP001                         Sequence< OUString > *pImplNames = pTable->Get( nLang );
//STRIP001                         if (pImplNames)
//STRIP001                             *pImplNames = aChange;
//STRIP001                         else
//STRIP001                             pTable->Insert( nLang, new Sequence< OUString >(aChange) );
//STRIP001                     }
//STRIP001 				}
//STRIP001 				nLocalIndex = nStart = 0;
//STRIP001 				aChange.realloc(aModulesCLB.GetEntryCount());
//STRIP001 				bChanged = FALSE;
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				OUString* pChange = aChange.getArray();
//STRIP001 				pChange[nStart] = pData->GetImplName();
//STRIP001 				bChanged |= pData->GetIndex() != nLocalIndex ||
//STRIP001 					pData->IsChecked() != aModulesCLB.IsChecked(i);
//STRIP001 				if(aModulesCLB.IsChecked(i))
//STRIP001 					nStart++;
//STRIP001 				++nLocalIndex;
//STRIP001 			}
//STRIP001 		}
//STRIP001 		if(bChanged)
//STRIP001 		{
//STRIP001 			aChange.realloc(nStart);
//STRIP001             LangImplNameTable &rTable = rLinguData.GetThesTable();
//STRIP001             Sequence< OUString > *pImplNames = rTable.Get( nLang );
//STRIP001             if (pImplNames)
//STRIP001                 *pImplNames = aChange;
//STRIP001             else
//STRIP001                 rTable.Insert( nLang, new Sequence< OUString >(aChange) );
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	for(ULONG i = 0; i < aModulesCLB.GetEntryCount(); i++)
//STRIP001 		delete (ModuleUserData_Impl*)aModulesCLB.GetEntry(i)->GetUserData();
//STRIP001 
//STRIP001     //
//STRIP001     // display entries for new selected language
//STRIP001     //
//STRIP001 	aModulesCLB.Clear();
//STRIP001 	if(LANGUAGE_DONTKNOW != eCurLanguage)
//STRIP001 	{
//STRIP001 		sal_Int32 nEntryPos = 1;
//STRIP001         const ServiceInfoArr &rAllDispSrvcArr = rLinguData.GetDisplayServiceArray();
//STRIP001         const ULONG nDispSrvcCount = rLinguData.GetDisplayServiceCount();
//STRIP001 
//STRIP001         ULONG n;
//STRIP001         ServiceInfo_Impl* pInfo;
//STRIP001 
//STRIP001         //
//STRIP001         // spellchecker entries
//STRIP001         //
//STRIP001 		SvLBoxEntry* pEntry = CreateEntry( sSpell,	CBCOL_SECOND );
//STRIP001         ModuleUserData_Impl* pUserData = new ModuleUserData_Impl(
//STRIP001                                          String(), TRUE, FALSE, TYPE_SPELL, 0 );
//STRIP001 		pEntry->SetUserData( (void *)pUserData );
//STRIP001 		pModel->Insert( pEntry );
//STRIP001 
//STRIP001         const Sequence< OUString > *pSpellSrvc =
//STRIP001                 rLinguData.GetSpellTable().Get( eCurLanguage );
//STRIP001 		sal_Int32 nLocalIndex = 0;	// index relative to parent
//STRIP001         for (n = 0;  n < nDispSrvcCount;  ++n)
//STRIP001 		{
//STRIP001             pInfo = rAllDispSrvcArr.Get(n);
//STRIP001             BOOL bIsSuppLang = pInfo->xSpell.is()  &&
//STRIP001                                pInfo->xSpell->hasLocale( aCurLocale );
//STRIP001 			const OUString &rImplName = pInfo->sSpellImplName;
//STRIP001             if (rImplName.getLength()  &&  bIsSuppLang)
//STRIP001 			{
//STRIP001                 String aTxt( pInfo->sDisplayName );
//STRIP001                 SvLBoxEntry* pEntry = CreateEntry( aTxt, CBCOL_FIRST );
//STRIP001                 BOOL bChecked = pSpellSrvc ?
//STRIP001                         lcl_SeqGetEntryPos( *pSpellSrvc, rImplName ) >= 0 : FALSE;
//STRIP001 				lcl_SetCheckButton( pEntry, bChecked );
//STRIP001 				pUserData = new ModuleUserData_Impl( rImplName, FALSE,
//STRIP001                                         bChecked, TYPE_SPELL, (BYTE)nLocalIndex++ );
//STRIP001 				pEntry->SetUserData( (void *)pUserData );
//STRIP001 				pModel->Insert( pEntry );
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001         //
//STRIP001         // hyphenator entries
//STRIP001         //
//STRIP001 		pEntry = CreateEntry( sHyph,	CBCOL_SECOND );
//STRIP001 		pUserData = new ModuleUserData_Impl( String(), TRUE, FALSE, TYPE_HYPH, 0 );
//STRIP001 		pEntry->SetUserData( (void *)pUserData );
//STRIP001 		pModel->Insert( pEntry );
//STRIP001 
//STRIP001         const Sequence< OUString > *pHyphSrvc = pHyphSrvc =
//STRIP001                 rLinguData.GetHyphTable().Get( eCurLanguage );
//STRIP001 		nLocalIndex = 0;
//STRIP001         for (n = 0;  n < nDispSrvcCount;  ++n)
//STRIP001 		{
//STRIP001             pInfo = rAllDispSrvcArr.Get(n);
//STRIP001             BOOL bIsSuppLang = pInfo->xHyph.is()  &&
//STRIP001                                pInfo->xHyph->hasLocale( aCurLocale );
//STRIP001 			const OUString &rImplName = pInfo->sHyphImplName;
//STRIP001             if (rImplName.getLength()  &&  bIsSuppLang)
//STRIP001 			{
//STRIP001                 String aTxt( pInfo->sDisplayName );
//STRIP001                 SvLBoxEntry* pEntry = CreateEntry( aTxt, CBCOL_FIRST );
//STRIP001                 BOOL bChecked = pHyphSrvc ?
//STRIP001                         lcl_SeqGetEntryPos( *pHyphSrvc, rImplName ) >= 0 : FALSE;
//STRIP001 				lcl_SetCheckButton( pEntry, bChecked );
//STRIP001 				pUserData = new ModuleUserData_Impl( rImplName, FALSE,
//STRIP001                                         bChecked, TYPE_HYPH, (BYTE)nLocalIndex++ );
//STRIP001 				pEntry->SetUserData( (void *)pUserData );
//STRIP001 				pModel->Insert( pEntry );
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001         //
//STRIP001         // thesaurus entries
//STRIP001         //
//STRIP001 		pEntry = CreateEntry( sThes,	CBCOL_SECOND );
//STRIP001 		pUserData = new ModuleUserData_Impl( String(), TRUE, FALSE, TYPE_THES, 0 );
//STRIP001 		pEntry->SetUserData( (void *)pUserData );
//STRIP001 		pModel->Insert( pEntry );
//STRIP001 
//STRIP001         const Sequence< OUString > *pThesSrvc = pHyphSrvc =
//STRIP001                 rLinguData.GetThesTable().Get( eCurLanguage );
//STRIP001 		nLocalIndex = 0;
//STRIP001         for (n = 0;  n < nDispSrvcCount;  ++n)
//STRIP001 		{
//STRIP001             pInfo = rAllDispSrvcArr.Get(n);
//STRIP001             BOOL bIsSuppLang = pInfo->xThes.is()  &&
//STRIP001                                pInfo->xThes->hasLocale( aCurLocale );
//STRIP001 			const OUString &rImplName = pInfo->sThesImplName;
//STRIP001             if (rImplName.getLength()  &&  bIsSuppLang)
//STRIP001 			{
//STRIP001                 String aTxt( pInfo->sDisplayName );
//STRIP001                 SvLBoxEntry* pEntry = CreateEntry( aTxt, CBCOL_FIRST );
//STRIP001                 BOOL bChecked = pThesSrvc ?
//STRIP001                         lcl_SeqGetEntryPos( *pThesSrvc, rImplName ) >= 0 : FALSE;
//STRIP001 				lcl_SetCheckButton( pEntry, bChecked );
//STRIP001 				pUserData = new ModuleUserData_Impl( rImplName, FALSE,
//STRIP001                                         bChecked, TYPE_THES, (BYTE)nLocalIndex++ );
//STRIP001 				pEntry->SetUserData( (void *)pUserData );
//STRIP001 				pModel->Insert( pEntry );
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 	aLastLocale.Language = aCurLocale.Language;
//STRIP001 	aLastLocale.Country = aCurLocale.Country;
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 /* -----------------------------27.11.00 19:50--------------------------------
//STRIP001 
//STRIP001  ---------------------------------------------------------------------------*/
//STRIP001 IMPL_LINK( SvxEditModulesDlg, UpDownHdl_Impl, PushButton *, pBtn )
//STRIP001 {
//STRIP001 	sal_Bool bUp = &aPrioUpPB == pBtn;
//STRIP001 	USHORT	nCurPos = aModulesCLB.GetSelectEntryPos();
//STRIP001     SvLBoxEntry* pEntry;
//STRIP001     if (nCurPos != LISTBOX_ENTRY_NOTFOUND  &&
//STRIP001         0 != (pEntry = aModulesCLB.GetEntry(nCurPos)))
//STRIP001     {
//STRIP001         aModulesCLB.SetUpdateMode(FALSE);
//STRIP001         SvLBoxTreeList *pModel = aModulesCLB.GetModel();
//STRIP001 
//STRIP001         ModuleUserData_Impl* pData = (ModuleUserData_Impl*)pEntry->GetUserData();
//STRIP001         String aStr(aModulesCLB.GetEntryText(pEntry));
//STRIP001         SvLBoxEntry* pToInsert = CreateEntry( aStr, CBCOL_FIRST );
//STRIP001         pToInsert->SetUserData( (void *)pData);
//STRIP001         BOOL bIsChecked = aModulesCLB.IsChecked(nCurPos);
//STRIP001 
//STRIP001         pModel->Remove(pEntry);
//STRIP001 
//STRIP001         USHORT nDestPos = bUp ? nCurPos - 1 : nCurPos + 1;
//STRIP001         pModel->Insert(pToInsert, nDestPos);
//STRIP001         aModulesCLB.CheckEntryPos(nDestPos, bIsChecked );
//STRIP001         aModulesCLB.SelectEntryPos(nDestPos );
//STRIP001         SelectHdl_Impl(&aModulesCLB);
//STRIP001         aModulesCLB.SetUpdateMode(TRUE);
//STRIP001     }
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 /* ---------------------------------------------------------------------------
//STRIP001 
//STRIP001  ---------------------------------------------------------------------------*/
//STRIP001 IMPL_LINK( SvxEditModulesDlg, ClickHdl_Impl, PushButton *, pBtn )
//STRIP001 {
//STRIP001 	if (&aClosePB == pBtn)
//STRIP001 	{
//STRIP001 		// store language config
//STRIP001 		LangSelectHdl_Impl(&aLanguageLB);
//STRIP001 		EndDialog( RET_OK );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		DBG_ERROR( "pBtn unexpected value" );
//STRIP001 	}
//STRIP001 
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 /* -----------------------------27.11.00 20:31--------------------------------
//STRIP001 
//STRIP001  ---------------------------------------------------------------------------*/
//STRIP001 IMPL_LINK( SvxEditModulesDlg, BackHdl_Impl, PushButton *, pBtn )
//STRIP001 {
//STRIP001     rLinguData = *pDefaultLinguData;
//STRIP001 	LangSelectHdl_Impl(0);
//STRIP001 	return 0;
//STRIP001 }

}
