/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: svx_msvbasic.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 06:27:42 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

/* -*- Mode: C; tab-width: 4; indent-tabs-mode: nil -*- */

#include <string.h> 	// memset(), ...
#ifndef UNX
#include <io.h> 		// access()
#endif

#ifndef _RTL_TENCINFO_H
#include <rtl/tencinfo.h>   //rtl_getTextEncodingFromWindowsCodePage
#endif

#ifndef _MSVBASIC_HXX
#include "msvbasic.hxx"
#endif
#ifndef _OSL_ENDIAN_H_
#include <osl/endian.h>
#endif
namespace binfilter {

/*
A few urls which may in the future be of some use
http://www.virusbtn.com/vb2000/Programme/papers/bontchev.pdf
*/

/* class VBA_Impl:
 * The VBA class provides a set of methods to handle Visual Basic For
 * Applications streams, the constructor is given the root ole2 stream
 * of the document, Open reads the VBA project file and figures out
 * the number of VBA streams, and the offset of the data within them.
 * Decompress decompresses a particular numbered stream, NoStreams returns
 * this number, and StreamName can give you the streams name. Decompress
 * will call Output when it has a 4096 byte collection of data to output,
 * and also with the final remainder of data if there is still some left
 * at the end of compression. Output is virtual to allow custom handling
 * of each chunk of decompressed data. So inherit from this to do something
 * useful with the data.
 *
 * cmc
 * */
#define MACSKIP 20

//STRIP001 bool VBA_Impl::SkipTrickyMac(SvStorageStreamRef &xVBAProject)
//STRIP001 {
//STRIP001     bool bSkipped = true;
//STRIP001     //For no particularly good reason that I can see this occurs on
//STRIP001     //occasion in macintosh xls documents, it looks like an object id
//STRIP001     xVBAProject->SeekRel(2);
//STRIP001     sal_uInt32 nIdA;
//STRIP001     sal_uInt16 nIdB, nIdC;
//STRIP001     *xVBAProject >> nIdA >> nIdB >> nIdC;
//STRIP001 
//STRIP001     static const sal_uInt8 aKnownChunk[] = 
//STRIP001     {
//STRIP001         0x85, 0x2E, 0x02, 0x60, 0x8C, 0x4D, 0x0B, 0xB4
//STRIP001     };
//STRIP001     sal_uInt8 aSeq[8];
//STRIP001 	xVBAProject->Read( aSeq, sizeof(aSeq) );
//STRIP001     xVBAProject->SeekRel(2);
//STRIP001 
//STRIP001 	if (!(
//STRIP001         nIdA == 0x0D452EE1 && nIdB == 0xE08F && nIdC == 0x101A &&
//STRIP001         (0 == memcmp( aSeq, aKnownChunk, sizeof(aSeq)))
//STRIP001        ))
//STRIP001     {
//STRIP001         xVBAProject->SeekRel(-MACSKIP);
//STRIP001         bSkipped = false;
//STRIP001     }
//STRIP001     return bSkipped;
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 sal_uInt8 VBA_Impl::ReadPString(SvStorageStreamRef &xVBAProject, 
//STRIP001     bool bIsUnicode)
//STRIP001 {
//STRIP001 	sal_uInt16 nIdLen, nOut16;
//STRIP001 	sal_uInt8 nType = 0, nOut8;
//STRIP001 
//STRIP001     bool bSkippedMac = SkipTrickyMac(xVBAProject);
//STRIP001 	*xVBAProject >> nIdLen;
//STRIP001 
//STRIP001     if (nIdLen < 6) //Error recovery
//STRIP001     {
//STRIP001 		xVBAProject->SeekRel(-2); //undo 2 byte len
//STRIP001         if (bSkippedMac)
//STRIP001             xVBAProject->SeekRel(-MACSKIP);   //Undo Mac skip
//STRIP001     }
//STRIP001 	else
//STRIP001 		for(sal_uInt16 i=0; i < nIdLen / (bIsUnicode ? 2 : 1); i++)
//STRIP001 		{
//STRIP001             if (bIsUnicode)
//STRIP001     			*xVBAProject >> nOut16;
//STRIP001             else
//STRIP001             {
//STRIP001                 *xVBAProject >> nOut8;
//STRIP001                 nOut16 = nOut8;
//STRIP001             }
//STRIP001 			if (i==2)
//STRIP001 			{
//STRIP001 				if ((nOut16 == 'G') || (nOut16 == 'H') || (nOut16 == 'C') ||
//STRIP001                     nOut16 == 'D')
//STRIP001                 {
//STRIP001 					nType = static_cast<sal_uInt8>(nOut16);
//STRIP001                 }
//STRIP001 				if ( nType == 0)
//STRIP001 				{
//STRIP001                     //Error recovery, 2byte len + 3 characters of used type
//STRIP001                     xVBAProject->SeekRel(-(2 + 3 * (bIsUnicode ? 2 : 1)));
//STRIP001                     if (bSkippedMac)
//STRIP001                         xVBAProject->SeekRel(-MACSKIP);   //Undo Mac skip
//STRIP001 					break;
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 	return nType;
//STRIP001 }
//STRIP001 
//STRIP001 void VBA_Impl::Output( int nLen, const sal_uInt8*pData )
//STRIP001 {
//STRIP001 	/*
//STRIP001 	Each StarBasic module is tragically limited to the maximum len of a 
//STRIP001 	string and WordBasic is not, so each overlarge module must be split
//STRIP001 	*/
//STRIP001 	String sTemp((const sal_Char *)pData, (xub_StrLen)nLen,
//STRIP001 		meCharSet);
//STRIP001 	int nTmp = sTemp.GetTokenCount('\x0D');
//STRIP001 	int nIndex = aVBAStrings.GetSize()-1;
//STRIP001 	if (aVBAStrings.Get(nIndex)->Len() +
//STRIP001 		nLen + ((nLines+nTmp) * sComment.Len()) >= STRING_MAXLEN)
//STRIP001 	{
//STRIP001 		//DBG_ASSERT(0,"New Module String\n");
//STRIP001 		//we are too large for our boots, break out into another
//STRIP001 		//string
//STRIP001 		nLines=0;
//STRIP001 		nIndex++;
//STRIP001 		aVBAStrings.SetSize(nIndex+1);
//STRIP001 		aVBAStrings.Put(nIndex,new String);
//STRIP001 	}
//STRIP001 	*(aVBAStrings.Get(nIndex)) += sTemp;
//STRIP001 	nLines+=nTmp;
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 int VBA_Impl::ReadVBAProject(const SvStorageRef &rxVBAStorage)
//STRIP001 {
//STRIP001 	SvStorageStreamRef xVBAProject;
//STRIP001 	xVBAProject = rxVBAStorage->OpenStream( String(
//STRIP001 								RTL_CONSTASCII_STRINGPARAM( "_VBA_PROJECT" ),
//STRIP001 								RTL_TEXTENCODING_MS_1252 ),
//STRIP001 					STREAM_STD_READ | STREAM_NOCREATE );
//STRIP001 
//STRIP001 	if( !xVBAProject.Is() || SVSTREAM_OK != xVBAProject->GetError() )
//STRIP001 	{
//STRIP001 		DBG_WARNING("Not able to find vba project, cannot find macros");
//STRIP001 		return 0;
//STRIP001 	}
//STRIP001 
//STRIP001     static const sal_uInt8 aKnownId[] = {0xCC, 0x61};
//STRIP001     sal_uInt8 aId[2];
//STRIP001 	xVBAProject->Read( aId, sizeof(aId) );
//STRIP001 	if (memcmp( aId, aKnownId, sizeof(aId)))
//STRIP001     {
//STRIP001         DBG_WARNING("unrecognized VBA macro project type");
//STRIP001         return 0;
//STRIP001     }
//STRIP001 
//STRIP001     static const sal_uInt8 aOffice2003LE[] = 
//STRIP001     {
//STRIP001         0x76, 0x00, 0x00, 0x01, 0x00, 0xFF
//STRIP001     };
//STRIP001 
//STRIP001     static const sal_uInt8 aOfficeXPLE[] = 
//STRIP001     {
//STRIP001         0x73, 0x00, 0x00, 0x01, 0x00, 0xFF
//STRIP001     };
//STRIP001 
//STRIP001     static const sal_uInt8 aOfficeXPBE[] = 
//STRIP001     {
//STRIP001         0x63, 0x00, 0x00, 0x0E, 0x00, 0xFF
//STRIP001     };
//STRIP001 
//STRIP001     static const sal_uInt8 aOffice2000LE[] = 
//STRIP001     {
//STRIP001         0x6D, 0x00, 0x00, 0x01, 0x00, 0xFF
//STRIP001     };
//STRIP001     static const sal_uInt8 aOffice98BE[] = 
//STRIP001     {
//STRIP001         0x60, 0x00, 0x00, 0x0E, 0x00, 0xFF
//STRIP001     };
//STRIP001     static const sal_uInt8 aOffice97LE[] = 
//STRIP001     {
//STRIP001         0x5E, 0x00, 0x00, 0x01, 0x00, 0xFF
//STRIP001     };
//STRIP001     sal_uInt8 aProduct[6];
//STRIP001 	xVBAProject->Read( aProduct, sizeof(aProduct) );
//STRIP001 
//STRIP001     bool bIsUnicode;
//STRIP001     if (!(memcmp(aProduct, aOffice2003LE, sizeof(aProduct))))
//STRIP001     {
//STRIP001     	xVBAProject->SetNumberFormatInt( NUMBERFORMAT_INT_LITTLEENDIAN );
//STRIP001         bIsUnicode = true;
//STRIP001     }
//STRIP001     else if (!(memcmp(aProduct, aOfficeXPLE, sizeof(aProduct))))
//STRIP001     {
//STRIP001     	xVBAProject->SetNumberFormatInt( NUMBERFORMAT_INT_LITTLEENDIAN );
//STRIP001         bIsUnicode = true;
//STRIP001     }
//STRIP001     else if (!(memcmp(aProduct, aOfficeXPBE, sizeof(aProduct))))
//STRIP001     {
//STRIP001     	xVBAProject->SetNumberFormatInt( NUMBERFORMAT_INT_BIGENDIAN );
//STRIP001         mbMac = true;
//STRIP001         bIsUnicode = false;
//STRIP001     }
//STRIP001     else if (!(memcmp(aProduct, aOffice2000LE, sizeof(aProduct))))
//STRIP001     {
//STRIP001     	xVBAProject->SetNumberFormatInt( NUMBERFORMAT_INT_LITTLEENDIAN );
//STRIP001         bIsUnicode = true;
//STRIP001     }
//STRIP001     else if (!(memcmp(aProduct, aOffice98BE, sizeof(aProduct))))
//STRIP001     {
//STRIP001     	xVBAProject->SetNumberFormatInt( NUMBERFORMAT_INT_BIGENDIAN );
//STRIP001         mbMac = true;
//STRIP001         bIsUnicode = false;
//STRIP001     }
//STRIP001     else if (!(memcmp(aProduct, aOffice97LE, sizeof(aProduct))))
//STRIP001     {
//STRIP001     	xVBAProject->SetNumberFormatInt( NUMBERFORMAT_INT_LITTLEENDIAN );
//STRIP001         bIsUnicode = true;
//STRIP001     }
//STRIP001     else
//STRIP001     {
//STRIP001         switch (aProduct[3])
//STRIP001         {
//STRIP001             case 0x1:
//STRIP001                 xVBAProject->SetNumberFormatInt(NUMBERFORMAT_INT_LITTLEENDIAN);
//STRIP001                 bIsUnicode = true;
//STRIP001                 DBG_ASSERT(!this, "unrecognized VBA macro version, report to cmc. Guessing at unicode little endian");
//STRIP001                 break;
//STRIP001             case 0xe:
//STRIP001                 xVBAProject->SetNumberFormatInt(NUMBERFORMAT_INT_BIGENDIAN);
//STRIP001                 mbMac = true;
//STRIP001                 bIsUnicode = false;
//STRIP001                 DBG_ASSERT(!this, "unrecognized VBA macro version, report to cmc. Guessing at 8bit big endian");
//STRIP001                 break;
//STRIP001             default:
//STRIP001                 DBG_ASSERT(!this, "totally unrecognized VBA macro version, report to cmc");
//STRIP001                 return 0;
//STRIP001         }
//STRIP001     }
//STRIP001 
//STRIP001     sal_uInt32 nLidA;  //Language identifiers
//STRIP001     sal_uInt32 nLidB;
//STRIP001     sal_uInt16 nCharSet;
//STRIP001     sal_uInt16 nLenA;
//STRIP001     sal_uInt32 nUnknownB;
//STRIP001     sal_uInt32 nUnknownC;
//STRIP001     sal_uInt16 nLenB;
//STRIP001     sal_uInt16 nLenC;
//STRIP001     sal_uInt16 nLenD;
//STRIP001 
//STRIP001 	*xVBAProject >> nLidA >> nLidB >> nCharSet >> nLenA >> nUnknownB;
//STRIP001 	*xVBAProject >> nUnknownC >> nLenB >> nLenC >> nLenD;
//STRIP001 
//STRIP001     meCharSet = rtl_getTextEncodingFromWindowsCodePage(nCharSet);
//STRIP001 
//STRIP001     DBG_ASSERT(meCharSet != RTL_TEXTENCODING_DONTKNOW,
//STRIP001                 "don't know what vba charset to use");
//STRIP001     if (meCharSet == RTL_TEXTENCODING_DONTKNOW)
//STRIP001         meCharSet = RTL_TEXTENCODING_MS_1252;
//STRIP001 
//STRIP001     if (nLenD != 0x02)
//STRIP001     {
//STRIP001         DBG_WARNING("Warning VBA number is different, please report");
//STRIP001         return 0;
//STRIP001     }
//STRIP001 
//STRIP001 	/*
//STRIP001     A sequence of string that are prepended with a len and then begin with G
//STRIP001     or H, there are also those that begin with C or D. If a string begins with
//STRIP001     C or D, it is really two strings, one right after the other.  Each string
//STRIP001     then has a 12 bytes suffix
//STRIP001 
//STRIP001     Recognizing the end of the sequence is done by finding a str len of < 6
//STRIP001     which does not appear to be the beginning of an object id. Admittedly this
//STRIP001     isn't a great test, but nothing in the header appears to count the number
//STRIP001     of strings, and nothing else seems to match. So it'll have to do, its
//STRIP001     protected by a number of secondry tests to prove its a valid string, and
//STRIP001     everything gives up if this isn't proven.
//STRIP001     */
//STRIP001     while (1)
//STRIP001     {
//STRIP001 	    sal_uInt8 nType;
//STRIP001         nType = ReadPString(xVBAProject,bIsUnicode);
//STRIP001         if (nType == 'C' || nType == 'D')
//STRIP001         {
//STRIP001             nType = ReadPString(xVBAProject,bIsUnicode);
//STRIP001     	    DBG_ASSERT( nType == 'C' || nType == 'D', 
//STRIP001                 "VBA: This must be a 'C' or 'D' string!" );
//STRIP001             if (nType != 'C' && nType != 'D')
//STRIP001                 return 0;
//STRIP001         }
//STRIP001 //    	DBG_ASSERT( nType, "VBA: Bad String in VBA Project, panic!!" );
//STRIP001         if (!nType)
//STRIP001             break;
//STRIP001         xVBAProject->SeekRel(12);
//STRIP001     }
//STRIP001 
//STRIP001     SkipTrickyMac(xVBAProject);
//STRIP001 
//STRIP001     sal_Int16 nInt16s;
//STRIP001     *xVBAProject >> nInt16s;
//STRIP001     DBG_ASSERT( nInt16s >= 0, "VBA: Bad no of records in VBA Project, panic!" );
//STRIP001     if (!nInt16s)
//STRIP001         return 0;
//STRIP001     
//STRIP001     xVBAProject->SeekRel(2*nInt16s);
//STRIP001 
//STRIP001     sal_Int16 nInt32s;
//STRIP001     *xVBAProject >> nInt32s;
//STRIP001     DBG_ASSERT( nInt32s >= 0, "VBA: Bad no of records in VBA Project, panic!" );
//STRIP001     if (!nInt32s)
//STRIP001         return 0;
//STRIP001     xVBAProject->SeekRel(4*nInt32s);
//STRIP001 
//STRIP001     xVBAProject->SeekRel(2);
//STRIP001     for(int k=0;k<3;k++)
//STRIP001     {
//STRIP001         sal_uInt16 nLen;
//STRIP001     	*xVBAProject >> nLen;
//STRIP001         if (nLen != 0xFFFF)
//STRIP001             xVBAProject->SeekRel(nLen);
//STRIP001     }
//STRIP001     xVBAProject->SeekRel(100); //Seems fixed len
//STRIP001 
//STRIP001 	*xVBAProject >> nOffsets;
//STRIP001     DBG_ASSERT( nOffsets != 0xFFFF, "VBA: Bad nOffsets, panic!!" );
//STRIP001     if ((nOffsets == 0xFFFF) || (nOffsets == 0))
//STRIP001         return 0;
//STRIP001 	pOffsets = new VBAOffset_Impl[ nOffsets ];
//STRIP001 
//STRIP001 	int i, j;
//STRIP001 	for( i=0; i < nOffsets; i++)
//STRIP001 	{
//STRIP001 		sal_uInt16 nLen;
//STRIP001 		*xVBAProject >> nLen;
//STRIP001 
//STRIP001         if (bIsUnicode)
//STRIP001         {
//STRIP001             sal_Unicode* pBuf = pOffsets[i].sName.AllocBuffer( nLen / 2 );
//STRIP001             xVBAProject->Read( (sal_Char*)pBuf, nLen  );
//STRIP001 
//STRIP001 #ifdef OSL_BIGENDIAN
//STRIP001             for( j = 0; j < nLen / 2; ++j, ++pBuf )
//STRIP001                 *pBuf = SWAPSHORT( *pBuf );
//STRIP001 #endif // ifdef OSL_BIGENDIAN
//STRIP001         }
//STRIP001         else
//STRIP001         {
//STRIP001             ByteString aByteStr;    
//STRIP001             sal_Char*  pByteData = aByteStr.AllocBuffer( nLen );
//STRIP001             sal_Size nWasRead = xVBAProject->Read( pByteData, nLen );
//STRIP001             if( nWasRead != nLen )
//STRIP001                 aByteStr.ReleaseBufferAccess();
//STRIP001             pOffsets[i].sName += String( aByteStr, meCharSet);
//STRIP001         }
//STRIP001 
//STRIP001 		*xVBAProject >> nLen;
//STRIP001 		xVBAProject->SeekRel( nLen );
//STRIP001 
//STRIP001 		//begin section, another problem area
//STRIP001 		*xVBAProject >> nLen;
//STRIP001 		if ( nLen == 0xFFFF)
//STRIP001 		{
//STRIP001 			xVBAProject->SeekRel(2);
//STRIP001 			*xVBAProject >> nLen;
//STRIP001 			xVBAProject->SeekRel( nLen );
//STRIP001 		}
//STRIP001 		else
//STRIP001 			xVBAProject->SeekRel( nLen+2 );
//STRIP001 		
//STRIP001 		*xVBAProject >> nLen;
//STRIP001         DBG_ASSERT( nLen == 0xFFFF, "VBA: Bad field in VBA Project, panic!!" );
//STRIP001 		if ( nLen != 0xFFFF)
//STRIP001             return 0;
//STRIP001 			
//STRIP001 		xVBAProject->SeekRel(6);
//STRIP001 		sal_uInt16 nOctects;
//STRIP001 		*xVBAProject >> nOctects;
//STRIP001 		for(j=0;j<nOctects;j++)
//STRIP001 			xVBAProject->SeekRel(8);
//STRIP001 		
//STRIP001 		xVBAProject->SeekRel(5);
//STRIP001 		//end section
//STRIP001 
//STRIP001 		*xVBAProject >> pOffsets[i].nOffset;
//STRIP001 		xVBAProject->SeekRel(2);
//STRIP001 	}
//STRIP001 
//STRIP001 	return nOffsets;
//STRIP001 }
//STRIP001 
//STRIP001 bool VBA_Impl::Open( const String &rToplevel, const String &rSublevel )
//STRIP001 {
//STRIP001 	/* beginning test for vba stuff */
//STRIP001 	bool bRet = false;
//STRIP001 	SvStorageRef xMacros= xStor->OpenStorage( rToplevel,
//STRIP001 									STREAM_READWRITE | STREAM_NOCREATE |
//STRIP001 									STREAM_SHARE_DENYALL );
//STRIP001 	if( !xMacros.Is() || SVSTREAM_OK != xMacros->GetError() )
//STRIP001 	{
//STRIP001 		DBG_WARNING("No Macros Storage");
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		xVBA = xMacros->OpenStorage( rSublevel,
//STRIP001 									STREAM_READWRITE | STREAM_NOCREATE |
//STRIP001 									STREAM_SHARE_DENYALL );
//STRIP001 		if( !xVBA.Is() || SVSTREAM_OK != xVBA->GetError() )
//STRIP001 		{
//STRIP001 			DBG_WARNING("No Visual Basic in Storage");
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			if (ReadVBAProject(xVBA))
//STRIP001 				bRet = true;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	/* end test for vba stuff */
//STRIP001 	return bRet;
//STRIP001 }
//STRIP001 
//STRIP001 const StringArray &VBA_Impl::Decompress(sal_uInt16 nIndex, int *pOverflow)
//STRIP001 {
//STRIP001 	DBG_ASSERT( nIndex < nOffsets, "Index out of range" );
//STRIP001 	SvStorageStreamRef xVBAStream;
//STRIP001 	aVBAStrings.SetSize(1);
//STRIP001 	aVBAStrings.Put(0,new String);
//STRIP001 
//STRIP001 	xVBAStream = xVBA->OpenStream( pOffsets[nIndex].sName,
//STRIP001 						STREAM_STD_READ | STREAM_NOCREATE );
//STRIP001 	if (pOverflow)
//STRIP001 		*pOverflow=0;
//STRIP001 
//STRIP001 	if( !xVBAStream.Is() || SVSTREAM_OK != xVBAStream->GetError() )
//STRIP001 	{
//STRIP001 		DBG_WARNING("Not able to open vb module ");
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		xVBAStream->SetNumberFormatInt( NUMBERFORMAT_INT_LITTLEENDIAN );
//STRIP001 		DecompressVBA( nIndex, xVBAStream );
//STRIP001 		/*
//STRIP001 		 * if len was too big for a single string set that variable ?
//STRIP001 		 *	if ((len > XX) && (pOverflow))
//STRIP001 				*pOverflow=1;
//STRIP001 		 */
//STRIP001 		if (bCommented)
//STRIP001 		{
//STRIP001             String sTempStringa;
//STRIP001             if (mbMac)
//STRIP001                 sTempStringa = String(RTL_CONSTASCII_STRINGPARAM("\x0D"));
//STRIP001             else
//STRIP001                 sTempStringa = String(RTL_CONSTASCII_STRINGPARAM("\x0D\x0A"));
//STRIP001             String sTempStringb(sTempStringa);
//STRIP001 			sTempStringb+=sComment;
//STRIP001 			for(ULONG i=0;i<aVBAStrings.GetSize();i++)
//STRIP001 			{
//STRIP001 				aVBAStrings.Get(i)->SearchAndReplaceAll(
//STRIP001 					sTempStringa,sTempStringb);
//STRIP001 				aVBAStrings.Get(i)->Insert(sComment,0);
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 	return aVBAStrings;
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 int VBA_Impl::DecompressVBA( int nIndex, SvStorageStreamRef &xVBAStream )
//STRIP001 {
//STRIP001 	sal_uInt8 nLeadbyte;
//STRIP001 	sal_uInt16 nToken;
//STRIP001 	unsigned int nPos = 0;
//STRIP001 	int nLen, nDistance, nShift, nClean=1;
//STRIP001 
//STRIP001 	xVBAStream->Seek( pOffsets[ nIndex ].nOffset + 3 );
//STRIP001 
//STRIP001 	while(xVBAStream->Read(&nLeadbyte,1))
//STRIP001 	{
//STRIP001 		for(int nPosition=0x01;nPosition < 0x100;nPosition=nPosition<<1)
//STRIP001 		{
//STRIP001 			//we see if the leadbyte has flagged this location as a dataunit
//STRIP001 			//which is actually a token which must be looked up in the history
//STRIP001 			if (nLeadbyte & nPosition)
//STRIP001 			{
//STRIP001 				*xVBAStream >> nToken;
//STRIP001 
//STRIP001 				if (nClean == 0)
//STRIP001 					nClean=1;
//STRIP001 
//STRIP001                 //For some reason the division of the token into the length
//STRIP001                 //field of the data to be inserted, and the distance back into
//STRIP001                 //the history differs depending on how full the history is
//STRIP001                 int nPos2 = nPos % nWINDOWLEN;
//STRIP001                 if (nPos2 <= 0x10)
//STRIP001 					nShift = 12;
//STRIP001 				else if (nPos2 <= 0x20)
//STRIP001 					nShift = 11;
//STRIP001 				else if (nPos2 <= 0x40)
//STRIP001 					nShift = 10;
//STRIP001 				else if (nPos2 <= 0x80)
//STRIP001 					nShift = 9;
//STRIP001 				else if (nPos2 <= 0x100)
//STRIP001 					nShift = 8;
//STRIP001 				else if (nPos2 <= 0x200)
//STRIP001 					nShift = 7;
//STRIP001 				else if (nPos2 <= 0x400)
//STRIP001 					nShift = 6;
//STRIP001 				else if (nPos2 <= 0x800)
//STRIP001 					nShift = 5;
//STRIP001 				else
//STRIP001 					nShift = 4;
//STRIP001 
//STRIP001 				int i;
//STRIP001 				nLen=0;
//STRIP001 				for(i=0;i<nShift;i++)
//STRIP001 					nLen |= nToken & (1<<i);
//STRIP001 
//STRIP001 				nLen += 3;
//STRIP001 
//STRIP001 				nDistance = nToken >> nShift;
//STRIP001 
//STRIP001                 //read the len of data from the history, wrapping around the
//STRIP001                 //nWINDOWLEN boundary if necessary data read from the history
//STRIP001                 //is also copied into the recent part of the history as well.
//STRIP001 				for (i = 0; i < nLen; i++)
//STRIP001 				{
//STRIP001 					unsigned char c;
//STRIP001 					c = aHistory[(nPos-nDistance-1) % nWINDOWLEN];
//STRIP001 					aHistory[nPos % nWINDOWLEN] = c;
//STRIP001 					nPos++;
//STRIP001 				}
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001                 // special boundary case code, not guarantueed to be correct
//STRIP001                 // seems to work though, there is something wrong with the
//STRIP001                 // compression scheme (or maybe a feature) where when the data
//STRIP001                 // ends on a nWINDOWLEN boundary and the excess bytes in the 8
//STRIP001                 // dataunit list are discarded, and not interpreted as tokens
//STRIP001                 // or normal data.
//STRIP001 				if ((nPos != 0) && ((nPos % nWINDOWLEN) == 0) && (nClean))
//STRIP001 				{
//STRIP001 					xVBAStream->SeekRel(2);
//STRIP001 					nClean=0;
//STRIP001 					Output(nWINDOWLEN, aHistory);
//STRIP001 					break;
//STRIP001 				}
//STRIP001 				//This is the normal case for when the data unit is not a
//STRIP001 				//token to be looked up, but instead some normal data which
//STRIP001 				//can be output, and placed in the history.
//STRIP001 				if (xVBAStream->Read(&aHistory[nPos % nWINDOWLEN],1))
//STRIP001 					nPos++;
//STRIP001 
//STRIP001 				if (nClean == 0)
//STRIP001 					nClean=1;
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 	if (nPos % nWINDOWLEN)
//STRIP001 		Output(nPos % nWINDOWLEN,aHistory);
//STRIP001 	return(nPos);
//STRIP001 }

/* vi:set tabstop=4 shiftwidth=4 expandtab: */
}
