/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: svx_fmundo.cxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 05:47:03 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#pragma hdrstop

#ifndef _SVX_FMUNDO_HXX
#include "fmundo.hxx"
#endif

// auto strip #include <com/sun/star/beans/PropertyAttribute.hpp>
// auto strip #ifndef _COM_SUN_STAR_FORM_XFORMCONTROLLER_HPP_
// auto strip #include <com/sun/star/form/XFormController.hpp>
// auto strip #endif
#ifndef _COM_SUN_STAR_CONTAINER_XCONTAINER_HPP_
#include <com/sun/star/container/XContainer.hpp>
#endif
// auto strip #ifndef _COM_SUN_STAR_CONTAINER_XCONTAINERLISTENER_HPP_
// auto strip #include <com/sun/star/container/XContainerListener.hpp>
// auto strip #endif
#ifndef _COM_SUN_STAR_SCRIPT_XEVENTATTACHERMANAGER_HPP_
#include <com/sun/star/script/XEventAttacherManager.hpp>
#endif

#ifndef _FM_FMMODEL_HXX
#include "fmmodel.hxx"
#endif

#ifndef _SVX_FMTOOLS_HXX
#include "fmtools.hxx"
#endif

#ifndef _SVX_FMPAGE_HXX //autogen
#include <fmpage.hxx>
#endif

#ifndef _SVX_FMRESIDS_HRC
#include "fmresids.hrc"
#endif

// auto strip #ifndef _SVX_DIALMGR_HXX
// auto strip #include "dialmgr.hxx"
// auto strip #endif

#ifndef _SVX_FMUNOPGE_HXX
#include "fmpgeimp.hxx"
#endif

// auto strip #ifndef _SVX_FMPROP_HXX
// auto strip #include "fmprop.hxx"
// auto strip #endif

// auto strip #ifndef _SFXMACITEM_HXX //autogen
// auto strip #include <svtools/macitem.hxx>
// auto strip #endif

// auto strip #ifndef _SHL_HXX
// auto strip #include <tools/shl.hxx>
// auto strip #endif

// auto strip #ifndef _SBXCLASS_HXX //autogen
// auto strip #include <svtools/sbx.hxx>
// auto strip #endif

// auto strip #ifndef _SB_SBUNO_HXX
// auto strip #include <basic/sbuno.hxx>
// auto strip #endif

#ifndef _SFX_OBJSH_HXX //autogen
#include <bf_sfx2/objsh.hxx>
#endif

// auto strip #ifndef _SFXDOCFILE_HXX //autogen
// auto strip #include <bf_sfx2/docfile.hxx>
// auto strip #endif

#ifndef _SFXAPP_HXX //autogen
#include <bf_sfx2/app.hxx>
#endif

#ifndef _SFX_HRC
#include <bf_sfx2/sfx.hrc>
#endif

#ifndef _SFXEVENT_HXX //autogen
#include <bf_sfx2/event.hxx>
#endif

// auto strip #ifndef _URLOBJ_HXX //autogen
// auto strip #include <tools/urlobj.hxx>
// auto strip #endif

#ifndef _SVDITER_HXX //autogen
#include "svditer.hxx"
#endif

#ifndef _SVX_FMOBJ_HXX
#include "fmobj.hxx"
#endif

// auto strip #ifndef _OSL_MUTEX_HXX_ //autogen
// auto strip #include <osl/mutex.hxx>
// auto strip #endif

#ifndef _SVX_FMGLOB_HXX
#include "fmglob.hxx"
#endif
#ifndef _SVX_FMPROP_HRC
#include "fmprop.hrc"
#endif
#ifndef _COMPHELPER_PROPERTY_HXX_
#include <comphelper/property.hxx>
#endif
// auto strip #ifndef _COMPHELPER_UNO3_HXX_
// auto strip #include <comphelper/uno3.hxx>
// auto strip #endif
// auto strip #ifndef _COMPHELPER_STLTYPES_HXX_
// auto strip #include <comphelper/stl_types.hxx>
// auto strip #endif
namespace binfilter {

using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::awt;
using namespace ::com::sun::star::beans;
using namespace ::com::sun::star::container;
using namespace ::com::sun::star::script;
using namespace ::com::sun::star::lang;
using namespace ::com::sun::star::form;
using namespace ::binfilter::svxform;//STRIP008 using namespace ::svxform;

//------------------------------------------------------------------------------
// some helper structs for caching property infos
//------------------------------------------------------------------------------
struct PropertyInfo
{
	BOOL	bIsTransientOrReadOnly		: 1;	// the property is transient or read-only, thus we need no undo action for it
	BOOL	bIsControlSourceProperty	: 1;	// the property is the special control source property, thus it may be handled
												// as if it's transient or persistent
};

struct PropertySetInfo
{
	DECLARE_STL_USTRINGACCESS_MAP(PropertyInfo, AllProperties);

	AllProperties	aProps; 				// all properties of this set which we know so far
	BOOL			bHasEmptyControlSource; // sal_True -> the set has a DataField property, and the current value is an empty string
											// sal_False -> the set has _no_ such property or it's value isn't empty
};

//STRIP001 BOOL operator < (const Reference< XPropertySet >& lhs,
//STRIP001 				 const Reference< XPropertySet >& rhs)
//STRIP001 {
//STRIP001 	return lhs.get() < rhs.get();
//STRIP001 }

/*?*/ DECLARE_STL_STDKEY_MAP(Reference< XPropertySet >, PropertySetInfo, PropertySetInfoCache);

//------------------------------------------------------------------------------

String static_STR_UNDO_PROPERTY;
//------------------------------------------------------------------------------
/*N*/ DBG_NAME(FmXUndoEnvironment)
//------------------------------------------------------------------------------
/*N*/ FmXUndoEnvironment::FmXUndoEnvironment(FmFormModel& _rModel)
/*N*/ 				   :rModel(_rModel)
/*N*/ 				   ,nLocks(0)
/*N*/ 				   ,bReadOnly(sal_False)
/*N*/ 				   ,m_pPropertySetCache(NULL)
/*N*/ {
/*N*/ 	DBG_CTOR(FmXUndoEnvironment,NULL);
/*N*/ }

//------------------------------------------------------------------------------
/*N*/ FmXUndoEnvironment::~FmXUndoEnvironment()
/*N*/ {
/*N*/ 	DBG_DTOR(FmXUndoEnvironment,NULL);
/*N*/ 	if (m_pPropertySetCache)
/*?*/ 		delete static_cast<PropertySetInfoCache*>(m_pPropertySetCache);
/*N*/ }

//------------------------------------------------------------------------------
//STRIP001 void FmXUndoEnvironment::Clear()
//STRIP001 {
//STRIP001 	Lock();
//STRIP001 	sal_uInt16 nCount = rModel.GetPageCount();
//STRIP001 	sal_uInt16 i;
//STRIP001 	for (i = 0; i < nCount; i++)
//STRIP001 	{
//STRIP001 		Reference< XInterface >  xInt(((FmFormPage*)rModel.GetPage(i))->GetForms());
//STRIP001 		RemoveElement(xInt);
//STRIP001 	}
//STRIP001 
//STRIP001 	nCount = rModel.GetMasterPageCount();
//STRIP001 	for (i = 0; i < nCount; i++)
//STRIP001 	{
//STRIP001 		Reference< XInterface >  xInt(((FmFormPage*)rModel.GetMasterPage(i))->GetForms());
//STRIP001 		RemoveElement(xInt);
//STRIP001 	}
//STRIP001 	UnLock();
//STRIP001 
//STRIP001 	EndListening(*rModel.GetObjectShell());
//STRIP001 	if (IsListening(rModel))
//STRIP001 		EndListening(rModel);
//STRIP001 }

//------------------------------------------------------------------------------
/*N*/ void FmXUndoEnvironment::ModeChanged()
/*N*/ {
/*N*/ 	if (bReadOnly != (rModel.GetObjectShell()->IsReadOnly() || rModel.GetObjectShell()->IsReadOnlyUI()))
/*N*/ 	{
/*N*/ 		bReadOnly = !bReadOnly;
/*N*/ 
/*N*/ 		sal_uInt16 nCount = rModel.GetPageCount();
/*N*/ 		sal_uInt16 i;
/*N*/ 		for (i = 0; i < nCount; i++)
/*N*/ 		{
/*N*/ 					Reference< XInterface >  xInt(((FmFormPage*)rModel.GetPage(i))->GetForms());
/*N*/ 			AlterPropertyListening(xInt);
/*N*/ 		}
/*N*/ 
/*N*/ 		nCount = rModel.GetMasterPageCount();
/*N*/ 		for (i = 0; i < nCount; i++)
/*N*/ 		{
/*N*/ 			Reference< XInterface >  xInt(((FmFormPage*)rModel.GetMasterPage(i))->GetForms());
/*N*/ 			AlterPropertyListening(xInt);
/*N*/ 		}
/*N*/ 
/*N*/ 		if (!bReadOnly)
/*N*/ 			StartListening(rModel);
/*N*/ 		else
/*?*/ 			EndListening(rModel);
/*N*/ 	}
/*N*/ }

//------------------------------------------------------------------------------
/*N*/ void FmXUndoEnvironment::Notify( SfxBroadcaster& rBC, const SfxHint& rHint )
/*N*/ {
/*N*/ 	if (rHint.ISA(SdrHint))
/*N*/ 	{
/*N*/ 		SdrHint* pSdrHint = (SdrHint*)&rHint;
/*N*/ 		switch( pSdrHint->GetKind() )
/*N*/ 		{
/*N*/ 			case HINT_OBJINSERTED:
/*N*/ 			{
/*N*/ 				SdrObject* pSdrObj = (SdrObject*)pSdrHint->GetObject();
/*N*/ 				Inserted( pSdrObj );
/*N*/ 			}	break;
/*N*/ 			case HINT_OBJREMOVED:
/*N*/ 			{
/*N*/ 				SdrObject* pSdrObj = (SdrObject*)pSdrHint->GetObject();
/*N*/ 				Removed( pSdrObj );
/*N*/ 			}
/*N*/ 			break;
/*N*/ 		}
/*N*/ 	}
/*N*/ 	else if (rHint.ISA(SfxSimpleHint))
/*N*/ 	{
/*N*/ 		switch ( ((SfxSimpleHint&)rHint).GetId() )
/*N*/ 		{
/*N*/ 			case SFX_HINT_DYING:
/*?*/				DBG_BF_ASSERT(0, "STRIP"); //STRIP001 /*?*/ 				Clear();
/*?*/ 				break;
/*N*/ 			case SFX_HINT_MODECHANGED:
/*N*/ 				ModeChanged();
/*N*/ 				break;
/*N*/ 		}
/*N*/ 	}
/*N*/ 	else if (rHint.ISA(SfxEventHint))
/*N*/ 	{
/*N*/ 		switch (((SfxEventHint&)rHint).GetEventId())
/*N*/ 		{
/*N*/ 		case SFX_EVENT_CREATEDOC:
/*N*/ 			case SFX_EVENT_OPENDOC:
/*N*/ 				ModeChanged();
/*N*/ 				break;
/*N*/ 		}
/*N*/ 	}
/*N*/ 
/*N*/ }

//------------------------------------------------------------------
/*N*/ void FmXUndoEnvironment::Inserted(SdrObject* pObj)
/*N*/ {
/*N*/ 	if (bReadOnly)
/*N*/ 		return;
/*N*/ 
/*N*/ 	if (pObj->GetObjInventor() == FmFormInventor)
/*N*/ 	{
/*N*/ 		FmFormObj* pFormObj = PTR_CAST(FmFormObj, pObj);
/*N*/ 		Inserted( pFormObj );
/*N*/ 	}
/*N*/ 	else if (pObj->IsGroupObject())
/*N*/ 	{
/*N*/ 		SdrObjListIter aIter(*pObj->GetSubList());
/*N*/ 		while (aIter.IsMore())
/*N*/ 		{
/*?*/ 			SdrObject* pObj = aIter.Next();
/*?*/ 			Inserted(pObj);
/*N*/ 		}
/*N*/ 	}
/*N*/ }

//------------------------------------------------------------------------------
/*N*/ void FmXUndoEnvironment::Inserted(FmFormObj* pObj)
/*N*/ {
/*N*/ 	DBG_ASSERT( pObj, "FmXUndoEnvironment::Inserted: invalid object!" );
/*N*/ 	if ( !pObj )
/*N*/ 		return;
/*N*/ 
/*N*/ 	// ist das Control noch einer Form zugeordnet
/*N*/ 	Reference< XInterface >  xModel = pObj->GetUnoControlModel();
/*N*/ 	Reference< XFormComponent >  xContent(xModel, UNO_QUERY);
/*N*/ 	if (xContent.is() && pObj->GetPage())
/*N*/ 	{
/*N*/ 		// Komponente gehoert noch keiner Form an
/*?*/ 		if (!xContent->getParent().is())
/*?*/ 		{
/*?*/			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 /*?*/ 			// Einfuegen in den Parent falls noetig
//STRIP001 /*?*/ 			Reference< XIndexContainer >  xParent = pObj->GetParent();
//STRIP001 /*?*/ 			// Suchen des Form in der aktuellen Page
//STRIP001 /*?*/ 			Reference< XIndexContainer >  xForm;
//STRIP001 /*?*/ 			Reference< XInterface >  xIface(xParent, UNO_QUERY);
//STRIP001 /*?*/ 			Reference< XIndexAccess >  xForms(((FmFormPage*)pObj->GetPage())->GetForms(), UNO_QUERY);;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 			if (searchElement(xForms, xIface))
//STRIP001 /*?*/ 				xForm = xParent;
//STRIP001 /*?*/ 			else
//STRIP001 /*?*/ 			{
//STRIP001 /*?*/ 				Reference< XForm >	xTemp = ((FmFormPage*)pObj->GetPage())->GetImpl()->SetDefaults(xContent);
//STRIP001 /*?*/ 				xForm = Reference< XIndexContainer > (xTemp, UNO_QUERY);
//STRIP001 /*?*/ 			}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 			// Position des Elements
//STRIP001 /*?*/ 			sal_Int32 nPos = xForm->getCount();
//STRIP001 /*?*/ 			if ((XIndexContainer*)xForm.get() == (XIndexContainer*)xParent.get())
//STRIP001 /*?*/ 			{
//STRIP001 /*?*/ 				if (nPos > pObj->GetPos())
//STRIP001 /*?*/ 					nPos = xForm->getCount();
//STRIP001 /*?*/ 			}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 			xForm->insertByIndex(nPos, makeAny(xContent));
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 			Reference< XEventAttacherManager >	xManager(xForm, UNO_QUERY);
//STRIP001 /*?*/ 			if (xManager.is())
//STRIP001 /*?*/ 				xManager->registerScriptEvents(nPos, pObj->GetEvents());
/*?*/ 		}
/*?*/ 
/*?*/ 		// FormObject zuruecksetzen
/*?*/ 		pObj->SetObjEnv(Reference< XIndexContainer > ());
/*N*/ 	}
/*N*/ }

//------------------------------------------------------------------
/*N*/ void FmXUndoEnvironment::Removed(SdrObject* pObj)
/*N*/ {
/*N*/ 	if (bReadOnly)
/*N*/ 		return;
/*N*/ 
/*N*/ 	if (pObj->GetObjInventor() == FmFormInventor)
/*N*/ 	{
/*N*/ 		FmFormObj* pFormObj = PTR_CAST(FmFormObj, pObj);
/*N*/ 		Removed(pFormObj);
/*N*/ 	}
/*N*/ 	else if (pObj->IsGroupObject())
/*N*/ 	{
/*N*/ 		SdrObjListIter aIter(*pObj->GetSubList());
/*N*/ 		while (aIter.IsMore())
/*N*/ 		{
/*N*/ 			SdrObject* pObj = aIter.Next();
/*N*/ 			Removed(pObj);
/*N*/ 		}
/*N*/ 	}
/*N*/ }

//------------------------------------------------------------------------------
/*N*/ void FmXUndoEnvironment::Removed(FmFormObj* pObj)
/*N*/ {
/*N*/ 	DBG_ASSERT( pObj, "FmXUndoEnvironment::Removed: invalid object!" );
/*N*/ 	if ( !pObj )
/*N*/ 		return;
/*N*/ 
/*N*/ 	// ist das Control noch einer Form zugeordnet
/*N*/ 	Reference< XInterface >  xModel = pObj->GetUnoControlModel();
/*N*/ 	Reference< XFormComponent >  xContent(xModel, UNO_QUERY);
/*N*/ 	if (xContent.is())
/*N*/ 	{
/*N*/ 		// das Object wird aus einer Liste herausgenommen
/*N*/ 		// existiert ein Vater wird das Object beim beim Vater entfernt und
/*N*/ 		// am FormObject gemerkt!
/*N*/ 
/*N*/ 		// wird das Object wieder eingefuegt und ein Parent existiert, so wird dieser
/*N*/ 		// Parent wiederum gesetzt
/*N*/ 		Reference< XIndexContainer >  xForm(xContent->getParent(), UNO_QUERY);
/*N*/ 		if (xForm.is())
/*N*/ 		{
/*N*/ 			Reference< XIndexAccess >  xIndexAccess((XIndexContainer*)xForm.get());
/*N*/ 			// Feststellen an welcher Position sich das Kind befunden hat
/*N*/ 			sal_Int32 nPos = getElementPos(xIndexAccess, xContent);
/*N*/ 			if (nPos >= 0)
/*N*/ 			{
/*N*/ 				Sequence< ScriptEventDescriptor > aEvts;
/*N*/ 				Reference< XEventAttacherManager >	xManager(xForm, UNO_QUERY);
/*N*/ 				if (xManager.is())
/*N*/ 					aEvts = xManager->getScriptEvents(nPos);
/*N*/ 
/*N*/ 				try
/*N*/ 				{
/*N*/ 					pObj->SetObjEnv(xForm, nPos, aEvts);
/*N*/ 					xForm->removeByIndex(nPos);
/*N*/ 				}
/*N*/ 				catch(Exception&)
/*N*/ 				{
/*N*/ 				}
/*N*/ 
/*N*/ 			}
/*N*/ 		}
/*N*/ 	}
/*N*/ }

//	XEventListener
//------------------------------------------------------------------------------
/*?*/ void SAL_CALL FmXUndoEnvironment::disposing(const EventObject& e) throw( RuntimeException )
/*?*/ {
/*?*/	DBG_BF_ASSERT(0, "STRIP"); //STRIP001 	// check if it's an object we have cached informations about
//STRIP001 	if (m_pPropertySetCache)
//STRIP001 	{
//STRIP001 		Reference< XPropertySet > xSourceSet(e.Source, UNO_QUERY);
//STRIP001 		if (xSourceSet.is())
//STRIP001 		{
//STRIP001 			PropertySetInfoCache* pCache = static_cast<PropertySetInfoCache*>(m_pPropertySetCache);
//STRIP001 			PropertySetInfoCacheIterator aSetPos = pCache->find(xSourceSet);
//STRIP001 			if (aSetPos != pCache->end())
//STRIP001 				pCache->erase(aSetPos);
//STRIP001 		}
//STRIP001 	}
/*?*/ }

// XPropertyChangeListener
//------------------------------------------------------------------------------
/*?*/ void SAL_CALL FmXUndoEnvironment::propertyChange(const PropertyChangeEvent& evt) throw(::com::sun::star::uno::RuntimeException)
/*?*/ {
/*?*/ DBG_BF_ASSERT(0, "STRIP"); //STRIP001 //STRIP001 	::vos::OClearableGuard aGuard( Application::GetSolarMutex() );
//STRIP001 	if (!IsLocked())
//STRIP001 	{
//STRIP001 		Reference< XPropertySet >  xSet(evt.Source, UNO_QUERY);
//STRIP001 		if (!xSet.is())
//STRIP001 			return;
//STRIP001 
//STRIP001 		// if it's a "default value" property of a control model, set the according "value" property
//STRIP001 		static const sal_Char* pDefaultValueProperties[] = {
//STRIP001 			FM_PROP_DEFAULT_TEXT, FM_PROP_DEFAULTCHECKED, FM_PROP_DEFAULT_DATE, FM_PROP_DEFAULT_TIME,
//STRIP001 			FM_PROP_DEFAULT_VALUE, FM_PROP_DEFAULT_SELECT_SEQ, FM_PROP_EFFECTIVE_DEFAULT
//STRIP001 		};
//STRIP001 		const ::rtl::OUString aValueProperties[] = {
//STRIP001 			FM_PROP_TEXT, FM_PROP_STATE, FM_PROP_DATE, FM_PROP_TIME,
//STRIP001 			FM_PROP_VALUE, FM_PROP_SELECT_SEQ, FM_PROP_EFFECTIVE_VALUE
//STRIP001 		};
//STRIP001 		sal_Int32 nDefaultValueProps = sizeof(pDefaultValueProperties)/sizeof(pDefaultValueProperties[0]);
//STRIP001 		OSL_ENSURE(sizeof(aValueProperties)/sizeof(aValueProperties[0]) == nDefaultValueProps,
//STRIP001 			"FmXUndoEnvironment::propertyChange: inconsistence!");
//STRIP001 		for (sal_Int32 i=0; i<nDefaultValueProps; ++i)
//STRIP001 		{
//STRIP001 			if (0 == evt.PropertyName.compareToAscii(pDefaultValueProperties[i]))
//STRIP001 			{
//STRIP001 				try
//STRIP001 				{
//STRIP001 					xSet->setPropertyValue(aValueProperties[i], evt.NewValue);
//STRIP001 				}
//STRIP001 				catch(const Exception&)
//STRIP001 				{
//STRIP001 					OSL_ENSURE(sal_False, "FmXUndoEnvironment::propertyChange: could not adjust the value property!");
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		// no Undo for transient and readonly props. But unfortunately "transient" is not only that the
//STRIP001 		// "persistent" flag is not set for the property in question, instead is is somewhat more complex
//STRIP001 		// (depending on whether or not the affected control model is intended to be bound, i.e. has a non-empty
//STRIP001 		// ControlSource property)
//STRIP001 
//STRIP001 		// kein Undo fuer transiente und readonly properties
//STRIP001 		if (!m_pPropertySetCache)
//STRIP001 			m_pPropertySetCache = new PropertySetInfoCache;
//STRIP001 		PropertySetInfoCache* pCache = static_cast<PropertySetInfoCache*>(m_pPropertySetCache);
//STRIP001 
//STRIP001 		// let's see if we know something about the set
//STRIP001 		PropertySetInfoCacheIterator aSetPos = pCache->find(xSet);
//STRIP001 		if (aSetPos == pCache->end())
//STRIP001 		{
//STRIP001 			PropertySetInfo aNewEntry;
//STRIP001 			if (!::comphelper::hasProperty(FM_PROP_CONTROLSOURCE, xSet))
//STRIP001 			{
//STRIP001 				aNewEntry.bHasEmptyControlSource = sal_False;
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				try
//STRIP001 				{
//STRIP001 					Any aCurrentControlSource = xSet->getPropertyValue(FM_PROP_CONTROLSOURCE);
//STRIP001 					aNewEntry.bHasEmptyControlSource = !aCurrentControlSource.hasValue() || (::comphelper::getString(aCurrentControlSource).getLength() == 0);
//STRIP001 				}
//STRIP001 				catch(Exception&)
//STRIP001 				{
//STRIP001 				}
//STRIP001 			}
//STRIP001 			aSetPos = pCache->insert(PropertySetInfoCache::value_type(xSet,aNewEntry)).first;
//STRIP001 			DBG_ASSERT(aSetPos != pCache->end(), "FmXUndoEnvironment::propertyChange : just inserted it ... why it's not there ?");
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{	// is it the DataField property ?
//STRIP001 			if (evt.PropertyName.equals(FM_PROP_CONTROLSOURCE))
//STRIP001 			{
//STRIP001 				aSetPos->second.bHasEmptyControlSource = !evt.NewValue.hasValue() || (::comphelper::getString(evt.NewValue).getLength() == 0);
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		// now we have access to the cached info about the set
//STRIP001 		// let's see what we know about the property
//STRIP001 		PropertySetInfo::AllProperties& rPropInfos = aSetPos->second.aProps;
//STRIP001 		PropertySetInfo::AllPropertiesIterator aPropertyPos = rPropInfos.find(evt.PropertyName);
//STRIP001 		if (aPropertyPos == rPropInfos.end())
//STRIP001 		{	// nothing 'til now ... have to change this ....
//STRIP001 			PropertyInfo aNewEntry;
//STRIP001 
//STRIP001 			// the attributes
//STRIP001 			INT32 nAttributes = xSet->getPropertySetInfo()->getPropertyByName(evt.PropertyName).Attributes;
//STRIP001 			aNewEntry.bIsTransientOrReadOnly = ((nAttributes & PropertyAttribute::READONLY) != 0) || ((nAttributes & PropertyAttribute::TRANSIENT) != 0);
//STRIP001 
//STRIP001 			// check if it is the special "DataFieldProperty"
//STRIP001 			aNewEntry.bIsControlSourceProperty = sal_False;
//STRIP001 			try
//STRIP001 			{
//STRIP001 				if (::comphelper::hasProperty(FM_PROP_CONTROLSOURCEPROPERTY, xSet))
//STRIP001 				{
//STRIP001 					Any aControlSourceProperty = xSet->getPropertyValue(FM_PROP_CONTROLSOURCEPROPERTY);
//STRIP001 					::rtl::OUString sControlSourceProperty;
//STRIP001 					aControlSourceProperty >>= sControlSourceProperty;
//STRIP001 
//STRIP001 					aNewEntry.bIsControlSourceProperty = (sControlSourceProperty.equals(evt.PropertyName));
//STRIP001 				}
//STRIP001 			}
//STRIP001 			catch(Exception&)
//STRIP001 			{
//STRIP001 			}
//STRIP001 
//STRIP001 			// insert the new entry
//STRIP001 			aPropertyPos = rPropInfos.insert(PropertySetInfo::AllProperties::value_type(evt.PropertyName,aNewEntry)).first;
//STRIP001 			DBG_ASSERT(aPropertyPos != rPropInfos.end(), "FmXUndoEnvironment::propertyChange : just inserted it ... why it's not there ?");
//STRIP001 		}
//STRIP001 
//STRIP001 		// now we have access to the cached info about the property affected
//STRIP001 		// and are able to decide wether or not we need an undo action
//STRIP001 
//STRIP001 		if (!aPropertyPos->second.bIsTransientOrReadOnly)
//STRIP001 		{	// normally we would generate an undo action for all non-readonly and non-transient properties, but ...
//STRIP001 
//STRIP001 			// check if it is a special control property which is required for data field connectivity, these
//STRIP001 			// special properties may be handled as though they were transient ...
//STRIP001 			if (!aPropertyPos->second.bIsControlSourceProperty || aSetPos->second.bHasEmptyControlSource)
//STRIP001 				rModel.AddUndo(new FmUndoPropertyAction(rModel, evt));
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		// if it's the DataField property we may have to adjust our cache
//STRIP001 		if (m_pPropertySetCache && evt.PropertyName.equals(FM_PROP_CONTROLSOURCE))
//STRIP001 		{
//STRIP001 			Reference< XPropertySet >  xSet(evt.Source, UNO_QUERY);
//STRIP001 			PropertySetInfoCache* pCache = static_cast<PropertySetInfoCache*>(m_pPropertySetCache);
//STRIP001 			PropertySetInfo& rSetInfo = (*pCache)[xSet];
//STRIP001 			rSetInfo.bHasEmptyControlSource = !evt.NewValue.hasValue() || (::comphelper::getString(evt.NewValue).getLength() == 0);
//STRIP001 		}
//STRIP001 	}
/*?*/ }

// XContainerListener
//------------------------------------------------------------------------------
/*N*/ void SAL_CALL FmXUndoEnvironment::elementInserted(const ContainerEvent& evt) throw(::com::sun::star::uno::RuntimeException)
/*N*/ {
/*N*/ 	::vos::OClearableGuard aGuard( Application::GetSolarMutex() );
/*N*/ 	// neues Object zum lauschen
/*N*/ 	Reference< XInterface >  xIface;
/*N*/ 	evt.Element >>= xIface;
/*N*/ 	OSL_ENSURE(xIface.is(), "FmXUndoEnvironment::elementInserted: invalid container notification!");
/*N*/ 	AddElement(xIface);
/*N*/ 
/*N*/ 	if (!IsLocked() && rModel.GetObjectShell())
/*N*/ 	{
/*N*/ 		rModel.GetObjectShell()->SetModified(sal_True);
/*N*/ 	}
/*N*/ }

//------------------------------------------------------------------------------
/*?*/ void SAL_CALL FmXUndoEnvironment::elementReplaced(const ContainerEvent& evt) throw(::com::sun::star::uno::RuntimeException)
/*?*/ {
/*?*/ DBG_BF_ASSERT(0, "STRIP"); //STRIP001 //STRIP001 	::vos::OClearableGuard aGuard( Application::GetSolarMutex() );
//STRIP001 	Reference< XInterface >  xIface;
//STRIP001 	evt.ReplacedElement >>= xIface;
//STRIP001 	OSL_ENSURE(xIface.is(), "FmXUndoEnvironment::elementReplaced: invalid container notification!");
//STRIP001 	RemoveElement(xIface);
//STRIP001 
//STRIP001 	evt.Element >>= xIface;
//STRIP001 	AddElement(xIface);
//STRIP001 
//STRIP001 	if (!IsLocked() && rModel.GetObjectShell())
//STRIP001 	{
//STRIP001 		rModel.GetObjectShell()->SetModified(sal_True);
//STRIP001 	}
/*?*/ }

//------------------------------------------------------------------------------
/*N*/ void SAL_CALL FmXUndoEnvironment::elementRemoved(const ContainerEvent& evt) throw(::com::sun::star::uno::RuntimeException)
/*N*/ {
/*N*/ 	::vos::OClearableGuard aGuard( Application::GetSolarMutex() );
/*N*/ 	Reference< XInterface >  xIface;
/*N*/ 	evt.Element >>= xIface;
/*N*/ 	OSL_ENSURE(xIface.is(), "FmXUndoEnvironment::elementRemoved: invalid container notification!");
/*N*/ 	RemoveElement(xIface);
/*N*/ 
/*N*/ 	if (!IsLocked() && rModel.GetObjectShell())
/*N*/ 	{
/*?*/ 		rModel.GetObjectShell()->SetModified(sal_True);
/*N*/ 	}
/*N*/ }

//------------------------------------------------------------------------------
/*N*/ void FmXUndoEnvironment::AddForms(const Reference< XNameContainer > & rForms)
/*N*/ {
/*N*/ 	Lock();
/*N*/ 	Reference< XInterface >  xInt = rForms;
/*N*/ 	AddElement(xInt);
/*N*/ 	UnLock();
/*N*/ }

//------------------------------------------------------------------------------
/*N*/ void FmXUndoEnvironment::RemoveForms(const Reference< XNameContainer > & rForms)
/*N*/ {
/*N*/ 	Lock();
/*N*/ 	Reference< XInterface >  xInt = rForms;
/*N*/ 	RemoveElement(xInt);
/*N*/ 	UnLock();
/*N*/ }

//------------------------------------------------------------------------------
/*N*/ void FmXUndoEnvironment::AlterPropertyListening(const Reference< XInterface > & Element)
/*N*/ {
/*N*/ 	// am Container horchen
/*N*/ 	Reference< XIndexContainer >  xContainer(Element, UNO_QUERY);
/*N*/ 	if (xContainer.is())
/*N*/ 	{
/*N*/ 		sal_uInt32 nCount = xContainer->getCount();
/*N*/ 		Reference< XInterface >  xIface;
/*N*/ 		for (sal_uInt32 i = 0; i < nCount; i++)
/*N*/ 		{
/*N*/ 			xContainer->getByIndex(i) >>= xIface;
/*N*/ 			AlterPropertyListening(xIface);
/*N*/ 		}
/*N*/ 	}
/*N*/ 
/*N*/ 	Reference< XPropertySet >  xSet(Element, UNO_QUERY);
/*N*/ 	if (xSet.is())
/*N*/ 	{
/*N*/ 		if (!bReadOnly)
/*N*/ 			xSet->addPropertyChangeListener(::rtl::OUString(), (XPropertyChangeListener*)this);
/*N*/ 		else
/*N*/ 			xSet->removePropertyChangeListener(::rtl::OUString(), (XPropertyChangeListener*)this);
/*N*/ 	}
/*N*/ }


//------------------------------------------------------------------------------
/*N*/ void FmXUndoEnvironment::AddElement(const Reference< XInterface > & Element)
/*N*/ {
/*N*/ 	// am Container horchen
/*N*/ 	Reference< XIndexContainer >  xContainer(Element, UNO_QUERY);
/*N*/ 	if (xContainer.is())
/*N*/ 	{
/*N*/ 		// Wenn der Container ein EventAttachManager ist, mussen wir uns
/*N*/ 		// auch noch als ScriptListener anmelden.
/*N*/ 		Reference< XEventAttacherManager >	xEAManager(Element, UNO_QUERY);
/*N*/ 		if( xEAManager.is() )
/*N*/ 			xEAManager->addScriptListener( (XScriptListener*)this );
/*N*/ 
/*N*/ 		sal_uInt32 nCount = xContainer->getCount();
/*N*/ 		Reference< XInterface >  xIface;
/*N*/ 		for (sal_uInt32 i = 0; i < nCount; i++)
/*N*/ 		{
/*N*/ 			xContainer->getByIndex(i) >>= xIface;
/*N*/ 			AddElement(xIface);
/*N*/ 		}
/*N*/ 
/*N*/ 		Reference< XContainer >  xCont(Element, UNO_QUERY);
/*N*/ 		if (xCont.is())
/*N*/ 			xCont->addContainerListener((XContainerListener*)this);
/*N*/ 	}
/*N*/ 
/*N*/ 	if (!bReadOnly)
/*N*/ 	{
/*N*/ 		// auf Properties horchen
/*N*/ 		Reference< XPropertySet >  xSet(Element, UNO_QUERY);
/*N*/ 		if (xSet.is())
/*N*/ 			xSet->addPropertyChangeListener(::rtl::OUString(), (XPropertyChangeListener*)this);
/*N*/ 	}
/*N*/ }

//------------------------------------------------------------------------------
/*N*/ void FmXUndoEnvironment::RemoveElement(const Reference< XInterface > & Element)
/*N*/ {
/*N*/ 	if (!bReadOnly)
/*N*/ 	{
/*N*/ 		// Verbindung zu PropertySet aufheben
/*N*/ 		Reference< XPropertySet >  xSet(Element, UNO_QUERY);
/*N*/ 		if (xSet.is())
/*N*/ 		{
/*N*/ 			xSet->removePropertyChangeListener(::rtl::OUString(), (XPropertyChangeListener*)this);
/*N*/ 
/*N*/ 			Reference< XForm >	xForm(xSet, UNO_QUERY);
/*N*/ 			if (xForm.is())
/*N*/ 			{
/*N*/ 				// reset the ActiveConnection if the form is to be removed. This will (should) free the resources
/*N*/ 				// associated with this connection
/*N*/ 				// 86299 - 05/02/2001 - frank.schoenheit@germany.sun.com
/*N*/ 				xSet->setPropertyValue(FM_PROP_ACTIVE_CONNECTION, Any());
/*N*/ 			}
/*N*/ 		}
/*N*/ 	}
/*N*/ 
/*N*/ 	// Verbindung zu Kindern aufheben
/*N*/ 	Reference< XIndexContainer >  xContainer(Element, UNO_QUERY);
/*N*/ 	if (xContainer.is())
/*N*/ 	{
/*N*/ 		Reference< XContainer >  xCont(Element, UNO_QUERY);
/*N*/ 		if (xCont.is())
/*N*/ 			xCont->removeContainerListener((XContainerListener*)this);
/*N*/ 
/*N*/ 		// Wenn der Container ein EventAttachManager ist, mussen wir uns
/*N*/ 		// auch noch als ScriptListener anmelden.
/*N*/ 		Reference< XEventAttacherManager >	xEAManager(Element, UNO_QUERY);
/*N*/ 		if( xEAManager.is() )
/*N*/ 			xEAManager->removeScriptListener( (XScriptListener*)this );
/*N*/ 
/*N*/ 		sal_uInt32 nCount = xContainer->getCount();
/*N*/ 		Reference< XInterface >  xIface;
/*N*/ 		for (sal_uInt32 i = 0; i < nCount; i++)
/*N*/ 		{
/*N*/ 			xContainer->getByIndex(i) >>= xIface;
/*N*/ 			RemoveElement(xIface);
/*N*/ 		}
/*N*/ 	}
/*N*/ }


// XScriptListener
//STRIP001 void FmXUndoEnvironment::firing_Impl( const ScriptEvent& evt, Any *pSyncRet )
//STRIP001 {
//STRIP001 	::vos::OClearableGuard aGuard( Application::GetSolarMutex() );
//STRIP001 
//STRIP001 	SfxObjectShellRef xObjSh = rModel.GetObjectShell();
//STRIP001 	if( !xObjSh.Is() )
//STRIP001 		return;
//STRIP001 
//STRIP001 	{
//STRIP001 		Reference< XInterface >  xThis;
//STRIP001 		evt.Helper >>= xThis;
//STRIP001 
//STRIP001 //		if (evt.Helper.getValueType() == ::getCppuType((const Reference< XFormController>*)0))
//STRIP001 //		{
//STRIP001 //			Reference< XFormController >  xController;
//STRIP001 //			evt.Helper >>= xController;
//STRIP001 //			xThis = Reference< XInterface > (xController, UNO_QUERY);
//STRIP001 //		}
//STRIP001 //		else if (evt.Helper.getValueType() == ::getCppuType((const Reference< XPropertySet>*)0))
//STRIP001 //
//STRIP001 //		{
//STRIP001 //			Reference< XPropertySet >  xSet;
//STRIP001 //			evt.Helper >>= xSet;
//STRIP001 //			Reference< XForm > xForm(xSet, UNO_QUERY);
//STRIP001 //
//STRIP001 //			xThis = Reference< XInterface > (xSet, UNO_QUERY);
//STRIP001 //		}
//STRIP001 //		else if( evt.Helper.getValueType() == ::getCppuType((const Reference< XControl>*)0) )
//STRIP001 //
//STRIP001 //		{
//STRIP001 //			Reference< XControl >  xControl;
//STRIP001 //			evt.Helper >>= xControl;
//STRIP001 //			xThis = Reference< XInterface > (xControl, UNO_QUERY);
//STRIP001 //		}
//STRIP001 
//STRIP001 		aGuard.clear();
//STRIP001 		if (xThis.is())
//STRIP001 		{
//STRIP001 			::rtl::OUString sScriptType = evt.ScriptType;
//STRIP001 			::rtl::OUString sScriptCode = evt.ScriptCode;
//STRIP001 			Sequence< Any > aArguments = evt.Arguments;
//STRIP001 
//STRIP001 			::rtl::OUString sMacroLocation;
//STRIP001 
//STRIP001 			// the object shell still want's the script in the old format where neither "document" nor "application" is prepended
//STRIP001 			if ( 0 == sScriptType.compareToAscii( "StarBasic" ) )
//STRIP001 			{	// it's a starbasic script
//STRIP001 				sal_Int32 nPrefixLen = sScriptCode.indexOf( ':' );
//STRIP001 				DBG_ASSERT( 0 <= nPrefixLen, "FmXUndoEnvironment::firing_Impl: Basic script name in old format encountered!" );
//STRIP001 
//STRIP001 				if ( 0 <= nPrefixLen )
//STRIP001 				{
//STRIP001 					// and it has such a prefix
//STRIP001 					sMacroLocation = sScriptCode.copy( 0, nPrefixLen );
//STRIP001 					DBG_ASSERT( 0 == sMacroLocation.compareToAscii( "document" )
//STRIP001 							||	0 == sMacroLocation.compareToAscii( "application" ),
//STRIP001 							"FmXUndoEnvironment::firing_Impl: invalid (unknown) prefix!" );
//STRIP001 
//STRIP001 					// strip the prefix: the SfxObjectShell::CallScript knows nothing about such prefixes
//STRIP001 					sScriptCode = sScriptCode.copy( nPrefixLen + 1 );
//STRIP001 
//STRIP001 					// (On the medium run, we should migrate to the mechanism where scripts are executed via
//STRIP001 					// XDispatch (or whatever they are planning to use). But at the moment this mechanism is not implemented at all ...)
//STRIP001 				}
//STRIP001 			}
//STRIP001 
//STRIP001 			if ( sMacroLocation.getLength() )
//STRIP001 			{	// we have a macro in the "new" runtime format (fully described)
//STRIP001 				xObjSh->CallStarBasicScript( sScriptCode, sMacroLocation, static_cast< void* >( &aArguments ), pSyncRet );
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{	// we have a script in the old format
//STRIP001 				xObjSh->CallScript( sScriptType, sScriptCode, xThis, static_cast< void* >( &aArguments ), pSyncRet );
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 	}
//STRIP001 
//STRIP001 	// Objectshells are not thread safe, so guard the destruction
//STRIP001 	{
//STRIP001 		::vos::OGuard aGuard( Application::GetSolarMutex() );
//STRIP001 		xObjSh = NULL;
//STRIP001 	}
//STRIP001 }

/*?*/ void SAL_CALL FmXUndoEnvironment::firing(const ScriptEvent& evt) throw(::com::sun::star::uno::RuntimeException)
/*?*/ {
/*?*/ DBG_BF_ASSERT(0, "STRIP"); //STRIP001 //STRIP001 	firing_Impl( evt );
/*?*/ }

//------------------------------------------------------------------------------
/*?*/ Any SAL_CALL FmXUndoEnvironment::approveFiring(const ScriptEvent& evt) throw(::com::sun::star::reflection::InvocationTargetException, ::com::sun::star::uno::RuntimeException)
/*?*/ {
/*?*/ DBG_BF_ASSERT(0, "STRIP"); Any aRet; return aRet; //STRIP001 	Any aRet;
/*?*/ //STRIP001 	firing_Impl( evt, &aRet );
/*?*/ //STRIP001 	return aRet;
/*?*/ }

//------------------------------------------------------------------------------
//STRIP001 FmUndoPropertyAction::FmUndoPropertyAction(FmFormModel& rNewMod, const PropertyChangeEvent& evt)
//STRIP001 					 :SdrUndoAction(rNewMod)
//STRIP001 					 ,aPropertyName(evt.PropertyName)
//STRIP001 					 ,aNewValue(evt.NewValue)
//STRIP001 					 ,aOldValue(evt.OldValue)
//STRIP001 					 ,xObj(evt.Source, UNO_QUERY)
//STRIP001 {
//STRIP001 	if (rNewMod.GetObjectShell())
//STRIP001 		rNewMod.GetObjectShell()->SetModified(sal_True);
//STRIP001 	if(static_STR_UNDO_PROPERTY.Len() == 0)
//STRIP001 		static_STR_UNDO_PROPERTY = SVX_RES(RID_STR_UNDO_PROPERTY);
//STRIP001 }


//------------------------------------------------------------------------------
//STRIP001 void FmUndoPropertyAction::Undo()
//STRIP001 {
//STRIP001 	FmXUndoEnvironment& rEnv = ((FmFormModel&)rMod).GetUndoEnv();
//STRIP001 
//STRIP001 	if (xObj.is() && !rEnv.IsLocked())
//STRIP001 	{
//STRIP001 		// Locking damit keine neue UndoAction entsteht
//STRIP001 		rEnv.Lock();
//STRIP001 		xObj->setPropertyValue(aPropertyName, aOldValue);
//STRIP001 		rEnv.UnLock();
//STRIP001 	}
//STRIP001 }

//------------------------------------------------------------------------------
//STRIP001 void FmUndoPropertyAction::Redo()
//STRIP001 {
//STRIP001 	FmXUndoEnvironment& rEnv = ((FmFormModel&)rMod).GetUndoEnv();
//STRIP001 
//STRIP001 	if (xObj.is() && !rEnv.IsLocked())
//STRIP001 	{
//STRIP001 		rEnv.Lock();
//STRIP001 		xObj->setPropertyValue(aPropertyName, aNewValue);
//STRIP001 		rEnv.UnLock();
//STRIP001 	}
//STRIP001 }

//------------------------------------------------------------------------------
//STRIP001 String FmUndoPropertyAction::GetComment() const
//STRIP001 {
//STRIP001 	String aStr(static_STR_UNDO_PROPERTY);
//STRIP001 	
//STRIP001 	::rtl::OUString sPropertyDisplayName = FmPropertyInfoService::getPropertyTranslation( aPropertyName );
//STRIP001 	if ( sPropertyDisplayName.getLength() )
//STRIP001 		sPropertyDisplayName = aPropertyName;
//STRIP001 
//STRIP001 	aStr.SearchAndReplace( '#', sPropertyDisplayName );
//STRIP001 	return aStr;
//STRIP001 }


DBG_NAME(FmUndoContainerAction)
//------------------------------------------------------------------------------
//STRIP001 FmUndoContainerAction::FmUndoContainerAction(FmFormModel& rMod,
//STRIP001 											 Action _eAction,
//STRIP001 											 const Reference< XIndexContainer > & xCont,
//STRIP001 											 const Reference< XInterface > & xElem,
//STRIP001 											 sal_Int32 nIdx)
//STRIP001 					  :SdrUndoAction(rMod)
//STRIP001 					  ,eAction(_eAction)
//STRIP001 					  ,xContainer(xCont)
//STRIP001 					  ,nIndex(nIdx)
//STRIP001 {
//STRIP001 	DBG_CTOR(FmUndoContainerAction,NULL);
//STRIP001 	if (xCont.is() && xElem.is())
//STRIP001 	{
//STRIP001 		// den Richtigen IFacePointer
//STRIP001 		::comphelper::query_interface(xElem, xElement);
//STRIP001 		if (eAction == Removed)
//STRIP001 		{
//STRIP001 			if (nIndex < 0)
//STRIP001 			{
//STRIP001 				// Feststellen an welcher Position sich das Kind befunden hat
//STRIP001 				Reference< XIndexAccess >  xInd(xContainer,UNO_QUERY);
//STRIP001 				nIndex = getElementPos(xInd, xElement);
//STRIP001 			}
//STRIP001 
//STRIP001 			if (nIndex >= 0)
//STRIP001 			{
//STRIP001 				Reference< XEventAttacherManager >	xManager(xCont, UNO_QUERY);
//STRIP001 				if (xManager.is())
//STRIP001 					aEvts = xManager->getScriptEvents(nIndex);
//STRIP001 			}
//STRIP001 			else
//STRIP001 				xElement = NULL;
//STRIP001 
//STRIP001 			xOwnElement = xElement;
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			if (nIndex < 0)
//STRIP001 				nIndex = xContainer->getCount();
//STRIP001 		}
//STRIP001 	}
//STRIP001 }

//------------------------------------------------------------------------------
//STRIP001 FmUndoContainerAction::~FmUndoContainerAction()
//STRIP001 {
//STRIP001 	Reference< XComponent >  xComp(xOwnElement, UNO_QUERY);
//STRIP001 	if (xComp.is())
//STRIP001 	{
//STRIP001 		Reference< XChild >  xChild(xOwnElement, UNO_QUERY);
//STRIP001 		// nur wenn das Objekt frei schwebt
//STRIP001 		if (xChild.is() && !xChild->getParent().is())
//STRIP001 			xComp->dispose();
//STRIP001 	}
//STRIP001 	DBG_DTOR(FmUndoContainerAction,NULL);
//STRIP001 }

//------------------------------------------------------------------------------
//STRIP001 void FmUndoContainerAction::Undo()
//STRIP001 {
//STRIP001 	FmXUndoEnvironment& rEnv = ((FmFormModel&)rMod).GetUndoEnv();
//STRIP001 	if (xContainer.is() && !rEnv.IsLocked() && xElement.is())
//STRIP001 	{
//STRIP001 		rEnv.Lock();
//STRIP001 		switch (eAction)
//STRIP001 		{
//STRIP001 			case Inserted:
//STRIP001 			{
//STRIP001 				Reference< XInterface >  xObj,xIface;;
//STRIP001 				xContainer->getByIndex(nIndex) >>= xObj;
//STRIP001 						
//STRIP001 
//STRIP001 				::comphelper::query_interface(xObj, xIface);
//STRIP001 				if ((XInterface *)xElement.get() == (XInterface *)xIface.get())
//STRIP001 				{
//STRIP001 					Reference< XEventAttacherManager >	xManager(xContainer, UNO_QUERY);
//STRIP001 					if (xManager.is())
//STRIP001 						aEvts = xManager->getScriptEvents(nIndex);
//STRIP001 					xContainer->removeByIndex(nIndex);
//STRIP001 					xOwnElement = xElement;
//STRIP001 				}
//STRIP001 			}	break;
//STRIP001 			case Removed:
//STRIP001 				if (xContainer->getCount() >= nIndex)
//STRIP001 				{
//STRIP001 					Any aVal;
//STRIP001 					if (xContainer->getElementType() == ::getCppuType((const Reference< XFormComponent>*)0))
//STRIP001 
//STRIP001 					{
//STRIP001 						Reference< XFormComponent >  xFmcomp(xElement, UNO_QUERY);
//STRIP001 						aVal <<= xFmcomp;
//STRIP001 					}
//STRIP001 					else
//STRIP001 					{
//STRIP001 						Reference< XForm >	xForm(xElement, UNO_QUERY);
//STRIP001 						aVal <<= xForm;
//STRIP001 					}
//STRIP001 
//STRIP001 					xContainer->insertByIndex(nIndex, aVal);
//STRIP001 					Reference< XEventAttacherManager >	xManager(xContainer, UNO_QUERY);
//STRIP001 					if (xManager.is())
//STRIP001 						xManager->registerScriptEvents(nIndex, aEvts);
//STRIP001 					xOwnElement = NULL;
//STRIP001 				}	break;
//STRIP001 		}
//STRIP001 		rEnv.UnLock();
//STRIP001 	}
//STRIP001 }

//------------------------------------------------------------------------------
//STRIP001 void FmUndoContainerAction::Redo()
//STRIP001 {
//STRIP001 	FmXUndoEnvironment& rEnv = ((FmFormModel&)rMod).GetUndoEnv();
//STRIP001 	if (xContainer.is() && !rEnv.IsLocked() && xElement.is())
//STRIP001 	{
//STRIP001 		rEnv.Lock();
//STRIP001 		switch (eAction)
//STRIP001 		{
//STRIP001 			case Inserted:
//STRIP001 			{
//STRIP001 				if (xContainer->getCount() >= nIndex)
//STRIP001 				{
//STRIP001 					Any aVal;
//STRIP001 					if (xContainer->getElementType() == 
//STRIP001 						::getCppuType((const Reference< XFormComponent>*)0))
//STRIP001 
//STRIP001 					{
//STRIP001 						Reference< XFormComponent >  xFmcomp(xElement, UNO_QUERY);
//STRIP001 						aVal <<= xFmcomp;
//STRIP001 					}
//STRIP001 					else
//STRIP001 					{
//STRIP001 						Reference< XForm >	xForm(xElement, UNO_QUERY);
//STRIP001 						aVal <<= xForm;
//STRIP001 					}
//STRIP001 
//STRIP001 					xContainer->insertByIndex(nIndex, aVal);
//STRIP001 
//STRIP001 					Reference< XEventAttacherManager >	xManager(xContainer, UNO_QUERY);
//STRIP001 					if (xManager.is())
//STRIP001 						xManager->registerScriptEvents(nIndex, aEvts);
//STRIP001 					xOwnElement = NULL;
//STRIP001 				}
//STRIP001 			}	break;
//STRIP001 			case Removed:
//STRIP001 			{
//STRIP001 				Reference< XInterface >  xObj;
//STRIP001 				xContainer->getByIndex(nIndex) >>= xObj;
//STRIP001 				if ((XInterface *)xElement.get() == (XInterface *)xObj.get())
//STRIP001 				{
//STRIP001 					Reference< XEventAttacherManager >	xManager(xContainer, UNO_QUERY);
//STRIP001 					if (xManager.is())
//STRIP001 						aEvts = xManager->getScriptEvents(nIndex);
//STRIP001 					xContainer->removeByIndex(nIndex);
//STRIP001 					xOwnElement = xElement;
//STRIP001 				}
//STRIP001 			}	break;
//STRIP001 		}
//STRIP001 		rEnv.UnLock();
//STRIP001 	}
//STRIP001 }

//------------------------------------------------------------------------------
//STRIP001 FmUndoModelReplaceAction::FmUndoModelReplaceAction(FmFormModel& _rMod, SdrUnoObj* _pObject, const Reference< XControlModel > & _xReplaced)
//STRIP001 	:SdrUndoAction(_rMod)
//STRIP001 	,m_xReplaced(_xReplaced)
//STRIP001 	,m_pObject(_pObject)
//STRIP001 {
//STRIP001 }

//------------------------------------------------------------------------------
//STRIP001 FmUndoModelReplaceAction::~FmUndoModelReplaceAction()
//STRIP001 {
//STRIP001 	// dispose our element if nobody else is responsible for
//STRIP001 	Reference< XComponent >  xComp(m_xReplaced, UNO_QUERY);
//STRIP001 	if (xComp.is())
//STRIP001 	{
//STRIP001 		Reference< XChild >  xChild(m_xReplaced, UNO_QUERY);
//STRIP001 		if (!xChild.is() || !xChild->getParent().is())
//STRIP001 			xComp->dispose();
//STRIP001 	}
//STRIP001 }

//------------------------------------------------------------------------------
//STRIP001 void FmUndoModelReplaceAction::Undo()
//STRIP001 {
//STRIP001 	try
//STRIP001 	{
//STRIP001 		Reference< XControlModel > xCurrentModel( m_pObject->GetUnoControlModel() );
//STRIP001 
//STRIP001 		// replace the model within the parent
//STRIP001 		Reference< XChild > xCurrentAsChild( xCurrentModel, UNO_QUERY );
//STRIP001 		Reference< XNameContainer > xCurrentsParent;
//STRIP001 		if ( xCurrentAsChild.is() )
//STRIP001 			xCurrentsParent = xCurrentsParent.query( xCurrentAsChild->getParent() );
//STRIP001 		DBG_ASSERT( xCurrentsParent.is(), "FmUndoModelReplaceAction::Undo: invalid current model!" );
//STRIP001 
//STRIP001 		if ( xCurrentsParent.is() )
//STRIP001 		{
//STRIP001 			// the form container works with FormComponents
//STRIP001 			Reference< XFormComponent > xComponent( m_xReplaced, UNO_QUERY );
//STRIP001 			DBG_ASSERT( xComponent.is(), "FmUndoModelReplaceAction::Undo: the new model is no form component !" );
//STRIP001 
//STRIP001 			Reference< XPropertySet > xCurrentAsSet( xCurrentModel, UNO_QUERY );
//STRIP001 			DBG_ASSERT( ::comphelper::hasProperty(FM_PROP_NAME, xCurrentAsSet ), "FmUndoModelReplaceAction::Undo : one of the models is invalid !");
//STRIP001 
//STRIP001 			::rtl::OUString sName;
//STRIP001 			xCurrentAsSet->getPropertyValue( FM_PROP_NAME ) >>= sName;
//STRIP001 			xCurrentsParent->replaceByName( sName, makeAny( xComponent ) );
//STRIP001 
//STRIP001 			m_pObject->SetUnoControlModel(m_xReplaced);
//STRIP001 			m_pObject->SetChanged();
//STRIP001 
//STRIP001 			m_xReplaced = xCurrentModel;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	catch(Exception&)
//STRIP001 	{
//STRIP001 		DBG_ERROR("FmUndoModelReplaceAction::Undo : could not replace the model !");
//STRIP001 	}
//STRIP001 }

//------------------------------------------------------------------------------
//STRIP001 String FmUndoModelReplaceAction::GetComment() const
//STRIP001 {
//STRIP001 	return SVX_RES(RID_STR_UNDO_MODEL_REPLACE);
//STRIP001 }




}
