/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: svx_tpshadow.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 05:12:03 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// include ---------------------------------------------------------------

#ifndef _SHL_HXX //autogen
#include <tools/shl.hxx>
#endif
#ifndef _SFXAPP_HXX
#include <bf_sfx2/app.hxx>
#endif
#ifndef _SFXMODULE_HXX
#include <bf_sfx2/module.hxx>
#endif

#define _SVX_TPSHADOW_CXX

#include "xattr.hxx"
#include "xpool.hxx"
#include "dialogs.hrc"
#include "tabarea.hrc"

#define ITEMID_COLOR_TABLE		SID_COLOR_TABLE

#include "svdattr.hxx"
#include "xoutx.hxx"

#include "drawitem.hxx"
#include "tabarea.hxx"
#include "dialmgr.hxx"
#include "dlgutil.hxx"

#ifndef _SVX_XLINEIT0_HXX //autogen
#include "xlineit0.hxx"
#endif
namespace binfilter {

//STRIP001 #define DLGWIN this->GetParent()->GetParent()

// static ----------------------------------------------------------------

//STRIP001 static USHORT pShadowRanges[] =
//STRIP001 {
//STRIP001 	SDRATTR_SHADOWCOLOR,
//STRIP001 	SDRATTR_SHADOWTRANSPARENCE,
//STRIP001 	SID_ATTR_FILL_SHADOW,
//STRIP001 	SID_ATTR_FILL_SHADOW,
//STRIP001 	0
//STRIP001 };

/*************************************************************************
|*
|*	Dialog zum Aendern des Schattens
|*
\************************************************************************/

//STRIP001 SvxShadowTabPage::SvxShadowTabPage( Window* pParent, const SfxItemSet& rInAttrs ) :
//STRIP001 
//STRIP001 	SvxTabPage			( pParent, SVX_RES( RID_SVXPAGE_SHADOW ), rInAttrs ),
//STRIP001 
//STRIP001 	pXPool				( (XOutdevItemPool*) rInAttrs.GetPool() ),
//STRIP001 	XOut				( &aCtlXRectPreview ),
//STRIP001 	aXFillAttr			( pXPool ),
//STRIP001 	rXFSet				( aXFillAttr.GetItemSet() ),
//STRIP001 
//STRIP001     aFlProp             ( this, ResId( FL_PROP ) ),
//STRIP001     aFtPosition         ( this, ResId( FT_POSITION ) ),
//STRIP001 	aCtlPosition		( this, ResId( CTL_POSITION ),
//STRIP001 									RP_RM, 200, 80, CS_SHADOW ),
//STRIP001 	aFtDistance			( this, ResId( FT_DISTANCE ) ),
//STRIP001 	aMtrDistance		( this, ResId( MTR_FLD_DISTANCE ) ),
//STRIP001 	aFtShadowColor		( this, ResId( FT_SHADOW_COLOR ) ),
//STRIP001 	aLbShadowColor		( this, ResId( LB_SHADOW_COLOR ) ),
//STRIP001 	aFtTransparent      ( this, ResId( FT_TRANSPARENT ) ),
//STRIP001 	aMtrTransparent      ( this, ResId( MTR_SHADOW_TRANSPARENT ) ),
//STRIP001 	aTsbShowShadow		( this, ResId( TSB_SHOW_SHADOW ) ),
//STRIP001 	aCtlXRectPreview	( this, ResId( CTL_COLOR_PREVIEW ), &XOut,
//STRIP001 									(XOutdevItemPool*) rInAttrs.GetPool() ),
//STRIP001 	rOutAttrs			( rInAttrs ),
//STRIP001 	bDisable			( FALSE )
//STRIP001 
//STRIP001 {
//STRIP001 	FreeResource();
//STRIP001 
//STRIP001 	// diese Page braucht ExchangeSupport
//STRIP001 	SetExchangeSupport();
//STRIP001 
//STRIP001 	// Metrik einstellen
//STRIP001 	FieldUnit eFUnit = GetModuleFieldUnit( &rInAttrs );
//STRIP001 
//STRIP001 	switch ( eFUnit )
//STRIP001 	{
//STRIP001 		case FUNIT_M:
//STRIP001 		case FUNIT_KM:
//STRIP001 			eFUnit = FUNIT_MM;
//STRIP001 			break;
//STRIP001 	}
//STRIP001 	SetFieldUnit( aMtrDistance, eFUnit );
//STRIP001 
//STRIP001 	// PoolUnit ermitteln
//STRIP001 	SfxItemPool* pPool = rOutAttrs.GetPool();
//STRIP001 	DBG_ASSERT( pPool, "Wo ist der Pool?" );
//STRIP001 	ePoolUnit = pPool->GetMetric( SDRATTR_SHADOWXDIST );
//STRIP001 
//STRIP001 	// Setzen des Output-Devices
//STRIP001 	XFillStyle eXFS = XFILL_SOLID;
//STRIP001 	if( rOutAttrs.GetItemState( XATTR_FILLSTYLE ) != SFX_ITEM_DONTCARE )
//STRIP001 	{
//STRIP001 		eXFS = (XFillStyle) ( ( ( const XFillStyleItem& ) rOutAttrs.
//STRIP001 								Get( GetWhich( XATTR_FILLSTYLE ) ) ).GetValue() );
//STRIP001 		switch( eXFS )
//STRIP001 		{
//STRIP001 			//case XFILL_NONE: --> NICHTS
//STRIP001 
//STRIP001 			case XFILL_SOLID:
//STRIP001 				if( SFX_ITEM_DONTCARE != rOutAttrs.GetItemState( XATTR_FILLCOLOR ) )
//STRIP001 				{
//STRIP001 					XFillColorItem aColorItem( ( const XFillColorItem& )
//STRIP001 										rOutAttrs.Get( XATTR_FILLCOLOR ) );
//STRIP001 					rXFSet.Put( aColorItem );
//STRIP001 				}
//STRIP001 			break;
//STRIP001 
//STRIP001 			case XFILL_GRADIENT:
//STRIP001 				if( SFX_ITEM_DONTCARE != rOutAttrs.GetItemState( XATTR_FILLGRADIENT ) )
//STRIP001 				{
//STRIP001 					XFillGradientItem aGradientItem( ( ( const XFillGradientItem& )
//STRIP001 											rOutAttrs.Get( XATTR_FILLGRADIENT ) ) );
//STRIP001 					rXFSet.Put( aGradientItem );
//STRIP001 				}
//STRIP001 			break;
//STRIP001 
//STRIP001 			case XFILL_HATCH:
//STRIP001 				if( SFX_ITEM_DONTCARE != rOutAttrs.GetItemState( XATTR_FILLHATCH ) )
//STRIP001 				{
//STRIP001 					XFillHatchItem aHatchItem( ( ( const XFillHatchItem& )
//STRIP001 									rOutAttrs.Get( XATTR_FILLHATCH ) ) );
//STRIP001 					rXFSet.Put( aHatchItem );
//STRIP001 				}
//STRIP001 			break;
//STRIP001 
//STRIP001 			case XFILL_BITMAP:
//STRIP001 			{
//STRIP001 				if( SFX_ITEM_DONTCARE != rOutAttrs.GetItemState( XATTR_FILLBITMAP ) )
//STRIP001 				{
//STRIP001 					XFillBitmapItem aBitmapItem( ( const XFillBitmapItem& )
//STRIP001 										rOutAttrs.Get( XATTR_FILLBITMAP ) );
//STRIP001 					rXFSet.Put( aBitmapItem );
//STRIP001 				}
//STRIP001 			}
//STRIP001 			break;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		rXFSet.Put( XFillColorItem( String(), COL_LIGHTRED ) );
//STRIP001 	}
//STRIP001 	rXFSet.Put( XFillStyleItem( eXFS ) );
//STRIP001 	aCtlXRectPreview.SetRectAttr( &aXFillAttr );
//STRIP001 	//XOut.SetFillAttr( aXFillAttr );
//STRIP001 
//STRIP001     // Set line at the OutputDevice
//STRIP001 	XLineAttrSetItem aXLineAttr( pXPool );
//STRIP001     aXLineAttr.GetItemSet().Put( XLineStyleItem( XLINE_NONE ) );
//STRIP001 	XOut.SetLineAttr( aXLineAttr.GetItemSet() );
//STRIP001 
//STRIP001 	aTsbShowShadow.SetClickHdl( LINK( this, SvxShadowTabPage, ClickShadowHdl_Impl ) );
//STRIP001 	Link aLink = LINK( this, SvxShadowTabPage, ModifyShadowHdl_Impl );
//STRIP001 	aLbShadowColor.SetSelectHdl( aLink );
//STRIP001 	aMtrTransparent.SetModifyHdl( aLink );
//STRIP001 	aMtrDistance.SetModifyHdl( aLink );
//STRIP001 
//STRIP001 	pColorTab = NULL;
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 void SvxShadowTabPage::Construct()
//STRIP001 {
//STRIP001 	// Farbtabelle fuellen
//STRIP001 	aLbShadowColor.Fill( pColorTab );
//STRIP001 
//STRIP001 	if( bDisable )
//STRIP001 	{
//STRIP001 		aTsbShowShadow.Disable();
//STRIP001 		aFtPosition.Disable();
//STRIP001 		aCtlPosition.Disable();
//STRIP001 		aFtDistance.Disable();
//STRIP001 		aMtrDistance.Disable();
//STRIP001 		aFtShadowColor.Disable();
//STRIP001 		aLbShadowColor.Disable();
//STRIP001 		aFtTransparent.Disable();
//STRIP001 		aMtrTransparent.Disable();
//STRIP001 	}
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 void SvxShadowTabPage::ActivatePage( const SfxItemSet& rSet )
//STRIP001 {
//STRIP001 	int nPos;
//STRIP001 	int nCount;
//STRIP001 
//STRIP001 	if( *pDlgType == 0 ) // Flaechen-Dialog
//STRIP001 	{
//STRIP001 		if( pColorTab )
//STRIP001 		{
//STRIP001 			// ColorTable
//STRIP001 			if( *pnColorTableState & CT_CHANGED ||
//STRIP001 				*pnColorTableState & CT_MODIFIED )
//STRIP001 			{
//STRIP001 				if( *pnColorTableState & CT_CHANGED )
//STRIP001 					pColorTab = ( (SvxAreaTabDialog*) DLGWIN )->GetNewColorTable();
//STRIP001 
//STRIP001 				// aLbShadowColor
//STRIP001 				nPos = aLbShadowColor.GetSelectEntryPos();
//STRIP001 				aLbShadowColor.Clear();
//STRIP001 				aLbShadowColor.Fill( pColorTab );
//STRIP001 				nCount = aLbShadowColor.GetEntryCount();
//STRIP001 				if( nCount == 0 )
//STRIP001 					; // Dieser Fall sollte nicht auftreten
//STRIP001 				else if( nCount <= nPos )
//STRIP001 					aLbShadowColor.SelectEntryPos( 0 );
//STRIP001 				else
//STRIP001 					aLbShadowColor.SelectEntryPos( nPos );
//STRIP001 
//STRIP001 				ModifyShadowHdl_Impl( this );
//STRIP001 			}
//STRIP001 			*pPageType = PT_SHADOW;
//STRIP001 		}
//STRIP001 	}
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 int SvxShadowTabPage::DeactivatePage( SfxItemSet* pSet )
//STRIP001 {
//STRIP001 	if( pSet )
//STRIP001 		FillItemSet( *pSet );
//STRIP001 
//STRIP001 	return( LEAVE_PAGE );
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 BOOL SvxShadowTabPage::FillItemSet( SfxItemSet& rAttrs )
//STRIP001 {
//STRIP001 	const SfxPoolItem*	pOld = NULL;
//STRIP001 	BOOL				bModified = FALSE;
//STRIP001 
//STRIP001 	if( !bDisable )
//STRIP001 	{
//STRIP001 		// Schatten
//STRIP001 		TriState eState = aTsbShowShadow.GetState();
//STRIP001 		if( eState != aTsbShowShadow.GetSavedValue() )
//STRIP001 		{
//STRIP001 			SdrShadowItem aItem( eState );
//STRIP001 			pOld = GetOldItem( rAttrs, SDRATTR_SHADOW );
//STRIP001 			if ( !pOld || !( *(const SdrShadowItem*)pOld == aItem ) )
//STRIP001 			{
//STRIP001 				rAttrs.Put( aItem );
//STRIP001 				bModified = TRUE;
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		// Schatten-Entfernung
//STRIP001 		// Etwas umstaendliche Abfrage, ob etwas geaendert wurde,
//STRIP001 		// da Items nicht direkt auf Controls abbildbar sind
//STRIP001 		INT32 nX = 0L, nY = 0L;
//STRIP001 		INT32 nXY = GetCoreValue( aMtrDistance, ePoolUnit );
//STRIP001 
//STRIP001 		switch( aCtlPosition.GetActualRP() )
//STRIP001 		{
//STRIP001 			case RP_LT: nX = nY = -nXY; 	 break;
//STRIP001 			case RP_MT: nY = -nXY;			 break;
//STRIP001 			case RP_RT: nX = nXY; nY = -nXY; break;
//STRIP001 			case RP_LM: nX = -nXY;			 break;
//STRIP001 			case RP_RM: nX = nXY;			 break;
//STRIP001 			case RP_LB: nX = -nXY; nY = nXY; break;
//STRIP001 			case RP_MB: nY = nXY; 			 break;
//STRIP001 			case RP_RB: nX = nY = nXY; 		 break;
//STRIP001 		}
//STRIP001 
//STRIP001 		// Wenn die Werte des Schattenabstanden==SFX_ITEM_DONTCARE und der angezeigte
//STRIP001 		// String im entspr. MetricField=="", dann wrde der Vergleich zw. alten und
//STRIP001 		// neuen Distance-Werte ein falsches Ergebnis liefern, da in so einem Fall die
//STRIP001 		// neuen Distance-Werte den Default-Werten des MetricField entsprchen !!!!
//STRIP001 		if ( !aMtrDistance.IsEmptyFieldValue()                                  ||
//STRIP001 			 rOutAttrs.GetItemState( SDRATTR_SHADOWXDIST ) != SFX_ITEM_DONTCARE ||
//STRIP001 			 rOutAttrs.GetItemState( SDRATTR_SHADOWYDIST ) != SFX_ITEM_DONTCARE    )
//STRIP001 		{
//STRIP001 			INT32 nOldX = 9876543; // Unmoeglicher Wert, entspr. DontCare
//STRIP001 			INT32 nOldY = 9876543;
//STRIP001 			if( rOutAttrs.GetItemState( SDRATTR_SHADOWXDIST ) != SFX_ITEM_DONTCARE &&
//STRIP001 				rOutAttrs.GetItemState( SDRATTR_SHADOWYDIST ) != SFX_ITEM_DONTCARE )
//STRIP001 			{
//STRIP001 				nOldX = ( ( const SdrShadowXDistItem& ) rOutAttrs.
//STRIP001 									Get( SDRATTR_SHADOWXDIST ) ).GetValue();
//STRIP001 				nOldY = ( ( const SdrShadowYDistItem& ) rOutAttrs.
//STRIP001 									Get( SDRATTR_SHADOWYDIST ) ).GetValue();
//STRIP001 			}
//STRIP001 			SdrShadowXDistItem aXItem( nX );
//STRIP001 			pOld = GetOldItem( rAttrs, SDRATTR_SHADOWXDIST );
//STRIP001 			if ( nX != nOldX &&
//STRIP001 				( !pOld || !( *(const SdrShadowXDistItem*)pOld == aXItem ) ) )
//STRIP001 			{
//STRIP001 				rAttrs.Put( aXItem );
//STRIP001 				bModified = TRUE;
//STRIP001 			}
//STRIP001 			SdrShadowYDistItem aYItem( nY );
//STRIP001 			pOld = GetOldItem( rAttrs, SDRATTR_SHADOWYDIST );
//STRIP001 			if ( nY != nOldY &&
//STRIP001 				( !pOld || !( *(const SdrShadowYDistItem*)pOld == aYItem ) ) )
//STRIP001 			{
//STRIP001 				rAttrs.Put( aYItem );
//STRIP001 				bModified = TRUE;
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		// ShadowColor
//STRIP001 		USHORT nPos = aLbShadowColor.GetSelectEntryPos();
//STRIP001 		if( nPos != LISTBOX_ENTRY_NOTFOUND &&
//STRIP001 			nPos != aLbShadowColor.GetSavedValue() )
//STRIP001 		{
//STRIP001 			SdrShadowColorItem aItem( aLbShadowColor.GetSelectEntry(),
//STRIP001 									aLbShadowColor.GetSelectEntryColor() );
//STRIP001 			pOld = GetOldItem( rAttrs, SDRATTR_SHADOWCOLOR );
//STRIP001 			if ( !pOld || !( *(const SdrShadowColorItem*)pOld == aItem ) )
//STRIP001 			{
//STRIP001 				rAttrs.Put( aItem );
//STRIP001 				bModified = TRUE;
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		// Transparenz
//STRIP001 		UINT16 nVal = (UINT16)aMtrTransparent.GetValue();
//STRIP001 		if( nVal != (UINT16)aMtrTransparent.GetSavedValue().ToInt32() )
//STRIP001 		{
//STRIP001 			SdrShadowTransparenceItem aItem( nVal );
//STRIP001 			pOld = GetOldItem( rAttrs, SDRATTR_SHADOWTRANSPARENCE );
//STRIP001 			if ( !pOld || !( *(const SdrShadowTransparenceItem*)pOld == aItem ) )
//STRIP001 			{
//STRIP001 				rAttrs.Put( aItem );
//STRIP001 				bModified = TRUE;
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 	return( bModified );
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 void SvxShadowTabPage::Reset( const SfxItemSet& rAttrs )
//STRIP001 {
//STRIP001 	if( !bDisable )
//STRIP001 	{
//STRIP001 		// Alle Objekte koennen einen Schatten besitzen
//STRIP001 		// z.Z. gibt es nur 8 mgliche Positionen den Schatten zu setzen
//STRIP001 
//STRIP001 		// Ist Schatten gesetzt?
//STRIP001 		if( rAttrs.GetItemState( SDRATTR_SHADOW ) != SFX_ITEM_DONTCARE )
//STRIP001 		{
//STRIP001 			aTsbShowShadow.EnableTriState( FALSE );
//STRIP001 
//STRIP001 			if( ( ( const SdrShadowItem& ) rAttrs.Get( SDRATTR_SHADOW ) ).GetValue() )
//STRIP001 				aTsbShowShadow.SetState( STATE_CHECK );
//STRIP001 			else
//STRIP001 			{
//STRIP001 				aTsbShowShadow.SetState( STATE_NOCHECK );
//STRIP001 			}
//STRIP001 		}
//STRIP001 		else
//STRIP001 			aTsbShowShadow.SetState( STATE_DONTKNOW );
//STRIP001 
//STRIP001 		// Entfernung (nur 8 moegliche Positionen), deshalb
//STRIP001 		// wird nur ein Item ausgewertet
//STRIP001 
//STRIP001 		if( rAttrs.GetItemState( SDRATTR_SHADOWXDIST ) != SFX_ITEM_DONTCARE &&
//STRIP001 			rAttrs.GetItemState( SDRATTR_SHADOWYDIST ) != SFX_ITEM_DONTCARE )
//STRIP001 		{
//STRIP001 			INT32 nX = ( ( const SdrShadowXDistItem& ) rAttrs.Get( SDRATTR_SHADOWXDIST ) ).GetValue();
//STRIP001 			INT32 nY = ( ( const SdrShadowYDistItem& ) rAttrs.Get( SDRATTR_SHADOWYDIST ) ).GetValue();
//STRIP001 
//STRIP001 			if( nX != 0 )
//STRIP001 				SetMetricValue( aMtrDistance, nX < 0L ? -nX : nX, ePoolUnit );
//STRIP001 			else
//STRIP001 				SetMetricValue( aMtrDistance, nY < 0L ? -nY : nY, ePoolUnit );
//STRIP001 
//STRIP001 			// Setzen des Schatten-Controls
//STRIP001 			if	   ( nX <  0L && nY <  0L ) aCtlPosition.SetActualRP( RP_LT );
//STRIP001 			else if( nX == 0L && nY <  0L ) aCtlPosition.SetActualRP( RP_MT );
//STRIP001 			else if( nX >  0L && nY <  0L ) aCtlPosition.SetActualRP( RP_RT );
//STRIP001 			else if( nX <  0L && nY == 0L ) aCtlPosition.SetActualRP( RP_LM );
//STRIP001 			// Mittelpunkt gibt es nicht mehr
//STRIP001 			else if( nX == 0L && nY == 0L ) aCtlPosition.SetActualRP( RP_RB );
//STRIP001 			else if( nX >  0L && nY == 0L ) aCtlPosition.SetActualRP( RP_RM );
//STRIP001 			else if( nX <  0L && nY >  0L ) aCtlPosition.SetActualRP( RP_LB );
//STRIP001 			else if( nX == 0L && nY >  0L ) aCtlPosition.SetActualRP( RP_MB );
//STRIP001 			else if( nX >  0L && nY >  0L ) aCtlPosition.SetActualRP( RP_RB );
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			// determine default-distance
//STRIP001 			SfxItemPool* pPool = rOutAttrs.GetPool();
//STRIP001 			SdrShadowXDistItem* pXDistItem = (SdrShadowXDistItem*)&pPool->GetDefaultItem (SDRATTR_SHADOWXDIST);
//STRIP001 			SdrShadowYDistItem* pYDistItem = (SdrShadowYDistItem*)&pPool->GetDefaultItem (SDRATTR_SHADOWYDIST);
//STRIP001 			if (pXDistItem && pYDistItem)
//STRIP001 			{
//STRIP001 				INT32 nX = pXDistItem->GetValue();
//STRIP001 				INT32 nY = pYDistItem->GetValue();
//STRIP001 				if( nX != 0 )
//STRIP001 					SetMetricValue( aMtrDistance, nX < 0L ? -nX : nX, ePoolUnit );
//STRIP001 				else
//STRIP001 					SetMetricValue( aMtrDistance, nY < 0L ? -nY : nY, ePoolUnit );
//STRIP001 			}
//STRIP001 
//STRIP001 			// Tristate, z.B. mehrer Objekte wurden markiert, wovon einige einen Schatten besitzen, einige nicht.
//STRIP001 			// Der anzuzeigende Text des MetricFields wird auf "" gesetzt und dient in der Methode FillItemSet
//STRIP001 			// als Erkennungszeichen dafr, das der Distance-Wert NICHT verndert wurde !!!!
//STRIP001 			aMtrDistance.SetText( String() );
//STRIP001 			aCtlPosition.SetActualRP( RP_MM );
//STRIP001 		}
//STRIP001 
//STRIP001 		// SchattenFarbe:
//STRIP001 		if( rAttrs.GetItemState( SDRATTR_SHADOWCOLOR ) != SFX_ITEM_DONTCARE )
//STRIP001 		{
//STRIP001 			aLbShadowColor.SelectEntry( ( ( const SdrShadowColorItem& ) rAttrs.Get( SDRATTR_SHADOWCOLOR ) ).GetValue() );
//STRIP001 		}
//STRIP001 		else
//STRIP001 			aLbShadowColor.SetNoSelection();
//STRIP001 
//STRIP001 		// Transparenz
//STRIP001 		if( rAttrs.GetItemState( SDRATTR_SHADOWTRANSPARENCE ) != SFX_ITEM_DONTCARE )
//STRIP001 		{
//STRIP001 			USHORT nTransp = ( ( const SdrShadowTransparenceItem& ) rAttrs.Get( SDRATTR_SHADOWTRANSPARENCE ) ).GetValue();
//STRIP001 			aMtrTransparent.SetValue( nTransp );
//STRIP001 		}
//STRIP001 		else
//STRIP001 			aMtrTransparent.SetText( String() );
//STRIP001 
//STRIP001 		// Werte sichern
//STRIP001 		//aCtlPosition
//STRIP001 		aMtrDistance.SaveValue();
//STRIP001 		aLbShadowColor.SaveValue();
//STRIP001 		aTsbShowShadow.SaveValue();
//STRIP001 
//STRIP001 		// #66832# This field was not saved, but used to determine changes.
//STRIP001 		// Why? Seems to be the error.
//STRIP001 		// It IS the error.
//STRIP001 		aMtrTransparent.SaveValue();
//STRIP001 
//STRIP001 		ClickShadowHdl_Impl( NULL );
//STRIP001 		ModifyShadowHdl_Impl( NULL );
//STRIP001 	}
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 SfxTabPage* SvxShadowTabPage::Create( Window* pWindow,
//STRIP001 				const SfxItemSet& rAttrs )
//STRIP001 {
//STRIP001 	return( new SvxShadowTabPage( pWindow, rAttrs ) );
//STRIP001 }

//------------------------------------------------------------------------

//STRIP001 USHORT*	SvxShadowTabPage::GetRanges()
//STRIP001 {
//STRIP001 	return( pShadowRanges );
//STRIP001 }

//------------------------------------------------------------------------

//STRIP001 IMPL_LINK( SvxShadowTabPage, ClickShadowHdl_Impl, void *, EMPTYARG )
//STRIP001 {
//STRIP001 	if( aTsbShowShadow.GetState() == STATE_NOCHECK )
//STRIP001 	{
//STRIP001 		aFtPosition.Disable();
//STRIP001 		aCtlPosition.Disable();
//STRIP001 		aFtDistance.Disable();
//STRIP001 		aMtrDistance.Disable();
//STRIP001 		aFtShadowColor.Disable();
//STRIP001 		aLbShadowColor.Disable();
//STRIP001 		aFtTransparent.Disable();
//STRIP001 		aMtrTransparent.Disable();
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		aFtPosition.Enable();
//STRIP001 		aCtlPosition.Enable();
//STRIP001 		aFtDistance.Enable();
//STRIP001 		aMtrDistance.Enable();
//STRIP001 		aFtShadowColor.Enable();
//STRIP001 		aLbShadowColor.Enable();
//STRIP001 		aFtTransparent.Enable();
//STRIP001 		aMtrTransparent.Enable();
//STRIP001 	}
//STRIP001 	aCtlPosition.Invalidate();
//STRIP001 
//STRIP001 	ModifyShadowHdl_Impl( NULL );
//STRIP001 
//STRIP001 	return( 0L );
//STRIP001 }

//------------------------------------------------------------------------

//STRIP001 IMPL_LINK( SvxShadowTabPage, ModifyShadowHdl_Impl, void *, EMPTYARG )
//STRIP001 {
//STRIP001 	if( aTsbShowShadow.GetState() == STATE_CHECK )
//STRIP001 		rXFSet.Put( XFillStyleItem( XFILL_SOLID ) );
//STRIP001 	else
//STRIP001 		rXFSet.Put( XFillStyleItem( XFILL_NONE ) );
//STRIP001 
//STRIP001 	USHORT nPos = aLbShadowColor.GetSelectEntryPos();
//STRIP001 	if( nPos != LISTBOX_ENTRY_NOTFOUND )
//STRIP001 	{
//STRIP001 		rXFSet.Put( XFillColorItem( String(),
//STRIP001 						aLbShadowColor.GetSelectEntryColor() ) );
//STRIP001 	}
//STRIP001 	UINT16 nVal = (UINT16)aMtrTransparent.GetValue();
//STRIP001 	XFillTransparenceItem aItem( nVal );
//STRIP001 	rXFSet.Put( XFillTransparenceItem( aItem ) );
//STRIP001 
//STRIP001 	// Schatten-Entfernung
//STRIP001 	INT32 nX = 0L, nY = 0L;
//STRIP001 	INT32 nXY = GetCoreValue( aMtrDistance, ePoolUnit );
//STRIP001 	switch( aCtlPosition.GetActualRP() )
//STRIP001 	{
//STRIP001 		case RP_LT: nX = nY = -nXY; 	 break;
//STRIP001 		case RP_MT: nY = -nXY;			 break;
//STRIP001 		case RP_RT: nX = nXY; nY = -nXY; break;
//STRIP001 		case RP_LM: nX = -nXY;			 break;
//STRIP001 		case RP_RM: nX = nXY;			 break;
//STRIP001 		case RP_LB: nX = -nXY; nY = nXY; break;
//STRIP001 		case RP_MB: nY = nXY; 			 break;
//STRIP001 		case RP_RB: nX = nY = nXY; 		 break;
//STRIP001 	}
//STRIP001 	aCtlXRectPreview.SetShadowPos( Point( nX, nY ) );
//STRIP001 
//STRIP001 	aCtlXRectPreview.SetShadowAttr( &aXFillAttr );
//STRIP001 	//XOut.SetFillAttr( aXFillAttr );
//STRIP001 	aCtlXRectPreview.Invalidate();
//STRIP001 
//STRIP001 	return( 0L );
//STRIP001 }

//------------------------------------------------------------------------

//STRIP001 void SvxShadowTabPage::PointChanged( Window* pWindow, RECT_POINT eRcPt )
//STRIP001 {
//STRIP001 	eRP = eRcPt;
//STRIP001 
//STRIP001 	// Schatten neu zeichnen
//STRIP001 	ModifyShadowHdl_Impl( pWindow );
//STRIP001 }


}
