/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: svx_thesdlg.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 05:09:19 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#pragma hdrstop
// include ---------------------------------------------------------------

#ifndef _SHL_HXX
#include <tools/shl.hxx>
#endif
#ifndef _SVTOOLS_LNGMISC_HXX_
#include <svtools/lngmisc.hxx>
#endif
#ifndef _SV_WRKWIN_HXX
#include <vcl/wrkwin.hxx>
#endif
#ifndef _MSGBOX_HXX //autogen
#include <vcl/msgbox.hxx>
#endif
#ifndef _APP_HXX //autogen
#include <vcl/svapp.hxx>
#endif

#ifndef _COM_SUN_STAR_LINGUISTIC2_XMEANING_HPP_
#include <com/sun/star/linguistic2/XMeaning.hpp>
#endif


#define _SVX_THESDLG_CXX

#include "thesdlg.hxx"
#include "dlgutil.hxx"
#include "dialmgr.hxx"
#include "svxerr.hxx"

#include "dialogs.hrc"
#include "thesdlg.hrc"

#ifndef _UNO_LINGU_HXX
#include <unolingu.hxx>
#endif
#ifndef _SVX_LANGBOX_HXX
#include <langbox.hxx>
#endif
namespace binfilter {


using namespace ::rtl;
using namespace ::com::sun::star;
using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::beans;
using namespace ::com::sun::star::linguistic2;

//STRIP001 #define S2U(s) 						StringToOUString(s, CHARSET_SYSTEM)
//STRIP001 #define U2S(s)						OUStringToString(s, CHARSET_SYSTEM)

// GetReplaceEditString -------------------------------

//STRIP001 static void GetReplaceEditString( String &rText )
//STRIP001 {
//STRIP001     // The strings returned by the thesaurus saometimes have some
//STRIP001     // explanation text put in between '(' and ')' or a trailing '*'.
//STRIP001     // These parts should not be put in the ReplaceEdit Text that may get
//STRIP001     // inserted into the document. Thus we strip them from the text.
//STRIP001     
//STRIP001     xub_StrLen nPos = rText.Search( sal_Unicode('(') );
//STRIP001     if (STRING_NOTFOUND != nPos)
//STRIP001     {
//STRIP001         xub_StrLen nEnd = rText.Search( sal_Unicode(')'), nPos );
//STRIP001         if (STRING_NOTFOUND != nEnd)
//STRIP001             rText.Erase( nPos, nEnd );
//STRIP001     }
//STRIP001     
//STRIP001     nPos = rText.Search( sal_Unicode('*') );
//STRIP001 	if (STRING_NOTFOUND != nPos)
//STRIP001         rText.Erase( nPos );
//STRIP001 
//STRIP001     // remove any possible remaining ' ' that may confuse the thesaurus
//STRIP001     // when it gets called with the text
//STRIP001     rText.EraseLeadingAndTrailingChars( sal_Unicode(' ') );
//STRIP001 }

// struct ThesDlg_Impl ---------------------------------------------------

//STRIP001 struct ThesDlg_Impl
//STRIP001 {
//STRIP001 	Reference< XThesaurus >	xThesaurus;
//STRIP001 	OUString				aLookUpText;
//STRIP001 	sal_Int16				nLookUpLanguage;
//STRIP001 
//STRIP001 	ThesDlg_Impl( Reference< XThesaurus > & xThes );
//STRIP001 	SfxErrorContext*	pErrContext;	// ErrorContext,
//STRIP001 										// w"ahrend der Dialog oben ist
//STRIP001 };

//STRIP001 ThesDlg_Impl::ThesDlg_Impl(Reference< XThesaurus > & xThes) :
//STRIP001 	xThesaurus	(xThes)
//STRIP001 {
//STRIP001 	pErrContext = NULL;
//STRIP001 	nLookUpLanguage = LANGUAGE_NONE;
//STRIP001 }


// class SvxThesaurusLanguageDlg_Impl ------------------------------------

//STRIP001 class SvxThesaurusLanguageDlg_Impl : public ModalDialog
//STRIP001 {
//STRIP001 private:
//STRIP001 	SvxLanguageBox	aLangLB;
//STRIP001     FixedLine       aLangFL;
//STRIP001 	OKButton		aOKBtn;
//STRIP001 	CancelButton	aCancelBtn;
//STRIP001 	HelpButton		aHelpBtn;
//STRIP001 
//STRIP001 #if SUPD <= 626
//STRIP001 	Reference< XThesaurus > 		xThesaurus;
//STRIP001 	uno::Sequence< lang::Locale >	aSuppLang;		// supported languages
//STRIP001 #endif
//STRIP001 
//STRIP001 	DECL_LINK( DoubleClickHdl_Impl, ListBox * );
//STRIP001 
//STRIP001 public:
//STRIP001 	SvxThesaurusLanguageDlg_Impl( Window* pParent );
//STRIP001 
//STRIP001 	sal_uInt16		GetLanguage() const;
//STRIP001 	void			SetLanguage( sal_uInt16 nLang );
//STRIP001 };

// -----------------------------------------------------------------------


//STRIP001 SvxThesaurusLanguageDlg_Impl::SvxThesaurusLanguageDlg_Impl( Window* pParent ) :
//STRIP001 
//STRIP001 	ModalDialog( pParent, SVX_RES( RID_SVXDLG_THES_LANGUAGE ) ),
//STRIP001 
//STRIP001 	aLangLB		( this, ResId( LB_THES_LANGUAGE ) ),
//STRIP001     aLangFL     ( this, ResId( FL_THES_LANGUAGE ) ),
//STRIP001 	aOKBtn		( this, ResId( BTN_LANG_OK ) ),
//STRIP001 	aCancelBtn	( this, ResId( BTN_LANG_CANCEL ) ),
//STRIP001 	aHelpBtn	( this, ResId( BTN_LANG_HELP ) )
//STRIP001 {
//STRIP001 	FreeResource();
//STRIP001 
//STRIP001     aLangLB.SetLanguageList( LANG_LIST_THES_USED, FALSE, FALSE );
//STRIP001 	aLangLB.SetDoubleClickHdl(
//STRIP001 		LINK( this, SvxThesaurusLanguageDlg_Impl, DoubleClickHdl_Impl ) );
//STRIP001 }


// -----------------------------------------------------------------------

//STRIP001 sal_uInt16 SvxThesaurusLanguageDlg_Impl::GetLanguage() const
//STRIP001 {
//STRIP001 	sal_uInt16 nLang = aLangLB.GetSelectLanguage();
//STRIP001 	return nLang;
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 void SvxThesaurusLanguageDlg_Impl::SetLanguage( sal_uInt16 nLang )
//STRIP001 {
//STRIP001 	aLangLB.SelectLanguage( nLang );
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 IMPL_LINK_INLINE_START( SvxThesaurusLanguageDlg_Impl, DoubleClickHdl_Impl, ListBox *, EMPTYARG )
//STRIP001 {
//STRIP001 	EndDialog( RET_OK );
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 IMPL_LINK_INLINE_END( SvxThesaurusLanguageDlg_Impl, DoubleClickHdl_Impl, ListBox *, EMPTYARG )

// class SvxThesaurusDialog ----------------------------------------------


// -----------------------------------------------------------------------


//STRIP001 SvxThesaurusDialog::SvxThesaurusDialog( Window* pParent, Reference< XThesaurus >  xThes,
//STRIP001 										const String &rWord, sal_Int16 nLanguage) :
//STRIP001 
//STRIP001 	SvxStandardDialog( pParent, SVX_RES( RID_SVXDLG_THESAURUS ) ),
//STRIP001 
//STRIP001 	aWordText	( this, ResId( FT_WORD ) ),
//STRIP001 	aWordLB		( this, ResId( LB_WORD ) ),
//STRIP001 	aReplaceText( this, ResId( FT_REPL ) ),
//STRIP001 	aReplaceEdit( this, ResId( ED_REPL ) ),
//STRIP001 	aMeanText	( this, ResId( FT_MEAN ) ),
//STRIP001 	aMeanLB		( this, ResId( LB_MEAN ) ),
//STRIP001 	aSynonymText( this, ResId( FT_SYNON ) ),
//STRIP001 	aSynonymLB	( this, ResId( LB_SYNON ) ),
//STRIP001     aVarFL      ( this, ResId( FL_VAR ) ),
//STRIP001 	aOkBtn		( this,	ResId( BTN_THES_OK ) ),
//STRIP001 	aCancelBtn	( this, ResId( BTN_THES_CANCEL ) ),
//STRIP001 	aLookUpBtn	( this, ResId( BTN_LOOKUP ) ),
//STRIP001 	aLangBtn	( this, ResId( BTN_LANGUAGE ) ),
//STRIP001 	aHelpBtn	( this, ResId( BTN_THES_HELP ) ),
//STRIP001 	aErrStr		(		ResId( STR_ERR_WORDNOTFOUND ) )
//STRIP001 {
//STRIP001 	pImpl = new ThesDlg_Impl( xThes );
//STRIP001 	pImpl->aLookUpText = ::rtl::OUString( rWord );
//STRIP001 	pImpl->nLookUpLanguage = nLanguage;
//STRIP001 	pImpl->pErrContext =
//STRIP001 		new	SfxErrorContext( ERRCTX_SVX_LINGU_THESAURUS, String(), this,
//STRIP001 							 RID_SVXERRCTX, DIALOG_MGR() );
//STRIP001 
//STRIP001 	aLangBtn.SetClickHdl( LINK( this, SvxThesaurusDialog, LanguageHdl_Impl ) );
//STRIP001 	aLookUpBtn.SetClickHdl( LINK( this, SvxThesaurusDialog, LookUpHdl_Impl ) );
//STRIP001 	aMeanLB.SetSelectHdl( LINK( this, SvxThesaurusDialog, EntryHdl_Impl ) );
//STRIP001 	aSynonymLB.SetSelectHdl( LINK( this, SvxThesaurusDialog, SynonymHdl_Impl ) );
//STRIP001 	Link aLink = LINK( this, SvxThesaurusDialog, SelectHdl_Impl );
//STRIP001 	aMeanLB.SetDoubleClickHdl( aLink );
//STRIP001 	aSynonymLB.SetDoubleClickHdl( aLink );
//STRIP001 	aWordLB.SetSelectHdl( aLink );
//STRIP001 
//STRIP001 	FreeResource();
//STRIP001 
//STRIP001 	OUString aTmp( rWord );
//STRIP001 	linguistic::RemoveHyphens( aTmp );
//STRIP001     linguistic::ReplaceControlChars( aTmp );
//STRIP001 	aReplaceEdit.SetText( aTmp );
//STRIP001 	aWordLB.InsertEntry( aTmp );
//STRIP001 	aWordLB.SelectEntry( aTmp );
//STRIP001 
//STRIP001 	Init_Impl( nLanguage );
//STRIP001 
//STRIP001 	// disable controls if service is missing
//STRIP001 	if (!pImpl->xThesaurus.is())
//STRIP001 		Enable( sal_False );
//STRIP001 }


// -----------------------------------------------------------------------

//STRIP001 SvxThesaurusDialog::~SvxThesaurusDialog()
//STRIP001 {
//STRIP001 	delete pImpl->pErrContext;
//STRIP001 	delete pImpl;
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 sal_uInt16 SvxThesaurusDialog::GetLanguage() const
//STRIP001 {
//STRIP001 	return pImpl->nLookUpLanguage;
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 void SvxThesaurusDialog::UpdateMeaningBox_Impl( uno::Sequence< Reference< XMeaning >  > *pMeaningSeq )
//STRIP001 {
//STRIP001 	// create temporary meaning list if not supplied from somewhere else
//STRIP001 	sal_Bool bTmpSeq = sal_False;
//STRIP001 	if (!pMeaningSeq  &&  pImpl->xThesaurus.is())
//STRIP001 	{
//STRIP001 		bTmpSeq = sal_True;
//STRIP001 		lang::Locale aLocale( SvxCreateLocale( pImpl->nLookUpLanguage ) );
//STRIP001 		uno::Sequence< Reference< XMeaning > > aTmpMean = pImpl->xThesaurus
//STRIP001 					->queryMeanings( pImpl->aLookUpText, aLocale,
//STRIP001 									 Sequence< PropertyValue >() );
//STRIP001 
//STRIP001 		pMeaningSeq = new Sequence< Reference< XMeaning >  > ( aTmpMean );
//STRIP001 	}
//STRIP001 
//STRIP001 	sal_Int32 nMeaningCount = pMeaningSeq ? pMeaningSeq->getLength() : 0;
//STRIP001 	const Reference< XMeaning >  *pMeaning = pMeaningSeq ? pMeaningSeq->getConstArray() : NULL;
//STRIP001 	aMeanLB.Clear();
//STRIP001 	for ( sal_Int32 i = 0;  i < nMeaningCount;  ++i )
//STRIP001 		aMeanLB.InsertEntry( pMeaning[i]->getMeaning() );
//STRIP001 
//STRIP001 	// remove temporary meaning list
//STRIP001 	if (bTmpSeq)
//STRIP001 		delete pMeaningSeq;
//STRIP001 
//STRIP001 	if (aMeanLB.GetEntryCount() > 0)
//STRIP001 		aMeanLB.SelectEntryPos(0);
//STRIP001 	UpdateSynonymBox_Impl();
//STRIP001 }


// -----------------------------------------------------------------------
//STRIP001 void SvxThesaurusDialog::UpdateSynonymBox_Impl()
//STRIP001 {
//STRIP001 
//STRIP001 	aSynonymLB.Clear();
//STRIP001 
//STRIP001 	sal_uInt16 nPos = aMeanLB.GetSelectEntryPos();	// active meaning pos
//STRIP001 	if (nPos != LISTBOX_ENTRY_NOTFOUND  &&  pImpl->xThesaurus.is())
//STRIP001 	{
//STRIP001 		// get Reference< XMeaning >  for selected meaning
//STRIP001 		lang::Locale aLocale( SvxCreateLocale( pImpl->nLookUpLanguage ) );
//STRIP001 		Reference< XMeaning >  xMeaning =
//STRIP001 			pImpl->xThesaurus->queryMeanings(pImpl->aLookUpText, aLocale,
//STRIP001 											 Sequence< PropertyValue >() )
//STRIP001 			 	.getConstArray()[ nPos ];
//STRIP001 
//STRIP001 		uno::Sequence< OUString >	aSynonyms;
//STRIP001 		if (xMeaning.is())
//STRIP001 			aSynonyms = xMeaning->querySynonyms();
//STRIP001 
//STRIP001 		sal_Int32 nSynonymCount = aSynonyms.getLength();
//STRIP001 		const OUString *pSynonym = aSynonyms.getConstArray();
//STRIP001 		for ( sal_Int32 i=0;  i < nSynonymCount;  ++i )
//STRIP001 			aSynonymLB.InsertEntry( pSynonym[i] );
//STRIP001 	}
//STRIP001 
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 void SvxThesaurusDialog::Apply()
//STRIP001 {
//STRIP001 }

// -----------------------------------------------------------------------
//STRIP001 void SvxThesaurusDialog::Init_Impl(sal_Int16 nLanguage)
//STRIP001 {
//STRIP001 	// Sprache anpassen
//STRIP001 	String aStr( GetText() );
//STRIP001 	aStr.Erase( aStr.Search( sal_Unicode( '(' ) ) - 1 );
//STRIP001 	aStr.Append( UniString::CreateFromAscii( RTL_CONSTASCII_STRINGPARAM( " (" ) ) );
//STRIP001 	//aStr += GetLanguageString( (LanguageType)pImpl->pThesaurus->GetLanguage() );
//STRIP001 	aStr += GetLanguageString( (LanguageType) nLanguage );
//STRIP001 	aStr.Append( sal_Unicode( ')' ) );
//STRIP001 	SetText( aStr );	// Text der Window-Leiste setzen (Wort + Sprache)
//STRIP001 
//STRIP001 	// adapt meanings according to (new) language
//STRIP001 	UpdateMeaningBox_Impl();
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 IMPL_LINK( SvxThesaurusDialog, LookUpHdl_Impl, Button *, pBtn )
//STRIP001 {
//STRIP001 
//STRIP001 	EnterWait();
//STRIP001 
//STRIP001 	String aText( aReplaceEdit.GetText() );
//STRIP001 
//STRIP001 	OUString aOldLookUpText = pImpl->aLookUpText;
//STRIP001 	pImpl->aLookUpText = ::rtl::OUString( aText );
//STRIP001 
//STRIP001 	uno::Sequence< Reference< XMeaning >  >	aMeanings;
//STRIP001 	if (pImpl->xThesaurus.is())
//STRIP001 		aMeanings = pImpl->xThesaurus->queryMeanings(
//STRIP001 							pImpl->aLookUpText,
//STRIP001 							SvxCreateLocale( pImpl->nLookUpLanguage ),
//STRIP001 							Sequence< PropertyValue >() );
//STRIP001 
//STRIP001 	LeaveWait();
//STRIP001 	if ( aMeanings.getLength() == 0 )
//STRIP001 	{
//STRIP001 		if( pBtn == &aCancelBtn ) // called via double click
//STRIP001 		{
//STRIP001 			pImpl->aLookUpText = aOldLookUpText;
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			UpdateMeaningBox_Impl( &aMeanings );
//STRIP001 			if( pBtn == &aLookUpBtn )
//STRIP001 				InfoBox( this, aErrStr ).Execute();
//STRIP001 		}
//STRIP001 		return 0;
//STRIP001 	}
//STRIP001 
//STRIP001 	UpdateMeaningBox_Impl( &aMeanings );
//STRIP001 
//STRIP001 	if ( aWordLB.GetEntryPos( aText ) == LISTBOX_ENTRY_NOTFOUND )
//STRIP001 		aWordLB.InsertEntry( aText );
//STRIP001 
//STRIP001 	aWordLB.SelectEntry( aText );
//STRIP001 	aMeanLB.SelectEntryPos( 0 );
//STRIP001 
//STRIP001 	String aStr( aMeanLB.GetSelectEntry() );
//STRIP001     GetReplaceEditString( aStr );
//STRIP001 	aReplaceEdit.SetText( aStr );
//STRIP001 	aSynonymLB.SetNoSelection();
//STRIP001 
//STRIP001 	return 0;
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 IMPL_LINK( SvxThesaurusDialog, LanguageHdl_Impl, Button *, EMPTYARG )
//STRIP001 {
//STRIP001 	if (!pImpl->xThesaurus.is())
//STRIP001 		return 0;
//STRIP001 
//STRIP001 	SvxThesaurusLanguageDlg_Impl aDlg( this );
//STRIP001 	sal_uInt16 nLang = pImpl->nLookUpLanguage;
//STRIP001 	aDlg.SetLanguage( nLang );
//STRIP001 
//STRIP001 	if ( aDlg.Execute() == RET_OK )
//STRIP001 	{
//STRIP001 		nLang = aDlg.GetLanguage();
//STRIP001 		if (pImpl->xThesaurus->hasLocale( SvxCreateLocale( nLang ) ))
//STRIP001 			pImpl->nLookUpLanguage = nLang;
//STRIP001 		UpdateMeaningBox_Impl();
//STRIP001 		Init_Impl( nLang );
//STRIP001 	}
//STRIP001 
//STRIP001 	return 0;
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 IMPL_LINK( SvxThesaurusDialog, SynonymHdl_Impl, ListBox *, EMPTYARG )
//STRIP001 {
//STRIP001 	if ( aSynonymLB.GetSelectEntryPos() != LISTBOX_ENTRY_NOTFOUND )
//STRIP001 	{
//STRIP001 		String aStr( aSynonymLB.GetSelectEntry() );
//STRIP001         GetReplaceEditString( aStr );
//STRIP001 		aReplaceEdit.SetText( aStr );
//STRIP001 	}
//STRIP001 	return 0;
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 IMPL_LINK( SvxThesaurusDialog, SelectHdl_Impl, ListBox *, pBox )
//STRIP001 {
//STRIP001 	String aStr( pBox->GetSelectEntry() );
//STRIP001     GetReplaceEditString( aStr );
//STRIP001 	aReplaceEdit.SetText( aStr );
//STRIP001 
//STRIP001 	//! 'aCancelBtn' is used to indicate that the handler is called as result
//STRIP001 	//! of a double click action.
//STRIP001 	LookUpHdl_Impl( &aCancelBtn /* ??? &aLookUpBtn */ );
//STRIP001 
//STRIP001 	return 0;
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 IMPL_LINK( SvxThesaurusDialog, EntryHdl_Impl, ListBox *, EMPTYARG )
//STRIP001 {
//STRIP001 
//STRIP001 	UpdateSynonymBox_Impl();
//STRIP001 
//STRIP001 	return 0;
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 IMPL_LINK( SvxThesaurusDialog, SpellErrorHdl_Impl, void *, pError )
//STRIP001 {
//STRIP001 	// Der "ubergebene Pointer pError ist die falsche Sprachen-Nummer
//STRIP001 	LanguageType eLang = (LanguageType)(sal_uInt32)pError;
//STRIP001 	String aErr( ::GetLanguageString( eLang ) );
//STRIP001 	// Fehlermeldung ausgeben
//STRIP001 	ErrorHandler::HandleError(
//STRIP001 		*new StringErrorInfo( ERRCODE_SVX_LINGU_LANGUAGENOTEXISTS, aErr ) );
//STRIP001 	return 0;
//STRIP001 }


}
