/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sfx2_dockwin.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 02:55:34 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// auto strip #ifndef _SFXENUMITEM_HXX //autogen
// auto strip #include <svtools/eitem.hxx>
// auto strip #endif
#ifndef _SV_DECOVIEW_HXX
#include <vcl/decoview.hxx>
#endif
#pragma hdrstop

#include "dockwin.hxx"
// auto strip #include "bindings.hxx"
#include "viewfrm.hxx"
#include "dispatch.hxx"
#include "workwin.hxx"
#include "splitwin.hxx"
#include "viewsh.hxx"
// auto strip #include "accmgr.hxx"
#include "sfxhelp.hxx"

#ifndef _SFX_SFXUNO_HXX
#include "sfxuno.hxx"
#endif

namespace binfilter {

#define MAX_TOGGLEAREA_WIDTH 		20
#define MAX_TOGGLEAREA_HEIGHT		20

// implemented in 'bf_sfx2/source/appl/childwin.cxx'
extern sal_Bool GetPosSizeFromString( const String& rStr, Point& rPos, Size& rSize );

class SfxDockingWindow_Impl
{
friend class SfxDockingWindow;

	SfxChildAlignment	eLastAlignment;
	SfxChildAlignment	eDockAlignment;
	BOOL				bConstructed;
	Size				aMinSize;
	SfxSplitWindow*		pSplitWin;
	BOOL				bSplitable;
//	BOOL				bAutoHide;

	// Folgende members sind nur in der Zeit von StartDocking bis EndDocking
	// g"ultig:
	BOOL				bEndDocked;
	Size				aSplitSize;
    long                nHorizontalSize;
    long                nVerticalSize;
	USHORT				nLine;
	USHORT 				nPos;
	USHORT 				nDockLine;
	USHORT				nDockPos;
	BOOL				bNewLine;
	BOOL 				bDockingPrevented;
    ByteString          aWinState;

	SfxChildAlignment	GetLastAlignment() const
						{ return eLastAlignment; }
	void				SetLastAlignment(SfxChildAlignment eAlign)
						{ eLastAlignment = eAlign; }
	SfxChildAlignment	GetDockAlignment() const
						{ return eDockAlignment; }
	void				SetDockAlignment(SfxChildAlignment eAlign)
						{ eDockAlignment = eAlign; }
};

//-------------------------------------------------------------------------

/*N*/ void SfxDockingWindow::Resize()

/*  [Beschreibung]

	Diese virtuelle Methode der Klasse DockingWindow merkt sich ggf. eine
	ver"anderte FloatingSize.
	Wird diese Methode von einer abgeleiteten Klasse "uberschrieben, mu\s
	auch SfxDockingWindow::Resize() gerufen werden.
*/
/*N*/ {
/*N*/ 	DockingWindow::Resize();
/*N*/     Invalidate();
/*N*/     if ( pImp->bConstructed && pMgr )
/*N*/     {
/*?*/         if ( IsFloatingMode() )
/*?*/         {
/*?*/             if( !GetFloatingWindow()->IsRollUp() )
/*?*/                 SetFloatingSize( GetOutputSizePixel() );
/*?*/             pImp->aWinState = GetFloatingWindow()->GetWindowState();
/*?*/             SfxWorkWindow *pWorkWin = pBindings->GetWorkWindow_Impl();
/*?*/             SfxChildIdentifier eIdent = SFX_CHILDWIN_DOCKINGWINDOW;
/*?*/             if ( pImp->bSplitable )
/*?*/                 eIdent = SFX_CHILDWIN_SPLITWINDOW;
/*?*/             pWorkWin->ConfigChild_Impl( eIdent, SFX_ALIGNDOCKINGWINDOW, pMgr->GetType() );
/*?*/         }
/*?*/ 		else
/*?*/ 		{
/*?*/             Size aSize( GetSizePixel() );
/*?*/             switch ( pImp->GetDockAlignment() )
/*?*/             {
/*?*/                 case SFX_ALIGN_LEFT:
/*?*/                 case SFX_ALIGN_FIRSTLEFT:
/*?*/                 case SFX_ALIGN_LASTLEFT:
/*?*/                 case SFX_ALIGN_RIGHT:
/*?*/                 case SFX_ALIGN_FIRSTRIGHT:
/*?*/                 case SFX_ALIGN_LASTRIGHT:
/*?*/                     pImp->nHorizontalSize = aSize.Width();
/*?*/                     break;
/*?*/                 case SFX_ALIGN_TOP:
/*?*/                 case SFX_ALIGN_LOWESTTOP:
/*?*/                 case SFX_ALIGN_HIGHESTTOP:
/*?*/                 case SFX_ALIGN_BOTTOM:
/*?*/                 case SFX_ALIGN_HIGHESTBOTTOM:
/*?*/                 case SFX_ALIGN_LOWESTBOTTOM:
/*?*/                     pImp->nVerticalSize = aSize.Height();
/*N*/                     break;
/*N*/             }
/*N*/ 		}
/*N*/     }
/*N*/ }

//-------------------------------------------------------------------------

/*N*/ BOOL SfxDockingWindow::PrepareToggleFloatingMode()

/*  [Beschreibung]

	Diese virtuelle Methode der Klasse DockingWindow erm"oglicht ein Eingreifen
	in das Umschalten des floating mode.
	Wird diese Methode von einer abgeleiteten Klasse "uberschrieben, mu\s
	danach SfxDockingWindow::PrepareToggleFloatingMode() gerufen werden,
	wenn nicht FALSE zur"uckgegeben wird.
*/

/*N*/ {
/*N*/ 	if (!pImp->bConstructed)
/*N*/ 		return TRUE;
/*N*/ 
/*?*/ 	if ( Application::IsInModalMode() && IsFloatingMode() || !pMgr )
/*?*/ 		return FALSE;
/*?*/ 
/*?*/     if ( pImp->bDockingPrevented )
/*?*/ 		return FALSE;
/*?*/ 
/*?*/ 	if (!IsFloatingMode())
/*?*/ 	{
/*?*/ 		// Testen, ob FloatingMode erlaubt ist
/*?*/         if ( CheckAlignment(GetAlignment(),SFX_ALIGN_NOALIGNMENT) != SFX_ALIGN_NOALIGNMENT )
/*?*/ 			return FALSE;
/*?*/ 
/*?*/ 		if ( pImp->pSplitWin )
/*?*/ 		{
/*?*/ 			// Das DockingWindow sitzt in einem SplitWindow und wird abgerissen
/*?*/ 			pImp->pSplitWin->RemoveWindow(this/*, FALSE*/);
/*?*/ 			pImp->pSplitWin = 0;
/*?*/ 		}
/*?*/ 	}
/*?*/ 	else if ( pMgr )
/*?*/ 	{
/*?*/ 		pImp->aWinState = GetFloatingWindow()->GetWindowState();
/*?*/ 
/*?*/ 		// Testen, ob es erlaubt ist, anzudocken
/*?*/         if (CheckAlignment(GetAlignment(),pImp->GetLastAlignment()) == SFX_ALIGN_NOALIGNMENT)
/*?*/ 			return FALSE;
/*?*/ 
/*?*/ 		// Testen, ob das Workwindow gerade ein Andocken erlaubt
/*?*/ 		SfxWorkWindow *pWorkWin = pBindings->GetWorkWindow_Impl();
/*?*/ 		if ( !pWorkWin->IsDockingAllowed() )
/*?*/ 			return FALSE;
/*?*/ 	}
/*?*/ 
/*?*/ 	return TRUE;
/*N*/ }

//-------------------------------------------------------------------------

/*N*/ void SfxDockingWindow::ToggleFloatingMode()

/*  [Beschreibung]

	Diese virtuelle Methode der Klasse DockingWindow setzt die internen
	Daten des SfxDockingWindow und sorgt f"ur korrektes Alignment am
	parent window.
	Durch PrepareToggleFloatMode und Initialize ist sichergestellt, da\s
	pImp->GetLastAlignment() immer eine erlaubtes Alignment liefert.
	Wird diese Methode von einer abgeleiteten Klasse "uberschrieben, mu\s
	zuerst SfxDockingWindow::ToggleFloatingMode() gerufen werden.
*/
/*N*/ {
/*N*/ 	if ( !pImp->bConstructed || !pMgr )
/*N*/ 		return;					// Kein Handler-Aufruf
/*N*/ 
/*N*/ 	// Altes Alignment merken und dann umschalten.
/*N*/ 	// Sv hat jetzt schon umgeschaltet, aber Alignment am SfxDockingWindow
/*N*/ 	// ist noch das alte!
/*N*/ 	// Was war ich bisher ?
/*?*/ 	SfxChildAlignment eLastAlign = GetAlignment();
/*?*/ 
/*?*/ 	SfxWorkWindow *pWorkWin = pBindings->GetWorkWindow_Impl();
/*?*/ 	SfxChildIdentifier eIdent = SFX_CHILDWIN_DOCKINGWINDOW;
/*?*/ 	if ( pImp->bSplitable )
/*?*/ 		eIdent = SFX_CHILDWIN_SPLITWINDOW;
/*?*/ 
/*?*/ 	if (IsFloatingMode())
/*?*/ 	{
/*?*/ 		SetAlignment(SFX_ALIGN_NOALIGNMENT);
/*?*/         if ( pImp->aWinState.Len() )
/*?*/             GetFloatingWindow()->SetWindowState( pImp->aWinState );
/*?*/         else
/*?*/             GetFloatingWindow()->SetOutputSizePixel( GetFloatingSize() );
/*
		if ( pImp->bSplitable && !pImp->bEndDocked )
			// Wenn das Fenster vorher in einem SplitWindow lag, kommt von
			// Sv kein Show
			Show();
*/
/*?*/ 	}
/*?*/ 	else
/*?*/ 	{
/*?*/ 		if (pImp->GetDockAlignment() == eLastAlign)
/*?*/ 		{
/*?*/ 			// Wenn ToggleFloatingMode aufgerufen wurde, das DockAlignment
/*?*/ 			// aber noch unver"andert ist, mu\s das ein Toggeln durch DClick
/*?*/ 			// gewesen sein, also LastAlignment verwenden
/*?*/ 			SetAlignment (pImp->GetLastAlignment());
/*?*/             if ( !pImp->bSplitable )
/*?*/ 				SetSizePixel( CalcDockingSize(GetAlignment()) );
/*?*/ 		}
/*?*/ 		else
/*?*/ 		{
/*?*/ 			// Toggeln wurde durch Draggen ausgel"ost
/*?*/ 			pImp->nLine = pImp->nDockLine;
/*?*/ 			pImp->nPos = pImp->nDockPos;
/*?*/ 			SetAlignment (pImp->GetDockAlignment());
/*?*/ 		}
/*?*/ 
/*?*/ 		if ( pImp->bSplitable )
/*?*/ 		{
/*?*/ 			// Das DockingWindow kommt jetzt in ein SplitWindow
/*?*/ 			pImp->pSplitWin = pWorkWin->GetSplitWindow_Impl(GetAlignment());
/*?*/ 
/*?*/ 			// Das LastAlignment ist jetzt immer noch das zuletzt angedockte
/*?*/             SfxSplitWindow *pSplit = pWorkWin->GetSplitWindow_Impl(pImp->GetLastAlignment());
/*?*/ 
/*?*/             DBG_ASSERT( pSplit, "LastAlignment kann nicht stimmen!" );
/*?*/ 			if ( pSplit && pSplit != pImp->pSplitWin )
/*?*/ 				{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 pSplit->ReleaseWindow_Impl(this);
/*?*/ 			if ( pImp->GetDockAlignment() == eLastAlign )
/*?*/                 {DBG_BF_ASSERT(0, "STRIP");} //STRIP001 pImp->pSplitWin->InsertWindow( this, pImp->aSplitSize );
/*?*/ 			else
/*?*/                 {DBG_BF_ASSERT(0, "STRIP");} //STRIP001 pImp->pSplitWin->InsertWindow( this, pImp->aSplitSize, pImp->nLine, pImp->nPos, pImp->bNewLine );
/*?*/ 			if ( !pImp->pSplitWin->IsFadeIn() )
/*?*/ 				pImp->pSplitWin->FadeIn();
/*?*/ 		}
/*?*/ 	}
/*?*/ 
/*?*/ 	// altes Alignment festhalten f"ur n"achstes Togglen; erst jetzt setzen
/*?*/ 	// wg. Abmelden beim SplitWindow!
/*?*/ 	pImp->SetLastAlignment(eLastAlign);
/*?*/ 
/*?*/ 	// DockAlignment zur"ucksetzen, falls noch EndDocking gerufen wird
/*?*/ 	pImp->SetDockAlignment(GetAlignment());
/*?*/ 
/*?*/ 	// SfxChildWindow korrekt andocken bzw. entdocken
/*?*/ 	if ( pMgr )
/*?*/ 		pWorkWin->ConfigChild_Impl( eIdent, SFX_TOGGLEFLOATMODE, pMgr->GetType() );
/*N*/ }

//-------------------------------------------------------------------------

/*?*/ void SfxDockingWindow::StartDocking()

/*  [Beschreibung]

	Diese virtuelle Methode der Klasse DockingWindow holt vom parent window
	das innere und "au\sere docking rectangle.
	Wird diese Methode von einer abgeleiteten Klasse "uberschrieben, mu\s
	am Ende SfxDockingWindow::StartDocking() gerufen werden.
*/
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 	if ( !pImp->bConstructed || !pMgr )
//STRIP001 		return;
//STRIP001 	SfxChildIdentifier eIdent = SFX_CHILDWIN_DOCKINGWINDOW;
//STRIP001 	if ( pImp->bSplitable )
//STRIP001 		eIdent = SFX_CHILDWIN_SPLITWINDOW;
//STRIP001 	SfxWorkWindow *pWorkWin = pBindings->GetWorkWindow_Impl();
//STRIP001 	pWorkWin->ConfigChild_Impl( eIdent, SFX_SETDOCKINGRECTS, pMgr->GetType() );
//STRIP001 	pImp->SetDockAlignment(GetAlignment());
//STRIP001 
//STRIP001 	if ( pImp->pSplitWin )
//STRIP001 	{
//STRIP001 		// Die aktuellen Docking-Daten besorgen
//STRIP001 		pImp->pSplitWin->GetWindowPos(this, pImp->nLine, pImp->nPos);
//STRIP001 		pImp->nDockLine = pImp->nLine;
//STRIP001 		pImp->nDockPos = pImp->nPos;
//STRIP001 		pImp->bNewLine = FALSE;
//STRIP001 	}
/*?*/ }

//-------------------------------------------------------------------------

/*?*/ BOOL SfxDockingWindow::Docking( const Point& rPos, Rectangle& rRect )

/*  [Beschreibung]

	Diese virtuelle Methode der Klasse DockingWindow berechnet das aktuelle
	tracking rectangle. Dazu benutzt sie die Methode CalcAlignment(rPos,rRect),
	deren Verhalten von abgeleiteten Klassen beeinflu\st werden kann (s.u.).
	Diese Methode sollte nach M"oglichkeit nicht "uberschrieben werden.
*/
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); return FALSE;//STRIP001 
//STRIP001 	if ( Application::IsInModalMode() )
//STRIP001 		return TRUE;
//STRIP001 
//STRIP001 	if ( !pImp->bConstructed || !pMgr )
//STRIP001 	{
//STRIP001 		rRect.SetSize( Size() );
//STRIP001 		return IsFloatingMode();
//STRIP001 	}
//STRIP001 
//STRIP001     if ( pImp->bDockingPrevented )
//STRIP001 		return FALSE;
//STRIP001 
//STRIP001 	BOOL bFloatMode = FALSE;
//STRIP001 	if ( GetOuterRect().IsInside( rPos ) && !IsDockingPrevented() )
//STRIP001 	{
//STRIP001 		// Maus innerhalb OuterRect : Alignment und Rectangle berechnen
//STRIP001 		SfxChildAlignment eAlign = CalcAlignment(rPos, rRect);
//STRIP001 		if (eAlign == SFX_ALIGN_NOALIGNMENT)
//STRIP001 			bFloatMode = TRUE;
//STRIP001 		pImp->SetDockAlignment(eAlign);
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		// Maus nicht innerhalb OuterRect : muss FloatingWindow sein
//STRIP001 		// Ist das erlaubt ?
//STRIP001         if (CheckAlignment(pImp->GetDockAlignment(),SFX_ALIGN_NOALIGNMENT) != SFX_ALIGN_NOALIGNMENT)
//STRIP001 			return FALSE;
//STRIP001 		bFloatMode = TRUE;
//STRIP001 		if ( SFX_ALIGN_NOALIGNMENT != pImp->GetDockAlignment() )
//STRIP001 		{
//STRIP001 			// wg. SV-Bug darf rRect nur ver"andert werden, wenn sich das
//STRIP001 			// Alignment "andert !
//STRIP001 			pImp->SetDockAlignment(SFX_ALIGN_NOALIGNMENT);
//STRIP001 			rRect.SetSize(CalcDockingSize(SFX_ALIGN_NOALIGNMENT));
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001     if ( !pImp->bSplitable )
//STRIP001 	{
//STRIP001 		// Bei individuell angedocktem Window wird die Position durch das
//STRIP001 		// Alignment und die docking rects festgelegt.
//STRIP001 		Size aSize = rRect.GetSize();
//STRIP001 		Point aPos;
//STRIP001 
//STRIP001 		switch ( pImp->GetDockAlignment() )
//STRIP001 		{
//STRIP001 			case SFX_ALIGN_LEFT:
//STRIP001 			case SFX_ALIGN_FIRSTLEFT:
//STRIP001 			case SFX_ALIGN_LASTLEFT:
//STRIP001 				aPos = aInnerRect.TopLeft();
//STRIP001 				if ( pImp->GetDockAlignment() == GetAlignment() )
//STRIP001 					aPos.X() -= aSize.Width();
//STRIP001 				break;
//STRIP001 
//STRIP001 			case SFX_ALIGN_TOP:
//STRIP001 			case SFX_ALIGN_LOWESTTOP:
//STRIP001 			case SFX_ALIGN_HIGHESTTOP:
//STRIP001 				aPos = Point(aOuterRect.Left(), aInnerRect.Top());
//STRIP001 				if ( pImp->GetDockAlignment() == GetAlignment() )
//STRIP001 					aPos.Y() -= aSize.Height();
//STRIP001 				break;
//STRIP001 
//STRIP001 			case SFX_ALIGN_RIGHT:
//STRIP001 			case SFX_ALIGN_FIRSTRIGHT:
//STRIP001 			case SFX_ALIGN_LASTRIGHT:
//STRIP001 				aPos = Point(aInnerRect.Right() - rRect.GetSize().Width(),
//STRIP001 							aInnerRect.Top());
//STRIP001 				if ( pImp->GetDockAlignment() == GetAlignment() )
//STRIP001 					aPos.X() += aSize.Width();
//STRIP001 				break;
//STRIP001 
//STRIP001 			case SFX_ALIGN_BOTTOM:
//STRIP001 			case SFX_ALIGN_HIGHESTBOTTOM:
//STRIP001 			case SFX_ALIGN_LOWESTBOTTOM:
//STRIP001 				aPos = Point(aOuterRect.Left(),
//STRIP001 						aInnerRect.Bottom() - rRect.GetSize().Height());
//STRIP001 				if ( pImp->GetDockAlignment() == GetAlignment() )
//STRIP001 					aPos.Y() += aSize.Height();
//STRIP001 				break;
//STRIP001 		}
//STRIP001 
//STRIP001 		rRect.SetPos(aPos);
//STRIP001 	}
//STRIP001 
//STRIP001 	return bFloatMode;
/*?*/ }

//-------------------------------------------------------------------------

/*?*/ void SfxDockingWindow::EndDocking( const Rectangle& rRect, BOOL bFloatMode )

/*  [Beschreibung]

	Diese virtuelle Methode der Klasse DockingWindow sorgt f"ur das korrekte
	Alignment am parent window.
	Wird diese Methode von einer abgeleiteten Klasse "uberschrieben, mu\s
	zuerst SfxDockingWindow::EndDocking() gerufen werden.
*/
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 	if ( !pImp->bConstructed || IsDockingCanceled() || !pMgr )
//STRIP001 		return;
//STRIP001 
//STRIP001 	SfxWorkWindow *pWorkWin = pBindings->GetWorkWindow_Impl();
//STRIP001 	BOOL bReArrange = FALSE;
//STRIP001 	SfxChildIdentifier eIdent = SFX_CHILDWIN_DOCKINGWINDOW;
//STRIP001 	if ( pImp->bSplitable )
//STRIP001 	{
//STRIP001 		eIdent = SFX_CHILDWIN_SPLITWINDOW;
//STRIP001 
//STRIP001 		// Wenn sich das Alignment "andert und das Fenster befindet sich
//STRIP001 		// im angedockten Zustand in einem SplitWindow, mu\s umgemeldet werden
//STRIP001 		// Wenn neu angedockt wird, machen PrepareToggleFloatingMode()
//STRIP001 		// und ToggleFloatingMode() das Ummelden.
//STRIP001 		if ( !bFloatMode )
//STRIP001 			bReArrange = TRUE;
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( bReArrange )
//STRIP001 	{
//STRIP001 		if ( GetAlignment() != pImp->GetDockAlignment() )
//STRIP001 		{
//STRIP001 			// Vor dem Show() mu\s das Ummelden passiert sein, daher kann nicht
//STRIP001 			// die Basisklasse gerufen werden
//STRIP001 			if ( IsFloatingMode() || !pImp->bSplitable )
//STRIP001 				Show( FALSE, SHOW_NOFOCUSCHANGE );
//STRIP001 
//STRIP001 			// Die Gr"o\se f"urs Toggeln setzen
//STRIP001             pImp->aSplitSize = rRect.GetSize();
//STRIP001 			if ( IsFloatingMode() )
//STRIP001 			{
//STRIP001 				SetFloatingMode( bFloatMode );
//STRIP001 				if ( IsFloatingMode() || !pImp->bSplitable )
//STRIP001                     Show( TRUE, SHOW_NOFOCUSCHANGE );
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				pImp->pSplitWin->RemoveWindow(this,FALSE);
//STRIP001 				pImp->nLine = pImp->nDockLine;
//STRIP001 				pImp->nPos = pImp->nDockPos;
//STRIP001 				pImp->pSplitWin->ReleaseWindow_Impl(this);
//STRIP001 				pImp->pSplitWin = pWorkWin->GetSplitWindow_Impl(pImp->GetDockAlignment());
//STRIP001                 pImp->pSplitWin->InsertWindow( this, pImp->aSplitSize, pImp->nDockLine, pImp->nDockPos, pImp->bNewLine );
//STRIP001 				if ( !pImp->pSplitWin->IsFadeIn() )
//STRIP001 					pImp->pSplitWin->FadeIn();
//STRIP001 			}
//STRIP001 		}
//STRIP001         else if ( pImp->nLine != pImp->nDockLine || pImp->nPos != pImp->nDockPos || pImp->bNewLine )
//STRIP001 		{
//STRIP001 			// Ich wurde innerhalb meines Splitwindows verschoben.
//STRIP001 			if ( pImp->nLine != pImp->nDockLine )
//STRIP001 				pImp->aSplitSize = rRect.GetSize();
//STRIP001             pImp->pSplitWin->MoveWindow( this, pImp->aSplitSize, pImp->nDockLine, pImp->nDockPos, pImp->bNewLine );
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		pImp->bEndDocked = TRUE;
//STRIP001 		DockingWindow::EndDocking(rRect, bFloatMode);
//STRIP001 		pImp->bEndDocked = FALSE;
//STRIP001 	}
//STRIP001 
//STRIP001 	SetAlignment( IsFloatingMode() ? SFX_ALIGN_NOALIGNMENT : pImp->GetDockAlignment() );
//STRIP001 	pWorkWin->ConfigChild_Impl( eIdent, SFX_ALIGNDOCKINGWINDOW, pMgr->GetType() );
/*?*/ }

//-------------------------------------------------------------------------

/*?*/ void SfxDockingWindow::Resizing( Size& rSize )

/*	[Beschreibung]

	Virtuelle Methode der Klasse DockingWindow.
	Hier kann das interaktive Umgr"o\sern im FloatingMode beeinflu\t werden,
	z.B. indem nur diskrete Werte f"ur Breite und/oder H"ohe zugelassen werden.
	Die Basisimplementation verhindert, da\s die OutputSize kleiner wird als
	eine mit SetMinOutputSizePixel() gesetzte Gr"o\se.
*/

/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 /*
//STRIP001 	if(rSize.Width()   < pImp->aMinSize.Width())
//STRIP001 		rSize.Width()  = pImp->aMinSize.Width();
//STRIP001 	if(rSize.Height()  < pImp->aMinSize.Height())
//STRIP001 		rSize.Height() = pImp->aMinSize.Height();
//STRIP001 */
/*?*/ }

//-------------------------------------------------------------------------

//STRIP001 SfxDockingWindow::SfxDockingWindow( SfxBindings *pBindinx, SfxChildWindow *pCW,
//STRIP001 	Window* pParent, WinBits nWinBits) :
//STRIP001 	pBindings(pBindinx),
//STRIP001 	pMgr(pCW),
//STRIP001 	DockingWindow (pParent, nWinBits)
//STRIP001 
//STRIP001 /*  [Beschreibung]
//STRIP001 
//STRIP001 	ctor der Klasse SfxDockingWindow. Es wird ein SfxChildWindow ben"otigt,
//STRIP001 	da das Andocken im Sfx "uber SfxChildWindows realisiert wird.
//STRIP001 */
//STRIP001 
//STRIP001 {
//STRIP001 	ULONG nId = GetHelpId();
//STRIP001 	if ( !nId && pCW )
//STRIP001 		nId = pCW->GetType();
//STRIP001 	SetHelpId( 0 );
//STRIP001 	SetUniqueId( nId );
//STRIP001 
//STRIP001 	pImp = new SfxDockingWindow_Impl;
//STRIP001 	pImp->bConstructed = FALSE;
//STRIP001 	pImp->pSplitWin = 0;
//STRIP001 	pImp->bEndDocked = FALSE;
//STRIP001 	pImp->bDockingPrevented = FALSE;
//STRIP001 
//STRIP001 	pImp->bSplitable = TRUE;
//STRIP001 //	pImp->bAutoHide = FALSE;
//STRIP001 
//STRIP001 	// Zun"achst auf Defaults setzen; das Alignment wird in der Subklasse gesetzt
//STRIP001 	pImp->nLine = pImp->nDockLine = 0;
//STRIP001 	pImp->nPos  = pImp->nDockPos = 0;
//STRIP001 	pImp->bNewLine = FALSE;
//STRIP001 	pImp->SetLastAlignment(SFX_ALIGN_NOALIGNMENT);
//STRIP001 
//STRIP001 //	DBG_ASSERT(pMgr,"DockingWindow erfordert ein SfxChildWindow!");
//STRIP001 }

//-------------------------------------------------------------------------

/*N*/ SfxDockingWindow::SfxDockingWindow( SfxBindings *pBindinx, SfxChildWindow *pCW,
/*N*/ 	Window* pParent, const ResId& rResId) :
/*N*/ 	pBindings(pBindinx),
/*N*/ 	pMgr(pCW),
/*N*/ 	DockingWindow(pParent, rResId)

/*  [Beschreibung]

	ctor der Klasse SfxDockingWindow. Es wird ein SfxChildWindow ben"otigt,
	da das Andocken im Sfx "uber SfxChildWindows realisiert wird.
*/

/*N*/ {
/*N*/ 	ULONG nId = GetHelpId();
/*N*/ 	SetHelpId(0);
/*N*/ 	SetUniqueId( nId );
/*N*/ 
/*N*/ 	pImp = new SfxDockingWindow_Impl;
/*N*/ 	pImp->bConstructed = FALSE;
/*N*/ 	pImp->pSplitWin = 0;
/*N*/ 	pImp->bEndDocked = FALSE;
/*N*/ 	pImp->bDockingPrevented = FALSE;
/*N*/ 
/*N*/ 	pImp->bSplitable = TRUE;
/*N*/ //	pImp->bAutoHide = FALSE;
/*N*/ 
/*N*/ 	// Zun"achst auf Defaults setzen; das Alignment wird in der Subklasse gesetzt
/*N*/ 	pImp->nLine = pImp->nDockLine = 0;
/*N*/ 	pImp->nPos  = pImp->nDockPos = 0;
/*N*/ 	pImp->bNewLine = FALSE;
/*N*/ 	pImp->SetLastAlignment(SFX_ALIGN_NOALIGNMENT);
/*N*/ 
/*N*/ //	DBG_ASSERT(pMgr,"DockingWindow erfordert ein SfxChildWindow!");
/*N*/ }

//-------------------------------------------------------------------------

/*N*/ void SfxDockingWindow::Initialize(SfxChildWinInfo *pInfo)
/*  [Beschreibung]

	Initialisierung der Klasse SfxDockingWindow "uber ein SfxChildWinInfo.
	Die Initialisierung erfolgt erst in einem 2.Schritt nach dem ctor und sollte
	vom ctor der abgeleiteten Klasse oder vom ctor des SfxChildWindows
	aufgerufen werden.
*/
/*N*/ {
/*N*/ 	if ( !pMgr )
/*N*/ 	{
/*N*/ 		// Bugfix #39771
/*?*/ 		pImp->SetDockAlignment( SFX_ALIGN_NOALIGNMENT );
/*?*/ 		pImp->bConstructed = TRUE;
/*?*/ 		return;
/*N*/ 	}
/*N*/ 
/*N*/ 	if ( pInfo->nFlags & SFX_CHILDWIN_FORCEDOCK )
/*N*/ 		pImp->bDockingPrevented = TRUE;
/*N*/ 
/*N*/     pImp->aSplitSize = GetOutputSizePixel();
/*N*/     if ( !GetFloatingSize().Width() )
/*N*/     {
/*N*/         Size aMinSize( GetMinOutputSizePixel() );
/*N*/         SetFloatingSize( pImp->aSplitSize );
/*N*/         if ( pImp->aSplitSize.Width() < aMinSize.Width() )
/*?*/             pImp->aSplitSize.Width() = aMinSize.Width();
/*N*/         if ( pImp->aSplitSize.Height() < aMinSize.Height() )
/*?*/             pImp->aSplitSize.Height() = aMinSize.Height();
/*N*/     }
/*N*/ 
/*N*/     if ( pInfo->aExtraString.Len() )
/*N*/     {
/*N*/         // get information about alignment, split size and position in SplitWindow
/*N*/         String aStr;
/*N*/         USHORT nPos = pInfo->aExtraString.SearchAscii("AL:");
/*N*/         if ( nPos != STRING_NOTFOUND )
/*N*/         {
/*N*/             // alignment information
/*N*/             USHORT n1 = pInfo->aExtraString.Search('(', nPos);
/*N*/             if ( n1 != STRING_NOTFOUND )
/*N*/             {
/*N*/                 USHORT n2 = pInfo->aExtraString.Search(')', n1);
/*N*/                 if ( n2 != STRING_NOTFOUND )
/*N*/                 {
/*N*/                     // extract alignment information from extrastring
/*N*/                     aStr = pInfo->aExtraString.Copy(nPos, n2 - nPos + 1);
/*N*/                     pInfo->aExtraString.Erase(nPos, n2 - nPos + 1);
/*N*/                     aStr.Erase(nPos, n1-nPos+1);
/*N*/                 }
/*N*/             }
/*N*/         }
/*N*/ 
/*N*/         if ( aStr.Len() )
/*N*/         {
/*N*/             // accept window state only if alignment is also set
/*N*/             pImp->aWinState = pInfo->aWinState;
/*N*/ 
/*N*/             // check for valid alignment
/*N*/ 			SfxChildAlignment eLocalAlignment = (SfxChildAlignment) (USHORT) aStr.ToInt32();
/*N*/ 			if ( pImp->bDockingPrevented )
/*N*/ 				// docking prevented, ignore old configuration and take alignment from default
/*N*/ 				aStr.Erase();
/*N*/ 			else
/*N*/             	SetAlignment( eLocalAlignment );
/*N*/ 
/*N*/             SfxChildAlignment eAlign = CheckAlignment(GetAlignment(),GetAlignment());
/*N*/             if ( eAlign != GetAlignment() )
/*N*/             {
/*?*/                 DBG_ERROR("Invalid Alignment!");
/*?*/                 SetAlignment( eAlign );
/*?*/                 aStr.Erase();
/*N*/             }
/*N*/ 
/*N*/             // get last alignment (for toggeling)
/*N*/             nPos = aStr.Search(',');
/*N*/             if ( nPos != STRING_NOTFOUND )
/*N*/             {
/*N*/                 aStr.Erase(0, nPos+1);
/*N*/                 pImp->SetLastAlignment( (SfxChildAlignment) (USHORT) aStr.ToInt32() );
/*N*/             }
/*N*/ 
/*N*/             nPos = aStr.Search(',');
/*N*/             if ( nPos != STRING_NOTFOUND )
/*N*/             {
/*N*/                 // get split size and position in SplitWindow
/*N*/                 Point aPos;
/*N*/                 aStr.Erase(0, nPos+1);
/*N*/                 if ( GetPosSizeFromString( aStr, aPos, pImp->aSplitSize ) )
/*N*/                 {
/*N*/                     pImp->nLine = pImp->nDockLine = (USHORT) aPos.X();
/*N*/                     pImp->nPos  = pImp->nDockPos  = (USHORT) aPos.Y();
/*N*/                 }
/*N*/             }
/*N*/         }
/*N*/         else
/*N*/             DBG_ERROR( "Information is missing!" );
/*N*/     }
/*N*/ 
/*N*/     pImp->nVerticalSize = pImp->aSplitSize.Height();
/*N*/     pImp->nHorizontalSize = pImp->aSplitSize.Width();
/*N*/ 
/*N*/ 	SfxWorkWindow *pWorkWin = pBindings->GetWorkWindow_Impl();
/*N*/ 	if ( GetAlignment() != SFX_ALIGN_NOALIGNMENT )
/*N*/ 	{
/*N*/         // check if SfxWorkWindow is able to allow docking at its border
/*N*/ 		if ( !pWorkWin->IsDockingAllowed() || ( GetFloatStyle() & WB_STANDALONE )
/*N*/ 			&& Application::IsInModalMode() )
/*N*/ 			SetAlignment( SFX_ALIGN_NOALIGNMENT );
/*N*/ 	}
/*N*/ 
/*N*/     // detect floating mode
/*N*/     // toggeling mode will not execute code in handlers, because pImp->bConstructed is not set yet
/*N*/ 	BOOL bFloatMode = IsFloatingMode();
/*N*/     if ( bFloatMode != ((GetAlignment() == SFX_ALIGN_NOALIGNMENT)) )
/*N*/     {
/*N*/         bFloatMode = !bFloatMode;
/*N*/         SetFloatingMode( bFloatMode );
/*N*/         if ( bFloatMode )
/*N*/         {
/*N*/             if ( pImp->aWinState.Len() )
/*N*/                 GetFloatingWindow()->SetWindowState( pImp->aWinState );
/*N*/             else
/*N*/                 GetFloatingWindow()->SetOutputSizePixel( GetFloatingSize() );
/*N*/         }
/*N*/     }
/*N*/ 
/*N*/     if ( IsFloatingMode() )
/*N*/ 	{
/*N*/         // validate last alignment
/*N*/         SfxChildAlignment eLastAlign = pImp->GetLastAlignment();
/*N*/ 		if ( eLastAlign == SFX_ALIGN_NOALIGNMENT)
/*N*/ 			eLastAlign = CheckAlignment(eLastAlign, SFX_ALIGN_LEFT);
/*N*/ 		if ( eLastAlign == SFX_ALIGN_NOALIGNMENT)
/*?*/ 			eLastAlign = CheckAlignment(eLastAlign, SFX_ALIGN_RIGHT);
/*N*/ 		if ( eLastAlign == SFX_ALIGN_NOALIGNMENT)
/*?*/ 			eLastAlign = CheckAlignment(eLastAlign, SFX_ALIGN_TOP);
/*N*/ 		if ( eLastAlign == SFX_ALIGN_NOALIGNMENT)
/*?*/ 			eLastAlign = CheckAlignment(eLastAlign, SFX_ALIGN_BOTTOM);
/*N*/ 		pImp->SetLastAlignment(eLastAlign);
/*N*/ 	}
/*N*/ 	else
/*N*/ 	{
/*N*/         // docked window must have NOALIGNMENT as last alignment
/*N*/ 		pImp->SetLastAlignment(SFX_ALIGN_NOALIGNMENT);
/*N*/ 
/*N*/         if ( pImp->bSplitable )
/*N*/ 		{
/*N*/ //			pImp->bAutoHide = ( pInfo->nFlags & SFX_CHILDWIN_AUTOHIDE) != 0;
/*N*/ 			pImp->pSplitWin = pWorkWin->GetSplitWindow_Impl(GetAlignment());
/*N*/ 			pImp->pSplitWin->InsertWindow(this, pImp->aSplitSize);
/*N*/ 		}
/*N*/ 		else
/*N*/ 		{
/*N*/             //?????? Currently not supported
/*N*/ 			// Fenster ist individuell angedockt; Gr"o\se berechnen.
/*N*/ 			// Dazu mu\s sie mit der FloatingSize initialisiert werden, falls
/*N*/ 			// irgendwer sich darauf verl"a\st, da\s eine vern"unftige Gr"o\se
/*N*/             // gesetzt ist
/*?*/ 			SetSizePixel(GetFloatingSize());
/*?*/ 			SetSizePixel(CalcDockingSize(GetAlignment()));
/*N*/ 		}
/*N*/ 	}
/*N*/ 
/*N*/     // save alignment
/*N*/     pImp->SetDockAlignment( GetAlignment() );
/*N*/ }

/*N*/ void SfxDockingWindow::Initialize_Impl()
/*N*/ {
/*N*/ 	if ( !pMgr )
/*N*/     {
/*N*/ 		// Bugfix #39771
/*?*/         pImp->bConstructed = TRUE;
/*?*/ 		return;
/*N*/     }
/*N*/ 
/*N*/     FloatingWindow* pFloatWin = GetFloatingWindow();
/*N*/     BOOL bSet = FALSE;
/*N*/     if ( pFloatWin )
/*N*/     {
/*N*/         bSet = !pFloatWin->IsDefaultPos();
/*N*/     }
/*N*/     else
/*N*/     {
/*?*/         Point aPos = GetFloatingPos();
/*?*/         if ( aPos != Point() )
/*?*/             bSet = TRUE;
/*N*/     }
/*N*/ 
/*N*/     if ( !bSet)
/*N*/ 	{
/*?*/ 		SfxViewFrame *pFrame = pBindings->GetDispatcher_Impl()->GetFrame();
/*?*/ 		Window* pEditWin = pFrame->GetViewShell()->GetWindow();
/*?*/         Point aPos = pEditWin->OutputToScreenPixel( pEditWin->GetPosPixel() );
/*?*/ 		aPos = GetParent()->ScreenToOutputPixel( aPos );
/*?*/ 		SetFloatingPos( aPos );
/*N*/ 	}
/*N*/ 
/*N*/     if ( pFloatWin )
/*N*/     {
/*N*/         // initialize floating window
/*N*/         if ( !pImp->aWinState.Len() )
/*N*/             // window state never set before, get if from defaults
/*N*/             pImp->aWinState = pFloatWin->GetWindowState();
/*N*/ 
/*N*/         // trick: use VCL method SetWindowState to adjust position and size
/*N*/         pFloatWin->SetWindowState( pImp->aWinState );
/*N*/ 
/*N*/         // remember floating size for calculating alignment and tracking rectangle
/*N*/         SetFloatingSize( pFloatWin->GetSizePixel() );
/*N*/ 
/*N*/         // some versions of VCL didn't call resize in the current situation
/*N*/ 		//Resize();
/*N*/     }
/*N*/ 
/*N*/     // allow calling of docking handlers
/*N*/ 	pImp->bConstructed = TRUE;
/*N*/ }

//-------------------------------------------------------------------------

/*N*/ void SfxDockingWindow::FillInfo(SfxChildWinInfo& rInfo) const

/*  [Beschreibung]

	F"ullt ein SfxChildWinInfo mit f"ur SfxDockingWindow spezifischen Daten,
	damit sie in die INI-Datei geschrieben werden koennen.
	Es wird angenommen, da\s rInfo alle anderen evt. relevanten Daten in
	der ChildWindow-Klasse erh"alt.
	Eingetragen werden hier gemerkten Gr"o\sen, das ZoomIn-Flag und die
	f"ur das Docking relevanten Informationen.
	Wird diese Methode "uberschrieben, mu\s zuerst die Basisimplementierung
	gerufen werden.
*/

/*N*/ {
/*N*/ 	if ( !pMgr )
/*N*/ 		return;
/*N*/ 
/*N*/     if ( GetFloatingWindow() && pImp->bConstructed )
/*N*/         pImp->aWinState = GetFloatingWindow()->GetWindowState();
/*N*/ 
/*N*/     rInfo.aWinState = pImp->aWinState;
/*N*/ 	rInfo.aExtraString += DEFINE_CONST_UNICODE("AL:(");
/*N*/     rInfo.aExtraString += String::CreateFromInt32((USHORT) GetAlignment());
/*N*/ 	rInfo.aExtraString += ',';
/*N*/     rInfo.aExtraString += String::CreateFromInt32 ((USHORT) pImp->GetLastAlignment());
/*N*/ 	if ( pImp->bSplitable )
/*N*/ 	{
/*N*/ 		Point aPos(pImp->nLine, pImp->nPos);
/*N*/ 		rInfo.aExtraString += ',';
/*N*/     	rInfo.aExtraString += String::CreateFromInt32( aPos.X() );
/*N*/ 		rInfo.aExtraString += '/';
/*N*/     	rInfo.aExtraString += String::CreateFromInt32( aPos.Y() );
/*N*/ 		rInfo.aExtraString += '/';
/*N*/         rInfo.aExtraString += String::CreateFromInt32( pImp->nHorizontalSize );
/*N*/ 		rInfo.aExtraString += '/';
/*N*/         rInfo.aExtraString += String::CreateFromInt32( pImp->nVerticalSize );
/*N*/ 	}
/*N*/ 
/*N*/ 	rInfo.aExtraString += ')';
/*N*/ }

//-------------------------------------------------------------------------

/*N*/ SfxDockingWindow::~SfxDockingWindow()
/*N*/ {
/*N*/     ReleaseChildWindow_Impl();
/*N*/ 	delete pImp;
/*N*/ }

/*N*/ void SfxDockingWindow::ReleaseChildWindow_Impl()
/*N*/ {
/*N*/     if ( pMgr && pMgr->GetFrame() == pBindings->GetActiveFrame() )
/*?*/         pBindings->SetActiveFrame( NULL );
/*N*/ 
/*N*/ 	if ( pMgr && pImp->pSplitWin && pImp->pSplitWin->IsItemValid( GetType() ) )
/*N*/ 		pImp->pSplitWin->RemoveWindow(this);
/*N*/ 
/*N*/     pMgr=NULL;
/*N*/ }

//-------------------------------------------------------------------------

//STRIP001 SfxChildAlignment SfxDockingWindow::CalcAlignment(const Point& rPos, Rectangle& rRect)
//STRIP001 
//STRIP001 /*  [Beschreibung]
//STRIP001 
//STRIP001 	Diese Methode berechnet f"ur gegebene Mausposition und tracking rectangle,
//STRIP001 	welches Alignment sich daraus ergeben w"urde. Beim Wechsel des Alignments
//STRIP001 	kann sich auch das tracking rectangle "andern, so dass ein ver"andertes
//STRIP001 	rectangle zur"uckgegeben wird.
//STRIP001 
//STRIP001 	Der Klassenbenutzer kann das Verhalten dieser Methode und damit das Verhalten
//STRIP001 	seiner DockinWindow-Klasse beim Docken beeinflussen, indem er die hier
//STRIP001 	aufgerufene virtuelle Methode
//STRIP001 
//STRIP001 		SfxDockingWindow::CalcDockingSize(SfxChildAlignment eAlign)
//STRIP001 
//STRIP001 	"uberschreibt (s.u.).
//STRIP001 */
//STRIP001 
//STRIP001 {
//STRIP001 	// calculate hypothetical sizes for different modes
//STRIP001 	Size aFloatingSize(CalcDockingSize(SFX_ALIGN_NOALIGNMENT));
//STRIP001 	Size aVerticalSize(CalcDockingSize(SFX_ALIGN_LEFT));
//STRIP001 	Size aHorizontalSize(CalcDockingSize(SFX_ALIGN_TOP));
//STRIP001 
//STRIP001 	// check if docking is permitted
//STRIP001 	SfxWorkWindow *pWorkWin = pBindings->GetWorkWindow_Impl();
//STRIP001 	if ( !pWorkWin->IsDockingAllowed() )
//STRIP001 	{
//STRIP001 		rRect.SetSize( aFloatingSize );
//STRIP001 		return pImp->GetDockAlignment();
//STRIP001 	}
//STRIP001 
//STRIP001 	// calculate borders to shrink inner area before checking for intersection with tracking rectangle
//STRIP001 	long nLRBorder, nTBBorder;
//STRIP001 	if ( pImp->bSplitable )
//STRIP001 	{
//STRIP001 		// take the smaller size of docked and floating mode
//STRIP001         Size aSize = pImp->aSplitSize;
//STRIP001 		if ( GetFloatingSize().Height() < aSize.Height() )
//STRIP001 			aSize.Height() = GetFloatingSize().Height();
//STRIP001 		if ( GetFloatingSize().Width() < aSize.Width() )
//STRIP001 			aSize.Width() = GetFloatingSize().Width();
//STRIP001 
//STRIP001 		nLRBorder = aSize.Width();
//STRIP001 		nTBBorder = aSize.Height();
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		nLRBorder = aVerticalSize.Width();
//STRIP001 		nTBBorder = aHorizontalSize.Height();
//STRIP001 	}
//STRIP001 
//STRIP001 	// limit border to predefined constant values
//STRIP001 	if ( nLRBorder > MAX_TOGGLEAREA_WIDTH )
//STRIP001 		nLRBorder = MAX_TOGGLEAREA_WIDTH;
//STRIP001 	if ( nTBBorder > MAX_TOGGLEAREA_WIDTH )
//STRIP001 		nTBBorder = MAX_TOGGLEAREA_WIDTH;
//STRIP001 
//STRIP001 	// shrink area for floating mode if possible
//STRIP001 	Rectangle aInRect = GetInnerRect();
//STRIP001 	if ( aInRect.GetWidth() > nLRBorder )
//STRIP001 		aInRect.Left()	 += nLRBorder/2;
//STRIP001 	if ( aInRect.GetWidth() > nLRBorder )
//STRIP001 		aInRect.Right()  -= nLRBorder/2;
//STRIP001 	if ( aInRect.GetHeight() > nTBBorder )
//STRIP001 		aInRect.Top()	 += nTBBorder/2;
//STRIP001 	if ( aInRect.GetHeight() > nTBBorder )
//STRIP001 		aInRect.Bottom() -= nTBBorder/2;
//STRIP001 
//STRIP001 	// calculate alignment resulting from docking rectangle
//STRIP001 	BOOL bBecomesFloating = FALSE;
//STRIP001 	SfxChildAlignment eDockAlign = pImp->GetDockAlignment();
//STRIP001 	Rectangle aDockingRect( rRect );
//STRIP001 	if ( !IsFloatingMode() )
//STRIP001 	{
//STRIP001 		// don't use tracking rectangle for alignment check, because it will be too large
//STRIP001 		// to get a floating mode as result - switch to floating size
//STRIP001 		// so the calculation only depends on the position of the rectangle, not the current
//STRIP001 		// docking state of the window
//STRIP001 		aDockingRect.SetSize( GetFloatingSize() );
//STRIP001 
//STRIP001 		// in this mode docking is never done by keyboard, so it's OK to use the mouse position
//STRIP001 		aDockingRect.SetPos( pWorkWin->GetWindow()->GetPointerPosPixel() );
//STRIP001 	}
//STRIP001 
//STRIP001 	Point aPos = aDockingRect.TopLeft();
//STRIP001 	Rectangle aIntersect = GetOuterRect().GetIntersection( aDockingRect );
//STRIP001     if ( aIntersect.IsEmpty() )
//STRIP001 		// docking rectangle completely outside docking area -> floating mode
//STRIP001 		bBecomesFloating = TRUE;
//STRIP001 	else
//STRIP001     {
//STRIP001         Rectangle aIntersect = aInRect.GetIntersection( aDockingRect );
//STRIP001         if ( aIntersect == aDockingRect )
//STRIP001 			// docking rectangle completely inside (shrinked) inner area -> floating mode
//STRIP001             bBecomesFloating = TRUE;
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( bBecomesFloating )
//STRIP001 	{
//STRIP001 		eDockAlign = CheckAlignment(pImp->GetDockAlignment(),SFX_ALIGN_NOALIGNMENT);
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		// docking rectangle is in the "sensible area"
//STRIP001         Point aInPosTL( aPos.X()-aInRect.Left(), aPos.Y()-aInRect.Top() );
//STRIP001         Point aInPosBR( aPos.X()-aInRect.Left() + aDockingRect.GetWidth(), aPos.Y()-aInRect.Top() + aDockingRect.GetHeight() );
//STRIP001 		Size  aInSize = aInRect.GetSize();
//STRIP001 		BOOL  bNoChange = FALSE;
//STRIP001 
//STRIP001 		// check if alignment is still unchanged
//STRIP001 		switch ( GetAlignment() )
//STRIP001 		{
//STRIP001 			case SFX_ALIGN_LEFT:
//STRIP001 			case SFX_ALIGN_FIRSTLEFT:
//STRIP001 			case SFX_ALIGN_LASTLEFT:
//STRIP001                 if (aInPosTL.X() <= 0)
//STRIP001 				{
//STRIP001 					eDockAlign = GetAlignment();
//STRIP001 					bNoChange = TRUE;
//STRIP001 				}
//STRIP001 				break;
//STRIP001 			case SFX_ALIGN_TOP:
//STRIP001 			case SFX_ALIGN_LOWESTTOP:
//STRIP001 			case SFX_ALIGN_HIGHESTTOP:
//STRIP001                 if ( aInPosTL.Y() <= 0)
//STRIP001 				{
//STRIP001 					eDockAlign = GetAlignment();
//STRIP001 					bNoChange = TRUE;
//STRIP001 				}
//STRIP001 				break;
//STRIP001 			case SFX_ALIGN_RIGHT:
//STRIP001 			case SFX_ALIGN_FIRSTRIGHT:
//STRIP001 			case SFX_ALIGN_LASTRIGHT:
//STRIP001                 if ( aInPosBR.X() >= aInSize.Width())
//STRIP001 				{
//STRIP001 					eDockAlign = GetAlignment();
//STRIP001 					bNoChange = TRUE;
//STRIP001 				}
//STRIP001 				break;
//STRIP001 			case SFX_ALIGN_BOTTOM:
//STRIP001 			case SFX_ALIGN_LOWESTBOTTOM:
//STRIP001 			case SFX_ALIGN_HIGHESTBOTTOM:
//STRIP001                 if ( aInPosBR.Y() >= aInSize.Height())
//STRIP001 				{
//STRIP001 					eDockAlign = GetAlignment();
//STRIP001 					bNoChange = TRUE;
//STRIP001 				}
//STRIP001 				break;
//STRIP001 			default:
//STRIP001 				break;
//STRIP001 		}
//STRIP001 
//STRIP001 		if ( !bNoChange )
//STRIP001 		{
//STRIP001 			// alignment will change, test alignment according to distance of the docking rectangles edges
//STRIP001 			BOOL bForbidden = TRUE;
//STRIP001             if ( aInPosTL.X() <= 0)
//STRIP001 			{
//STRIP001 				eDockAlign = CheckAlignment(pImp->GetDockAlignment(),SFX_ALIGN_LEFT);
//STRIP001 				bForbidden = ( eDockAlign != SFX_ALIGN_LEFT &&
//STRIP001 							   eDockAlign != SFX_ALIGN_FIRSTLEFT &&
//STRIP001 							   eDockAlign != SFX_ALIGN_LASTLEFT );
//STRIP001 			}
//STRIP001 
//STRIP001             if ( bForbidden && aInPosTL.Y() <= 0)
//STRIP001 			{
//STRIP001 				eDockAlign = CheckAlignment(pImp->GetDockAlignment(),SFX_ALIGN_TOP);
//STRIP001 				bForbidden = ( eDockAlign != SFX_ALIGN_TOP &&
//STRIP001 							   eDockAlign != SFX_ALIGN_HIGHESTTOP &&
//STRIP001 							   eDockAlign != SFX_ALIGN_LOWESTTOP );
//STRIP001 			}
//STRIP001 
//STRIP001             if ( bForbidden && aInPosBR.X() >= aInSize.Width())
//STRIP001 			{
//STRIP001 				eDockAlign = CheckAlignment(pImp->GetDockAlignment(),SFX_ALIGN_RIGHT);
//STRIP001 				bForbidden = ( eDockAlign != SFX_ALIGN_RIGHT &&
//STRIP001 							   eDockAlign != SFX_ALIGN_FIRSTRIGHT &&
//STRIP001 							   eDockAlign != SFX_ALIGN_LASTRIGHT );
//STRIP001 			}
//STRIP001 
//STRIP001             if ( bForbidden && aInPosBR.Y() >= aInSize.Height())
//STRIP001 			{
//STRIP001 				eDockAlign = CheckAlignment(pImp->GetDockAlignment(),SFX_ALIGN_BOTTOM);
//STRIP001 				bForbidden = ( eDockAlign != SFX_ALIGN_BOTTOM &&
//STRIP001 							   eDockAlign != SFX_ALIGN_HIGHESTBOTTOM &&
//STRIP001 							   eDockAlign != SFX_ALIGN_LOWESTBOTTOM );
//STRIP001 			}
//STRIP001 
//STRIP001 			// the calculated alignment was rejected by the window -> take floating mode
//STRIP001 			if ( bForbidden )
//STRIP001 				eDockAlign = CheckAlignment(pImp->GetDockAlignment(),SFX_ALIGN_NOALIGNMENT);
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( eDockAlign == SFX_ALIGN_NOALIGNMENT )
//STRIP001 	{
//STRIP001 		//Im FloatingMode erh"alt das tracking rectangle die floating size
//STRIP001 		// wg. SV-Bug darf rRect nur ver"andert werden, wenn sich das
//STRIP001 		// Alignment "andert !
//STRIP001 		if ( eDockAlign != pImp->GetDockAlignment() )
//STRIP001 			aDockingRect.SetSize( aFloatingSize );
//STRIP001 	}
//STRIP001 	else if ( pImp->bSplitable )
//STRIP001 	{
//STRIP001 		USHORT nLine, nPos;
//STRIP001 		SfxSplitWindow *pSplitWin = pWorkWin->GetSplitWindow_Impl(eDockAlign);
//STRIP001 		aPos = pSplitWin->ScreenToOutputPixel( aPos );
//STRIP001 		if ( pSplitWin->GetWindowPos( aPos, nLine, nPos ) )
//STRIP001 		{
//STRIP001 			// mouse over splitwindow, get line and position
//STRIP001 			pImp->nDockLine = nLine;
//STRIP001 			pImp->nDockPos = nPos;
//STRIP001 			pImp->bNewLine = FALSE;
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			if ( 0 )
//STRIP001 			{
//STRIP001 				// mouse touches outer border -> treated as floating mode
//STRIP001 				eDockAlign = SFX_ALIGN_NOALIGNMENT;
//STRIP001 				aDockingRect.SetSize( aFloatingSize );
//STRIP001 				rRect = aDockingRect;
//STRIP001 				return eDockAlign;
//STRIP001 			}
//STRIP001 
//STRIP001 			// mouse touches inner border -> create new line
//STRIP001 			if ( eDockAlign == GetAlignment() && pImp->pSplitWin &&
//STRIP001  				pImp->nLine == pImp->pSplitWin->GetLineCount()-1 && pImp->pSplitWin->GetWindowCount(pImp->nLine) == 1 )
//STRIP001 			{
//STRIP001 				// if this window is the only one in the last line, it can't be docked as new line in the same splitwindow
//STRIP001 				pImp->nDockLine = pImp->nLine;
//STRIP001 				pImp->nDockPos = pImp->nPos;
//STRIP001 				pImp->bNewLine = FALSE;
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				// create new line
//STRIP001 				pImp->nDockLine = pSplitWin->GetLineCount();
//STRIP001 				pImp->nDockPos = 0;
//STRIP001 				pImp->bNewLine = TRUE;
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		BOOL bChanged = pImp->nLine != pImp->nDockLine || pImp->nPos != pImp->nDockPos || eDockAlign != GetAlignment();
//STRIP001 		if ( !bChanged && !IsFloatingMode() )
//STRIP001 		{
//STRIP001 			// window only sightly moved, no change of any property
//STRIP001             rRect.SetSize( pImp->aSplitSize );
//STRIP001         	rRect.SetPos( aDockingRect.TopLeft() );
//STRIP001 			return eDockAlign;
//STRIP001 		}
//STRIP001 
//STRIP001 		// calculate new size and position
//STRIP001         Size aSize;
//STRIP001 		Point aPoint = aDockingRect.TopLeft();
//STRIP001 		Size aInnerSize = GetInnerRect().GetSize();
//STRIP001 		if ( eDockAlign == SFX_ALIGN_LEFT || eDockAlign == SFX_ALIGN_RIGHT )
//STRIP001 		{
//STRIP001 			if ( pImp->bNewLine )
//STRIP001 			{
//STRIP001 				// set height to height of free area
//STRIP001 				aSize.Height() = aInnerSize.Height();
//STRIP001                 aSize.Width() = pImp->nHorizontalSize;
//STRIP001 				if ( eDockAlign == SFX_ALIGN_LEFT )
//STRIP001 				{
//STRIP001             		aPoint = aInnerRect.TopLeft();
//STRIP001 				}
//STRIP001 				else
//STRIP001 				{
//STRIP001             		aPoint = aInnerRect.TopRight();
//STRIP001             		aPoint.X() -= aSize.Width();
//STRIP001 				}
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				// get width from splitwindow
//STRIP001 				aSize.Width() = pSplitWin->GetLineSize(nLine);
//STRIP001                 aSize.Height() = pImp->aSplitSize.Height();
//STRIP001 			}
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			if ( pImp->bNewLine )
//STRIP001 			{
//STRIP001 				// set width to width of free area
//STRIP001 				aSize.Width() = aInnerSize.Width();
//STRIP001                 aSize.Height() = pImp->nVerticalSize;
//STRIP001 				if ( eDockAlign == SFX_ALIGN_TOP )
//STRIP001 				{
//STRIP001             		aPoint = aInnerRect.TopLeft();
//STRIP001 				}
//STRIP001 				else
//STRIP001         		{
//STRIP001             		aPoint = aInnerRect.BottomLeft();
//STRIP001             		aPoint.Y() -= aSize.Height();
//STRIP001         		}
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				// get height from splitwindow
//STRIP001 				aSize.Height() = pSplitWin->GetLineSize(nLine);
//STRIP001                 aSize.Width() = pImp->aSplitSize.Width();
//STRIP001 			}
//STRIP001     	}
//STRIP001 
//STRIP001 		aDockingRect.SetSize( aSize );
//STRIP001 		aDockingRect.SetPos( aPoint );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		// window can be docked, but outside our splitwindows
//STRIP001 		// tracking rectangle only needs to be modified if alignment was changed
//STRIP001 		if ( eDockAlign != pImp->GetDockAlignment() )
//STRIP001 		{
//STRIP001 			switch ( eDockAlign )
//STRIP001 			{
//STRIP001 				case SFX_ALIGN_LEFT:
//STRIP001 				case SFX_ALIGN_RIGHT:
//STRIP001 				case SFX_ALIGN_FIRSTLEFT:
//STRIP001         		    aDockingRect.SetPos( aInnerRect.TopLeft() );
//STRIP001 					aDockingRect.SetSize( aVerticalSize );
//STRIP001 					break;
//STRIP001 				case SFX_ALIGN_LASTLEFT:
//STRIP001 				case SFX_ALIGN_FIRSTRIGHT:
//STRIP001 				case SFX_ALIGN_LASTRIGHT:
//STRIP001         		{
//STRIP001             		Point aPt( aInnerRect.TopRight() );
//STRIP001             		aPt.X() -= aDockingRect.GetWidth();
//STRIP001             		aDockingRect.SetPos( aPt );
//STRIP001 					aDockingRect.SetSize( aVerticalSize );
//STRIP001             		break;
//STRIP001         		}
//STRIP001 
//STRIP001 				case SFX_ALIGN_TOP:
//STRIP001 				case SFX_ALIGN_BOTTOM:
//STRIP001 				case SFX_ALIGN_LOWESTTOP:
//STRIP001             		aDockingRect.SetPos( aInnerRect.TopLeft() );
//STRIP001 					aDockingRect.SetSize( aHorizontalSize );
//STRIP001 					break;
//STRIP001 				case SFX_ALIGN_HIGHESTTOP:
//STRIP001 				case SFX_ALIGN_LOWESTBOTTOM:
//STRIP001 				case SFX_ALIGN_HIGHESTBOTTOM:
//STRIP001         		{
//STRIP001             		Point aPt( aInnerRect.BottomLeft() );
//STRIP001             		aPt.Y() -= aDockingRect.GetHeight();
//STRIP001             		aDockingRect.SetPos( aPt );
//STRIP001 					aDockingRect.SetSize( aHorizontalSize );
//STRIP001             		break;
//STRIP001         		}
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	rRect = aDockingRect;
//STRIP001     return eDockAlign;
//STRIP001 }

//-------------------------------------------------------------------------

/*N*/ Size SfxDockingWindow::CalcDockingSize(SfxChildAlignment eAlign)
/*N*/ 
/*	[Beschreibung]

	Virtuelle Methode der Klasse SfxDockingWindow.
	Hier wird festgelegt, wie sich die Gr"o\se des DockingWindows abh"angig vom
	Alignment "andert.
	Die Basisimplementation setzt im Floating Mode die Gr"o\se auf die gemerkte
	Floating Size.
	Bei horizontalem Alignment wird die Breite auf die Breite des "au\seren
	DockingRects, bei vertikalem Alignment die H"ohe auf die H"ohe des inneren
	DockingRects (ergibt sich aus der Reihenfolge, in der im SFX ChildWindows
	ausgegeben werden). Die jeweils andere Gr"o\se wird auf die aktuelle
	Floating Size gesetzt, hier k"onnte eine abgeleitete Klasse "andernd
	eingreifen.
	Die DockingSize mu\s f"ur Left/Right und Top/Bottom jeweils gleich sein.
*/

/*N*/ {
/*N*/ 	// Achtung: falls das Resizing auch im angedockten Zustand geht, mu\s dabei
/*N*/ 	// auch die Floating Size angepa\st werden !?
/*N*/ DBG_BF_ASSERT(0, "STRIP"); Size aSize; //STRIP001 
//STRIP001 	Size aSize = GetFloatingSize();
//STRIP001 	switch (eAlign)
//STRIP001 	{
//STRIP001 		case SFX_ALIGN_TOP:
//STRIP001 		case SFX_ALIGN_BOTTOM:
//STRIP001 		case SFX_ALIGN_LOWESTTOP:
//STRIP001 		case SFX_ALIGN_HIGHESTTOP:
//STRIP001 		case SFX_ALIGN_LOWESTBOTTOM:
//STRIP001 		case SFX_ALIGN_HIGHESTBOTTOM:
//STRIP001 			aSize.Width() = aOuterRect.Right() - aOuterRect.Left();
//STRIP001 			break;
//STRIP001 		case SFX_ALIGN_LEFT:
//STRIP001 		case SFX_ALIGN_RIGHT:
//STRIP001 		case SFX_ALIGN_FIRSTLEFT:
//STRIP001 		case SFX_ALIGN_LASTLEFT:
//STRIP001 		case SFX_ALIGN_FIRSTRIGHT:
//STRIP001 		case SFX_ALIGN_LASTRIGHT:
//STRIP001 			aSize.Height() = aInnerRect.Bottom() - aInnerRect.Top();
//STRIP001 			break;
//STRIP001 		case SFX_ALIGN_NOALIGNMENT:
//STRIP001 			break;
//STRIP001 	}
//STRIP001 
/*N*/ 	return aSize;
/*N*/ }

//-------------------------------------------------------------------------

/*N*/ SfxChildAlignment SfxDockingWindow::CheckAlignment(SfxChildAlignment,
/*N*/ 	SfxChildAlignment eAlign)
/*N*/ 
/*	[Beschreibung]

	Virtuelle Methode der Klasse SfxDockingWindow.
	Hier kann eine abgeleitete Klasse bestimmte Alignments verbieten.
	Die Basisimplementation verbietet kein Alignment.
*/

/*N*/ {
/*N*/ 	return eAlign;
/*N*/ }

//-------------------------------------------------------------------------

/*?*/ BOOL SfxDockingWindow::Close()

/*	[Beschreibung]

	Das Fenster wird geschlossen, indem das ChildWindow durch Ausf"uhren des
	ChildWindow-Slots zerst"ort wird.
	Wird diese Methode von einer abgeleiteten Klasse "uberschrieben, mu\s
	danach SfxDockingWindow::Close() gerufen werden, wenn nicht das Close()
	mit "return FALSE" abgebrochen wird.

*/
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); return FALSE;//STRIP001 
//STRIP001 	// Execute mit Parametern, da Toggle von einigen ChildWindows ignoriert
//STRIP001 	// werden kann
//STRIP001 	if ( !pMgr )
//STRIP001 		return TRUE;
//STRIP001 
//STRIP001 	SfxBoolItem aValue( pMgr->GetType(), FALSE);
//STRIP001 	pBindings->GetDispatcher_Impl()->Execute(
//STRIP001 		pMgr->GetType(), SFX_CALLMODE_RECORD | SFX_CALLMODE_ASYNCHRON, &aValue, 0L );
//STRIP001 	return TRUE;
/*?*/ }

//-------------------------------------------------------------------------

/*N*/ void SfxDockingWindow::Paint(const Rectangle& rRect)

/*	[Beschreibung]

	Es wird im angedockten Zustand eine Begrenzungslinie an der angedockten
	Kante und ein Rahmen ausgegeben. Dabei wird SVLOOK ber"ucksichtigt.
*/

/*N*/ {
/*N*/ 	if ( pImp->bSplitable || IsFloatingMode() )
/*N*/ 		return;
/*N*/ 
/*?*/ 	Rectangle aRect = Rectangle(Point(0, 0),
/*?*/ 								GetOutputSizePixel());
/*?*/ 	switch (GetAlignment())
/*?*/ 	{
/*?*/ 		case SFX_ALIGN_TOP:
/*?*/ 		{
/*?*/ 			DrawLine(aRect.BottomLeft(), aRect.BottomRight());
/*?*/ 			aRect.Bottom()--;
/*?*/ 			break;
/*?*/ 		}
/*?*/ 
/*?*/ 		case SFX_ALIGN_BOTTOM:
/*?*/ 		{
/*?*/ 			DrawLine(aRect.TopLeft(), aRect.TopRight());
/*?*/ 			aRect.Top()++;
/*?*/ 			break;
/*?*/ 		}
/*?*/ 
/*?*/ 		case SFX_ALIGN_LEFT:
/*?*/ 		{
/*?*/ 			DrawLine(aRect.TopRight(), aRect.BottomRight());
/*?*/ 			aRect.Right()--;
/*?*/ 			break;
/*?*/ 		}
/*?*/ 
/*?*/ 		case SFX_ALIGN_RIGHT:
/*?*/ 		{
/*?*/ 			DrawLine(aRect.TopLeft(), aRect.BottomLeft());
/*?*/ 			aRect.Left()++;
/*?*/ 			break;
/*?*/ 		}
/*?*/ 	}
/*N*/ 
/*N*/ 	DecorationView aView( this );
/*N*/ 	aView.DrawFrame( aRect, FRAME_DRAW_OUT );
/*N*/ }

//-------------------------------------------------------------------------

/*N*/ void SfxDockingWindow::SetMinOutputSizePixel( const Size& rSize )

/*	[Beschreibung]

	Mit dieser Methode kann eine minimale OutpuSize gesetzt werden, die
	im Resizing()-Handler abgefragt wird.
*/

/*N*/ {
/*N*/ 	pImp->aMinSize = rSize;
/*N*/     DockingWindow::SetMinOutputSizePixel( rSize );
/*N*/ }

//-------------------------------------------------------------------------

/*N*/ Size SfxDockingWindow::GetMinOutputSizePixel() const
/*N*/ 
/*	[Beschreibung]

	Die gesetzte minimale Gr"o\se wird zur"uckgegeben.
*/
/*N*/ 
/*N*/ {
/*N*/ 	return pImp->aMinSize;
/*N*/ }

//-------------------------------------------------------------------------

/*N*/ long SfxDockingWindow::Notify( NotifyEvent& rEvt )
/*N*/ {
/*N*/     if ( rEvt.GetType() == EVENT_GETFOCUS )
/*N*/ 	{
/*N*/ 		pBindings->SetActiveFrame( pMgr->GetFrame() );
/*N*/ 
/*N*/ 		if ( pImp->pSplitWin )
/*N*/ 			pImp->pSplitWin->SetActiveWindow_Impl( this );
/*N*/ 		else
/*?*/ 			{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 pMgr->Activate_Impl();
/*N*/ 
/*N*/         Window* pWindow = rEvt.GetWindow();
/*N*/         ULONG nHelpId  = 0;
/*N*/         while ( !nHelpId && pWindow )
/*N*/         {
/*N*/             nHelpId = pWindow->GetHelpId();
/*N*/             pWindow = pWindow->GetParent();
/*N*/         }
/*N*/ 
/*N*/         if ( nHelpId )
/*N*/             SfxHelp::OpenHelpAgent( pBindings->GetDispatcher_Impl()->GetFrame()->GetFrame(), nHelpId );
/*
		// Nur wg. PlugIn
		SfxViewFrame *pFrame = pBindings->GetDispatcher_Impl()->GetFrame();
		if ( pFrame )
			pFrame->MakeActive_Impl();
*/
/*N*/ 		// In VCL geht Notify zun"achst an das Fenster selbst,
/*N*/ 		// also base class rufen, sonst erf"ahrt der parent nichts
/*N*/         if ( rEvt.GetWindow() == this )
/*N*/ 			DockingWindow::Notify( rEvt );
/*N*/ 		return TRUE;
/*N*/ 	}
/*N*/ 	else if( rEvt.GetType() == EVENT_KEYINPUT )
/*N*/ 	{
/*N*/ 		// KeyInput zuerst f"ur Dialogfunktionen zulassen
/*?*/ 		if ( !DockingWindow::Notify( rEvt ) )
/*?*/ 			// dann auch global g"ultige Acceleratoren verwenden
/*?*/ 			{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 return SfxViewShell::Current()->GlobalKeyInput_Impl( *rEvt.GetKeyEvent() );
/*?*/ 		return TRUE;
/*N*/ 	}
/*N*/     else if ( rEvt.GetType() == EVENT_LOSEFOCUS && !HasChildPathFocus() )
/*N*/ 	{
/*N*/ //        pBindings->SetActiveFrame( XFrameRef() );
/*N*/         pMgr->Deactivate_Impl();
/*N*/ 	}
/*N*/ 
/*N*/ 	return DockingWindow::Notify( rEvt );
/*N*/ }


/*N*/ USHORT SfxDockingWindow::GetWinBits_Impl() const
/*N*/ {
/*N*/ 	USHORT nBits = 0;
/*N*/ //	if ( pImp->bAutoHide )
/*N*/ //		nBits |= SWIB_AUTOHIDE;
/*N*/ 	return nBits;
/*N*/ }

//-------------------------------------------------------------------------

//STRIP001 void SfxDockingWindow::SetItemSize_Impl( const Size& rSize )
//STRIP001 {
//STRIP001 	pImp->aSplitSize = rSize;
//STRIP001     SfxWorkWindow *pWorkWin = pBindings->GetWorkWindow_Impl();
//STRIP001     SfxChildIdentifier eIdent = SFX_CHILDWIN_DOCKINGWINDOW;
//STRIP001     if ( pImp->bSplitable )
//STRIP001         eIdent = SFX_CHILDWIN_SPLITWINDOW;
//STRIP001     pWorkWin->ConfigChild_Impl( eIdent, SFX_ALIGNDOCKINGWINDOW, pMgr->GetType() );
//STRIP001 }

//STRIP001 void SfxDockingWindow::Disappear_Impl()
//STRIP001 {
//STRIP001 	if ( pImp->pSplitWin && pImp->pSplitWin->IsItemValid( GetType() ) )
//STRIP001 		pImp->pSplitWin->RemoveWindow(this);
//STRIP001 }

/*N*/ void SfxDockingWindow::Reappear_Impl()
/*N*/ {
/*N*/ 	if ( pImp->pSplitWin && !pImp->pSplitWin->IsItemValid( GetType() ) )
/*N*/ 	{
/*?*/ 		pImp->pSplitWin->InsertWindow( this, pImp->aSplitSize );
/*N*/ 	}
/*N*/ }

//STRIP001 BOOL SfxDockingWindow::IsAutoHide_Impl() const
//STRIP001 {
//STRIP001 	if ( pImp->pSplitWin )
//STRIP001 		return !pImp->pSplitWin->IsFadeIn();
//STRIP001 	else
//STRIP001 		return FALSE;
//STRIP001 }

//STRIP001 BOOL SfxDockingWindow::IsPinned_Impl() const
//STRIP001 {
//STRIP001 	if ( pImp->pSplitWin )
//STRIP001 		return pImp->pSplitWin->IsPinned();
//STRIP001 	else
//STRIP001 		return TRUE;
//STRIP001 }

//STRIP001 void SfxDockingWindow::AutoShow_Impl( BOOL bShow )
//STRIP001 {
//STRIP001 	if ( pImp->pSplitWin )
//STRIP001 	{
//STRIP001 		if ( bShow )
//STRIP001 			pImp->pSplitWin->FadeIn();
//STRIP001 		else
//STRIP001 			pImp->pSplitWin->FadeOut();
//STRIP001 	}
//STRIP001 }

/*
void SfxDockingWindow::Pin_Impl( BOOL bPinned )
{
	if ( pImp->pSplitWin )
		pImp->pSplitWin->Pin_Impl( bPinned );
}
*/

//STRIP001 SfxSplitWindow* SfxDockingWindow::GetSplitWindow_Impl() const
//STRIP001 {
//STRIP001 	return pImp->pSplitWin;
//STRIP001 }

/*N*/ void SfxDockingWindow::FadeIn( BOOL bFadeIn )
/*N*/ {
/*N*/ }

/*N*/ void SfxDockingWindow::StateChanged( StateChangedType nStateChange )
/*N*/ {
/*N*/ 	if ( nStateChange == STATE_CHANGE_INITSHOW )
/*N*/ 		Initialize_Impl();
/*N*/ 
/*N*/ 	DockingWindow::StateChanged( nStateChange );
/*N*/ }

/*N*/ void SfxDockingWindow::Move()
/*N*/ {
/*N*/     if ( IsReallyVisible() && IsFloatingMode() )
/*N*/     {
/*N*/         SfxChildIdentifier eIdent = SFX_CHILDWIN_DOCKINGWINDOW;
/*N*/         if ( pImp->bSplitable )
/*N*/             eIdent = SFX_CHILDWIN_SPLITWINDOW;
/*N*/         SfxWorkWindow *pWorkWin = pBindings->GetWorkWindow_Impl();
/*N*/         pWorkWin->ConfigChild_Impl( eIdent, SFX_ALIGNDOCKINGWINDOW, pMgr->GetType() );
/*N*/     }
/*N*/ }

}
