/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sfx2_unoctitm.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 02:46:28 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// auto strip #include <tools/debug.hxx>

// auto strip #ifndef _SFXENUMITEM_HXX //autogen
// auto strip #include <svtools/eitem.hxx>
// auto strip #endif
// auto strip #ifndef _SFXSTRITEM_HXX //autogen
// auto strip #include <svtools/stritem.hxx>
// auto strip #endif
// auto strip #include <svtools/intitem.hxx>
// auto strip #include <svtools/itemset.hxx>

// auto strip #ifndef _COM_SUN_STAR_UTIL_XURLTRANSFORMER_HPP_
// auto strip #include <com/sun/star/util/XURLTransformer.hpp>
// auto strip #endif
// auto strip #ifndef _COM_SUN_STAR_FRAME_XCONTROLLER_HPP_
// auto strip #include <com/sun/star/frame/XController.hpp>
// auto strip #endif
// auto strip #ifndef _COM_SUN_STAR_FRAME_XFRAMEACTIONLISTENER_HPP_
// auto strip #include <com/sun/star/frame/XFrameActionListener.hpp>
// auto strip #endif
// auto strip #ifndef _COM_SUN_STAR_FRAME_XCOMPONENTLOADER_HPP_
// auto strip #include <com/sun/star/frame/XComponentLoader.hpp>
// auto strip #endif
// auto strip #ifndef _COM_SUN_STAR_FRAME_XFRAME_HPP_
// auto strip #include <com/sun/star/frame/XFrame.hpp>
// auto strip #endif
// auto strip #ifndef _COM_SUN_STAR_FRAME_FRAMEACTIONEVENT_HPP_
// auto strip #include <com/sun/star/frame/FrameActionEvent.hpp>
// auto strip #endif
// auto strip #ifndef _COM_SUN_STAR_FRAME_FRAMEACTION_HPP_
// auto strip #include <com/sun/star/frame/FrameAction.hpp>
// auto strip #endif
// auto strip #ifndef _COM_SUN_STAR_FRAME_DISPATCHRESULTSTATE_HPP_
// auto strip #include <com/sun/star/frame/DispatchResultState.hpp>
// auto strip #endif

// auto strip #include <comphelper/processfactory.hxx>
// auto strip #include <vos/mutex.hxx>

#ifndef _COM_SUN_STAR_LANG_XTYPEPROVIDER_HPP_
#include <com/sun/star/lang/XTypeProvider.hpp>
#endif

#include "unoctitm.hxx"
// auto strip #include "viewfrm.hxx"
#include "frame.hxx"
// auto strip #include "ctrlitem.hxx"
// auto strip #include "sfxuno.hxx"
// auto strip #include "bindings.hxx"
#include "dispatch.hxx"
#include "sfxsids.hrc"
// auto strip #include "request.hxx"

// auto strip #ifndef _LEGACYBINFILTERMGR_HXX
// auto strip #include <legacysmgr/legacy_binfilters_smgr.hxx>	//STRIP002 
// auto strip #endif

#ifndef _CPPUHELPER_TYPEPROVIDER_HXX_
#include <cppuhelper/typeprovider.hxx>
#endif

namespace binfilter {

using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::util;
//long nOfficeDispatchCount = 0;

/*?*/ SFX_IMPL_XINTERFACE_2( SfxUnoControllerItem, OWeakObject, ::com::sun::star::frame::XStatusListener, ::com::sun::star::lang::XEventListener )
/*?*/ SFX_IMPL_XTYPEPROVIDER_2( SfxUnoControllerItem, ::com::sun::star::frame::XStatusListener, ::com::sun::star::lang::XEventListener )

/*?*/ SfxUnoControllerItem::SfxUnoControllerItem( SfxControllerItem *pItem, SfxBindings& rBind, const String& rCmd )
/*?*/ 	: pCtrlItem( pItem )
/*?*/     , pBindings( &rBind )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 	DBG_ASSERT( !pCtrlItem || !pCtrlItem->IsBound(), "ControllerItem fehlerhaft!" );
//STRIP001 
//STRIP001 	aCommand.Complete = rCmd;
//STRIP001     Reference < XURLTransformer > xTrans( ::legacy_binfilters::getLegacyProcessServiceFactory()->createInstance( ::rtl::OUString::createFromAscii("com.sun.star.util.URLTransformer" )), UNO_QUERY );
//STRIP001     xTrans->parseStrict( aCommand );
//STRIP001 	pBindings->RegisterUnoController_Impl( this );
/*?*/ }

/*?*/ SfxUnoControllerItem::~SfxUnoControllerItem()
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 	// tell bindings to forget this controller ( if still connected )
//STRIP001 	if ( pBindings )
//STRIP001 		pBindings->ReleaseUnoController_Impl( this );
/*?*/ }

/*?*/ void SfxUnoControllerItem::UnBind()
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 	// connection to SfxControllerItem is lost
//STRIP001 	pCtrlItem = NULL;
//STRIP001 	::com::sun::star::uno::Reference< ::com::sun::star::frame::XStatusListener >  aRef( (::cppu::OWeakObject*)this, ::com::sun::star::uno::UNO_QUERY );
//STRIP001 	ReleaseDispatch();
/*?*/ }

/*?*/ void SAL_CALL SfxUnoControllerItem::statusChanged(const ::com::sun::star::frame::FeatureStateEvent& rEvent) throw ( ::com::sun::star::uno::RuntimeException )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001     ::vos::OGuard aGuard( Application::GetSolarMutex() );
//STRIP001 	DBG_ASSERT( pCtrlItem, "Dispatch hat den StatusListener nicht entfern!" );
//STRIP001 
//STRIP001 	if ( rEvent.Requery )
//STRIP001 	{
//STRIP001 		// Fehler kann nur passieren, wenn das alte Dispatch fehlerhaft implementiert
//STRIP001 		// ist, also removeStatusListener nicht gefunzt hat. Aber sowas soll
//STRIP001 		// ja vorkommen ...
//STRIP001 		// Also besser vor ReleaseDispatch gegen Abflug sch"utzen!
//STRIP001 		::com::sun::star::uno::Reference< ::com::sun::star::frame::XStatusListener >  aRef( (::cppu::OWeakObject*)this, ::com::sun::star::uno::UNO_QUERY  );
//STRIP001 		ReleaseDispatch();
//STRIP001 		if ( pCtrlItem )
//STRIP001 			GetNewDispatch(); 		// asynchron ??
//STRIP001 	}
//STRIP001 	else if ( pCtrlItem )
//STRIP001 	{
//STRIP001 		SfxItemState eState = SFX_ITEM_DISABLED;
//STRIP001 		SfxPoolItem* pItem = NULL;
//STRIP001 		if ( rEvent.IsEnabled )
//STRIP001 		{
//STRIP001 			eState = SFX_ITEM_AVAILABLE;
//STRIP001 			::com::sun::star::uno::Type pType =	rEvent.State.getValueType();
//STRIP001 
//STRIP001 			if ( pType == ::getBooleanCppuType() )
//STRIP001 			{
//STRIP001 				sal_Bool bTemp ;
//STRIP001 				rEvent.State >>= bTemp ;
//STRIP001 				pItem = new SfxBoolItem( pCtrlItem->GetId(), bTemp );
//STRIP001 			}
//STRIP001 			else if ( pType == ::getCppuType((const sal_uInt16*)0) )
//STRIP001 			{
//STRIP001 				sal_uInt16 nTemp ;
//STRIP001 				rEvent.State >>= nTemp ;
//STRIP001 				pItem = new SfxUInt16Item( pCtrlItem->GetId(), nTemp );
//STRIP001 			}
//STRIP001 			else if ( pType == ::getCppuType((const sal_uInt32*)0) )
//STRIP001 			{
//STRIP001 				sal_uInt32 nTemp ;
//STRIP001 				rEvent.State >>= nTemp ;
//STRIP001 				pItem = new SfxUInt32Item( pCtrlItem->GetId(), nTemp );
//STRIP001 			}
//STRIP001 			else if ( pType == ::getCppuType((const ::rtl::OUString*)0) )
//STRIP001 			{
//STRIP001 				::rtl::OUString sTemp ;
//STRIP001 				rEvent.State >>= sTemp ;
//STRIP001 				pItem = new SfxStringItem( pCtrlItem->GetId(), sTemp );
//STRIP001 			}
//STRIP001 			else
//STRIP001 				pItem = new SfxVoidItem( pCtrlItem->GetId() );
//STRIP001 		}
//STRIP001 
//STRIP001 		pCtrlItem->StateChanged( pCtrlItem->GetId(), eState, pItem );
//STRIP001 		delete pItem;
//STRIP001 	}
/*?*/ }

/*?*/ void  SAL_CALL SfxUnoControllerItem::disposing( const ::com::sun::star::lang::EventObject& rEvent ) throw ( ::com::sun::star::uno::RuntimeException )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 	::com::sun::star::uno::Reference< ::com::sun::star::frame::XStatusListener >  aRef( (::cppu::OWeakObject*)this, ::com::sun::star::uno::UNO_QUERY );
//STRIP001 	ReleaseDispatch();
/*?*/ }

/*?*/ void SfxUnoControllerItem::ReleaseDispatch()
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 	if ( xDispatch.is() )
//STRIP001 	{
//STRIP001 		xDispatch->removeStatusListener( (::com::sun::star::frame::XStatusListener*) this, aCommand );
//STRIP001 		xDispatch = ::com::sun::star::uno::Reference< ::com::sun::star::frame::XDispatch > ();
//STRIP001 	}
/*?*/ }

/*?*/ void SfxUnoControllerItem::GetNewDispatch()
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 	if ( !pBindings )
//STRIP001 	{
//STRIP001 		// Bindings released
//STRIP001 		DBG_ERROR( "Tried to get dispatch, but no Bindings!" );
//STRIP001 		return;
//STRIP001 	}
//STRIP001 
//STRIP001 	// forget old dispatch
//STRIP001 	xDispatch = ::com::sun::star::uno::Reference< ::com::sun::star::frame::XDispatch > ();
//STRIP001 
//STRIP001 	// no arms, no cookies !
//STRIP001 	if ( !pBindings->GetDispatcher_Impl() || !pBindings->GetDispatcher_Impl()->GetFrame() )
//STRIP001 		return;
//STRIP001 
//STRIP001 	SfxFrame *pFrame = pBindings->GetDispatcher_Impl()->GetFrame()->GetFrame();
//STRIP001 	SfxFrame *pParent = pFrame->GetParentFrame();
//STRIP001 	if ( pParent )
//STRIP001 		// parent may intercept
//STRIP001 		xDispatch = TryGetDispatch( pParent );
//STRIP001 
//STRIP001 	if ( !xDispatch.is() )
//STRIP001 	{
//STRIP001 		// no interception
//STRIP001 		::com::sun::star::uno::Reference< ::com::sun::star::frame::XFrame >  xFrame = pFrame->GetFrameInterface();
//STRIP001 		::com::sun::star::uno::Reference< ::com::sun::star::frame::XDispatchProvider >  xProv( xFrame, ::com::sun::star::uno::UNO_QUERY );
//STRIP001 		if ( xProv.is() )
//STRIP001 			xDispatch = xProv->queryDispatch( aCommand, ::rtl::OUString(), 0 );
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( xDispatch.is() )
//STRIP001 		xDispatch->addStatusListener( (::com::sun::star::frame::XStatusListener*) this, aCommand );
//STRIP001 	else if ( pCtrlItem )
//STRIP001 		pCtrlItem->StateChanged( pCtrlItem->GetId(), SFX_ITEM_DISABLED, NULL );
/*?*/ }

/*?*/ ::com::sun::star::uno::Reference< ::com::sun::star::frame::XDispatch >  SfxUnoControllerItem::TryGetDispatch( SfxFrame *pFrame )
/*?*/ {
/*?*/ 	::com::sun::star::uno::Reference< ::com::sun::star::frame::XDispatch >  xDisp;
/*?*/ 	SfxFrame *pParent = pFrame->GetParentFrame();
/*?*/ 	if ( pParent )
/*?*/ 		// parent may intercept
/*?*/ 		xDisp = TryGetDispatch( pParent );
/*?*/ 
/*?*/ 	// only components may intercept
/*?*/ 	if ( !xDisp.is() && pFrame->HasComponent() )
/*?*/ 	{
/*?*/ 		// no interception
/*?*/ 		::com::sun::star::uno::Reference< ::com::sun::star::frame::XFrame >  xFrame = pFrame->GetFrameInterface();
/*?*/ 		::com::sun::star::uno::Reference< ::com::sun::star::frame::XDispatchProvider >  xProv( xFrame, ::com::sun::star::uno::UNO_QUERY );
/*?*/ 		if ( xProv.is() )
/*?*/ 			xDisp = xProv->queryDispatch( aCommand, ::rtl::OUString(), 0 );
/*?*/ 	}
/*?*/ 
/*?*/ 	return xDisp;
/*?*/ }

/*?*/ void SfxUnoControllerItem::Execute()
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 	// dispatch the resource
//STRIP001     ::com::sun::star::uno::Sequence< ::com::sun::star::beans::PropertyValue > aSeq(1);
//STRIP001     aSeq[0].Name = ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM("Referer") );
//STRIP001     aSeq[0].Value <<= ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM("private:select") );
//STRIP001 	if ( xDispatch.is() )
//STRIP001         xDispatch->dispatch( aCommand, aSeq );
/*?*/ }

/*?*/ void SfxUnoControllerItem::ReleaseBindings()
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 	// connection to binding is lost; so forget the binding and the dispatch
//STRIP001 	::com::sun::star::uno::Reference< ::com::sun::star::frame::XStatusListener >  aRef( (::cppu::OWeakObject*)this, ::com::sun::star::uno::UNO_QUERY );
//STRIP001 	ReleaseDispatch();
//STRIP001 	if ( pBindings )
//STRIP001 		pBindings->ReleaseUnoController_Impl( this );
//STRIP001 	pBindings = NULL;
/*?*/ }

/*N*/ void SfxStatusDispatcher::ReleaseAll()
/*N*/ {
/*N*/ 	::com::sun::star::lang::EventObject aObject;
/*N*/ 	aObject.Source = (::cppu::OWeakObject*) this;
/*N*/ 	aListeners.disposeAndClear( aObject );
/*N*/ }

/*N*/ void SAL_CALL SfxStatusDispatcher::dispatch( const ::com::sun::star::util::URL&, const ::com::sun::star::uno::Sequence< ::com::sun::star::beans::PropertyValue >& ) throw ( ::com::sun::star::uno::RuntimeException )
/*N*/ {
/*N*/ }

/*N*/ void SAL_CALL SfxStatusDispatcher::dispatchWithNotification( const ::com::sun::star::util::URL& aURL,
/*N*/         const ::com::sun::star::uno::Sequence< ::com::sun::star::beans::PropertyValue >& aArgs,
/*N*/         const ::com::sun::star::uno::Reference< ::com::sun::star::frame::XDispatchResultListener >& rListener ) throw( ::com::sun::star::uno::RuntimeException )
/*N*/ {
/*N*/ }

/*N*/ SFX_IMPL_XINTERFACE_1( SfxStatusDispatcher, OWeakObject, ::com::sun::star::frame::XNotifyingDispatch )
/*N*/ SFX_IMPL_XTYPEPROVIDER_1( SfxStatusDispatcher, ::com::sun::star::frame::XNotifyingDispatch )
//IMPLNAME "com.sun.star.comp.sfx2.StatusDispatcher",

/*N*/ SfxStatusDispatcher::SfxStatusDispatcher()
/*N*/ 	: aListeners( aMutex )
/*N*/ {
/*N*/ }

/*?*/ void SAL_CALL SfxStatusDispatcher::addStatusListener(const ::com::sun::star::uno::Reference< ::com::sun::star::frame::XStatusListener > & aListener, const ::com::sun::star::util::URL& aURL) throw ( ::com::sun::star::uno::RuntimeException )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 	aListeners.addInterface( aURL.Complete, aListener );
//STRIP001 	if ( aURL.Complete.compareToAscii(".uno:LifeTime")==0 )
//STRIP001 	{
//STRIP001 		::com::sun::star::frame::FeatureStateEvent aEvent;
//STRIP001 		aEvent.FeatureURL = aURL;
//STRIP001 		aEvent.Source = (::com::sun::star::frame::XDispatch*) this;
//STRIP001 		aEvent.IsEnabled = sal_True;
//STRIP001 		aEvent.Requery = sal_False;
//STRIP001 		aListener->statusChanged( aEvent );
//STRIP001 	}
/*?*/ }

/*?*/ void SAL_CALL SfxStatusDispatcher::removeStatusListener( const ::com::sun::star::uno::Reference< ::com::sun::star::frame::XStatusListener > & aListener, const ::com::sun::star::util::URL& aURL ) throw ( ::com::sun::star::uno::RuntimeException )
/*?*/ {
DBG_BF_ASSERT(0, "STRIP"); //STRIP001 	aListeners.removeInterface( aURL.Complete, aListener );
/*?*/ }

/*N*/ SFX_IMPL_XINTERFACE_1( SfxOfficeDispatch, SfxStatusDispatcher, ::com::sun::star::lang::XUnoTunnel )
/*N*/ SFX_IMPL_XTYPEPROVIDER_2( SfxOfficeDispatch, ::com::sun::star::frame::XNotifyingDispatch, ::com::sun::star::lang::XUnoTunnel )


//-------------------------------------------------------------------------
// XUnoTunnel
/*N*/ sal_Int64 SAL_CALL SfxOfficeDispatch::getSomething( const ::com::sun::star::uno::Sequence< sal_Int8 >& aIdentifier ) throw(::com::sun::star::uno::RuntimeException)
/*N*/ {
/*N*/ 	if ( aIdentifier == impl_getStaticIdentifier() )
/*N*/         return (sal_Int64)this;
/*N*/ 	else
/*N*/ 		return 0;
/*N*/ }

/* ASDBG
void* SfxOfficeDispatch::getImplementation(Reflection *p)
{
	if( p == ::getCppuType((const SfxOfficeDispatch*)0) )
		return this;
	else
		return ::cppu::OWeakObject::getImplementation(p);

}

Reflection* ::getCppuType((const SfxOfficeDispatch*)0)
{
	static StandardClassReflection aRefl(
		0,
		createStandardClass(
			"SfxOfficeDispatch", ::cppu::OWeakObject::get::cppu::OWeakObjectIdlClass(),
			1,
			::getCppuType((const ::com::sun::star::frame::XDispatch*)0) ) );
	return &aRefl;
}
*/

/*N*/ SfxOfficeDispatch::SfxOfficeDispatch( SfxBindings& rBindings, SfxDispatcher* pDispat, sal_uInt16 nSlotId, const ::com::sun::star::util::URL& rURL, sal_Bool bInter )
/*N*/     : bIntercept( bInter )
/*N*/ {
/*N*/ //    nOfficeDispatchCount++;
/*N*/ 
/*N*/     // this object is an adapter that shows a ::com::sun::star::frame::XDispatch-Interface to the outside and uses a SfxControllerItem to monitor a state
/*N*/     pControllerItem = new SfxDispatchController_Impl( this, &rBindings, pDispat, nSlotId, rURL, bInter );
/*N*/ }

/*N*/ SfxOfficeDispatch::SfxOfficeDispatch( SfxDispatcher* pDispat, sal_uInt16 nSlotId, const ::com::sun::star::util::URL& rURL, sal_Bool bInter )
/*N*/     : bIntercept( bInter )
/*N*/ {
//    nOfficeDispatchCount++;

    // this object is an adapter that shows a ::com::sun::star::frame::XDispatch-Interface to the outside and uses a SfxControllerItem to monitor a state
/*N*/     pControllerItem = new SfxDispatchController_Impl( this, NULL, pDispat, nSlotId, rURL, bInter );
/*N*/ }

/*N*/ SfxOfficeDispatch::~SfxOfficeDispatch()
/*N*/ {
//    --nOfficeDispatchCount;

/*N*/     if ( pControllerItem )
/*N*/     {
/*N*/         // when dispatch object is released, destroy its connection to this object and destroy it
/*N*/         pControllerItem->UnBindController();
/*N*/         delete pControllerItem;
/*N*/     }
/*N*/ }

#if defined(MACOSX) && (__GNUC__ < 3)
    //MACOSX moved outside of class above
    // {38 57 CA 80 09 36 11 d4 83 FE 00 50 04 52 6B 21}
/*N*/     static sal_uInt8 pGUID[16] = { 0x38, 0x57, 0xCA, 0x80, 0x09, 0x36, 0x11, 0xd4, 0x83, 0xFE, 0x00, 0x50, 0x04, 0x52, 0x6B, 0x21 };
/*N*/     static ::com::sun::star::uno::Sequence< sal_Int8 > seqID((sal_Int8*)pGUID,16) ;
/*N*/ #endif

/*N*/ const ::com::sun::star::uno::Sequence< sal_Int8 >& SfxOfficeDispatch::impl_getStaticIdentifier()
/*N*/ {
#if !(defined(MACOSX) && (__GNUC__ < 3))
    //MACOSX moved outside of class above
    // {38 57 CA 80 09 36 11 d4 83 FE 00 50 04 52 6B 21}
/*N*/     static sal_uInt8 pGUID[16] = { 0x38, 0x57, 0xCA, 0x80, 0x09, 0x36, 0x11, 0xd4, 0x83, 0xFE, 0x00, 0x50, 0x04, 0x52, 0x6B, 0x21 };
/*N*/     static ::com::sun::star::uno::Sequence< sal_Int8 > seqID((sal_Int8*)pGUID,16) ;
/*N*/ #endif
/*N*/     return seqID ;
/*N*/ }


/*?*/ void SAL_CALL SfxOfficeDispatch::dispatch( const ::com::sun::star::util::URL& aURL, const ::com::sun::star::uno::Sequence< ::com::sun::star::beans::PropertyValue >& aArgs ) throw ( ::com::sun::star::uno::RuntimeException )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001     // ControllerItem is the Impl class
//STRIP001     if ( pControllerItem )
//STRIP001         pControllerItem->dispatch( aURL, aArgs, ::com::sun::star::uno::Reference < ::com::sun::star::frame::XDispatchResultListener >() );
/*?*/ }

/*?*/ void SAL_CALL SfxOfficeDispatch::dispatchWithNotification( const ::com::sun::star::util::URL& aURL,
/*?*/         const ::com::sun::star::uno::Sequence< ::com::sun::star::beans::PropertyValue >& aArgs,
/*?*/         const ::com::sun::star::uno::Reference< ::com::sun::star::frame::XDispatchResultListener >& rListener ) throw( ::com::sun::star::uno::RuntimeException )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001     // ControllerItem is the Impl class
//STRIP001     if ( pControllerItem )
//STRIP001         pControllerItem->dispatch( aURL, aArgs, rListener );
/*?*/ }

/*?*/ void SAL_CALL SfxOfficeDispatch::addStatusListener(const ::com::sun::star::uno::Reference< ::com::sun::star::frame::XStatusListener > & aListener, const ::com::sun::star::util::URL& aURL) throw ( ::com::sun::star::uno::RuntimeException )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001     GetListeners().addInterface( aURL.Complete, aListener );
//STRIP001     if ( pControllerItem )
//STRIP001     {
//STRIP001         // ControllerItem is the Impl class
//STRIP001         pControllerItem->addStatusListener( aListener, aURL );
//STRIP001     }
/*?*/ }

/*N*/ SfxDispatcher* SfxOfficeDispatch::GetDispatcher_Impl()
/*N*/ {
/*N*/     return pControllerItem->GetDispatcher();
/*N*/ }

/*N*/ SfxDispatchController_Impl::SfxDispatchController_Impl( SfxOfficeDispatch* pDisp, SfxBindings* pBind, SfxDispatcher* pDispat, sal_uInt16 nSlotId, const ::com::sun::star::util::URL& rURL, sal_Bool bInter )
/*N*/     : pDispatch( pDisp )
/*N*/ 	, aDispatchURL( rURL )
/*N*/     , pBindings( pBind )
/*N*/     , pDispatcher( pDispat )
/*N*/ 	, pLastState( 0 )
/*N*/     , nSlot( nSlotId )
/*N*/ {
/*N*/     SetId( nSlot );
/*N*/ }

/*N*/ SfxDispatchController_Impl::~SfxDispatchController_Impl()
/*N*/ {
/*N*/ 	if ( pLastState && !IsInvalidItem( pLastState ) )
/*?*/ 		delete pLastState;
/*N*/ 
/*N*/     if ( pDispatch )
/*N*/     {
/*?*/         // disconnect
/*?*/         pDispatch->pControllerItem = NULL;
/*?*/ 
/*?*/         // force all listeners to release the dispatch object
/*?*/         ::com::sun::star::lang::EventObject aObject;
/*?*/         aObject.Source = (::cppu::OWeakObject*) pDispatch;
/*?*/         pDispatch->GetListeners().disposeAndClear( aObject );
/*N*/     }
/*N*/ }

/*N*/ void SfxDispatchController_Impl::UnBindController()
/*N*/ {
/*N*/     pDispatch = NULL;
/*N*/     if ( IsBound() )
/*N*/     {
/*?*/         GetBindings().ENTERREGISTRATIONS();
/*?*/         SfxControllerItem::UnBind();
/*?*/         GetBindings().LEAVEREGISTRATIONS();
/*N*/     }
/*N*/ }

/*?*/ void SAL_CALL SfxDispatchController_Impl::dispatch( const ::com::sun::star::util::URL& aURL,
/*?*/         const ::com::sun::star::uno::Sequence< ::com::sun::star::beans::PropertyValue >& aArgs,
/*?*/         const ::com::sun::star::uno::Reference< ::com::sun::star::frame::XDispatchResultListener >& rListener ) throw( ::com::sun::star::uno::RuntimeException )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001     ::vos::OGuard aGuard( Application::GetSolarMutex() );
//STRIP001     if ( pDispatch && aURL == aDispatchURL )
//STRIP001 	{
//STRIP001         if ( !IsBound() && pBindings )
//STRIP001         {
//STRIP001             pBindings->ENTERREGISTRATIONS();
//STRIP001             Bind( nSlot, pBindings );
//STRIP001             pBindings->LEAVEREGISTRATIONS();
//STRIP001         }
//STRIP001 
//STRIP001         if ( !pDispatcher && pBindings )
//STRIP001             pDispatcher = GetBindings().GetDispatcher_Impl();
//STRIP001 
//STRIP001         // Try to find call mode and frame name inside given arguments...
//STRIP001         SfxCallMode nCall = SFX_CALLMODE_SYNCHRON;
//STRIP001         sal_Int32   nMarkArg = -1;
//STRIP001 
//STRIP001         ::com::sun::star::uno::Sequence< ::com::sun::star::beans::PropertyValue > lNewArgs( aArgs );
//STRIP001         sal_Int32 nCount = lNewArgs.getLength();
//STRIP001         sal_Bool bTemp;
//STRIP001         for( sal_Int32 n=0; n<nCount; n++ )
//STRIP001         {
//STRIP001             const ::com::sun::star::beans::PropertyValue& rProp = lNewArgs[n];
//STRIP001             if( rProp.Name.compareToAscii("SynchronMode")== 0 )
//STRIP001             {
//STRIP001 				if( rProp.Value >>=bTemp )
//STRIP001                 	nCall = bTemp ? SFX_CALLMODE_SYNCHRON : SFX_CALLMODE_ASYNCHRON;
//STRIP001             }
//STRIP001             else if( rProp.Name.compareToAscii("Bookmark")== 0 )
//STRIP001                 nMarkArg = n;
//STRIP001         }
//STRIP001 
//STRIP001         // Overwrite possible detected sychron argument, if real listener exist!
//STRIP001         if ( rListener.is() )
//STRIP001             nCall = SFX_CALLMODE_SYNCHRON;
//STRIP001 
//STRIP001         if( GetId() == SID_JUMPTOMARK && nMarkArg == - 1 )
//STRIP001         {
//STRIP001 			// we offer dispatches for SID_JUMPTOMARK if the URL points to a bookmark inside the document
//STRIP001 			// so we must retrieve this as an argument from the parsed URL
//STRIP001             lNewArgs.realloc( lNewArgs.getLength()+1 );
//STRIP001             nMarkArg = lNewArgs.getLength()-1;
//STRIP001 	        lNewArgs[nMarkArg].Name = ::rtl::OUString(RTL_CONSTASCII_USTRINGPARAM("Bookmark"));
//STRIP001 	        lNewArgs[nMarkArg].Value <<= aURL.Mark;
//STRIP001         }
//STRIP001 
//STRIP001         sal_Bool bSuccess = sal_False;
//STRIP001         sal_Bool bFailure = sal_False;
//STRIP001         const SfxPoolItem* pItem = NULL;
//STRIP001         if ( pDispatcher->GetBindings() )
//STRIP001         {
//STRIP001             if ( !pDispatcher->IsLocked( GetId() ) )
//STRIP001             {
//STRIP001                 SfxShell *pShell = 0;
//STRIP001                 const SfxSlot *pSlot = 0;
//STRIP001                 if ( pDispatcher->GetShellAndSlot_Impl( GetId(), &pShell, &pSlot, sal_False,
//STRIP001                         SFX_CALLMODE_MODAL==(nCall&SFX_CALLMODE_MODAL), FALSE ) )
//STRIP001                 {
//STRIP001                     SfxAllItemSet aSet( pShell->GetPool() );
//STRIP001                     TransformParameters( GetId(), lNewArgs, aSet, pSlot );
//STRIP001                     if ( aSet.Count() )
//STRIP001                     {
//STRIP001                         // execute with arguments - call directly
//STRIP001                         pItem = pDispatcher->Execute( GetId(), nCall, aSet );
//STRIP001                         bSuccess = (pItem != NULL);
//STRIP001                     }
//STRIP001                     else
//STRIP001                     {
//STRIP001                         // execute using bindings, enables support for toggle/enum etc.
//STRIP001                         SfxRequest aReq( GetId(), nCall, pShell->GetPool() );
//STRIP001                         pDispatcher->GetBindings()->Execute_Impl( aReq, pSlot, pShell );
//STRIP001                         pItem = aReq.GetReturnValue();
//STRIP001                         bSuccess = aReq.IsDone() || pItem != NULL;
//STRIP001                         bFailure = aReq.IsCancelled();
//STRIP001                     }
//STRIP001                 }
//STRIP001 #ifdef DBG_UTIL
//STRIP001                 else
//STRIP001                     DBG_WARNING("MacroPlayer: Unknown slot dispatched!");
//STRIP001 #endif
//STRIP001             }
//STRIP001         }
//STRIP001         else
//STRIP001         {
//STRIP001             // AppDispatcher
//STRIP001             SfxAllItemSet aSet( SFX_APP()->GetPool() );
//STRIP001             TransformParameters( GetId(), lNewArgs, aSet );
//STRIP001             if ( aSet.Count() )
//STRIP001                 pItem = pDispatcher->Execute( GetId(), nCall, aSet );
//STRIP001             else
//STRIP001                 // SfxRequests take empty sets as argument sets, GetArgs() returning non-zero!
//STRIP001                 pItem = pDispatcher->Execute( GetId(), nCall );
//STRIP001 
//STRIP001             // no bindings, no invalidate ( usually done in SfxDispatcher::Call_Impl()! )
//STRIP001             SfxDispatcher* pAppDispat = SFX_APP()->GetAppDispatcher_Impl();
//STRIP001             if ( pAppDispat )
//STRIP001             {
//STRIP001                 const SfxPoolItem* pState=0;
//STRIP001                 SfxItemState eState = pDispatcher->QueryState( GetId(), pState );
//STRIP001                 StateChanged( GetId(), eState, pState );
//STRIP001             }
//STRIP001 
//STRIP001             bSuccess = (pItem != NULL);
//STRIP001         }
//STRIP001 
//STRIP001         if ( rListener.is() )
//STRIP001         {
//STRIP001             ::com::sun::star::frame::DispatchResultEvent aEvent;
//STRIP001             if ( bSuccess )
//STRIP001                 aEvent.State = ::com::sun::star::frame::DispatchResultState::SUCCESS;
//STRIP001 //            else if ( bFailure )
//STRIP001             else
//STRIP001                 aEvent.State = ::com::sun::star::frame::DispatchResultState::FAILURE;
//STRIP001 //            else
//STRIP001 //                aEvent.State = ::com::sun::star::frame::DispatchResultState::DONTKNOW;
//STRIP001 
//STRIP001             aEvent.Source = (::com::sun::star::frame::XDispatch*) pDispatch;
//STRIP001             if ( bSuccess && pItem && !pItem->ISA(SfxVoidItem) )
//STRIP001                 pItem->QueryValue( aEvent.Result );
//STRIP001 
//STRIP001             rListener->dispatchFinished( aEvent );
//STRIP001         }
//STRIP001 	}
/*?*/ }

/*N*/ SfxDispatcher* SfxDispatchController_Impl::GetDispatcher()
/*N*/ {
/*N*/     if ( !pDispatcher && pBindings )
/*?*/         pDispatcher = GetBindings().GetDispatcher_Impl();
/*N*/     return pDispatcher;
/*N*/ }

/*?*/ void SAL_CALL SfxDispatchController_Impl::addStatusListener(const ::com::sun::star::uno::Reference< ::com::sun::star::frame::XStatusListener > & aListener, const ::com::sun::star::util::URL& aURL) throw ( ::com::sun::star::uno::RuntimeException )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001     ::vos::OGuard aGuard( Application::GetSolarMutex() );
//STRIP001     if ( !pDispatch )
//STRIP001         return;
//STRIP001 
//STRIP001     if ( !IsBound() && pBindings )
//STRIP001     {
//STRIP001         pBindings->ENTERREGISTRATIONS();
//STRIP001         Bind( nSlot, pBindings );
//STRIP001         pBindings->LEAVEREGISTRATIONS();
//STRIP001     }
//STRIP001 
//STRIP001     const SfxPoolItem *pItem = 0;
//STRIP001     if ( !pDispatcher && pBindings )
//STRIP001         pDispatcher = GetBindings().GetDispatcher_Impl();
//STRIP001     SfxItemState eState = pDispatcher->QueryState( GetId(), pItem );
//STRIP001 	::com::sun::star::uno::Any aState;
//STRIP001 	if ( pItem && !pItem->ISA(SfxVoidItem) )
//STRIP001 		pItem->QueryValue( aState );
//STRIP001 
//STRIP001 	::com::sun::star::frame::FeatureStateEvent aEvent;
//STRIP001 	aEvent.FeatureURL = aURL;
//STRIP001     aEvent.Source = (::com::sun::star::frame::XDispatch*) pDispatch;
//STRIP001 	aEvent.IsEnabled = eState != SFX_ITEM_DISABLED;
//STRIP001 	aEvent.Requery = sal_False;
//STRIP001 	aEvent.State = aState;
//STRIP001 
//STRIP001 	aListener->statusChanged( aEvent );
/*?*/ }

/*?*/ void SfxDispatchController_Impl::StateChanged( sal_uInt16 nSID, SfxItemState eState, const SfxPoolItem* pState )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001     if ( !pDispatch )
//STRIP001         return;
//STRIP001 
//STRIP001     if ( pDispatch->IsInterceptDispatch() )
//STRIP001     {
//STRIP001         // If this Controller is made for an interception, the state can't be set from outside
//STRIP001         // because this would be the state of the interceptor itself!
//STRIP001         if ( !pDispatcher && pBindings )
//STRIP001             pDispatcher = GetBindings().GetDispatcher_Impl();
//STRIP001         eState = pDispatcher->QueryState( GetId(), pState );
//STRIP001     }
//STRIP001 
//STRIP001     // Bindings instance notifies controller about a state change, listeners must be notified also
//STRIP001 	sal_Bool bNotify = sal_True;
//STRIP001 	sal_Bool bBothAvailable = pLastState && pState && !IsInvalidItem(pLastState) && !IsInvalidItem(pState);
//STRIP001 	if ( bBothAvailable )
//STRIP001 		bNotify = pState->Type() != pLastState->Type() || *pState != *pLastState;
//STRIP001 	else
//STRIP001 		bNotify = ( pLastState != pState );
//STRIP001 	if ( pLastState && !IsInvalidItem( pLastState ) )
//STRIP001 		delete pLastState;
//STRIP001 	pLastState = ( pState && !IsInvalidItem(pState) ) ? pState->Clone() : pState;
//STRIP001 
//STRIP001     ::cppu::OInterfaceContainerHelper* pContnr = pDispatch->GetListeners().getContainer ( aDispatchURL.Complete );
//STRIP001 	if ( bNotify && pContnr )
//STRIP001 	{
//STRIP001 		::com::sun::star::uno::Any aState;
//STRIP001         if ( ( eState >= SFX_ITEM_AVAILABLE ) && pState && !pState->ISA(SfxVoidItem) )
//STRIP001 			pState->QueryValue( aState );
//STRIP001 
//STRIP001 		::com::sun::star::frame::FeatureStateEvent aEvent;
//STRIP001 		aEvent.FeatureURL = aDispatchURL;
//STRIP001         aEvent.Source = (::com::sun::star::frame::XDispatch*) pDispatch;
//STRIP001 		aEvent.IsEnabled = eState != SFX_ITEM_DISABLED;
//STRIP001 		aEvent.Requery = sal_False;
//STRIP001 		aEvent.State = aState;
//STRIP001 
//STRIP001 		::cppu::OInterfaceIteratorHelper aIt( *pContnr );
//STRIP001 		while( aIt.hasMoreElements() )
//STRIP001         {
//STRIP001             try
//STRIP001             {
//STRIP001                 ((::com::sun::star::frame::XStatusListener *)aIt.next())->statusChanged( aEvent );
//STRIP001             }
//STRIP001             catch( ::com::sun::star::uno::RuntimeException& )
//STRIP001             {
//STRIP001                 aIt.remove();
//STRIP001             }
//STRIP001         }
//STRIP001 	}
/*?*/ }


}
