/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sd_slidvish.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 01:46:14 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#include <string> // HACK: prevent conflict between STLPORT and Workshop headers

// auto strip #ifndef _SFXDISPATCH_HXX //autogen
// auto strip #include <bf_sfx2/dispatch.hxx>
// auto strip #endif
#ifndef _ZOOMITEM_HXX
#include <bf_svx/zoomitem.hxx>
#endif
// auto strip #ifndef _SFXREQUEST_HXX //autogen
// auto strip #include <bf_sfx2/request.hxx>
// auto strip #endif
// auto strip #ifndef _SFX_WHITER_HXX //autogen
// auto strip #include <svtools/whiter.hxx>
// auto strip #endif
// auto strip #ifndef _SFXITEMPOOL_HXX //autogen
// auto strip #include <svtools/itempool.hxx>
// auto strip #endif
// auto strip #ifndef _AEITEM_HXX //autogen
// auto strip #include <svtools/aeitem.hxx>
// auto strip #endif
// auto strip #ifndef _SV_SCRBAR_HXX //autogen
// auto strip #include <vcl/scrbar.hxx>
// auto strip #endif
// auto strip #ifndef _TL_POLY_HXX
// auto strip #include <tools/poly.hxx>
// auto strip #endif
// auto strip #ifndef _SVDPAGV_HXX //autogen
// auto strip #include <bf_svx/svdpagv.hxx>
// auto strip #endif
// auto strip #ifndef _SV_MSGBOX_HXX //autogen
// auto strip #include <vcl/msgbox.hxx>
// auto strip #endif
// auto strip #ifndef _SD_OPTSITEM_HXX
// auto strip #include "optsitem.hxx"
// auto strip #endif
// auto strip #ifndef _SFXINTITEM_HXX
// auto strip #include <svtools/intitem.hxx>
// auto strip #endif
// auto strip #ifndef _SFX_TOPFRM_HXX //autogen wg. SfxTopViewFrame
// auto strip #include <bf_sfx2/topfrm.hxx>
// auto strip #endif

#include "app.hrc"
#include "strings.hrc"
#include "glob.hrc"
#include "res_bmp.hrc"

// auto strip #include "drawdoc.hxx"
#include "docshell.hxx"
#include "slidvish.hxx"
// auto strip #include "presvish.hxx"
// auto strip #include "slidview.hxx"
// auto strip #include "sdwindow.hxx"
// auto strip #include "fupoor.hxx"
// auto strip #include "fuzoom.hxx"
// auto strip #include "fuscale.hxx"
// auto strip #include "fuslsel.hxx"
// auto strip #include "fuslshow.hxx"
// auto strip #include "fuslprms.hxx"
// auto strip #include "fuslhide.hxx"
// auto strip #include "fusldlg.hxx"
// auto strip #include "sdpage.hxx"
// auto strip #include "pres.hxx"
// auto strip #include "frmview.hxx"
#include "sdresid.hxx"
// auto strip #include "sdattr.hxx"
#include "diactrl.hxx"
// auto strip #include "zoomlist.hxx"
#include "prevchld.hxx"
//STRIP001 #include "preview.hxx"
#include "slidchld.hxx"
// auto strip #include "fuexpand.hxx"
// auto strip #include "fusumry.hxx"
// auto strip #include "fucushow.hxx"
// auto strip #include "sdxfer.hxx"
// auto strip #include "AccessibleSlideView.hxx"
// auto strip #include "SdUnoSlideView.hxx"

// auto strip #ifndef _COM_SUN_STAR_ACCESSIBILITY_ACCESSIBLEEVENTID_HPP_
// auto strip #include <com/sun/star/accessibility/AccessibleEventId.hpp>
// auto strip #endif

using namespace ::com::sun::star;

// MBA: never declare "using namespace" for css and drafts::css in one file!
// always use subnamespace or directly declare the single types
using namespace ::com::sun::star::accessibility;

//==================================================================
namespace binfilter {

SFX_DECL_TYPE(13);

#define SdSlideViewShell
#include "sdslots.hxx"

#define MIN_ZOOM	       10       // Minimaler Zoomfaktor
#define MAX_ZOOM	       68	    // Maximaler Zoomfaktor


/*N*/ SFX_IMPL_INTERFACE(SdSlideViewShell, SfxViewShell, SdResId(STR_SLIDEVIEWSHELL))
/*N*/ {
/*N*/     SFX_OBJECTBAR_REGISTRATION( SFX_OBJECTBAR_APPLICATION | SFX_VISIBILITY_DESKTOP | SFX_VISIBILITY_STANDARD | SFX_VISIBILITY_CLIENT | SFX_VISIBILITY_VIEWER | SFX_VISIBILITY_READONLYDOC,
/*N*/             					SdResId(RID_DRAW_VIEWER_TOOLBOX) );
/*N*/ 	SFX_OBJECTBAR_REGISTRATION( SFX_OBJECTBAR_TOOLS | SFX_VISIBILITY_STANDARD |
/*N*/ 								SFX_VISIBILITY_FULLSCREEN | SFX_VISIBILITY_SERVER,
/*N*/ 								SdResId(RID_SLIDE_TOOLBOX) );
/*N*/ 	SFX_OBJECTBAR_REGISTRATION( SFX_OBJECTBAR_OBJECT, SdResId(RID_SLIDE_OBJ_TOOLBOX) );
/*N*/ 	SFX_CHILDWINDOW_REGISTRATION( SdSlideChangeChildWindow::GetChildWindowId() );
/*N*/ 	SFX_CHILDWINDOW_REGISTRATION( SdPreviewChildWindow::GetChildWindowId() );
/*N*/ }

/*N*/ SFX_IMPL_VIEWFACTORY(SdSlideViewShell, SdResId(STR_SPECIALVIEW))
/*N*/ {
/*N*/ 	SFX_VIEW_REGISTRATION(SdDrawDocShell);
/*N*/ }

TYPEINIT1( SdSlideViewShell, SdViewShell );

// --------------------
// - SdSlideViewShell -
// --------------------

//STRIP001 void SdSlideViewShell::Construct(SdDrawDocument* pDoc)
//STRIP001 {
//STRIP001     nCurFocusPage = SDRPAGE_NOTFOUND;
//STRIP001 	pSlideView = new SdSlideView(pDoc, pWindow, this);
//STRIP001 	pView = pSlideView; 		  // Pointer der Basisklasse SdViewShell
//STRIP001 
//STRIP001 	pWindow->SetMinZoom( MIN_ZOOM );
//STRIP001 	pWindow->SetMaxZoom( MAX_ZOOM );
//STRIP001 
//STRIP001 	ReadFrameViewData(pFrameView);
//STRIP001 
//STRIP001 	SetPool( &pDoc->GetPool() );
//STRIP001 
//STRIP001 	SetUndoManager( pDoc->GetDocSh()->GetUndoManager() );
//STRIP001 
//STRIP001 	SetZoom(100);
//STRIP001 
//STRIP001 	// create uno view
//STRIP001 	pController = new SdUnoSlideView(pView, this);
//STRIP001 
//STRIP001 	uno::Reference< awt::XWindow > aTmpRef;
//STRIP001 	GetViewFrame()->GetFrame()->GetFrameInterface()->setComponent( aTmpRef, pController );
//STRIP001 
//STRIP001 	USHORT nNoOfPages	= pDoc->GetSdPageCount(PK_STANDARD);
//STRIP001 	USHORT nPagesPerRow = pSlideView->GetPagesPerRow();
//STRIP001 	Size   aPageSize	= pSlideView->GetPageArea(0).GetSize();
//STRIP001 	ULONG  nGapX		= pSlideView->GetPageGap();
//STRIP001 	ULONG  nGapY		= nGapX;
//STRIP001 
//STRIP001 	Size aViewSize(nPagesPerRow * aPageSize.Width() +
//STRIP001 				   (nPagesPerRow + 1) * nGapX,
//STRIP001 				   pSlideView->CalcPagePos(nNoOfPages-1).Y() +
//STRIP001 				   aPageSize.Height() + nGapY);
//STRIP001 	Point aWinPos (0, 0);
//STRIP001 	Point aViewOrigin(0, 0);
//STRIP001 
//STRIP001 	aSlideBtn.Check(TRUE);
//STRIP001 
//STRIP001 	InitWindows(aViewOrigin, aViewSize, aWinPos);
//STRIP001 
//STRIP001 	String aName( RTL_CONSTASCII_USTRINGPARAM( "SlideViewShell" ));
//STRIP001 	SetName (aName);
//STRIP001 
//STRIP001 	SetHelpId( SD_IF_SDSLIDEVIEWSHELL );
//STRIP001 	pWindow->SetHelpId( SD_IF_SDSLIDEVIEWSHELL );
//STRIP001 	pWindow->SetUniqueId( SD_IF_SDSLIDEVIEWSHELL );
//STRIP001 }

// -----------------------------------------------------------------------------

//STRIP001 SdSlideViewShell::SdSlideViewShell(SfxViewFrame* pFrame, SfxViewShell* pOldShell)
//STRIP001   : SdViewShell(pFrame, &pFrame->GetWindow()   /*, FALSE */),
//STRIP001 	bSetInitialZoomFactor(TRUE),
//STRIP001 	bInitializeWinPos(TRUE),
//STRIP001 	pController(NULL)
//STRIP001 {
//STRIP001 	if (pOldShell)
//STRIP001 	{
//STRIP001 		pFrameView = ( (SdViewShell*) pOldShell)->GetFrameView();
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		pFrameView = new FrameView(pDoc);
//STRIP001 	}
//STRIP001 
//STRIP001 	pFrameView->Connect();
//STRIP001 
//STRIP001 	Construct(pDoc);
//STRIP001 
//STRIP001 	// Selektionsfunktion starten
//STRIP001 	SfxRequest aReq(SID_OBJECT_SELECT, 0, pDoc->GetItemPool());
//STRIP001 	FuPermanent(aReq);
//STRIP001 }

// -----------------------------------------------------------------------------

//STRIP001 SdSlideViewShell::SdSlideViewShell(SfxViewFrame* pFrame,
//STRIP001 								   const SdSlideViewShell& rShell)
//STRIP001    : SdViewShell(pFrame, rShell),
//STRIP001 	 bInitializeWinPos(TRUE),
//STRIP001 	 pController(NULL)
//STRIP001 {
//STRIP001 	pFrameView = new FrameView(pDoc);
//STRIP001 	pFrameView->Connect();
//STRIP001 
//STRIP001 	Construct(pDoc);
//STRIP001 }

// -----------------------------------------------------------------------------

//STRIP001 SdSlideViewShell::~SdSlideViewShell()
//STRIP001 {
//STRIP001 	if (pFuActual)
//STRIP001 	{
//STRIP001 		if (pFuOld == pFuActual)
//STRIP001 			pFuOld = NULL;
//STRIP001 
//STRIP001 		pFuActual->Deactivate();
//STRIP001 		delete pFuActual;
//STRIP001 		pFuActual = NULL;
//STRIP001 	}
//STRIP001 
//STRIP001 	if (pFuOld)
//STRIP001 	{
//STRIP001 		delete pFuOld;
//STRIP001 		pFuOld = NULL;
//STRIP001 	}
//STRIP001 
//STRIP001 	SdPage* pTestPage	   = NULL;
//STRIP001 	USHORT	nNoOfPages	   = pDoc->GetSdPageCount(PK_STANDARD);
//STRIP001 	BOOL	bSelectedFound = FALSE;
//STRIP001 
//STRIP001 	for (USHORT nPage = 0; nPage < nNoOfPages; nPage++)
//STRIP001 	{
//STRIP001 		pTestPage = pDoc->GetSdPage(nPage, PK_STANDARD);
//STRIP001 		if (pTestPage->IsSelected())
//STRIP001 		{
//STRIP001 			if (bSelectedFound)
//STRIP001 				pDoc->SetSelected(pTestPage, FALSE);
//STRIP001 			else
//STRIP001 				bSelectedFound = TRUE;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	if (!bSelectedFound && nNoOfPages > 0)
//STRIP001 	{
//STRIP001 		pDoc->SetSelected( (SdPage*)pDoc->GetSdPage(0, PK_STANDARD), TRUE);
//STRIP001 	}
//STRIP001 
//STRIP001 	delete pSlideView;
//STRIP001 
//STRIP001 	pFrameView->Disconnect();
//STRIP001 }

// -----------------------------------------------------------------------------

//STRIP001 Size SdSlideViewShell::GetOptimalSizePixel() const
//STRIP001 {
//STRIP001 	// erstmal das "optimale" SdWindow berechnen
//STRIP001 	USHORT nNoOfPages	= pDoc->GetSdPageCount(PK_STANDARD);
//STRIP001 	USHORT nPagesPerRow = Min(nNoOfPages, pSlideView->GetPagesPerRow());
//STRIP001 	USHORT nRows		= nNoOfPages / nPagesPerRow;
//STRIP001 	if (nNoOfPages % nPagesPerRow)
//STRIP001 		nRows++;
//STRIP001 	Size   aPageSize	= pDoc->GetSdPage(0, PK_STANDARD)->GetSize();
//STRIP001 	long   nGap 		= pSlideView->GetPageGap();
//STRIP001 	long   nWidth		= nPagesPerRow * aPageSize.Width() +
//STRIP001 						   (nPagesPerRow + 1) * nGap;
//STRIP001 	long   nHeight		= aPageSize.Height();
//STRIP001 
//STRIP001 	// angestrebtes Hoehen-Seiten-Verhaeltnis ist 3 zu 4
//STRIP001 	USHORT nVisibleRows = 1;
//STRIP001 	while (nVisibleRows < nRows && (4 * nHeight < 3 * nWidth))
//STRIP001 	{
//STRIP001 		nVisibleRows++;
//STRIP001 		nHeight += aPageSize.Height() + nGap;
//STRIP001 	}
//STRIP001 
//STRIP001 	Size aResult(nWidth, nHeight);
//STRIP001 	aResult = pWindow->LogicToPixel(aResult);
//STRIP001 
//STRIP001 	// und jetzt jetzt das Standardgelumpe draufaddieren
//STRIP001 	aResult.Width()  += pVScrlArray[0]->GetSizePixel().Width();
//STRIP001 	aResult.Height() += pHScrlArray[0]->GetSizePixel().Height();
//STRIP001 
//STRIP001 	return aResult;
//STRIP001 }

// -----------------------------------------------------------------------------

//STRIP001 void SdSlideViewShell::Paint(const Rectangle& rRect, SdWindow* pWin)
//STRIP001 {
//STRIP001 	pSlideView->Paint(rRect, pWin);
//STRIP001 
//STRIP001 	if ( pDocSh->GetActualFunction() )
//STRIP001 	{
//STRIP001 		pDocSh->GetActualFunction()->Paint(rRect, pWin);
//STRIP001 	}
//STRIP001 
//STRIP001 	if (pFuActual)
//STRIP001 	{
//STRIP001 		pFuActual->Paint(rRect, pWin);
//STRIP001 	}
//STRIP001 }


/** This call is simply delegated to the base class.
*/
//STRIP001 void SdSlideViewShell::AdjustPosSizePixel(const Point &rNewPos,
//STRIP001 										  const Size &rNewSize)
//STRIP001 {
//STRIP001     SdViewShell::AdjustPosSizePixel(rNewPos, rNewSize);
//STRIP001 }

//STRIP001 void SdSlideViewShell::ArrangeGUIElements ()
//STRIP001 {
//STRIP001     // Retrieve the current size (thickness) of the scroll bars.  That is
//STRIP001     // the width of the vertical and the height of the horizontal scroll
//STRIP001     // bar.
//STRIP001     int nScrollBarSize = GetViewFrame()->GetWindow().GetSettings().GetStyleSettings().GetScrollBarSize();
//STRIP001 	aScrBarWH = Size (nScrollBarSize, nScrollBarSize);
//STRIP001 
//STRIP001     SdViewShell::ArrangeGUIElements ();
//STRIP001 
//STRIP001 	// initialen Zoomfaktor setzen?
//STRIP001 	if (bSetInitialZoomFactor)
//STRIP001 	{
//STRIP001 		bSetInitialZoomFactor = FALSE;	// nie wieder !!!
//STRIP001 
//STRIP001 		Size	aPageSize	 = pSlideView->GetPageArea(0).GetSize();
//STRIP001 		USHORT	nNoOfPages	 = pDoc->GetSdPageCount(PK_STANDARD);
//STRIP001 		USHORT	nPagesPerRow = Min(nNoOfPages, pSlideView->GetPagesPerRow());
//STRIP001 		long	nGapX		 = pSlideView->GetPageGap();
//STRIP001 		long	nMinWidth	 = nPagesPerRow * aPageSize.Width() +
//STRIP001 							   (nPagesPerRow + 1) * nGapX;
//STRIP001 		long	nMinHeight	 = pSlideView->CalcPagePos(0).Y() +
//STRIP001 							   pSlideView->GetPageArea(0).GetHeight();
//STRIP001 
//STRIP001 		long nZoomX = pWindow->GetOutputSize().Width() * 100 / nMinWidth;
//STRIP001 		long nZoomY = pWindow->GetOutputSize().Height() * 100 / nMinHeight;
//STRIP001 
//STRIP001 		SetZoom(Min(nZoomX, nZoomY));
//STRIP001 		pWindow->SetWinViewPos(Point(0,0));
//STRIP001 		pWindow->UpdateMapOrigin(FALSE);
//STRIP001 	}
//STRIP001 
//STRIP001 	// initiale WinPos setzen?
//STRIP001 	if (bInitializeWinPos)
//STRIP001 	{
//STRIP001 		bInitializeWinPos = FALSE;		   // nie wieder
//STRIP001 
//STRIP001 		USHORT nNoOfPages	= pDoc->GetSdPageCount(PK_STANDARD);
//STRIP001 		USHORT nPagesPerRow = pSlideView->GetPagesPerRow();
//STRIP001 		Size   aPageSize	= pSlideView->GetPageArea(0).GetSize();
//STRIP001 		ULONG  nGapX		= pSlideView->GetPageGap();
//STRIP001 		ULONG  nGapY		= nGapX;
//STRIP001 
//STRIP001 		Size aViewSizeLogic(nPagesPerRow * aPageSize.Width() +
//STRIP001 							(nPagesPerRow + 1) * nGapX,
//STRIP001 							pSlideView->CalcPagePos(nNoOfPages-1).Y() +
//STRIP001 							aPageSize.Height() + nGapY);
//STRIP001 		Size aWinSize(pWindow->GetOutputSize());
//STRIP001 		Point aViewOrigin(0,0);
//STRIP001 		Point aWinPos (0,0);
//STRIP001 
//STRIP001 		// die WinPos so positionieren, dass die selektierte Seite auf
//STRIP001 		// halber Hoehe  erscheint
//STRIP001 		USHORT nSelected = pFrameView->GetSelectedPage();
//STRIP001 
//STRIP001         // #96707# Beware, might be a masterpage number and invalid for normal pages
//STRIP001         if ( pDoc->GetSdPage( nSelected, PK_STANDARD ) == NULL )
//STRIP001             nSelected = 0;
//STRIP001 
//STRIP001 		long   nY		 = pSlideView->GetPageArea(nSelected).TopLeft().Y();
//STRIP001 		nY += aPageSize.Height() / 2;
//STRIP001 		aWinPos.Y() = nY -	aWinSize.Height() / 2;
//STRIP001 
//STRIP001 		// falls die sichtbare Flaeche jetzt zu weit oben oder unten liegt,
//STRIP001 		// entsprechend korrigieren
//STRIP001 		if (aWinPos.Y() < 0)
//STRIP001 			aWinPos.Y() = 0;
//STRIP001 		else if (aWinPos.Y() + aWinSize.Height() > aViewSizeLogic.Height())
//STRIP001 			aWinPos.Y() = aViewSizeLogic.Height() - aWinSize.Height();
//STRIP001 
//STRIP001 		InitWindows(Point(0,0), aViewSizeLogic, aWinPos);
//STRIP001 		SetZoomRect(Rectangle(aWinPos, aWinSize));
//STRIP001 	}
//STRIP001 }

// -----------------------------------------------------------------------------

//STRIP001 void SdSlideViewShell::ExecCtrl(SfxRequest &rReq)
//STRIP001 {
//STRIP001 	USHORT nSlot = rReq.GetSlot();
//STRIP001 	switch ( nSlot )
//STRIP001 	{
//STRIP001 		case SID_RELOAD:
//STRIP001 		{
//STRIP001 			// Undo-Manager leeren
//STRIP001 			pDocSh->GetUndoManager()->Clear();
//STRIP001 
//STRIP001 			// Normale Weiterleitung an ViewFrame zur Ausfuehrung
//STRIP001 			GetViewFrame()->ExecuteSlot(rReq);
//STRIP001 
//STRIP001 			// Muss sofort beendet werden
//STRIP001 			return;
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		case SID_OUTPUT_QUALITY_COLOR:
//STRIP001 		case SID_OUTPUT_QUALITY_GRAYSCALE:
//STRIP001 		case SID_OUTPUT_QUALITY_BLACKWHITE:
//STRIP001 		case SID_OUTPUT_QUALITY_CONTRAST:
//STRIP001 		{
//STRIP001             // flush page cache
//STRIP001             pSlideView->UpdateAllPages();
//STRIP001             ExecReq( rReq );
//STRIP001 			break;
//STRIP001 		}
//STRIP001 
//STRIP001 		case SID_PREVIEW_QUALITY_COLOR:
//STRIP001 		case SID_PREVIEW_QUALITY_GRAYSCALE:
//STRIP001 		case SID_PREVIEW_QUALITY_BLACKWHITE:
//STRIP001 		case SID_PREVIEW_QUALITY_CONTRAST:
//STRIP001 
//STRIP001 		case SID_MAIL_SCROLLBODY_PAGEDOWN:
//STRIP001 		{
//STRIP001             ExecReq( rReq );
//STRIP001 			break;
//STRIP001 		}
//STRIP001 
//STRIP001 		case SID_OPT_LOCALE_CHANGED:
//STRIP001 		{
//STRIP001 			pSlideView->UpdateAllPages();
//STRIP001 			UpdatePreview( GetActualPage() );
//STRIP001 			rReq.Done();
//STRIP001             break;
//STRIP001 		}
//STRIP001 
//STRIP001 		default:
//STRIP001 		break;
//STRIP001 	}
//STRIP001 }

// -----------------------------------------------------------------------------

//STRIP001 void SdSlideViewShell::GetCtrlState(SfxItemSet &rSet)
//STRIP001 {
//STRIP001 	if (rSet.GetItemState(SID_RELOAD) != SFX_ITEM_UNKNOWN)
//STRIP001 	{
//STRIP001 		// "Letzte Version" vom SFx en/disablen lassen
//STRIP001 		SfxViewFrame* pSlideViewFrame = SFX_APP()->GetViewFrame();
//STRIP001 		DBG_ASSERT(pSlideViewFrame, "ViewFrame nicht gefunden");
//STRIP001 		if (pSlideViewFrame->ISA(SfxTopViewFrame))
//STRIP001 		{
//STRIP001 			pSlideViewFrame->GetSlotState (SID_RELOAD, NULL, &rSet);
//STRIP001 		}
//STRIP001 		else		// MI sagt: kein MDIFrame --> disablen
//STRIP001 		{
//STRIP001 			rSet.DisableItem(SID_RELOAD);
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001     // output quality
//STRIP001 	if( SFX_ITEM_AVAILABLE == rSet.GetItemState( SID_OUTPUT_QUALITY_COLOR ) ||
//STRIP001 		SFX_ITEM_AVAILABLE == rSet.GetItemState( SID_OUTPUT_QUALITY_GRAYSCALE ) ||
//STRIP001 		SFX_ITEM_AVAILABLE == rSet.GetItemState( SID_OUTPUT_QUALITY_BLACKWHITE ) ||
//STRIP001         SFX_ITEM_AVAILABLE == rSet.GetItemState( SID_OUTPUT_QUALITY_CONTRAST ) )
//STRIP001 	{
//STRIP001 		ULONG   nMode = pWindow->GetDrawMode();
//STRIP001 		UINT16  nQuality = 0;
//STRIP001 
//STRIP001         if( OUTPUT_DRAWMODE_COLOR == nMode )
//STRIP001 			nQuality = 0;
//STRIP001 		else if( OUTPUT_DRAWMODE_GRAYSCALE == nMode )
//STRIP001 			nQuality = 1;
//STRIP001 		else if( OUTPUT_DRAWMODE_BLACKWHITE == nMode )
//STRIP001 			nQuality = 2;
//STRIP001         else if( OUTPUT_DRAWMODE_CONTRAST == nMode )
//STRIP001             nQuality = 3;
//STRIP001 
//STRIP001 		rSet.Put( SfxBoolItem( SID_OUTPUT_QUALITY_COLOR, (BOOL)(nQuality == 0) ) );
//STRIP001 		rSet.Put( SfxBoolItem( SID_OUTPUT_QUALITY_GRAYSCALE, (BOOL)(nQuality == 1) ) );
//STRIP001 		rSet.Put( SfxBoolItem( SID_OUTPUT_QUALITY_BLACKWHITE, (BOOL)(nQuality == 2) ) );
//STRIP001 		rSet.Put( SfxBoolItem( SID_OUTPUT_QUALITY_CONTRAST, (BOOL)(nQuality == 3) ) );
//STRIP001 	}
//STRIP001 
//STRIP001 	// #49150#: Qualitaet des Previewfensters aendern, falls vorhanden
//STRIP001 	if( SFX_ITEM_AVAILABLE == rSet.GetItemState( SID_PREVIEW_QUALITY_COLOR ) ||
//STRIP001 		SFX_ITEM_AVAILABLE == rSet.GetItemState( SID_PREVIEW_QUALITY_GRAYSCALE ) ||
//STRIP001 		SFX_ITEM_AVAILABLE == rSet.GetItemState( SID_PREVIEW_QUALITY_BLACKWHITE ) ||
//STRIP001         SFX_ITEM_AVAILABLE == rSet.GetItemState( SID_PREVIEW_QUALITY_CONTRAST ) )
//STRIP001 	{
//STRIP001 		USHORT nId = SdPreviewChildWindow::GetChildWindowId();
//STRIP001 		if( GetViewFrame()->GetChildWindow( nId ) )
//STRIP001 		{
//STRIP001 			ULONG nMode = pFrameView->GetPreviewDrawMode();
//STRIP001 			rSet.Put( SfxBoolItem( SID_PREVIEW_QUALITY_COLOR, (BOOL)(nMode == PREVIEW_DRAWMODE_COLOR) ) );
//STRIP001 			rSet.Put( SfxBoolItem( SID_PREVIEW_QUALITY_GRAYSCALE, (BOOL)(nMode == PREVIEW_DRAWMODE_GRAYSCALE) ) );
//STRIP001 			rSet.Put( SfxBoolItem( SID_PREVIEW_QUALITY_BLACKWHITE, (BOOL)(nMode == PREVIEW_DRAWMODE_BLACKWHITE) ) );
//STRIP001 			rSet.Put( SfxBoolItem( SID_PREVIEW_QUALITY_CONTRAST, (BOOL)(nMode == PREVIEW_DRAWMODE_CONTRAST) ) );
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			rSet.DisableItem( SID_PREVIEW_QUALITY_COLOR );
//STRIP001 			rSet.DisableItem( SID_PREVIEW_QUALITY_GRAYSCALE );
//STRIP001 			rSet.DisableItem( SID_PREVIEW_QUALITY_BLACKWHITE );
//STRIP001 			rSet.DisableItem( SID_PREVIEW_QUALITY_CONTRAST );
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( SFX_ITEM_AVAILABLE == rSet.GetItemState(SID_MAIL_SCROLLBODY_PAGEDOWN) )
//STRIP001 	{
//STRIP001 		rSet.Put( SfxBoolItem( SID_MAIL_SCROLLBODY_PAGEDOWN, TRUE ) );
//STRIP001 	}
//STRIP001 }

// -----------------------------------------------------------------------------

//STRIP001 void SdSlideViewShell::FuSupport(SfxRequest &rReq)
//STRIP001 {
//STRIP001 	if( rReq.GetSlot() == SID_STYLE_FAMILY && rReq.GetArgs())
//STRIP001 		pDocSh->SetStyleFamily(((SfxUInt16Item&)rReq.GetArgs()->Get( SID_STYLE_FAMILY )).GetValue());
//STRIP001 
//STRIP001 	switch ( rReq.GetSlot() )
//STRIP001 	{
//STRIP001 		case SID_CUT:
//STRIP001 		{
//STRIP001 			if (pFuActual)
//STRIP001 			{
//STRIP001 				pFuActual->DoCut();
//STRIP001 			}
//STRIP001 			else if (pSlideView)
//STRIP001 			{
//STRIP001 				pSlideView->DoCut();
//STRIP001 			}
//STRIP001 			rReq.Done();
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		case SID_COPY:
//STRIP001 		{
//STRIP001 			if (pFuActual)
//STRIP001 			{
//STRIP001 				pFuActual->DoCopy();
//STRIP001 			}
//STRIP001 			else if (pSlideView)
//STRIP001 			{
//STRIP001 				pSlideView->DoCopy();
//STRIP001 			}
//STRIP001 			rReq.Done();
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		case SID_PASTE:
//STRIP001 		{
//STRIP001 			if (pFuActual)
//STRIP001 			{
//STRIP001 				pFuActual->DoPaste();
//STRIP001 			}
//STRIP001 			else if (pSlideView)
//STRIP001 			{
//STRIP001 				pSlideView->DoPaste();
//STRIP001 			}
//STRIP001 
//STRIP001 			Rectangle	aZoomRect, aFullRect;
//STRIP001 			SdPage* 	pPage;
//STRIP001 			USHORT		nPageCnt = pDoc->GetSdPageCount(PK_STANDARD);
//STRIP001 			USHORT		nPageNum = 0;
//STRIP001 			BOOL		bHasSelection = FALSE;
//STRIP001 
//STRIP001 			while( nPageNum < nPageCnt )
//STRIP001 			{
//STRIP001 			    const Rectangle aRect( pSlideView->GetPageArea( nPageNum ) );
//STRIP001 
//STRIP001 				pPage = pDoc->GetSdPage(nPageNum, PK_STANDARD);
//STRIP001 
//STRIP001 				if( pPage->IsSelected() )
//STRIP001 				{
//STRIP001 					bHasSelection = TRUE;
//STRIP001 					aZoomRect.Union(aRect);
//STRIP001 					if ( rReq.GetSlot() == SID_SIZE_PAGE )
//STRIP001 						break;
//STRIP001 				}
//STRIP001 
//STRIP001 				aFullRect.Union(aRect);
//STRIP001 				nPageNum++;
//STRIP001 			}
//STRIP001 			
//STRIP001             if( !bHasSelection )
//STRIP001 				aZoomRect = aFullRect;
//STRIP001 
//STRIP001 			// Sichtbarer Bereich
//STRIP001 			Size aVisSizePixel( pWindow->GetOutputSizePixel() );
//STRIP001 			Rectangle aVisArea( pWindow->PixelToLogic(Rectangle(Point(0,0), aVisSizePixel)) );
//STRIP001 			Size aVisAreaSize( aVisArea.GetSize() );
//STRIP001 
//STRIP001 			if ( !aVisArea.IsInside( aZoomRect ) )
//STRIP001 			{
//STRIP001 				// Objekt liegt nicht komplett im sichtbaren Bereich
//STRIP001 				Size aLogicSize( aZoomRect.GetSize() );
//STRIP001 
//STRIP001 				if (aLogicSize.Height() > aVisAreaSize.Height() ||
//STRIP001 					aLogicSize.Width() > aVisAreaSize.Width())
//STRIP001 				{
//STRIP001 					// Objekt passt nicht in sichtbaren Bereich -> auf Objektgroesse zoomen
//STRIP001 					SetZoomRect( aZoomRect );
//STRIP001 				}
//STRIP001 				else
//STRIP001 				{
//STRIP001 					// Objekt in sichtbaren Bereich scrollen
//STRIP001 					Point aPos = aVisArea.TopLeft() + aZoomRect.Center() - aVisArea.Center();
//STRIP001 					aVisArea.SetPos( aPos );
//STRIP001 					SetZoomRect( aVisArea );
//STRIP001 				}
//STRIP001 			}
//STRIP001 
//STRIP001 			Invalidate( SID_ATTR_ZOOM );
//STRIP001 			rReq.Done();
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		case SID_DRAWINGMODE:
//STRIP001 		case SID_NOTESMODE:
//STRIP001 		case SID_HANDOUTMODE:
//STRIP001 		{
//STRIP001 			if (rReq.GetSlot()==SID_DRAWINGMODE)
//STRIP001 			{
//STRIP001 				pFrameView->SetPageKind(PK_STANDARD);
//STRIP001 				GetViewFrame()->GetDispatcher()->Execute(SID_VIEWSHELL0,
//STRIP001 							SFX_CALLMODE_ASYNCHRON | SFX_CALLMODE_RECORD);
//STRIP001 			}
//STRIP001 			else if (rReq.GetSlot()==SID_NOTESMODE)
//STRIP001 			{
//STRIP001 				pFrameView->SetPageKind(PK_NOTES);
//STRIP001 				GetViewFrame()->GetDispatcher()->Execute(SID_VIEWSHELL0,
//STRIP001 							SFX_CALLMODE_ASYNCHRON | SFX_CALLMODE_RECORD);
//STRIP001 			}
//STRIP001 			else if (rReq.GetSlot()==SID_HANDOUTMODE)
//STRIP001 			{
//STRIP001 				pFrameView->SetPageKind(PK_HANDOUT);
//STRIP001 				GetViewFrame()->GetDispatcher()->Execute(SID_VIEWSHELL0,
//STRIP001 							SFX_CALLMODE_ASYNCHRON | SFX_CALLMODE_RECORD);
//STRIP001 			}
//STRIP001 			rReq.Done();
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		case SID_DIAMODE:
//STRIP001 			rReq.Done();
//STRIP001 			break;
//STRIP001 
//STRIP001 		case SID_OUTLINEMODE:
//STRIP001 			GetViewFrame()->GetDispatcher()->Execute(SID_VIEWSHELL2,
//STRIP001 						SFX_CALLMODE_ASYNCHRON | SFX_CALLMODE_RECORD);
//STRIP001 			rReq.Done();
//STRIP001 			break;
//STRIP001 
//STRIP001 		case SID_ZOOM_PREV:
//STRIP001 		{
//STRIP001 			if (pZoomList->IsPreviousPossible())
//STRIP001 			{
//STRIP001 				// Vorheriges ZoomRect einstellen
//STRIP001 				SetZoomRect(pZoomList->GetPreviousZoomRect());
//STRIP001 			}
//STRIP001 			rReq.Done ();
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		case SID_ZOOM_NEXT:
//STRIP001 		{
//STRIP001 			if (pZoomList->IsNextPossible())
//STRIP001 			{
//STRIP001 				// Naechstes ZoomRect einstellen
//STRIP001 				SetZoomRect(pZoomList->GetNextZoomRect());
//STRIP001 			}
//STRIP001 			rReq.Done ();
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		// #96090# added Undo/Redo handling
//STRIP001 		case SID_UNDO :
//STRIP001 		{
//STRIP001 			ImpSidUndo(FALSE, rReq);
//STRIP001 		}
//STRIP001 		break;
//STRIP001 		case SID_REDO :
//STRIP001 		{
//STRIP001 			ImpSidRedo(FALSE, rReq);
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		default:
//STRIP001 		break;
//STRIP001 	}
//STRIP001 
//STRIP001 	Invalidate(SID_CUT);
//STRIP001 	Invalidate(SID_COPY);
//STRIP001 	Invalidate(SID_PASTE);
//STRIP001 }

// -----------------------------------------------------------------------------

//STRIP001 void SdSlideViewShell::FuTemporary(SfxRequest& rReq)
//STRIP001 {
//STRIP001 	if (pFuActual)
//STRIP001 	{
//STRIP001 		pFuActual->Deactivate();
//STRIP001 
//STRIP001 		if (pFuActual != pFuOld)
//STRIP001 		{
//STRIP001 			delete pFuActual;
//STRIP001 		}
//STRIP001 
//STRIP001 		pFuActual = NULL;
//STRIP001 	}
//STRIP001 
//STRIP001 	switch( rReq.GetSlot() )
//STRIP001 	{
//STRIP001 		case SID_PRESENTATION:
//STRIP001 		case SID_REHEARSE_TIMINGS:
//STRIP001 		{
//STRIP001             SFX_REQUEST_ARG( rReq, pFullScreen, SfxBoolItem, ATTR_PRESENT_FULLSCREEN, FALSE );
//STRIP001             const BOOL bFullScreen = ( ( SID_REHEARSE_TIMINGS != rReq.GetSlot() ) && pFullScreen ) ? pFullScreen->GetValue() : pDoc->GetPresFullScreen();
//STRIP001 
//STRIP001             if( bFullScreen )
//STRIP001             {
//STRIP001                 SdPresViewShell::CreateFullScreenShow( this, rReq );
//STRIP001 			    Cancel();
//STRIP001             }
//STRIP001             else
//STRIP001             {
//STRIP001 			    pFrameView->SetPresentationViewShellId( SID_VIEWSHELL1 );
//STRIP001 			    pFrameView->SetSlotId( rReq.GetSlot() );
//STRIP001 			    pFrameView->SetPageKind( PK_STANDARD );
//STRIP001 			    GetViewFrame()->GetDispatcher()->Execute( SID_VIEWSHELL0, SFX_CALLMODE_ASYNCHRON | SFX_CALLMODE_RECORD );
//STRIP001             }
//STRIP001 
//STRIP001 			rReq.Done();
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		case SID_DIA:
//STRIP001 		{
//STRIP001 			pFuActual =new FuSlideParameters(this,pWindow,pSlideView,pDoc,rReq);
//STRIP001 			Cancel();
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		case SID_HIDE_SLIDE:
//STRIP001 		{
//STRIP001 			pFuActual = new FuSlideHide(this,pWindow,pSlideView,pDoc,rReq);
//STRIP001 			Cancel();
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		case SID_ATTR_ZOOM:
//STRIP001 		{
//STRIP001 			const SfxItemSet* pArgs = rReq.GetArgs();
//STRIP001 
//STRIP001 			if ( pArgs )
//STRIP001 			{
//STRIP001 				SvxZoomType eZT = ( ( const SvxZoomItem& ) pArgs->
//STRIP001 											Get( SID_ATTR_ZOOM ) ).GetType();
//STRIP001 				switch( eZT )
//STRIP001 				{
//STRIP001 					case SVX_ZOOM_PERCENT:
//STRIP001 						SetZoom( (long) ( ( const SvxZoomItem& ) pArgs->
//STRIP001 											Get( SID_ATTR_ZOOM ) ).GetValue() );
//STRIP001 						break;
//STRIP001 
//STRIP001 					/*
//STRIP001 					case SVX_ZOOM_OPTIMAL:
//STRIP001 						GetViewFrame()->GetDispatcher()->Execute( SID_SIZE_ALL,
//STRIP001 									SFX_CALLMODE_ASYNCHRON | SFX_CALLMODE_RECORD );
//STRIP001 						break;
//STRIP001 
//STRIP001 					case SVX_ZOOM_PAGEWIDTH:
//STRIP001 						GetViewFrame()->GetDispatcher()->Execute( SID_SIZE_PAGE_WIDTH,
//STRIP001 									SFX_CALLMODE_ASYNCHRON | SFX_CALLMODE_RECORD );
//STRIP001 						break;
//STRIP001 					*/
//STRIP001 					case SVX_ZOOM_WHOLEPAGE:
//STRIP001 						GetViewFrame()->GetDispatcher()->Execute( SID_SIZE_PAGE,
//STRIP001 									SFX_CALLMODE_ASYNCHRON | SFX_CALLMODE_RECORD );
//STRIP001 						break;
//STRIP001 				}
//STRIP001 				Invalidate( SID_ATTR_ZOOM );
//STRIP001 				rReq.Done();
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				// hier den Zoom-Dialog oeffnen
//STRIP001 				pFuActual = new FuScale( this, pWindow, pSlideView, pDoc, rReq );
//STRIP001 			}
//STRIP001 			Cancel();
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		case SID_ZOOM_OUT:
//STRIP001 		{
//STRIP001 			pFuActual = new FuZoom(this, pWindow, pSlideView, pDoc, rReq);
//STRIP001 			// Beendet sich selbst, kein Cancel() notwendig!
//STRIP001 			rReq.Done();
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		case SID_SIZE_REAL:
//STRIP001 		{
//STRIP001 			SetZoom( 100 );
//STRIP001 			Rectangle aVisAreaWin = pWindow->PixelToLogic( Rectangle( Point(0,0),
//STRIP001 											 pWindow->GetOutputSizePixel()) );
//STRIP001 			pZoomList->InsertZoomRect(aVisAreaWin);
//STRIP001 			Invalidate( SID_ATTR_ZOOM );
//STRIP001 			Invalidate( SID_ZOOM_OUT);
//STRIP001 			Invalidate( SID_ZOOM_IN );
//STRIP001 			Invalidate( SID_SIZE_REAL );
//STRIP001 			Cancel();
//STRIP001 			rReq.Done();
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		case SID_ZOOM_IN:
//STRIP001 		{
//STRIP001 			SetZoom( Max( (long) ( pWindow->GetZoom() / 2 ), (long) pWindow->GetMinZoom() ) );
//STRIP001 			Rectangle aVisAreaWin = pWindow->PixelToLogic( Rectangle( Point(0,0),
//STRIP001 											 pWindow->GetOutputSizePixel()) );
//STRIP001 			pZoomList->InsertZoomRect(aVisAreaWin);
//STRIP001 			Invalidate( SID_ATTR_ZOOM );
//STRIP001 			Invalidate( SID_ZOOM_OUT);
//STRIP001 			Invalidate( SID_ZOOM_IN );
//STRIP001 			Invalidate( SID_SIZE_REAL );
//STRIP001 			Cancel();
//STRIP001 			rReq.Done();
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		case SID_SIZE_ALL:
//STRIP001 		case SID_SIZE_PAGE:
//STRIP001 		{
//STRIP001 			Rectangle	aZoomRect, aFullRect;
//STRIP001 			SdPage* 	pPage;
//STRIP001 			USHORT		nPageCnt = pDoc->GetSdPageCount(PK_STANDARD);
//STRIP001 			USHORT		nPageNum = 0;
//STRIP001 			BOOL		bHasSelection = FALSE;
//STRIP001 
//STRIP001 			while ( nPageNum < nPageCnt )
//STRIP001 			{
//STRIP001 				const Rectangle aRect( pSlideView->GetPageArea( nPageNum ) );
//STRIP001 				
//STRIP001                 pPage = pDoc->GetSdPage( nPageNum, PK_STANDARD );
//STRIP001 
//STRIP001 				if( pPage->IsSelected() )
//STRIP001 				{
//STRIP001 					bHasSelection = TRUE;
//STRIP001 					aZoomRect.Union( aRect );
//STRIP001 					
//STRIP001                     if( rReq.GetSlot() == SID_SIZE_PAGE )
//STRIP001 						break;
//STRIP001 				}
//STRIP001 				
//STRIP001                 aFullRect.Union( aRect );
//STRIP001 				nPageNum++;
//STRIP001 			}
//STRIP001 			
//STRIP001             if ( !bHasSelection )
//STRIP001 				aZoomRect = aFullRect;
//STRIP001 
//STRIP001 			if ( !aZoomRect.IsEmpty() )
//STRIP001 			{
//STRIP001 				Point aPagePos = aZoomRect.Center();
//STRIP001 				Size aPageSize = aZoomRect.GetSize();
//STRIP001 				aPageSize.Width()  = aPageSize.Width()	* 11 / 10;
//STRIP001 				aPageSize.Height() = aPageSize.Height() * 11 / 10;
//STRIP001 				aPagePos.X() -= aPageSize.Width() / 2;
//STRIP001 				aPagePos.Y() -= aPageSize.Height() / 2;
//STRIP001 
//STRIP001 				SetZoomRect( Rectangle(aPagePos, aPageSize) );
//STRIP001 
//STRIP001 				Rectangle aVisAreaWin = pWindow->PixelToLogic( Rectangle( Point(0,0),
//STRIP001 											 pWindow->GetOutputSizePixel()) );
//STRIP001 				pZoomList->InsertZoomRect(aVisAreaWin);
//STRIP001 			}
//STRIP001 			Invalidate( SID_ATTR_ZOOM );
//STRIP001 			Cancel();
//STRIP001 			rReq.Done();
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		case SID_PAGES_PER_ROW:
//STRIP001 		{
//STRIP001 			if( rReq.GetArgs() )
//STRIP001 			{
//STRIP001 				SFX_REQUEST_ARG( rReq, pPagesPerRow, SfxUInt16Item, SID_PAGES_PER_ROW, FALSE);
//STRIP001 
//STRIP001 				if( pPagesPerRow )
//STRIP001 				{
//STRIP001 					SetPagesPerRow( pPagesPerRow->GetValue() );
//STRIP001 					Invalidate( SID_ATTR_ZOOM );
//STRIP001 				}
//STRIP001 			}
//STRIP001 			Cancel();
//STRIP001 			rReq.Done();
//STRIP001 			break;
//STRIP001 		}
//STRIP001 
//STRIP001 		case SID_SELECTALL:
//STRIP001 		{
//STRIP001             pSlideView->SelectAll( TRUE );
//STRIP001 			Cancel();
//STRIP001 			rReq.Done();
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 
//STRIP001 		// Diawechsel-Window
//STRIP001 		case SID_DIA_TIME:
//STRIP001 		case SID_DIA_EFFECT:
//STRIP001 		case SID_DIA_SPEED:
//STRIP001 		case SID_DIA_AUTO:
//STRIP001 		{
//STRIP001 			if( !rReq.GetArgs() )
//STRIP001 			{
//STRIP001 				GetViewFrame()->SetChildWindow(SdSlideChangeChildWindow::GetChildWindowId(),
//STRIP001 										  TRUE);
//STRIP001 			}
//STRIP001 			else if( rReq.GetSlot() == SID_DIA_AUTO )
//STRIP001 				Invalidate( SID_DIA_TIME );
//STRIP001 			rReq.Done();
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		case SID_SLIDE_CHANGE_WIN:
//STRIP001 		{
//STRIP001 			if ( rReq.GetArgs() )
//STRIP001 				GetViewFrame()->SetChildWindow(SdSlideChangeChildWindow::GetChildWindowId(),
//STRIP001 										((const SfxBoolItem&) (rReq.GetArgs()->
//STRIP001 										Get(SID_SLIDE_CHANGE_WIN))).GetValue());
//STRIP001 			else
//STRIP001 				GetViewFrame()->ToggleChildWindow(SdSlideChangeChildWindow::GetChildWindowId() );
//STRIP001 
//STRIP001 			GetViewFrame()->GetBindings().Invalidate(SID_SLIDE_CHANGE_WIN);
//STRIP001 			Cancel();
//STRIP001 			rReq.Ignore ();
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		case SID_SLIDE_CHANGE_STATE:
//STRIP001 		{
//STRIP001 			UpdateSlideChangeWindow();
//STRIP001 			Cancel();
//STRIP001 			rReq.Done();
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		case SID_SLIDE_CHANGE_ASSIGN:
//STRIP001 		{
//STRIP001 			AssignFromSlideChangeWindow();
//STRIP001 			Cancel();
//STRIP001 			rReq.Done();
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		case SID_PREVIEW_WIN:
//STRIP001 		{
//STRIP001 			bool bPreview = false;
//STRIP001 
//STRIP001 			if ( rReq.GetArgs() )
//STRIP001 			{
//STRIP001 				bPreview = ( FALSE != ((const SfxBoolItem&) (rReq.GetArgs()->Get(SID_PREVIEW_WIN))).GetValue() );
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				USHORT nId = SdPreviewChildWindow::GetChildWindowId();
//STRIP001 				bPreview = !SfxBoolItem(SID_PREVIEW_WIN, GetViewFrame()->HasChildWindow(nId)).GetValue();
//STRIP001 			}
//STRIP001 
//STRIP001 			SetPreview( bPreview );
//STRIP001 
//STRIP001 			Cancel();
//STRIP001 			rReq.Ignore ();
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		case SID_PRESENTATION_DLG:
//STRIP001 		{
//STRIP001 			pFuActual = new FuSlideShowDlg( this, pWindow, pSlideView, pDoc, rReq );
//STRIP001 			Cancel();
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		case SID_CUSTOMSHOW_DLG:
//STRIP001 		{
//STRIP001 			pFuActual = new FuCustomShowDlg( this, pWindow, pSlideView, pDoc, rReq );
//STRIP001 			Cancel();
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		case SID_EXPAND_PAGE:
//STRIP001 		{
//STRIP001 			pFuActual = new FuExpandPage( this, pWindow, pSlideView, pDoc, rReq );
//STRIP001 			Cancel();
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		case SID_SUMMARY_PAGE:
//STRIP001 		{
//STRIP001 			pFuActual = new FuSummaryPage( this, pWindow, pSlideView, pDoc, rReq );
//STRIP001 			Cancel();
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		case SID_DELETE_PAGE:
//STRIP001 		{
//STRIP001 			 String aString(SdResId(STR_WARN_DEL_SEL_PAGES));
//STRIP001 
//STRIP001 			if (pDoc->GetSdPageCount(PK_STANDARD) > 1 &&
//STRIP001 				QueryBox(pWindow, WB_YES_NO, aString).Execute() == RET_YES)
//STRIP001 			{
//STRIP001 				pSlideView->DeleteMarked();
//STRIP001 			}
//STRIP001 
//STRIP001 			Cancel();
//STRIP001 			rReq.Done();
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		default:
//STRIP001 		break;
//STRIP001 	}
//STRIP001 
//STRIP001 	if (pFuActual)
//STRIP001 	{
//STRIP001 		pFuActual->Activate();
//STRIP001 	}
//STRIP001 
//STRIP001 	Invalidate(SID_CUT);
//STRIP001 	Invalidate(SID_COPY);
//STRIP001 	Invalidate(SID_PASTE);
//STRIP001 }

// -----------------------------------------------------------------------------

//STRIP001 void SdSlideViewShell::FuPermanent(SfxRequest &rReq)
//STRIP001 {
//STRIP001 	if (pFuActual)
//STRIP001 	{
//STRIP001 		if (pFuOld == pFuActual)
//STRIP001 		{
//STRIP001 			pFuOld = NULL;
//STRIP001 		}
//STRIP001 
//STRIP001 		pFuActual->Deactivate();
//STRIP001 		delete pFuActual;
//STRIP001 		pFuActual = NULL;
//STRIP001 	}
//STRIP001 
//STRIP001 	switch ( rReq.GetSlot() )
//STRIP001 	{
//STRIP001 		case SID_OBJECT_SELECT:
//STRIP001 		{
//STRIP001 			pFuActual = new FuSlideSelection( this, pWindow, pSlideView, pDoc,
//STRIP001 											  rReq );
//STRIP001 			rReq.Done();
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		default:
//STRIP001 		break;
//STRIP001 	}
//STRIP001 
//STRIP001 	if (pFuOld)
//STRIP001 	{
//STRIP001 		pFuOld->Deactivate();
//STRIP001 		delete pFuOld;
//STRIP001 		pFuOld = NULL;
//STRIP001 	}
//STRIP001 
//STRIP001 	if (pFuActual)
//STRIP001 	{
//STRIP001 		pFuActual->Activate();
//STRIP001 		pFuOld = pFuActual;
//STRIP001 	}
//STRIP001 
//STRIP001 	//! das ist nur bis das ENUM-Slots sind
//STRIP001 	Invalidate( SID_OBJECT_SELECT );
//STRIP001 }

// -----------------------------------------------------------------------------

//STRIP001 void SdSlideViewShell::GetMenuState( SfxItemSet &rSet )
//STRIP001 {
//STRIP001 	SdViewShell::GetMenuState(rSet);
//STRIP001 
//STRIP001 	if (pDocSh->IsPreview())
//STRIP001 	{
//STRIP001 		aPresentationBtn.Disable();
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		aPresentationBtn.Enable();
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( SFX_ITEM_AVAILABLE == rSet.GetItemState( SID_PRESENTATION ) )
//STRIP001 	{
//STRIP001 		SfxChildWindow* pPreviewChildWindow = GetViewFrame()->GetChildWindow(SdPreviewChildWindow::GetChildWindowId());
//STRIP001 		SdPreviewWin*	pPreviewWin = (SdPreviewWin*) ( pPreviewChildWindow ? pPreviewChildWindow->GetWindow() : NULL );
//STRIP001 		FuSlideShow*	pShow = pPreviewWin ? pPreviewWin->GetSlideShow() : NULL;
//STRIP001 
//STRIP001 		if ( (pShow && pShow->IsInputLocked()) ||
//STRIP001 			 pDocSh->IsPreview() )
//STRIP001 		{
//STRIP001 			rSet.DisableItem( SID_PRESENTATION );
//STRIP001 			aPresentationBtn.Disable();
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	if( pFuActual )
//STRIP001 	{
//STRIP001 		USHORT nSId = pFuActual->GetSlotID();
//STRIP001 
//STRIP001 		rSet.Put( SfxBoolItem( nSId, TRUE ) );
//STRIP001 	}
//STRIP001 	rSet.Put( SfxBoolItem( SID_DRAWINGMODE, FALSE ) );
//STRIP001 	rSet.Put( SfxBoolItem( SID_DIAMODE, TRUE ) );
//STRIP001 	rSet.Put( SfxBoolItem( SID_OUTLINEMODE, FALSE ) );
//STRIP001 	rSet.Put( SfxBoolItem( SID_NOTESMODE, FALSE ) );
//STRIP001 	rSet.Put( SfxBoolItem( SID_HANDOUTMODE, FALSE ) );
//STRIP001 
//STRIP001 	// Vorlagenkatalog darf nicht aufgerufen werden
//STRIP001 	rSet.DisableItem( SID_STYLE_CATALOG );
//STRIP001 	rSet.DisableItem(SID_SIZE_ALL);
//STRIP001 	rSet.DisableItem(SID_SPELLING);
//STRIP001 	rSet.DisableItem(SID_SEARCH_DLG);
//STRIP001 
//STRIP001 	if (!pZoomList->IsNextPossible())
//STRIP001 	{
//STRIP001 	   rSet.DisableItem(SID_ZOOM_NEXT);
//STRIP001 	}
//STRIP001 	if (!pZoomList->IsPreviousPossible())
//STRIP001 	{
//STRIP001 	   rSet.DisableItem(SID_ZOOM_PREV);
//STRIP001 	}
//STRIP001 
//STRIP001 	if( SFX_ITEM_AVAILABLE == rSet.GetItemState( SID_ZOOM_IN ) ||
//STRIP001 		SFX_ITEM_AVAILABLE == rSet.GetItemState( SID_ZOOM_OUT ) ||
//STRIP001 		SFX_ITEM_AVAILABLE == rSet.GetItemState( SID_SIZE_REAL ) )
//STRIP001 	{
//STRIP001 		BOOL bUIActive = pDocSh->IsUIActive();
//STRIP001 
//STRIP001 		if( pWindow->GetZoom() <= pWindow->GetMinZoom() || bUIActive )
//STRIP001 			rSet.DisableItem( SID_ZOOM_IN );
//STRIP001 		if( pWindow->GetZoom() >= pWindow->GetMaxZoom() || bUIActive )
//STRIP001 			rSet.DisableItem( SID_ZOOM_OUT );
//STRIP001 		if( 100 >= pWindow->GetMaxZoom() || bUIActive )
//STRIP001 			rSet.DisableItem( SID_SIZE_REAL );
//STRIP001 	}
//STRIP001 
//STRIP001     /*	if ( pDocSh->GetActualFunction() )
//STRIP001 	{
//STRIP001 		rSet.ClearItem( SID_DRAWINGMODE );
//STRIP001 		rSet.DisableItem( SID_DRAWINGMODE );
//STRIP001 		aDrawBtn.Disable();
//STRIP001 
//STRIP001 		rSet.ClearItem( SID_NOTESMODE );
//STRIP001 		rSet.DisableItem( SID_NOTESMODE );
//STRIP001 		aNotesBtn.Disable();
//STRIP001 
//STRIP001 		rSet.ClearItem( SID_HANDOUTMODE );
//STRIP001 		rSet.DisableItem( SID_HANDOUTMODE );
//STRIP001 		aHandoutBtn.Disable();
//STRIP001 
//STRIP001 		rSet.ClearItem( SID_OUTLINEMODE );
//STRIP001 		rSet.DisableItem( SID_OUTLINEMODE );
//STRIP001 		aOutlineBtn.Disable();
//STRIP001 
//STRIP001 		rSet.ClearItem( SID_DIAMODE );
//STRIP001 		rSet.DisableItem( SID_DIAMODE );
//STRIP001 		aSlideBtn.Disable();
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001     */		aDrawBtn.Enable();
//STRIP001 		aNotesBtn.Enable();
//STRIP001 		aHandoutBtn.Enable();
//STRIP001 		aOutlineBtn.Enable();
//STRIP001 		aSlideBtn.Enable();
//STRIP001         //	}
//STRIP001 	if( SFX_ITEM_AVAILABLE == rSet.GetItemState( SID_SLIDE_CHANGE_WIN ) )
//STRIP001 	{
//STRIP001 		USHORT nId = SdSlideChangeChildWindow::GetChildWindowId();
//STRIP001 		rSet.Put( SfxBoolItem( SID_SLIDE_CHANGE_WIN, GetViewFrame()->HasChildWindow( nId ) ) );
//STRIP001 	}
//STRIP001 
//STRIP001 	// PreviewWindow
//STRIP001 	if( SFX_ITEM_AVAILABLE == rSet.GetItemState( SID_PREVIEW_WIN ) )
//STRIP001 	{
//STRIP001 		USHORT nId = SdPreviewChildWindow::GetChildWindowId();
//STRIP001 		rSet.Put( SfxBoolItem( SID_PREVIEW_WIN, GetViewFrame()->HasChildWindow( nId ) ) );
//STRIP001 	}
//STRIP001 
//STRIP001 	if (SFX_ITEM_AVAILABLE == rSet.GetItemState(SID_EXPAND_PAGE))
//STRIP001 	{
//STRIP001 		BOOL bDisable = TRUE;
//STRIP001 		USHORT i = 0;
//STRIP001 		USHORT nCount = pDoc->GetSdPageCount(PK_STANDARD);
//STRIP001 
//STRIP001 		while (i < nCount && bDisable)
//STRIP001 		{
//STRIP001 			SdPage* pPage = pDoc->GetSdPage(i, PK_STANDARD);
//STRIP001 
//STRIP001 			if (pPage->IsSelected())
//STRIP001 			{
//STRIP001 				SdrObject* pObj = pPage->GetPresObj(PRESOBJ_OUTLINE);
//STRIP001 
//STRIP001 				if (pObj && !pObj->IsEmptyPresObj())
//STRIP001 				{
//STRIP001 					bDisable = FALSE;
//STRIP001 				}
//STRIP001 			}
//STRIP001 
//STRIP001 			i++;
//STRIP001 		}
//STRIP001 
//STRIP001 		if (bDisable)
//STRIP001 		{
//STRIP001 			rSet.DisableItem(SID_EXPAND_PAGE);
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	if (SFX_ITEM_AVAILABLE == rSet.GetItemState(SID_SUMMARY_PAGE))
//STRIP001 	{
//STRIP001 		BOOL bDisable = TRUE;
//STRIP001 		USHORT i = 0;
//STRIP001 		USHORT nCount = pDoc->GetSdPageCount(PK_STANDARD);
//STRIP001 
//STRIP001 		while (i < nCount && bDisable)
//STRIP001 		{
//STRIP001 			SdPage* pPage = pDoc->GetSdPage(i, PK_STANDARD);
//STRIP001 
//STRIP001 			if (pPage->IsSelected())
//STRIP001 			{
//STRIP001 				SdrObject* pObj = pPage->GetPresObj(PRESOBJ_TITLE);
//STRIP001 
//STRIP001 				if (pObj && !pObj->IsEmptyPresObj())
//STRIP001 				{
//STRIP001 					bDisable = FALSE;
//STRIP001 				}
//STRIP001 			}
//STRIP001 
//STRIP001 			i++;
//STRIP001 		}
//STRIP001 
//STRIP001 		if (bDisable)
//STRIP001 		{
//STRIP001 			rSet.DisableItem(SID_SUMMARY_PAGE);
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	// Starten der Praesentation moeglich?
//STRIP001 	if( SFX_ITEM_AVAILABLE == rSet.GetItemState( SID_PRESENTATION ) ||
//STRIP001 		SFX_ITEM_AVAILABLE == rSet.GetItemState( SID_REHEARSE_TIMINGS ) )
//STRIP001 	{
//STRIP001 		BOOL bDisable = TRUE;
//STRIP001 		USHORT nCount = pDoc->GetSdPageCount( PK_STANDARD );
//STRIP001 
//STRIP001 		for( USHORT i = 0; i < nCount && bDisable; i++ )
//STRIP001 		{
//STRIP001 			SdPage* pPage = pDoc->GetSdPage(i, PK_STANDARD);
//STRIP001 
//STRIP001 			if( !pPage->IsExcluded() )
//STRIP001 				bDisable = FALSE;
//STRIP001 		}
//STRIP001 		if( bDisable || pDocSh->IsPreview())
//STRIP001 		{
//STRIP001 			rSet.DisableItem( SID_PRESENTATION );
//STRIP001 			aPresentationBtn.Disable();
//STRIP001 			rSet.DisableItem( SID_REHEARSE_TIMINGS );
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	SdTransferable* pTransferClip = SD_MOD()->pTransferClip;
//STRIP001 
//STRIP001 	// Keine eigenen Clipboard-Daten?
//STRIP001 	if ( !pTransferClip || !pTransferClip->GetDocShell() )
//STRIP001     {
//STRIP001 		rSet.DisableItem(SID_PASTE);
//STRIP001     }
//STRIP001 	else
//STRIP001 	{
//STRIP001 		SvEmbeddedObject* pObj = pTransferClip->GetDocShell();
//STRIP001 
//STRIP001 		if( !pObj || ( (SdDrawDocShell*) pObj)->GetDoc()->GetPageCount() <= 1 )
//STRIP001         {
//STRIP001 			// Eigene Clipboard-Daten haben nur eine Seite
//STRIP001             rSet.DisableItem(SID_PASTE);
//STRIP001         }
//STRIP001 	}
//STRIP001 
//STRIP001 	if (SFX_ITEM_AVAILABLE == rSet.GetItemState(SID_CUT)  ||
//STRIP001 		SFX_ITEM_AVAILABLE == rSet.GetItemState(SID_COPY) ||
//STRIP001 		SFX_ITEM_AVAILABLE == rSet.GetItemState(SID_DELETE_PAGE))
//STRIP001 	{
//STRIP001 		BOOL bDisable = TRUE;
//STRIP001 		USHORT i = 0;
//STRIP001 		USHORT nCount = pDoc->GetSdPageCount(PK_STANDARD);
//STRIP001 
//STRIP001 		while (i < nCount && bDisable)
//STRIP001 		{
//STRIP001 			SdPage* pPage = pDoc->GetSdPage(i, PK_STANDARD);
//STRIP001 
//STRIP001 			if (pPage->IsSelected())
//STRIP001 			{
//STRIP001 				bDisable = FALSE;
//STRIP001 			}
//STRIP001 
//STRIP001 			i++;
//STRIP001 		}
//STRIP001 
//STRIP001 		if (bDisable)
//STRIP001 		{
//STRIP001 			rSet.DisableItem(SID_CUT);
//STRIP001 			rSet.DisableItem(SID_CUT);
//STRIP001 			rSet.DisableItem(SID_DELETE_PAGE);
//STRIP001 		}
//STRIP001 		else if (pDoc->GetSdPageCount(PK_STANDARD) < 2)
//STRIP001 		{
//STRIP001 			rSet.DisableItem(SID_CUT);
//STRIP001 			rSet.DisableItem(SID_DELETE_PAGE);
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	//rSet.DisableItem( SID_PRINTDOC );
//STRIP001 	//rSet.DisableItem( SID_PRINTDOCDIRECT );
//STRIP001 	//rSet.DisableItem( SID_SETUPPRINTER );
//STRIP001 }

// -----------------------------------------------------------------------------

//STRIP001 void SdSlideViewShell::GetAttrState( SfxItemSet &rSet )
//STRIP001 {
//STRIP001 	BOOL			bDia = FALSE;
//STRIP001 	SfxWhichIter	aIter( rSet );
//STRIP001 	USHORT			nWhich = aIter.FirstWhich();
//STRIP001 /*
//STRIP001 	SdPage* pPage	   = NULL;
//STRIP001 	USHORT	nNoOfPages = pDoc->GetSdPageCount(PK_STANDARD);
//STRIP001 	USHORT	nPage;
//STRIP001 */
//STRIP001 
//STRIP001 	while ( nWhich )
//STRIP001 	{
//STRIP001 		USHORT nSlotId = SfxItemPool::IsWhich(nWhich)
//STRIP001 			? GetPool().GetSlotId(nWhich)
//STRIP001 			: nWhich;
//STRIP001 		switch ( nSlotId )
//STRIP001 		{
//STRIP001 			case SID_DIA_TIME:
//STRIP001 			{
//STRIP001 			/*
//STRIP001 				 BOOL bManual;
//STRIP001 
//STRIP001 				for (nPage = 0; nPage < nNoOfPages; nPage++)
//STRIP001 				{
//STRIP001 					pPage = pDoc->GetSdPage(nPage, PK_STANDARD);
//STRIP001 					if (pPage->IsSelected())
//STRIP001 					{
//STRIP001 						bManual = pPage->GetPresChange() == PRESCHANGE_MANUAL;
//STRIP001 						break;
//STRIP001 					}
//STRIP001 				}
//STRIP001 				if( bManual )
//STRIP001 					rSet.DisableItem( ATTR_DIA_TIME );
//STRIP001 				else
//STRIP001 					rSet.Put( DiaTimeItem ( pPage->GetTime() ) );
//STRIP001 			*/
//STRIP001 				bDia = TRUE;
//STRIP001 			}
//STRIP001 			break;
//STRIP001 
//STRIP001 			case SID_DIA_EFFECT:
//STRIP001 			case SID_DIA_SPEED:
//STRIP001 			case SID_DIA_AUTO:
//STRIP001 				bDia = TRUE;
//STRIP001 			break;
//STRIP001 
//STRIP001 			case SID_PAGES_PER_ROW:
//STRIP001 				rSet.Put( SfxUInt16Item( nSlotId, pSlideView->GetPagesPerRow() ) );
//STRIP001 			break;
//STRIP001 		}
//STRIP001 		nWhich = aIter.NextWhich();
//STRIP001 	}
//STRIP001 
//STRIP001 	if( bDia )
//STRIP001 	{
//STRIP001 		SdPage* pPage	   = NULL;
//STRIP001 		USHORT	nNoOfPages = pDoc->GetSdPageCount(PK_STANDARD);
//STRIP001 		USHORT	nPage;
//STRIP001 
//STRIP001 		// SfxItemSet aSet( pDoc->GetPool(), ATTR_DIA_START, ATTR_DIA_END );
//STRIP001 
//STRIP001 		// jetzt werden die Seitenattribute "per Hand" gemerged
//STRIP001 		BOOL bSameEffect  = TRUE;		  // Annahme: alle Seiten haben die
//STRIP001 		BOOL bSameSpeed   = TRUE;		  // gleichen Attribute
//STRIP001 		BOOL bSameTime	  = TRUE;
//STRIP001 		BOOL bSameChange  = TRUE;
//STRIP001 		//BOOL bSameSoundOn = TRUE;
//STRIP001 		//BOOL bSoundFile	= TRUE;
//STRIP001 
//STRIP001 		presentation::FadeEffect eLastEffect;
//STRIP001 		FadeSpeed  eLastSpeed;
//STRIP001 		PresChange eLastChange;
//STRIP001 		ULONG	   nLastTime;
//STRIP001 		// BOOL    bLastSoundOn;
//STRIP001 		// String	   bLastSound; <-- ziemlich uebel (Prefix)
//STRIP001 
//STRIP001 		// Attribute der ersten selektierten Seite
//STRIP001 		for (nPage = 0; nPage < nNoOfPages; nPage++)
//STRIP001 		{
//STRIP001 			pPage = pDoc->GetSdPage(nPage, PK_STANDARD);
//STRIP001 			if (pPage->IsSelected())
//STRIP001 			{
//STRIP001 				eLastEffect  = pPage->GetFadeEffect();
//STRIP001 				eLastSpeed	 = pPage->GetFadeSpeed();
//STRIP001 				nLastTime	 = pPage->GetTime();
//STRIP001 				eLastChange	 = pPage->GetPresChange();
//STRIP001 				// bLastSoundOn = pPage->IsSoundOn();
//STRIP001 				break;
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		if( nPage == nNoOfPages) // keine selektierte Seite
//STRIP001 		{
//STRIP001 			rSet.DisableItem( SID_DIA_EFFECT );
//STRIP001 			rSet.DisableItem( SID_DIA_SPEED );
//STRIP001 			rSet.DisableItem( SID_DIA_AUTO );
//STRIP001 			rSet.DisableItem( SID_DIA_TIME );
//STRIP001 		}
//STRIP001 		else // mit den anderen selektierten Seiten vergleichen
//STRIP001 		{
//STRIP001 			for (; nPage < nNoOfPages; nPage++)
//STRIP001 			{
//STRIP001 				pPage = pDoc->GetSdPage(nPage, PK_STANDARD);
//STRIP001 				if (pPage->IsSelected())
//STRIP001 				{
//STRIP001 					if (eLastEffect  != pPage->GetFadeEffect()) bSameEffect  = FALSE;
//STRIP001 					if (eLastSpeed	 != pPage->GetFadeSpeed())	bSameSpeed	 = FALSE;
//STRIP001 					if (nLastTime	 != pPage->GetTime())		bSameTime	 = FALSE;
//STRIP001 					if (eLastChange  != pPage->GetPresChange())	bSameChange  = FALSE;
//STRIP001 					// if (bLastSoundOn != pPage->IsSoundOn())	bSameSoundOn = FALSE;
//STRIP001 				}
//STRIP001 			}
//STRIP001 
//STRIP001 			// das Set besetzen
//STRIP001 			//if (bSameEffect)	rSet.Put( DiaEffectItem( eLastEffect ) );
//STRIP001 			if (bSameEffect)  rSet.Put( SfxAllEnumItem( SID_DIA_EFFECT, eLastEffect ) );
//STRIP001 			else			  rSet.InvalidateItem( SID_DIA_EFFECT );
//STRIP001 
//STRIP001 			// if (bSameSpeed)	 rSet.Put( DiaSpeedItem( eLastSpeed ) );
//STRIP001 			if (bSameSpeed)   rSet.Put( SfxAllEnumItem( SID_DIA_SPEED, eLastSpeed ) );
//STRIP001 			else			  rSet.InvalidateItem( SID_DIA_SPEED );
//STRIP001 
//STRIP001 			// SID_DIA_TIME soll disabled werden, wenn nicht automatisch
//STRIP001 			// ausgewaehlt wurde (also auch uneindeutig)
//STRIP001 			if( bSameChange )
//STRIP001 			{
//STRIP001 				rSet.Put( SfxAllEnumItem( SID_DIA_AUTO, eLastChange ) );
//STRIP001 
//STRIP001 				if( eLastChange != PRESCHANGE_AUTO )
//STRIP001 					rSet.DisableItem( SID_DIA_TIME );
//STRIP001 				else
//STRIP001 				{
//STRIP001 					if( bSameTime )
//STRIP001 						rSet.Put( SfxUInt32Item( SID_DIA_TIME, nLastTime ) );
//STRIP001 					else
//STRIP001 						rSet.InvalidateItem( SID_DIA_TIME );
//STRIP001 				}
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				rSet.InvalidateItem( SID_DIA_AUTO );
//STRIP001 				rSet.DisableItem( SID_DIA_TIME );
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		// rSet.Set( aSet );
//STRIP001 	}
//STRIP001 
//STRIP001 }

// -----------------------------------------------------------------------------

//STRIP001 BOOL SdSlideViewShell::KeyInput(const KeyEvent& rKEvt, SdWindow* pWin)
//STRIP001 {
//STRIP001 	BOOL bReturn = FALSE;
//STRIP001 
//STRIP001 	// vom ShowWindow der DiaShow?
//STRIP001 	if (pWin == NULL && pFuActual)
//STRIP001 	{
//STRIP001 		bReturn = pFuActual->KeyInput(rKEvt);
//STRIP001 	}
//STRIP001 
//STRIP001 	// nein, weiterleiten an Basisklasse
//STRIP001 	else
//STRIP001 	{
//STRIP001 		bReturn = SdViewShell::KeyInput(rKEvt, pWin);
//STRIP001 	}
//STRIP001 
//STRIP001 	return(bReturn);
//STRIP001 }

// -----------------------------------------------------------------------------

//STRIP001 void SdSlideViewShell::MouseButtonDown(const MouseEvent& rMEvt, SdWindow* pWin)
//STRIP001 {
//STRIP001 	// vom ShowWindow der DiaShow?
//STRIP001 	if (pWin == NULL && pFuActual)
//STRIP001 	{
//STRIP001 		pFuActual->MouseButtonDown(rMEvt);
//STRIP001 	}
/*
	// Popup-Menue? NEIN !!!!!
	else if ((rMEvt.GetButtons() == MOUSE_RIGHT) && rMEvt.GetClicks() == 1)
	{
		pWindow->ReleaseMouse();
		GetViewFrame()->GetDispatcher()->ExecutePopup(SdResId(RID_SLIDETABLE_POPUP));
	}
	// nein, weiterleiten an Basisklasse
	else
	{
*/
//STRIP001 	SdViewShell::MouseButtonDown(rMEvt, pWin);
//STRIP001 }

// -----------------------------------------------------------------------------

//STRIP001 void SdSlideViewShell::MouseMove(const MouseEvent& rMEvt, SdWindow* pWin)
//STRIP001 {
//STRIP001 	// vom ShowWindow der DiaShow?
//STRIP001 	if (pWin == NULL && pFuActual)
//STRIP001 	{
//STRIP001 		pFuActual->MouseMove(rMEvt);
//STRIP001 	}
//STRIP001 
//STRIP001 	// nein, weiterleiten an Basisklasse (wenn nicht Readonly)
//STRIP001 	else if( !pDocSh->IsReadOnly() )
//STRIP001 	{
//STRIP001 		SdViewShell::MouseMove(rMEvt, pWin);
//STRIP001 	}
//STRIP001 }

// -----------------------------------------------------------------------------

//STRIP001 void SdSlideViewShell::MouseButtonUp(const MouseEvent& rMEvt, SdWindow* pWin)
//STRIP001 {
//STRIP001 	// vom ShowWindow der DiaShow?
//STRIP001 	if (pWin == NULL && pFuActual)
//STRIP001 	{
//STRIP001 		pFuActual->MouseButtonUp(rMEvt);
//STRIP001 	}
//STRIP001 
//STRIP001 	// nein, weiterleiten an Basisklasse
//STRIP001 	else
//STRIP001 	{
//STRIP001 		SdViewShell::MouseButtonUp(rMEvt, pWin);
//STRIP001 	}
//STRIP001 }

// -----------------------------------------------------------------------------

//STRIP001 void SdSlideViewShell::Command(const CommandEvent& rCEvt, SdWindow* pWin)
//STRIP001 {
//STRIP001 	if ( rCEvt.GetCommand() == COMMAND_CONTEXTMENU )
//STRIP001 	{
//STRIP001 		SdPage* pPage	   = NULL;
//STRIP001 		USHORT	nNoOfPages = pDoc->GetSdPageCount(PK_STANDARD);
//STRIP001 		USHORT	nPage;
//STRIP001 		BOOL	bFound = FALSE;
//STRIP001 		USHORT	nPopupId = RID_SLIDE_NOSEL_POPUP;
//STRIP001 
//STRIP001 		for( nPage = 0; nPage < nNoOfPages && !bFound; nPage++ )
//STRIP001 		{
//STRIP001 			pPage = pDoc->GetSdPage( nPage, PK_STANDARD );
//STRIP001 			if( pPage->IsSelected() )
//STRIP001 			{
//STRIP001 				nPopupId = RID_SLIDETABLE_POPUP;
//STRIP001 				bFound = TRUE;
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		pWindow->ReleaseMouse();
//STRIP001 		GetViewFrame()->GetDispatcher()->ExecutePopup( SdResId( nPopupId ) );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		SdViewShell::Command(rCEvt, pWin);
//STRIP001 	}
//STRIP001 }

// -----------------------------------------------------------------------------

//STRIP001 void SdSlideViewShell::InnerResizePixel(const Point &rPos, const Size &rSize)
//STRIP001 {
//STRIP001 	AdjustPosSizePixel(rPos, rSize);
//STRIP001 }

// -----------------------------------------------------------------------------

//STRIP001 void SdSlideViewShell::OuterResizePixel(const Point &rPos, const Size &rSize)
//STRIP001 {
//STRIP001 	AdjustPosSizePixel(rPos, rSize);
//STRIP001 
//STRIP001 }

// -----------------------------------------------------------------------------

//STRIP001 void SdSlideViewShell::ReadFrameViewData(FrameView* pFrameView)
//STRIP001 {
//STRIP001 	pSlideView->SetLineDraft( pFrameView->IsLineDraft() );
//STRIP001 	pSlideView->SetFillDraft( pFrameView->IsFillDraft() );
//STRIP001 	pSlideView->SetTextDraft( pFrameView->IsTextDraft() );
//STRIP001 	pSlideView->SetGrafDraft( pFrameView->IsGrafDraft() );
//STRIP001 	pSlideView->ChangePagesPerRow(pFrameView->GetSlidesPerRow());
//STRIP001 
//STRIP001 	// DrawMode for 'main' window
//STRIP001 	if( pWindow->GetDrawMode() != pFrameView->GetDrawMode() )
//STRIP001 	  pWindow->SetDrawMode( pFrameView->GetDrawMode() );
//STRIP001 }

// -----------------------------------------------------------------------------

//STRIP001 void SdSlideViewShell::WriteFrameViewData()
//STRIP001 {
//STRIP001 	pFrameView->SetLineDraft( pSlideView->IsLineDraft() );
//STRIP001 	pFrameView->SetFillDraft( pSlideView->IsFillDraft() );
//STRIP001 	pFrameView->SetTextDraft( pSlideView->IsTextDraft() );
//STRIP001 	pFrameView->SetGrafDraft( pSlideView->IsGrafDraft() );
//STRIP001 	pFrameView->SetSlidesPerRow(pSlideView->GetPagesPerRow());
//STRIP001 
//STRIP001 	// DrawMode for 'main' window
//STRIP001 	if( pFrameView->GetDrawMode() != pWindow->GetDrawMode() )
//STRIP001 	  pFrameView->SetDrawMode( pWindow->GetDrawMode() );
//STRIP001 
//STRIP001 	SdPage* pActualPage = GetActualPage();
//STRIP001 	
//STRIP001 	if( pActualPage )
//STRIP001         pFrameView->SetSelectedPage( ( pActualPage->GetPageNum() - 1 ) / 2 );
//STRIP001 }

// -----------------------------------------------------------------------------

//STRIP001 void SdSlideViewShell::ExecStatusBar(SfxRequest& rReq)
//STRIP001 {
//STRIP001 }

// -----------------------------------------------------------------------------

//STRIP001 void SdSlideViewShell::GetStatusBarState(SfxItemSet& rSet)
//STRIP001 {
//STRIP001 	// Zoom-Item
//STRIP001 	if( SFX_ITEM_AVAILABLE == rSet.GetItemState( SID_ATTR_ZOOM ) )
//STRIP001 	{
//STRIP001 		SvxZoomItem* pZoomItem;
//STRIP001 		UINT16 nZoom = (UINT16) pWindow->GetZoom();
//STRIP001 
//STRIP001 		pZoomItem = new SvxZoomItem( SVX_ZOOM_PERCENT, nZoom );
//STRIP001 
//STRIP001 		// Bereich einschraenken
//STRIP001 		USHORT nZoomValues = SVX_ZOOM_ENABLE_ALL;
//STRIP001 		nZoomValues &= ~SVX_ZOOM_ENABLE_OPTIMAL;
//STRIP001 		nZoomValues &= ~SVX_ZOOM_ENABLE_PAGEWIDTH;
//STRIP001 		nZoomValues &= ~(SVX_ZOOM_ENABLE_100|SVX_ZOOM_ENABLE_150|SVX_ZOOM_ENABLE_200);
//STRIP001 
//STRIP001 		pZoomItem->SetValueSet( nZoomValues );
//STRIP001 		rSet.Put( *pZoomItem );
//STRIP001 		delete pZoomItem;
//STRIP001 	}
//STRIP001 
//STRIP001 	// Seitenanzeige und Layout
//STRIP001 	/*
//STRIP001 	if( SFX_ITEM_AVAILABLE == rSet.GetItemState( SID_STATUS_PAGE ) ||
//STRIP001 		SFX_ITEM_AVAILABLE == rSet.GetItemState( SID_STATUS_LAYOUT ) )
//STRIP001 	*/
//STRIP001 	SdPage* pPage	   = NULL;
//STRIP001 	SdPage* pFirstPage = NULL;
//STRIP001 	USHORT	nPageCount = pDoc->GetSdPageCount( PK_STANDARD );
//STRIP001 	USHORT	nPage, nFirstPage;
//STRIP001 	USHORT	nSelectedPages = 0;
//STRIP001 	String	aPageStr, aLayoutStr;
//STRIP001 
//STRIP001 	for( nPage = 0; nPage < nPageCount; nPage++ )
//STRIP001 	{
//STRIP001 		pPage = pDoc->GetSdPage( nPage, PK_STANDARD );
//STRIP001 		if( pPage->IsSelected() )
//STRIP001 		{
//STRIP001 			if( ++nSelectedPages > 1 )
//STRIP001 				break;
//STRIP001 			else
//STRIP001 			{
//STRIP001 				nFirstPage = nPage;
//STRIP001 				pFirstPage = pPage;
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	if( nSelectedPages == 1 )
//STRIP001 	{
//STRIP001 		aPageStr = String(SdResId( STR_SD_PAGE ));
//STRIP001 		aPageStr += sal_Unicode(' ');
//STRIP001 		aPageStr += String::CreateFromInt32( nFirstPage + 1 );
//STRIP001 		aPageStr.AppendAscii( RTL_CONSTASCII_STRINGPARAM( " / " ));
//STRIP001 		aPageStr += String::CreateFromInt32( (sal_Int32)nPageCount );
//STRIP001 
//STRIP001 		aLayoutStr = pFirstPage->GetLayoutName();
//STRIP001 		aLayoutStr.Erase( aLayoutStr.SearchAscii( SD_LT_SEPARATOR ) );
//STRIP001 	}
//STRIP001 	rSet.Put( SfxStringItem( SID_STATUS_PAGE, aPageStr ) );
//STRIP001 	rSet.Put( SfxStringItem( SID_STATUS_LAYOUT, aLayoutStr ) );
//STRIP001 }

// -----------------------------------------------------------------------------

//STRIP001 void SdSlideViewShell::SetZoom(long nZoom)
//STRIP001 {
//STRIP001 	Fraction aFrac(pWindow->GetMapMode().GetScaleX());
//STRIP001 	long	 nCurrentZoom = aFrac.GetNumerator() * 100 /
//STRIP001 							aFrac.GetDenominator();
//STRIP001 
//STRIP001 	if (nZoom > nCurrentZoom)
//STRIP001 	{
//STRIP001 		Size aPageSize(pSlideView->GetPageArea(0).GetSize());
//STRIP001 		Size aWinSize(pWindow->PixelToLogic(pWindow->GetOutputSizePixel()));
//STRIP001 
//STRIP001 
//STRIP001 
//STRIP001 		// der Zoom Factor darf nicht um mehr als um diesen Faktor wachsen
//STRIP001 		// (horizontal und vertikal sollten immer gleich skaliert sein)
//STRIP001 		long nAllowedFactorFactor = aWinSize.Width() / aPageSize.Width();
//STRIP001 		long nMaxFactor 		  = nCurrentZoom * nAllowedFactorFactor;
//STRIP001 
//STRIP001 		nZoom = Min(nMaxFactor, nZoom);
//STRIP001 	}
//STRIP001 
//STRIP001 	SdViewShell::SetZoom(nZoom);
//STRIP001 
//STRIP001 	// #106268#
//STRIP001 	GetViewFrame()->GetBindings().Invalidate( SID_ATTR_ZOOM );
//STRIP001 }

// -----------------------------------------------------------------------------

//STRIP001 void SdSlideViewShell::SetZoomRect(const Rectangle& rZoomRect)
//STRIP001 {
//STRIP001 	Size aPageSize(pSlideView->GetPageArea(0).GetSize());
//STRIP001 
//STRIP001 	Rectangle aRect(rZoomRect);
//STRIP001 
//STRIP001 	if (aRect.GetWidth()  < aPageSize.Width())
//STRIP001 	{
//STRIP001 		long nWidthDiff  = (aPageSize.Width() - aRect.GetWidth()) / 2;
//STRIP001 
//STRIP001 		aRect.Left() -= nWidthDiff;
//STRIP001 		aRect.Right() += nWidthDiff;
//STRIP001 
//STRIP001 		if (aRect.Left() < 0)
//STRIP001 		{
//STRIP001 			aRect.SetPos(Point(0, aRect.Top()));
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	if (aRect.GetHeight()  < aPageSize.Height())
//STRIP001 	{
//STRIP001 		long nHeightDiff  = (aPageSize.Height() - aRect.GetHeight()) / 2;
//STRIP001 
//STRIP001 		aRect.Top() -= nHeightDiff;
//STRIP001 		aRect.Bottom() += nHeightDiff;
//STRIP001 
//STRIP001 		if (aRect.Top() < 0)
//STRIP001 		{
//STRIP001 			aRect.SetPos(Point(aRect.Left(), 0));
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	SdViewShell::SetZoomRect(aRect);
//STRIP001 
//STRIP001 	// #106268#
//STRIP001 	GetViewFrame()->GetBindings().Invalidate( SID_ATTR_ZOOM );
//STRIP001 }

// -----------------------------------------------------------------------------

//STRIP001 void SdSlideViewShell::DrawSelectionRect( USHORT nPage )
//STRIP001 {
//STRIP001 	SdPage* pPage = pDoc->GetSdPage(nPage, PK_STANDARD);
//STRIP001     if (pPage != NULL)
//STRIP001     {
//STRIP001         Color           aColor;
//STRIP001         Rectangle       aRect( pSlideView->CalcPagePos( nPage ), pPage->GetSize() );
//STRIP001 
//STRIP001         // Determine the color with which to paint the rectangle.
//STRIP001         if( pPage->IsSelected() )
//STRIP001 		{
//STRIP001 			svtools::ColorConfig aColorConfig;
//STRIP001             aColor = aColorConfig.GetColorValue( svtools::FONTCOLOR ).nColor;
//STRIP001 		}
//STRIP001         else
//STRIP001             aColor = Application::GetSettings().GetStyleSettings().GetWindowColor();
//STRIP001 
//STRIP001         for( short nX = 0; nX < MAX_HSPLIT_CNT; nX++ )
//STRIP001         {
//STRIP001             for( short nY = 0; nY < MAX_VSPLIT_CNT; nY++ )
//STRIP001             {
//STRIP001                 Window* pWindow = pWinArray[nX][nY];
//STRIP001                 if( pWindow )
//STRIP001                 {
//STRIP001                     // Set default draw mode to be able to correctly draw the
//STRIP001                     // selected (and only that) frame.
//STRIP001                     ULONG nPreviousDrawMode = pWindow->GetDrawMode();
//STRIP001                     pWindow->SetDrawMode (DRAWMODE_DEFAULT);
//STRIP001 
//STRIP001                     Rectangle   aInner( pWindow->LogicToPixel( aRect ) );
//STRIP001                     Rectangle   aOuter( aInner );
//STRIP001                     const Color aOldFillColor( pWindow->GetFillColor() );
//STRIP001                     const Color aOldLineColor( pWindow->GetLineColor() );
//STRIP001 
//STRIP001                     pWindow->SetFillColor();
//STRIP001                     pWindow->SetLineColor( aColor );
//STRIP001 
//STRIP001                     aInner.Left() -= 4; aInner.Top() -= 4; aInner.Right() += 4;	aInner.Bottom() += 4;
//STRIP001                     pWindow->DrawRect( pWindow->PixelToLogic( aInner ) );
//STRIP001 
//STRIP001                     aOuter.Left() -= 5; aOuter.Top() -= 5; aOuter.Right() += 5; aOuter.Bottom() += 5;
//STRIP001                     pWindow->DrawRect( pWindow->PixelToLogic( aOuter ) );
//STRIP001 
//STRIP001                     pWindow->SetLineColor( aOldLineColor );
//STRIP001                     pWindow->SetFillColor( aOldFillColor );
//STRIP001 
//STRIP001                     // Restore the previous draw mode.
//STRIP001                     pWindow->SetDrawMode (nPreviousDrawMode);
//STRIP001                 }
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 }

// -----------------------------------------------------------------------------

//STRIP001 void SdSlideViewShell::ImplDrawFocusRect( USHORT nPage, BOOL bVisible )
//STRIP001 {
//STRIP001 	SdPage*     pPage = pDoc->GetSdPage( nPage, PK_STANDARD );
//STRIP001 	Rectangle   aRect( pSlideView->CalcPagePos( nPage ), pPage->GetSize() );
//STRIP001 
//STRIP001 	for( short nX = 0; nX < MAX_HSPLIT_CNT; nX++ )
//STRIP001 	{
//STRIP001 		for( short nY = 0; nY < MAX_VSPLIT_CNT; nY++ )
//STRIP001 		{
//STRIP001 			if( pWinArray[nX][nY] )
//STRIP001 			{
//STRIP001                 if( bVisible )
//STRIP001                 {
//STRIP001     				Rectangle   aInner( pWinArray[nX][nY]->LogicToPixel( aRect ) );
//STRIP001                     const Color aOldFillColor( pWinArray[nX][nY]->GetFillColor() );
//STRIP001 
//STRIP001     				aInner.Left() -= 3; aInner.Top() -= 3; aInner.Right() += 3;	aInner.Bottom() += 3;
//STRIP001 
//STRIP001                     pWinArray[nX][nY]->SetFillColor();
//STRIP001                     pWinArray[nX][nY]->ShowFocus( pWinArray[nX][nY]->PixelToLogic( aInner ) );
//STRIP001                     pWinArray[nX][nY]->SetFillColor( aOldFillColor );
//STRIP001                 }
//STRIP001                 else
//STRIP001                     pWinArray[nX][nY]->HideFocus();
//STRIP001 
//STRIP001                 pWinArray[nX][nY]->Flush();
//STRIP001 			}
//STRIP001         }
//STRIP001     }
//STRIP001 }

// -----------------------------------------------------------------------------

//STRIP001 void SdSlideViewShell::DrawFocusRect( USHORT nPage )
//STRIP001 {
//STRIP001     if( ( SDRPAGE_NOTFOUND != nCurFocusPage ) && ( nPage != nCurFocusPage ) )
//STRIP001         ImplDrawFocusRect( nCurFocusPage, FALSE );
//STRIP001 
//STRIP001     if( SDRPAGE_NOTFOUND != ( nCurFocusPage = nPage ) )
//STRIP001         ImplDrawFocusRect( nCurFocusPage, TRUE );
//STRIP001 }

// -----------------------------------------------------------------------------

//STRIP001 SdPage* SdSlideViewShell::GetActualPage()
//STRIP001 {
//STRIP001 	SdPage* pPage;
//STRIP001 	USHORT	nPageCnt = pDoc->GetSdPageCount( PK_STANDARD );
//STRIP001 	USHORT	nPageNum = 0;
//STRIP001 
//STRIP001 	while( nPageNum < nPageCnt )
//STRIP001 	{
//STRIP001 		pPage = pDoc->GetSdPage( nPageNum, PK_STANDARD );
//STRIP001 		if( pPage->IsSelected() )
//STRIP001 			break;
//STRIP001 		nPageNum++;
//STRIP001 	}
//STRIP001 	if( !pPage->IsSelected() )
//STRIP001 		pPage = pDoc->GetSdPage( 0, PK_STANDARD );
//STRIP001 
//STRIP001 	return( pPage );
//STRIP001 }

// -----------------------------------------------------------------------------

//STRIP001 String SdSlideViewShell::GetPageRangeString()
//STRIP001 {
//STRIP001 	SdPage* pPage      = NULL;
//STRIP001 	USHORT	nPageCount = pDoc->GetSdPageCount( PK_STANDARD );
//STRIP001 	BOOL	bFirst	   = TRUE;
//STRIP001 	BOOL	bAll 	   = TRUE;
//STRIP001 	String  aString;
//STRIP001 
//STRIP001 	for( USHORT nPage = 0; nPage < nPageCount; nPage++)
//STRIP001 	{
//STRIP001 		pPage = pDoc->GetSdPage( nPage, PK_STANDARD );
//STRIP001 		if( pPage->IsSelected() )
//STRIP001 		{
//STRIP001 			if( !bFirst )
//STRIP001 				aString += (sal_Unicode)',';
//STRIP001 			aString += String::CreateFromInt32( nPage + 1 );
//STRIP001 			bFirst = FALSE;
//STRIP001 		}
//STRIP001 		else
//STRIP001 			bAll = FALSE;
//STRIP001 	}
//STRIP001 	if( bAll )
//STRIP001 		aString.Erase();
//STRIP001 
//STRIP001 	return( aString );
//STRIP001 }

// -----------------------------------------------------------------------------

//STRIP001 BOOL SdSlideViewShell::HasSelection(BOOL bText) const
//STRIP001 {
//STRIP001 	BOOL bReturn = FALSE;
//STRIP001 
//STRIP001 	if (!bText)
//STRIP001 	{
//STRIP001 		SdPage* pPage;
//STRIP001 		USHORT  nPageCnt = pDoc->GetSdPageCount( PK_STANDARD );
//STRIP001 		USHORT  nPageNum = 0;
//STRIP001 
//STRIP001 		while(nPageNum < nPageCnt && !bReturn)
//STRIP001 		{
//STRIP001 			pPage = pDoc->GetSdPage(nPageNum, PK_STANDARD);
//STRIP001 
//STRIP001 			if (pPage->IsSelected())
//STRIP001 			{
//STRIP001 				bReturn = TRUE;
//STRIP001 			}
//STRIP001 
//STRIP001 			nPageNum++;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	return bReturn;
//STRIP001 }

// -----------------------------------------------------------------------------

//STRIP001 void SdSlideViewShell::WriteUserDataSequence ( uno::Sequence < beans::PropertyValue >& rSequence, sal_Bool bBrowse )
//STRIP001 {
//STRIP001 	WriteFrameViewData();
//STRIP001 
//STRIP001 	SdViewShell::WriteUserDataSequence( rSequence, bBrowse );
//STRIP001 }

// -----------------------------------------------------------------------------

//STRIP001 void SdSlideViewShell::ReadUserDataSequence ( const uno::Sequence < beans::PropertyValue >& rSequence, sal_Bool bBrowse )
//STRIP001 {
//STRIP001 	WriteFrameViewData();
//STRIP001 
//STRIP001 	SdViewShell::ReadUserDataSequence( rSequence, bBrowse );
//STRIP001 
//STRIP001 	ReadFrameViewData( pFrameView );
//STRIP001 
//STRIP001 	SetPagesPerRow( pFrameView->GetSlidesPerRow() );
//STRIP001 	Invalidate( SID_ATTR_ZOOM );
//STRIP001 }

// -----------------------------------------------------------------------------

//STRIP001 void SdSlideViewShell::SetPagesPerRow( USHORT nPagesPerRow )
//STRIP001 {
//STRIP001 	USHORT nOldPagesPerRow = pSlideView->GetPagesPerRow();
//STRIP001 	// den Wert als maximal erlaubten Wert interpretieren; wenn
//STRIP001 	// es weniger Seiten gibt entsprechend einschraenken
//STRIP001 	USHORT nNoOfPages = pDoc->GetSdPageCount(PK_STANDARD);
//STRIP001 	nPagesPerRow = Min(nPagesPerRow, nNoOfPages);
//STRIP001 
//STRIP001 	pSlideView->ChangePagesPerRow(nPagesPerRow);
//STRIP001 
//STRIP001 	Size  aPageSize   = pSlideView->GetPageArea(0).GetSize();
//STRIP001 	ULONG nGapX 	  = pSlideView->GetPageGap();
//STRIP001 	ULONG nVisWidth   = nPagesPerRow * aPageSize.Width() + (nPagesPerRow + 1) * nGapX;
//STRIP001 
//STRIP001 	Size aViewSize (nVisWidth,
//STRIP001 						pSlideView->GetPageArea(nNoOfPages - 1).Bottom() + nGapX);
//STRIP001 
//STRIP001 	SdWindow* pWin = GetActiveWindow();
//STRIP001 	Size aWinSize(pWin->GetOutputSize());
//STRIP001 	double fRatio = ((double)aWinSize.Height()) / aWinSize.Width();
//STRIP001 	ULONG nVisHeight = (ULONG)(nVisWidth * fRatio);
//STRIP001 	if (nVisHeight < aPageSize.Height() + 2 * nGapX)
//STRIP001 		nVisHeight = aPageSize.Height() + 2 * nGapX;
//STRIP001 	Size aVisSize(nVisWidth, nVisHeight);
//STRIP001 
//STRIP001 	InitWindows(Point(), aViewSize, Point());
//STRIP001 	SetZoomRect(Rectangle(Point(), aVisSize));
//STRIP001 }

// -----------------------------------------------------------------------------

//STRIP001 void SdSlideViewShell::VisAreaChanged(const Rectangle& rRect)
//STRIP001 {
//STRIP001 	SdViewShell::VisAreaChanged( rRect );
//STRIP001 
//STRIP001 	if( pController )
//STRIP001 	{
//STRIP001 		pController->fireVisAreaChanged( rRect );
//STRIP001 	}
//STRIP001 }

// -----------------------------------------------------------------------------

//STRIP001 void SdSlideViewShell::SelectionHasChanged()
//STRIP001 {
//STRIP001 	Invalidate( SID_DIA_EFFECT );
//STRIP001 	Invalidate( SID_DIA_SPEED );
//STRIP001 	Invalidate( SID_DIA_AUTO );
//STRIP001 	Invalidate( SID_DIA_TIME );
//STRIP001 	Invalidate( SID_EXPAND_PAGE );
//STRIP001 	Invalidate( SID_SUMMARY_PAGE );
//STRIP001 
//STRIP001 	// StatusBar
//STRIP001 	Invalidate( SID_STATUS_PAGE );
//STRIP001 	Invalidate( SID_STATUS_LAYOUT );
//STRIP001 
//STRIP001 	UpdateSlideChangeWindow();
//STRIP001 	UpdatePreview( GetActualPage() );
//STRIP001 
//STRIP001     // fire accessible event
//STRIP001 	for( short nX = 0; nX < MAX_HSPLIT_CNT; nX++ )
//STRIP001 	{
//STRIP001 		for( short nY = 0; nY < MAX_VSPLIT_CNT; nY++ )
//STRIP001 		{
//STRIP001 			if( pWinArray[ nX ][ nY ] )
//STRIP001 			{
//STRIP001                 uno::Reference< XAccessible > xAcc( pWinArray[ nX ][ nY ]->GetAccessible( FALSE ) );
//STRIP001 
//STRIP001                 if( xAcc.is() )
//STRIP001                 {
//STRIP001                     AccessibleSlideView* pAccView = AccessibleSlideView::getImplementation( xAcc );
//STRIP001 
//STRIP001                     if( pAccView )
//STRIP001                     {
//STRIP001                         const uno::Any aOldAny, aNewAny;
//STRIP001                         pAccView->FireAccessibleEvent( AccessibleEventId::SELECTION_CHANGED, aOldAny, aNewAny );
//STRIP001                     }
//STRIP001                 }
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 }

// -----------------------------------------------------------------------------

//STRIP001 void SdSlideViewShell::FocusHasChanged( USHORT nOldFocusPage, USHORT nNewFocusPage )
//STRIP001 {
//STRIP001 	for( short nX = 0; nX < MAX_HSPLIT_CNT; nX++ )
//STRIP001 	{
//STRIP001 		for( short nY = 0; nY < MAX_VSPLIT_CNT; nY++ )
//STRIP001 		{
//STRIP001 			if( pWinArray[ nX ][ nY ] )
//STRIP001 			{
//STRIP001                 uno::Reference< XAccessible > xAcc( pWinArray[ nX ][ nY ]->GetAccessible( FALSE ) );
//STRIP001 
//STRIP001                 if( xAcc.is() )
//STRIP001                 {
//STRIP001                     AccessibleSlideView* pAccView = AccessibleSlideView::getImplementation( xAcc );
//STRIP001 
//STRIP001                     if( pAccView )
//STRIP001                         pAccView->FocusHasChanged( nOldFocusPage, nNewFocusPage );
//STRIP001                 }
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 }

// -----------------------------------------------------------------------------

//STRIP001 void SdSlideViewShell::PageLayoutHasChanged()
//STRIP001 {
//STRIP001     const BOOL bFocus = ( SDRPAGE_NOTFOUND != nCurFocusPage );
//STRIP001 
//STRIP001     if( bFocus )
//STRIP001         ImplDrawFocusRect( nCurFocusPage, FALSE );
//STRIP001 
//STRIP001 	for( short nX = 0; nX < MAX_HSPLIT_CNT; nX++ )
//STRIP001 	{
//STRIP001 		for( short nY = 0; nY < MAX_VSPLIT_CNT; nY++ )
//STRIP001 		{
//STRIP001 			if( pWinArray[ nX ][ nY ] )
//STRIP001 			{
//STRIP001                 uno::Reference< XAccessible > xAcc( pWinArray[ nX ][ nY ]->GetAccessible( FALSE ) );
//STRIP001 
//STRIP001                 if( xAcc.is() )
//STRIP001                 {
//STRIP001                     AccessibleSlideView* pAccView = AccessibleSlideView::getImplementation( xAcc );
//STRIP001 
//STRIP001                     if( pAccView )
//STRIP001                         pAccView->Reset();
//STRIP001                 }
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001     if( bFocus )
//STRIP001         ImplDrawFocusRect( nCurFocusPage, TRUE );
//STRIP001 }

// -----------------------------------------------------------------------------

//STRIP001 void SdSlideViewShell::PageVisibilityHasChanged( USHORT nPage, BOOL bVisible )
//STRIP001 {
//STRIP001 	for( short nX = 0; nX < MAX_HSPLIT_CNT; nX++ )
//STRIP001 	{
//STRIP001 		for( short nY = 0; nY < MAX_VSPLIT_CNT; nY++ )
//STRIP001 		{
//STRIP001 			if( pWinArray[ nX ][ nY ] )
//STRIP001 			{
//STRIP001                 uno::Reference< XAccessible > xAcc( pWinArray[ nX ][ nY ]->GetAccessible( FALSE ) );
//STRIP001 
//STRIP001                 if( xAcc.is() )
//STRIP001                 {
//STRIP001                     AccessibleSlideView* pAccView = AccessibleSlideView::getImplementation( xAcc );
//STRIP001 
//STRIP001                     if( pAccView )
//STRIP001                         pAccView->SetPageVisible( nPage, bVisible );
//STRIP001                 }
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 }

// -----------------------------------------------------------------------------

//STRIP001 long SdSlideViewShell::VirtHScrollHdl(ScrollBar* pHScroll)
//STRIP001 {
//STRIP001     const BOOL bFocus = ( SDRPAGE_NOTFOUND != nCurFocusPage );
//STRIP001 
//STRIP001     if( bFocus )
//STRIP001         ImplDrawFocusRect( nCurFocusPage, FALSE );
//STRIP001 
//STRIP001     const long nRet = SdViewShell::VirtHScrollHdl( pHScroll );
//STRIP001 
//STRIP001     if( bFocus )
//STRIP001         ImplDrawFocusRect( nCurFocusPage, TRUE );
//STRIP001 
//STRIP001     return( nRet );
//STRIP001 }

// -----------------------------------------------------------------------------

//STRIP001 long SdSlideViewShell::VirtVScrollHdl(ScrollBar* pVScroll)
//STRIP001 {
//STRIP001     const BOOL bFocus = ( SDRPAGE_NOTFOUND != nCurFocusPage );
//STRIP001 
//STRIP001     if( bFocus )
//STRIP001         ImplDrawFocusRect( nCurFocusPage, FALSE );
//STRIP001 
//STRIP001     const long nRet = SdViewShell::VirtVScrollHdl( pVScroll );
//STRIP001 
//STRIP001     if( bFocus )
//STRIP001         ImplDrawFocusRect( nCurFocusPage, TRUE );
//STRIP001 
//STRIP001     return( nRet );
//STRIP001 }

// -----------------------------------------------------------------------------

//STRIP001 uno::Reference< XAccessible> SdSlideViewShell::CreateAccessibleDocumentView( SdWindow* pWindow )
//STRIP001 {
//STRIP001     uno::Reference< XAccessible> xRet;
//STRIP001 
//STRIP001     if( pWindow && !pWindow->GetAccessible( FALSE ).is() )
//STRIP001         xRet = new AccessibleSlideView( *pDoc, *pSlideView, *pWindow );
//STRIP001 
//STRIP001     return( xRet );
//STRIP001 }
}
