/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sd_docshel2.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 00:06:00 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// auto strip #ifndef _SV_MSGBOX_HXX //autogen
// auto strip #include <vcl/msgbox.hxx>
// auto strip #endif
// auto strip #ifndef _SVDPAGV_HXX //autogen
// auto strip #include <bf_svx/svdpagv.hxx>
// auto strip #endif
// auto strip #ifndef _SVX_SVXIFACT_HXX //autogen
// auto strip #include <bf_svx/svxifact.hxx>
// auto strip #endif
// auto strip #ifndef _SVX_DLGNAME_HXX //autogen
// auto strip #include <bf_svx/dlgname.hxx>
// auto strip #endif

#pragma hdrstop

#include "helpids.h"
#include "docshell.hxx"
#include "viewshel.hxx"
// auto strip #include "drawview.hxx"
// auto strip #include "frmview.hxx"
#include "drawdoc.hxx"
#include "sdpage.hxx"
#include "sdview.hxx"
// auto strip #include "clview.hxx"
#include "sdwindow.hxx"
#include "strings.hrc"
#include "res_bmp.hrc"
// auto strip #include "sdresid.hxx"
#include "strmname.h"
// auto strip #include "fupoor.hxx"
namespace binfilter {

/*************************************************************************
|*
|* Zeichnen der DocShell (mittels der Hilfsklasse SdDrawViewShell)
|*
\************************************************************************/

//STRIP001 void SdDrawDocShell::Draw(OutputDevice* pOut, const JobSetup& rSetup,
//STRIP001 								   USHORT nAspect)
//STRIP001 {
//STRIP001 	if (nAspect == ASPECT_THUMBNAIL)
//STRIP001 	{
//STRIP001 		/**********************************************************************
//STRIP001 		* THUMBNAIL: Hier koennte ev. einmal der Draft-Mode gesetzt werden
//STRIP001 		**********************************************************************/
//STRIP001 	}
//STRIP001 
//STRIP001 	SdClientView* pView = new SdClientView(this, pOut, NULL);
//STRIP001 
//STRIP001 	pView->SetHlplVisible(FALSE);
//STRIP001 	pView->SetGridVisible(FALSE);
//STRIP001 	pView->SetBordVisible(FALSE);
//STRIP001 	pView->SetPageVisible(FALSE);
//STRIP001 	pView->SetGlueVisible(FALSE);
//STRIP001 
//STRIP001 	SdPage* pSelectedPage = NULL;
//STRIP001 
//STRIP001 	List* pFrameViewList = pDoc->GetFrameViewList();
//STRIP001 	if( pFrameViewList && pFrameViewList->Count() )
//STRIP001 	{
//STRIP001 		FrameView* pFrameView = (FrameView*)pFrameViewList->GetObject(0);
//STRIP001 		if( pFrameView && pFrameView->GetPageKind() == PK_STANDARD )
//STRIP001 		{
//STRIP001 			USHORT nSelectedPage = pFrameView->GetSelectedPage();
//STRIP001 			pSelectedPage = pDoc->GetSdPage(nSelectedPage, PK_STANDARD);
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	if( NULL == pSelectedPage )
//STRIP001 	{
//STRIP001 		SdPage* pPage = NULL;
//STRIP001 		USHORT nSelectedPage = 0;
//STRIP001 		USHORT nPageCnt = (USHORT) pDoc->GetSdPageCount(PK_STANDARD);
//STRIP001 
//STRIP001 		for (USHORT i = 0; i < nPageCnt; i++)
//STRIP001 		{
//STRIP001 			pPage = pDoc->GetSdPage(i, PK_STANDARD);
//STRIP001 
//STRIP001 			if ( pPage->IsSelected() )
//STRIP001 			{
//STRIP001 				nSelectedPage = i;
//STRIP001 				pSelectedPage = pPage;
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		if( NULL == pSelectedPage )
//STRIP001 			pSelectedPage = pDoc->GetSdPage(0, PK_STANDARD);
//STRIP001 	}
//STRIP001 
//STRIP001 	Rectangle aVisArea = GetVisArea(nAspect);
//STRIP001 	pOut->IntersectClipRegion(aVisArea);
//STRIP001 
//STRIP001 	pView->ShowPage(pSelectedPage, Point());
//STRIP001 
//STRIP001 	if (pOut->GetOutDevType() != OUTDEV_WINDOW)
//STRIP001 	{
//STRIP001 		MapMode aOldMapMode = pOut->GetMapMode();
//STRIP001 
//STRIP001 		if (pOut->GetOutDevType() == OUTDEV_PRINTER)
//STRIP001 		{
//STRIP001 			MapMode aMapMode = aOldMapMode;
//STRIP001 			Point aOrigin = aMapMode.GetOrigin();
//STRIP001 			aOrigin.X() += 1;
//STRIP001 			aOrigin.Y() += 1;
//STRIP001 			aMapMode.SetOrigin(aOrigin);
//STRIP001 			pOut->SetMapMode(aMapMode);
//STRIP001 		}
//STRIP001 
//STRIP001 		Region aRegion(aVisArea);
//STRIP001 		pView->InitRedraw(pOut, aRegion);
//STRIP001 
//STRIP001 		if (pOut->GetOutDevType() == OUTDEV_PRINTER)
//STRIP001 		{
//STRIP001 			pOut->SetMapMode(aOldMapMode);
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	delete pView;
//STRIP001 
//STRIP001 //  Fuer Testzwecke: Bitte nicht entfernen!
//STRIP001 //
//STRIP001 //  GDIMetaFile* pMtf = pOut->GetConnectMetaFile();
//STRIP001 //
//STRIP001 //  if( pMtf )
//STRIP001 //  {
//STRIP001 //		String aURLStr;
//STRIP001 //
//STRIP001 //		if( ::utl::LocalFileHelper::ConvertPhysicalNameToURL( String( RTL_CONSTASCII_USTRINGPARAM( "d:\\gdi.mtf" ) ), aURLStr ) )
//STRIP001 //		{
//STRIP001 //			SvStream* pOStm = ::utl::UcbStreamHelper::CreateStream( aURLStr, STREAM_WRITE | STREAM_TRUNC );
//STRIP001 //
//STRIP001 //			if( pOStm )
//STRIP001 //			{
//STRIP001 //				*pOStm << *pMtf;
//STRIP001 //				delete pOStm;
//STRIP001 //			}
//STRIP001 //		}
//STRIP001 //  }
//STRIP001 }

/*************************************************************************
|*
|*
|*
\************************************************************************/

/*N*/ void SdDrawDocShell::SetVisArea(const Rectangle& rRect)
/*N*/ {
//    SfxInPlaceObject::SetVisArea(rRect);

/*N*/ 	if (GetCreateMode() == SFX_CREATE_MODE_EMBEDDED)
/*N*/ 	{
/*N*/ 		// Setzt das Modified-Flag
/*N*/ 		SfxInPlaceObject::SetVisArea(rRect);
/*N*/ 	}
/*N*/ 	else
/*N*/ 	{
/*N*/ 		SvEmbeddedObject::SetVisArea(rRect);
/*N*/ 	}
/*N*/ }

/*************************************************************************
|*
|*
|*
\************************************************************************/

/*N*/ Rectangle SdDrawDocShell::GetVisArea(USHORT nAspect) const
/*N*/ {
/*N*/ 	Rectangle aVisArea;
/*N*/ 
/*N*/ 	if( ( ASPECT_THUMBNAIL == nAspect ) || ( ASPECT_DOCPRINT == nAspect ) )
/*N*/ 	{
/*N*/ 		// Groesse der ersten Seite herausgeben
/*?*/ 		MapMode aSrcMapMode(MAP_PIXEL);
/*?*/ 		MapMode aDstMapMode(MAP_100TH_MM);
/*?*/ 		Size aSize = pDoc->GetSdPage(0, PK_STANDARD)->GetSize();
/*?*/ 		aSrcMapMode.SetMapUnit(MAP_100TH_MM);
/*?*/ 
/*?*/ 		aSize = Application::GetDefaultDevice()->LogicToLogic(aSize, &aSrcMapMode, &aDstMapMode);
/*?*/ 		aVisArea.SetSize(aSize);
/*N*/ 	}
/*N*/ 	else
/*N*/ 	{
/*N*/ 		aVisArea = SfxInPlaceObject::GetVisArea(nAspect);
/*N*/ 	}
/*N*/ 
/*N*/ 	if (aVisArea.IsEmpty() && pViewShell)
/*N*/ 	{
/*N*/ 		Window* pWin = pViewShell->GetActiveWindow();
/*N*/ 
/*N*/ 		if (pWin)
/*N*/ 		{
/*N*/ 			aVisArea = pWin->PixelToLogic(Rectangle(Point(0,0), pWin->GetOutputSizePixel()));
/*N*/ 		}
/*N*/ 	}
/*N*/ 
/*N*/ 	return (aVisArea);
/*N*/ }

/*************************************************************************
|*
|* SdViewShell anmelden
|*
\************************************************************************/

/*N*/ void SdDrawDocShell::Connect(SdViewShell* pViewSh)
/*N*/ {
/*N*/ 	pViewShell = pViewSh;
/*N*/ }

/*************************************************************************
|*
|* SdViewShell abmelden
|*
\************************************************************************/

/*N*/ void SdDrawDocShell::Disconnect(SdViewShell* pViewSh)
/*N*/ {
/*N*/ 	if (pViewShell == pViewSh)
/*N*/ 	{
/*N*/ 		pViewShell = NULL;
/*N*/ 	}
/*N*/ }

/*************************************************************************
|*
|*
|*
\************************************************************************/

/*N*/ FrameView* SdDrawDocShell::GetFrameView()
/*N*/ {
/*N*/ 	FrameView* pFrameView = NULL;
/*N*/ 
/*N*/ 	if (pViewShell)
/*N*/ 	{
/*N*/ 		pFrameView = pViewShell->GetFrameView();
/*N*/ 	}
/*N*/ 
/*N*/ 	return(pFrameView);
/*N*/ }

/*************************************************************************
|*
|* Groesse der ersten Seite zurueckgeben
|*
\************************************************************************/

//STRIP001 Size SdDrawDocShell::GetFirstPageSize()
//STRIP001 {
//STRIP001 	return SfxObjectShell::GetFirstPageSize();
//STRIP001 }

/*************************************************************************
|*
|*
|*
\************************************************************************/

//STRIP001 void SdDrawDocShell::UIActivate( BOOL bActive )
//STRIP001 {
//STRIP001 	bUIActive = bActive;
//STRIP001 	SfxInPlaceObject::UIActivate( bActive );
//STRIP001 }

/*************************************************************************
|*
|* Bitmap einer beliebigen Seite erzeugen
|*
\************************************************************************/

//STRIP001 Bitmap SdDrawDocShell::GetPagePreviewBitmap(SdPage* pPage, USHORT nMaxEdgePixel)
//STRIP001 {
//STRIP001 	MapMode			aMapMode( MAP_100TH_MM );
//STRIP001 	const Size		aSize( pPage->GetSize() );
//STRIP001 	const Point		aNullPt;
//STRIP001 	VirtualDevice	aVDev( *Application::GetDefaultDevice() );
//STRIP001 
//STRIP001 	aVDev.SetMapMode( aMapMode );
//STRIP001 
//STRIP001 	const Size	aPixSize( aVDev.LogicToPixel( aSize ) );
//STRIP001 	const ULONG	nMaxEdgePix = Max( aPixSize.Width(), aPixSize.Height() );
//STRIP001 	Fraction	aFrac( nMaxEdgePixel, nMaxEdgePix );
//STRIP001 
//STRIP001 	aMapMode.SetScaleX( aFrac );
//STRIP001 	aMapMode.SetScaleY( aFrac );
//STRIP001 	aVDev.SetMapMode( aMapMode );
//STRIP001 	aVDev.SetOutputSize( aSize );
//STRIP001 
//STRIP001 	// damit die dunklen Linien am rechten und unteren Seitenrans mitkommen
//STRIP001 	aFrac = Fraction( nMaxEdgePixel - 1, nMaxEdgePix );
//STRIP001 	aMapMode.SetScaleX( aFrac );
//STRIP001 	aMapMode.SetScaleY( aFrac );
//STRIP001 	aVDev.SetMapMode( aMapMode );
//STRIP001 
//STRIP001 	SdClientView*	pView = new SdClientView( this, &aVDev, NULL );
//STRIP001 	FrameView*		pFrameView = GetFrameView();
//STRIP001 
//STRIP001 	pView->ShowPage( pPage, aNullPt );
//STRIP001 
//STRIP001 	if ( GetFrameView() )
//STRIP001 	{
//STRIP001 		// Initialisierungen der Zeichen-(Bildschirm-)Attribute
//STRIP001 		pView->SetGridCoarse( pFrameView->GetGridCoarse() );
//STRIP001 		pView->SetGridFine( pFrameView->GetGridFine() );
//STRIP001 		pView->SetSnapGrid( pFrameView->GetSnapGrid() );
//STRIP001 		pView->SetSnapGridWidth(pFrameView->GetSnapGridWidthX(), pFrameView->GetSnapGridWidthY());
//STRIP001 		pView->SetGridVisible( pFrameView->IsGridVisible() );
//STRIP001 		pView->SetGridFront( pFrameView->IsGridFront() );
//STRIP001 		pView->SetSnapAngle( pFrameView->GetSnapAngle() );
//STRIP001 		pView->SetGridSnap( pFrameView->IsGridSnap() );
//STRIP001 		pView->SetBordSnap( pFrameView->IsBordSnap() );
//STRIP001 		pView->SetHlplSnap( pFrameView->IsHlplSnap() );
//STRIP001 		pView->SetOFrmSnap( pFrameView->IsOFrmSnap() );
//STRIP001 		pView->SetOPntSnap( pFrameView->IsOPntSnap() );
//STRIP001 		pView->SetOConSnap( pFrameView->IsOConSnap() );
//STRIP001 		pView->SetDragStripes( pFrameView->IsDragStripes() );
//STRIP001 		pView->SetFrameDragSingles( pFrameView->IsFrameDragSingles() );
//STRIP001 		pView->SetSnapMagneticPixel( pFrameView->GetSnapMagneticPixel() );
//STRIP001 		pView->SetMarkedHitMovesAlways( pFrameView->IsMarkedHitMovesAlways() );
//STRIP001 		pView->SetMoveOnlyDragging( pFrameView->IsMoveOnlyDragging() );
//STRIP001 		pView->SetSlantButShear( pFrameView->IsSlantButShear() );
//STRIP001 		pView->SetNoDragXorPolys( pFrameView->IsNoDragXorPolys() );
//STRIP001 		pView->SetCrookNoContortion( pFrameView->IsCrookNoContortion() );
//STRIP001 		pView->SetAngleSnapEnabled( pFrameView->IsAngleSnapEnabled() );
//STRIP001 		pView->SetBigOrtho( pFrameView->IsBigOrtho() );
//STRIP001 		pView->SetOrtho( pFrameView->IsOrtho() );
//STRIP001 
//STRIP001 		SdrPageView* pPageView = pView->GetPageViewPvNum(0);
//STRIP001 
//STRIP001 		if (pPageView)
//STRIP001 		{
//STRIP001 			if ( pPageView->GetVisibleLayers() != pFrameView->GetVisibleLayers() )
//STRIP001 				pPageView->SetVisibleLayers( pFrameView->GetVisibleLayers() );
//STRIP001 
//STRIP001 			if ( pPageView->GetPrintableLayers() != pFrameView->GetPrintableLayers() )
//STRIP001 				pPageView->SetPrintableLayers( pFrameView->GetPrintableLayers() );
//STRIP001 
//STRIP001 			if ( pPageView->GetLockedLayers() != pFrameView->GetLockedLayers() )
//STRIP001 				pPageView->SetLockedLayers( pFrameView->GetLockedLayers() );
//STRIP001 
//STRIP001 	//				  if ( pPageView->GetHelpLines() != pFrameView->GetHelpLines() )
//STRIP001 				pPageView->SetHelpLines( pFrameView->GetStandardHelpLines() );
//STRIP001 		}
//STRIP001 
//STRIP001 		if ( pView->GetActiveLayer() != pFrameView->GetActiveLayer() )
//STRIP001 			pView->SetActiveLayer( pFrameView->GetActiveLayer() );
//STRIP001 	}
//STRIP001 
//STRIP001 	pView->InitRedraw( &aVDev, Rectangle( aNullPt, aSize ) );
//STRIP001 
//STRIP001 	while ( !pView->IsRedrawReady() ) {}
//STRIP001 	delete pView;
//STRIP001 
//STRIP001 	aVDev.SetMapMode( MapMode() );
//STRIP001 
//STRIP001 	Bitmap aPreview( aVDev.GetBitmap( aNullPt, aVDev.GetOutputSizePixel() ) );
//STRIP001 
//STRIP001 	DBG_ASSERT(!!aPreview, "Vorschau-Bitmap konnte nicht erzeugt werden");
//STRIP001 
//STRIP001 	return aPreview;
//STRIP001 }


/*************************************************************************
|*
|* Pruefen, ob die Seite vorhanden ist und dann den Anwender zwingen einen
|* noch nicht vorhandenen Namen einzugeben. Wird FALSE zurueckgegeben,
|* wurde die Aktion vom Anwender abgebrochen.
|*
\************************************************************************/

//STRIP001 BOOL SdDrawDocShell::CheckPageName( Window* pWin, String& rName )
//STRIP001 {
//STRIP001     const String aStrForDlg( rName );
//STRIP001     bool bIsNameValid = IsNewPageNameValid( rName, true );
//STRIP001 
//STRIP001     if( ! bIsNameValid )
//STRIP001 	{
//STRIP001 		String aDesc( SdResId( STR_WARN_PAGE_EXISTS ) );
//STRIP001 		SvxNameDialog aNameDlg( pWin, aStrForDlg, aDesc );
//STRIP001 		aNameDlg.SetEditHelpId( HID_SD_NAMEDIALOG_PAGE );
//STRIP001 
//STRIP001         if( pViewShell )
//STRIP001             aNameDlg.SetCheckNameHdl( LINK( this, SdDrawDocShell, RenameSlideHdl ) );
//STRIP001 
//STRIP001 		FuPoor* pFunc = pViewShell->GetActualFunction();
//STRIP001         if( pFunc )
//STRIP001 			pFunc->cancel();
//STRIP001 
//STRIP001         if( aNameDlg.Execute() == RET_OK )
//STRIP001 		{
//STRIP001 			aNameDlg.GetName( rName );
//STRIP001             bIsNameValid = IsNewPageNameValid( rName );
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	return ( bIsNameValid ? TRUE : FALSE );
//STRIP001 }

//STRIP001 bool SdDrawDocShell::IsNewPageNameValid( String & rInOutPageName, bool bResetStringIfStandardName /* = false */ )
//STRIP001 {
//STRIP001     bool bCanUseNewName = false;
//STRIP001 
//STRIP001     // check if name is something like 'Slide n'
//STRIP001     String aStrPage( SdResId( STR_SD_PAGE ) );
//STRIP001 	aStrPage += ' ';
//STRIP001 
//STRIP001     bool bIsStandardName = false;
//STRIP001 
//STRIP001     // prevent also _future_ slide names of the form "'STR_SD_PAGE' + ' ' + '[0-9]+|[a-z]|[A-Z]|[CDILMVX]+|[cdilmvx]+'"
//STRIP001     // (arabic, lower- and upper case single letter, lower- and upper case roman numbers)
//STRIP001     if( 0 == rInOutPageName.Search( aStrPage ) )
//STRIP001     {
//STRIP001         if( rInOutPageName.GetToken( 1, sal_Unicode(' ') ).GetChar(0) >= '0' &&
//STRIP001             rInOutPageName.GetToken( 1, sal_Unicode(' ') ).GetChar(0) <= '9' )
//STRIP001         {
//STRIP001             // check for arabic numbering
//STRIP001 
//STRIP001             // gobble up all following numbers
//STRIP001             String sRemainder = rInOutPageName.GetToken( 1, sal_Unicode(' ') );
//STRIP001             while( sRemainder.Len() &&
//STRIP001                    sRemainder.GetChar(0) >= '0' && 
//STRIP001                    sRemainder.GetChar(0) <= '9' )
//STRIP001             {
//STRIP001                 // trim by one
//STRIP001                 sRemainder.Erase(0, 1);
//STRIP001             }
//STRIP001             
//STRIP001             // EOL? Reserved name!
//STRIP001             if( !sRemainder.Len() )
//STRIP001             {
//STRIP001                 bIsStandardName = true;
//STRIP001             }
//STRIP001         }
//STRIP001         else if( rInOutPageName.GetToken( 1, sal_Unicode(' ') ).GetChar(0) >= 'a' &&
//STRIP001                  rInOutPageName.GetToken( 1, sal_Unicode(' ') ).GetChar(0) <= 'z' &&
//STRIP001                  rInOutPageName.GetToken( 1, sal_Unicode(' ') ).Len() == 1 ) 
//STRIP001         {
//STRIP001             // lower case, single character: reserved
//STRIP001             bIsStandardName = true;
//STRIP001         }
//STRIP001         else if( rInOutPageName.GetToken( 1, sal_Unicode(' ') ).GetChar(0) >= 'A' &&
//STRIP001                  rInOutPageName.GetToken( 1, sal_Unicode(' ') ).GetChar(0) <= 'Z' &&
//STRIP001                  rInOutPageName.GetToken( 1, sal_Unicode(' ') ).Len() == 1 ) 
//STRIP001         {
//STRIP001             // upper case, single character: reserved
//STRIP001             bIsStandardName = true;
//STRIP001         }
//STRIP001         else 
//STRIP001         {
//STRIP001             // check for upper/lower case roman numbering
//STRIP001             String sReserved( String::CreateFromAscii( "cdilmvx" ) );
//STRIP001 
//STRIP001             // gobble up all following characters contained in one reserved class
//STRIP001             String sRemainder = rInOutPageName.GetToken( 1, sal_Unicode(' ') );
//STRIP001             if( sReserved.Search( sRemainder.GetChar(0) ) == STRING_NOTFOUND )
//STRIP001                 sReserved.ToUpperAscii();
//STRIP001                 
//STRIP001             while( sReserved.Search( sRemainder.GetChar(0) ) != STRING_NOTFOUND )
//STRIP001             {
//STRIP001                 // trim by one
//STRIP001                 sRemainder.Erase(0, 1);
//STRIP001             }
//STRIP001             
//STRIP001             // EOL? Reserved name!
//STRIP001             if( !sRemainder.Len() )
//STRIP001             {
//STRIP001                 bIsStandardName = true;
//STRIP001             }
//STRIP001         }
//STRIP001     }
//STRIP001 
//STRIP001     if( bIsStandardName )
//STRIP001     {
//STRIP001         if( bResetStringIfStandardName )
//STRIP001         {
//STRIP001             // this is for insertion of slides from other files with standard
//STRIP001             // name.  They get a new standard name, if the string is set to an
//STRIP001             // empty one.
//STRIP001             rInOutPageName = String();
//STRIP001             bCanUseNewName = true;
//STRIP001         }
//STRIP001         else
//STRIP001             bCanUseNewName = false;
//STRIP001     }
//STRIP001     else
//STRIP001     {
//STRIP001         if( rInOutPageName.Len() > 0 )
//STRIP001         {
//STRIP001             BOOL   bOutDummy;
//STRIP001             USHORT nExistingPageNum = pDoc->GetPageByName( rInOutPageName, bOutDummy );
//STRIP001             bCanUseNewName = ( nExistingPageNum == SDRPAGE_NOTFOUND );
//STRIP001         }
//STRIP001         else
//STRIP001             bCanUseNewName = false;
//STRIP001     }
//STRIP001 
//STRIP001     return bCanUseNewName;
//STRIP001 }

//STRIP001 IMPL_LINK( SdDrawDocShell, RenameSlideHdl, SvxNameDialog*, pDialog )
//STRIP001 {
//STRIP001     if( ! pDialog )
//STRIP001         return 0;
//STRIP001 
//STRIP001     String aNewName;
//STRIP001     pDialog->GetName( aNewName );
//STRIP001 
//STRIP001     return IsNewPageNameValid( aNewName );
//STRIP001 }
}
