/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sch_tpstat.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 22:23:33 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#pragma hdrstop

#include <so3/iface.hxx>
#include "schattr.hxx"
#define ITEMID_DOUBLE           0
#define ITEMID_CHARTKINDERROR   SCHATTR_STAT_KIND_ERROR
#define ITEMID_CHARTINDICATE    SCHATTR_STAT_INDICATE
#define ITEMID_CHARTDATADESCR	SCHATTR_DATADESCR_DESCR
#ifndef _SVX_CHRTITEM_HXX //autogen
#include <bf_svx/chrtitem.hxx>
#endif

#include "schresid.hxx"
#include "chtmodel.hxx"
#include "attrib.hxx"
#include "attrib.hrc"
#include "strings.hrc"
#include "res_bmp.hrc"
// for high contrast images
#include "res_hc_bmp.hrc"
namespace binfilter {

// macro for selecting a normal or high contrast bitmap the stack variable
// bIsHighContrast must exist and reflect the correct state

#define SELECT_BITMAP(name) Bitmap( SchResId( bIsHighContrast ? name ## _HC : name ))

//STRIP001 enum StatIndicator
//STRIP001 {
//STRIP001 	INDICATE_NONE,
//STRIP001 	INDICATE_BOTH,
//STRIP001 	INDICATE_UP,
//STRIP001 	INDICATE_DOWN
//STRIP001 };
//STRIP001 
//STRIP001 enum StatRegression
//STRIP001 {
//STRIP001 	REGRESSION_NONE,
//STRIP001 	REGRESSION_LINE,
//STRIP001 	REGRESSION_LOG,
//STRIP001 	REGRESSION_EXP,
//STRIP001 	REGRESSION_POW
//STRIP001 };

/*************************************************************************
|*
|* Dialog zur Ausrichtung der Legende
|*
\************************************************************************/

//STRIP001 SchStatisticTabPage::SchStatisticTabPage(Window* pWindow,
//STRIP001 										 const SfxItemSet& rInAttrs) :
//STRIP001 	SfxTabPage(pWindow, SchResId(TP_STAT), rInAttrs),
//STRIP001 	aRbtNone (this, ResId (RBT_NONE)),
//STRIP001 	aRbtVariant (this, ResId (RBT_VARIANT)),
//STRIP001 	aRbtSigma (this, ResId (RBT_SIGMA)),
//STRIP001 	aRbtPercent (this, ResId (RBT_PERCENTVALUE)),
//STRIP001 	aRbtBigError (this, ResId (RBT_BIGERROR)),
//STRIP001 	aRbtConst (this, ResId (RBT_CONST)),
//STRIP001 	aCbxAverage (this, ResId (CBX_AVERAGE)),
//STRIP001 	aFlDescr (this, ResId (FL_ERROR)),
//STRIP001 	aMtrFldPercent (this, ResId (MTR_FLD_PERCENT)),
//STRIP001 	aMtrFldBigError (this, ResId (MTR_FLD_BIGERROR)),
//STRIP001 	aMtrFldConstPlus (this, ResId (MTR_FLD_PLUS)),
//STRIP001 	aMtrFldConstMinus (this, ResId (MTR_FLD_MINUS)),
//STRIP001 	aFTConstPlus (this, ResId (FT_PERCENT_PLUS)),
//STRIP001 	aFTConstMinus (this, ResId (FT_PERCENT_MINUS)),
//STRIP001 	aFTIndicate (this, ResId (FT_INDICATE)),
//STRIP001 	aFTRegress (this, ResId (FT_REGRESS)),
//STRIP001 	aSet (this, ResId (CT_INDICATE)),
//STRIP001 	aRegression (this, ResId (CT_REGRESS)),
//STRIP001 	rOutAttrs(rInAttrs)
//STRIP001 {
//STRIP001 	FreeResource();
//STRIP001 
//STRIP001 	aRbtNone.SetClickHdl(LINK(this, SchStatisticTabPage, RBtnClick));
//STRIP001 	aRbtVariant.SetClickHdl(LINK(this, SchStatisticTabPage, RBtnClick));
//STRIP001 	aRbtSigma.SetClickHdl(LINK(this, SchStatisticTabPage, RBtnClick));
//STRIP001 	aRbtPercent.SetClickHdl(LINK(this, SchStatisticTabPage, RBtnClick));
//STRIP001 	aRbtBigError.SetClickHdl(LINK(this, SchStatisticTabPage, RBtnClick));
//STRIP001 	aRbtConst.SetClickHdl(LINK(this, SchStatisticTabPage, RBtnClick));
//STRIP001 	aCbxAverage.SetClickHdl(LINK(this, SchStatisticTabPage, CbxClick));
//STRIP001 	aMtrFldConstPlus.SetLoseFocusHdl(LINK(this, SchStatisticTabPage, EditLoseFocusHdl));
//STRIP001 	aMtrFldConstMinus.SetLoseFocusHdl(LINK(this, SchStatisticTabPage, EditLoseFocusHdl));
//STRIP001 
//STRIP001     FillValueSets();
//STRIP001 
//STRIP001 	aSet.SetStyle (aSet.GetStyle () /*| WB_ITEMBORDER | WB_DOUBLEBORDER*/ | WB_NAMEFIELD | WB_VSCROLL );
//STRIP001 	aSet.SetColCount(2);
//STRIP001 	aSet.SetLineCount(1);
//STRIP001 	aSet.SetExtraSpacing(2);
//STRIP001 	aSet.SetSelectHdl(LINK(this, SchStatisticTabPage, SelectIndicate));
//STRIP001 
//STRIP001     aRegression.SetStyle (aSet.GetStyle () /*| WB_ITEMBORDER | WB_DOUBLEBORDER*/ | WB_NAMEFIELD | WB_VSCROLL );
//STRIP001 	aRegression.SetColCount(2);
//STRIP001 	aRegression.SetLineCount(1);
//STRIP001 	aRegression.SetExtraSpacing(2);
//STRIP001 	aRegression.SetSelectHdl(LINK(this, SchStatisticTabPage, SelectRegression));
//STRIP001 }

/*************************************************************************
|*
|* Dtor
|*
/************************************************************************/

//STRIP001 SchStatisticTabPage::~SchStatisticTabPage()
//STRIP001 {
//STRIP001 }

/*************************************************************************
|*
|*	Handler fuer ShowSym-Button enablen/disablen
|*
\*************************************************************************/

//STRIP001 IMPL_LINK( SchStatisticTabPage, RBtnClick, Button *, pBtn )
//STRIP001 {
//STRIP001 	aMtrFldPercent.Enable (pBtn == &aRbtPercent);
//STRIP001 	aMtrFldBigError.Enable (pBtn == &aRbtBigError);
//STRIP001 	aMtrFldConstPlus.Enable (pBtn == &aRbtConst);
//STRIP001 	aMtrFldConstMinus.Enable (pBtn == &aRbtConst);
//STRIP001     aFTConstPlus.Enable (pBtn == &aRbtConst);
//STRIP001     aFTConstMinus.Enable (pBtn == &aRbtConst);
//STRIP001     aSet.Show (pBtn != &aRbtNone);
//STRIP001     aFTIndicate.Show (pBtn != &aRbtNone);
//STRIP001 
//STRIP001 	if (pBtn == &aRbtPercent) eKindError = CHERROR_PERCENT;
//STRIP001     else if (pBtn == &aRbtBigError) eKindError = CHERROR_BIGERROR;
//STRIP001     else if (pBtn == &aRbtConst) eKindError = CHERROR_CONST;
//STRIP001     else if (pBtn == &aRbtNone) eKindError = CHERROR_NONE;
//STRIP001     else if (pBtn == &aRbtVariant) eKindError = CHERROR_VARIANT;
//STRIP001     else if (pBtn == &aRbtSigma) eKindError = CHERROR_SIGMA;
//STRIP001 
//STRIP001 	return 0;
//STRIP001 }


/*************************************************************************
|*
|*    Bearbeitet das Werteset der Fehlerbalken
|*
\*************************************************************************/

//STRIP001 IMPL_LINK( SchStatisticTabPage, SelectIndicate, void *, EMPTYARG )
//STRIP001 {
//STRIP001 	StatIndicator eSelection = (StatIndicator) aSet.GetSelectItemId();
//STRIP001 
//STRIP001 	switch (eSelection - 1)
//STRIP001 	{
//STRIP001 		case INDICATE_NONE :
//STRIP001 			eIndicate = CHINDICATE_NONE;
//STRIP001 			break;
//STRIP001 
//STRIP001 		case INDICATE_BOTH :
//STRIP001 			eIndicate = CHINDICATE_BOTH;
//STRIP001 			break;
//STRIP001 
//STRIP001 		case INDICATE_UP :
//STRIP001 			eIndicate = CHINDICATE_UP;
//STRIP001 			break;
//STRIP001 
//STRIP001 		case INDICATE_DOWN :
//STRIP001 			eIndicate = CHINDICATE_DOWN;
//STRIP001 			break;
//STRIP001 	}
//STRIP001 
//STRIP001 	aSet.SelectItem(eSelection);
//STRIP001 	aSet.Show ();
//STRIP001     aFTIndicate.Show();
//STRIP001 
//STRIP001 	return 0;
//STRIP001 }

/*************************************************************************
|*
|*	Handler fuer Mittelwert-Button
|*
\*************************************************************************/

//STRIP001 IMPL_LINK( SchStatisticTabPage, CbxClick, CheckBox *, pBtn )
//STRIP001 {
//STRIP001 	return 0;
//STRIP001 }

/*************************************************************************
|*
|* Erzeugung
|*
\*************************************************************************/

//STRIP001 SfxTabPage* SchStatisticTabPage::Create(Window* pWindow,
//STRIP001 										const SfxItemSet& rOutAttrs)
//STRIP001 {
//STRIP001 	return new SchStatisticTabPage(pWindow, rOutAttrs);
//STRIP001 }

/*************************************************************************
|*
|* Fuellt uebergebenen Item-Set mit Dialogbox-Attributen
|*
\*************************************************************************/

//STRIP001 BOOL SchStatisticTabPage::FillItemSet(SfxItemSet& rOutAttrs)
//STRIP001 {
//STRIP001 	rOutAttrs.Put (SfxInt32Item (SCHATTR_STAT_KIND_ERROR, (INT32) eKindError));
//STRIP001 	rOutAttrs.Put (SfxInt32Item (SCHATTR_STAT_INDICATE, (INT32) eIndicate));
//STRIP001 	rOutAttrs.Put (SfxBoolItem (SCHATTR_STAT_AVERAGE, aCbxAverage.IsChecked ()));
//STRIP001 
//STRIP001 	if (!bRegressionDisabled) rOutAttrs.Put (SfxInt32Item (SCHATTR_STAT_REGRESSTYPE, (INT32) eRegression));
//STRIP001 
//STRIP001 	switch (eKindError)
//STRIP001 	{
//STRIP001 		case CHERROR_PERCENT :
//STRIP001 			rOutAttrs.Put (SvxDoubleItem ((double) aMtrFldPercent.GetValue (), SCHATTR_STAT_PERCENT));
//STRIP001 			break;
//STRIP001 
//STRIP001 		case CHERROR_BIGERROR :
//STRIP001 			rOutAttrs.Put (SvxDoubleItem ((double) aMtrFldBigError.GetValue (), SCHATTR_STAT_BIGERROR));
//STRIP001 			break;
//STRIP001 
//STRIP001 		case CHERROR_CONST :
//STRIP001 			rOutAttrs.Put (SvxDoubleItem ((double) aMtrFldConstPlus.GetValue () / 10.0, SCHATTR_STAT_CONSTPLUS));
//STRIP001 			rOutAttrs.Put (SvxDoubleItem ((double) aMtrFldConstMinus.GetValue () / 10.0, SCHATTR_STAT_CONSTMINUS));
//STRIP001 			break;
//STRIP001 	}
//STRIP001 
//STRIP001 	return TRUE;
//STRIP001 }

/*************************************************************************
|*
|* Initialisierung
|*
\*************************************************************************/

//STRIP001 void SchStatisticTabPage::Reset(const SfxItemSet& rInAttrs)
//STRIP001 {
//STRIP001 	const SfxPoolItem *pPoolItem = NULL;
//STRIP001 
//STRIP001 	if (rInAttrs.GetItemState(SCHATTR_STAT_AVERAGE, TRUE, &pPoolItem) == SFX_ITEM_SET)
//STRIP001 		aCbxAverage.Check(((const SfxBoolItem*) pPoolItem)->GetValue());
//STRIP001 
//STRIP001 	if (rInAttrs.GetItemState(SCHATTR_STAT_KIND_ERROR, TRUE, &pPoolItem) == SFX_ITEM_SET)
//STRIP001 		eKindError = (SvxChartKindError) ((const SfxInt32Item*) pPoolItem)->GetValue();
//STRIP001 	else eKindError = CHERROR_NONE;
//STRIP001 
//STRIP001     aSet.Show(eKindError != CHERROR_NONE);
//STRIP001     aFTIndicate.Show(eKindError != CHERROR_NONE);
//STRIP001 
//STRIP001 	if (rInAttrs.GetItemState(SCHATTR_STAT_PERCENT, TRUE, &pPoolItem) == SFX_ITEM_SET)
//STRIP001 		aMtrFldPercent.SetValue (((const SvxDoubleItem*) pPoolItem)->GetValue());
//STRIP001 	else aMtrFldPercent.SetValue (0.0);
//STRIP001 
//STRIP001 	if (rInAttrs.GetItemState(SCHATTR_STAT_BIGERROR, TRUE, &pPoolItem) == SFX_ITEM_SET)
//STRIP001 		aMtrFldBigError.SetValue (((const SvxDoubleItem*) pPoolItem)->GetValue());
//STRIP001 	else aMtrFldBigError.SetValue (0.0);
//STRIP001 
//STRIP001 	if (rInAttrs.GetItemState(SCHATTR_STAT_CONSTPLUS, TRUE, &pPoolItem) == SFX_ITEM_SET)
//STRIP001 		aMtrFldConstPlus.SetValue (((const SvxDoubleItem*) pPoolItem)->GetValue() * 10.0);
//STRIP001 	else aMtrFldConstPlus.SetValue (0.0);
//STRIP001 
//STRIP001 	if (rInAttrs.GetItemState(SCHATTR_STAT_CONSTMINUS, TRUE, &pPoolItem) == SFX_ITEM_SET)
//STRIP001 		aMtrFldConstMinus.SetValue (((const SvxDoubleItem*) pPoolItem)->GetValue() * 10.0);
//STRIP001 	else aMtrFldConstMinus.SetValue (0.0);
//STRIP001 
//STRIP001 	if (rInAttrs.GetItemState(SCHATTR_DUMMY0, TRUE, &pPoolItem) == SFX_ITEM_SET)
//STRIP001 		switch ((SvxChartStyle) ((const SfxInt32Item*) pPoolItem)->GetValue())
//STRIP001 		{
//STRIP001 			case CHSTYLE_2D_CUBIC_SPLINE_XY :
//STRIP001 			case CHSTYLE_2D_CUBIC_SPLINE_SYMBOL_XY :
//STRIP001 			case CHSTYLE_2D_B_SPLINE_XY :
//STRIP001 			case CHSTYLE_2D_B_SPLINE_SYMBOL_XY :
//STRIP001 			case CHSTYLE_2D_XY :
//STRIP001 			case CHSTYLE_2D_XYSYMBOLS :
//STRIP001 			case CHSTYLE_2D_XY_LINE :
//STRIP001 				bRegressionDisabled = FALSE;
//STRIP001                 aFTRegress.Show ();
//STRIP001 				aRegression.Show ();
//STRIP001 				break;
//STRIP001 
//STRIP001 			default :
//STRIP001 				aRegression.Hide ();
//STRIP001                 aFTRegress.Hide ();
//STRIP001 				bRegressionDisabled = TRUE;
//STRIP001 		}
//STRIP001 
//STRIP001 	aRbtNone.Check (eKindError == CHERROR_NONE);
//STRIP001 	aRbtVariant.Check (eKindError == CHERROR_VARIANT);
//STRIP001 	aRbtSigma.Check (eKindError == CHERROR_SIGMA);
//STRIP001 	aRbtPercent.Check (eKindError == CHERROR_PERCENT);
//STRIP001 	aRbtBigError.Check (eKindError == CHERROR_BIGERROR);
//STRIP001 	aRbtConst.Check (eKindError == CHERROR_CONST);
//STRIP001 
//STRIP001     aMtrFldPercent.Enable (eKindError == CHERROR_PERCENT);
//STRIP001     aMtrFldBigError.Enable (eKindError == CHERROR_BIGERROR);
//STRIP001     aMtrFldConstPlus.Enable (eKindError == CHERROR_CONST);
//STRIP001     aMtrFldConstMinus.Enable (eKindError == CHERROR_CONST);
//STRIP001     aFTConstPlus.Enable (eKindError == CHERROR_CONST);
//STRIP001     aFTConstMinus.Enable (eKindError == CHERROR_CONST);
//STRIP001 
//STRIP001 	if (rInAttrs.GetItemState(SCHATTR_STAT_INDICATE, TRUE, &pPoolItem) == SFX_ITEM_SET)
//STRIP001 		eIndicate = (SvxChartIndicate) ((const SfxInt32Item*) pPoolItem)->GetValue();
//STRIP001 	else eIndicate = CHINDICATE_NONE;
//STRIP001 
//STRIP001 	switch (eIndicate)
//STRIP001 	{
//STRIP001 		case CHINDICATE_NONE :
//STRIP001 			aSet.SelectItem(INDICATE_NONE + 1);
//STRIP001 			break;
//STRIP001 
//STRIP001 		case CHINDICATE_BOTH :
//STRIP001 			aSet.SelectItem(INDICATE_BOTH + 1);
//STRIP001 			break;
//STRIP001 
//STRIP001 		case CHINDICATE_UP :
//STRIP001 			aSet.SelectItem(INDICATE_UP + 1);
//STRIP001 			break;
//STRIP001 
//STRIP001 		case CHINDICATE_DOWN :
//STRIP001 			aSet.SelectItem(INDICATE_DOWN + 1);
//STRIP001 			break;
//STRIP001 	}
//STRIP001 
//STRIP001 	if (rInAttrs.GetItemState(SCHATTR_STAT_REGRESSTYPE, TRUE, &pPoolItem) == SFX_ITEM_SET)
//STRIP001 		eRegression = (SvxChartRegress) ((const SfxInt32Item*) pPoolItem)->GetValue();
//STRIP001 	else eRegression = CHREGRESS_NONE;
//STRIP001 
//STRIP001 	switch (eRegression)
//STRIP001 	{
//STRIP001 		case CHREGRESS_NONE :
//STRIP001 			aRegression.SelectItem(REGRESSION_NONE + 1);
//STRIP001 			break;
//STRIP001 
//STRIP001 		case CHREGRESS_LINEAR :
//STRIP001 			aRegression.SelectItem(REGRESSION_LINE + 1);
//STRIP001 			break;
//STRIP001 
//STRIP001 		case CHREGRESS_LOG :
//STRIP001 			aRegression.SelectItem(REGRESSION_LOG + 1);
//STRIP001 			break;
//STRIP001 
//STRIP001 		case CHREGRESS_EXP :
//STRIP001 			aRegression.SelectItem(REGRESSION_EXP + 1);
//STRIP001 			break;
//STRIP001 
//STRIP001 		case CHREGRESS_POWER :
//STRIP001 			aRegression.SelectItem(REGRESSION_POW + 1);
//STRIP001 			break;
//STRIP001 	}
//STRIP001 }

/*************************************************************************
|*
|*    Bearbeite das Valueset
|*
\*************************************************************************/

//STRIP001 IMPL_LINK( SchStatisticTabPage, EditLoseFocusHdl, Control *, pControl )
//STRIP001 {
//STRIP001 	if ((double) aMtrFldConstPlus.GetValue () == 0.0)
//STRIP001 	{
//STRIP001 		if ((double) aMtrFldConstMinus.GetValue () == 0.0)
//STRIP001 		{
//STRIP001 			eIndicate = CHINDICATE_NONE;
//STRIP001 			aSet.SelectItem(INDICATE_NONE + 1);
//STRIP001 		}
//STRIP001 		else if (eIndicate != CHINDICATE_NONE)
//STRIP001 			 {
//STRIP001 				 eIndicate = CHINDICATE_DOWN;
//STRIP001 				 aSet.SelectItem(INDICATE_DOWN + 1);
//STRIP001 			 }
//STRIP001 	}
//STRIP001 	else if ((double) aMtrFldConstMinus.GetValue () == 0.0)
//STRIP001 		 {
//STRIP001 			 if (eIndicate != CHINDICATE_NONE)
//STRIP001 			 {
//STRIP001 				 eIndicate = CHINDICATE_UP;
//STRIP001 				 aSet.SelectItem(INDICATE_UP + 1);
//STRIP001 			 }
//STRIP001 		 }
//STRIP001 		 else
//STRIP001 		 {
//STRIP001 			 eIndicate = CHINDICATE_BOTH;
//STRIP001 			 aSet.SelectItem(INDICATE_BOTH + 1);
//STRIP001 		 }
//STRIP001 
//STRIP001 	return 0;
//STRIP001 }

/*************************************************************************
|*
|*    Bearbeitet das Werteset der Regression
|*
\*************************************************************************/

//STRIP001 IMPL_LINK( SchStatisticTabPage, SelectRegression, void *, EMPTYARG )
//STRIP001 {
//STRIP001 	StatRegression eSelection = (StatRegression) aRegression.GetSelectItemId();
//STRIP001 
//STRIP001     switch (eSelection - 1)
//STRIP001 	{
//STRIP001 		case REGRESSION_NONE :
//STRIP001 			eRegression = CHREGRESS_NONE;
//STRIP001 			break;
//STRIP001 
//STRIP001 		case REGRESSION_LINE :
//STRIP001 			eRegression = CHREGRESS_LINEAR;
//STRIP001 			break;
//STRIP001 
//STRIP001 		case REGRESSION_LOG :
//STRIP001 			eRegression = CHREGRESS_LOG;
//STRIP001 			break;
//STRIP001 
//STRIP001 		case REGRESSION_EXP :
//STRIP001 			eRegression = CHREGRESS_EXP;
//STRIP001 			break;
//STRIP001 
//STRIP001 		case REGRESSION_POW :
//STRIP001 			eRegression = CHREGRESS_POWER;
//STRIP001 			break;
//STRIP001 	}
//STRIP001 
//STRIP001 	aRegression.SelectItem(eSelection);
//STRIP001 	aRegression.Show ();
//STRIP001     aFTRegress.Show ();
//STRIP001 
//STRIP001     return 0;
//STRIP001 }

//STRIP001 void SchStatisticTabPage::FillValueSets()
//STRIP001 {
//STRIP001     bool bIsHighContrast = ( true && GetDisplayBackground().GetColor().IsDark() );
//STRIP001 
//STRIP001     if( aSet.GetItemCount() == 0 )
//STRIP001     {
//STRIP001         aSet.InsertItem( INDICATE_NONE + 1, SELECT_BITMAP( BMP_INDICATE_NONE ),
//STRIP001                          String(SchResId(STR_INDICATE_NONE)));
//STRIP001         aSet.InsertItem( INDICATE_BOTH + 1, SELECT_BITMAP( BMP_INDICATE_BOTH ),
//STRIP001                          String(SchResId(STR_INDICATE_BOTH)));
//STRIP001         aSet.InsertItem( INDICATE_DOWN + 1, SELECT_BITMAP( BMP_INDICATE_DOWN ),
//STRIP001                          String(SchResId(STR_INDICATE_DOWN)));
//STRIP001         aSet.InsertItem( INDICATE_UP + 1, SELECT_BITMAP( BMP_INDICATE_UP ),
//STRIP001                          String(SchResId(STR_INDICATE_UP)));
//STRIP001     }
//STRIP001     else
//STRIP001     {
//STRIP001         aSet.SetItemImage( INDICATE_NONE + 1, SELECT_BITMAP( BMP_INDICATE_NONE ));
//STRIP001         aSet.SetItemImage( INDICATE_BOTH + 1, SELECT_BITMAP( BMP_INDICATE_BOTH ));
//STRIP001         aSet.SetItemImage( INDICATE_DOWN + 1, SELECT_BITMAP( BMP_INDICATE_DOWN ));
//STRIP001         aSet.SetItemImage( INDICATE_UP + 1, SELECT_BITMAP( BMP_INDICATE_UP ));
//STRIP001     }
//STRIP001 
//STRIP001     if( aRegression.GetItemCount() == 0 )
//STRIP001     {
//STRIP001         aRegression.InsertItem( REGRESSION_NONE + 1, SELECT_BITMAP( BMP_REGRESSION_NONE ),
//STRIP001                                 String(SchResId(STR_REGRESSION_NONE)));
//STRIP001         aRegression.InsertItem( REGRESSION_LINE + 1, SELECT_BITMAP( BMP_REGRESSION_LINEAR ),
//STRIP001                                 String(SchResId(STR_REGRESSION_LINEAR)));
//STRIP001         aRegression.InsertItem( REGRESSION_LOG + 1, SELECT_BITMAP( BMP_REGRESSION_LOG ),
//STRIP001                                 String(SchResId(STR_REGRESSION_LOG)));
//STRIP001         aRegression.InsertItem( REGRESSION_EXP + 1, SELECT_BITMAP( BMP_REGRESSION_EXP ),
//STRIP001                                 String(SchResId(STR_REGRESSION_EXP)));
//STRIP001         aRegression.InsertItem( REGRESSION_POW + 1, SELECT_BITMAP( BMP_REGRESSION_POWER ),
//STRIP001                                 String(SchResId(STR_REGRESSION_POWER)));
//STRIP001     }
//STRIP001     else
//STRIP001     {
//STRIP001         aRegression.SetItemImage( REGRESSION_NONE + 1, SELECT_BITMAP( BMP_REGRESSION_NONE ));
//STRIP001         aRegression.SetItemImage( REGRESSION_LINE + 1, SELECT_BITMAP( BMP_REGRESSION_LINEAR ));
//STRIP001         aRegression.SetItemImage( REGRESSION_LOG + 1, SELECT_BITMAP( BMP_REGRESSION_LOG ));
//STRIP001         aRegression.SetItemImage( REGRESSION_EXP + 1, SELECT_BITMAP( BMP_REGRESSION_EXP ));
//STRIP001         aRegression.SetItemImage( REGRESSION_POW + 1, SELECT_BITMAP( BMP_REGRESSION_POWER ));
//STRIP001     }
//STRIP001 }

//STRIP001 void SchStatisticTabPage::DataChanged( const DataChangedEvent& rDCEvt )
//STRIP001 {
//STRIP001     SfxTabPage::DataChanged( rDCEvt );
//STRIP001 
//STRIP001     if ( (rDCEvt.GetType() == DATACHANGED_SETTINGS) && (rDCEvt.GetFlags() & SETTINGS_STYLE) )
//STRIP001         FillValueSets();
//STRIP001 }
}
