/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sc_undodat.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 21:07:17 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// System - Includes -----------------------------------------------------

#ifdef PCH
// auto strip #include "ui_pch.hxx"
#endif

#pragma hdrstop

// INCLUDE ---------------------------------------------------------------

// auto strip #include <bf_sfx2/app.hxx>

#include "undodat.hxx"
// auto strip #include "undoutil.hxx"
// auto strip #include "document.hxx"
// auto strip #include "docsh.hxx"
#include "tabvwsh.hxx"
// auto strip #include "olinetab.hxx"
#include "dbcolect.hxx"
// auto strip #include "rangenam.hxx"
// auto strip #include "pivot.hxx"
#include "globstr.hrc"
// auto strip #include "global.hxx"
// auto strip #include "target.hxx"
// auto strip #include "chartarr.hxx"
// auto strip #include "dbdocfun.hxx"
// auto strip #include "olinefun.hxx"
// auto strip #include "dpobject.hxx"
#include "bf_sc.hrc"
namespace binfilter {

// -----------------------------------------------------------------------

//STRIP001 TYPEINIT1(ScUndoDoOutline,			SfxUndoAction);
//STRIP001 TYPEINIT1(ScUndoMakeOutline,		SfxUndoAction);
//STRIP001 TYPEINIT1(ScUndoOutlineLevel,		SfxUndoAction);
//STRIP001 TYPEINIT1(ScUndoOutlineBlock,		SfxUndoAction);
//STRIP001 TYPEINIT1(ScUndoRemoveAllOutlines,	SfxUndoAction);
//STRIP001 TYPEINIT1(ScUndoAutoOutline,		SfxUndoAction);
//STRIP001 TYPEINIT1(ScUndoSubTotals,			SfxUndoAction);
//STRIP001 TYPEINIT1(ScUndoSort,				SfxUndoAction);
//STRIP001 TYPEINIT1(ScUndoQuery,				SfxUndoAction);
//STRIP001 TYPEINIT1(ScUndoDBData, 			SfxUndoAction);
//STRIP001 TYPEINIT1(ScUndoImportData, 		SfxUndoAction);
//STRIP001 TYPEINIT1(ScUndoRepeatDB,			SfxUndoAction);
//STRIP001 TYPEINIT1(ScUndoPivot,				SfxUndoAction);
//STRIP001 TYPEINIT1(ScUndoDataPilot,			SfxUndoAction);
//STRIP001 TYPEINIT1(ScUndoConsolidate,		SfxUndoAction);
//STRIP001 TYPEINIT1(ScUndoChartData,			SfxUndoAction);

// -----------------------------------------------------------------------


//
//		Outline-Gruppen ein- oder ausblenden
//

//STRIP001 ScUndoDoOutline::ScUndoDoOutline( ScDocShell* pNewDocShell,
//STRIP001 							USHORT nNewStart, USHORT nNewEnd, USHORT nNewTab,
//STRIP001 							ScDocument* pNewUndoDoc, BOOL bNewColumns,
//STRIP001 							USHORT nNewLevel, USHORT nNewEntry, BOOL bNewShow ) :
//STRIP001 	ScSimpleUndo( pNewDocShell ),
//STRIP001 	nStart( nNewStart ),
//STRIP001 	nEnd( nNewEnd ),
//STRIP001 	nTab( nNewTab ),
//STRIP001 	pUndoDoc( pNewUndoDoc ),
//STRIP001 	bColumns( bNewColumns ),
//STRIP001 	nLevel( nNewLevel ),
//STRIP001 	nEntry( nNewEntry ),
//STRIP001 	bShow( bNewShow )
//STRIP001 {
//STRIP001 }

//STRIP001 __EXPORT ScUndoDoOutline::~ScUndoDoOutline()
//STRIP001 {
//STRIP001 	delete pUndoDoc;
//STRIP001 }

//STRIP001 String __EXPORT ScUndoDoOutline::GetComment() const
//STRIP001 {	// Detail einblenden" "Detail ausblenden"
//STRIP001 	return bShow ?
//STRIP001 		ScGlobal::GetRscString( STR_UNDO_DOOUTLINE ) :
//STRIP001 		ScGlobal::GetRscString( STR_UNDO_REDOOUTLINE );
//STRIP001 }

//STRIP001 void __EXPORT ScUndoDoOutline::Undo()
//STRIP001 {
//STRIP001 	BeginUndo();
//STRIP001 
//STRIP001 	ScDocument* pDoc = pDocShell->GetDocument();
//STRIP001 	ScTabViewShell* pViewShell = ScTabViewShell::GetActiveViewShell();
//STRIP001 
//STRIP001 	//	Tabelle muss vorher umgeschaltet sein (#46952#) !!!
//STRIP001 
//STRIP001 	USHORT nVisTab = pViewShell->GetViewData()->GetTabNo();
//STRIP001 	if ( nVisTab != nTab )
//STRIP001 		pViewShell->SetTabNo( nTab );
//STRIP001 
//STRIP001 	//	inverse Funktion ausfuehren
//STRIP001 
//STRIP001 	if (bShow)
//STRIP001 		pViewShell->HideOutline( bColumns, nLevel, nEntry, FALSE, FALSE );
//STRIP001 	else
//STRIP001 		pViewShell->ShowOutline( bColumns, nLevel, nEntry, FALSE, FALSE );
//STRIP001 
//STRIP001 	//	Original Spalten-/Zeilenstatus
//STRIP001 
//STRIP001 	if (bColumns)
//STRIP001 		pUndoDoc->CopyToDocument( nStart, 0, nTab, nEnd, MAXROW, nTab, IDF_NONE, FALSE, pDoc );
//STRIP001 	else
//STRIP001 		pUndoDoc->CopyToDocument( 0, nStart, nTab, MAXCOL, nEnd, nTab, IDF_NONE, FALSE, pDoc );
//STRIP001 
//STRIP001 	pViewShell->UpdateScrollBars();
//STRIP001 
//STRIP001 	pDocShell->PostPaint(0,0,nTab,MAXCOL,MAXROW,nTab,PAINT_GRID|PAINT_LEFT|PAINT_TOP);
//STRIP001 
//STRIP001 	EndUndo();
//STRIP001 }

//STRIP001 void __EXPORT ScUndoDoOutline::Redo()
//STRIP001 {
//STRIP001 	BeginRedo();
//STRIP001 
//STRIP001 	ScTabViewShell* pViewShell = ScTabViewShell::GetActiveViewShell();
//STRIP001 
//STRIP001 	//	Tabelle muss vorher umgeschaltet sein (#46952#) !!!
//STRIP001 
//STRIP001 	USHORT nVisTab = pViewShell->GetViewData()->GetTabNo();
//STRIP001 	if ( nVisTab != nTab )
//STRIP001 		pViewShell->SetTabNo( nTab );
//STRIP001 
//STRIP001 	if (bShow)
//STRIP001 		pViewShell->ShowOutline( bColumns, nLevel, nEntry, FALSE );
//STRIP001 	else
//STRIP001 		pViewShell->HideOutline( bColumns, nLevel, nEntry, FALSE );
//STRIP001 
//STRIP001 	EndRedo();
//STRIP001 }

//STRIP001 void __EXPORT ScUndoDoOutline::Repeat(SfxRepeatTarget& rTarget)
//STRIP001 {
//STRIP001 }

//STRIP001 BOOL __EXPORT ScUndoDoOutline::CanRepeat(SfxRepeatTarget& rTarget) const
//STRIP001 {
//STRIP001 	return FALSE;						// geht nicht
//STRIP001 }

//
//		Outline-Gruppen erzeugen oder loeschen
//

//STRIP001 ScUndoMakeOutline::ScUndoMakeOutline( ScDocShell* pNewDocShell,
//STRIP001 							USHORT nStartX, USHORT nStartY, USHORT nStartZ,
//STRIP001 							USHORT nEndX, USHORT nEndY, USHORT nEndZ,
//STRIP001 							ScOutlineTable* pNewUndoTab, BOOL bNewColumns, BOOL bNewMake ) :
//STRIP001 	ScSimpleUndo( pNewDocShell ),
//STRIP001 	aBlockStart( nStartX, nStartY, nStartZ ),
//STRIP001 	aBlockEnd( nEndX, nEndY, nEndZ ),
//STRIP001 	pUndoTable( pNewUndoTab ),
//STRIP001 	bColumns( bNewColumns ),
//STRIP001 	bMake( bNewMake )
//STRIP001 {
//STRIP001 }

//STRIP001 __EXPORT ScUndoMakeOutline::~ScUndoMakeOutline()
//STRIP001 {
//STRIP001 	delete pUndoTable;
//STRIP001 }

//STRIP001 String __EXPORT ScUndoMakeOutline::GetComment() const
//STRIP001 {	// "Gruppierung" "Gruppierung aufheben"
//STRIP001 	return bMake ?
//STRIP001 		ScGlobal::GetRscString( STR_UNDO_MAKEOUTLINE ) :
//STRIP001 		ScGlobal::GetRscString( STR_UNDO_REMAKEOUTLINE );
//STRIP001 }

//STRIP001 void __EXPORT ScUndoMakeOutline::Undo()
//STRIP001 {
//STRIP001 	BeginUndo();
//STRIP001 
//STRIP001 	ScDocument* pDoc = pDocShell->GetDocument();
//STRIP001 	ScTabViewShell* pViewShell = ScTabViewShell::GetActiveViewShell();
//STRIP001 	USHORT nTab = aBlockStart.GetTab();
//STRIP001 
//STRIP001 	ScUndoUtil::MarkSimpleBlock( pDocShell, aBlockStart, aBlockEnd );
//STRIP001 
//STRIP001 	pDoc->SetOutlineTable( nTab, pUndoTable );
//STRIP001 
//STRIP001 	USHORT nVisTab = pViewShell->GetViewData()->GetTabNo();
//STRIP001 	if ( nVisTab != nTab )
//STRIP001 		pViewShell->SetTabNo( nTab );
//STRIP001 
//STRIP001 	pDocShell->PostPaint(0,0,nTab,MAXCOL,MAXROW,nTab,PAINT_GRID|PAINT_LEFT|PAINT_TOP|PAINT_SIZE);
//STRIP001 
//STRIP001 	EndUndo();
//STRIP001 }

//STRIP001 void __EXPORT ScUndoMakeOutline::Redo()
//STRIP001 {
//STRIP001 	BeginRedo();
//STRIP001 
//STRIP001 	ScTabViewShell* pViewShell = ScTabViewShell::GetActiveViewShell();
//STRIP001 
//STRIP001 	ScUndoUtil::MarkSimpleBlock( pDocShell, aBlockStart, aBlockEnd );
//STRIP001 
//STRIP001 	if (bMake)
//STRIP001 		pViewShell->MakeOutline( bColumns, FALSE );
//STRIP001 	else
//STRIP001 		pViewShell->RemoveOutline( bColumns, FALSE );
//STRIP001 
//STRIP001 	pDocShell->PostPaint(0,0,aBlockStart.GetTab(),MAXCOL,MAXROW,aBlockEnd.GetTab(),PAINT_GRID);
//STRIP001 
//STRIP001 	EndRedo();
//STRIP001 }

//STRIP001 void __EXPORT ScUndoMakeOutline::Repeat(SfxRepeatTarget& rTarget)
//STRIP001 {
//STRIP001 	if (rTarget.ISA(ScTabViewTarget))
//STRIP001 	{
//STRIP001 		ScTabViewShell& rViewShell = *((ScTabViewTarget&)rTarget).GetViewShell();
//STRIP001 
//STRIP001 		if (bMake)
//STRIP001 			rViewShell.MakeOutline( bColumns, TRUE );
//STRIP001 		else
//STRIP001 			rViewShell.RemoveOutline( bColumns, TRUE );
//STRIP001 	}
//STRIP001 }

//STRIP001 BOOL __EXPORT ScUndoMakeOutline::CanRepeat(SfxRepeatTarget& rTarget) const
//STRIP001 {
//STRIP001 	return (rTarget.ISA(ScTabViewTarget));
//STRIP001 }

//
//		Outline-Ebene auswaehlen
//

//STRIP001 ScUndoOutlineLevel::ScUndoOutlineLevel( ScDocShell* pNewDocShell,
//STRIP001 						USHORT nNewStart, USHORT nNewEnd, USHORT nNewTab,
//STRIP001 						ScDocument* pNewUndoDoc, ScOutlineTable* pNewUndoTab,
//STRIP001 						BOOL bNewColumns, USHORT nNewLevel ) :
//STRIP001 	ScSimpleUndo( pNewDocShell ),
//STRIP001 	nStart( nNewStart ),
//STRIP001 	nEnd( nNewEnd ),
//STRIP001 	nTab( nNewTab ),
//STRIP001 	pUndoDoc( pNewUndoDoc ),
//STRIP001 	pUndoTable( pNewUndoTab ),
//STRIP001 	bColumns( bNewColumns ),
//STRIP001 	nLevel( nNewLevel )
//STRIP001 {
//STRIP001 }

//STRIP001 __EXPORT ScUndoOutlineLevel::~ScUndoOutlineLevel()
//STRIP001 {
//STRIP001 	delete pUndoDoc;
//STRIP001 	delete pUndoTable;
//STRIP001 }

//STRIP001 String __EXPORT ScUndoOutlineLevel::GetComment() const
//STRIP001 {	// "Gliederungsebene auswaehlen";
//STRIP001 	return ScGlobal::GetRscString( STR_UNDO_OUTLINELEVEL );
//STRIP001 }

//STRIP001 void __EXPORT ScUndoOutlineLevel::Undo()
//STRIP001 {
//STRIP001 	BeginUndo();
//STRIP001 
//STRIP001 	ScDocument* pDoc = pDocShell->GetDocument();
//STRIP001 	ScTabViewShell* pViewShell = ScTabViewShell::GetActiveViewShell();
//STRIP001 
//STRIP001 	//	Original Outline-Table
//STRIP001 
//STRIP001 	pDoc->SetOutlineTable( nTab, pUndoTable );
//STRIP001 
//STRIP001 	//	Original Spalten-/Zeilenstatus
//STRIP001 
//STRIP001 	if (bColumns)
//STRIP001 		pUndoDoc->CopyToDocument( nStart, 0, nTab, nEnd, MAXROW, nTab, IDF_NONE, FALSE, pDoc );
//STRIP001 	else
//STRIP001 		pUndoDoc->CopyToDocument( 0, nStart, nTab, MAXCOL, nEnd, nTab, IDF_NONE, FALSE, pDoc );
//STRIP001 
//STRIP001 	pDoc->UpdatePageBreaks( nTab );
//STRIP001 
//STRIP001 	pViewShell->UpdateScrollBars();
//STRIP001 
//STRIP001 	USHORT nVisTab = pViewShell->GetViewData()->GetTabNo();
//STRIP001 	if ( nVisTab != nTab )
//STRIP001 		pViewShell->SetTabNo( nTab );
//STRIP001 
//STRIP001 	pDocShell->PostPaint(0,0,nTab,MAXCOL,MAXROW,nTab,PAINT_GRID|PAINT_LEFT|PAINT_TOP);
//STRIP001 
//STRIP001 	EndUndo();
//STRIP001 }

//STRIP001 void __EXPORT ScUndoOutlineLevel::Redo()
//STRIP001 {
//STRIP001 	BeginRedo();
//STRIP001 
//STRIP001 	ScTabViewShell* pViewShell = ScTabViewShell::GetActiveViewShell();
//STRIP001 
//STRIP001 	//	Tabelle muss vorher umgeschaltet sein (#46952#) !!!
//STRIP001 
//STRIP001 	USHORT nVisTab = pViewShell->GetViewData()->GetTabNo();
//STRIP001 	if ( nVisTab != nTab )
//STRIP001 		pViewShell->SetTabNo( nTab );
//STRIP001 
//STRIP001 	pViewShell->SelectLevel( bColumns, nLevel, FALSE );
//STRIP001 
//STRIP001 	EndRedo();
//STRIP001 }

//STRIP001 void __EXPORT ScUndoOutlineLevel::Repeat(SfxRepeatTarget& rTarget)
//STRIP001 {
//STRIP001 	if (rTarget.ISA(ScTabViewTarget))
//STRIP001 		((ScTabViewTarget&)rTarget).GetViewShell()->SelectLevel( bColumns, nLevel, TRUE );
//STRIP001 }

//STRIP001 BOOL __EXPORT ScUndoOutlineLevel::CanRepeat(SfxRepeatTarget& rTarget) const
//STRIP001 {
//STRIP001 	return (rTarget.ISA(ScTabViewTarget));
//STRIP001 }

//
//		Outline ueber Blockmarken ein- oder ausblenden
//

//STRIP001 ScUndoOutlineBlock::ScUndoOutlineBlock( ScDocShell* pNewDocShell,
//STRIP001 						USHORT nStartX, USHORT nStartY, USHORT nStartZ,
//STRIP001 						USHORT nEndX, USHORT nEndY, USHORT nEndZ,
//STRIP001 						ScDocument* pNewUndoDoc, ScOutlineTable* pNewUndoTab, BOOL bNewShow ) :
//STRIP001 	ScSimpleUndo( pNewDocShell ),
//STRIP001 	aBlockStart( nStartX, nStartY, nStartZ ),
//STRIP001 	aBlockEnd( nEndX, nEndY, nEndZ ),
//STRIP001 	pUndoDoc( pNewUndoDoc ),
//STRIP001 	pUndoTable( pNewUndoTab ),
//STRIP001 	bShow( bNewShow )
//STRIP001 {
//STRIP001 }

//STRIP001 __EXPORT ScUndoOutlineBlock::~ScUndoOutlineBlock()
//STRIP001 {
//STRIP001 	delete pUndoDoc;
//STRIP001 	delete pUndoTable;
//STRIP001 }

//STRIP001 String __EXPORT ScUndoOutlineBlock::GetComment() const
//STRIP001 {	// "Detail einblenden" "Detail ausblenden"
//STRIP001 	return bShow ?
//STRIP001 		ScGlobal::GetRscString( STR_UNDO_DOOUTLINEBLK ) :
//STRIP001 		ScGlobal::GetRscString( STR_UNDO_REDOOUTLINEBLK );
//STRIP001 }

//STRIP001 void __EXPORT ScUndoOutlineBlock::Undo()
//STRIP001 {
//STRIP001 	BeginUndo();
//STRIP001 
//STRIP001 	ScDocument* pDoc = pDocShell->GetDocument();
//STRIP001 	ScTabViewShell* pViewShell = ScTabViewShell::GetActiveViewShell();
//STRIP001 	USHORT nTab = aBlockStart.GetTab();
//STRIP001 
//STRIP001 	//	Original Outline-Table
//STRIP001 
//STRIP001 	pDoc->SetOutlineTable( nTab, pUndoTable );
//STRIP001 
//STRIP001 	//	Original Spalten-/Zeilenstatus
//STRIP001 
//STRIP001 	USHORT	nStartCol = aBlockStart.GetCol();
//STRIP001 	USHORT	nEndCol = aBlockEnd.GetCol();
//STRIP001 	USHORT	nStartRow = aBlockStart.GetRow();
//STRIP001 	USHORT	nEndRow = aBlockEnd.GetRow();
//STRIP001 
//STRIP001 	if (!bShow)
//STRIP001 	{								//	Groesse des ausgeblendeten Blocks
//STRIP001 		USHORT nLevel;
//STRIP001 		pUndoTable->GetColArray()->FindTouchedLevel( nStartCol, nEndCol, nLevel );
//STRIP001 		pUndoTable->GetColArray()->ExtendBlock( nLevel, nStartCol, nEndCol );
//STRIP001 		pUndoTable->GetRowArray()->FindTouchedLevel( nStartRow, nEndRow, nLevel );
//STRIP001 		pUndoTable->GetRowArray()->ExtendBlock( nLevel, nStartRow, nEndRow );
//STRIP001 	}
//STRIP001 
//STRIP001 	pUndoDoc->CopyToDocument( nStartCol, 0, nTab, nEndCol, MAXROW, nTab, IDF_NONE, FALSE, pDoc );
//STRIP001 	pUndoDoc->CopyToDocument( 0, nStartRow, nTab, MAXCOL, nEndRow, nTab, IDF_NONE, FALSE, pDoc );
//STRIP001 
//STRIP001 	pDoc->UpdatePageBreaks( nTab );
//STRIP001 
//STRIP001 	pViewShell->UpdateScrollBars();
//STRIP001 
//STRIP001 	USHORT nVisTab = pViewShell->GetViewData()->GetTabNo();
//STRIP001 	if ( nVisTab != nTab )
//STRIP001 		pViewShell->SetTabNo( nTab );
//STRIP001 
//STRIP001 	pDocShell->PostPaint(0,0,nTab,MAXCOL,MAXROW,nTab,PAINT_GRID|PAINT_LEFT|PAINT_TOP);
//STRIP001 
//STRIP001 	EndUndo();
//STRIP001 }

//STRIP001 void __EXPORT ScUndoOutlineBlock::Redo()
//STRIP001 {
//STRIP001 	BeginRedo();
//STRIP001 
//STRIP001 	ScTabViewShell* pViewShell = ScTabViewShell::GetActiveViewShell();
//STRIP001 
//STRIP001 	ScUndoUtil::MarkSimpleBlock( pDocShell, aBlockStart, aBlockEnd );
//STRIP001 	if (bShow)
//STRIP001 		pViewShell->ShowMarkedOutlines( FALSE );
//STRIP001 	else
//STRIP001 		pViewShell->HideMarkedOutlines( FALSE );
//STRIP001 
//STRIP001 	EndRedo();
//STRIP001 }

//STRIP001 void __EXPORT ScUndoOutlineBlock::Repeat(SfxRepeatTarget& rTarget)
//STRIP001 {
//STRIP001 	if (rTarget.ISA(ScTabViewTarget))
//STRIP001 	{
//STRIP001 		ScTabViewShell& rViewShell = *((ScTabViewTarget&)rTarget).GetViewShell();
//STRIP001 
//STRIP001 		if (bShow)
//STRIP001 			rViewShell.ShowMarkedOutlines( TRUE );
//STRIP001 		else
//STRIP001 			rViewShell.HideMarkedOutlines( TRUE );
//STRIP001 	}
//STRIP001 }

//STRIP001 BOOL __EXPORT ScUndoOutlineBlock::CanRepeat(SfxRepeatTarget& rTarget) const
//STRIP001 {
//STRIP001 	return (rTarget.ISA(ScTabViewTarget));
//STRIP001 }

//
//		alle Outlines loeschen
//

//STRIP001 ScUndoRemoveAllOutlines::ScUndoRemoveAllOutlines( ScDocShell* pNewDocShell,
//STRIP001 									USHORT nStartX, USHORT nStartY, USHORT nStartZ,
//STRIP001 									USHORT nEndX, USHORT nEndY, USHORT nEndZ,
//STRIP001 									ScDocument* pNewUndoDoc, ScOutlineTable* pNewUndoTab ) :
//STRIP001 	ScSimpleUndo( pNewDocShell ),
//STRIP001 	aBlockStart( nStartX, nStartY, nStartZ ),
//STRIP001 	aBlockEnd( nEndX, nEndY, nEndZ ),
//STRIP001 	pUndoDoc( pNewUndoDoc ),
//STRIP001 	pUndoTable( pNewUndoTab )
//STRIP001 {
//STRIP001 }

//STRIP001 __EXPORT ScUndoRemoveAllOutlines::~ScUndoRemoveAllOutlines()
//STRIP001 {
//STRIP001 	delete pUndoDoc;
//STRIP001 	delete pUndoTable;
//STRIP001 }

//STRIP001 String __EXPORT ScUndoRemoveAllOutlines::GetComment() const
//STRIP001 {	// "Gliederung entfernen"
//STRIP001 	return ScGlobal::GetRscString( STR_UNDO_REMOVEALLOTLNS );
//STRIP001 }

//STRIP001 void __EXPORT ScUndoRemoveAllOutlines::Undo()
//STRIP001 {
//STRIP001 	BeginUndo();
//STRIP001 
//STRIP001 	ScDocument* pDoc = pDocShell->GetDocument();
//STRIP001 	ScTabViewShell* pViewShell = ScTabViewShell::GetActiveViewShell();
//STRIP001 	USHORT nTab = aBlockStart.GetTab();
//STRIP001 
//STRIP001 	//	Original Outline-Table
//STRIP001 
//STRIP001 	pDoc->SetOutlineTable( nTab, pUndoTable );
//STRIP001 
//STRIP001 	//	Original Spalten-/Zeilenstatus
//STRIP001 
//STRIP001 	USHORT	nStartCol = aBlockStart.GetCol();
//STRIP001 	USHORT	nEndCol = aBlockEnd.GetCol();
//STRIP001 	USHORT	nStartRow = aBlockStart.GetRow();
//STRIP001 	USHORT	nEndRow = aBlockEnd.GetRow();
//STRIP001 
//STRIP001 	pUndoDoc->CopyToDocument( nStartCol, 0, nTab, nEndCol, MAXROW, nTab, IDF_NONE, FALSE, pDoc );
//STRIP001 	pUndoDoc->CopyToDocument( 0, nStartRow, nTab, MAXCOL, nEndRow, nTab, IDF_NONE, FALSE, pDoc );
//STRIP001 
//STRIP001 	pDoc->UpdatePageBreaks( nTab );
//STRIP001 
//STRIP001 	pViewShell->UpdateScrollBars();
//STRIP001 
//STRIP001 	USHORT nVisTab = pViewShell->GetViewData()->GetTabNo();
//STRIP001 	if ( nVisTab != nTab )
//STRIP001 		pViewShell->SetTabNo( nTab );
//STRIP001 
//STRIP001 	pDocShell->PostPaint(0,0,nTab,MAXCOL,MAXROW,nTab,PAINT_GRID|PAINT_LEFT|PAINT_TOP|PAINT_SIZE);
//STRIP001 
//STRIP001 	EndUndo();
//STRIP001 }

//STRIP001 void __EXPORT ScUndoRemoveAllOutlines::Redo()
//STRIP001 {
//STRIP001 	BeginRedo();
//STRIP001 
//STRIP001 	ScTabViewShell* pViewShell = ScTabViewShell::GetActiveViewShell();
//STRIP001 
//STRIP001 	//	Tabelle muss vorher umgeschaltet sein (#46952#) !!!
//STRIP001 
//STRIP001 	USHORT nTab = aBlockStart.GetTab();
//STRIP001 	USHORT nVisTab = pViewShell->GetViewData()->GetTabNo();
//STRIP001 	if ( nVisTab != nTab )
//STRIP001 		pViewShell->SetTabNo( nTab );
//STRIP001 
//STRIP001 	pViewShell->RemoveAllOutlines( FALSE );
//STRIP001 
//STRIP001 	EndRedo();
//STRIP001 }

//STRIP001 void __EXPORT ScUndoRemoveAllOutlines::Repeat(SfxRepeatTarget& rTarget)
//STRIP001 {
//STRIP001 	if (rTarget.ISA(ScTabViewTarget))
//STRIP001 		((ScTabViewTarget&)rTarget).GetViewShell()->RemoveAllOutlines( TRUE );
//STRIP001 }

//STRIP001 BOOL __EXPORT ScUndoRemoveAllOutlines::CanRepeat(SfxRepeatTarget& rTarget) const
//STRIP001 {
//STRIP001 	return (rTarget.ISA(ScTabViewTarget));
//STRIP001 }

//
//		Auto-Outline
//

//STRIP001 ScUndoAutoOutline::ScUndoAutoOutline( ScDocShell* pNewDocShell,
//STRIP001 									USHORT nStartX, USHORT nStartY, USHORT nStartZ,
//STRIP001 									USHORT nEndX, USHORT nEndY, USHORT nEndZ,
//STRIP001 									ScDocument* pNewUndoDoc, ScOutlineTable* pNewUndoTab ) :
//STRIP001 	ScSimpleUndo( pNewDocShell ),
//STRIP001 	aBlockStart( nStartX, nStartY, nStartZ ),
//STRIP001 	aBlockEnd( nEndX, nEndY, nEndZ ),
//STRIP001 	pUndoDoc( pNewUndoDoc ),
//STRIP001 	pUndoTable( pNewUndoTab )
//STRIP001 {
//STRIP001 }

//STRIP001 __EXPORT ScUndoAutoOutline::~ScUndoAutoOutline()
//STRIP001 {
//STRIP001 	delete pUndoDoc;
//STRIP001 	delete pUndoTable;
//STRIP001 }

//STRIP001 String __EXPORT ScUndoAutoOutline::GetComment() const
//STRIP001 {	// "Auto-Gliederung"
//STRIP001 	return ScGlobal::GetRscString( STR_UNDO_AUTOOUTLINE );
//STRIP001 }

//STRIP001 void __EXPORT ScUndoAutoOutline::Undo()
//STRIP001 {
//STRIP001 	BeginUndo();
//STRIP001 
//STRIP001 	ScDocument* pDoc = pDocShell->GetDocument();
//STRIP001 	ScTabViewShell* pViewShell = ScTabViewShell::GetActiveViewShell();
//STRIP001 	USHORT nTab = aBlockStart.GetTab();
//STRIP001 
//STRIP001 	//	Original Outline-Table
//STRIP001 
//STRIP001 	pDoc->SetOutlineTable( nTab, pUndoTable );
//STRIP001 
//STRIP001 	//	Original Spalten-/Zeilenstatus
//STRIP001 
//STRIP001 	if (pUndoDoc && pUndoTable)
//STRIP001 	{
//STRIP001 		USHORT nStartCol;
//STRIP001 		USHORT nStartRow;
//STRIP001 		USHORT nEndCol;
//STRIP001 		USHORT nEndRow;
//STRIP001 		pUndoTable->GetColArray()->GetRange( nStartCol, nEndCol );
//STRIP001 		pUndoTable->GetRowArray()->GetRange( nStartRow, nEndRow );
//STRIP001 
//STRIP001 		pUndoDoc->CopyToDocument( nStartCol, 0, nTab, nEndCol, MAXROW, nTab, IDF_NONE, FALSE, pDoc );
//STRIP001 		pUndoDoc->CopyToDocument( 0, nStartRow, nTab, MAXCOL, nEndRow, nTab, IDF_NONE, FALSE, pDoc );
//STRIP001 
//STRIP001 		pViewShell->UpdateScrollBars();
//STRIP001 	}
//STRIP001 
//STRIP001 	USHORT nVisTab = pViewShell->GetViewData()->GetTabNo();
//STRIP001 	if ( nVisTab != nTab )
//STRIP001 		pViewShell->SetTabNo( nTab );
//STRIP001 
//STRIP001 	pDocShell->PostPaint(0,0,nTab,MAXCOL,MAXROW,nTab,PAINT_GRID|PAINT_LEFT|PAINT_TOP|PAINT_SIZE);
//STRIP001 
//STRIP001 	EndUndo();
//STRIP001 }

//STRIP001 void __EXPORT ScUndoAutoOutline::Redo()
//STRIP001 {
//STRIP001 	BeginRedo();
//STRIP001 
//STRIP001 	ScTabViewShell* pViewShell = ScTabViewShell::GetActiveViewShell();
//STRIP001 	ScDocument* pDoc = pDocShell->GetDocument();
//STRIP001 
//STRIP001 	USHORT nTab = aBlockStart.GetTab();
//STRIP001 	if (pViewShell)
//STRIP001 	{
//STRIP001 		//	Tabelle muss vorher umgeschaltet sein (#46952#) !!!
//STRIP001 
//STRIP001 		USHORT nVisTab = pViewShell->GetViewData()->GetTabNo();
//STRIP001 		if ( nVisTab != nTab )
//STRIP001 			pViewShell->SetTabNo( nTab );
//STRIP001 	}
//STRIP001 
//STRIP001 	ScRange aRange( aBlockStart.GetCol(), aBlockStart.GetRow(), nTab,
//STRIP001 					aBlockEnd.GetCol(),   aBlockEnd.GetRow(),   nTab );
//STRIP001 	ScOutlineDocFunc aFunc( *pDocShell );
//STRIP001 	aFunc.AutoOutline( aRange, FALSE, FALSE );
//STRIP001 
//STRIP001 	//	auf der View markieren
//STRIP001 	//	Wenn's beim Aufruf eine Mehrfachselektion war, ist es jetzt der
//STRIP001 	//	umschliessende Bereich...
//STRIP001 
//STRIP001 	if (pViewShell)
//STRIP001 		pViewShell->MarkRange( aRange );
//STRIP001 
//STRIP001 	EndRedo();
//STRIP001 }

//STRIP001 void __EXPORT ScUndoAutoOutline::Repeat(SfxRepeatTarget& rTarget)
//STRIP001 {
//STRIP001 	if (rTarget.ISA(ScTabViewTarget))
//STRIP001 		((ScTabViewTarget&)rTarget).GetViewShell()->AutoOutline( TRUE );
//STRIP001 }

//STRIP001 BOOL __EXPORT ScUndoAutoOutline::CanRepeat(SfxRepeatTarget& rTarget) const
//STRIP001 {
//STRIP001 	return (rTarget.ISA(ScTabViewTarget));
//STRIP001 }

//
//		Zwischenergebnisse
//

//STRIP001 ScUndoSubTotals::ScUndoSubTotals( ScDocShell* pNewDocShell, USHORT nNewTab,
//STRIP001 								const ScSubTotalParam& rNewParam, USHORT nNewEndY,
//STRIP001 								ScDocument* pNewUndoDoc, ScOutlineTable* pNewUndoTab,
//STRIP001 								ScRangeName* pNewUndoRange, ScDBCollection* pNewUndoDB ) :
//STRIP001 	ScSimpleUndo( pNewDocShell ),
//STRIP001 	nTab( nNewTab ),
//STRIP001 	aParam( rNewParam ),
//STRIP001 	nNewEndRow( nNewEndY ),
//STRIP001 	pUndoDoc( pNewUndoDoc ),
//STRIP001 	pUndoTable( pNewUndoTab ),
//STRIP001 	pUndoRange( pNewUndoRange ),
//STRIP001 	pUndoDB( pNewUndoDB )
//STRIP001 {
//STRIP001 }

//STRIP001 __EXPORT ScUndoSubTotals::~ScUndoSubTotals()
//STRIP001 {
//STRIP001 	delete pUndoDoc;
//STRIP001 	delete pUndoTable;
//STRIP001 	delete pUndoRange;
//STRIP001 	delete pUndoDB;
//STRIP001 }

//STRIP001 String __EXPORT ScUndoSubTotals::GetComment() const
//STRIP001 {	// "Teilergebnisse"
//STRIP001 	return ScGlobal::GetRscString( STR_UNDO_SUBTOTALS );
//STRIP001 }

//STRIP001 void __EXPORT ScUndoSubTotals::Undo()
//STRIP001 {
//STRIP001 	BeginUndo();
//STRIP001 
//STRIP001 	ScDocument* pDoc = pDocShell->GetDocument();
//STRIP001 	ScTabViewShell* pViewShell = ScTabViewShell::GetActiveViewShell();
//STRIP001 
//STRIP001 	//	um einzelnen DB-Bereich anzupassen
//STRIP001 /*	ScDBData* pOldDBData = ScUndoUtil::GetOldDBData( pUndoDBData, pDoc, nTab,
//STRIP001 										aParam.nCol1, aParam.nRow1, aParam.nCol2, nNewEndRow );
//STRIP001 */
//STRIP001 
//STRIP001 	if (nNewEndRow > aParam.nRow2)
//STRIP001 	{
//STRIP001 		pDoc->DeleteRow( 0,nTab, MAXCOL,nTab, aParam.nRow2+1, nNewEndRow-aParam.nRow2 );
//STRIP001 	}
//STRIP001 	else if (nNewEndRow < aParam.nRow2)
//STRIP001 	{
//STRIP001 		pDoc->InsertRow( 0,nTab, MAXCOL,nTab, nNewEndRow+1, nNewEndRow-aParam.nRow2 );
//STRIP001 	}
//STRIP001 
//STRIP001 
//STRIP001 	//	Original Outline-Table
//STRIP001 
//STRIP001 	pDoc->SetOutlineTable( nTab, pUndoTable );
//STRIP001 
//STRIP001 	//	Original Spalten-/Zeilenstatus
//STRIP001 
//STRIP001 	if (pUndoDoc && pUndoTable)
//STRIP001 	{
//STRIP001 		USHORT nStartCol;
//STRIP001 		USHORT nStartRow;
//STRIP001 		USHORT nEndCol;
//STRIP001 		USHORT nEndRow;
//STRIP001 		pUndoTable->GetColArray()->GetRange( nStartCol, nEndCol );
//STRIP001 		pUndoTable->GetRowArray()->GetRange( nStartRow, nEndRow );
//STRIP001 
//STRIP001 		pUndoDoc->CopyToDocument( nStartCol, 0, nTab, nEndCol, MAXROW, nTab, IDF_NONE, FALSE, pDoc );
//STRIP001 		pUndoDoc->CopyToDocument( 0, nStartRow, nTab, MAXCOL, nEndRow, nTab, IDF_NONE, FALSE, pDoc );
//STRIP001 
//STRIP001 		pViewShell->UpdateScrollBars();
//STRIP001 	}
//STRIP001 
//STRIP001 	//	Original-Daten & Referenzen
//STRIP001 
//STRIP001 	ScUndoUtil::MarkSimpleBlock( pDocShell, 0, aParam.nRow1+1, nTab,
//STRIP001 											MAXCOL, aParam.nRow2, nTab );
//STRIP001 
//STRIP001 	pDoc->DeleteAreaTab( 0,aParam.nRow1+1, MAXCOL,aParam.nRow2, nTab, IDF_ALL );
//STRIP001 
//STRIP001 	pUndoDoc->CopyToDocument( 0, aParam.nRow1+1, nTab, MAXCOL, aParam.nRow2, nTab,
//STRIP001 															IDF_NONE, FALSE, pDoc );	// Flags
//STRIP001 	pUndoDoc->UndoToDocument( 0, aParam.nRow1+1, nTab, MAXCOL, aParam.nRow2, nTab,
//STRIP001 															IDF_ALL, FALSE, pDoc );
//STRIP001 
//STRIP001 	ScUndoUtil::MarkSimpleBlock( pDocShell, aParam.nCol1,aParam.nRow1,nTab,
//STRIP001 											aParam.nCol2,aParam.nRow2,nTab );
//STRIP001 
//STRIP001 /*	if (pUndoDBData)
//STRIP001 		*pOldDBData = *pUndoDBData;
//STRIP001 */
//STRIP001 	if (pUndoRange)
//STRIP001 		pDoc->SetRangeName( new ScRangeName( *pUndoRange ) );
//STRIP001 	if (pUndoDB)
//STRIP001 		pDoc->SetDBCollection( new ScDBCollection( *pUndoDB ), TRUE );
//STRIP001 
//STRIP001 	USHORT nVisTab = pViewShell->GetViewData()->GetTabNo();
//STRIP001 	if ( nVisTab != nTab )
//STRIP001 		pViewShell->SetTabNo( nTab );
//STRIP001 
//STRIP001 	pDocShell->PostPaint(0,0,nTab,MAXCOL,MAXROW,nTab,PAINT_GRID|PAINT_LEFT|PAINT_TOP|PAINT_SIZE);
//STRIP001 	pDocShell->PostDataChanged();
//STRIP001 
//STRIP001 	EndUndo();
//STRIP001 }

//STRIP001 void __EXPORT ScUndoSubTotals::Redo()
//STRIP001 {
//STRIP001 	BeginRedo();
//STRIP001 
//STRIP001 	ScTabViewShell* pViewShell = ScTabViewShell::GetActiveViewShell();
//STRIP001 	ScDocument* pDoc = pDocShell->GetDocument();
//STRIP001 
//STRIP001 	USHORT nVisTab = pViewShell->GetViewData()->GetTabNo();
//STRIP001 	if ( nVisTab != nTab )
//STRIP001 		pViewShell->SetTabNo( nTab );
//STRIP001 
//STRIP001 	ScUndoUtil::MarkSimpleBlock( pDocShell, aParam.nCol1,aParam.nRow1,nTab,
//STRIP001 											aParam.nCol2,aParam.nRow2,nTab );
//STRIP001 	pViewShell->DoSubTotals( aParam, FALSE );
//STRIP001 
//STRIP001 	EndRedo();
//STRIP001 }

//STRIP001 void __EXPORT ScUndoSubTotals::Repeat(SfxRepeatTarget& rTarget)
//STRIP001 {
//STRIP001 }

//STRIP001 BOOL __EXPORT ScUndoSubTotals::CanRepeat(SfxRepeatTarget& rTarget) const
//STRIP001 {
//STRIP001 	return FALSE;						// geht nicht wegen Spaltennummern
//STRIP001 }

//
//		Sortieren
//

//STRIP001 ScUndoSort::ScUndoSort( ScDocShell* pNewDocShell,
//STRIP001 						USHORT nNewTab, const ScSortParam& rParam,
//STRIP001 						BOOL bQuery, ScDocument* pNewUndoDoc, ScDBCollection* pNewUndoDB,
//STRIP001 						const ScRange* pDest ) :
//STRIP001 	ScSimpleUndo( pNewDocShell ),
//STRIP001 	nTab( nNewTab ),
//STRIP001 	aSortParam( rParam ),
//STRIP001 	bRepeatQuery( bQuery ),
//STRIP001 	pUndoDoc( pNewUndoDoc ),
//STRIP001 	pUndoDB( pNewUndoDB ),
//STRIP001 	bDestArea( FALSE )
//STRIP001 {
//STRIP001 	if ( pDest )
//STRIP001 	{
//STRIP001 		bDestArea = TRUE;
//STRIP001 		aDestRange = *pDest;
//STRIP001 	}
//STRIP001 }

//STRIP001 __EXPORT ScUndoSort::~ScUndoSort()
//STRIP001 {
//STRIP001 	delete pUndoDoc;
//STRIP001 	delete pUndoDB;
//STRIP001 }

//STRIP001 String __EXPORT ScUndoSort::GetComment() const
//STRIP001 {
//STRIP001 	return ScGlobal::GetRscString( STR_UNDO_SORT );
//STRIP001 }

//STRIP001 void __EXPORT ScUndoSort::Undo()
//STRIP001 {
//STRIP001 	BeginUndo();
//STRIP001 
//STRIP001 	ScDocument* pDoc = pDocShell->GetDocument();
//STRIP001 	ScTabViewShell* pViewShell = ScTabViewShell::GetActiveViewShell();
//STRIP001 
//STRIP001 	USHORT nStartCol = aSortParam.nCol1;
//STRIP001 	USHORT nStartRow = aSortParam.nRow1;
//STRIP001 	USHORT nEndCol	 = aSortParam.nCol2;
//STRIP001 	USHORT nEndRow	 = aSortParam.nRow2;
//STRIP001 	USHORT nSortTab  = nTab;
//STRIP001 	if ( !aSortParam.bInplace )
//STRIP001 	{
//STRIP001 		nStartCol = aSortParam.nDestCol;
//STRIP001 		nStartRow = aSortParam.nDestRow;
//STRIP001 		nEndCol   = nStartCol + ( aSortParam.nCol2 - aSortParam.nCol1 );
//STRIP001 		nEndRow   = nStartRow + ( aSortParam.nRow2 - aSortParam.nRow1 );
//STRIP001 		nSortTab  = aSortParam.nDestTab;
//STRIP001 	}
//STRIP001 
//STRIP001 	ScUndoUtil::MarkSimpleBlock( pDocShell, nStartCol, nStartRow, nSortTab,
//STRIP001 								 nEndCol, nEndRow, nSortTab );
//STRIP001 
//STRIP001 	pDoc->DeleteAreaTab( nStartCol,nStartRow, nEndCol,nEndRow, nSortTab, IDF_ALL );
//STRIP001 
//STRIP001 	pUndoDoc->CopyToDocument( nStartCol, nStartRow, nSortTab, nEndCol, nEndRow, nSortTab,
//STRIP001 								IDF_ALL, FALSE, pDoc );
//STRIP001 
//STRIP001 	if (bDestArea)
//STRIP001 	{
//STRIP001 		pDoc->DeleteAreaTab( aDestRange, IDF_ALL );
//STRIP001 		pUndoDoc->CopyToDocument( aDestRange, IDF_ALL, FALSE, pDoc );
//STRIP001 	}
//STRIP001 
//STRIP001 	//	Zeilenhoehen immer (wegen automatischer Anpassung)
//STRIP001 	//!	auf ScBlockUndo umstellen
//STRIP001 //	if (bRepeatQuery)
//STRIP001 		pUndoDoc->CopyToDocument( 0, nStartRow, nSortTab, MAXCOL, nEndRow, nSortTab,
//STRIP001 								IDF_NONE, FALSE, pDoc );
//STRIP001 
//STRIP001 	if (pUndoDB)
//STRIP001 		pDoc->SetDBCollection( new ScDBCollection( *pUndoDB ), TRUE );
//STRIP001 
//STRIP001 	USHORT nVisTab = pViewShell->GetViewData()->GetTabNo();
//STRIP001 	if ( nVisTab != nSortTab )
//STRIP001 		pViewShell->SetTabNo( nSortTab );
//STRIP001 
//STRIP001 	pDocShell->PostPaint(0,0,nTab,MAXCOL,MAXROW,nTab,PAINT_GRID|PAINT_LEFT|PAINT_TOP|PAINT_SIZE);
//STRIP001 	pDocShell->PostDataChanged();
//STRIP001 
//STRIP001 	EndUndo();
//STRIP001 }

//STRIP001 void __EXPORT ScUndoSort::Redo()
//STRIP001 {
//STRIP001 	BeginRedo();
//STRIP001 
//STRIP001 	ScTabViewShell* pViewShell = ScTabViewShell::GetActiveViewShell();
//STRIP001 	ScDocument* pDoc = pDocShell->GetDocument();
//STRIP001 
//STRIP001 	USHORT nVisTab = pViewShell->GetViewData()->GetTabNo();
//STRIP001 	if ( nVisTab != nTab )
//STRIP001 		pViewShell->SetTabNo( nTab );
//STRIP001 
//STRIP001 //	pViewShell->DoneBlockMode();
//STRIP001 //	pViewShell->InitOwnBlockMode();
//STRIP001 //	pViewShell->GetViewData()->GetMarkData() = aMarkData;	// CopyMarksTo
//STRIP001 
//STRIP001 	pViewShell->MarkRange( ScRange( aSortParam.nCol1, aSortParam.nRow1, nTab,
//STRIP001 									  aSortParam.nCol2, aSortParam.nRow2, nTab ) );
//STRIP001 
//STRIP001 	pViewShell->Sort( aSortParam, FALSE );
//STRIP001 
//STRIP001 	//	Quellbereich painten wegen Markierung
//STRIP001 	if ( !aSortParam.bInplace )
//STRIP001 		pDocShell->PostPaint( aSortParam.nCol1, aSortParam.nRow1, nTab,
//STRIP001 							  aSortParam.nCol2, aSortParam.nRow2, nTab, PAINT_GRID );
//STRIP001 
//STRIP001 	EndRedo();
//STRIP001 }

//STRIP001 void __EXPORT ScUndoSort::Repeat(SfxRepeatTarget& rTarget)
//STRIP001 {
//STRIP001 }

//STRIP001 BOOL __EXPORT ScUndoSort::CanRepeat(SfxRepeatTarget& rTarget) const
//STRIP001 {
//STRIP001 	return FALSE;						// geht nicht wegen Spaltennummern
//STRIP001 }

//
//		Filtern
//

//STRIP001 ScUndoQuery::ScUndoQuery( ScDocShell* pNewDocShell, USHORT nNewTab, const ScQueryParam& rParam,
//STRIP001 							ScDocument* pNewUndoDoc, ScDBCollection* pNewUndoDB,
//STRIP001 							const ScRange* pOld, BOOL bSize, const ScRange* pAdvSrc ) :
//STRIP001 	ScSimpleUndo( pNewDocShell ),
//STRIP001 	nTab( nNewTab ),
//STRIP001 	aQueryParam( rParam ),
//STRIP001 	pUndoDoc( pNewUndoDoc ),
//STRIP001 //	pUndoDBData( pNewData )
//STRIP001 	pUndoDB( pNewUndoDB ),
//STRIP001 	bIsAdvanced( FALSE ),
//STRIP001 	bDestArea( FALSE ),
//STRIP001 	bDoSize( bSize )
//STRIP001 {
//STRIP001 	if ( pOld )
//STRIP001 	{
//STRIP001 		bDestArea = TRUE;
//STRIP001 		aOldDest = *pOld;
//STRIP001 	}
//STRIP001 	if ( pAdvSrc )
//STRIP001 	{
//STRIP001 		bIsAdvanced = TRUE;
//STRIP001 		aAdvSource = *pAdvSrc;
//STRIP001 	}
//STRIP001 }

//STRIP001 __EXPORT ScUndoQuery::~ScUndoQuery()
//STRIP001 {
//STRIP001 	delete pUndoDoc;
//STRIP001 //	delete pUndoDBData;
//STRIP001 	delete pUndoDB;
//STRIP001 }

//STRIP001 String __EXPORT ScUndoQuery::GetComment() const
//STRIP001 {	// "Filtern";
//STRIP001 	return ScGlobal::GetRscString( STR_UNDO_QUERY );
//STRIP001 }

//STRIP001 void __EXPORT ScUndoQuery::Undo()
//STRIP001 {
//STRIP001 	BeginUndo();
//STRIP001 
//STRIP001 	ScDocument* pDoc = pDocShell->GetDocument();
//STRIP001 	ScTabViewShell* pViewShell = ScTabViewShell::GetActiveViewShell();
//STRIP001 
//STRIP001 	BOOL bCopy = !aQueryParam.bInplace;
//STRIP001 	USHORT nDestEndCol = 0;
//STRIP001 	USHORT nDestEndRow = 0;
//STRIP001 	if (bCopy)
//STRIP001 	{
//STRIP001 		nDestEndCol = aQueryParam.nDestCol + ( aQueryParam.nCol2-aQueryParam.nCol1 );
//STRIP001 		nDestEndRow = aQueryParam.nDestRow + ( aQueryParam.nRow2-aQueryParam.nRow1 );
//STRIP001 
//STRIP001 		ScDBData* pData = pDoc->GetDBAtCursor( aQueryParam.nDestCol, aQueryParam.nDestRow,
//STRIP001 												aQueryParam.nDestTab, TRUE );
//STRIP001 		if (pData)
//STRIP001 		{
//STRIP001 			ScRange aNewDest;
//STRIP001 			pData->GetArea( aNewDest );
//STRIP001 			nDestEndCol = aNewDest.aEnd.Col();
//STRIP001 			nDestEndRow = aNewDest.aEnd.Row();
//STRIP001 		}
//STRIP001 
//STRIP001 		if ( bDoSize && bDestArea )
//STRIP001 		{
//STRIP001 			//	aDestRange ist der alte Bereich
//STRIP001 			pDoc->FitBlock( ScRange(
//STRIP001 								aQueryParam.nDestCol, aQueryParam.nDestRow, aQueryParam.nDestTab,
//STRIP001 								nDestEndCol, nDestEndRow, aQueryParam.nDestTab ),
//STRIP001 							aOldDest );
//STRIP001 		}
//STRIP001 
//STRIP001 		ScUndoUtil::MarkSimpleBlock( pDocShell,
//STRIP001 									aQueryParam.nDestCol, aQueryParam.nDestRow, aQueryParam.nDestTab,
//STRIP001 									nDestEndCol, nDestEndRow, aQueryParam.nDestTab );
//STRIP001 		pDoc->DeleteAreaTab( aQueryParam.nDestCol, aQueryParam.nDestRow,
//STRIP001 							nDestEndCol, nDestEndRow, aQueryParam.nDestTab, IDF_ALL );
//STRIP001 
//STRIP001 		pViewShell->DoneBlockMode();
//STRIP001 
//STRIP001 		pUndoDoc->CopyToDocument( aQueryParam.nDestCol, aQueryParam.nDestRow, aQueryParam.nDestTab,
//STRIP001 									nDestEndCol, nDestEndRow, aQueryParam.nDestTab,
//STRIP001 									IDF_ALL, FALSE, pDoc );
//STRIP001 		//	Attribute werden immer mitkopiert (#49287#)
//STRIP001 
//STRIP001 		//	Rest von altem Bereich
//STRIP001 		if ( bDestArea && !bDoSize )
//STRIP001 		{
//STRIP001 			pDoc->DeleteAreaTab( aOldDest, IDF_ALL );
//STRIP001 			pUndoDoc->CopyToDocument( aOldDest, IDF_ALL, FALSE, pDoc );
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else
//STRIP001 		pUndoDoc->CopyToDocument( 0, aQueryParam.nRow1, nTab, MAXCOL, aQueryParam.nRow2, nTab,
//STRIP001 										IDF_NONE, FALSE, pDoc );
//STRIP001 
//STRIP001 	if (pUndoDB)
//STRIP001 		pDoc->SetDBCollection( new ScDBCollection( *pUndoDB ), TRUE );
//STRIP001 
//STRIP001 	if (!bCopy)
//STRIP001 		pDoc->UpdatePageBreaks( nTab );
//STRIP001 
//STRIP001 	USHORT nVisTab = pViewShell->GetViewData()->GetTabNo();
//STRIP001 	if ( nVisTab != nTab )
//STRIP001 		pViewShell->SetTabNo( nTab );
//STRIP001 
//STRIP001 		//	Paint
//STRIP001 
//STRIP001 	if (bCopy)
//STRIP001 	{
//STRIP001 		USHORT nEndX = nDestEndCol;
//STRIP001 		USHORT nEndY = nDestEndRow;
//STRIP001 		if (bDestArea)
//STRIP001 		{
//STRIP001 			if ( aOldDest.aEnd.Col() > nEndX )
//STRIP001 				nEndX = aOldDest.aEnd.Col();
//STRIP001 			if ( aOldDest.aEnd.Row() > nEndY )
//STRIP001 				nEndY = aOldDest.aEnd.Row();
//STRIP001 		}
//STRIP001 		if (bDoSize)
//STRIP001 			nEndY = MAXROW;
//STRIP001 		pDocShell->PostPaint( aQueryParam.nDestCol, aQueryParam.nDestRow, aQueryParam.nDestTab,
//STRIP001 									nEndY, nEndY, aQueryParam.nDestTab, PAINT_GRID );
//STRIP001 	}
//STRIP001 	else
//STRIP001 		pDocShell->PostPaint( 0, aQueryParam.nRow1, nTab, MAXCOL, MAXROW, nTab,
//STRIP001 													PAINT_GRID | PAINT_LEFT );
//STRIP001 	pDocShell->PostDataChanged();
//STRIP001 
//STRIP001 	EndUndo();
//STRIP001 }

//STRIP001 void __EXPORT ScUndoQuery::Redo()
//STRIP001 {
//STRIP001 	BeginRedo();
//STRIP001 
//STRIP001 	ScTabViewShell* pViewShell = ScTabViewShell::GetActiveViewShell();
//STRIP001 	ScDocument* pDoc = pDocShell->GetDocument();
//STRIP001 
//STRIP001 	USHORT nVisTab = pViewShell->GetViewData()->GetTabNo();
//STRIP001 	if ( nVisTab != nTab )
//STRIP001 		pViewShell->SetTabNo( nTab );
//STRIP001 
//STRIP001 	if ( bIsAdvanced )
//STRIP001 		pViewShell->Query( aQueryParam, &aAdvSource, FALSE );
//STRIP001 	else
//STRIP001 		pViewShell->Query( aQueryParam, NULL, FALSE );
//STRIP001 
//STRIP001 	EndRedo();
//STRIP001 }

//STRIP001 void __EXPORT ScUndoQuery::Repeat(SfxRepeatTarget& rTarget)
//STRIP001 {
//STRIP001 }

//STRIP001 BOOL __EXPORT ScUndoQuery::CanRepeat(SfxRepeatTarget& rTarget) const
//STRIP001 {
//STRIP001 	return FALSE;						// geht nicht wegen Spaltennummern
//STRIP001 }

//
//		Datenbankbereiche aendern (Dialog)
//

/*N*/ ScUndoDBData::ScUndoDBData( ScDocShell* pNewDocShell,
/*N*/ 							ScDBCollection* pNewUndoColl, ScDBCollection* pNewRedoColl ) :
/*N*/ 	ScSimpleUndo( pNewDocShell ),
/*N*/ 	pUndoColl( pNewUndoColl ),
/*N*/ 	pRedoColl( pNewRedoColl )
/*N*/ {
/*N*/ }

/*N*/ __EXPORT ScUndoDBData::~ScUndoDBData()
/*N*/ {
/*N*/ 	delete pUndoColl;
/*N*/ 	delete pRedoColl;
/*N*/ }

/*N*/ String __EXPORT ScUndoDBData::GetComment() const
/*N*/ {	// "Datenbankbereiche aendern";
/*N*/ 	return ScGlobal::GetRscString( STR_UNDO_DBDATA );
/*N*/ }

//STRIP001 void __EXPORT ScUndoDBData::Undo()
//STRIP001 {
//STRIP001 	BeginUndo();
//STRIP001 
//STRIP001 	ScTabViewShell* pViewShell = ScTabViewShell::GetActiveViewShell();
//STRIP001 	ScDocument* pDoc = pDocShell->GetDocument();
//STRIP001 
//STRIP001 	BOOL bOldAutoCalc = pDoc->GetAutoCalc();
//STRIP001 	pDoc->SetAutoCalc( FALSE );			// unnoetige Berechnungen vermeiden
//STRIP001 	pDoc->CompileDBFormula( TRUE );		// CreateFormulaString
//STRIP001 	pDoc->SetDBCollection( new ScDBCollection(*pUndoColl), TRUE );
//STRIP001 	pDoc->CompileDBFormula( FALSE );	// CompileFormulaString
//STRIP001 	pDoc->SetAutoCalc( bOldAutoCalc );
//STRIP001 
//STRIP001 	SFX_APP()->Broadcast( SfxSimpleHint( SC_HINT_DBAREAS_CHANGED ) );
//STRIP001 
//STRIP001 	EndUndo();
//STRIP001 }

//STRIP001 void __EXPORT ScUndoDBData::Redo()
//STRIP001 {
//STRIP001 	BeginRedo();
//STRIP001 
//STRIP001 	ScTabViewShell* pViewShell = ScTabViewShell::GetActiveViewShell();
//STRIP001 	ScDocument* pDoc = pDocShell->GetDocument();
//STRIP001 
//STRIP001 	BOOL bOldAutoCalc = pDoc->GetAutoCalc();
//STRIP001 	pDoc->SetAutoCalc( FALSE );			// unnoetige Berechnungen vermeiden
//STRIP001 	pDoc->CompileDBFormula( TRUE );		// CreateFormulaString
//STRIP001 	pDoc->SetDBCollection( new ScDBCollection(*pRedoColl), TRUE );
//STRIP001 	pDoc->CompileDBFormula( FALSE );	// CompileFormulaString
//STRIP001 	pDoc->SetAutoCalc( bOldAutoCalc );
//STRIP001 
//STRIP001 	SFX_APP()->Broadcast( SfxSimpleHint( SC_HINT_DBAREAS_CHANGED ) );
//STRIP001 
//STRIP001 	EndRedo();
//STRIP001 }

//STRIP001 void __EXPORT ScUndoDBData::Repeat(SfxRepeatTarget& rTarget)
//STRIP001 {
//STRIP001 }

/*N*/ BOOL __EXPORT ScUndoDBData::CanRepeat(SfxRepeatTarget& rTarget) const
/*N*/ {
/*N*/ 	return FALSE;						// geht nicht
/*N*/ }

//
//		Import
//

//STRIP001 ScUndoImportData::ScUndoImportData( ScDocShell* pNewDocShell, USHORT nNewTab,
//STRIP001 								const ScImportParam& rParam, USHORT nNewEndX, USHORT nNewEndY,
//STRIP001 								USHORT nNewFormula,
//STRIP001 								ScDocument* pNewUndoDoc, ScDocument* pNewRedoDoc,
//STRIP001 								ScDBData* pNewUndoData, ScDBData* pNewRedoData ) :
//STRIP001 	ScSimpleUndo( pNewDocShell ),
//STRIP001 	nTab( nNewTab ),
//STRIP001 	aImportParam( rParam ),
//STRIP001 	nEndCol( nNewEndX ),
//STRIP001 	nEndRow( nNewEndY ),
//STRIP001 	pUndoDoc( pNewUndoDoc ),
//STRIP001 	pRedoDoc( pNewRedoDoc ),
//STRIP001 	pUndoDBData( pNewUndoData ),
//STRIP001 	pRedoDBData( pNewRedoData ),
//STRIP001 	nFormulaCols( nNewFormula ),
//STRIP001 	bRedoFilled( FALSE )
//STRIP001 {
//STRIP001 	// redo doc doesn't contain imported data (but everything else)
//STRIP001 }

//STRIP001 __EXPORT ScUndoImportData::~ScUndoImportData()
//STRIP001 {
//STRIP001 	delete pUndoDoc;
//STRIP001 	delete pRedoDoc;
//STRIP001 	delete pUndoDBData;
//STRIP001 	delete pRedoDBData;
//STRIP001 }

//STRIP001 String __EXPORT ScUndoImportData::GetComment() const
//STRIP001 {	// "Importieren";
//STRIP001 	return ScGlobal::GetRscString( STR_UNDO_IMPORTDATA );
//STRIP001 }

//STRIP001 void __EXPORT ScUndoImportData::Undo()
//STRIP001 {
//STRIP001 	BeginUndo();
//STRIP001 
//STRIP001 	ScDocument* pDoc = pDocShell->GetDocument();
//STRIP001 	ScTabViewShell* pViewShell = ScTabViewShell::GetActiveViewShell();
//STRIP001 
//STRIP001 	ScUndoUtil::MarkSimpleBlock( pDocShell, aImportParam.nCol1,aImportParam.nRow1,nTab,
//STRIP001 														nEndCol,nEndRow,nTab );
//STRIP001 
//STRIP001 	USHORT nTable, nCol1, nRow1, nCol2, nRow2;
//STRIP001 	ScDBData* pCurrentData = NULL;
//STRIP001 	if (pUndoDBData && pRedoDBData)
//STRIP001 	{
//STRIP001 		pRedoDBData->GetArea( nTable, nCol1, nRow1, nCol2, nRow2 );
//STRIP001 		pCurrentData = ScUndoUtil::GetOldDBData( pRedoDBData, pDoc, nTab,
//STRIP001 													nCol1, nRow1, nCol2, nRow2 );
//STRIP001 
//STRIP001 		if ( !bRedoFilled )
//STRIP001 		{
//STRIP001 			//	read redo data from document at first undo
//STRIP001 			//	imported data is deleted later anyway,
//STRIP001 			//	so now delete each column after copying to save memory (#41216#)
//STRIP001 
//STRIP001 			BOOL bOldAutoCalc = pDoc->GetAutoCalc();
//STRIP001 			pDoc->SetAutoCalc( FALSE );				// outside of the loop
//STRIP001 			for (USHORT nCopyCol = nCol1; nCopyCol <= nCol2; nCopyCol++)
//STRIP001 			{
//STRIP001 				pDoc->CopyToDocument( nCopyCol,nRow1,nTab, nCopyCol,nRow2,nTab,
//STRIP001 										IDF_CONTENTS, FALSE, pRedoDoc );
//STRIP001 				pDoc->DeleteAreaTab( nCopyCol,nRow1, nCopyCol,nRow2, nTab, IDF_CONTENTS );
//STRIP001 				pDoc->DoColResize( nTab, nCopyCol, nCopyCol, 0 );
//STRIP001 			}
//STRIP001 			pDoc->SetAutoCalc( bOldAutoCalc );
//STRIP001 			bRedoFilled = TRUE;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	BOOL bMoveCells = pUndoDBData && pRedoDBData &&
//STRIP001 						pRedoDBData->IsDoSize();		// in alt und neu gleich
//STRIP001 	if (bMoveCells)
//STRIP001 	{
//STRIP001 		//	Undo: erst die neuen Daten loeschen, dann FitBlock rueckwaerts
//STRIP001 
//STRIP001 		ScRange aOld, aNew;
//STRIP001 		pUndoDBData->GetArea( aOld );
//STRIP001 		pRedoDBData->GetArea( aNew );
//STRIP001 
//STRIP001 		pDoc->DeleteAreaTab( aNew.aStart.Col(), aNew.aStart.Row(),
//STRIP001 								aNew.aEnd.Col(), aNew.aEnd.Row(), nTab, IDF_ALL );
//STRIP001 
//STRIP001 		aOld.aEnd.SetCol( aOld.aEnd.Col() + nFormulaCols );		// FitBlock auch fuer Formeln
//STRIP001 		aNew.aEnd.SetCol( aNew.aEnd.Col() + nFormulaCols );
//STRIP001 		pDoc->FitBlock( aNew, aOld, FALSE );					// rueckwaerts
//STRIP001 	}
//STRIP001 	else
//STRIP001 		pDoc->DeleteAreaTab( aImportParam.nCol1,aImportParam.nRow1,
//STRIP001 								nEndCol,nEndRow, nTab, IDF_ALL );
//STRIP001 
//STRIP001 	pUndoDoc->CopyToDocument( aImportParam.nCol1,aImportParam.nRow1,nTab,
//STRIP001 								nEndCol+nFormulaCols,nEndRow,nTab,
//STRIP001 								IDF_ALL, FALSE, pDoc );
//STRIP001 
//STRIP001 	if (pCurrentData)
//STRIP001 	{
//STRIP001 		*pCurrentData = *pUndoDBData;
//STRIP001 
//STRIP001 		pUndoDBData->GetArea( nTable, nCol1, nRow1, nCol2, nRow2 );
//STRIP001 		ScUndoUtil::MarkSimpleBlock( pDocShell, nCol1, nRow1, nTable, nCol2, nRow2, nTable );
//STRIP001 	}
//STRIP001 
//STRIP001 // erack! it's broadcasted
//STRIP001 //	pDoc->SetDirty();
//STRIP001 
//STRIP001 	USHORT nVisTab = pViewShell->GetViewData()->GetTabNo();
//STRIP001 	if ( nVisTab != nTab )
//STRIP001 		pViewShell->SetTabNo( nTab );
//STRIP001 
//STRIP001 	if (bMoveCells)
//STRIP001 		pDocShell->PostPaint( 0,0,nTab, MAXCOL,MAXROW,nTab, PAINT_GRID );
//STRIP001 	else
//STRIP001 		pDocShell->PostPaint( aImportParam.nCol1,aImportParam.nRow1,nTab,
//STRIP001 								nEndCol,nEndRow,nTab, PAINT_GRID );
//STRIP001 	pDocShell->PostDataChanged();
//STRIP001 
//STRIP001 	EndUndo();
//STRIP001 }

//STRIP001 void __EXPORT ScUndoImportData::Redo()
//STRIP001 {
//STRIP001 	BeginRedo();
//STRIP001 
//STRIP001 	ScDocument* pDoc = pDocShell->GetDocument();
//STRIP001 	ScTabViewShell* pViewShell = ScTabViewShell::GetActiveViewShell();
//STRIP001 
//STRIP001 	ScUndoUtil::MarkSimpleBlock( pDocShell, aImportParam.nCol1,aImportParam.nRow1,nTab,
//STRIP001 														nEndCol,nEndRow,nTab );
//STRIP001 
//STRIP001 	USHORT nTable, nCol1, nRow1, nCol2, nRow2;
//STRIP001 	ScDBData* pCurrentData = NULL;
//STRIP001 	if (pUndoDBData && pRedoDBData)
//STRIP001 	{
//STRIP001 		pUndoDBData->GetArea( nTable, nCol1, nRow1, nCol2, nRow2 );
//STRIP001 		pCurrentData = ScUndoUtil::GetOldDBData( pUndoDBData, pDoc, nTab,
//STRIP001 													nCol1, nRow1, nCol2, nRow2 );
//STRIP001 	}
//STRIP001 	BOOL bMoveCells = pUndoDBData && pRedoDBData &&
//STRIP001 						pRedoDBData->IsDoSize();		// in alt und neu gleich
//STRIP001 	if (bMoveCells)
//STRIP001 	{
//STRIP001 		//	Redo: FitBlock, dann Daten loeschen (noetig fuer CopyToDocument)
//STRIP001 
//STRIP001 		ScRange aOld, aNew;
//STRIP001 		pUndoDBData->GetArea( aOld );
//STRIP001 		pRedoDBData->GetArea( aNew );
//STRIP001 
//STRIP001 		aOld.aEnd.SetCol( aOld.aEnd.Col() + nFormulaCols );		// FitBlock auch fuer Formeln
//STRIP001 		aNew.aEnd.SetCol( aNew.aEnd.Col() + nFormulaCols );
//STRIP001 		pDoc->FitBlock( aOld, aNew );
//STRIP001 
//STRIP001 		pDoc->DeleteAreaTab( aNew.aStart.Col(), aNew.aStart.Row(),
//STRIP001 								aNew.aEnd.Col(), aNew.aEnd.Row(), nTab, IDF_ALL );
//STRIP001 
//STRIP001 		pRedoDoc->CopyToDocument( aNew, IDF_ALL, FALSE, pDoc );		// incl. Formeln
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		pDoc->DeleteAreaTab( aImportParam.nCol1,aImportParam.nRow1,
//STRIP001 								nEndCol,nEndRow, nTab, IDF_ALL );
//STRIP001 		pRedoDoc->CopyToDocument( aImportParam.nCol1,aImportParam.nRow1,nTab,
//STRIP001 								nEndCol,nEndRow,nTab, IDF_ALL, FALSE, pDoc );
//STRIP001 	}
//STRIP001 
//STRIP001 	if (pCurrentData)
//STRIP001 	{
//STRIP001 		*pCurrentData = *pRedoDBData;
//STRIP001 
//STRIP001 		pRedoDBData->GetArea( nTable, nCol1, nRow1, nCol2, nRow2 );
//STRIP001 		ScUndoUtil::MarkSimpleBlock( pDocShell, nCol1, nRow1, nTable, nCol2, nRow2, nTable );
//STRIP001 	}
//STRIP001 
//STRIP001 // erack! it's broadcasted
//STRIP001 //	pDoc->SetDirty();
//STRIP001 
//STRIP001 	USHORT nVisTab = pViewShell->GetViewData()->GetTabNo();
//STRIP001 	if ( nVisTab != nTab )
//STRIP001 		pViewShell->SetTabNo( nTab );
//STRIP001 
//STRIP001 	if (bMoveCells)
//STRIP001 		pDocShell->PostPaint( 0,0,nTab, MAXCOL,MAXROW,nTab, PAINT_GRID );
//STRIP001 	else
//STRIP001 		pDocShell->PostPaint( aImportParam.nCol1,aImportParam.nRow1,nTab,
//STRIP001 								nEndCol,nEndRow,nTab, PAINT_GRID );
//STRIP001 	pDocShell->PostDataChanged();
//STRIP001 
//STRIP001 	EndRedo();
//STRIP001 }

//STRIP001 void __EXPORT ScUndoImportData::Repeat(SfxRepeatTarget& rTarget)
//STRIP001 {
//STRIP001 	if (rTarget.ISA(ScTabViewTarget))
//STRIP001 	{
//STRIP001 		ScTabViewShell& rViewShell = *((ScTabViewTarget&)rTarget).GetViewShell();
//STRIP001 
//STRIP001 		USHORT nDummy;
//STRIP001 		ScImportParam aNewParam(aImportParam);
//STRIP001 		ScDBData* pDBData = rViewShell.GetDBData();
//STRIP001 		pDBData->GetArea( nDummy, aNewParam.nCol1,aNewParam.nRow1, aNewParam.nCol2,aNewParam.nRow2 );
//STRIP001 
//STRIP001 		rViewShell.ImportData( aNewParam );
//STRIP001 	}
//STRIP001 }

//STRIP001 BOOL __EXPORT ScUndoImportData::CanRepeat(SfxRepeatTarget& rTarget) const
//STRIP001 {
//STRIP001 	//	Repeat nur fuer Import per DB-Bereich, dann ist pUndoDBData gesetzt
//STRIP001 
//STRIP001 	if (pUndoDBData)
//STRIP001 		return (rTarget.ISA(ScTabViewTarget));
//STRIP001 	else
//STRIP001 		return FALSE;		// Adressbuch
//STRIP001 }

//
//		Operationen wiederholen
//

//STRIP001 ScUndoRepeatDB::ScUndoRepeatDB( ScDocShell* pNewDocShell, USHORT nNewTab,
//STRIP001 								USHORT nStartX, USHORT nStartY, USHORT nEndX, USHORT nEndY,
//STRIP001 								USHORT nResultEndRow, USHORT nCurX, USHORT nCurY,
//STRIP001 								ScDocument* pNewUndoDoc, ScOutlineTable* pNewUndoTab,
//STRIP001 								ScRangeName* pNewUndoRange, ScDBCollection* pNewUndoDB,
//STRIP001 								const ScRange* pOldQ, const ScRange* pNewQ ) :
//STRIP001 	ScSimpleUndo( pNewDocShell ),
//STRIP001 	aBlockStart( nStartX,nStartY,nNewTab ),
//STRIP001 	aBlockEnd( nEndX,nEndY,nNewTab ),
//STRIP001 	nNewEndRow( nResultEndRow ),
//STRIP001 	aCursorPos( nCurX,nCurY,nNewTab ),
//STRIP001 	pUndoDoc( pNewUndoDoc ),
//STRIP001 	pUndoTable( pNewUndoTab ),
//STRIP001 	pUndoRange( pNewUndoRange ),
//STRIP001 	pUndoDB( pNewUndoDB ),
//STRIP001 	bQuerySize( FALSE )
//STRIP001 {
//STRIP001 	if ( pOldQ && pNewQ )
//STRIP001 	{
//STRIP001 		aOldQuery = *pOldQ;
//STRIP001 		aNewQuery = *pNewQ;
//STRIP001 		bQuerySize = TRUE;;
//STRIP001 	}
//STRIP001 }

//STRIP001 __EXPORT ScUndoRepeatDB::~ScUndoRepeatDB()
//STRIP001 {
//STRIP001 	delete pUndoDoc;
//STRIP001 	delete pUndoTable;
//STRIP001 	delete pUndoRange;
//STRIP001 	delete pUndoDB;
//STRIP001 }

//STRIP001 String __EXPORT ScUndoRepeatDB::GetComment() const
//STRIP001 {	// "Wiederholen";       //! bessere Beschreibung!
//STRIP001 	return ScGlobal::GetRscString( STR_UNDO_REPEATDB );
//STRIP001 }

//STRIP001 void __EXPORT ScUndoRepeatDB::Undo()
//STRIP001 {
//STRIP001 	BeginUndo();
//STRIP001 
//STRIP001 	ScDocument* pDoc = pDocShell->GetDocument();
//STRIP001 	ScTabViewShell* pViewShell = ScTabViewShell::GetActiveViewShell();
//STRIP001 	USHORT nTab = aBlockStart.GetTab();
//STRIP001 
//STRIP001 	if (bQuerySize)
//STRIP001 	{
//STRIP001 		pDoc->FitBlock( aNewQuery, aOldQuery, FALSE );
//STRIP001 
//STRIP001 		if ( aNewQuery.aEnd.Col() == aOldQuery.aEnd.Col() )
//STRIP001 		{
//STRIP001 			USHORT nFormulaCols = 0;
//STRIP001 			USHORT nCol = aOldQuery.aEnd.Col() + 1;
//STRIP001 			USHORT nRow = aOldQuery.aStart.Row() + 1;		//! Header testen
//STRIP001 			while ( nCol <= MAXCOL &&
//STRIP001 					pDoc->GetCellType(ScAddress( nCol, nRow, nTab )) == CELLTYPE_FORMULA )
//STRIP001 				++nCol, ++nFormulaCols;
//STRIP001 
//STRIP001 			if ( nFormulaCols )
//STRIP001 			{
//STRIP001 				ScRange aOldForm = aOldQuery;
//STRIP001 				aOldForm.aStart.SetCol( aOldQuery.aEnd.Col() + 1 );
//STRIP001 				aOldForm.aEnd.SetCol( aOldQuery.aEnd.Col() + nFormulaCols );
//STRIP001 				ScRange aNewForm = aOldForm;
//STRIP001 				aNewForm.aEnd.SetRow( aNewQuery.aEnd.Row() );
//STRIP001 				pDoc->FitBlock( aNewForm, aOldForm, FALSE );
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	//!		Daten von Filter in anderen Bereich fehlen noch	!!!!!!!!!!!!!!!!!
//STRIP001 
//STRIP001 	if (nNewEndRow > aBlockEnd.GetRow())
//STRIP001 	{
//STRIP001 		pDoc->DeleteRow( 0,nTab, MAXCOL,nTab, aBlockEnd.GetRow()+1, nNewEndRow-aBlockEnd.GetRow() );
//STRIP001 	}
//STRIP001 	else if (nNewEndRow < aBlockEnd.GetRow())
//STRIP001 	{
//STRIP001 		pDoc->InsertRow( 0,nTab, MAXCOL,nTab, nNewEndRow+1, nNewEndRow-aBlockEnd.GetRow() );
//STRIP001 	}
//STRIP001 
//STRIP001 	//	Original Outline-Table
//STRIP001 
//STRIP001 	pDoc->SetOutlineTable( nTab, pUndoTable );
//STRIP001 
//STRIP001 	//	Original Spalten-/Zeilenstatus
//STRIP001 
//STRIP001 	if (pUndoDoc && pUndoTable)
//STRIP001 	{
//STRIP001 		USHORT nStartCol;
//STRIP001 		USHORT nStartRow;
//STRIP001 		USHORT nEndCol;
//STRIP001 		USHORT nEndRow;
//STRIP001 		pUndoTable->GetColArray()->GetRange( nStartCol, nEndCol );
//STRIP001 		pUndoTable->GetRowArray()->GetRange( nStartRow, nEndRow );
//STRIP001 
//STRIP001 		pUndoDoc->CopyToDocument( nStartCol, 0, nTab, nEndCol, MAXROW, nTab, IDF_NONE, FALSE, pDoc );
//STRIP001 		pUndoDoc->CopyToDocument( 0, nStartRow, nTab, MAXCOL, nEndRow, nTab, IDF_NONE, FALSE, pDoc );
//STRIP001 
//STRIP001 		pViewShell->UpdateScrollBars();
//STRIP001 	}
//STRIP001 
//STRIP001 	//	Original-Daten & Referenzen
//STRIP001 
//STRIP001 	ScUndoUtil::MarkSimpleBlock( pDocShell, 0, aBlockStart.GetRow(), nTab,
//STRIP001 											MAXCOL, aBlockEnd.GetRow(), nTab );
//STRIP001 	pDoc->DeleteAreaTab( 0, aBlockStart.GetRow(),
//STRIP001 							MAXCOL, aBlockEnd.GetRow(), nTab, IDF_ALL );
//STRIP001 
//STRIP001 	pUndoDoc->CopyToDocument( 0, aBlockStart.GetRow(), nTab, MAXCOL, aBlockEnd.GetRow(), nTab,
//STRIP001 															IDF_NONE, FALSE, pDoc );			// Flags
//STRIP001 	pUndoDoc->UndoToDocument( 0, aBlockStart.GetRow(), nTab, MAXCOL, aBlockEnd.GetRow(), nTab,
//STRIP001 															IDF_ALL, FALSE, pDoc );
//STRIP001 
//STRIP001 	ScUndoUtil::MarkSimpleBlock( pDocShell, aBlockStart.GetCol(),aBlockStart.GetRow(),nTab,
//STRIP001 											aBlockEnd.GetCol(),aBlockEnd.GetRow(),nTab );
//STRIP001 
//STRIP001 	if (pUndoRange)
//STRIP001 		pDoc->SetRangeName( new ScRangeName( *pUndoRange ) );
//STRIP001 	if (pUndoDB)
//STRIP001 		pDoc->SetDBCollection( new ScDBCollection( *pUndoDB ), TRUE );
//STRIP001 
//STRIP001 // erack! it's broadcasted
//STRIP001 //	pDoc->SetDirty();
//STRIP001 
//STRIP001 	USHORT nVisTab = pViewShell->GetViewData()->GetTabNo();
//STRIP001 	if ( nVisTab != nTab )
//STRIP001 		pViewShell->SetTabNo( nTab );
//STRIP001 
//STRIP001 	pDocShell->PostPaint(0,0,nTab,MAXCOL,MAXROW,nTab,PAINT_GRID|PAINT_LEFT|PAINT_TOP|PAINT_SIZE);
//STRIP001 	pDocShell->PostDataChanged();
//STRIP001 
//STRIP001 	EndUndo();
//STRIP001 }

//STRIP001 void __EXPORT ScUndoRepeatDB::Redo()
//STRIP001 {
//STRIP001 	BeginRedo();
//STRIP001 
//STRIP001 	ScTabViewShell* pViewShell = ScTabViewShell::GetActiveViewShell();
//STRIP001 	USHORT nTab = aBlockStart.GetTab();
//STRIP001 
//STRIP001 	USHORT nVisTab = pViewShell->GetViewData()->GetTabNo();
//STRIP001 	if ( nVisTab != nTab )
//STRIP001 		pViewShell->SetTabNo( nTab );
//STRIP001 
//STRIP001 	ScUndoUtil::MarkSimpleBlock( pDocShell, aBlockStart.GetCol(),aBlockStart.GetRow(),nTab,
//STRIP001 											aBlockEnd.GetCol(),aBlockEnd.GetRow(),nTab );
//STRIP001 	pViewShell->SetCursor( aCursorPos.GetCol(), aCursorPos.GetRow() );
//STRIP001 
//STRIP001 	pViewShell->RepeatDB( FALSE );
//STRIP001 
//STRIP001 	EndRedo();
//STRIP001 }

//STRIP001 void __EXPORT ScUndoRepeatDB::Repeat(SfxRepeatTarget& rTarget)
//STRIP001 {
//STRIP001 	if (rTarget.ISA(ScTabViewTarget))
//STRIP001 		((ScTabViewTarget&)rTarget).GetViewShell()->RepeatDB( TRUE );
//STRIP001 }

//STRIP001 BOOL __EXPORT ScUndoRepeatDB::CanRepeat(SfxRepeatTarget& rTarget) const
//STRIP001 {
//STRIP001 	return (rTarget.ISA(ScTabViewTarget));
//STRIP001 }

//
//		Pivot-Tabellen
//

//STRIP001 ScUndoPivot::ScUndoPivot( ScDocShell* pNewDocShell,
//STRIP001 							const ScArea& rOld, const ScArea& rNew,
//STRIP001 							ScDocument* pOldDoc, ScDocument* pNewDoc,
//STRIP001 							const ScPivot* pOldPivot, const ScPivot* pNewPivot ) :
//STRIP001 	ScSimpleUndo( pNewDocShell ),
//STRIP001 	aOldArea( rOld ),
//STRIP001 	aNewArea( rNew ),
//STRIP001 	pOldUndoDoc( pOldDoc ),
//STRIP001 	pNewUndoDoc( pNewDoc )
//STRIP001 {
//STRIP001 	if (pNewPivot)
//STRIP001 	{
//STRIP001 		pNewPivot->GetParam( aNewParam, aNewQuery, aNewSrc );
//STRIP001 		aNewName = pNewPivot->GetName();
//STRIP001 		aNewTag = pNewPivot->GetTag();
//STRIP001 	}
//STRIP001 	if (pOldPivot)
//STRIP001 	{
//STRIP001 		pOldPivot->GetParam( aOldParam, aOldQuery, aOldSrc );
//STRIP001 		aOldName = pOldPivot->GetName();
//STRIP001 		aOldTag = pOldPivot->GetTag();
//STRIP001 	}
//STRIP001 }

//STRIP001 __EXPORT ScUndoPivot::~ScUndoPivot()
//STRIP001 {
//STRIP001 	delete pOldUndoDoc;
//STRIP001 	delete pNewUndoDoc;
//STRIP001 }

//STRIP001 String __EXPORT ScUndoPivot::GetComment() const
//STRIP001 {
//STRIP001 	USHORT nIndex;
//STRIP001 	if ( pOldUndoDoc && pNewUndoDoc )
//STRIP001 		nIndex = STR_UNDO_PIVOT_MODIFY;
//STRIP001 	else if ( pNewUndoDoc )
//STRIP001 		nIndex = STR_UNDO_PIVOT_NEW;
//STRIP001 	else
//STRIP001 		nIndex = STR_UNDO_PIVOT_DELETE;
//STRIP001 
//STRIP001 	return ScGlobal::GetRscString( nIndex );
//STRIP001 }

//STRIP001 void __EXPORT ScUndoPivot::Undo()
//STRIP001 {
//STRIP001 	BeginUndo();
//STRIP001 
//STRIP001 	ScDocument* pDoc = pDocShell->GetDocument();
//STRIP001 
//STRIP001 	if (pNewUndoDoc)
//STRIP001 	{
//STRIP001 		pDoc->DeleteAreaTab( aNewArea.nColStart,aNewArea.nRowStart,
//STRIP001 							aNewArea.nColEnd,aNewArea.nRowEnd, aNewArea.nTab, IDF_ALL );
//STRIP001 		pNewUndoDoc->CopyToDocument( aNewArea.nColStart, aNewArea.nRowStart, aNewArea.nTab,
//STRIP001 								aNewArea.nColEnd, aNewArea.nRowEnd, aNewArea.nTab,
//STRIP001 								IDF_ALL, FALSE, pDoc );
//STRIP001 	}
//STRIP001 	if (pOldUndoDoc)
//STRIP001 	{
//STRIP001 		pDoc->DeleteAreaTab( aOldArea.nColStart,aOldArea.nRowStart,
//STRIP001 							aOldArea.nColEnd,aOldArea.nRowEnd, aOldArea.nTab, IDF_ALL );
//STRIP001 		pOldUndoDoc->CopyToDocument( aOldArea.nColStart, aOldArea.nRowStart, aOldArea.nTab,
//STRIP001 								aOldArea.nColEnd, aOldArea.nRowEnd, aOldArea.nTab,
//STRIP001 								IDF_ALL, FALSE, pDoc );
//STRIP001 	}
//STRIP001 
//STRIP001 	ScPivotCollection* pPivotCollection = pDoc->GetPivotCollection();
//STRIP001 	if ( pNewUndoDoc )
//STRIP001 	{
//STRIP001 		ScPivot* pNewPivot = pPivotCollection->GetPivotAtCursor(
//STRIP001 								aNewParam.nCol, aNewParam.nRow, aNewParam.nTab );
//STRIP001 		if (pNewPivot)
//STRIP001 			pPivotCollection->Free( pNewPivot );
//STRIP001 	}
//STRIP001 	if ( pOldUndoDoc )
//STRIP001 	{
//STRIP001 		ScPivot* pOldPivot = new ScPivot( pDoc );
//STRIP001 		pOldPivot->SetParam( aOldParam, aOldQuery, aOldSrc );
//STRIP001 		pOldPivot->SetName( aOldName );
//STRIP001 		pOldPivot->SetTag( aOldTag );
//STRIP001 		if (pOldPivot->CreateData())							// Felder berechnen
//STRIP001 			pOldPivot->ReleaseData();
//STRIP001 		pPivotCollection->Insert( pOldPivot );
//STRIP001 	}
//STRIP001 
//STRIP001 // erack! it's broadcasted
//STRIP001 //	pDoc->SetDirty();
//STRIP001 	if (pNewUndoDoc)
//STRIP001 		pDocShell->PostPaint( aNewArea.nColStart, aNewArea.nRowStart, aNewArea.nTab,
//STRIP001 								aNewArea.nColEnd, aNewArea.nRowEnd, aNewArea.nTab,
//STRIP001 								PAINT_GRID, SC_PF_LINES );
//STRIP001 	if (pOldUndoDoc)
//STRIP001 		pDocShell->PostPaint( aOldArea.nColStart, aOldArea.nRowStart, aOldArea.nTab,
//STRIP001 								aOldArea.nColEnd, aOldArea.nRowEnd, aOldArea.nTab,
//STRIP001 								PAINT_GRID, SC_PF_LINES );
//STRIP001 	pDocShell->PostDataChanged();
//STRIP001 
//STRIP001 	ScTabViewShell* pViewShell = ScTabViewShell::GetActiveViewShell();
//STRIP001 	if (pViewShell)
//STRIP001 	{
//STRIP001 		USHORT nTab = pViewShell->GetViewData()->GetTabNo();
//STRIP001 		if ( pOldUndoDoc )
//STRIP001 		{
//STRIP001 			if ( nTab != aOldArea.nTab )
//STRIP001 				pViewShell->SetTabNo( aOldArea.nTab );
//STRIP001 		}
//STRIP001 		else if ( pNewUndoDoc )
//STRIP001 		{
//STRIP001 			if ( nTab != aNewArea.nTab )
//STRIP001 				pViewShell->SetTabNo( aNewArea.nTab );
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	EndUndo();
//STRIP001 }

//STRIP001 void __EXPORT ScUndoPivot::Redo()
//STRIP001 {
//STRIP001 	BeginRedo();
//STRIP001 
//STRIP001 	ScDocument* pDoc = pDocShell->GetDocument();
//STRIP001 	ScPivotCollection* pPivotCollection = pDoc->GetPivotCollection();
//STRIP001 	ScPivot* pOldPivot = pPivotCollection->GetPivotAtCursor(
//STRIP001 											aOldParam.nCol, aOldParam.nRow, aOldParam.nTab );
//STRIP001 
//STRIP001 	ScPivot* pNewPivot = NULL;
//STRIP001 	if (pNewUndoDoc)
//STRIP001 	{
//STRIP001 		pNewPivot = new ScPivot( pDoc );
//STRIP001 		pNewPivot->SetParam( aNewParam, aNewQuery, aNewSrc );
//STRIP001 		pNewPivot->SetName( aNewName );
//STRIP001 		pNewPivot->SetTag( aNewTag );
//STRIP001 	}
//STRIP001 
//STRIP001 	pDocShell->PivotUpdate( pOldPivot, pNewPivot, FALSE );
//STRIP001 
//STRIP001 	EndRedo();
//STRIP001 }

//STRIP001 void __EXPORT ScUndoPivot::Repeat(SfxRepeatTarget& rTarget)
//STRIP001 {
//STRIP001 	//	Wiederholen: nur loeschen
//STRIP001 
//STRIP001 	if ( pOldUndoDoc && !pNewUndoDoc && rTarget.ISA(ScTabViewTarget) )
//STRIP001 		((ScTabViewTarget&)rTarget).GetViewShell()->DeletePivotTable();
//STRIP001 }

//STRIP001 BOOL __EXPORT ScUndoPivot::CanRepeat(SfxRepeatTarget& rTarget) const
//STRIP001 {
//STRIP001 	//	Wiederholen: nur loeschen
//STRIP001 
//STRIP001 	return ( pOldUndoDoc && !pNewUndoDoc && rTarget.ISA(ScTabViewTarget) );
//STRIP001 }


//
//		data pilot
//

//STRIP001 ScUndoDataPilot::ScUndoDataPilot( ScDocShell* pNewDocShell,
//STRIP001 							ScDocument* pOldDoc, ScDocument* pNewDoc,
//STRIP001 							const ScDPObject* pOldObj, const ScDPObject* pNewObj ) :
//STRIP001 	ScSimpleUndo( pNewDocShell ),
//STRIP001 	pOldDPObject( NULL ),
//STRIP001 	pNewDPObject( NULL ),
//STRIP001 	pOldUndoDoc( pOldDoc ),
//STRIP001 	pNewUndoDoc( pNewDoc )
//STRIP001 {
//STRIP001 	if (pOldObj)
//STRIP001 		pOldDPObject = new ScDPObject( *pOldObj );
//STRIP001 	if (pNewObj)
//STRIP001 		pNewDPObject = new ScDPObject( *pNewObj );
//STRIP001 }

//STRIP001 __EXPORT ScUndoDataPilot::~ScUndoDataPilot()
//STRIP001 {
//STRIP001 	delete pOldDPObject;
//STRIP001 	delete pNewDPObject;
//STRIP001 	delete pOldUndoDoc;
//STRIP001 	delete pNewUndoDoc;
//STRIP001 }

//STRIP001 String __EXPORT ScUndoDataPilot::GetComment() const
//STRIP001 {
//STRIP001 	USHORT nIndex;
//STRIP001 	if ( pOldUndoDoc && pNewUndoDoc )
//STRIP001 		nIndex = STR_UNDO_PIVOT_MODIFY;
//STRIP001 	else if ( pNewUndoDoc )
//STRIP001 		nIndex = STR_UNDO_PIVOT_NEW;
//STRIP001 	else
//STRIP001 		nIndex = STR_UNDO_PIVOT_DELETE;
//STRIP001 
//STRIP001 	return ScGlobal::GetRscString( nIndex );
//STRIP001 }

//STRIP001 void __EXPORT ScUndoDataPilot::Undo()
//STRIP001 {
//STRIP001 	BeginUndo();
//STRIP001 
//STRIP001 	ScDocument* pDoc = pDocShell->GetDocument();
//STRIP001 
//STRIP001 	ScRange aOldRange;
//STRIP001 	ScRange aNewRange;
//STRIP001 
//STRIP001 	if ( pNewDPObject && pNewUndoDoc )
//STRIP001 	{
//STRIP001 		aNewRange = pNewDPObject->GetOutRange();
//STRIP001 		pDoc->DeleteAreaTab( aNewRange, IDF_ALL );
//STRIP001 		pNewUndoDoc->CopyToDocument( aNewRange, IDF_ALL, FALSE, pDoc );
//STRIP001 	}
//STRIP001 	if ( pOldDPObject && pOldUndoDoc )
//STRIP001 	{
//STRIP001 		aOldRange = pOldDPObject->GetOutRange();
//STRIP001 		pDoc->DeleteAreaTab( aOldRange, IDF_ALL );
//STRIP001 		pOldUndoDoc->CopyToDocument( aOldRange, IDF_ALL, FALSE, pDoc );
//STRIP001 	}
//STRIP001 
//STRIP001 	//	update objects in collection
//STRIP001 
//STRIP001 	if ( pNewDPObject )
//STRIP001 	{
//STRIP001 		//	find updated object
//STRIP001 		//!	find by name!
//STRIP001 
//STRIP001 		ScDPObject* pDocObj = pDoc->GetDPAtCursor(
//STRIP001 							aNewRange.aStart.Col(), aNewRange.aStart.Row(), aNewRange.aStart.Tab() );
//STRIP001 		DBG_ASSERT(pDocObj, "DPObject not found");
//STRIP001 		if (pDocObj)
//STRIP001 		{
//STRIP001 			if ( pOldDPObject )
//STRIP001 			{
//STRIP001 				//	restore old settings
//STRIP001 				pOldDPObject->WriteSourceDataTo( *pDocObj );
//STRIP001 				ScDPSaveData* pData = pOldDPObject->GetSaveData();
//STRIP001 				if (pData)
//STRIP001 					pDocObj->SetSaveData(*pData);
//STRIP001 				pDocObj->SetOutRange( pOldDPObject->GetOutRange() );
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				//	delete inserted object
//STRIP001 				pDoc->GetDPCollection()->Free(pDocObj);
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else if ( pOldDPObject )
//STRIP001 	{
//STRIP001 		//	re-insert deleted object
//STRIP001 
//STRIP001 		ScDPObject* pDestObj = new ScDPObject( *pOldDPObject );
//STRIP001 		pDestObj->SetAlive(TRUE);
//STRIP001 		if ( !pDoc->GetDPCollection()->Insert(pDestObj) )
//STRIP001 		{
//STRIP001 			DBG_ERROR("cannot insert DPObject");
//STRIP001 			DELETEZ( pDestObj );
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	if (pNewUndoDoc)
//STRIP001 		pDocShell->PostPaint( aNewRange, PAINT_GRID, SC_PF_LINES );
//STRIP001 	if (pOldUndoDoc)
//STRIP001 		pDocShell->PostPaint( aOldRange, PAINT_GRID, SC_PF_LINES );
//STRIP001 	pDocShell->PostDataChanged();
//STRIP001 
//STRIP001 	ScTabViewShell* pViewShell = ScTabViewShell::GetActiveViewShell();
//STRIP001 	if (pViewShell)
//STRIP001 	{
//STRIP001 		//!	set current sheet
//STRIP001 	}
//STRIP001 
//STRIP001 	EndUndo();
//STRIP001 }

//STRIP001 void __EXPORT ScUndoDataPilot::Redo()
//STRIP001 {
//STRIP001 	BeginRedo();
//STRIP001 
//STRIP001 	//!	copy output data instead of repeating the change,
//STRIP001 	//!	in case external data have changed!
//STRIP001 
//STRIP001 	ScDocument* pDoc = pDocShell->GetDocument();
//STRIP001 
//STRIP001 	ScDPObject* pSourceObj = NULL;
//STRIP001 	if ( pOldDPObject )
//STRIP001 	{
//STRIP001 		//	find object to modify
//STRIP001 		//!	find by name!
//STRIP001 
//STRIP001 		ScRange aOldRange = pOldDPObject->GetOutRange();
//STRIP001 		pSourceObj = pDoc->GetDPAtCursor(
//STRIP001 						aOldRange.aStart.Col(), aOldRange.aStart.Row(), aOldRange.aStart.Tab() );
//STRIP001 		DBG_ASSERT(pSourceObj, "DPObject not found");
//STRIP001 	}
//STRIP001 
//STRIP001 	ScDBDocFunc aFunc( *pDocShell );
//STRIP001 	aFunc.DataPilotUpdate( pSourceObj, pNewDPObject, FALSE, FALSE );	// no new undo action
//STRIP001 
//STRIP001 	EndRedo();
//STRIP001 }

//STRIP001 void __EXPORT ScUndoDataPilot::Repeat(SfxRepeatTarget& rTarget)
//STRIP001 {
//STRIP001 	//!	allow deletion
//STRIP001 }

//STRIP001 BOOL __EXPORT ScUndoDataPilot::CanRepeat(SfxRepeatTarget& rTarget) const
//STRIP001 {
//STRIP001 	//!	allow deletion
//STRIP001 	return FALSE;
//STRIP001 }


//
//		Konsolidieren
//

//STRIP001 ScUndoConsolidate::ScUndoConsolidate( ScDocShell* pNewDocShell, const ScArea& rArea,
//STRIP001 					const ScConsolidateParam& rPar, ScDocument* pNewUndoDoc,
//STRIP001 					BOOL bReference, USHORT nInsCount, ScOutlineTable* pTab,
//STRIP001 					ScDBData* pData ) :
//STRIP001 	ScSimpleUndo( pNewDocShell ),
//STRIP001 	aDestArea( rArea ),
//STRIP001 	aParam( rPar ),
//STRIP001 	pUndoDoc( pNewUndoDoc ),
//STRIP001 	bInsRef( bReference ),
//STRIP001 	nInsertCount( nInsCount ),
//STRIP001 	pUndoTab( pTab ),
//STRIP001 	pUndoData( pData )
//STRIP001 {
//STRIP001 }

//STRIP001 __EXPORT ScUndoConsolidate::~ScUndoConsolidate()
//STRIP001 {
//STRIP001 	delete pUndoDoc;
//STRIP001 	delete pUndoTab;
//STRIP001 	delete pUndoData;
//STRIP001 }

//STRIP001 String __EXPORT ScUndoConsolidate::GetComment() const
//STRIP001 {
//STRIP001 	return ScGlobal::GetRscString( STR_UNDO_CONSOLIDATE );
//STRIP001 }

//STRIP001 void __EXPORT ScUndoConsolidate::Undo()
//STRIP001 {
//STRIP001 	BeginUndo();
//STRIP001 
//STRIP001 	ScDocument* pDoc = pDocShell->GetDocument();
//STRIP001 	USHORT nTab = aDestArea.nTab;
//STRIP001 
//STRIP001 	ScRange aOldRange;
//STRIP001 	if (pUndoData)
//STRIP001 		pUndoData->GetArea(aOldRange);
//STRIP001 
//STRIP001 	if (bInsRef)
//STRIP001 	{
//STRIP001 		//	Zeilen loeschen
//STRIP001 		pDoc->DeleteRow( 0,nTab, MAXCOL,nTab, aDestArea.nRowStart, nInsertCount );
//STRIP001 
//STRIP001 		//	Outlines
//STRIP001 		pDoc->SetOutlineTable( nTab, pUndoTab );
//STRIP001 
//STRIP001 		//	Zeilenstatus
//STRIP001 		pUndoDoc->CopyToDocument( 0,0,nTab, MAXCOL,MAXROW,nTab, IDF_NONE, FALSE, pDoc );
//STRIP001 
//STRIP001 		//	Daten & Referenzen
//STRIP001 		pDoc->DeleteAreaTab( 0,aDestArea.nRowStart, MAXCOL,aDestArea.nRowEnd, nTab, IDF_ALL );
//STRIP001 		pUndoDoc->UndoToDocument( 0, aDestArea.nRowStart, nTab,
//STRIP001 									MAXCOL, aDestArea.nRowEnd, nTab,
//STRIP001 									IDF_ALL, FALSE, pDoc );
//STRIP001 
//STRIP001 		//	Original-Bereich
//STRIP001 		if (pUndoData)
//STRIP001 		{
//STRIP001 			pDoc->DeleteAreaTab(aOldRange, IDF_ALL);
//STRIP001 			pUndoDoc->CopyToDocument(aOldRange, IDF_ALL, FALSE, pDoc);
//STRIP001 		}
//STRIP001 
//STRIP001 		pDocShell->PostPaint( 0,aDestArea.nRowStart,nTab, MAXCOL,MAXROW,nTab,
//STRIP001 								PAINT_GRID | PAINT_LEFT | PAINT_SIZE );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		pDoc->DeleteAreaTab( aDestArea.nColStart,aDestArea.nRowStart,
//STRIP001 								aDestArea.nColEnd,aDestArea.nRowEnd, nTab, IDF_ALL );
//STRIP001 		pUndoDoc->CopyToDocument( aDestArea.nColStart, aDestArea.nRowStart, nTab,
//STRIP001 									aDestArea.nColEnd, aDestArea.nRowEnd, nTab,
//STRIP001 									IDF_ALL, FALSE, pDoc );
//STRIP001 
//STRIP001 		//	Original-Bereich
//STRIP001 		if (pUndoData)
//STRIP001 		{
//STRIP001 			pDoc->DeleteAreaTab(aOldRange, IDF_ALL);
//STRIP001 			pUndoDoc->CopyToDocument(aOldRange, IDF_ALL, FALSE, pDoc);
//STRIP001 		}
//STRIP001 
//STRIP001 		USHORT nEndX = aDestArea.nColEnd;
//STRIP001 		USHORT nEndY = aDestArea.nRowEnd;
//STRIP001 		if ( pUndoData )
//STRIP001 		{
//STRIP001 			if ( aOldRange.aEnd.Col() > nEndX )
//STRIP001 				nEndX = aOldRange.aEnd.Col();
//STRIP001 			if ( aOldRange.aEnd.Row() > nEndY )
//STRIP001 				nEndY = aOldRange.aEnd.Row();
//STRIP001 		}
//STRIP001 		pDocShell->PostPaint( aDestArea.nColStart, aDestArea.nRowStart, nTab,
//STRIP001 									nEndX, nEndY, nTab, PAINT_GRID );
//STRIP001 	}
//STRIP001 
//STRIP001 	//	DB-Bereich wieder anpassen
//STRIP001 	if (pUndoData)
//STRIP001 	{
//STRIP001 		ScDBCollection*	pColl = pDoc->GetDBCollection();
//STRIP001 		if (pColl)
//STRIP001 		{
//STRIP001 			USHORT nIndex;
//STRIP001 			if (pColl->SearchName( pUndoData->GetName(), nIndex ))
//STRIP001 			{
//STRIP001 				ScDBData* pDocData = (*pColl)[nIndex];
//STRIP001 				if (pDocData)
//STRIP001 					*pDocData = *pUndoData;
//STRIP001 			}
//STRIP001 			else
//STRIP001 				DBG_ERROR("alte DB-Daten nicht gefunden");
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	ScTabViewShell* pViewShell = ScTabViewShell::GetActiveViewShell();
//STRIP001 	if (pViewShell)
//STRIP001 	{
//STRIP001 		USHORT nViewTab = pViewShell->GetViewData()->GetTabNo();
//STRIP001 		if ( nViewTab != nTab )
//STRIP001 			pViewShell->SetTabNo( nTab );
//STRIP001 	}
//STRIP001 
//STRIP001 	EndUndo();
//STRIP001 }

//STRIP001 void __EXPORT ScUndoConsolidate::Redo()
//STRIP001 {
//STRIP001 	BeginRedo();
//STRIP001 
//STRIP001 	pDocShell->DoConsolidate( aParam, FALSE );
//STRIP001 
//STRIP001 	ScTabViewShell* pViewShell = ScTabViewShell::GetActiveViewShell();
//STRIP001 	if (pViewShell)
//STRIP001 	{
//STRIP001 		USHORT nViewTab = pViewShell->GetViewData()->GetTabNo();
//STRIP001 		if ( nViewTab != aParam.nTab )
//STRIP001 			pViewShell->SetTabNo( aParam.nTab );
//STRIP001 	}
//STRIP001 
//STRIP001 	EndRedo();
//STRIP001 }

//STRIP001 void __EXPORT ScUndoConsolidate::Repeat(SfxRepeatTarget& rTarget)
//STRIP001 {
//STRIP001 }

//STRIP001 BOOL __EXPORT ScUndoConsolidate::CanRepeat(SfxRepeatTarget& rTarget) const
//STRIP001 {
//STRIP001 	return FALSE;
//STRIP001 }


//
//		Quell-Daten von Chart aendern
//

//STRIP001 void ScUndoChartData::Init()
//STRIP001 {
//STRIP001 	ScDocument* pDoc = pDocShell->GetDocument();
//STRIP001 	BOOL bFound = FALSE;;
//STRIP001 
//STRIP001 	SchMemChart* pOld = pDoc->FindChartData(aChartName);
//STRIP001 	if (pOld)
//STRIP001 	{
//STRIP001 		ScChartArray aData(pDoc,*pOld);
//STRIP001 		aOldRangeListRef = aData.GetRangeList();
//STRIP001 		bOldColHeaders = aData.HasColHeaders();
//STRIP001 		bOldRowHeaders = aData.HasRowHeaders();
//STRIP001 	}
//STRIP001 	else								//	war vorher nicht initialisiert
//STRIP001 	{									//!	bei Undo zuruecksetzen ?
//STRIP001 		aOldRangeListRef = aNewRangeListRef;
//STRIP001 		bOldColHeaders = bNewColHeaders;
//STRIP001 		bOldRowHeaders = bNewRowHeaders;
//STRIP001 	}
//STRIP001 }

/*N*/ ScUndoChartData::ScUndoChartData( ScDocShell* pNewDocShell, const String& rName,
/*N*/ 									const ScRange& rNew, BOOL bColHdr, BOOL bRowHdr,
/*N*/ 									BOOL bAdd ) :
/*N*/ 	ScSimpleUndo( pNewDocShell ),
/*N*/ 	aChartName( rName ),
/*N*/ 	bNewColHeaders( bColHdr ),
/*N*/ 	bNewRowHeaders( bRowHdr ),
/*N*/ 	bAddRange( bAdd )
/*N*/ {
/*?*/ 	DBG_BF_ASSERT(0, "STRIP"); //STRIP001 aNewRangeListRef = new ScRangeList;
//STRIP001 /*?*/ 	aNewRangeListRef->Append( rNew );
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 	Init();
/*N*/ }

/*N*/ ScUndoChartData::ScUndoChartData( ScDocShell* pNewDocShell, const String& rName,
/*N*/ 									const ScRangeListRef& rNew, BOOL bColHdr, BOOL bRowHdr,
/*N*/ 									BOOL bAdd ) :
/*N*/ 	ScSimpleUndo( pNewDocShell ),
/*N*/ 	aChartName( rName ),
/*N*/ 	aNewRangeListRef( rNew ),
/*N*/ 	bNewColHeaders( bColHdr ),
/*N*/ 	bNewRowHeaders( bRowHdr ),
/*N*/ 	bAddRange( bAdd )
/*N*/ {
/*?*/ 	DBG_BF_ASSERT(0, "STRIP"); //STRIP001 Init();
/*N*/ }

/*N*/ __EXPORT ScUndoChartData::~ScUndoChartData()
/*N*/ {
/*N*/ }

//STRIP001 String __EXPORT ScUndoChartData::GetComment() const
//STRIP001 {
//STRIP001 	return ScGlobal::GetRscString( STR_UNDO_CHARTDATA );
//STRIP001 }

//STRIP001 void __EXPORT ScUndoChartData::Undo()
//STRIP001 {
//STRIP001 	BeginUndo();
//STRIP001 
//STRIP001 	Window* pDataWin = NULL;
//STRIP001 	ScTabViewShell* pViewSh	= ScTabViewShell::GetActiveViewShell();
//STRIP001 	if (pViewSh)
//STRIP001 		pDataWin = pViewSh->GetActiveWin();
//STRIP001 
//STRIP001 	pDocShell->GetDocument()->UpdateChartArea( aChartName, aOldRangeListRef,
//STRIP001 								bOldColHeaders, bOldRowHeaders, FALSE, pDataWin );
//STRIP001 
//STRIP001 	EndUndo();
//STRIP001 }

//STRIP001 void __EXPORT ScUndoChartData::Redo()
//STRIP001 {
//STRIP001 	BeginRedo();
//STRIP001 
//STRIP001 	Window* pDataWin = NULL;
//STRIP001 	ScTabViewShell* pViewSh	= ScTabViewShell::GetActiveViewShell();
//STRIP001 	if (pViewSh)
//STRIP001 		pDataWin = pViewSh->GetActiveWin();
//STRIP001 
//STRIP001 	pDocShell->GetDocument()->UpdateChartArea( aChartName, aNewRangeListRef,
//STRIP001 								bNewColHeaders, bNewRowHeaders, bAddRange, pDataWin );
//STRIP001 
//STRIP001 	EndRedo();
//STRIP001 }

//STRIP001 void __EXPORT ScUndoChartData::Repeat(SfxRepeatTarget& rTarget)
//STRIP001 {
//STRIP001 }

//STRIP001 BOOL __EXPORT ScUndoChartData::CanRepeat(SfxRepeatTarget& rTarget) const
//STRIP001 {
//STRIP001 	return FALSE;
//STRIP001 }






}
