/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sc_dbnamdlg.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 18:58:29 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// System - Includes ---------------------------------------------------------

#ifdef PCH
// auto strip #include "ui_pch.hxx"
#endif

#pragma hdrstop

// INCLUDE -------------------------------------------------------------------

// auto strip #include <vcl/msgbox.hxx>

// auto strip #include "reffact.hxx"
// auto strip #include "document.hxx"
// auto strip #include "scresid.hxx"
#include "globstr.hrc"
#include "dbnamdlg.hrc"
// auto strip #include "rangenam.hxx"		// IsNameValid

#define _DBNAMDLG_CXX
#include "dbnamdlg.hxx"
#undef _DBNAMDLG_CXX
namespace binfilter {


//============================================================================

#define ABS_SREF		  SCA_VALID \
						| SCA_COL_ABSOLUTE | SCA_ROW_ABSOLUTE | SCA_TAB_ABSOLUTE
#define ABS_DREF		  ABS_SREF \
						| SCA_COL2_ABSOLUTE | SCA_ROW2_ABSOLUTE | SCA_TAB2_ABSOLUTE
#define ABS_SREF3D		ABS_SREF | SCA_TAB_3D
#define ABS_DREF3D		ABS_DREF | SCA_TAB_3D

//----------------------------------------------------------------------------

class DBSaveData;

static DBSaveData* pSaveObj = NULL;

#define ERRORBOX(s) ErrorBox(this,WinBits(WB_OK|WB_DEF_OK),s).Execute()
#define QUERYBOX(m) QueryBox(this,WinBits(WB_YES_NO|WB_DEF_YES),m).Execute()

//============================================================================
//	class DBSaveData

//STRIP001 class DBSaveData
//STRIP001 {
//STRIP001 public:
//STRIP001 	DBSaveData( Edit& rEd, CheckBox& rHdr, CheckBox& rSize, CheckBox& rFmt,
//STRIP001 							CheckBox& rStrip, ScRange& rArea )
//STRIP001 		: bHeader(FALSE), bSize(FALSE), bFormat(FALSE), bDirty(FALSE),
//STRIP001 		  rEdAssign(rEd),
//STRIP001 		  rBtnHeader(rHdr), rBtnSize(rSize), rBtnFormat(rFmt), rBtnStrip(rStrip),
//STRIP001 		  rCurArea(rArea) {}
//STRIP001 
//STRIP001 	void Clear();
//STRIP001 	void Save();
//STRIP001 	void Restore();
//STRIP001 
//STRIP001 private:
//STRIP001 	Edit&		rEdAssign;
//STRIP001 	CheckBox&	rBtnHeader;
//STRIP001 	CheckBox&	rBtnSize;
//STRIP001 	CheckBox&	rBtnFormat;
//STRIP001 	CheckBox&	rBtnStrip;
//STRIP001 	ScRange&	rCurArea;
//STRIP001 	String		aStr;
//STRIP001 	ScRange		aArea;
//STRIP001 	BOOL		bHeader:1;
//STRIP001 	BOOL		bSize:1;
//STRIP001 	BOOL		bFormat:1;
//STRIP001 	BOOL		bStrip:1;
//STRIP001 	BOOL		bDirty:1;
//STRIP001 };



//----------------------------------------------------------------------------

//STRIP001 void DBSaveData::Clear()
//STRIP001 {
//STRIP001 	aStr.Erase();
//STRIP001 	aArea = ScRange();
//STRIP001 	bHeader = bSize = bFormat = bStrip = bDirty = FALSE;
//STRIP001 }


//----------------------------------------------------------------------------

//STRIP001 void DBSaveData::Save()
//STRIP001 {
//STRIP001 	aArea   = rCurArea;
//STRIP001 	aStr    = rEdAssign.GetText();
//STRIP001 	bHeader = rBtnHeader.IsChecked();
//STRIP001 	bSize   = rBtnSize.IsChecked();
//STRIP001 	bFormat = rBtnFormat.IsChecked();
//STRIP001 	bStrip	= rBtnStrip.IsChecked();
//STRIP001 	bDirty  = TRUE;
//STRIP001 }


//----------------------------------------------------------------------------

//STRIP001 void DBSaveData::Restore()
//STRIP001 {
//STRIP001 	if ( bDirty )
//STRIP001 	{
//STRIP001 		rCurArea = aArea;
//STRIP001 		rEdAssign.SetText( aStr );
//STRIP001 		rBtnHeader.Check ( bHeader );
//STRIP001 		rBtnSize.Check   ( bSize );
//STRIP001 		rBtnFormat.Check ( bFormat );
//STRIP001 		rBtnStrip.Check  ( bStrip );
//STRIP001 		bDirty = FALSE;
//STRIP001 	}
//STRIP001 }


//============================================================================
//	class ScDbNameDlg

//----------------------------------------------------------------------------

//STRIP001 ScDbNameDlg::ScDbNameDlg( SfxBindings* pB, SfxChildWindow* pCW, Window* pParent,
//STRIP001 						  ScViewData*	ptrViewData )
//STRIP001 
//STRIP001 	:	ScAnyRefDlg	( pB, pCW, pParent, RID_SCDLG_DBNAMES ),
//STRIP001 		//
//STRIP001         aFlName         ( this, ScResId( FL_NAME ) ),
//STRIP001 		aEdName			( this, ScResId( ED_NAME ) ),
//STRIP001 
//STRIP001         aFlAssign       ( this, ScResId( FL_ASSIGN ) ),
//STRIP001 		aEdAssign		( this, ScResId( ED_DBAREA ) ),
//STRIP001 		aRbAssign		( this, ScResId( RB_DBAREA ), &aEdAssign ),
//STRIP001 
//STRIP001         aFlOptions      ( this, ScResId( FL_OPTIONS ) ),
//STRIP001 		aBtnHeader		( this, ScResId( BTN_HEADER ) ),
//STRIP001 		aBtnDoSize		( this, ScResId( BTN_SIZE ) ),
//STRIP001 		aBtnKeepFmt		( this, ScResId( BTN_FORMAT ) ),
//STRIP001 		aBtnStripData	( this, ScResId( BTN_STRIPDATA ) ),
//STRIP001 		aFTSource		( this, ScResId( FT_SOURCE ) ),
//STRIP001 		aFTOperations	( this, ScResId( FT_OPERATIONS ) ),
//STRIP001 
//STRIP001 		aBtnOk			( this, ScResId( BTN_OK ) ),
//STRIP001 		aBtnCancel		( this, ScResId( BTN_CANCEL ) ),
//STRIP001 		aBtnAdd			( this, ScResId( BTN_ADD ) ),
//STRIP001 		aBtnRemove		( this, ScResId( BTN_REMOVE ) ),
//STRIP001 		aBtnHelp		( this, ScResId( BTN_HELP ) ),
//STRIP001 		aBtnMore		( this, ScResId( BTN_MORE ) ),
//STRIP001 
//STRIP001 		aStrAdd			( ScResId( STR_ADD ) ),
//STRIP001 		aStrModify		( ScResId( STR_MODIFY ) ),
//STRIP001 		aStrNoName		( ScGlobal::GetRscString(STR_DB_NONAME) ),
//STRIP001 		aStrInvalid		( ScResId( STR_DB_INVALID ) ),
//STRIP001 		//
//STRIP001 		pViewData		( ptrViewData ),
//STRIP001 		pDoc			( ptrViewData->GetDocument() ),
//STRIP001 		aLocalDbCol		( *(pDoc->GetDBCollection()) ),
//STRIP001 		bRefInputMode	( FALSE )
//STRIP001 {
//STRIP001 	// WB_NOLABEL can't be set in resource...
//STRIP001 	aFTSource.SetStyle( aFTSource.GetStyle() | WB_NOLABEL );
//STRIP001 	aFTOperations.SetStyle( aFTOperations.GetStyle() | WB_NOLABEL );
//STRIP001 
//STRIP001 	//	damit die Strings in der Resource bei den FixedTexten bleiben koennen:
//STRIP001 	aStrSource		= aFTSource.GetText();
//STRIP001 	aStrOperations	= aFTOperations.GetText();
//STRIP001 
//STRIP001 	pSaveObj = new DBSaveData( aEdAssign, aBtnHeader,
//STRIP001 						aBtnDoSize, aBtnKeepFmt, aBtnStripData, theCurArea );
//STRIP001 	Init();
//STRIP001 	FreeResource();
//STRIP001 }


//----------------------------------------------------------------------------

//STRIP001 __EXPORT ScDbNameDlg::~ScDbNameDlg()
//STRIP001 {
//STRIP001 	DELETEZ( pSaveObj );
//STRIP001 
//STRIP001 	ScRange* pEntry = (ScRange*)aRemoveList.First();
//STRIP001 	while ( pEntry )
//STRIP001 	{
//STRIP001 		delete aRemoveList.Remove( pEntry );
//STRIP001 		pEntry = (ScRange*)aRemoveList.Next();
//STRIP001 	}
//STRIP001 }


//----------------------------------------------------------------------------

//STRIP001 void ScDbNameDlg::Init()
//STRIP001 {
//STRIP001 	aBtnHeader.Check( TRUE );		// Default: mit Spaltenkoepfen
//STRIP001 
//STRIP001     aBtnMore.AddWindow( &aFlOptions );
//STRIP001 	aBtnMore.AddWindow( &aBtnHeader );
//STRIP001 	aBtnMore.AddWindow( &aBtnDoSize );
//STRIP001 	aBtnMore.AddWindow( &aBtnKeepFmt );
//STRIP001 	aBtnMore.AddWindow( &aBtnStripData );
//STRIP001 	aBtnMore.AddWindow( &aFTSource );
//STRIP001 	aBtnMore.AddWindow( &aFTOperations );
//STRIP001 
//STRIP001 	String	theAreaStr;
//STRIP001 	USHORT	nStartCol 	= 0;
//STRIP001 	USHORT	nStartRow 	= 0;
//STRIP001 	USHORT	nStartTab 	= 0;
//STRIP001 	USHORT	nEndCol 	= 0;
//STRIP001 	USHORT	nEndRow		= 0;
//STRIP001 	USHORT	nEndTab 	= 0;
//STRIP001 
//STRIP001 	aBtnOk.SetClickHdl		( LINK( this, ScDbNameDlg, OkBtnHdl ) );
//STRIP001 	aBtnCancel.SetClickHdl	( LINK( this, ScDbNameDlg, CancelBtnHdl ) );
//STRIP001 	aBtnAdd.SetClickHdl		( LINK( this, ScDbNameDlg, AddBtnHdl ) );
//STRIP001 	aBtnRemove.SetClickHdl	( LINK( this, ScDbNameDlg, RemoveBtnHdl ) );
//STRIP001 	aEdName.SetModifyHdl	( LINK( this, ScDbNameDlg, NameModifyHdl ) );
//STRIP001 	aEdAssign.SetModifyHdl	( LINK( this, ScDbNameDlg, AssModifyHdl ) );
//STRIP001 	UpdateNames();
//STRIP001 
//STRIP001 	if ( pViewData && pDoc )
//STRIP001 	{
//STRIP001 		ScDBCollection*	pDBColl	= pDoc->GetDBCollection();
//STRIP001 		ScDBData*		pDBData = NULL;
//STRIP001 
//STRIP001 		pViewData->GetSimpleArea( nStartCol, nStartRow, nStartTab,
//STRIP001 								  nEndCol,	 nEndRow,  nEndTab );
//STRIP001 
//STRIP001 		theCurArea = ScRange( ScAddress( nStartCol, nStartRow, nStartTab ),
//STRIP001 							  ScAddress( nEndCol,   nEndRow,   nEndTab ) );
//STRIP001 
//STRIP001 		theCurArea.Format( theAreaStr, ABS_DREF3D, pDoc );
//STRIP001 
//STRIP001 		if ( pDBColl )
//STRIP001 		{
//STRIP001 			// Feststellen, ob definierter DB-Bereich markiert wurde:
//STRIP001 			pDBData = pDBColl->GetDBAtCursor( nStartCol, nStartRow, nStartTab, TRUE );
//STRIP001 			if ( pDBData )
//STRIP001 			{
//STRIP001 				String		theDbName;
//STRIP001 				ScAddress&	rStart = theCurArea.aStart;
//STRIP001 				ScAddress&	rEnd   = theCurArea.aEnd;
//STRIP001 				USHORT		nCol1, nCol2, nRow1, nRow2, nTab;
//STRIP001 
//STRIP001 				pDBData->GetArea( nTab, nCol1, nRow1, nCol2, nRow2 );
//STRIP001 
//STRIP001 				if (   (rStart.Tab() == nTab)
//STRIP001 					&& (rStart.Col() == nCol1) && (rStart.Row() == nRow1)
//STRIP001 					&& (rEnd.Col()   == nCol2) && (rEnd.Row()   == nRow2 ) )
//STRIP001 				{
//STRIP001 					pDBData->GetName( theDbName );
//STRIP001 					if ( theDbName != aStrNoName )
//STRIP001 						aEdName.SetText( theDbName );
//STRIP001 					else
//STRIP001 						aEdName.SetText( EMPTY_STRING );
//STRIP001 					aBtnHeader.Check( pDBData->HasHeader() );
//STRIP001 					aBtnDoSize.Check( pDBData->IsDoSize() );
//STRIP001 					aBtnKeepFmt.Check( pDBData->IsKeepFmt() );
//STRIP001 					aBtnStripData.Check( pDBData->IsStripData() );
//STRIP001 					SetInfoStrings( pDBData );
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	aEdAssign.SetText( theAreaStr );
//STRIP001 	aEdName.GrabFocus();
//STRIP001 	bSaved=TRUE;
//STRIP001 	pSaveObj->Save();
//STRIP001 	NameModifyHdl( 0 );
//STRIP001 }


//STRIP001 void ScDbNameDlg::SetInfoStrings( const ScDBData* pDBData )
//STRIP001 {
//STRIP001 	String aSource = aStrSource;
//STRIP001 	if (pDBData)
//STRIP001 	{
//STRIP001 		aSource += ' ';
//STRIP001 		aSource += pDBData->GetSourceString();
//STRIP001 	}
//STRIP001 	aFTSource.SetText( aSource );
//STRIP001 
//STRIP001 	String aOper = aStrOperations;
//STRIP001 	if (pDBData)
//STRIP001 	{
//STRIP001 		aOper += ' ';
//STRIP001 		aOper += pDBData->GetOperations();
//STRIP001 	}
//STRIP001 	aFTOperations.SetText( aOper );
//STRIP001 }

//----------------------------------------------------------------------------
// Uebergabe eines mit der Maus selektierten Tabellenbereiches, der dann als
//  neue Selektion im Referenz-Fenster angezeigt wird.

//STRIP001 void ScDbNameDlg::SetReference( const ScRange& rRef, ScDocument* pDoc )
//STRIP001 {
//STRIP001 	if ( aEdAssign.IsEnabled() )
//STRIP001 	{
//STRIP001 		if ( rRef.aStart != rRef.aEnd )
//STRIP001 			RefInputStart( &aEdAssign );
//STRIP001 
//STRIP001 		theCurArea = rRef;
//STRIP001 
//STRIP001 		String aRefStr;
//STRIP001 		theCurArea.Format( aRefStr, ABS_DREF3D, pDoc );
//STRIP001 		aEdAssign.SetRefString( aRefStr );
//STRIP001 		aBtnHeader.Enable();
//STRIP001 		aBtnDoSize.Enable();
//STRIP001 		aBtnKeepFmt.Enable();
//STRIP001 		aBtnStripData.Enable();
//STRIP001 		aFTSource.Enable();
//STRIP001 		aFTOperations.Enable();
//STRIP001 		aBtnAdd.Enable();
//STRIP001 		bSaved=TRUE;
//STRIP001 		pSaveObj->Save();
//STRIP001 	}
//STRIP001 }


//----------------------------------------------------------------------------

//STRIP001 BOOL __EXPORT ScDbNameDlg::Close()
//STRIP001 {
//STRIP001 	return DoClose( ScDbNameDlgWrapper::GetChildWindowId() );
//STRIP001 }

//------------------------------------------------------------------------

//STRIP001 void ScDbNameDlg::SetActive()
//STRIP001 {
//STRIP001 	aEdAssign.GrabFocus();
//STRIP001 
//STRIP001 	//	kein NameModifyHdl, weil sonst Bereiche nicht geaendert werden koennen
//STRIP001 	//	(nach dem Aufziehen der Referenz wuerde der alte Inhalt wieder angezeigt)
//STRIP001 	//	(der ausgewaehlte DB-Name hat sich auch nicht veraendert)
//STRIP001 
//STRIP001 	RefInputDone();
//STRIP001 }

//------------------------------------------------------------------------

//STRIP001 void ScDbNameDlg::UpdateNames()
//STRIP001 {
//STRIP001 	USHORT	nNameCount = aLocalDbCol.GetCount();
//STRIP001 
//STRIP001 	aEdName.SetUpdateMode( FALSE );
//STRIP001 	//-----------------------------------------------------------
//STRIP001 	aEdName.Clear();
//STRIP001 	aEdAssign.SetText( EMPTY_STRING );
//STRIP001 
//STRIP001 	if ( nNameCount > 0 )
//STRIP001 	{
//STRIP001 		ScDBData*	pDbData = NULL;
//STRIP001 		String		aString;
//STRIP001 
//STRIP001 		for ( USHORT i=0; i<nNameCount; i++ )
//STRIP001 		{
//STRIP001 			pDbData = (ScDBData*)(aLocalDbCol.At( i ));
//STRIP001 			if ( pDbData )
//STRIP001 			{
//STRIP001 				pDbData->GetName( aString );
//STRIP001 				if ( aString != aStrNoName )
//STRIP001 					aEdName.InsertEntry( aString );
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		aBtnAdd.SetText( aStrAdd );
//STRIP001 		aBtnAdd.Disable();
//STRIP001 		aBtnRemove.Disable();
//STRIP001 	}
//STRIP001 	//-----------------------------------------------------------
//STRIP001 	aEdName.SetUpdateMode( TRUE );
//STRIP001 	aEdName.Invalidate();
//STRIP001 }

//------------------------------------------------------------------------

//STRIP001 void ScDbNameDlg::UpdateDBData( const String& rStrName )
//STRIP001 {
//STRIP001 	String		theArea;
//STRIP001 	USHORT 		nAt;
//STRIP001 	ScDBData*	pData;
//STRIP001 
//STRIP001 	aLocalDbCol.SearchName( rStrName, nAt );
//STRIP001 	pData = (ScDBData*)(aLocalDbCol.At( nAt ));
//STRIP001 
//STRIP001 	if ( pData )
//STRIP001 	{
//STRIP001 		USHORT nColStart = 0;
//STRIP001 		USHORT nRowStart = 0;
//STRIP001 		USHORT nColEnd	 = 0;
//STRIP001 		USHORT nRowEnd	 = 0;
//STRIP001 		USHORT nTab		 = 0;
//STRIP001 
//STRIP001 		pData->GetArea( nTab, nColStart, nRowStart, nColEnd, nRowEnd );
//STRIP001 		theCurArea = ScRange( ScAddress( nColStart, nRowStart, nTab ),
//STRIP001 							  ScAddress( nColEnd,	nRowEnd,   nTab ) );
//STRIP001 		theCurArea.Format( theArea, ABS_DREF3D, pDoc );
//STRIP001 		aEdAssign.SetText( theArea );
//STRIP001 		aBtnAdd.SetText( aStrModify );
//STRIP001 		aBtnHeader.Check( pData->HasHeader() );
//STRIP001 		aBtnDoSize.Check( pData->IsDoSize() );
//STRIP001 		aBtnKeepFmt.Check( pData->IsKeepFmt() );
//STRIP001 		aBtnStripData.Check( pData->IsStripData() );
//STRIP001 		SetInfoStrings( pData );
//STRIP001 	}
//STRIP001 
//STRIP001 	aBtnAdd.SetText( aStrModify );
//STRIP001 	aBtnAdd.Enable();
//STRIP001 	aBtnRemove.Enable();
//STRIP001 	aBtnHeader.Enable();
//STRIP001 	aBtnDoSize.Enable();
//STRIP001 	aBtnKeepFmt.Enable();
//STRIP001 	aBtnStripData.Enable();
//STRIP001 	aFTSource.Enable();
//STRIP001 	aFTOperations.Enable();
//STRIP001 }

//------------------------------------------------------------------------


//STRIP001 BOOL ScDbNameDlg::IsRefInputMode() const
//STRIP001 {
//STRIP001 	return bRefInputMode;
//STRIP001 }

//------------------------------------------------------------------------
// Handler:
// ========

//STRIP001 IMPL_LINK( ScDbNameDlg, OkBtnHdl, void *, EMPTYARG )
//STRIP001 {
//STRIP001 	AddBtnHdl( 0 );
//STRIP001 
//STRIP001 	// Der View die Aenderungen und die Remove-Liste uebergeben:
//STRIP001 	// beide werden nur als Referenz uebergeben, so dass an dieser
//STRIP001 	// Stelle keine Speicherleichen entstehen koennen:
//STRIP001 	if ( pViewData )
//STRIP001 		pViewData->GetView()->
//STRIP001 			NotifyCloseDbNameDlg( aLocalDbCol, aRemoveList );
//STRIP001 
//STRIP001 	Close();
//STRIP001 	return 0;
//STRIP001 }

//------------------------------------------------------------------------

//STRIP001 IMPL_LINK_INLINE_START( ScDbNameDlg, CancelBtnHdl, void *, EMPTYARG )
//STRIP001 {
//STRIP001 	Close();
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 IMPL_LINK_INLINE_END( ScDbNameDlg, CancelBtnHdl, void *, EMPTYARG )

//------------------------------------------------------------------------

//STRIP001 IMPL_LINK( ScDbNameDlg, AddBtnHdl, void *, EMPTYARG )
//STRIP001 {
//STRIP001 	String	aNewName = aEdName.GetText();
//STRIP001 	String	aNewArea = aEdAssign.GetText();
//STRIP001 
//STRIP001 	aNewName.EraseLeadingChars( ' ' );
//STRIP001 	aNewName.EraseTrailingChars( ' ' );
//STRIP001 
//STRIP001 	if ( aNewName.Len() > 0 && aNewArea.Len() > 0 )
//STRIP001 	{
//STRIP001 		if ( ScRangeData::IsNameValid( aNewName, pDoc ) )
//STRIP001 		{
//STRIP001 			//	weil jetzt editiert werden kann, muss erst geparst werden
//STRIP001 			ScRange aTmpRange;
//STRIP001 			String aText = aEdAssign.GetText();
//STRIP001 			if ( aTmpRange.ParseAny( aText, pDoc ) & SCA_VALID )
//STRIP001 			{
//STRIP001 				theCurArea = aTmpRange;
//STRIP001 				ScAddress aStart = theCurArea.aStart;
//STRIP001 				ScAddress aEnd   = theCurArea.aEnd;
//STRIP001 
//STRIP001 				ScDBData* pOldEntry = NULL;
//STRIP001 				USHORT nFoundAt = 0;
//STRIP001 				if ( aLocalDbCol.SearchName( aNewName, nFoundAt ) )
//STRIP001 					pOldEntry = aLocalDbCol[nFoundAt];
//STRIP001 				if (pOldEntry)
//STRIP001 				{
//STRIP001 					//	Bereich veraendern
//STRIP001 
//STRIP001 					pOldEntry->MoveTo( aStart.Tab(), aStart.Col(), aStart.Row(),
//STRIP001 														aEnd.Col(), aEnd.Row() );
//STRIP001 					pOldEntry->SetByRow( TRUE );
//STRIP001 					pOldEntry->SetHeader( aBtnHeader.IsChecked() );
//STRIP001 					pOldEntry->SetDoSize( aBtnDoSize.IsChecked() );
//STRIP001 					pOldEntry->SetKeepFmt( aBtnKeepFmt.IsChecked() );
//STRIP001 					pOldEntry->SetStripData( aBtnStripData.IsChecked() );
//STRIP001 				}
//STRIP001 				else
//STRIP001 				{
//STRIP001 					//	neuen Bereich einfuegen
//STRIP001 
//STRIP001 					ScDBData* pNewEntry = new ScDBData( aNewName, aStart.Tab(),
//STRIP001 														aStart.Col(), aStart.Row(),
//STRIP001 														aEnd.Col(), aEnd.Row(),
//STRIP001 														TRUE, aBtnHeader.IsChecked() );
//STRIP001 					pNewEntry->SetDoSize( aBtnDoSize.IsChecked() );
//STRIP001 					pNewEntry->SetKeepFmt( aBtnKeepFmt.IsChecked() );
//STRIP001 					pNewEntry->SetStripData( aBtnStripData.IsChecked() );
//STRIP001 
//STRIP001 					if ( !aLocalDbCol.Insert( pNewEntry ) )
//STRIP001 						delete pNewEntry;
//STRIP001 				}
//STRIP001 
//STRIP001 				UpdateNames();
//STRIP001 
//STRIP001 				aEdName.SetText( EMPTY_STRING );
//STRIP001 				aEdName.GrabFocus();
//STRIP001 				aBtnAdd.SetText( aStrAdd );
//STRIP001 				aBtnAdd.Disable();
//STRIP001 				aBtnRemove.Disable();
//STRIP001 				aEdAssign.SetText( EMPTY_STRING );
//STRIP001 				aBtnHeader.Check( TRUE );		// Default: mit Spaltenkoepfen
//STRIP001 				aBtnDoSize.Check( FALSE );
//STRIP001 				aBtnKeepFmt.Check( FALSE );
//STRIP001 				aBtnStripData.Check( FALSE );
//STRIP001 				SetInfoStrings( NULL );		// leer
//STRIP001 				theCurArea = ScRange();
//STRIP001 				bSaved=TRUE;
//STRIP001 				pSaveObj->Save();
//STRIP001 				NameModifyHdl( 0 );
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				ERRORBOX( aStrInvalid );
//STRIP001 				aEdAssign.SetSelection( Selection( 0, SELECTION_MAX ) );
//STRIP001 				aEdAssign.GrabFocus();
//STRIP001 			}
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			ERRORBOX( ScGlobal::GetRscString(STR_INVALIDNAME) );
//STRIP001 			aEdName.SetSelection( Selection( 0, SELECTION_MAX ) );
//STRIP001 			aEdName.GrabFocus();
//STRIP001 		}
//STRIP001 	}
//STRIP001 	return 0;
//STRIP001 }

//------------------------------------------------------------------------

//STRIP001 IMPL_LINK( ScDbNameDlg, RemoveBtnHdl, void *, EMPTYARG )
//STRIP001 {
//STRIP001 	USHORT		 nRemoveAt = 0;
//STRIP001 	const String aStrEntry = aEdName.GetText();
//STRIP001 
//STRIP001 	if ( aLocalDbCol.SearchName( aStrEntry, nRemoveAt ) )
//STRIP001 	{
//STRIP001 		String aStrDelMsg = ScGlobal::GetRscString( STR_QUERY_DELENTRY );
//STRIP001 		String aMsg		  = aStrDelMsg.GetToken( 0, '#' );
//STRIP001 
//STRIP001 		aMsg += aStrEntry;
//STRIP001 		aMsg += aStrDelMsg.GetToken( 1, '#' );
//STRIP001 
//STRIP001 		if ( RET_YES == QUERYBOX(aMsg) )
//STRIP001 		{
//STRIP001 			ScDBData* pEntry = (ScDBData*)aLocalDbCol.At(nRemoveAt);
//STRIP001 
//STRIP001 			if ( pEntry )
//STRIP001 			{
//STRIP001 				USHORT nTab, nColStart, nRowStart, nColEnd, nRowEnd;
//STRIP001 				pEntry->GetArea( nTab, nColStart, nRowStart, nColEnd, nRowEnd );
//STRIP001 				aRemoveList.Insert(
//STRIP001 					new ScRange( ScAddress( nColStart, nRowStart, nTab ),
//STRIP001 								 ScAddress( nColEnd,   nRowEnd,   nTab ) ) );
//STRIP001 			}
//STRIP001 			aLocalDbCol.AtFree( nRemoveAt );
//STRIP001 
//STRIP001 			UpdateNames();
//STRIP001 
//STRIP001 			aEdName.SetText( EMPTY_STRING );
//STRIP001 			aEdName.GrabFocus();
//STRIP001 			aBtnAdd.SetText( aStrAdd );
//STRIP001 			aBtnAdd.Disable();
//STRIP001 			aBtnRemove.Disable();
//STRIP001 			aEdAssign.SetText( EMPTY_STRING );
//STRIP001 			theCurArea = ScRange();
//STRIP001 			aBtnHeader.Check( TRUE );		// Default: mit Spaltenkoepfen
//STRIP001 			aBtnDoSize.Check( FALSE );
//STRIP001 			aBtnKeepFmt.Check( FALSE );
//STRIP001 			aBtnStripData.Check( FALSE );
//STRIP001 			SetInfoStrings( NULL );		// leer
//STRIP001 			bSaved=FALSE;
//STRIP001 			pSaveObj->Restore();
//STRIP001 			NameModifyHdl( 0 );
//STRIP001 		}
//STRIP001 	}
//STRIP001 	return 0;
//STRIP001 }

//------------------------------------------------------------------------

//STRIP001 IMPL_LINK( ScDbNameDlg, NameModifyHdl, void *, EMPTYARG )
//STRIP001 {
//STRIP001 	String	theName		= aEdName.GetText();
//STRIP001 	BOOL	bNameFound  = (COMBOBOX_ENTRY_NOTFOUND
//STRIP001 						   != aEdName.GetEntryPos( theName ));
//STRIP001 
//STRIP001 	if ( theName.Len() == 0 )
//STRIP001 	{
//STRIP001 		if ( aBtnAdd.GetText() != aStrAdd )
//STRIP001 			aBtnAdd.SetText( aStrAdd );
//STRIP001 		aBtnAdd		.Disable();
//STRIP001 		aBtnRemove	.Disable();
//STRIP001         aFlAssign   .Disable();
//STRIP001 		aBtnHeader	.Disable();
//STRIP001 		aBtnDoSize	.Disable();
//STRIP001 		aBtnKeepFmt	.Disable();
//STRIP001 		aBtnStripData.Disable();
//STRIP001 		aFTSource	.Disable();
//STRIP001 		aFTOperations.Disable();
//STRIP001 		aEdAssign	.Disable();
//STRIP001 		aRbAssign	.Disable();
//STRIP001 		//bSaved=FALSE;
//STRIP001 		//pSaveObj->Restore();
//STRIP001 		//@BugID 54702 Enablen/Disablen nur noch in Basisklasse
//STRIP001 		//SFX_APPWINDOW->Disable(FALSE);		//! allgemeine Methode im ScAnyRefDlg
//STRIP001 		bRefInputMode = FALSE;
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		if ( bNameFound )
//STRIP001 		{
//STRIP001 			if ( aBtnAdd.GetText() != aStrModify )
//STRIP001 				aBtnAdd.SetText( aStrModify );
//STRIP001 
//STRIP001 			if(!bSaved)
//STRIP001 			{
//STRIP001 				bSaved=TRUE;
//STRIP001 				pSaveObj->Save();
//STRIP001 			}
//STRIP001 			UpdateDBData( theName );
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			if ( aBtnAdd.GetText() != aStrAdd )
//STRIP001 				aBtnAdd.SetText( aStrAdd );
//STRIP001 
//STRIP001 			bSaved=FALSE;
//STRIP001 			pSaveObj->Restore();
//STRIP001 
//STRIP001 			if ( aEdAssign.GetText().Len() > 0 )
//STRIP001 			{
//STRIP001 				aBtnAdd.Enable();
//STRIP001 				aBtnHeader.Enable();
//STRIP001 				aBtnDoSize.Enable();
//STRIP001 				aBtnKeepFmt.Enable();
//STRIP001 				aBtnStripData.Enable();
//STRIP001 				aFTSource.Enable();
//STRIP001 				aFTOperations.Enable();
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				aBtnAdd.Disable();
//STRIP001 				aBtnHeader.Disable();
//STRIP001 				aBtnDoSize.Disable();
//STRIP001 				aBtnKeepFmt.Disable();
//STRIP001 				aBtnStripData.Disable();
//STRIP001 				aFTSource.Disable();
//STRIP001 				aFTOperations.Disable();
//STRIP001 			}
//STRIP001 			aBtnRemove.Disable();
//STRIP001 		}
//STRIP001 
//STRIP001         aFlAssign.Enable();
//STRIP001 		aEdAssign.Enable();
//STRIP001 		aRbAssign.Enable();
//STRIP001 
//STRIP001 		//@BugID 54702 Enablen/Disablen nur noch in Basisklasse
//STRIP001 		//SFX_APPWINDOW->Enable();
//STRIP001 		bRefInputMode = TRUE;
//STRIP001 	}
//STRIP001 	return 0;
//STRIP001 }

//------------------------------------------------------------------------

//STRIP001 IMPL_LINK( ScDbNameDlg, AssModifyHdl, void *, EMPTYARG )
//STRIP001 {
//STRIP001 	//	hier parsen fuer Save() etc.
//STRIP001 
//STRIP001 	ScRange aTmpRange;
//STRIP001 	String aText = aEdAssign.GetText();
//STRIP001 	if ( aTmpRange.ParseAny( aText, pDoc ) & SCA_VALID )
//STRIP001 		theCurArea = aTmpRange;
//STRIP001 
//STRIP001 	return 0;
//STRIP001 }


}
