/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sc_seltrans.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 18:48:32 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// INCLUDE ---------------------------------------------------------------

#ifdef PCH
// auto strip #include "ui_pch.hxx"
#endif

#pragma hdrstop

// auto strip #include <com/sun/star/beans/XPropertySet.hpp>
// auto strip #include <com/sun/star/beans/XPropertySetInfo.hpp>
// auto strip #include <com/sun/star/form/FormButtonType.hpp>

// auto strip #include <tools/urlobj.hxx>
// auto strip #include <bf_sfx2/docfile.hxx>
// auto strip #include <bf_svx/fmglob.hxx>
#include <bf_svx/svdograf.hxx>
// auto strip #include <bf_svx/svdouno.hxx>

#include "seltrans.hxx"
// auto strip #include "transobj.hxx"
// auto strip #include "drwtrans.hxx"
// auto strip #include "scmod.hxx"
#include "dbfunc.hxx"	// for CopyToClip
// auto strip #include "docsh.hxx"
#include "drawview.hxx"
// auto strip #include "drwlayer.hxx"
namespace binfilter {

using namespace ::com::sun::star;

// -----------------------------------------------------------------------

BOOL lcl_IsURLButton( SdrObject* pObject )
{
	BOOL bRet = FALSE;

	DBG_BF_ASSERT(0, "STRIP"); //STRIP001 SdrUnoObj* pUnoCtrl = PTR_CAST(SdrUnoObj, pObject);
//STRIP001 	if (pUnoCtrl && FmFormInventor == pUnoCtrl->GetObjInventor())
//STRIP001    	{
//STRIP001 		uno::Reference<awt::XControlModel> xControlModel = pUnoCtrl->GetUnoControlModel();
//STRIP001 		DBG_ASSERT( xControlModel.is(), "uno control without model" );
//STRIP001 		if ( xControlModel.is() )
//STRIP001 		{
//STRIP001 			uno::Reference< beans::XPropertySet > xPropSet( xControlModel, uno::UNO_QUERY );
//STRIP001 			uno::Reference< beans::XPropertySetInfo > xInfo = xPropSet->getPropertySetInfo();
//STRIP001 
//STRIP001 			::rtl::OUString sPropButtonType = ::rtl::OUString::createFromAscii( "ButtonType" );
//STRIP001 			if(xInfo->hasPropertyByName( sPropButtonType ))
//STRIP001 			{
//STRIP001 				uno::Any aAny = xPropSet->getPropertyValue( sPropButtonType );
//STRIP001 				form::FormButtonType eTmp;
//STRIP001 				if ( (aAny >>= eTmp) && eTmp == form::FormButtonType_URL )
//STRIP001 					bRet = TRUE;
//STRIP001 			}
//STRIP001  		}
//STRIP001 	}

	return bRet;
}

// static

/*M*/ ScSelectionTransferObj* ScSelectionTransferObj::CreateFromView( ScTabView* pView )
/*M*/ {
/*M*/ 	ScSelectionTransferObj* pRet = NULL;
/*M*/ 
/*M*/ 	if ( pView )
/*M*/ 	{
/*M*/ 		ScSelectionTransferMode eMode = SC_SELTRANS_INVALID;
/*M*/ 
/*M*/ 		SdrView* pSdrView = pView->GetSdrView();
/*M*/ 		if ( pSdrView )
/*M*/ 		{
/*M*/ 			//	handle selection on drawing layer
/*M*/ 			const SdrMarkList& rMarkList = pSdrView->GetMarkList();
/*M*/ 			ULONG nMarkCount = rMarkList.GetMarkCount();
/*M*/ 			if ( nMarkCount )
/*M*/ 			{
/*M*/ 				if ( nMarkCount == 1 )
/*M*/ 				{
/*M*/ 					SdrObject* pObj = rMarkList.GetMark(0)->GetObj();
/*M*/ 					UINT16 nSdrObjKind = pObj->GetObjIdentifier();
/*M*/ 
/*M*/ 					if ( nSdrObjKind == OBJ_GRAF )
/*M*/ 					{
/*M*/ 						if ( ((SdrGrafObj*)pObj)->GetGraphic().GetType() == GRAPHIC_BITMAP )
/*M*/ 							eMode = SC_SELTRANS_DRAW_BITMAP;
/*M*/ 						else
/*M*/ 							eMode = SC_SELTRANS_DRAW_GRAPHIC;
/*M*/ 					}
/*M*/ 					else if ( nSdrObjKind == OBJ_OLE2 )
/*M*/ 						eMode = SC_SELTRANS_DRAW_OLE;
/*M*/ 					else if ( lcl_IsURLButton( pObj ) )
/*M*/ 						eMode = SC_SELTRANS_DRAW_BOOKMARK;
/*M*/ 				}
/*M*/ 	
/*M*/ 				if ( eMode == SC_SELTRANS_INVALID )
/*M*/ 					eMode = SC_SELTRANS_DRAW_OTHER;		// something selected but no special selection
/*M*/ 			}
/*M*/ 		}
/*M*/ 		if ( eMode == SC_SELTRANS_INVALID )				// no drawing object selected
/*M*/ 		{
/*M*/ 			ScRange aRange;
/*M*/ 			ScViewData* pViewData = pView->GetViewData();
/*M*/ 			const ScMarkData& rMark = pViewData->GetMarkData();
/*M*/ 			//	allow MultiMarked because GetSimpleArea may be able to merge into a simple range
/*M*/ 			//	(GetSimpleArea modifies a local copy of MarkData)
/*N*/ 			if ( ( rMark.IsMarked() || rMark.IsMultiMarked() ) && pViewData->GetSimpleArea( aRange ) )
/*M*/ 			{
/*M*/ 				//	only for "real" selection, cursor alone isn't used
/*M*/ 				if ( aRange.aStart == aRange.aEnd )
/*M*/ 					eMode = SC_SELTRANS_CELL;
/*M*/ 				else
/*M*/ 					eMode = SC_SELTRANS_CELLS;
/*M*/ 			}
/*M*/ 		}
/*M*/ 
/*M*/ 		if ( eMode != SC_SELTRANS_INVALID )
/*M*/ 			pRet = new ScSelectionTransferObj( pView, eMode );
/*M*/ 	}
/*M*/ 
/*M*/ 	return pRet;
/*M*/ }


//STRIP001 ScSelectionTransferObj::ScSelectionTransferObj( ScTabView* pSource, ScSelectionTransferMode eNewMode ) :
//STRIP001 	pView( pSource ),
//STRIP001 	eMode( eNewMode ),
//STRIP001 	pCellData( NULL ),
//STRIP001 	pDrawData( NULL )
//STRIP001 {
//STRIP001 	//!	store range for StillValid
//STRIP001 }

//STRIP001 ScSelectionTransferObj::~ScSelectionTransferObj()
//STRIP001 {
//STRIP001 	ScModule* pScMod = SC_MOD();
//STRIP001 	if ( pScMod->GetSelectionTransfer() == this )
//STRIP001 	{
//STRIP001 		//	this is reached when the object wasn't really copied to the selection
//STRIP001 		//	(CopyToSelection has no effect under Windows)
//STRIP001 
//STRIP001 		ForgetView();
//STRIP001 		pScMod->SetSelectionTransfer( NULL );
//STRIP001 	}
//STRIP001 
//STRIP001 	DBG_ASSERT( !pView, "ScSelectionTransferObj dtor: ForgetView not called" );
//STRIP001 }

/*N*/ BOOL ScSelectionTransferObj::StillValid()
/*N*/ {
/*N*/ 	//!	check if view still has same cell selection
/*N*/ 	//!	(but return FALSE if data has changed inbetween)
/*N*/ 	return FALSE;
/*N*/ }

//STRIP001 void ScSelectionTransferObj::ForgetView()
//STRIP001 {
//STRIP001 	pView = NULL;
//STRIP001 	eMode = SC_SELTRANS_INVALID;
//STRIP001 
//STRIP001 	if (pCellData)
//STRIP001 	{
//STRIP001 		pCellData->release();
//STRIP001 		pCellData = NULL;
//STRIP001 	}
//STRIP001 	if (pDrawData)
//STRIP001 	{
//STRIP001 		pDrawData->release();
//STRIP001 		pDrawData = NULL;
//STRIP001 	}
//STRIP001 }

//STRIP001 void ScSelectionTransferObj::AddSupportedFormats()
//STRIP001 {
//STRIP001 	//	AddSupportedFormats must work without actually creating the
//STRIP001 	//	"real" transfer object
//STRIP001 
//STRIP001 	switch (eMode)
//STRIP001 	{
//STRIP001 		case SC_SELTRANS_CELL:
//STRIP001 		case SC_SELTRANS_CELLS:
//STRIP001 			//	same formats as in ScTransferObj::AddSupportedFormats
//STRIP001 			AddFormat( SOT_FORMATSTR_ID_EMBED_SOURCE );
//STRIP001 			AddFormat( SOT_FORMATSTR_ID_OBJECTDESCRIPTOR );
//STRIP001 			AddFormat( SOT_FORMAT_GDIMETAFILE );
//STRIP001 			AddFormat( SOT_FORMAT_BITMAP );
//STRIP001 			AddFormat( SOT_FORMATSTR_ID_HTML );
//STRIP001 			AddFormat( SOT_FORMATSTR_ID_SYLK );
//STRIP001 			AddFormat( SOT_FORMATSTR_ID_LINK );
//STRIP001 			AddFormat( SOT_FORMATSTR_ID_DIF );
//STRIP001 			AddFormat( SOT_FORMAT_STRING );
//STRIP001 			AddFormat( SOT_FORMAT_RTF );
//STRIP001 			if ( eMode == SC_SELTRANS_CELL )
//STRIP001 				AddFormat( SOT_FORMATSTR_ID_EDITENGINE );
//STRIP001 			break;
//STRIP001 
//STRIP001 		// different graphic formats as in ScDrawTransferObj::AddSupportedFormats:
//STRIP001 
//STRIP001 		case SC_SELTRANS_DRAW_BITMAP:
//STRIP001 			AddFormat( SOT_FORMATSTR_ID_OBJECTDESCRIPTOR );
//STRIP001 			AddFormat( SOT_FORMATSTR_ID_SVXB );
//STRIP001         	AddFormat( SOT_FORMAT_BITMAP );
//STRIP001         	AddFormat( SOT_FORMAT_GDIMETAFILE );
//STRIP001 			break;
//STRIP001 
//STRIP001 		case SC_SELTRANS_DRAW_GRAPHIC:
//STRIP001 			AddFormat( SOT_FORMATSTR_ID_OBJECTDESCRIPTOR );
//STRIP001         	AddFormat( SOT_FORMATSTR_ID_SVXB );
//STRIP001         	AddFormat( SOT_FORMAT_GDIMETAFILE );
//STRIP001         	AddFormat( SOT_FORMAT_BITMAP );
//STRIP001  			break;
//STRIP001 
//STRIP001 		case SC_SELTRANS_DRAW_BOOKMARK:
//STRIP001         	AddFormat( SOT_FORMATSTR_ID_OBJECTDESCRIPTOR );
//STRIP001         	AddFormat( SOT_FORMATSTR_ID_SOLK );
//STRIP001         	AddFormat( SOT_FORMAT_STRING );
//STRIP001         	AddFormat( SOT_FORMATSTR_ID_UNIFORMRESOURCELOCATOR );
//STRIP001         	AddFormat( SOT_FORMATSTR_ID_NETSCAPE_BOOKMARK );
//STRIP001         	AddFormat( SOT_FORMATSTR_ID_DRAWING );
//STRIP001 			break;
//STRIP001 
//STRIP001 		case SC_SELTRANS_DRAW_OLE:
//STRIP001 			AddFormat( SOT_FORMATSTR_ID_EMBED_SOURCE );
//STRIP001         	AddFormat( SOT_FORMATSTR_ID_OBJECTDESCRIPTOR );
//STRIP001         	AddFormat( SOT_FORMAT_GDIMETAFILE );
//STRIP001 			break;
//STRIP001 
//STRIP001 		case SC_SELTRANS_DRAW_OTHER:
//STRIP001 			//	other drawing objects
//STRIP001 	        AddFormat( SOT_FORMATSTR_ID_EMBED_SOURCE );
//STRIP001         	AddFormat( SOT_FORMATSTR_ID_OBJECTDESCRIPTOR );
//STRIP001         	AddFormat( SOT_FORMATSTR_ID_DRAWING );
//STRIP001         	AddFormat( SOT_FORMAT_BITMAP );
//STRIP001         	AddFormat( SOT_FORMAT_GDIMETAFILE );
//STRIP001 			break;
//STRIP001 	}
//STRIP001 }

//STRIP001 void ScSelectionTransferObj::CreateCellData()
//STRIP001 {
//STRIP001 	DBG_ASSERT( !pCellData, "CreateCellData twice" );
//STRIP001 	if ( pView )
//STRIP001 	{
//STRIP001 		ScViewData* pViewData = pView->GetViewData();
//STRIP001 		ScMarkData aNewMark( pViewData->GetMarkData() );	// use local copy for MarkToSimple
//STRIP001 		aNewMark.MarkToSimple();
//STRIP001 
//STRIP001 		//	similar to ScViewFunctionSet::BeginDrag
//STRIP001 		if ( aNewMark.IsMarked() && !aNewMark.IsMultiMarked() )
//STRIP001 		{
//STRIP001 			ScDocShell* pDocSh = pViewData->GetDocShell();
//STRIP001 
//STRIP001 			ScRange aSelRange;
//STRIP001 			aNewMark.GetMarkArea( aSelRange );
//STRIP001 			ScDocShellRef aDragShellRef;
//STRIP001 			if ( pDocSh->GetDocument()->HasOLEObjectsInArea( aSelRange, &aNewMark ) )
//STRIP001 			{
//STRIP001 				aDragShellRef = new ScDocShell;		// DocShell needs a Ref immediately
//STRIP001 				aDragShellRef->DoInitNew(NULL);
//STRIP001 			}
//STRIP001 			ScDrawLayer::SetGlobalDrawPersist(aDragShellRef);
//STRIP001 
//STRIP001 			ScDocument* pClipDoc = new ScDocument( SCDOCMODE_CLIP );
//STRIP001 			// bApi = TRUE -> no error mesages
//STRIP001 			BOOL bCopied = pViewData->GetView()->CopyToClip( pClipDoc, FALSE, TRUE, TRUE );
//STRIP001 
//STRIP001 			ScDrawLayer::SetGlobalDrawPersist(NULL);
//STRIP001 
//STRIP001 			if ( bCopied )
//STRIP001 			{
//STRIP001 				TransferableObjectDescriptor aObjDesc;
//STRIP001 				pDocSh->FillTransferableObjectDescriptor( aObjDesc );
//STRIP001 				aObjDesc.maDisplayName = pDocSh->GetMedium()->GetURLObject().GetURLNoPass();
//STRIP001 				// maSize is set in ScTransferObj ctor
//STRIP001 
//STRIP001 				ScTransferObj* pTransferObj = new ScTransferObj( pClipDoc, aObjDesc );
//STRIP001 				uno::Reference<datatransfer::XTransferable> xTransferable( pTransferObj );
//STRIP001 
//STRIP001 				// SetDragHandlePos is not used - there is no mouse position
//STRIP001 				//? pTransferObj->SetVisibleTab( nTab );
//STRIP001 
//STRIP001 				SvEmbeddedObjectRef aPersistRef( aDragShellRef );
//STRIP001 				pTransferObj->SetDrawPersist( aPersistRef );	// keep persist for ole objects alive
//STRIP001 
//STRIP001 				pTransferObj->SetDragSource( pDocSh, aNewMark );
//STRIP001 
//STRIP001 				pCellData = pTransferObj;
//STRIP001 				pCellData->acquire();		// keep ref count up - released in ForgetView
//STRIP001 			}
//STRIP001 			else
//STRIP001 				delete pClipDoc;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	DBG_ASSERT( pCellData, "can't create CellData" );
//STRIP001 }

//!	make static member of ScDrawView
extern void lcl_CheckOle( const SdrMarkList& rMarkList, BOOL& rAnyOle, BOOL& rOneOle );

//STRIP001 void ScSelectionTransferObj::CreateDrawData()
//STRIP001 {
//STRIP001 	DBG_ASSERT( !pDrawData, "CreateDrawData twice" );
//STRIP001 	if ( pView )
//STRIP001 	{
//STRIP001 		//	similar to ScDrawView::BeginDrag
//STRIP001 
//STRIP001 		ScDrawView* pDrawView = pView->GetScDrawView();
//STRIP001 		if ( pDrawView )
//STRIP001 		{
//STRIP001 			BOOL bAnyOle, bOneOle;
//STRIP001 			const SdrMarkList& rMarkList = pDrawView->GetMarkList();
//STRIP001 			lcl_CheckOle( rMarkList, bAnyOle, bOneOle );
//STRIP001 
//STRIP001 			//---------------------------------------------------------
//STRIP001 			ScDocShellRef aDragShellRef;
//STRIP001 			if (bAnyOle)
//STRIP001 			{
//STRIP001 				aDragShellRef = new ScDocShell;		// ohne Ref lebt die DocShell nicht !!!
//STRIP001 				aDragShellRef->DoInitNew(NULL);
//STRIP001 			}
//STRIP001 			//---------------------------------------------------------
//STRIP001 
//STRIP001 			ScDrawLayer::SetGlobalDrawPersist(aDragShellRef);
//STRIP001 			SdrModel* pModel = pDrawView->GetAllMarkedModel();
//STRIP001 			ScDrawLayer::SetGlobalDrawPersist(NULL);
//STRIP001 
//STRIP001 			ScViewData* pViewData = pView->GetViewData();
//STRIP001 			ScDocShell* pDocSh = pViewData->GetDocShell();
//STRIP001 
//STRIP001 			TransferableObjectDescriptor aObjDesc;
//STRIP001 			pDocSh->FillTransferableObjectDescriptor( aObjDesc );
//STRIP001 			aObjDesc.maDisplayName = pDocSh->GetMedium()->GetURLObject().GetURLNoPass();
//STRIP001 			// maSize is set in ScDrawTransferObj ctor
//STRIP001 
//STRIP001 			ScDrawTransferObj* pTransferObj = new ScDrawTransferObj( pModel, pDocSh, aObjDesc );
//STRIP001 			uno::Reference<datatransfer::XTransferable> xTransferable( pTransferObj );
//STRIP001 
//STRIP001 			SvEmbeddedObjectRef aPersistRef( aDragShellRef );
//STRIP001 			pTransferObj->SetDrawPersist( aPersistRef );	// keep persist for ole objects alive
//STRIP001 			pTransferObj->SetDragSource( pDrawView );		// copies selection
//STRIP001 
//STRIP001 			pDrawData = pTransferObj;
//STRIP001 			pDrawData->acquire();		// keep ref count up - released in ForgetView
//STRIP001 		}
//STRIP001 	}
//STRIP001 	DBG_ASSERT( pDrawData, "can't create DrawData" );
//STRIP001 }

//STRIP001 ScTransferObj* ScSelectionTransferObj::GetCellData()
//STRIP001 {
//STRIP001 	if ( !pCellData && ( eMode == SC_SELTRANS_CELL || eMode == SC_SELTRANS_CELLS ) )
//STRIP001 		CreateCellData();
//STRIP001 	return pCellData;
//STRIP001 }

//STRIP001 ScDrawTransferObj* ScSelectionTransferObj::GetDrawData()
//STRIP001 {
//STRIP001 	if ( !pDrawData && ( eMode == SC_SELTRANS_DRAW_BITMAP || eMode == SC_SELTRANS_DRAW_GRAPHIC ||
//STRIP001 						 eMode == SC_SELTRANS_DRAW_BOOKMARK || eMode == SC_SELTRANS_DRAW_OLE ||
//STRIP001 						 eMode == SC_SELTRANS_DRAW_OTHER ) )
//STRIP001 		CreateDrawData();
//STRIP001 	return pDrawData;
//STRIP001 }

//STRIP001 sal_Bool ScSelectionTransferObj::GetData( const ::com::sun::star::datatransfer::DataFlavor& rFlavor )
//STRIP001 {
//STRIP001 	sal_Bool bOK = sal_False;
//STRIP001 
//STRIP001 	uno::Reference<datatransfer::XTransferable> xSource;
//STRIP001 	switch (eMode)
//STRIP001 	{
//STRIP001 		case SC_SELTRANS_CELL:
//STRIP001 		case SC_SELTRANS_CELLS:
//STRIP001 			xSource = GetCellData();
//STRIP001 			break;
//STRIP001 		case SC_SELTRANS_DRAW_BITMAP:
//STRIP001 		case SC_SELTRANS_DRAW_GRAPHIC:
//STRIP001 		case SC_SELTRANS_DRAW_BOOKMARK:
//STRIP001 		case SC_SELTRANS_DRAW_OLE:
//STRIP001 		case SC_SELTRANS_DRAW_OTHER:
//STRIP001 			xSource = GetDrawData();
//STRIP001 			break;
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( xSource.is() )
//STRIP001 	{
//STRIP001 		TransferableDataHelper aHelper( xSource );
//STRIP001 		uno::Any aAny = aHelper.GetAny( rFlavor );
//STRIP001 		bOK = SetAny( aAny, rFlavor );
//STRIP001 	}
//STRIP001 
//STRIP001 	return bOK;
//STRIP001 }

//STRIP001 void ScSelectionTransferObj::ObjectReleased()
//STRIP001 {
//STRIP001 	//	called when another selection is set from outside
//STRIP001 
//STRIP001 	ForgetView();
//STRIP001 
//STRIP001 	ScModule* pScMod = SC_MOD();
//STRIP001 	if ( pScMod->GetSelectionTransfer() == this )
//STRIP001 		pScMod->SetSelectionTransfer( NULL );
//STRIP001 
//STRIP001 	TransferableHelper::ObjectReleased();
//STRIP001 }


}
