/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sc_inputwin.cxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 18:46:29 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifdef PCH
// auto strip #include "ui_pch.hxx"
#endif

#pragma hdrstop

//------------------------------------------------------------------

#include "scitems.hxx"
#include "eetext.hxx"
// auto strip #include <bf_svx/eeitem.hxx>
#define ITEMID_FIELD EE_FEATURE_FIELD

// auto strip #include <bf_svx/adjitem.hxx>
#include <bf_svx/editview.hxx>
// auto strip #include <bf_svx/editstat.hxx>
// auto strip #include <bf_svx/frmdiritem.hxx>
// auto strip #include <bf_svx/lspcitem.hxx>
// auto strip #include <bf_sfx2/bindings.hxx>
#include <bf_sfx2/dispatch.hxx>
#include <bf_sfx2/event.hxx>
#include <bf_sfx2/imgmgr.hxx>
// auto strip #include <bf_offmgr/app.hxx>
//#include <vcl/system.hxx>
#include <stdlib.h>		// qsort
// auto strip #include <bf_svx/scriptspaceitem.hxx>
// auto strip #include <bf_svx/scripttypeitem.hxx>

// auto strip #ifndef _SFXSTRITEM_HXX //autogen
// auto strip #include <svtools/stritem.hxx>
// auto strip #endif

#include "inputwin.hxx"
#include "scmod.hxx"
// auto strip #include "uiitems.hxx"
// auto strip #include "global.hxx"
#include "scresid.hxx"
#include "bf_sc.hrc"
#include "globstr.hrc"
#include "editutil.hxx"
#include "inputhdl.hxx"
#include "tabvwsh.hxx"
// auto strip #include "document.hxx"
#include "docsh.hxx"
// auto strip #include "appoptio.hxx"
#include "rangenam.hxx"
#include "compiler.hrc"
// auto strip #include "dbcolect.hxx"

// auto strip #ifndef _SVX_FONTITEM_HXX //autogen
// auto strip #include <bf_svx/fontitem.hxx>
// auto strip #endif

// auto strip #ifndef _COM_SUN_STAR_ACCESSIBILITY_XACCESSIBLE_HPP_ 
// auto strip #include <com/sun/star/accessibility/XAccessible.hpp>
// auto strip #endif
// auto strip #ifndef _SC_ACCESSIBLEEDITOBJECT_HXX
// auto strip #include "AccessibleEditObject.hxx"
// auto strip #endif
// auto strip #ifndef _SC_ACCESSIBLETEXT_HXX
// auto strip #include "AccessibleText.hxx"
// auto strip #endif
namespace binfilter {

#define TEXT_STARTPOS		3
#define THESIZE				1000000	//!!! langt... :-)
#define TBX_WINDOW_HEIGHT 	22 // in Pixeln - fuer alle Systeme gleich?


//==================================================================
//	class ScInputWindowWrapper
//==================================================================

/*N*/ SFX_IMPL_CHILDWINDOW(ScInputWindowWrapper,FID_INPUTLINE_STATUS)

/*N*/ ScInputWindowWrapper::ScInputWindowWrapper( Window*			 pParent,
/*N*/ 											USHORT			 nId,
/*N*/ 											SfxBindings*	 pBindings,
/*N*/ 											SfxChildWinInfo* pInfo )
/*N*/ 	:	SfxChildWindow( pParent, nId )
/*N*/ {
/*N*/     ScInputWindow* pWin=new ScInputWindow( pParent, pBindings );
/*N*/ 	pWindow = pWin;
/*N*/ 
/*N*/ 	pWin->Show();
/*N*/ 
/*N*/ 	pWin->SetSizePixel( pWin->CalcWindowSizePixel() );
/*N*/ 
/*N*/ 	eChildAlignment = SFX_ALIGN_LOWESTTOP;
/*N*/ 	pBindings->Invalidate( FID_TOGGLEINPUTLINE );
/*N*/ }

//	GetInfo fliegt wieder raus, wenn es ein SFX_IMPL_TOOLBOX gibt !!!!

/*N*/ SfxChildWinInfo __EXPORT ScInputWindowWrapper::GetInfo() const
/*N*/ {
/*N*/ 	SfxChildWinInfo aInfo = SfxChildWindow::GetInfo();
/*N*/ 	return aInfo;
/*N*/ }

//==================================================================

#define IMAGE(id) pImgMgr->SeekImage(id,bDark,pScMod)

//==================================================================
//	class ScInputWindow
//==================================================================

/*N*/ ScInputWindow::ScInputWindow( Window* pParent, SfxBindings* pBind ) :
/*N*/ #ifdef OS2
/*N*/ // #37192# ohne WB_CLIPCHILDREN wg. os/2 Paintproblem
/*N*/ 		ToolBox         ( pParent, WinBits(WB_BORDER|WB_3DLOOK) ),
/*N*/ #else
/*N*/ // mit WB_CLIPCHILDREN, sonst Flicker
/*N*/ 		ToolBox         ( pParent, WinBits(WB_BORDER|WB_3DLOOK|WB_CLIPCHILDREN) ),
/*N*/ #endif
/*N*/ 		aWndPos         ( this ),
/*N*/ 		aTextWindow     ( this ),
/*N*/ 		aTextOk			( ScResId( SCSTR_QHELP_BTNOK ) ),		// nicht immer neu aus Resource
/*N*/ 		aTextCancel		( ScResId( SCSTR_QHELP_BTNCANCEL ) ),
/*N*/ 		aTextSum		( ScResId( SCSTR_QHELP_BTNSUM ) ),
/*N*/ 		aTextEqual		( ScResId( SCSTR_QHELP_BTNEQUAL ) ),
/*N*/         pBindings       ( pBind ),
/*N*/ 		bIsOkCancelMode ( FALSE ),
/*N*/ 		pInputHdl		( NULL )
/*N*/ {
/*N*/     SfxImageManager* pImgMgr = pBindings->GetImageManager();
/*N*/ 	ScTabViewShell*	 pViewSh = PTR_CAST( ScTabViewShell, SfxViewShell::Current() );
/*N*/ 	ScModule*		 pScMod  = SC_MOD();
/*N*/ 
/*N*/ 	BOOL bDark = GetDisplayBackground().GetColor().IsDark();
/*N*/ 
/*N*/ 	// Positionsfenster, 3 Buttons, Eingabefenster
/*N*/ 	InsertWindow    ( 1, &aWndPos, 0,								      0 );
/*N*/ 	InsertSeparator ( 												   	  1 );
/*N*/ 	InsertItem      ( SID_INPUT_FUNCTION, IMAGE( SID_INPUT_FUNCTION ), 0, 2 );
/*N*/ 	InsertItem      ( SID_INPUT_SUM, 	  IMAGE( SID_INPUT_SUM ), 0,      3 );
/*N*/ 	InsertItem      ( SID_INPUT_EQUAL,	  IMAGE( SID_INPUT_EQUAL ), 0,    4 );
/*N*/ 	InsertSeparator ( 												      5 );
/*N*/ 	InsertWindow    ( 7, &aTextWindow, 0,                                 6 );
/*N*/ 
/*N*/ 	aWndPos	   .SetQuickHelpText( ScResId( SCSTR_QHELP_POSWND ) );
/*N*/ 	aWndPos    .SetHelpId		( HID_INSWIN_POS );
/*N*/ 	aTextWindow.SetQuickHelpText( ScResId( SCSTR_QHELP_INPUTWND ) );
/*N*/ 	aTextWindow.SetHelpId		( HID_INSWIN_INPUT );
/*N*/ 
/*N*/ 	//	kein SetHelpText, die Hilfetexte kommen aus der Hilfe
/*N*/ 
/*N*/ 	SetItemText ( SID_INPUT_FUNCTION, ScResId( SCSTR_QHELP_BTNCALC ) );
/*N*/ 	SetHelpId	( SID_INPUT_FUNCTION, HID_INSWIN_CALC );
/*N*/ 
/*N*/ 	SetItemText ( SID_INPUT_SUM, aTextSum );
/*N*/ 	SetHelpId	( SID_INPUT_SUM, HID_INSWIN_SUMME );
/*N*/ 
/*N*/ 	SetItemText ( SID_INPUT_EQUAL, aTextEqual );
/*N*/ 	SetHelpId	( SID_INPUT_EQUAL, HID_INSWIN_FUNC );
/*N*/ 
/*N*/ 	SetHelpId( HID_SC_INPUTWIN );	// fuer die ganze Eingabezeile
/*N*/ 
/*N*/ 	aWndPos		.Show();
/*N*/ 	aTextWindow	.Show();
/*N*/ 
/*N*/ 	pInputHdl = SC_MOD()->GetInputHdl( NULL, FALSE );	// use own handler even if ref-handler is set
/*N*/ 	if (pInputHdl)
/*?*/ 		pInputHdl->SetInputWindow( this );
/*N*/ 
/*N*/ 	if ( pInputHdl && pInputHdl->GetFormString().Len() )
/*N*/ 	{
	DBG_BF_ASSERT(0, "STRIP"); //STRIP001 /*?*/ 		//	Umschalten waehrend der Funktionsautopilot aktiv ist
//STRIP001 /*?*/ 		//	-> Inhalt des Funktionsautopiloten wieder anzeigen
//STRIP001 /*?*/ 		//!	auch Selektion (am InputHdl gemerkt) wieder anzeigen
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 		aTextWindow.SetTextString( pInputHdl->GetFormString() );
/*N*/ 	}
/*N*/ 	else if ( pInputHdl && pInputHdl->IsInputMode() )
/*N*/ 	{
/*?*/ 		//	wenn waehrend des Editierens die Eingabezeile weg war
/*?*/ 		//	(Editieren einer Formel, dann umschalten zu fremdem Dokument/Hilfe),
/*?*/ 		//	wieder den gerade editierten Text aus dem InputHandler anzeigen
/*?*/ 
	DBG_BF_ASSERT(0, "STRIP"); //STRIP001 /*?*/ 		aTextWindow.SetTextString( pInputHdl->GetEditString() );	// Text anzeigen
//STRIP001 /*?*/ 		if ( pInputHdl->IsTopMode() )
//STRIP001 /*?*/ 			pInputHdl->SetMode( SC_INPUT_TABLE );		// Focus kommt eh nach unten
/*N*/ 	}
/*N*/ 	else if ( pViewSh )
/*N*/ 	pViewSh->UpdateInputHandler( TRUE ); // unbedingtes Update
/*N*/ 
/*N*/ 	pImgMgr->RegisterToolBox( this, SC_MOD() );
/*N*/ }

/*N*/ __EXPORT ScInputWindow::~ScInputWindow()
/*N*/ {
/*N*/     BOOL bDown = ( ScGlobal::pSysLocale == NULL );    // after Clear?
/*N*/ 
/*N*/ 	//	if any view's input handler has a pointer to this input window, reset it
/*N*/ 	//	(may be several ones, #74522#)
/*N*/ 	//	member pInputHdl is not used here
/*N*/ 
/*N*/ 	if ( !bDown )
/*N*/ 	{
/*N*/ 		TypeId aScType = TYPE(ScTabViewShell);
/*N*/ 		SfxViewShell* pSh = SfxViewShell::GetFirst( &aScType );
/*N*/ 		while ( pSh )
/*N*/ 		{
/*N*/ 			ScInputHandler* pHdl = ((ScTabViewShell*)pSh)->GetInputHandler();
/*N*/ 			if ( pHdl && pHdl->GetInputWindow() == this )
/*?*/ 				pHdl->SetInputWindow( NULL );
/*N*/ 			pSh = SfxViewShell::GetNext( *pSh, &aScType );
/*N*/ 		}
/*N*/ 	}
/*N*/ 
/*N*/     pBindings->GetImageManager()->ReleaseToolBox( this );
/*N*/ }

//STRIP001 void ScInputWindow::SetInputHandler( ScInputHandler* pNew )
//STRIP001 {
//STRIP001 	//	wird im Activate der View gerufen...
//STRIP001 
//STRIP001     if ( pNew != pInputHdl )
//STRIP001 	{
//STRIP001 		//	Bei Reload (letzte Version) ist pInputHdl der Input-Handler der alten,
//STRIP001 		//	geloeschten ViewShell, darum hier auf keinen Fall anfassen!
//STRIP001 
//STRIP001 		pInputHdl = pNew;
//STRIP001 		if (pInputHdl)
//STRIP001 			pInputHdl->SetInputWindow( this );
//STRIP001 	}
//STRIP001 }

//STRIP001 sal_Bool ScInputWindow::UseSubTotal(ScRangeList* pRangeList) const
//STRIP001 {
//STRIP001     sal_Bool bSubTotal(sal_False);
//STRIP001     ScTabViewShell* pViewSh = PTR_CAST( ScTabViewShell, SfxViewShell::Current() );
//STRIP001     if ( pViewSh )
//STRIP001     {
//STRIP001         ScDocument* pDoc = pViewSh->GetViewData()->GetDocument();
//STRIP001         sal_Int32 nRangeCount (pRangeList->Count());
//STRIP001         sal_Int32 nRangeIndex (0);
//STRIP001         while (!bSubTotal && nRangeIndex < nRangeCount)
//STRIP001         {
//STRIP001             const ScRange* pRange = pRangeList->GetObject( nRangeIndex );
//STRIP001             if( pRange )
//STRIP001             {
//STRIP001                 sal_uInt16 nTabEnd(pRange->aEnd.Tab());
//STRIP001                 sal_uInt16 nTab(pRange->aStart.Tab());
//STRIP001                 while (!bSubTotal && nTab <= nTabEnd)
//STRIP001                 {
//STRIP001                     sal_uInt16 nRowEnd(pRange->aEnd.Row());
//STRIP001                     sal_uInt16 nRow(pRange->aStart.Row());
//STRIP001                     while (!bSubTotal && nRow <= nRowEnd)
//STRIP001                     {
//STRIP001                         if (pDoc->IsFiltered(nRow, nTab))
//STRIP001                             bSubTotal = sal_True;
//STRIP001                         else
//STRIP001                             ++nRow;
//STRIP001                     }
//STRIP001                     ++nTab;
//STRIP001                 }
//STRIP001             }
//STRIP001             ++nRangeIndex;
//STRIP001         }
//STRIP001 
//STRIP001         ScDBCollection* pDBCollection = pDoc->GetDBCollection();
//STRIP001         sal_uInt16 nDBCount (pDBCollection->GetCount());
//STRIP001         sal_uInt16 nDBIndex (0);
//STRIP001         while (!bSubTotal && nDBIndex < nDBCount)
//STRIP001         {
//STRIP001             ScDBData* pDB = (*pDBCollection)[nDBIndex];
//STRIP001             if (pDB && pDB->HasAutoFilter())
//STRIP001             {
//STRIP001                 nRangeIndex = 0;
//STRIP001                 while (!bSubTotal && nRangeIndex < nRangeCount)
//STRIP001                 {
//STRIP001                     const ScRange* pRange = pRangeList->GetObject( nRangeIndex );
//STRIP001                     if( pRange )
//STRIP001                     {
//STRIP001                         ScRange aDBArea;
//STRIP001                         pDB->GetArea(aDBArea);
//STRIP001                         if (aDBArea.Intersects(*pRange))
//STRIP001                             bSubTotal = sal_True;
//STRIP001                     }
//STRIP001                     ++nRangeIndex;
//STRIP001                 }
//STRIP001             }
//STRIP001             ++nDBIndex;
//STRIP001         }
//STRIP001     }
//STRIP001     return bSubTotal;
//STRIP001 }

//STRIP001 void __EXPORT ScInputWindow::Select()
//STRIP001 {
//STRIP001 	ScModule* pScMod = SC_MOD();
//STRIP001 	ToolBox::Select();
//STRIP001 
//STRIP001 	switch ( GetCurItemId() )
//STRIP001 	{
//STRIP001 		case SID_INPUT_FUNCTION:
//STRIP001 			{
//STRIP001 				//!	new method at ScModule to query if function autopilot is open
//STRIP001 				SfxViewFrame* pViewFrm = SfxViewFrame::Current();
//STRIP001 				if ( pViewFrm && !pViewFrm->GetChildWindow( SID_OPENDLG_FUNCTION ) )
//STRIP001 				{
//STRIP001 					pViewFrm->GetDispatcher()->Execute( SID_OPENDLG_FUNCTION,
//STRIP001 											  SFX_CALLMODE_SYNCHRON | SFX_CALLMODE_RECORD );
//STRIP001 
//STRIP001 					//	die Toolbox wird sowieso disabled, also braucht auch nicht umgeschaltet
//STRIP001 					//	zu werden, egal ob's geklappt hat oder nicht
//STRIP001 //					SetOkCancelMode();
//STRIP001 				}
//STRIP001 			}
//STRIP001 			break;
//STRIP001 
//STRIP001 		case SID_INPUT_CANCEL:
//STRIP001 			pScMod->InputCancelHandler();
//STRIP001 			SetSumAssignMode();
//STRIP001 			break;
//STRIP001 
//STRIP001 		case SID_INPUT_OK:
//STRIP001 			pScMod->InputEnterHandler();
//STRIP001 			SetSumAssignMode();
//STRIP001 			aTextWindow.Invalidate();		// sonst bleibt Selektion stehen
//STRIP001 			break;
//STRIP001 
//STRIP001 		case SID_INPUT_SUM:
//STRIP001 			{
//STRIP001 				ScTabViewShell* pViewSh = PTR_CAST( ScTabViewShell, SfxViewShell::Current() );
//STRIP001 				if ( pViewSh )
//STRIP001 				{
//STRIP001 					ScMarkData& rMark = pViewSh->GetViewData()->GetMarkData();
//STRIP001 
//STRIP001 					ScRangeList* pRangeList = new ScRangeList;
//STRIP001 					BOOL bDataFound = pViewSh->GetAutoSumArea( *pRangeList );
//STRIP001 
//STRIP001                     sal_Bool bSubTotal(UseSubTotal(pRangeList));
//STRIP001 
//STRIP001 					if ((rMark.IsMarked() || rMark.IsMultiMarked()) && bDataFound)
//STRIP001 					{
//STRIP001 						pViewSh->EnterAutoSum( *pRangeList, bSubTotal );	// Block mit Summen fuellen
//STRIP001 					}
//STRIP001 					else									// nur in Eingabezeile einfuegen
//STRIP001 					{
//STRIP001 						String aFormula = '=';
//STRIP001 						ScFunctionMgr* pFuncMgr = ScGlobal::GetStarCalcFunctionMgr();
//STRIP001 						ScFuncDesc* pDesc = NULL;
//STRIP001                         if (!bSubTotal)
//STRIP001                             pDesc = pFuncMgr->Get( SC_OPCODE_SUM );
//STRIP001                         else
//STRIP001                             pDesc = pFuncMgr->Get( SC_OPCODE_SUB_TOTAL );
//STRIP001 						if ( pDesc && pDesc->pFuncName )
//STRIP001 						{
//STRIP001 							aFormula += *pDesc->pFuncName;
//STRIP001                             if (bSubTotal)
//STRIP001                                 aFormula.AppendAscii(RTL_CONSTASCII_STRINGPARAM( "(9;)" ));
//STRIP001                             else
//STRIP001 							    aFormula.AppendAscii(RTL_CONSTASCII_STRINGPARAM( "()" ));
//STRIP001 						}
//STRIP001 
//STRIP001 						xub_StrLen nPos = aFormula.Len() - 1;
//STRIP001 						String aRef;
//STRIP001                         ScDocument* pDoc = pViewSh->GetViewData()->GetDocument();
//STRIP001 						pRangeList->Format( aRef, SCA_VALID, pDoc );
//STRIP001 						aFormula.Insert( aRef, nPos );
//STRIP001 
//STRIP001 						SetFuncString( aFormula );
//STRIP001 
//STRIP001 						if ( bDataFound && pScMod->IsEditMode() )
//STRIP001 						{
//STRIP001 							ScInputHandler* pHdl = pScMod->GetInputHdl( pViewSh );
//STRIP001 							if ( pHdl )
//STRIP001 							{
//STRIP001 								pHdl->InitRangeFinder( aFormula );
//STRIP001 
//STRIP001 								//!	SetSelection am InputHandler ???
//STRIP001 								//!	bSelIsRef setzen ???
//STRIP001 								xub_StrLen nOpen = aFormula.Search('(');
//STRIP001 								xub_StrLen nLen = aFormula.Len();
//STRIP001 								if ( nOpen != STRING_NOTFOUND && nLen > nOpen )
//STRIP001 								{
//STRIP001                                     sal_uInt8 nAdd(1);
//STRIP001                                     if (bSubTotal)
//STRIP001                                         nAdd = 3;
//STRIP001 									ESelection aSel(0,nOpen+nAdd,0,nLen-1);
//STRIP001 									EditView* pTableView = pHdl->GetTableView();
//STRIP001 									if (pTableView)
//STRIP001 										pTableView->SetSelection(aSel);
//STRIP001 									EditView* pTopView = pHdl->GetTopView();
//STRIP001 									if (pTopView)
//STRIP001 										pTopView->SetSelection(aSel);
//STRIP001 								}
//STRIP001 							}
//STRIP001 						}
//STRIP001 					}
//STRIP001 					delete pRangeList;
//STRIP001 				}
//STRIP001 			}
//STRIP001 			break;
//STRIP001 
//STRIP001 		case SID_INPUT_EQUAL:
//STRIP001 		{
//STRIP001 			aTextWindow.StartEditEngine();
//STRIP001 			if ( pScMod->IsEditMode() )			// nicht, wenn z.B. geschuetzt
//STRIP001 			{
//STRIP001 				aTextWindow.GrabFocus();
//STRIP001 				aTextWindow.SetTextString( '=' );
//STRIP001 
//STRIP001 				EditView* pView = aTextWindow.GetEditView();
//STRIP001 				if (pView)
//STRIP001 				{
//STRIP001 					pView->SetSelection( ESelection(0,1, 0,1) );
//STRIP001 					pScMod->InputChanged(pView);
//STRIP001 					SetOkCancelMode();
//STRIP001 					pView->SetEditEngineUpdateMode(TRUE);
//STRIP001 				}
//STRIP001 			}
//STRIP001 			break;
//STRIP001 		}
//STRIP001 	}
//STRIP001 }

/*N*/ void __EXPORT ScInputWindow::Resize()
/*N*/ {
/*N*/ 	ToolBox::Resize();
/*N*/ 
/*N*/ 	long nWidth = GetSizePixel().Width();
/*N*/ 	long nLeft  = aTextWindow.GetPosPixel().X();
/*N*/ 	Size aSize  = aTextWindow.GetSizePixel();
/*N*/ 
/*N*/ 	aSize.Width() = Max( ((long)(nWidth - nLeft - 5)), (long)0 );
/*N*/ 	aTextWindow.SetSizePixel( aSize );
/*N*/ 	aTextWindow.Invalidate();
/*N*/ }

//STRIP001 void ScInputWindow::SetFuncString( const String& rString, BOOL bDoEdit )
//STRIP001 {
//STRIP001 	//!	new method at ScModule to query if function autopilot is open
//STRIP001 	SfxViewFrame* pViewFrm = SfxViewFrame::Current();
//STRIP001 	EnableButtons( pViewFrm && !pViewFrm->GetChildWindow( SID_OPENDLG_FUNCTION ) );
//STRIP001 	aTextWindow.StartEditEngine();
//STRIP001 
//STRIP001 	ScModule* pScMod = SC_MOD();
//STRIP001 	if ( pScMod->IsEditMode() )
//STRIP001 	{
//STRIP001 		if ( bDoEdit )
//STRIP001 			aTextWindow.GrabFocus();
//STRIP001 		aTextWindow.SetTextString( rString );
//STRIP001 		EditView* pView = aTextWindow.GetEditView();
//STRIP001 		if (pView)
//STRIP001 		{
//STRIP001 			xub_StrLen nLen = rString.Len();
//STRIP001 
//STRIP001 			if ( nLen > 0 )
//STRIP001 			{
//STRIP001 				nLen--;
//STRIP001 				pView->SetSelection( ESelection( 0, nLen, 0, nLen ) );
//STRIP001 			}
//STRIP001 
//STRIP001 			pScMod->InputChanged(pView);
//STRIP001 			if ( bDoEdit )
//STRIP001 				SetOkCancelMode();			// nicht, wenn gleich hinterher Enter/Cancel
//STRIP001 
//STRIP001 			pView->SetEditEngineUpdateMode(TRUE);
//STRIP001 		}
//STRIP001 	}
//STRIP001 }

//STRIP001 void ScInputWindow::SetPosString( const String& rStr )
//STRIP001 {
//STRIP001 	aWndPos.SetPos( rStr );
//STRIP001 }

//STRIP001 void ScInputWindow::SetTextString( const String& rString )
//STRIP001 {
//STRIP001 	if (rString.Len() <= 32767)
//STRIP001 		aTextWindow.SetTextString(rString);
//STRIP001 	else
//STRIP001 	{
//STRIP001 		String aNew = rString;
//STRIP001 		aNew.Erase(32767);
//STRIP001 		aTextWindow.SetTextString(aNew);
//STRIP001 	}
//STRIP001 }

//STRIP001 const String& ScInputWindow::GetTextString()
//STRIP001 {
//STRIP001 	return aTextWindow.GetTextString();
//STRIP001 }

//STRIP001 void ScInputWindow::SetOkCancelMode()
//STRIP001 {
//STRIP001 	//!	new method at ScModule to query if function autopilot is open
//STRIP001 	SfxViewFrame* pViewFrm = SfxViewFrame::Current();
//STRIP001 	EnableButtons( pViewFrm && !pViewFrm->GetChildWindow( SID_OPENDLG_FUNCTION ) );
//STRIP001 
//STRIP001 	ScModule* pScMod = SC_MOD();
//STRIP001     SfxImageManager* pImgMgr = pBindings->GetImageManager();
//STRIP001 	if (!bIsOkCancelMode)
//STRIP001 	{
//STRIP001 		BOOL bDark = GetDisplayBackground().GetColor().IsDark();
//STRIP001 
//STRIP001 		RemoveItem( 3 ); // SID_INPUT_SUM und SID_INPUT_EQUAL entfernen
//STRIP001 		RemoveItem( 3 );
//STRIP001 		InsertItem( SID_INPUT_CANCEL, IMAGE( SID_INPUT_CANCEL ), 0, 3 );
//STRIP001 		InsertItem( SID_INPUT_OK,	  IMAGE( SID_INPUT_OK ),	 0, 4 );
//STRIP001 		SetItemText	( SID_INPUT_CANCEL, aTextCancel );
//STRIP001 		SetHelpId	( SID_INPUT_CANCEL, HID_INSWIN_CANCEL );
//STRIP001 		SetItemText	( SID_INPUT_OK,		aTextOk );
//STRIP001 		SetHelpId	( SID_INPUT_OK,		HID_INSWIN_OK );
//STRIP001 		bIsOkCancelMode = TRUE;
//STRIP001 	}
//STRIP001 }

//STRIP001 void ScInputWindow::SetSumAssignMode()
//STRIP001 {
//STRIP001 	//!	new method at ScModule to query if function autopilot is open
//STRIP001 	SfxViewFrame* pViewFrm = SfxViewFrame::Current();
//STRIP001 	EnableButtons( pViewFrm && !pViewFrm->GetChildWindow( SID_OPENDLG_FUNCTION ) );
//STRIP001 
//STRIP001 	ScModule* pScMod = SC_MOD();
//STRIP001     SfxImageManager* pImgMgr = pBindings->GetImageManager();
//STRIP001 	if (bIsOkCancelMode)
//STRIP001 	{
//STRIP001 		BOOL bDark = GetDisplayBackground().GetColor().IsDark();
//STRIP001 
//STRIP001 		// SID_INPUT_CANCEL, und SID_INPUT_OK entfernen
//STRIP001 		RemoveItem( 3 );
//STRIP001 		RemoveItem( 3 );
//STRIP001 		InsertItem( SID_INPUT_SUM, 	 IMAGE( SID_INPUT_SUM ), 	 0, 3 );
//STRIP001 		InsertItem( SID_INPUT_EQUAL, IMAGE( SID_INPUT_EQUAL ),	 0, 4 );
//STRIP001 		SetItemText	( SID_INPUT_SUM,   aTextSum );
//STRIP001 		SetHelpId	( SID_INPUT_SUM,   HID_INSWIN_SUMME );
//STRIP001 		SetItemText	( SID_INPUT_EQUAL, aTextEqual );
//STRIP001 		SetHelpId	( SID_INPUT_EQUAL, HID_INSWIN_FUNC );
//STRIP001 		bIsOkCancelMode = FALSE;
//STRIP001 
//STRIP001 		SetFormulaMode(FALSE);		// kein editieren -> keine Formel
//STRIP001 	}
//STRIP001 }

//STRIP001 void ScInputWindow::SetFormulaMode( BOOL bSet )
//STRIP001 {
//STRIP001 	aWndPos.SetFormulaMode(bSet);
//STRIP001 	aTextWindow.SetFormulaMode(bSet);
//STRIP001 }

//STRIP001 void __EXPORT ScInputWindow::SetText( const String& rString )
//STRIP001 {
//STRIP001 	ToolBox::SetText(rString);
//STRIP001 }

//STRIP001 String __EXPORT ScInputWindow::GetText() const
//STRIP001 {
//STRIP001 	return ToolBox::GetText();
//STRIP001 }


//STRIP001 EditView* ScInputWindow::ActivateEdit( const String&     rText,
//STRIP001 									   const ESelection& rSel )
//STRIP001 {
//STRIP001 	if ( !aTextWindow.IsActive() )
//STRIP001 	{
//STRIP001 		aTextWindow.StartEditEngine();
//STRIP001 		aTextWindow.GrabFocus();
//STRIP001 		aTextWindow.SetTextString( rText );
//STRIP001 		aTextWindow.GetEditView()->SetSelection( rSel );
//STRIP001 	}
//STRIP001 
//STRIP001 	return aTextWindow.GetEditView();
//STRIP001 }

//STRIP001 BOOL ScInputWindow::IsActive()
//STRIP001 {
//STRIP001 	return aTextWindow.IsActive();
//STRIP001 }

//STRIP001 EditView* ScInputWindow::GetEditView()
//STRIP001 {
//STRIP001 	return aTextWindow.GetEditView();
//STRIP001 }

//STRIP001 void ScInputWindow::MakeDialogEditView()
//STRIP001 {
//STRIP001 	aTextWindow.MakeDialogEditView();
//STRIP001 }

//STRIP001 void ScInputWindow::StopEditEngine( BOOL bAll )
//STRIP001 {
//STRIP001 	aTextWindow.StopEditEngine( bAll );
//STRIP001 }

//STRIP001 void ScInputWindow::TextGrabFocus()
//STRIP001 {
//STRIP001 	aTextWindow.GrabFocus();
//STRIP001 }

//STRIP001 void ScInputWindow::TextInvalidate()
//STRIP001 {
//STRIP001 	aTextWindow.Invalidate();
//STRIP001 }

//STRIP001 void ScInputWindow::SwitchToTextWin()
//STRIP001 {
//STRIP001 	// used for shift-ctrl-F2
//STRIP001 
//STRIP001 	aTextWindow.StartEditEngine();
//STRIP001 	if ( SC_MOD()->IsEditMode() )
//STRIP001 	{
//STRIP001 		aTextWindow.GrabFocus();
//STRIP001 		EditView* pView = aTextWindow.GetEditView();
//STRIP001 		if (pView)
//STRIP001 		{
//STRIP001 			xub_StrLen nLen = pView->GetEditEngine()->GetTextLen(0);
//STRIP001 			ESelection aSel( 0, nLen, 0, nLen );
//STRIP001 			pView->SetSelection( aSel );				// set cursor to end of text
//STRIP001 		}
//STRIP001 	}
//STRIP001 }

//STRIP001 void ScInputWindow::PosGrabFocus()
//STRIP001 {
//STRIP001 	aWndPos.GrabFocus();
//STRIP001 }

//STRIP001 void ScInputWindow::EnableButtons( BOOL bEnable )
//STRIP001 {
//STRIP001 	//	when enabling buttons, always also enable the input window itself
//STRIP001 	if ( bEnable && !IsEnabled() )
//STRIP001 		Enable();
//STRIP001 
//STRIP001 	EnableItem( SID_INPUT_FUNCTION,									  bEnable );
//STRIP001 	EnableItem( bIsOkCancelMode ? SID_INPUT_CANCEL : SID_INPUT_SUM,   bEnable );
//STRIP001 	EnableItem( bIsOkCancelMode ? SID_INPUT_OK     : SID_INPUT_EQUAL, bEnable );
//STRIP001 //	Invalidate();
//STRIP001 }

/*N*/ void ScInputWindow::StateChanged( StateChangedType nType )
/*N*/ {
/*N*/ 	ToolBox::StateChanged( nType );
/*N*/ 
/*N*/ 	if ( nType == STATE_CHANGE_INITSHOW ) Resize();
/*N*/ }

//STRIP001 void ScInputWindow::DataChanged( const DataChangedEvent& rDCEvt )
//STRIP001 {
//STRIP001 	if ( rDCEvt.GetType() == DATACHANGED_SETTINGS && (rDCEvt.GetFlags() & SETTINGS_STYLE) )
//STRIP001 	{
//STRIP001 		//	update item images
//STRIP001 
//STRIP001 		ScModule*		 pScMod  = SC_MOD();
//STRIP001 	    SfxImageManager* pImgMgr = pBindings->GetImageManager();
//STRIP001 		BOOL bDark = GetDisplayBackground().GetColor().IsDark();
//STRIP001 		// IMAGE macro uses pScMod, pImgMgr, bDark
//STRIP001 
//STRIP001 		SetItemImage( SID_INPUT_FUNCTION, IMAGE( SID_INPUT_FUNCTION ) );
//STRIP001 		if ( bIsOkCancelMode )
//STRIP001 		{
//STRIP001 			SetItemImage( SID_INPUT_CANCEL, IMAGE( SID_INPUT_CANCEL ) );
//STRIP001 			SetItemImage( SID_INPUT_OK,     IMAGE( SID_INPUT_OK ) );
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			SetItemImage( SID_INPUT_SUM,   IMAGE( SID_INPUT_SUM ) );
//STRIP001 			SetItemImage( SID_INPUT_EQUAL, IMAGE( SID_INPUT_EQUAL ) );
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001     ToolBox::DataChanged( rDCEvt );
//STRIP001 }

//========================================================================
// 							Eingabefenster
//========================================================================

/*N*/ ScTextWnd::ScTextWnd( Window* pParent )
/*N*/ 	:	Window		 ( pParent, WinBits(WB_HIDE | WB_BORDER) ),
/*N*/ 		DragSourceHelper( this ),
/*N*/ 		pEditEngine	 ( NULL ),
/*N*/ 		pEditView	 ( NULL ),
/*N*/         pAccTextData ( NULL ),
/*N*/ 		bIsInsertMode( TRUE ),
/*N*/ 		bFormulaMode ( FALSE ),
/*N*/         bInputMode   ( FALSE )
/*N*/ {
/*N*/ 	EnableRTL( FALSE );		// #106269# EditEngine can't be used with VCL EnableRTL
/*N*/ 
/*N*/ 	bIsRTL = GetSettings().GetLayoutRTL();
/*N*/ 
/*N*/ 	//	#79096# always use application font, so a font with cjk chars can be installed
/*N*/ 	Font aAppFont = GetFont();
/*N*/ 	aTextFont = aAppFont;
/*N*/ 	aTextFont.SetSize( PixelToLogic( aAppFont.GetSize(), MAP_TWIP ) );	// AppFont ist in Pixeln
/*N*/ 
/*N*/ 	const StyleSettings& rStyleSettings = Application::GetSettings().GetStyleSettings();
/*N*/ 
/*N*/ 	Color aBgColor= rStyleSettings.GetWindowColor();
/*N*/ 	Color aTxtColor= rStyleSettings.GetWindowTextColor();
/*N*/ 
/*N*/ 	aTextFont.SetTransparent ( TRUE );
/*N*/ 	aTextFont.SetFillColor   ( aBgColor );
/*N*/ 	//aTextFont.SetColor		 ( COL_FIELDTEXT );
/*N*/ 	aTextFont.SetColor		 (aTxtColor);
/*N*/ 	aTextFont.SetWeight		 ( WEIGHT_NORMAL );
/*N*/ 
/*N*/ 	SetSizePixel		( Size(1,TBX_WINDOW_HEIGHT) );
/*N*/ 	SetBackground		( aBgColor );
/*N*/ 	SetLineColor		( COL_BLACK );
/*N*/ 	SetMapMode		    ( MAP_TWIP );
/*N*/ 	SetPointer		    ( POINTER_TEXT );
/*N*/ }

/*N*/ __EXPORT ScTextWnd::~ScTextWnd()
/*N*/ {
/*N*/ 	delete pEditView;
/*N*/ 	delete pEditEngine;
/*N*/     if (pAccTextData)
/*?*/      {DBG_BF_ASSERT(0, "STRIP"); }//STRIP001    pAccTextData->Dispose();
/*N*/ }

//STRIP001 void __EXPORT ScTextWnd::Paint( const Rectangle& rRec )
//STRIP001 {
//STRIP001 	if (pEditView)
//STRIP001 		pEditView->Paint( rRec );
//STRIP001 	else
//STRIP001 	{
//STRIP001 		SetFont( aTextFont );
//STRIP001 
//STRIP001 		long nDiff =  GetOutputSizePixel().Height()
//STRIP001 					- LogicToPixel( Size( 0, GetTextHeight() ) ).Height();
//STRIP001 //		if (nDiff<2) nDiff=2;		// mind. 1 Pixel
//STRIP001 
//STRIP001 		long nStartPos = TEXT_STARTPOS;
//STRIP001 		if ( bIsRTL )
//STRIP001 		{
//STRIP001 			//	right-align
//STRIP001 			nStartPos += GetOutputSizePixel().Width() - 2*TEXT_STARTPOS -
//STRIP001 						LogicToPixel( Size( GetTextWidth( aString ), 0 ) ).Width();
//STRIP001 
//STRIP001 			//	LayoutMode isn't changed as long as ModifyRTLDefaults doesn't include SvxFrameDirectionItem
//STRIP001 		}
//STRIP001 
//STRIP001 		DrawText( PixelToLogic( Point( nStartPos, nDiff/2 ) ), aString );
//STRIP001 	}
//STRIP001 }

/*N*/ void __EXPORT ScTextWnd::Resize()
/*N*/ {
/*N*/ 	if (pEditView)
/*?*/ 	{
/*?*/ 		Size aSize = GetOutputSizePixel();
/*?*/ 		long nDiff =  aSize.Height()
/*?*/ 					- LogicToPixel( Size( 0, GetTextHeight() ) ).Height();
/*?*/ 
/*?*/ #ifdef OS2_DOCH_NICHT
/*?*/ 		nDiff-=2;		// wird durch 2 geteilt
/*?*/ 						// passt sonst nicht zur normalen Textausgabe
/*?*/ #endif
/*?*/ 
/*?*/ 		aSize.Width() -= 2 * TEXT_STARTPOS - 1;
/*?*/ 
/*?*/ 		pEditView->SetOutputArea(
/*?*/ 			PixelToLogic( Rectangle( Point( TEXT_STARTPOS, (nDiff > 0) ? nDiff/2 : 1 ),
/*?*/ 									 aSize ) ) );
/*N*/ 	}
/*N*/ }

//STRIP001 void __EXPORT ScTextWnd::MouseMove( const MouseEvent& rMEvt )
//STRIP001 {
//STRIP001 	if (pEditView)
//STRIP001 		pEditView->MouseMove( rMEvt );
//STRIP001 }
//STRIP001 
//STRIP001 void __EXPORT ScTextWnd::MouseButtonDown( const MouseEvent& rMEvt )
//STRIP001 {
//STRIP001 	if (!HasFocus())
//STRIP001 	{
//STRIP001 		StartEditEngine();
//STRIP001 		if ( SC_MOD()->IsEditMode() )
//STRIP001 			GrabFocus();
//STRIP001 	}
//STRIP001 
//STRIP001 	if (pEditView)
//STRIP001 	{
//STRIP001 		pEditView->SetEditEngineUpdateMode( TRUE );
//STRIP001 		pEditView->MouseButtonDown( rMEvt );
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 void __EXPORT ScTextWnd::MouseButtonUp( const MouseEvent& rMEvt )
//STRIP001 {
//STRIP001 	if (pEditView)
//STRIP001 		if (pEditView->MouseButtonUp( rMEvt ))
//STRIP001 		{
//STRIP001 			if ( rMEvt.IsMiddle() && 
//STRIP001 		         	GetSettings().GetMouseSettings().GetMiddleButtonAction() == MOUSE_MIDDLE_PASTESELECTION )
//STRIP001 		    {
//STRIP001 		    	//	EditView may have pasted from selection
//STRIP001 		    	SC_MOD()->InputChanged( pEditView );
//STRIP001 		    }				
//STRIP001 			else
//STRIP001 				SC_MOD()->InputSelection( pEditView );
//STRIP001 		}
//STRIP001 }
//STRIP001 
//STRIP001 void __EXPORT ScTextWnd::Command( const CommandEvent& rCEvt )
//STRIP001 {
//STRIP001     bInputMode = TRUE;
//STRIP001 	USHORT nCommand = rCEvt.GetCommand();
//STRIP001 	if ( pEditView /* && ( nCommand == COMMAND_STARTDRAG || nCommand == COMMAND_VOICE ) */ )
//STRIP001 	{
//STRIP001 		ScModule* pScMod = SC_MOD();
//STRIP001 		ScTabViewShell* pStartViewSh = ScTabViewShell::GetActiveViewShell();
//STRIP001 
//STRIP001 		// #109441# don't modify the font defaults here - the right defaults are
//STRIP001 		// already set in StartEditEngine when the EditEngine is created
//STRIP001 
//STRIP001 		// #63263# verhindern, dass die EditView beim View-Umschalten wegkommt
//STRIP001 		pScMod->SetInEditCommand( TRUE );
//STRIP001 		pEditView->Command( rCEvt );
//STRIP001 		pScMod->SetInEditCommand( FALSE );
//STRIP001 
//STRIP001 		//	#48929# COMMAND_STARTDRAG heiss noch lange nicht, dass der Inhalt geaendert wurde
//STRIP001 		//	darum in dem Fall kein InputChanged
//STRIP001 		//!	erkennen, ob mit Move gedraggt wurde, oder Drag&Move irgendwie verbieten
//STRIP001 
//STRIP001 		if ( nCommand == COMMAND_STARTDRAG )
//STRIP001 		{
//STRIP001 			//	ist auf eine andere View gedraggt worden?
//STRIP001 			ScTabViewShell* pEndViewSh = ScTabViewShell::GetActiveViewShell();
//STRIP001 			if ( pEndViewSh != pStartViewSh && pStartViewSh != NULL )
//STRIP001 			{
//STRIP001 				ScViewData* pViewData = pStartViewSh->GetViewData();
//STRIP001 				ScInputHandler* pHdl = pScMod->GetInputHdl( pStartViewSh );
//STRIP001 				if ( pHdl && pViewData->HasEditView( pViewData->GetActivePart() ) )
//STRIP001 				{
//STRIP001 					pHdl->CancelHandler();
//STRIP001 					pViewData->GetView()->ShowCursor();		// fehlt bei KillEditView, weil nicht aktiv
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 		else if ( nCommand == COMMAND_CURSORPOS )
//STRIP001 		{
//STRIP001 			//	don't call InputChanged for COMMAND_CURSORPOS
//STRIP001 		}
//STRIP001 		else
//STRIP001 			SC_MOD()->InputChanged( pEditView );
//STRIP001 	}
//STRIP001 	else
//STRIP001 		Window::Command(rCEvt);		//	sonst soll sich die Basisklasse drum kuemmern...
//STRIP001 
//STRIP001     bInputMode = FALSE;
//STRIP001 }
//STRIP001 
//STRIP001 void ScTextWnd::StartDrag( sal_Int8 nAction, const Point& rPosPixel )
//STRIP001 {
//STRIP001 	if ( pEditView )
//STRIP001 	{
//STRIP001 		::com::mandEvent aDragEvent( rPosPixel, COMMAND_STARTDRAG, TRUE );
//STRIP001 		pEditView->Command( aDragEvent );
//STRIP001 
//STRIP001 		//	handling of d&d to different view (CancelHandler) can't be done here,
//STRIP001 		//	because the call returns before d&d is complete.
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 void __EXPORT ScTextWnd::KeyInput(const KeyEvent& rKEvt)
//STRIP001 {
//STRIP001     bInputMode = TRUE;
//STRIP001 	if (!SC_MOD()->InputKeyEvent( rKEvt ))
//STRIP001 	{
//STRIP001 		BOOL bUsed = FALSE;
//STRIP001 		ScTabViewShell* pViewSh = ScTabViewShell::GetActiveViewShell();
//STRIP001 		if ( pViewSh )
//STRIP001 			bUsed = pViewSh->SfxKeyInput(rKEvt);	// nur Acceleratoren, keine Eingabe
//STRIP001 		if (!bUsed)
//STRIP001 			Window::KeyInput( rKEvt );
//STRIP001 	}
//STRIP001     bInputMode = FALSE;
//STRIP001 }
//STRIP001 
//STRIP001 void __EXPORT ScTextWnd::GetFocus()
//STRIP001 {
//STRIP001 }
//STRIP001 
//STRIP001 void __EXPORT ScTextWnd::LoseFocus()
//STRIP001 {
//STRIP001 }
//STRIP001 
//STRIP001 String __EXPORT ScTextWnd::GetText() const
//STRIP001 {
//STRIP001 	//	ueberladen, um per Testtool an den Text heranzukommen
//STRIP001 
//STRIP001 	if ( pEditEngine )
//STRIP001 		return pEditEngine->GetText();
//STRIP001 	else
//STRIP001 		return GetTextString();
//STRIP001 }
//STRIP001 
//STRIP001 void ScTextWnd::SetFormulaMode( BOOL bSet )
//STRIP001 {
//STRIP001 	if ( bSet != bFormulaMode )
//STRIP001 	{
//STRIP001 		bFormulaMode = bSet;
//STRIP001 		UpdateAutoCorrFlag();
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 void ScTextWnd::UpdateAutoCorrFlag()
//STRIP001 {
//STRIP001 	if ( pEditEngine )
//STRIP001 	{
//STRIP001 		ULONG nControl = pEditEngine->GetControlWord();
//STRIP001 		ULONG nOld = nControl;
//STRIP001 		if ( bFormulaMode )
//STRIP001 			nControl &= ~EE_CNTRL_AUTOCORRECT;		// keine Autokorrektur in Formeln
//STRIP001 		else
//STRIP001 			nControl |= EE_CNTRL_AUTOCORRECT;		// sonst schon
//STRIP001 		if ( nControl != nOld )
//STRIP001 			pEditEngine->SetControlWord( nControl );
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 void lcl_ExtendEditFontAttribs( SfxItemSet& rSet )
//STRIP001 {
//STRIP001 	const SfxPoolItem& rFontItem = rSet.Get( EE_CHAR_FONTINFO );
//STRIP001 	rSet.Put( rFontItem, EE_CHAR_FONTINFO_CJK );
//STRIP001 	rSet.Put( rFontItem, EE_CHAR_FONTINFO_CTL );
//STRIP001 	const SfxPoolItem& rHeightItem = rSet.Get( EE_CHAR_FONTHEIGHT );
//STRIP001 	rSet.Put( rHeightItem, EE_CHAR_FONTHEIGHT_CJK );
//STRIP001 	rSet.Put( rHeightItem, EE_CHAR_FONTHEIGHT_CTL );
//STRIP001 	const SfxPoolItem& rWeightItem = rSet.Get( EE_CHAR_WEIGHT );
//STRIP001 	rSet.Put( rWeightItem, EE_CHAR_WEIGHT_CJK );
//STRIP001 	rSet.Put( rWeightItem, EE_CHAR_WEIGHT_CTL );
//STRIP001 	const SfxPoolItem& rItalicItem = rSet.Get( EE_CHAR_ITALIC );
//STRIP001 	rSet.Put( rItalicItem, EE_CHAR_ITALIC_CJK );
//STRIP001 	rSet.Put( rItalicItem, EE_CHAR_ITALIC_CTL );
//STRIP001 	const SfxPoolItem& rLangItem = rSet.Get( EE_CHAR_LANGUAGE );
//STRIP001 	rSet.Put( rLangItem, EE_CHAR_LANGUAGE_CJK );
//STRIP001 	rSet.Put( rLangItem, EE_CHAR_LANGUAGE_CTL );
//STRIP001 }
//STRIP001 
//STRIP001 void lcl_ModifyRTLDefaults( SfxItemSet& rSet )
//STRIP001 {
//STRIP001 	rSet.Put( SvxAdjustItem( SVX_ADJUST_RIGHT, EE_PARA_JUST ) );
//STRIP001 
//STRIP001 	//	always using rtl writing direction would break formulas
//STRIP001 	//rSet.Put( SvxFrameDirectionItem( FRMDIR_HORI_RIGHT_TOP, EE_PARA_WRITINGDIR ) );
//STRIP001 
//STRIP001 	//	PaperSize width is limited to USHRT_MAX in RTL mode (because of EditEngine's
//STRIP001 	//	USHORT values in EditLine), so the text may be wrapped and line spacing must be
//STRIP001 	//	increased to not see the beginning of the next line.
//STRIP001 	SvxLineSpacingItem aItem( SVX_LINESPACE_TWO_LINES, EE_PARA_SBL );
//STRIP001 	aItem.SetPropLineSpace( 200 );
//STRIP001 	rSet.Put( aItem );
//STRIP001 }

//STRIP001 void lcl_ModifyRTLVisArea( EditView* pEditView )
//STRIP001 {
//STRIP001 	Rectangle aVisArea = pEditView->GetVisArea();
//STRIP001 	Size aPaper = pEditView->GetEditEngine()->GetPaperSize();
//STRIP001 	long nDiff = aPaper.Width() - aVisArea.Right();
//STRIP001 	aVisArea.Left()  += nDiff;
//STRIP001 	aVisArea.Right() += nDiff;
//STRIP001 	pEditView->SetVisArea(aVisArea);
//STRIP001 }

//STRIP001 void ScTextWnd::StartEditEngine()
//STRIP001 {
//STRIP001 	//	#31147# Bei "eigener Modalitaet" (Doc-modale Dialoge) nicht aktivieren
//STRIP001 	SfxObjectShell* pObjSh = SfxObjectShell::Current();
//STRIP001 	if ( pObjSh && pObjSh->IsInModalMode() )
//STRIP001 		return;
//STRIP001 
//STRIP001 	if ( !pEditView || !pEditEngine )
//STRIP001 	{
//STRIP001 		ScFieldEditEngine* pNew;
//STRIP001 		ScTabViewShell* pViewSh = ScTabViewShell::GetActiveViewShell();
//STRIP001 		if ( pViewSh )
//STRIP001 		{
//STRIP001 			const ScDocument* pDoc = pViewSh->GetViewData()->GetDocument();
//STRIP001 			pNew = new ScFieldEditEngine( pDoc->GetEnginePool(), pDoc->GetEditPool() );
//STRIP001 		}
//STRIP001 		else
//STRIP001 			pNew = new ScFieldEditEngine( EditEngine::CreatePool(),	NULL, TRUE );
//STRIP001 		pNew->SetExecuteURL( FALSE );
//STRIP001 		pEditEngine = pNew;
//STRIP001 
//STRIP001 		pEditEngine->SetUpdateMode( FALSE );
//STRIP001 		pEditEngine->SetPaperSize( Size( bIsRTL ? USHRT_MAX : THESIZE, 300 ) );
//STRIP001 		pEditEngine->SetWordDelimiters(
//STRIP001 						ScEditUtil::ModifyDelimiters( pEditEngine->GetWordDelimiters() ) );
//STRIP001 
//STRIP001 		UpdateAutoCorrFlag();
//STRIP001 
//STRIP001 		{
//STRIP001 			SfxItemSet* pSet = new SfxItemSet( pEditEngine->GetEmptyItemSet() );
//STRIP001 			pEditEngine->SetFontInfoInItemSet( *pSet, aTextFont );
//STRIP001 			lcl_ExtendEditFontAttribs( *pSet );
//STRIP001 			// turn off script spacing to match DrawText output
//STRIP001 			pSet->Put( SvxScriptSpaceItem( FALSE, EE_PARA_ASIANCJKSPACING ) );
//STRIP001 			if ( bIsRTL )
//STRIP001 				lcl_ModifyRTLDefaults( *pSet );
//STRIP001 			pEditEngine->SetDefaults( pSet );
//STRIP001 		}
//STRIP001 
//STRIP001 		//	#57254# Wenn in der Zelle URL-Felder enthalten sind, muessen die auch in
//STRIP001 		//	die Eingabezeile uebernommen werden, weil sonst die Positionen nicht stimmen.
//STRIP001 
//STRIP001 		BOOL bFilled = FALSE;
//STRIP001 		ScInputHandler* pHdl = SC_MOD()->GetInputHdl();
//STRIP001 		if ( pHdl )			//!	Testen, ob's der richtige InputHdl ist?
//STRIP001 			bFilled = pHdl->GetTextAndFields( *pEditEngine );
//STRIP001 
//STRIP001 		pEditEngine->SetUpdateMode( TRUE );
//STRIP001 
//STRIP001 		//	aString ist die Wahrheit...
//STRIP001 		if ( bFilled && pEditEngine->GetText() == aString )
//STRIP001 			Invalidate();						// Repaint fuer (hinterlegte) Felder
//STRIP001 		else
//STRIP001 			pEditEngine->SetText(aString);		// dann wenigstens den richtigen Text
//STRIP001 
//STRIP001 		pEditView = new EditView( pEditEngine, this );
//STRIP001 		pEditView->SetInsertMode(bIsInsertMode);
//STRIP001 
//STRIP001 		// Text aus Clipboard wird als ASCII einzeilig uebernommen
//STRIP001 		ULONG n = pEditView->GetControlWord();
//STRIP001 		pEditView->SetControlWord( n | EV_CNTRL_SINGLELINEPASTE	);
//STRIP001 
//STRIP001 		pEditEngine->InsertView( pEditView, EE_APPEND );
//STRIP001 
//STRIP001 		Resize();
//STRIP001 
//STRIP001 		if ( bIsRTL )
//STRIP001 			lcl_ModifyRTLVisArea( pEditView );
//STRIP001 
//STRIP001         pEditEngine->SetModifyHdl(LINK(this, ScTextWnd, NotifyHdl));
//STRIP001 
//STRIP001         if (pAccTextData)
//STRIP001             pAccTextData->StartEdit();
//STRIP001 
//STRIP001 		//	as long as EditEngine and DrawText sometimes differ for CTL text,
//STRIP001 		//	repaint now to have the EditEngine's version visible
//STRIP001 		SfxObjectShell* pObjSh = SfxObjectShell::Current();
//STRIP001 		if ( pObjSh && pObjSh->ISA(ScDocShell) )
//STRIP001 		{
//STRIP001 			ScDocument* pDoc = ((ScDocShell*)pObjSh)->GetDocument();	// any document
//STRIP001 			BYTE nScript = pDoc->GetStringScriptType( aString );
//STRIP001 			if ( nScript & SCRIPTTYPE_COMPLEX )
//STRIP001 				Invalidate();
//STRIP001 		}
//STRIP001     }
//STRIP001 
//STRIP001 	SC_MOD()->SetInputMode( SC_INPUT_TOP );
//STRIP001 
//STRIP001 	SfxViewFrame* pViewFrm = SfxViewFrame::Current();
//STRIP001 	if (pViewFrm)
//STRIP001 		pViewFrm->GetBindings().Invalidate( SID_ATTR_INSERT );
//STRIP001 }

//STRIP001 IMPL_LINK(ScTextWnd, NotifyHdl, EENotify*, aNotify)
//STRIP001 {
//STRIP001     if (pEditView && !bInputMode)
//STRIP001 	{
//STRIP001 		ScInputHandler* pHdl = SC_MOD()->GetInputHdl();
//STRIP001 
//STRIP001 		//	#105354# Use the InputHandler's InOwnChange flag to prevent calling InputChanged
//STRIP001 		//	while an InputHandler method is modifying the EditEngine content
//STRIP001 
//STRIP001 		if ( pHdl && !pHdl->IsInOwnChange() )
//STRIP001 			pHdl->InputChanged( pEditView );
//STRIP001 	}
//STRIP001 
//STRIP001     return 0;
//STRIP001 }
//STRIP001 
//STRIP001 void ScTextWnd::StopEditEngine( BOOL bAll )
//STRIP001 {
//STRIP001 	if (pEditView)
//STRIP001 	{
//STRIP001         if (pAccTextData)
//STRIP001             pAccTextData->EndEdit();
//STRIP001 
//STRIP001 		ScModule* pScMod = SC_MOD();
//STRIP001 
//STRIP001 		if (!bAll)
//STRIP001 			pScMod->InputSelection( pEditView );
//STRIP001 		aString = pEditEngine->GetText();
//STRIP001 		bIsInsertMode = pEditView->IsInsertMode();
//STRIP001 		BOOL bSelection = pEditView->HasSelection();
//STRIP001         pEditEngine->SetModifyHdl(Link());
//STRIP001 		DELETEZ(pEditView);
//STRIP001 		DELETEZ(pEditEngine);
//STRIP001 
//STRIP001 		if ( pScMod->IsEditMode() && !bAll )
//STRIP001 			pScMod->SetInputMode(SC_INPUT_TABLE);
//STRIP001 
//STRIP001 		SfxViewFrame* pViewFrm = SfxViewFrame::Current();
//STRIP001 		if (pViewFrm)
//STRIP001 			pViewFrm->GetBindings().Invalidate( SID_ATTR_INSERT );
//STRIP001 
//STRIP001 		if (bSelection)
//STRIP001 			Invalidate();			// damit Selektion nicht stehenbleibt
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 void ScTextWnd::SetTextString( const String& rNewString )
//STRIP001 {
//STRIP001 	if ( rNewString != aString )
//STRIP001 	{
//STRIP001         bInputMode = TRUE;
//STRIP001 
//STRIP001 		//	Position der Aenderung suchen, nur Rest painten
//STRIP001 
//STRIP001 		long nInvPos = 0;
//STRIP001 		long nStartPos = 0;
//STRIP001 		long nYPos = 0;
//STRIP001 		long nTextSize = 0;
//STRIP001 
//STRIP001 		if (!pEditEngine)
//STRIP001 		{
//STRIP001 			BOOL bPaintAll;
//STRIP001 			if ( bIsRTL )
//STRIP001 				bPaintAll = TRUE;
//STRIP001 			else
//STRIP001 			{
//STRIP001 				//	test if CTL script type is involved
//STRIP001 				BYTE nOldScript = 0;
//STRIP001 				BYTE nNewScript = 0;
//STRIP001 				SfxObjectShell* pObjSh = SfxObjectShell::Current();
//STRIP001 				if ( pObjSh && pObjSh->ISA(ScDocShell) )
//STRIP001 				{
//STRIP001 					//	any document can be used (used only for its break iterator)
//STRIP001 					ScDocument* pDoc = ((ScDocShell*)pObjSh)->GetDocument();
//STRIP001 					nOldScript = pDoc->GetStringScriptType( aString );
//STRIP001 					nNewScript = pDoc->GetStringScriptType( rNewString );
//STRIP001 				}
//STRIP001 				bPaintAll = ( nOldScript & SCRIPTTYPE_COMPLEX ) || ( nNewScript & SCRIPTTYPE_COMPLEX );
//STRIP001 			}
//STRIP001 
//STRIP001 			if ( bPaintAll )
//STRIP001 			{
//STRIP001 				// if CTL is involved, the whole text has to be redrawn
//STRIP001 				Invalidate();
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				xub_StrLen nDifPos;
//STRIP001 				if (rNewString.Len() > aString.Len())
//STRIP001 					nDifPos = rNewString.Match(aString);
//STRIP001 				else
//STRIP001 					nDifPos = aString.Match(rNewString);
//STRIP001 
//STRIP001 				long nSize1 = GetTextWidth(aString);
//STRIP001 				long nSize2 = GetTextWidth(rNewString);
//STRIP001 				if ( nSize1>0 && nSize2>0 )
//STRIP001 					nTextSize = Max( nSize1, nSize2 );
//STRIP001 				else
//STRIP001 					nTextSize = GetOutputSize().Width();		// Ueberlauf
//STRIP001 
//STRIP001 				if (nDifPos == STRING_MATCH)
//STRIP001 					nDifPos = 0;
//STRIP001 
//STRIP001 												// -1 wegen Rundung und "A"
//STRIP001 				Point aLogicStart = PixelToLogic(Point(TEXT_STARTPOS-1,0));
//STRIP001 				nStartPos = aLogicStart.X();
//STRIP001 				nInvPos = nStartPos;
//STRIP001 				if (nDifPos)
//STRIP001 					nInvPos += GetTextWidth(aString,0,nDifPos);
//STRIP001 
//STRIP001 				USHORT nFlags = 0;
//STRIP001 				if ( nDifPos == aString.Len() )			// only new characters appended
//STRIP001 					nFlags = INVALIDATE_NOERASE;		// then background is already clear
//STRIP001 
//STRIP001 				Invalidate( Rectangle( nInvPos, 0,
//STRIP001 										nStartPos+nTextSize, GetOutputSize().Height()-1 ),
//STRIP001 							nFlags );
//STRIP001 			}
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			pEditEngine->SetText(rNewString);
//STRIP001 		}
//STRIP001 
//STRIP001 		aString = rNewString;
//STRIP001 
//STRIP001         if (pAccTextData)
//STRIP001             pAccTextData->TextChanged();
//STRIP001 
//STRIP001         bInputMode = FALSE;
//STRIP001     }
//STRIP001 }
//STRIP001 
//STRIP001 const String& ScTextWnd::GetTextString() const
//STRIP001 {
//STRIP001 	return aString;
//STRIP001 }
//STRIP001 
//STRIP001 BOOL ScTextWnd::IsActive()
//STRIP001 {
//STRIP001 	return HasFocus();
//STRIP001 }
//STRIP001 
//STRIP001 EditView* ScTextWnd::GetEditView()
//STRIP001 {
//STRIP001 	return pEditView;
//STRIP001 }
//STRIP001 
//STRIP001 void ScTextWnd::MakeDialogEditView()
//STRIP001 {
//STRIP001 	if ( pEditView ) return;
//STRIP001 
//STRIP001 	ScFieldEditEngine* pNew;
//STRIP001 	ScTabViewShell* pViewSh = ScTabViewShell::GetActiveViewShell();
//STRIP001 	if ( pViewSh )
//STRIP001 	{
//STRIP001 		const ScDocument* pDoc = pViewSh->GetViewData()->GetDocument();
//STRIP001 		pNew = new ScFieldEditEngine( pDoc->GetEnginePool(), pDoc->GetEditPool() );
//STRIP001 	}
//STRIP001 	else
//STRIP001 		pNew = new ScFieldEditEngine( EditEngine::CreatePool(),	NULL, TRUE );
//STRIP001 	pNew->SetExecuteURL( FALSE );
//STRIP001 	pEditEngine = pNew;
//STRIP001 
//STRIP001 	pEditEngine->SetUpdateMode( FALSE );
//STRIP001 	pEditEngine->SetWordDelimiters( pEditEngine->GetWordDelimiters() += '=' );
//STRIP001 	pEditEngine->SetPaperSize( Size( bIsRTL ? USHRT_MAX : THESIZE, 300 ) );
//STRIP001 
//STRIP001 	SfxItemSet* pSet = new SfxItemSet( pEditEngine->GetEmptyItemSet() );
//STRIP001 	pEditEngine->SetFontInfoInItemSet( *pSet, aTextFont );
//STRIP001 	lcl_ExtendEditFontAttribs( *pSet );
//STRIP001 	if ( bIsRTL )
//STRIP001 		lcl_ModifyRTLDefaults( *pSet );
//STRIP001 	pEditEngine->SetDefaults( pSet );
//STRIP001 	pEditEngine->SetUpdateMode( TRUE );
//STRIP001 
//STRIP001 	pEditView	= new EditView( pEditEngine, this );
//STRIP001 	pEditEngine->InsertView( pEditView, EE_APPEND );
//STRIP001 
//STRIP001 	Resize();
//STRIP001 
//STRIP001 	if ( bIsRTL )
//STRIP001 		lcl_ModifyRTLVisArea( pEditView );
//STRIP001 
//STRIP001     if (pAccTextData)
//STRIP001         pAccTextData->StartEdit();
//STRIP001 }
//STRIP001 
//STRIP001 void ScTextWnd::ImplInitSettings()
//STRIP001 {
//STRIP001 	bIsRTL = GetSettings().GetLayoutRTL();
//STRIP001 
//STRIP001 	const StyleSettings& rStyleSettings = Application::GetSettings().GetStyleSettings();
//STRIP001 
//STRIP001 	Color aBgColor= rStyleSettings.GetWindowColor();
//STRIP001 	Color aTxtColor= rStyleSettings.GetWindowTextColor();
//STRIP001 
//STRIP001 	aTextFont.SetFillColor   ( aBgColor );
//STRIP001 	aTextFont.SetColor		 (aTxtColor);
//STRIP001 	SetBackground			( aBgColor );
//STRIP001 	Invalidate();
//STRIP001 }
//STRIP001 
//STRIP001 ::com::sun::star::uno::Reference< ::com::sun::star::accessibility::XAccessible > ScTextWnd::CreateAccessible()
//STRIP001 {
//STRIP001     return new ScAccessibleEditObject(GetAccessibleParentWindow()->GetAccessible(), NULL, this, 
//STRIP001         ::rtl::OUString(String(ScResId(STR_ACC_EDITLINE_NAME))),
//STRIP001         ::rtl::OUString(String(ScResId(STR_ACC_EDITLINE_DESCR))), EditLine);
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void ScTextWnd::DataChanged( const DataChangedEvent& rDCEvt )
//STRIP001 {
//STRIP001 	if ( (rDCEvt.GetType() == DATACHANGED_SETTINGS) &&
//STRIP001 		 (rDCEvt.GetFlags() & SETTINGS_STYLE) )
//STRIP001 	{
//STRIP001 		ImplInitSettings();
//STRIP001 		Invalidate();
//STRIP001 	}
//STRIP001 	else
//STRIP001 		Window::DataChanged( rDCEvt );
//STRIP001 }


//========================================================================
// 							Positionsfenster
//========================================================================

/*N*/ ScPosWnd::ScPosWnd( Window* pParent ) :
/*N*/ 	ComboBox	( pParent, WinBits(WB_HIDE | WB_DROPDOWN) ),
/*N*/ 	pAccel		( NULL ),
/*N*/ 	bFormulaMode( FALSE )
/*N*/ {
/*N*/ 	Size aSize( GetTextWidth( String::CreateFromAscii(RTL_CONSTASCII_STRINGPARAM("GW99999:GW99999")) ),
/*N*/ 				GetTextHeight() );
/*N*/ 	aSize.Width() += 25;	// ??
/*N*/ 	aSize.Height() = CalcWindowSizePixel(11);		// Funktionen: 10 MRU + "andere..."
/*N*/ 	SetSizePixel( aSize );
/*N*/ 
/*N*/ 	FillRangeNames();
/*N*/ 
/*N*/ 	StartListening( *SFX_APP() );		// fuer Navigator-Bereichsnamen-Updates
/*N*/ }

/*N*/ __EXPORT ScPosWnd::~ScPosWnd()
/*N*/ {
/*N*/ 	EndListening( *SFX_APP() );
/*N*/ 
/*N*/ 	delete pAccel;
/*N*/ }

//STRIP001 void ScPosWnd::SetFormulaMode( BOOL bSet )
//STRIP001 {
//STRIP001 	if ( bSet != bFormulaMode )
//STRIP001 	{
//STRIP001 		bFormulaMode = bSet;
//STRIP001 
//STRIP001 		if ( bSet )
//STRIP001 			FillFunctions();
//STRIP001 		else
//STRIP001 			FillRangeNames();
//STRIP001 	}
//STRIP001 }

//STRIP001 void ScPosWnd::SetPos( const String& rPosStr )
//STRIP001 {
//STRIP001 	if ( aPosStr != rPosStr )
//STRIP001 	{
//STRIP001 		aPosStr = rPosStr;
//STRIP001 		SetText(aPosStr);
//STRIP001 	}
//STRIP001 }

/*N*/ void ScPosWnd::FillRangeNames()
/*N*/ {
/*N*/ 	Clear();
/*N*/ 
/*N*/ 	SfxObjectShell* pObjSh = SfxObjectShell::Current();
/*N*/ 	if ( pObjSh && pObjSh->ISA(ScDocShell) )
/*N*/ 	{
/*?*/ 		ScDocument* pDoc = ((ScDocShell*)pObjSh)->GetDocument();
/*?*/ 
/*?*/ 		//	per Hand sortieren, weil Funktionen nicht sortiert werden:
/*?*/ 
/*?*/ 		ScRangeName* pRangeNames = pDoc->GetRangeName();
/*?*/ 		USHORT nCount = pRangeNames->GetCount();
/*?*/ 		if ( nCount > 0 )
/*?*/ 		{
/*?*/ 			USHORT nValidCount = 0;
/*?*/ 			ScRange aDummy;
/*?*/ 			USHORT i;
/*?*/ 			for ( i=0; i<nCount; i++ )
/*?*/ 			{
/*?*/ 				ScRangeData* pData = (*pRangeNames)[i];
/*?*/ 				if (pData->IsReference(aDummy))
/*?*/ 					nValidCount++;
/*?*/ 			}
/*?*/ 			if ( nValidCount )
/*?*/ 			{
/*?*/ 				ScRangeData** ppSortArray = new ScRangeData* [ nValidCount ];
/*?*/ 				USHORT j;
/*?*/ 				for ( i=0, j=0; i<nCount; i++ )
/*?*/ 				{
/*?*/ 					ScRangeData* pData = (*pRangeNames)[i];
/*?*/ 					if (pData->IsReference(aDummy))
/*?*/ 						ppSortArray[j++] = pData;
/*?*/ 				}
/*?*/ #ifndef ICC
/*?*/ 				qsort( (void*)ppSortArray, nValidCount, sizeof(ScRangeData*),
/*?*/ 					&ScRangeData::QsortNameCompare );
/*?*/ #else
/*?*/ 				qsort( (void*)ppSortArray, nValidCount, sizeof(ScRangeData*),
/*?*/ 					ICCQsortNameCompare );
/*?*/ #endif
/*?*/ 				for ( j=0; j<nValidCount; j++ )
/*?*/ 					InsertEntry( ppSortArray[j]->GetName() );
/*?*/ 				delete [] ppSortArray;
/*?*/ 			}
/*?*/ 		}
/*N*/ 	}
/*N*/ 	SetText(aPosStr);
/*N*/ }

//STRIP001 void ScPosWnd::FillFunctions()
//STRIP001 {
//STRIP001 	Clear();
//STRIP001 
//STRIP001 	String aFirstName;
//STRIP001 	const ScAppOptions& rOpt = SC_MOD()->GetAppOptions();
//STRIP001 	USHORT nMRUCount = rOpt.GetLRUFuncListCount();
//STRIP001 	const USHORT* pMRUList = rOpt.GetLRUFuncList();
//STRIP001 	if (pMRUList)
//STRIP001 	{
//STRIP001 		const ScFunctionList* pFuncList = ScGlobal::GetStarCalcFunctionList();
//STRIP001 		ULONG nListCount = pFuncList->GetCount();
//STRIP001 		ScFunctionMgr* pFuncMgr = ScGlobal::GetStarCalcFunctionMgr();
//STRIP001 		for (USHORT i=0; i<nMRUCount; i++)
//STRIP001 		{
//STRIP001 			USHORT nId = pMRUList[i];
//STRIP001 			for (ULONG j=0; j<nListCount; j++)
//STRIP001 			{
//STRIP001 				const ScFuncDesc* pDesc = pFuncList->GetFunction( j );
//STRIP001 				if ( pDesc->nFIndex == nId && pDesc->pFuncName )
//STRIP001 				{
//STRIP001 					InsertEntry( *pDesc->pFuncName );
//STRIP001 					if (!aFirstName.Len())
//STRIP001 						aFirstName = *pDesc->pFuncName;
//STRIP001 					break;	// nicht weitersuchen
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	//!	Eintrag "Andere..." fuer Funktions-Autopilot wieder aufnehmen,
//STRIP001 	//!	wenn der Funktions-Autopilot mit dem bisher eingegebenen Text arbeiten kann!
//STRIP001 
//STRIP001 //	InsertEntry( ScGlobal::GetRscString(STR_FUNCTIONLIST_MORE) );
//STRIP001 
//STRIP001 	SetText(aFirstName);
//STRIP001 }

/*N*/ void __EXPORT ScPosWnd::SFX_NOTIFY( SfxBroadcaster& rBC, const TypeId& rBCType,
/*N*/ 									  const SfxHint& rHint, const TypeId& rHintType )
/*N*/ {
/*N*/ 	if ( !bFormulaMode )
/*N*/ 	{
/*N*/ 		//	muss die Liste der Bereichsnamen updgedated werden?
/*N*/ 
/*N*/ 		if ( rHint.ISA(SfxSimpleHint) )
/*N*/ 		{
/*N*/ 			ULONG nHintId = ((SfxSimpleHint&)rHint).GetId();
/*N*/ 			if ( nHintId == SC_HINT_AREAS_CHANGED || nHintId == SC_HINT_NAVIGATOR_UPDATEALL)
/*N*/ 				FillRangeNames();
/*N*/ 		}
/*N*/ 		else if ( rHint.ISA(SfxEventHint) )
/*N*/ 		{
/*N*/ 			ULONG nEventId = ((SfxEventHint&)rHint).GetEventId();
/*N*/ 			if ( nEventId == SFX_EVENT_ACTIVATEDOC )
/*?*/ 				FillRangeNames();
/*N*/ 		}
/*N*/ 	}
/*N*/ }

//STRIP001 void __EXPORT ScPosWnd::Select()
//STRIP001 {
//STRIP001 	::com::boBox::Select();		//	in VCL gibt GetText() erst danach den ausgewaehlten Eintrag
//STRIP001 
//STRIP001 	if (!IsTravelSelect())
//STRIP001 		DoEnter();
//STRIP001 }

//STRIP001 void ScPosWnd::DoEnter()
//STRIP001 {
//STRIP001 	String aText = GetText();
//STRIP001 	if ( aText.Len() )
//STRIP001 	{
//STRIP001 		if ( bFormulaMode )
//STRIP001 		{
//STRIP001 			ScModule* pScMod = SC_MOD();
//STRIP001 			if ( aText == ScGlobal::GetRscString(STR_FUNCTIONLIST_MORE) )
//STRIP001 			{
//STRIP001 				//	Funktions-Autopilot
//STRIP001 				//!	mit dem bisher eingegebenen Text weiterarbeiten !!!
//STRIP001 
//STRIP001 				//!	new method at ScModule to query if function autopilot is open
//STRIP001 				SfxViewFrame* pViewFrm = SfxViewFrame::Current();
//STRIP001 				if ( pViewFrm && !pViewFrm->GetChildWindow( SID_OPENDLG_FUNCTION ) )
//STRIP001 					pViewFrm->GetDispatcher()->Execute( SID_OPENDLG_FUNCTION,
//STRIP001 											  SFX_CALLMODE_SYNCHRON | SFX_CALLMODE_RECORD );
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				ScTabViewShell* pViewSh = PTR_CAST( ScTabViewShell, SfxViewShell::Current() );
//STRIP001 				ScInputHandler* pHdl = pScMod->GetInputHdl( pViewSh );
//STRIP001 				if (pHdl)
//STRIP001 					pHdl->InsertFunction( aText );
//STRIP001 			}
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			//	Position (Zelle oder Namen) setzen
//STRIP001 			SfxStringItem aPosItem( SID_CURRENTCELL, aText );
//STRIP001 			SfxBoolItem aUnmarkItem( FN_PARAM_1, TRUE );		// Selektion aufheben
//STRIP001 			SfxViewFrame* pViewFrm = SfxViewFrame::Current();
//STRIP001 			if ( pViewFrm )
//STRIP001 				pViewFrm->GetDispatcher()->Execute( SID_CURRENTCELL,
//STRIP001 									  SFX_CALLMODE_SYNCHRON | SFX_CALLMODE_RECORD,
//STRIP001 									  &aPosItem, &aUnmarkItem, 0L );
//STRIP001 
//STRIP001 			//!	Fehler erkennen und meckern
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else
//STRIP001 		SetText( aPosStr );
//STRIP001 
//STRIP001 	ReleaseFocus_Impl();
//STRIP001 }

//STRIP001 long __EXPORT ScPosWnd::Notify( NotifyEvent& rNEvt )
//STRIP001 {
//STRIP001 	long nHandled = 0;
//STRIP001 
//STRIP001 	if ( rNEvt.GetType() == EVENT_KEYINPUT )
//STRIP001 	{
//STRIP001 		const KeyEvent* pKEvt = rNEvt.GetKeyEvent();
//STRIP001 
//STRIP001 		switch ( pKEvt->GetKeyCode().GetCode() )
//STRIP001 		{
//STRIP001 			case KEY_RETURN:
//STRIP001 				DoEnter();
//STRIP001 				nHandled = 1;
//STRIP001 				break;
//STRIP001 
//STRIP001 			case KEY_ESCAPE:
//STRIP001 				if (!bFormulaMode)
//STRIP001 					SetText( aPosStr );
//STRIP001 				ReleaseFocus_Impl();
//STRIP001 				nHandled = 1;
//STRIP001 				break;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( !nHandled )
//STRIP001 		nHandled = ComboBox::Notify( rNEvt );
//STRIP001 
//STRIP001 	return nHandled;
//STRIP001 }

//STRIP001 void ScPosWnd::ReleaseFocus_Impl()
//STRIP001 {
//STRIP001 	SfxViewShell* pCurSh = SfxViewShell::Current();
//STRIP001 	ScInputHandler* pHdl = SC_MOD()->GetInputHdl( PTR_CAST( ScTabViewShell, pCurSh ) );
//STRIP001 	if ( pHdl && pHdl->IsTopMode() )
//STRIP001 	{
//STRIP001 		//	Focus wieder in die Eingabezeile?
//STRIP001 
//STRIP001 		ScInputWindow* pInputWin = pHdl->GetInputWindow();
//STRIP001 		if (pInputWin)
//STRIP001 		{
//STRIP001 			pInputWin->TextGrabFocus();
//STRIP001 			return;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	//	Focus auf die aktive View
//STRIP001 
//STRIP001 	if ( pCurSh )
//STRIP001 	{
//STRIP001 		Window* pShellWnd = pCurSh->GetWindow();
//STRIP001 
//STRIP001 		if ( pShellWnd )
//STRIP001 			pShellWnd->GrabFocus();
//STRIP001 	}
//STRIP001 }






}
