/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: otlnbuff.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 17:50:43 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _OTLNBUFF_HXX
#define _OTLNBUFF_HXX

#ifndef _SOLAR_H
#include <tools/solar.h>
#endif
namespace binfilter {

class ScOutlineArray;

class OutlineBuffer
{
	// -> exctools.cxx
	private:
		BYTE*			pLevel;
		BOOL*			pOuted;
		BOOL*			pHidden;
		USHORT			nSize;
		USHORT			nLast;
		BYTE			nMaxLevel;
		ScOutlineArray*	pOutlineArray;
		BOOL			bButtonNormal;	// TRUE -> right / under
	public:
						OutlineBuffer( USHORT nNewSize );
						~OutlineBuffer();
		void			SetLevel( USHORT nIndex, BYTE nVal, BOOL bOuted, BOOL bHidden );
		void			SetOuted( USHORT nIndex );
		void			SetOuted( USHORT nIndex, BOOL bOuted );
		void			SetOutlineArray( ScOutlineArray* pOArray );
		void			Reset( void );
		void			Reset( ScOutlineArray* pOArray );
		void			MakeScOutline( void );
		void			SetLevelRange( USHORT nF, USHORT nL, BYTE nVal,
							BOOL bOuted, BOOL bHidden );

		inline BOOL		HasOutline( void ) const;

		inline void		SetButtonMode( const BOOL bRightOrUnder );
};




inline BOOL OutlineBuffer::HasOutline( void ) const
{
	return nMaxLevel > 0;
}


inline void OutlineBuffer::SetButtonMode( const BOOL b )
{
	bButtonNormal = b;
}


} //namespace binfilter
#endif

